/*-------------------------------------------------------------------
Fichier     : upswin_nt.e
Objet       : En-tete de Up ! Windows

Module      : Up ! Windows
Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.
---------------------------------------------------------------------
                        Observations
                   
---------------------------------------------------------------------*/ 

/********************************/
#if !defined(PasseModuleUpsWinNat)
/********************************/
#define PasseModuleUpsWinNat 1

/**********************/
#if defined(__cplusplus)
/**********************/
extern "C"
{
/****/
#endif
/****/

enum EnuUpsWinDeplacementBarre
   {
   DB_Debut=1,
   DB_Fin=2,
   DB_LigneEnAvant=3,
   DB_LigneEnArriere=4,
   DB_PageEnAvant=5,
   DB_PageEnArriere=6,
   DB_Position=7
   };

enum EnuUpsWinToucheSpeciale
   {
   TS_Haut=1,
   TS_Bas=2,
   TS_Gauche=3,
   TS_Droite=4,
   TS_PageHaut=5,
   TS_PageBas=6,
   TS_DebutDocument=7,
   TS_FinDocument=8
   };

enum EnuUpsWinMessageBouton
   {
   MB_Ok=1,
   MB_OkAnnuler=2,
   MB_OuiNon=3
   };

/****************************************************************/
typedef struct typupswincouleur
/* Objet : Pour modeliser une couleur.                          */
/****************************************************************/
{
TypUpsVmShort Rouge;
TypUpsVmShort Vert;
TypUpsVmShort Bleu;
} TypUpsWinCouleur;

/****************************************************************/
typedef struct typupswinrectangle
/* Objet : Pour modeliser un rectangle.                         */
/****************************************************************/
{
TypUpsVmLong X;
TypUpsVmLong Y;
TypUpsVmLong Largeur;
TypUpsVmLong Hauteur;
} TypUpsWinRectangle;

typedef TypUpsVmShort UpsVmAPI (*TypUpsWinCreer)(TypUpsVmPointeurDonnees HandleFenetre);
   /* Creation de la fenetre. */
typedef TypUpsVmShort UpsVmAPI (*TypUpsWinDeplacer)(TypUpsVmPointeurDonnees HandleFenetre);
   /* Deplacement de la fenetre. */
typedef TypUpsVmShort UpsVmAPI (*TypUpsWinRedimensionner)(TypUpsVmPointeurDonnees HandleFenetre);
   /* Redimensionnement de la fenetre. */
typedef TypUpsVmShort UpsVmAPI (*TypUpsWinFermer)(TypUpsVmPointeurDonnees HandleFenetre);
   /* Fermeture de la fenetre. */
typedef TypUpsVmShort UpsVmAPI (*TypUpsWinDetruire)(TypUpsVmPointeurDonnees HandleFenetre);
   /* Destruction de la fenetre. */
typedef TypUpsVmShort UpsVmAPI (*TypUpsWinPeindre)(TypUpsVmPointeurDonnees HandleFenetre, TypUpsVmPointeurDonnees HandleGraphique, TypUpsWinRectangle *RectangleAPeindre);
   /* Peinture de la fenetre. */
typedef TypUpsVmShort UpsVmAPI (*TypUpsWinExecuterCommande)(TypUpsVmPointeurDonnees HandleFenetre, TypUpsVmLong Commande);
   /* Execution d'une commande. */
typedef TypUpsVmShort UpsVmAPI (*TypUpsWinExecuterClicGauche)(TypUpsVmPointeurDonnees HandleFenetre);
   /* Reponse a un clic gauche. */
typedef TypUpsVmShort UpsVmAPI (*TypUpsWinExecuterClicDroit)(TypUpsVmPointeurDonnees HandleFenetre);
   /* Reponse a un clic droit. */
typedef TypUpsVmShort UpsVmAPI (*TypUpsWinExecuterDoubleClicGauche)(TypUpsVmPointeurDonnees HandleFenetre);
   /* Reponse a un double clic gauche. */
typedef TypUpsVmShort UpsVmAPI (*TypUpsWinExecuterDoubleClicDroit)(TypUpsVmPointeurDonnees HandleFenetre);
   /* Reponse a un double clic droit. */
typedef TypUpsVmShort UpsVmAPI (*TypUpsWinExecuterClavier)(TypUpsVmPointeurDonnees HandleFenetre, TypUpsVmUnicode Caractere);
   /* Reponse a l'appui sur une touche. */
typedef TypUpsVmShort UpsVmAPI (*TypUpsWinDeplacerBarre)(TypUpsVmPointeurDonnees HandleFenetre, TypUpsVmShort EstLaBarreVerticale, 
   enum EnuUpsWinDeplacementBarre Deplacement, TypUpsVmLong Position);
   /* Deplacement de la barre de scrolling. */

/****************************************************************/
typedef struct typupswinmethodesfenetre
/* Objet : Methodes pour les fenetres.                          */
/****************************************************************/
{
TypUpsWinCreer Creer;
   /* Creation de la fenetre. */
TypUpsWinDeplacer Deplacer;
   /* Deplacement de la fenetre. */
TypUpsWinRedimensionner Redimensionner;
   /* Redimensionnement de la fenetre. */
TypUpsWinFermer Fermer;
   /* Fermeture de la fenetre. */
TypUpsWinDetruire Detruire;
   /* Destruction de la fenetre. */
TypUpsWinPeindre Peindre;
   /* Peinture de la fenetre. */
TypUpsWinExecuterCommande ExecuterCommande;
   /* Execute une commande. */
TypUpsWinExecuterClicGauche ExecuterClicGauche;
   /* Reponse a un clic gauche. */
TypUpsWinExecuterClicDroit ExecuterClicDroit;
   /* Reponse a un clic droit. */
TypUpsWinExecuterDoubleClicGauche ExecuterDoubleClicGauche;
   /* Reponse a un double clic gauche. */
TypUpsWinExecuterDoubleClicDroit ExecuterDoubleClicDroit;
   /* Reponse a un double clic droit. */
TypUpsWinDeplacerBarre DeplacerBarre;
   /* Deplacement de la barre de scrolling. */
TypUpsWinExecuterClavier ExecuterClavier;
   /* Reponse a l'appui sur une touche. */
} *TypUpsWinMethodesFenetre;

/****************************************************************/
typedef struct typupswinnattraitements_1_1_0
/* Objet: Interface des traitements de Ups Win Nat.             */
/****************************************************************/
{
/******************************/
#if defined(PLATEFORMEMACINTOSH)
/******************************/
/****/
#endif
/****/
/**************************/
#if defined(PLATEFORMEOS390)
/**************************/
/****/
#endif
/****/
/**************************/
#if defined(PLATEFORMEOS400)
/**************************/
/****/
#endif
/****/
/*************************/
#if defined(PLATEFORMEUNIX)
/*************************/
/****/
#endif
/****/
/****************************/
#if defined(PLATEFORMEWINDOWS)
/****************************/
TypUpsVmPointeurDonnees UpsVmAPI (*CreateFont)(TypUpsVmUnicode *NomPolice, TypUpsVmShort Taille, 
   TypUpsVmShort Gras, TypUpsVmShort Italique, TypUpsVmShort Souligne, TypUpsVmShort Barre);
   /* Objet : CreateFont(). */
TypUpsVmShort UpsVmAPI (*CreateService)(TypUpsVmUnicode *NomProgramme, TypUpsVmUnicode *Commande, TypUpsVmUnicode *Commentaire);
   /* Objet : CreateService(). */
TypUpsVmPointeurDonnees UpsVmAPI (*CreateWindowEx)(TypUpsVmUnicode *TitreFenetre, TypUpsVmShort EstDemon, TypUpsVmShort BarresDeScrolling,
   TypUpsWinMethodesFenetre TableMethodesFenetre);
   /* Objet : Creation d'une fenetre. */
TypUpsVmShort UpsVmAPI (*DeleteObject)(TypUpsVmPointeurDonnees HandleObjetGraphique);
   /* Objet : DeleteObject. */
TypUpsVmShort UpsVmAPI (*DeleteService)(TypUpsVmUnicode *NomProgramme);
   /* Objet : DeleteService(). */
TypUpsVmShort UpsVmAPI (*DestroyWindow)(TypUpsVmPointeurDonnees Handle);
   /* Objet : DestroyWindow(). */
TypUpsVmShort UpsVmAPI (*DoEvents)(TypUpsVmShort Bloquer);
   /* Objet : DoEvents(). */
TypUpsVmShort UpsVmAPI (*EndDoc)(TypUpsVmPointeurDonnees HandleGraphique);
   /* Objet : EndDoc(). */
TypUpsVmShort UpsVmAPI (*EndPage)(TypUpsVmPointeurDonnees HandleGraphique);
   /* Objet : EndPage(). */
TypUpsVmPointeurDonnees UpsVmAPI (*GetActiveWindow)(TypUpsVmVoid);
   /* Objet : GetActiveWindow(). */
TypUpsVmShort UpsVmAPI (*GetClientRect)(TypUpsVmPointeurDonnees Handle, TypUpsWinRectangle *Rectangle);
   /* Objet : GetClientRect(). */
TypUpsVmLong UpsVmAPI (*GetScrollPos)(TypUpsVmPointeurDonnees Handle, TypUpsVmShort EstLaBarreVerticale);
   /* Objet : GetScrollPos(). */
TypUpsVmShort UpsVmAPI (*GetScrollRange)(TypUpsVmPointeurDonnees Handle, TypUpsVmShort EstLaBarreVerticale, 
   TypUpsVmLong *PositionMin, TypUpsVmLong *PositionMax);
   /* Objet : GetScrollRange(). */
TypUpsVmShort UpsVmAPI (*InvalidateRect)(TypUpsVmPointeurDonnees Handle);
   /* Objet : InvalidateRect(). */
TypUpsVmShort UpsVmAPI (*MessageBox)(TypUpsVmPointeurDonnees HandleFenetre, TypUpsVmUnicode *Message, TypUpsVmUnicode *Titre, enum EnuUpsWinMessageBouton Boutons);
   /* Objet : MessageBox(). */
TypUpsVmShort UpsVmAPI (*MoveWindow)(TypUpsVmPointeurDonnees HandleFenetre, TypUpsVmLong X, TypUpsVmLong Y, TypUpsVmLong Largeur,
   TypUpsVmLong Hauteur, TypUpsVmShort Repeindre);
   /* Objet : MoveWindow(). */
TypUpsVmShort UpsVmAPI (*QuestionBox)(TypUpsVmPointeurDonnees HandleFenetre, TypUpsVmPointeurDonnees HandleRessources, TypUpsVmUnicode *LigneALire, 
   TypUpsVmLong TailleLigneALire);
   /* Objet : Lecture d'un octet au clavier. */
TypUpsVmShort UpsVmAPI (*Rectangle)(TypUpsVmPointeurDonnees Handle, TypUpsWinRectangle *Rectangle);
   /* Objet : Rectangle(). */
TypUpsVmShort UpsVmAPI (*RegisterClass)(TypUpsVmPointeurDonnees HandleRessources, TypUpsVmDouble *RatioH2, TypUpsVmDouble *RatioV2);
   /* Objet : RegisterClass(). */
TypUpsVmPointeurDonnees UpsVmAPI (*SelectObject)(TypUpsVmPointeurDonnees HandleGraphique, TypUpsVmPointeurDonnees HandleObjetGraphique);
   /* Objet : SelectObject(). */
TypUpsVmShort UpsVmAPI (*SetBkColor)(TypUpsVmPointeurDonnees HandleGraphique, TypUpsWinCouleur *CouleurFond);
   /* Objet : SetBkColor(). */
TypUpsVmShort UpsVmAPI (*SetBkMode)(TypUpsVmPointeurDonnees HandleGraphique, TypUpsVmShort EstOpaque);
   /* Objet : SetBkMode(). */
TypUpsVmShort UpsVmAPI (*SetScrollPos)(TypUpsVmPointeurDonnees Handle, TypUpsVmShort EstLaBarreVerticale, TypUpsVmLong Position, 
   TypUpsVmShort Repeindre);
   /* Objet : SetScrollPos(). */
TypUpsVmShort UpsVmAPI (*SetScrollRange)(TypUpsVmPointeurDonnees Handle, TypUpsVmShort EstLaBarreVerticale, TypUpsVmLong PositionMix, 
   TypUpsVmLong PositionMax, TypUpsVmShort Repeindre);
   /* Objet : SetScrollRange(). */
TypUpsVmShort UpsVmAPI (*SetTextColor)(TypUpsVmPointeurDonnees HandleGraphique, TypUpsWinCouleur *CouleurPinceau);
   /* Objet : SetTextColor(). */
TypUpsVmShort UpsVmAPI (*ShellNotifyIcon)(TypUpsVmPointeurDonnees Handle);
   /* Objet : Shell_NotifyIcon(). */
TypUpsVmPointeurDonnees UpsVmAPI (*StartDoc)(TypUpsVmUnicode *NomFichierSpool, TypUpsVmLong *LargeurPage, TypUpsVmLong *HauteurPage);
   /* Objet : StartDoc(). */
TypUpsVmShort UpsVmAPI (*StartPage)(TypUpsVmPointeurDonnees HandleGraphique);
   /* Objet : StartPage(). */
TypUpsVmShort UpsVmAPI (*StartServiceDispatcher)(TypUpsVmUnicode *NomProgramme, TypUpsVmPrincipal FonctionPrincipale);
   /* Objet : StartServiceDispatcher. */
TypUpsVmShort UpsVmAPI (*TextOut)(TypUpsVmPointeurDonnees HandleGraphique, TypUpsVmLong X, TypUpsVmLong Y, TypUpsVmUnicode *Chaine);
   /* Objet : TextOut. */
TypUpsVmShort UpsVmAPI (*UpdateWindow)(TypUpsVmPointeurDonnees Handle);
   /* Objet : UpdateWindow(). */
TypUpsVmShort UpsVmAPI (*UnregisterClass)(TypUpsVmVoid);
   /* Objet : UnregisterClass(). */
/****/
#endif
/****/
} *TypUpsWinNatTraitements_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsWinNatTraitements_1_1_0 TypUpsWinNatTraitements;

extern DllExport TypUpsWinNatTraitements UpsVmAPI UpsWinNatDemarrerModule(TypUpsVtmMachineInterface MachineInterfaceUpsVtm);
   /* Objet : Retourne la description de Ups Win Nat. */

/**********************/
#if defined(__cplusplus)
/**********************/
}
/****/
#endif
/****/

/****/
#endif
/****/
