/*-------------------------------------------------------------------
Fichier     : upswin.e
Objet       : En-tete du module Up ! Windows.

Module      : Up ! Windows
Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.
---------------------------------------------------------------------
                         Observations

 
---------------------------------------------------------------------*/

/**************************/
#if !defined(PasseModuleWin)
/**************************/
#define PasseModuleWin 1

#include <upswin_nt.e>

/**********************/
#if defined(__cplusplus)
/**********************/
extern "C"
{
/****/
#endif
/****/

/*******************************************************************/
typedef struct typupswinmachineinterface_1_1_0
/* Objet : Interface avec la machine pour Up ! Windows.            */ 
/*******************************************************************/
{
TypUpsVmShort UpsVmAPI (*DeplacerFenetre)(TypUpsVmPointeurDonnees Handle, TypUpsVmLong X, TypUpsVmLong Y, TypUpsVmLong Largeur,
   TypUpsVmLong Hauteur);
   /* Objet : Deplace la fenetre. */
TypUpsVmShort UpsVmAPI (*RepeindreFenetre)(TypUpsVmPointeurDonnees Handle, TypUpsVmShort PeindreBarresDeDeplacement, TypUpsVmShort Synchroniser);
   /* Objet : Repeint la fenetre. */
TypUpsVmShort UpsVmAPI (*FixerEchelleBarreDeScrolling)(TypUpsVmPointeurDonnees Handle, TypUpsVmShort EstLaBarreVerticale, 
   TypUpsVmLong PositionMin, TypUpsVmLong PositionMax);
   /* Objet : Fixe l'echelle de la barre de scrolling. */
TypUpsVmShort UpsVmAPI (*FixerPositionBarreDeScrolling)(TypUpsVmPointeurDonnees Handle, TypUpsVmShort EstLaBarreVerticale, 
   TypUpsVmLong Position);
   /* Objet : Fixe la position de la barre de scrolling. */
TypUpsVmShort UpsVmAPI (*LireEchelleBarreDeScrolling)(TypUpsVmPointeurDonnees Handle, TypUpsVmShort EstLaBarreVerticale, 
   TypUpsVmLong *PositionMin, TypUpsVmLong *PositionMax);
   /* Objet : Lit l'echelle de la barre de scrolling. */
TypUpsVmLong UpsVmAPI (*LirePositionBarreDeScrolling)(TypUpsVmPointeurDonnees Handle, TypUpsVmShort EstLaBarreVerticale);
   /* Objet : Lit la position de la barre de scrolling. */
TypUpsVmPointeurDonnees UpsVmAPI (*LireHandleFenetreActive)(TypUpsVmVoid);
   /* Objet : Lit le handle de la fenetre active. */
TypUpsVmShort UpsVmAPI (*EcrireMessage)(TypUpsVmPointeurDonnees HandleFenetre, TypUpsVmUnicode *Message, TypUpsVmUnicode *Titre, 
   enum EnuUpsWinMessageBouton Boutons);
   /* Objet : Ecrit le message. */
TypUpsVmShort UpsVmAPI (*LireMessage)(TypUpsVmPointeurDonnees HandleFenetre, TypUpsVmPointeurDonnees HandleRessources, 
   TypUpsVmUnicode *Message, TypUpsVmLong TailleMessage);
   /* Objet : Lit un message. */
TypUpsVmShort UpsVmAPI (*LireTailleClient)(TypUpsVmPointeurDonnees HandleFenetre, TypUpsWinRectangle *Rectangle);
   /* Objet : Lit la taille de la zone cliente de la fenetre. */
TypUpsVmShort UpsVmAPI (*DetruireFenetre)(TypUpsVmPointeurDonnees HandleFenetre);
   /* Objet : Detruit la fenetre. */
TypUpsVmPointeurDonnees UpsVmAPI (*CreerPolice)(TypUpsVmUnicode *NomPolice, TypUpsVmShort Taille, 
   TypUpsVmShort Gras, TypUpsVmShort Italique, TypUpsVmShort Souligne, TypUpsVmShort Barre);
   /* Objet : Cree une police. */
TypUpsVmPointeurDonnees UpsVmAPI (*SelectionnerPolice)(TypUpsVmPointeurDonnees HandleGraphique, TypUpsVmPointeurDonnees HandlePolice, 
   TypUpsWinCouleur *CouleurPinceau, TypUpsWinCouleur *CouleurFond);
   /* Objet : Selectionne une police. */
TypUpsVmShort UpsVmAPI (*DetruirePolice)(TypUpsVmPointeurDonnees HandlePolice);
   /* Objet : Detruire une police. */
TypUpsVmShort UpsVmAPI (*Rectangle)(TypUpsVmPointeurDonnees Handle, TypUpsWinRectangle *Rectangle);
   /* Objet : Dessine un rectangle. */
TypUpsVmShort UpsVmAPI (*EcrireTexte)(TypUpsVmPointeurDonnees HandleGraphique, TypUpsVmLong X, TypUpsVmLong Y, TypUpsVmUnicode *Chaine);
   /* Objet : Ecrit un texte. */
TypUpsVmShort UpsVmAPI (*AttenteActive)(TypUpsVmShort Bloquer);
   /* Objet : Entre dans la boucle d'attente active. */
TypUpsVmPointeurDonnees UpsVmAPI (*DebuterImpression)(TypUpsVmUnicode *NomFichierSpool, TypUpsVmLong *LargeurPage, TypUpsVmLong *HauteurPage);
   /* Objet : Debute l'impression. */
TypUpsVmShort UpsVmAPI (*SauterPage)(TypUpsVmPointeurDonnees HandleGraphique);
   /* Objet : Saute une page. */
TypUpsVmShort UpsVmAPI (*TerminerImpression)(TypUpsVmPointeurDonnees HandleGraphique);
   /* Objet : Termine l'impression. */
TypUpsVmShort UpsVmAPI (*DevenirDemon)(TypUpsVmUnicode *NomProgramme, TypUpsVmPrincipal Principal);
   /* Objet : Transforme le programme en un demon. */
TypUpsVmShort UpsVmAPI (*ArreterDemon)(TypUpsVmPointeurDonnees Handle);
   /* Objet : Transforme le programme en un demon. */
TypUpsVmShort UpsVmAPI (*ReferencerService)(TypUpsVmSession *Session, TypUpsVmUnicode *NomProgramme, TypUpsVmUnicode *Commentaire);
   /* Objet : Reference un service Ups ! Server. */
TypUpsVmShort UpsVmAPI (*DereferencerService)(TypUpsVmSession *Session, TypUpsVmUnicode *NomProgramme);
   /* Objet : Dereference un service Ups ! Server. */
TypUpsVmPointeurDonnees UpsVmAPI (*CreerFenetre)(TypUpsVmUnicode *TitreFenetre, TypUpsVmShort EstDemon, TypUpsVmShort BarresDeScrolling,
   TypUpsWinMethodesFenetre TableMethodesFenetre);
   /* Objet : Creation d'une feenetre. */
} *TypUpsWinMachineInterface_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsWinMachineInterface_1_1_0 TypUpsWinMachineInterface;

/****************************************************************/
typedef struct typupswindonnees
/* Objet: Interface des donnees de Ups Win.                     */
/****************************************************************/
{
struct typupsvmentetedonneesmodule EnteteDonneesModule;
   /* Entete generique du module. */
TypUpsVmDouble RatioH;
   /* Ratio de la resolution logique horizontale par rapport a la resolution physique. */
TypUpsVmDouble RatioV;
   /* Ratio de la resolution logique verticale par rapport a la resolution physique. */
} *TypUpsWinDonnees;

/****************************************************************/
typedef struct typupswintraitements_1_1_0
/* Objet: Interface des traitements de Ups Win.                 */
/****************************************************************/
{
struct typupsvmentetemethodesmodule EnteteMethodesModule;
   /* Methodes generiques au module. */ 
/*--------------------------------------------------------------*/
/* Procedures et fonctions.                                     */
/*--------------------------------------------------------------*/
TypUpsVmLong UpsVmAPI (*CalculerIndexAppel)(TypUpsVmPointeurDonnees InterfaceAppel, TypUpsVmPointeurDonnees AppelCourant);
   /* Objet : Calcule l'index de l'appel. */

/*--------------------------------------------------------------*/
/* Tables des methodes.                                         */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Enumeres.			              				                   */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Entrepots.          								                   */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Types et interfaces.                                         */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Variables globales.                                          */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Exceptions.                                                  */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Files d'attente.                                             */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Application Program Interfaces proprietaires.                */
/*--------------------------------------------------------------*/
TypUpsVmLong UpsVmAPI (*PrincipalTacheConsole)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *ObjetTache, TypUpsVmPointeurDonnees Parametres);
   /* Objet : Fonction pricipale de la tache gerant la console. */
TypUpsVmShort UpsVmAPI (*Principal)(TypUpsVmPrincipal FonctionPrincipale);
  /* Objet : Execute en mode fenetree la fonction principale. */
} *TypUpsWinTraitements_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsWinTraitements_1_1_0 TypUpsWinTraitements;

extern DllExport TypUpsVtmDemarrer UpsVmAPI UpsWinDemarrerModule(TypUpsVmShort Numero, TypUpsVtmMachineInterface MachineInterfaceUpsVtm,
   TypUpsVtmTraitements IntTrtUpsVtm, TypUpsVtmDonnees IntDonUpsVtm);
   /* Objet : Retourne la description de Ups Win. */

/**********************/
#if defined(__cplusplus)
/**********************/
}
/****/
#endif
/****/

/****/
#endif
/****/
