/*-------------------------------------------------------------------
Fichier     : upssys_nt.e
Objet       : En-tete de Up ! System

Module      : Up ! System
Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.
---------------------------------------------------------------------
                        Observations
                   
---------------------------------------------------------------------*/ 

/********************************/
#if !defined(PasseModuleUpsSysNat)
/********************************/
#define PasseModuleUpsSysNat 1

/**********************/
#if defined(__cplusplus)
/**********************/
extern "C"
{
/****/
#endif
/****/

/****************************************************************/
/* Codification du deplacement des sortes d'unites.       		 */
/****************************************************************/
enum EnuUpsSysSorteUnite
   {
   SU_DisqueDur=1,
      /* Disque dur. */
   SU_DisqueAmovible=2,
      /* Disquette ou assimilee. */
   SU_DisqueReseau=3,
      /* Disque partage par le reseau. */
   SU_DisqueCdRom=4,
      /* Cd-Rom ou assimilie. */
   SU_DisqueVirtuel=5
      /* Disque virtuel. */
   };

/****************************************************************/
enum EnuUpsSysSorteDonneeC
/* Objet : Sorte de la donnees C.                               */
/****************************************************************/
   {
   SDC_Adresse=1,
      /* void *. */
   SDC_Char=2,
      /* char. */ 
   SDC_Double=3,
      /* double. */ 
   SDC_Float=4,
      /* float. */ 
   SDC_Long=5,
      /* long. */ 
   SDC_LongDouble=6,
      /* long double. */ 
   SDC_LongLong=7,
      /* long. */ 
   SDC_Short=8,
      /* short. */ 
   SDC_UnsignedChar=9,
      /* unsigned char. */ 
   SDC_UnsignedShort=10,
      /* unsigned short. */ 
   SDC_UnsignedLong=11,
      /* unsigned long. */ 
   SDC_UnsignedLongLong=12
      /* unsigned long. */ 
   };

/****************************************************************/
typedef struct typupssysvaleurc
/* Objet : Valeur generique.                                    */
/****************************************************************/
{
enum EnuUpsSysSorteDonneeC SorteDonneeC;
   /* Sorte de la donnee C. */
union
   {
   TypUpsVmPointeurDonnees Adresse;
      /* void *. */
   TypUpsVmChar Char;
      /* char. */ 
   TypUpsVmDouble Double;
      /* double. */ 
   TypUpsVmFloat Float;
      /* float. */ 
   TypUpsVmLong Long;
      /* long. */ 
   TypUpsVmLongDouble LongDouble;
      /* long double. */ 
   TypUpsVmLongLong LongLong;
      /* long long. */ 
   TypUpsVmShort Short;
      /* short. */ 
   TypUpsVmUnsignedChar UnsignedChar;
      /* unsigned char. */ 
   TypUpsVmUnsignedShort UnsignedShort;
      /* unsigned short. */ 
   TypUpsVmUnsignedLong UnsignedLong;
      /* unsigned long. */ 
   TypUpsVmUnsignedLongLong UnsignedLongLong;
      /* unsigned long long. */ 
   } Selection;
   /* Selection en fonction de la sorte. */
} TypUpsSysValeurC;

/****************************************************************/
enum EnuUpsSysSorteAppelC
/* Objet : Sorte de l'appel C.                                  */
/****************************************************************/
   {
   SDC_CDecl=1,
      /* __cdecl. */
   SDC_CDeclPascal=2,
      /* __cdecl __pascal. */
   SDC_StdCall=3,
      /* __stdcall. */
   SDC_StdCallPascal=4
      /* __stdcall __pascal. */
   };

/****************************************************************/
typedef struct typupssysnattraitements_1_1_0
/* Objet: Interface des traitements de Ups Sys Nat.             */
/****************************************************************/
{
/*************************/
#if defined(PLATEFORMEUNIX)
/*************************/
TypUpsVmShort UpsVmAPI (*Access)(TypUpsVmChar *NomFichier);
   /* Objet : access(). */
TypUpsVmShort UpsVmAPI (*ChDir)(TypUpsVmChar *NomRepertoire);
   /* Objet : chdir(). */
TypUpsVmShort UpsVmAPI (*Chmod)(TypUpsVmChar *NomFichier, TypUpsVmShort Masque);
   /* Objet : chmod(). */
TypUpsVmShort UpsVmAPI (*Close)(TypUpsVmPointeurDonnees Handle);
   /* Objet : close(). */
TypUpsVmVoid UpsVmAPI (*CloseDir)(TypUpsVmPointeurDonnees Handle);
   /* Objet : closedir(). */
TypUpsVmShort UpsVmAPI (*CUserId)(TypUpsVmChar *NomUtilisateur, TypUpsVmLong TailleNomUtilisateur);
   /* Objet : cuserid(). */
TypUpsVmVoid UpsVmAPI (*DoEvents)(TypUpsVmVoid);
   /* Objet : DoEvents() de Windows. */
TypUpsVmPointeurDonnees UpsVmAPI (*Dup)(TypUpsVmPointeurDonnees Handle);
   /* Objet : dup(). */
TypUpsVmShort UpsVmAPI (*Errno)(TypUpsVmLong *CodeErreur, TypUpsVmChar *LibelleErreur, TypUpsVmLong Taille);
   /* Objet : errno(). */
TypUpsVmShort (*Execvp)(TypUpsVmChar *Commande, TypUpsVmChar **Parametres);
   /* Objet : execvp(). */
TypUpsVmShort UpsVmAPI (*FCntl)(TypUpsVmPointeurDonnees Handle, TypUpsVmShort LaisserOuvert, TypUpsVmShort Synchroniser);
   /* Objet : fcntl(). */
TypUpsVmLong UpsVmAPI (*Fork)(TypUpsVmVoid);
   /* Objet : fork(). */
TypUpsVmShort UpsVmAPI (*FSync)(TypUpsVmPointeurDonnees Handle);
   /* Objet : fsync(). */
TypUpsVmChar UpsVmAPI *(*GetCwd)(TypUpsVmChar *NomRepertoire, TypUpsVmLong TailleRepertoire);
   /* Objet : getcwd(). */
TypUpsVmChar UpsVmAPI *(*GetEnv)(TypUpsVmChar *NomVariable, TypUpsVmChar *Valeur, TypUpsVmLong TailleValeur);
   /* Objet : getenv(). */
TypUpsVmLong UpsVmAPI (*GetGId)(TypUpsVmVoid);
   /* Objet : getgid(). */
TypUpsVmShort UpsVmAPI (*GetGrGid)(TypUpsVmChar *NomGroupe, TypUpsVmLong TailleGroupName);
   /* Objet : getgrgid(). */
TypUpsVmLong UpsVmAPI (*GetPid)(TypUpsVmVoid);
   /* Objet : getpid(). */
TypUpsVmPointeurDonnees UpsVmAPI (*GetStdHandle)(TypUpsVmChar *NomFlux);
   /* Objet : GetStdHandle() de Windows. */
TypUpsVmLong UpsVmAPI (*GetUId)(TypUpsVmVoid);
   /* Objet : getuid(). */
TypUpsVmShort UpsVmAPI (*Kill)(TypUpsVmLong NumeroProcessus, enum EnuUpsVmSignal NumeroSignal);
   /* Objet : kill(). */
TypUpsVmShort UpsVmAPI (*Link)(TypUpsVmChar *NomInitial, TypUpsVmChar *NomRaccourci);
   /* Objet : link(). */
TypUpsVmVoid UpsVmAPI (*LocalTime)(TypUpsVmLong DateEnSecondes, TypUpsVmDateEtHeure *DateEtHeure);
   /* Objet : localtime(). */
TypUpsVmVoid UpsVmAPI (*LongJmp)(TypUpsVmRegistres Registres, TypUpsVmShort CodeRetour);
   /* Objet : longjmp(). */
TypUpsVmLong UpsVmAPI (*LSeek)(TypUpsVmPointeurDonnees Handle, enum EnuUpsVmDeplacement Reference, TypUpsVmLong Position);
   /* Objet : lseek(). */
TypUpsVmShort UpsVmAPI (*Mount)(TypUpsVmChar *NomDuVolume, TypUpsVmChar *PointDeMontage);
   /* Objet : mount(). */
TypUpsVmShort UpsVmAPI (*MkDir)(TypUpsVmChar *NomRepertoire);
   /* Objet : mkdir(). */
TypUpsVmShort UpsVmAPI (*Nice)(TypUpsVmShort Priorite);
   /* Objet : nice(). */
TypUpsVmPointeurDonnees UpsVmAPI (*Open)(TypUpsVmChar *NomFichier, TypUpsVmChar *Masque, enum EnuUpsVmTailleBuffer TailleBuffer);
   /* Objet : open(). */
TypUpsVmPointeurDonnees UpsVmAPI (*OpenDir)(TypUpsVmChar *NomRepertoire);
   /* Objet : opendir(). */
TypUpsVmShort UpsVmAPI (*Pipe)(TypUpsVmPointeurDonnees *HandleLecture, TypUpsVmPointeurDonnees *HandleEcriture);
   /* Objet : pipe(). */
TypUpsVmShort UpsVmAPI (*PThreadCondDestroy)(TypUpsVmPointeurDonnees *Handle);
   /* Objet : pthread_cond_destroy(). */
TypUpsVmShort UpsVmAPI (*PThreadCondInit)(TypUpsVmPointeurDonnees *Handle);
   /* Objet : pthread_cond_init(). */
TypUpsVmShort UpsVmAPI (*PThreadCondSignal)(TypUpsVmPointeurDonnees HandleCondition, TypUpsVmPointeurDonnees HandleMutex);
   /* Objet : pthread_cond_signal(). */
TypUpsVmShort UpsVmAPI (*PThreadCondWait)(TypUpsVmPointeurDonnees HandleCondition, TypUpsVmPointeurDonnees HandleMutex);
   /* Objet : pthread_cond_wait(). */
TypUpsVmPointeurDonnees UpsVmAPI (*PThreadCreate)(TypUpsVmPrincipalThread PrincipalThread, TypUpsVmPointeurDonnees Parametres);
   /* Objet : pthread_create(). */
TypUpsVmShort UpsVmAPI (*PThreadMutexDestroy)(TypUpsVmPointeurDonnees *Handle);
   /* Objet : pthread_mutex_destroy(). */
TypUpsVmShort UpsVmAPI (*PThreadMutexInit)(TypUpsVmPointeurDonnees *Handle);
   /* Objet : pthread_mutex_init(). */
TypUpsVmShort UpsVmAPI (*PThreadMutexLock)(TypUpsVmPointeurDonnees Handle);
   /* Objet : pthread_mutex_lock(). */
TypUpsVmShort UpsVmAPI (*PThreadKill)(TypUpsVmPointeurDonnees Handle, enum EnuUpsVmSignal Signal);
   /* Objet : pthread_kill(). */
TypUpsVmPointeurDonnees UpsVmAPI (*PThreadSelf)(TypUpsVmVoid);
   /* Objet : pthread_self(). */
TypUpsVmShort UpsVmAPI (*PThreadMutexUnlock)(TypUpsVmPointeurDonnees Handle);
   /* Objet : pthread_mutex_unlock(). */
TypUpsVmShort UpsVmAPI (*PutEnv)(TypUpsVmChar *NomEtValeur);
   /* Objet : putenv(). */
TypUpsVmShort UpsVmAPI (*Read)(TypUpsVmPointeurDonnees Handle, TypUpsVmChar *Buffer, TypUpsVmLong TailleALire, TypUpsVmLong *TailleLue);
   /* Objet : read(). */
TypUpsVmShort UpsVmAPI (*ReadDir)(TypUpsVmPointeurDonnees Handle, TypUpsVmChar *NomFichier, TypUpsVmLong TailleNomFichier);
   /* Objet : readdir. */
TypUpsVmShort UpsVmAPI (*Rename)(TypUpsVmChar *AncienNom, TypUpsVmChar *NouveauNom);
   /* Objet : rename(). */
TypUpsVmShort UpsVmAPI (*RmDir)(TypUpsVmChar *NomRepertoire);
   /* Objet : rmdir(). */
TypUpsVmShort UpsVmAPI (*SemCtl)(TypUpsVmPointeurDonnees Handle, TypUpsVmShort Numero);
   /* Objet : semctl(). */
TypUpsVmPointeurDonnees UpsVmAPI (*SemGet)(TypUpsVmLong Cle, TypUpsVmShort Creer, TypUpsVmShort Creer);
   /* Objet : semop(). */
TypUpsVmShort UpsVmAPI (*SemOp)(TypUpsVmPointeurDonnees Handle, TypUpsVmShort Numero, TypUpsVmShort Operation);
   /* Objet : semop(). */
TypUpsVmVoid UpsVmAPI (*Sleep)(TypUpsVmLong Secondes);
   /* Objet : sleep(). */
TypUpsVmShort UpsVmAPI (*Stat)(TypUpsVmChar *NomFichier, TypUpsVmDateEtHeure *DateCreation, TypUpsVmDateEtHeure *DateDerniereModification, 
   TypUpsVmDateEtHeure *DateDernierAcces, TypUpsVmShort *EstUnRepertoire, TypUpsVmUnsignedLong *Taille);
   /* Objet : stat(). */ 
TypUpsVmShort UpsVmAPI (*StatFs)(TypUpsVmChar *Entrepot, TypUpsVmLong *NbBlocsAuTotal, TypUpsVmLong *NbBlocsLibres, 
   TypUpsVmLong *TailleBloc, TypUpsVmLong *Type);
   /* Objet : statfs(). */
TypUpsVmVoid UpsVmAPI (*SwitchToThread)(TypUpsVmVoid);
   /* Objet : SwitchToThread(). */
TypUpsVmVoid UpsVmAPI (*Sync)(TypUpsVmVoid);
   /* Objet : sync(). */
TypUpsVmLong UpsVmAPI (*Time)(TypUpsVmVoid);
   /* Objet : time(). */
TypUpsVmShort UpsVmAPI (*Times)(TypUpsVmDouble *TempsSysteme, TypUpsVmDouble *TempsUser);
   /* Objet : times(). */
TypUpsVmShort UpsVmAPI (*UAdmin)(enum EnuUpsVmArretSysteme Mode);
   /* Objet : uadmin(). */
TypUpsVmShort UpsVmAPI (*Umount)(TypUpsVmChar *NomDuVolume);
   /* Objet : umount(). */
TypUpsVmShort UpsVmAPI (*Uname)(TypUpsVmChar *NomDuSysteme, TypUpsVmLong TailleNomDuSysteme, TypUpsVmChar *NomDuNoeud, 
   TypUpsVmLong TailleNomDuNoeud, TypUpsVmChar *Release, TypUpsVmLong TailleRelease, TypUpsVmChar *Version, 
   TypUpsVmLong TailleVersion, TypUpsVmChar *PlateForme, TypUpsVmLong TaillePlateForme);
   /* Objet : Recupere les informations sur la machine. */
TypUpsVmShort UpsVmAPI (*Unlink)(TypUpsVmChar *NomFichier);
   /* Objet : unlink(). */
TypUpsVmLong UpsVmAPI (*WaitPid)(TypUpsVmLong PId, TypUpsVmLong *CodeRetour);
   /* Objet : waitpid(). */
TypUpsVmShort UpsVmAPI (*Write)(TypUpsVmPointeurDonnees Handle, TypUpsVmChar *Buffer, 
   TypUpsVmLong TailleAEcrire, TypUpsVmLong *TailleEcrite);
   /* Objet : write(). */
/****/
#endif
/****/
/****************************/
#if defined(PLATEFORMEWINDOWS)
/****************************/
TypUpsVmShort UpsVmAPI (*AllocConsole)(TypUpsVmVoid);
   /* Objet : AllocConsole(). */
TypUpsVmShort UpsVmAPI (*CloseHandle)(TypUpsVmPointeurDonnees Handle);
   /* Objet : CloseHandle(). */
TypUpsVmShort UpsVmAPI (*CloseServiceHandle)(TypUpsVmPointeurDonnees Handle);
   /* Objet : CloseServiceHandle(). */
TypUpsVmShort UpsVmAPI (*ControlService)(TypUpsVmPointeurDonnees Handle);
   /* Objet : ControlService(). */
TypUpsVmShort UpsVmAPI (*CreateDirectory)(TypUpsVmChar *NomRepertoire);
   /* Objet : CreateDirectory(). */
TypUpsVmPointeurDonnees UpsVmAPI (*CreateEvent)(TypUpsVmVoid);
   /* Objet : CreateEvent(). */
TypUpsVmPointeurDonnees UpsVmAPI (*CreateFile)(TypUpsVmUnicode *NomFichier, TypUpsVmChar *Masque, enum EnuUpsVmTailleBuffer TailleBuffer);
   /* Objet : CreateFile(). */
TypUpsVmPointeurDonnees UpsVmAPI (*CreateMutex)(TypUpsVmUnicode *NomMutex);
   /* Objet : CreateMutex(). */
TypUpsVmShort UpsVmAPI (*CreatePipe)(TypUpsVmPointeurDonnees *HandleLecture, TypUpsVmPointeurDonnees *HandleEcriture);
   /* Objet : CreatePipe(). */
TypUpsVmShort UpsVmAPI (*CreateProcess)(TypUpsVmUnicode *Commande, TypUpsVmUnicode *Parametres, TypUpsVmShort Prioritaire,
   TypUpsVmUnicode *RepertoireInitial, TypUpsVmShort Cache, TypUpsVmPointeurDonnees HandleLecture, TypUpsVmPointeurDonnees HandleEcriture, 
   TypUpsVmPointeurDonnees HandleEcriture2, TypUpsVmPointeurDonnees *HandleProcessus, TypUpsVmLong *NumeroProcessus);
   /* Objet : CreateProcess(). */
TypUpsVmPointeurDonnees UpsVmAPI (*CreateSemaphore)(TypUpsVmUnicode *NomSemaphore);
   /* Objet : CreateSemaphore(). */
TypUpsVmShort UpsVmAPI (*CreateShortCut)(TypUpsVmUnicode *NomInitial, TypUpsVmUnicode *NomRaccourci);
   /* Objet : CreateShortCut(). */
TypUpsVmPointeurDonnees UpsVmAPI (*CreateStdHandle)(TypUpsVmUnicode *NomFichier, TypUpsVmShort Lecture, TypUpsVmShort ALaSuite);
   /* Objet : CreateStdHandle(). */
TypUpsVmPointeurDonnees UpsVmAPI (*CreateThread)(TypUpsVmPrincipalThread PrincipalThread, TypUpsVmPointeurDonnees Parametres, TypUpsVmLong *NumeroThread,
   TypUpsVmShort Lancer);
   /* Objet : CreateThread(). */
TypUpsVmPointeurDonnees UpsVmAPI (*CreateToolhelp32Snapshot)(TypUpsVmShort PourUnModule, TypUpsVmLong NumeroProcessus);
   /* Objet : CreateToolhelp32Snapshot(). */
TypUpsVmVoid UpsVmAPI (*DeleteCriticalSection)(TypUpsVmPointeurDonnees SectionCritique);
   /* Objet : DeleteCriticalSection(). */
TypUpsVmShort UpsVmAPI (*DeleteFile)(TypUpsVmUnicode *NomFichier);
   /* Objet : DeleteFile(). */
TypUpsVmShort UpsVmAPI (*DeviceIoControl)(TypUpsVmChar *NomVolume, TypUpsVmShort Monter);
   /* Objet : DeviceIoControl. */
TypUpsVmVoid UpsVmAPI (*DoEvents)(TypUpsVmVoid);
   /* Objet : DoEvents(). */
TypUpsVmVoid UpsVmAPI (*EnterCriticalSection)(TypUpsVmPointeurDonnees SectionCritique);
   /* Objet : EnterCriticalSection(). */
TypUpsVmShort UpsVmAPI (*ExitWindowsEx)(enum EnuUpsVmArretSysteme Mode);
   /* Objet : ExitWindowsEx(). */
TypUpsVmVoid UpsVmAPI (*FillConsoleOutputCharacter)(TypUpsVmUnicode Caractere, TypUpsVmLong NbCaracteres);
   /* Objet : FillConsoleOutputCharacter(). */
TypUpsVmVoid UpsVmAPI (*FindClose)(TypUpsVmPointeurDonnees Handle);
   /* Objet : FindClose(). */
TypUpsVmPointeurDonnees UpsVmAPI (*FindFirstFile)(TypUpsVmUnicode *NomRepertoire, 
   TypUpsVmUnicode *NomFichier, TypUpsVmLong TailleNomFichier, TypUpsVmShort *EstUnRepertoire);
   /* Objet : FindFirstFile(). */
TypUpsVmShort UpsVmAPI (*FindNextFile)(TypUpsVmPointeurDonnees Handle, 
   TypUpsVmUnicode *NomFichier, TypUpsVmLong TailleNomFichier, TypUpsVmShort *EstUnRepertoire);
   /* Objet : FindNextFile. */
TypUpsVmShort UpsVmAPI (*FlushFileBuffers)(TypUpsVmPointeurDonnees Handle);
   /* Objet : FlushFileBuffers(). */
TypUpsVmShort UpsVmAPI (*GetConsoleWindow)(TypUpsVmVoid);
   /* Objet : GetConsoleWindow(). */
TypUpsVmUnicode UpsVmAPI *(*GetCurrentDirectory)(TypUpsVmUnicode *NomRepertoire, TypUpsVmLong TailleRepertoire);
   /* Objet : GetCurrentDirectory(). */
TypUpsVmLong UpsVmAPI (*GetCurrentProcessId)(TypUpsVmVoid);
   /* Objet : GetCurrentProcessId(). */
TypUpsVmPointeurDonnees UpsVmAPI (*GetCurrentThread)(TypUpsVmVoid);
   /* Objet : GetCurrentThread(). */
TypUpsVmLong UpsVmAPI (*GetCurrentThreadId)(TypUpsVmVoid);
   /* Objet : GetCurrentThreadId(). */
TypUpsVmLong UpsVmAPI (*GetDriveType)(TypUpsVmUnicode *Racine);
   /* Objet : GetDriveType(). */
TypUpsVmShort UpsVmAPI (*GetDiskFreeSpace)(TypUpsVmUnicode *Racine, TypUpsVmLong *NbSecteursParCluster, 
   TypUpsVmLong *NbOctetsParSecteur, TypUpsVmLong *NombreDeClustersLibres, TypUpsVmLong *NombreTotalDeClusters);
   /* Objet : GetDiskFreeSpace(). */
TypUpsVmUnicode UpsVmAPI *(*GetEnvironmentVariable)(TypUpsVmUnicode *NomVariable, TypUpsVmUnicode *Valeur, TypUpsVmLong TailleValeur);
   /* Objet : GetEnvironementVariable(). */
TypUpsVmShort UpsVmAPI (*GetExitCodeProcess)(TypUpsVmPointeurDonnees Handle, TypUpsVmLong *CodeRetour, TypUpsVmShort *EstActif);
   /* Objet : GetExitCodeProcess(). */
TypUpsVmShort UpsVmAPI (*GetExitCodeThread)(TypUpsVmPointeurDonnees Handle, TypUpsVmLong *CodeRetour);
   /* Objet : GetExitCodeThread(). */
TypUpsVmLong UpsVmAPI (*GetFileAttributes)(TypUpsVmUnicode *Chemin, TypUpsVmShort *Cache, TypUpsVmShort *Repertoire, TypUpsVmShort *LectureSeule);
   /* Objet : GetFileAttributes(). */
TypUpsVmShort UpsVmAPI (*GetFileInformationByHandle)(TypUpsVmUnicode *NomFichier, TypUpsVmDateEtHeure *DateCreation, 
   TypUpsVmDateEtHeure *DateDerniereModification, TypUpsVmDateEtHeure *DateDernierAcces, TypUpsVmShort *EstUnRepertoire, 
   TypUpsVmUnsignedLong *Taille);
   /* Objet : GetFileInformationByHandle(). */ 
TypUpsVmShort UpsVmAPI (*GetLastError)(TypUpsVmLong *CodeErreur, TypUpsVmUnicode *LibelleErreur, TypUpsVmLong Taille);
   /* Objet : GetLastError(). */
TypUpsVmVoid UpsVmAPI (*GetLocalTime)(TypUpsVmDateEtHeure *DateEtHeure);
   /* Objet : GetLocalTime(). */
TypUpsVmShort UpsVmAPI (*GetModuleFileName)(TypUpsVmPointeurDonnees Handle, TypUpsVmUnicode *NomFichier, TypUpsVmLong TailleNomFichier);
   /* Objet : GetModuleFileName(). */
TypUpsVmShort UpsVmAPI (*GetPriorityClass)(TypUpsVmVoid);
   /* Objet : GetPriorityClass(). */
TypUpsVmShort UpsVmAPI (*GetProcessTimes)(TypUpsVmLong NumeroProcessus, TypUpsVmDateEtHeure *CreationTime,
   TypUpsVmDateEtHeure *ExitTime, TypUpsVmDateEtHeure *KernelTime, TypUpsVmDateEtHeure *UserTime);
   /* Objet : GetProcessTimes(). */
TypUpsVmPointeurDonnees UpsVmAPI (*GetStdHandle)(TypUpsVmChar *NomFlux);
   /* Objet : GetStdHandle(). */
TypUpsVmShort UpsVmAPI (*GetSystemInfo)(TypUpsVmUnicode *NomDuSysteme, TypUpsVmLong TailleNomDuSysteme, TypUpsVmUnicode *NomDuNoeud, 
   TypUpsVmLong TailleNomDuNoeud, TypUpsVmLong *Version, TypUpsVmLong *Revision, TypUpsVmUnicode *PlateForme, TypUpsVmLong TaillePlateForme);
   /* Objet : Recupere les informations sur le systeme d'exploitation. */
TypUpsVmShort UpsVmAPI (*GetThreadPriority)(TypUpsVmVoid);
   /* Objet : GetThreadPriority(). */
TypUpsVmShort UpsVmAPI (*GetUserName)(TypUpsVmUnicode *NomUtilisateur, TypUpsVmLong TailleNomUtilisateur);
   /* Objet : GetUserName(). */
TypUpsVmUnicode UpsVmAPI *(*GetWindowsDirectory)(TypUpsVmUnicode *NomRepertoire, TypUpsVmLong TailleNomRepertoire);
   /* Objet : GetWindowsDirectory(). */
TypUpsVmPointeurDonnees  UpsVmAPI (*InitializeCriticalSection)(TypUpsVmVoid);
   /* Objet : InitializeCriticalSection(). */
TypUpsVmVoid UpsVmAPI (*LeaveCriticalSection)(TypUpsVmPointeurDonnees SectionCritique);
   /* Objet : LeaveCriticalSection(). */
TypUpsVmVoid UpsVmAPI (*LongJmp)(TypUpsVmRegistres Registres, TypUpsVmShort CodeRetour);
   /* Objet : LongJmp(). */
TypUpsVmShort UpsVmAPI (*LookupAccountName)(TypUpsVmUnicode *NomGroupe, TypUpsVmLong TailleNomGroupe);
   /* Objet : LookupAccountName(). */
TypUpsVmShort UpsVmAPI (*Module32First)(TypUpsVmPointeurDonnees Handle, 
   TypUpsVmUnicode *NomModuleTrouve, TypUpsVmLong TailleNomModuleTrouve, 
   TypUpsVmUnicode *NomProgrammeTrouve, TypUpsVmLong TailleNomProgrammeTrouve);
   /* Objet : Module32First(). */
TypUpsVmShort UpsVmAPI (*Module32Next)(TypUpsVmPointeurDonnees Handle, 
   TypUpsVmUnicode *NomModuleTrouve, TypUpsVmLong TailleNomModuleTrouve, 
   TypUpsVmUnicode *NomProgrammeTrouve, TypUpsVmLong TailleNomProgrammeTrouve);
   /* Objet : Module32Next(). */
TypUpsVmShort UpsVmAPI (*MoveFile)(TypUpsVmUnicode *AncienNom, TypUpsVmUnicode *NouveauNom);
   /* Objet : MoveFile(). */
TypUpsVmShort UpsVmAPI (*OpenFile)(TypUpsVmUnicode *NomFichier);
   /* Objet : OpenFile(). */
TypUpsVmPointeurDonnees UpsVmAPI (*OpenMutex)(TypUpsVmUnicode *NomMutex);
   /* Objet : OpenMutex(). */
TypUpsVmPointeurDonnees UpsVmAPI (*OpenSCManager)(TypUpsVmVoid);
   /* Objet : OpenSCManager(). */
TypUpsVmPointeurDonnees UpsVmAPI (*OpenSemaphore)(TypUpsVmUnicode *NomSemaphore);
   /* Objet : OpenSemaphore(). */
TypUpsVmPointeurDonnees UpsVmAPI (*OpenService)(TypUpsVmPointeurDonnees Handle, TypUpsVmUnicode *NomService, enum EnuUpsVmActionService Action);
   /* Objet : OpenService(). */
TypUpsVmVoid UpsVmAPI (*OutputDebugString)(TypUpsVmUnicode *Message);
   /* Objet : OutputDebugString(). */
TypUpsVmShort UpsVmAPI (*PeekNamedPipe)(TypUpsVmPointeurDonnees Handle, TypUpsVmChar *Buffer, TypUpsVmLong TailleALire,
   TypUpsVmLong *TailleLue);
   /* Objet : PeekNamedPipe(). */
TypUpsVmShort UpsVmAPI (*Process32First)(TypUpsVmPointeurDonnees *TableProcessus2, TypUpsVmShort *IndexProcessus, TypUpsVmShort *IndexProcessusMax);
   /* Objet : Process32First(). */
TypUpsVmLong UpsVmAPI (*Process32Info)(TypUpsVmPointeurDonnees TableProcessus2, TypUpsVmShort *IndexProcessus, TypUpsVmShort IndexProcessusMax, TypUpsVmLong *Priorite, 
   TypUpsVmChar *NomProgramme, TypUpsVmLong TailleNomProgramme);
   /* Objet : Process32Info(). */
TypUpsVmShort UpsVmAPI (*Process32Next)(TypUpsVmPointeurDonnees TableProcessus2, TypUpsVmShort *IndexProcessus, TypUpsVmShort IndexProcessusMax);
   /* Objet : Process32Next(). */
TypUpsVmShort UpsVmAPI (*QueryServiceStatus)(TypUpsVmPointeurDonnees Handle);
   /* Objet : QueryServiceStatus(). */
TypUpsVmShort UpsVmAPI (*ReadFile)(TypUpsVmPointeurDonnees Handle, TypUpsVmChar *Buffer, 
   TypUpsVmLong TailleALire, TypUpsVmLong *TailleLue);
   /* Objet : ReadFile(). */
TypUpsVmShort UpsVmAPI (*ReleaseMutex)(TypUpsVmPointeurDonnees Handle);
   /* Objet : ReleaseMutex(). */
TypUpsVmShort UpsVmAPI (*ReleaseSemaphore)(TypUpsVmPointeurDonnees Handle);
   /* Objet : ReleaseSemaphore(). */
TypUpsVmShort UpsVmAPI (*RegDeleteKey)(TypUpsVmUnicode *Prefixe, TypUpsVmUnicode *CheminCle);
   /* Objet : RegDeleteKey(). */
TypUpsVmShort UpsVmAPI (*RegQueryValueEx)(TypUpsVmUnicode *Prefixe, TypUpsVmUnicode *CheminCle, TypUpsVmUnicode *NomCle, 
   TypUpsVmUnicode *Valeur, TypUpsVmLong TailleValeur);
   /* Objet : RegQueryValueEx(). */
TypUpsVmShort UpsVmAPI (*RegSetValueEx)(TypUpsVmUnicode *Prefixe, TypUpsVmUnicode *CheminCle, TypUpsVmUnicode *NomCle, 
   TypUpsVmUnicode *Valeur);
   /* Objet : RegSetValueEx(). */
TypUpsVmShort UpsVmAPI (*RemoveDirectory)(TypUpsVmUnicode *NomRepertoire);
   /* Objet : RemoveDirectory(). */
TypUpsVmShort UpsVmAPI (*ReportEvent)(TypUpsVmUnicode *Message);
   /* Objet : ReportEvent(). */
TypUpsVmShort UpsVmAPI (*SetCurrentDirectory)(TypUpsVmUnicode *NomRepertoire);
   /* Objet : SetCurrentDirectory(). */
TypUpsVmShort UpsVmAPI (*SetEnvironmentVariable)(TypUpsVmUnicode *NomVariable, TypUpsVmUnicode *Valeur);
   /* Objet : SetEnvironmentVariable(). */
TypUpsVmShort UpsVmAPI (*SetEvent)(TypUpsVmPointeurDonnees Handle);
   /* Objet : SetEvent(). */
TypUpsVmShort UpsVmAPI (*SetFileAttributes)(TypUpsVmUnicode *NomFichier, TypUpsVmShort LectureSeule);
   /* Objet : SetFileAttributes(). */
TypUpsVmLong UpsVmAPI (*SetFilePointer)(TypUpsVmPointeurDonnees Handle, enum EnuUpsVmDeplacement Reference, 
   TypUpsVmLong Position);
   /* Objet : SetFilePointer(). */
TypUpsVmShort UpsVmAPI (*SetPriorityClass)(TypUpsVmShort Priorite);
   /* Objet : SetPriorityClass(). */
TypUpsVmShort UpsVmAPI (*SetThreadPriority)(TypUpsVmShort PrioriteRelative);
   /* Objet : SetThreadPriority(). */
TypUpsVmVoid UpsVmAPI (*Signal)(TypUpsVtmGestionnaireSignal GestionnaireSignal, TypUpsVmPointeurDonnees HandleInstanceCode);
   /* Objet : signal(). */
TypUpsVmVoid UpsVmAPI (*Sleep)(TypUpsVmLong Milliemes);
   /* Objet : Sleep(). */
TypUpsVmShort UpsVmAPI (*StartService)(TypUpsVmPointeurDonnees Handle, TypUpsVmShort NbParametres, TypUpsVmUnicode **Parametres);
   /* Objet : StartService(). */
TypUpsVmVoid UpsVmAPI (*SwitchToThread)(TypUpsVmVoid);
   /* Objet : SwitchToThread(). */
TypUpsVmShort UpsVmAPI (*TerminateProcess)(TypUpsVmPointeurDonnees Handle, TypUpsVmShort CodeRetour);
   /* Objet : TerminateProcess(). */
TypUpsVmShort UpsVmAPI (*TerminateThread)(TypUpsVmPointeurDonnees Handle, TypUpsVmShort CodeRetour);
   /* Objet : TerminateThread(). */
TypUpsVmShort UpsVmAPI (*Thread32First)(TypUpsVmPointeurDonnees Handle, TypUpsVmLong *Priorite, TypUpsVmLong *NumeroProcessus);
   /* Objet : Thread32First(). */
TypUpsVmShort UpsVmAPI (*Thread32Next)(TypUpsVmPointeurDonnees Handle, TypUpsVmLong *Priorite, TypUpsVmLong *NumeroProcessus);
   /* Objet : Thread32Next(). */
TypUpsVmLong UpsVmAPI (*Time)(TypUpsVmVoid);
   /* Objet : Time(). */
TypUpsVmShort UpsVmAPI (*WaitForSingleObject)(TypUpsVmPointeurDonnees Handle, TypUpsVmLong GardeEnMilliemes);
   /* Objet : WaitForSingleObject(). */
TypUpsVmShort UpsVmAPI (*WriteFile)(TypUpsVmPointeurDonnees Handle, TypUpsVmChar *Buffer, 
   TypUpsVmLong TailleAEcrire, TypUpsVmLong *TailleEcrite);
   /* Objet : WriteFile(). */
/****/
#endif
/****/
TypUpsVmShort UpsVmAPI (*Invoquer)(TypUpsVmPointeurTraitements Appel, TypUpsVmShort NbParameres, TypUpsSysValeurC *TableParametresC, 
   enum EnuUpsSysSorteDonneeC SorteDonneeResultat, TypUpsSysValeurC *Resultat, enum EnuUpsSysSorteAppelC SorteAppelC);
   /* Objet : Invoque dynamiquement un appel natif. */
} *TypUpsSysNatTraitements_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsSysNatTraitements_1_1_0 TypUpsSysNatTraitements;

extern DllExport TypUpsSysNatTraitements UpsVmAPI UpsSysNatDemarrerModule(TypUpsVtmMachineInterface MachineInterfaceUpsVtm);
   /* Objet : Retourne la description de Ups Sys Nat. */

/**********************/
#if defined(__cplusplus)
/**********************/
}
/****/
#endif
/****/

/****/
#endif
/****/
