/*-------------------------------------------------------------------
Fichier     : upssys.e
Objet       : En-tete du module Up ! System.

Module      : Up ! System
Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.
---------------------------------------------------------------------
                         Observations

 
---------------------------------------------------------------------*/

/*****************************/
#if !defined(PasseModuleUpsSys)
/*****************************/
#define PasseModuleUpsSys 1

#include <upssys_nt.e>

/**********************/
#if defined(__cplusplus)
/**********************/
extern "C"
{
/****/
#endif
/****/

/****************************************************************/
/* Sections critiques.										             */
/****************************************************************/
enum EnuUpsSysSectionCritique
   {
   SC_Alarme=1,
   SC_GroupeDeTravail=2,
   SC_MemoirePartagee=3,
   SC_Mutex=4,
   SC_Semaphore=5,
   SC_Thread=6,
   SC_Allocateur=7,
   SC_Tas=8,
   SC_UpsNls=9,
   SC_UpsWin=10,
   SC_UpsVtm=11,
   SC_UpsOrb=12,
   SC_Contrainte=13,
   SC_Exception=14,
   SC_UpsNet=15,
   SC_Transaction=16,
   SC_EnregistrementJournal=17,
   SC_UpsAna=18,
   SC_Ups5GL=19,
   SC_UpsLg1=20
   };

/****************************************************************/
/* Codification des types de taches.      			      		*/
/****************************************************************/
enum EnuUpsSysTypeTache
   {
   TA_Alarme=1,
   TA_FileDAttente=2,
   TA_RetasserTousLesTypes=3,
   TA_RetasserType=4,
   TA_Serveur=5,
   TA_FichierEchange=6,
   TA_Scrutateur=7,
   TA_Statistiques=8,
   TA_EnregistrementJournal=9,
   TA_Moniteur=10,
   TA_Archivage=11,
   TA_Principal=12,
   TA_ConsoleGraphique=13,
   TA_AutreTache=100
   };

/****************************************************************/
/* Codification des types de parametres.   			      	    */
/****************************************************************/
enum EnuUpsSysTypeParametre
   {
   TP_Chaine=1,
   TP_ChaineCryptee=2,
   TP_BooleenShort=3,
   TP_BooleenChar=4,
   TP_EvenementShort=5,
   TP_Char=6,
   TP_UnsignedChar=7,
   TP_Short=8,
   TP_UnsignedShort=9,
   TP_Long=10,
   TP_UnsignedLong=11,
   TP_Double=12,
   TP_Caractere=13
   };

/****************************************************************/
/* Codification des operations sur un element alloue.   			 */
/****************************************************************/
enum EnuUpsSysOperationElement
   {
   OE_EffacerUtilisation=1,
   OE_CalculerUtilisation=2,
   OE_SortirSiInutile=3,
   OE_DetruireSiInutile=4
   };

/****************************************************************/
/* Codification de l'utilite d'un element alloue.      			 */
/****************************************************************/
enum EnuUpsSysUtiliteElement
   {
   UE_NeSaitPas=1,
   UE_Utile=2,
   UE_Inutile=3
   };

#define CO_TaillePaquetSemaphore 32
   /* Taille d'un paquet de semaphores unitaires. */
#define CO_NbSectionsCritiquesMax 25
   /* Nombre de sections critiques au maximum. */

/*----------------------*/
/* Enumere DroitsDAcces	*/
/*----------------------*/
#define UpsEnuUpsSys_1_1 1
   /* Valeur : Lecture */
#define UpsEnuUpsSys_1_2 2
   /* Valeur : Ecriture */
#define UpsEnuUpsSys_1_3 3
   /* Valeur : Execution */
#define UpsEnuUpsSys_1_4 4
   /* Valeur : LectureEcriture */
#define UpsEnuUpsSys_1_5 5
   /* Valeur : LectureExecution */
#define UpsEnuUpsSys_1_6 6
   /* Valeur : EcritureExecution */
#define UpsEnuUpsSys_1_7 7
   /* Valeur : LectureEcritureExecution */

/*--------------------*/
/* Enumere SorteUnite */
/*--------------------*/
#define UpsEnuUpsSys_2_1 1
   /* Valeur : DisqueDur. */
#define UpsEnuUpsSys_2_2 2
   /* Valeur : DisqueAmovible. */
#define UpsEnuUpsSys_2_3 3
   /* Valeur : DisqueReseau. */
#define UpsEnuUpsSys_2_4 4
   /* Valeur : DisqueCdRom. */
#define UpsEnuUpsSys_2_5 5
   /* Valeur : DisqueVirtuel. */

/*------------------------------*/
/* Enumere AccesSynchronisation */
/*------------------------------*/
#define UpsEnuUpsSys_3_1 1
   /* Valeur : SynchronisationPrivee. */
#define UpsEnuUpsSys_3_2 2
   /* Valeur : SynchronisationProtegee. */
#define UpsEnuUpsSys_3_3 3
   /* Valeur : SynchronisationPublique. */

/*------------------------------*/
/* Enumere ModeSynchronisation  */
/*------------------------------*/
#define UpsEnuUpsSys_4_1 1
   /* Valeur : SynchronisationLecturePartagee. */
#define UpsEnuUpsSys_4_2 2
   /* Valeur : SynchronisationLectureExclusive. */
#define UpsEnuUpsSys_4_3 3
   /* Valeur : SynchronisationEcriturePartagee. */
#define UpsEnuUpsSys_4_4 4
   /* Valeur : SynchronisationEcritureExclusive. */

/*------------------------------*/
/* Enumere EtatTravail          */
/*------------------------------*/
#define UpsEnuUpsSys_5_1 1
   /* Valeur : TravailNonPlanifie. */
#define UpsEnuUpsSys_5_2 2
   /* Valeur : TravailEnAttente. */
#define UpsEnuUpsSys_5_3 3
   /* Valeur : TravailEnCours. */
#define UpsEnuUpsSys_5_4 4
   /* Valeur : TravailTermine. */
#define UpsEnuUpsSys_5_5 5
   /* Valeur : TravailEnErreur. */

/*------------------------------*/
/* Enumere TypePlanification    */
/*------------------------------*/
#define UpsEnuUpsSys_6_1 1
   /* Valeur : PlanificationAuPlusTot. */
#define UpsEnuUpsSys_6_2 2
   /* Valeur : PlanificationAuPlusTard. */
#define UpsEnuUpsSys_6_3 3
   /* Valeur : PlanificationSynchronisee. */
#define UpsEnuUpsSys_6_4 4
   /* Valeur : PlanificationPeriodique. */

/*------------------------------*/
/* Enumere ModeOuvertureFlux    */
/*------------------------------*/
#define UpsEnuUpsSys_7_1 1
   /* Valeur : NonOuvert */
#define UpsEnuUpsSys_7_2 2
   /* Valeur : LectureTexte */
#define UpsEnuUpsSys_7_3 3
   /* Valeur : EcritureTexte */
#define UpsEnuUpsSys_7_4 4
   /* Valeur : EcritureTexteALaSuite */
#define UpsEnuUpsSys_7_5 5
   /* Valeur : LectureEcritureTexte */
#define UpsEnuUpsSys_7_6 6
   /* Valeur : LectureBinaire */
#define UpsEnuUpsSys_7_7 7
   /* Valeur : EcritureBinaire */
#define UpsEnuUpsSys_7_8 8
   /* Valeur : EcritureBinaireALaSuite */
#define UpsEnuUpsSys_7_9 9
   /* Valeur : LectureEcritureBinaire */

/*------------------------------*/
/* Enumere SorteAccesSegment    */
/*------------------------------*/
#define UpsEnuUpsSys_8_1 1
   /* Valeur : AccesSegmentPrive */
#define UpsEnuUpsSys_8_2 2
   /* Valeur : AccesSegmentProtege */
#define UpsEnuUpsSys_8_3 3
   /* Valeur : AccesSegmentPublic */

/*------------------------------*/
/* Enumere TypePeriodeCalendrier*/
/*------------------------------*/
#define UpsEnuUpsSys_9_1 1
   /* Valeur : PeriodeJournaliere */
#define UpsEnuUpsSys_9_2 2
   /* Valeur : PeriodeHebdomadaire */
#define UpsEnuUpsSys_9_3 3
   /* Valeur : PeriodeBimensuelle */
#define UpsEnuUpsSys_9_4 4
   /* Valeur : PeriodeMensuelle */
#define UpsEnuUpsSys_9_5 5
   /* Valeur : PeriodeBimestrielle */
#define UpsEnuUpsSys_9_6 6
   /* Valeur : PeriodeTrimestrielle */
#define UpsEnuUpsSys_9_7 7
   /* Valeur : PeriodeSemestrielle */
#define UpsEnuUpsSys_9_8 8
   /* Valeur : PeriodeAnnuelle */

/*---------------------------------*/
/* Enumere PagesDeCodesSupportees. */
/*---------------------------------*/
#define UpsEnuUpsSys_10_1 1
   /* Valeur : PageUs7Ascii. */
#define UpsEnuUpsSys_10_2 2
   /* Valeur : PageWE8Iso8859P1. */
#define UpsEnuUpsSys_10_3 3
   /* Valeur : PageEE8Iso8859P2. */
#define UpsEnuUpsSys_10_4 4
   /* Valeur : PageWE8Iso8859P9. */
#define UpsEnuUpsSys_10_5 5
   /* Valeur : PageNE8Iso8859P10. */
#define UpsEnuUpsSys_10_6 6
   /* Valeur : PageUs8Pc437. */
#define UpsEnuUpsSys_10_7 7
   /* Valeur : PageWE8Pc850. */
#define UpsEnuUpsSys_10_8 8
   /* Valeur : PageUS8Pc852. */
#define UpsEnuUpsSys_10_9 9
   /* Valeur : PageWE8Pc857. */
#define UpsEnuUpsSys_10_10 10
   /* Valeur : PageWE8MacRoman8. */
#define UpsEnuUpsSys_10_11 11
   /* Valeur : PageWE8Windows1. */
#define UpsEnuUpsSys_10_12 12
   /* Valeur : PageEE8Windows2. */
#define UpsEnuUpsSys_10_13 13
   /* Valeur : PageWE8Ebcdic297. */
#define UpsEnuUpsSys_10_14 14
   /* Valeur : PageWE8Ebcdic500. */
#define UpsEnuUpsSys_10_15 15
   /* Valeur : PageWE8Ebcdic037. */
#define UpsEnuUpsSys_10_16 16
   /* Valeur : PageWE8Ebcdic260. */
#define UpsEnuUpsSys_10_17 17
   /* Valeur : PageUTF8. */
#define UpsEnuUpsSys_10_18 18
   /* Valeur : PageUTF16BigEndian. */
#define UpsEnuUpsSys_10_19 19
   /* Valeur : PageUTF16LittleEndian. */

/*------------------------------*/
/* Enumere ModeOptimisationFlux */
/*------------------------------*/
#define UpsEnuUpsSys_11_1 1
   /* Valeur : MemoireVolatile. */
#define UpsEnuUpsSys_11_2 2
   /* Valeur : MemoirePersistant. */
#define UpsEnuUpsSys_11_3 3
   /* Valeur : SynchroneSysteme. */
#define UpsEnuUpsSys_11_4 4
   /* Valeur : AsynchroneSysteme. */
#define UpsEnuUpsSys_11_5 5
   /* Valeur : Asynchrone1024. */
#define UpsEnuUpsSys_11_6 6
   /* Valeur : Asynchrone4096. */
#define UpsEnuUpsSys_11_7 7
   /* Valeur : Asynchrone16384. */
#define UpsEnuUpsSys_11_8 8
   /* Valeur : Asynchrone65536. */

/****************************************************************/
typedef struct typupssyscontexte
/* Objet: Memorise un element du contexte.                      */
/****************************************************************/
{
TypUpsVmUnicode NomValeur[CO_TailleIdf+1];
   /* Nom logique du parametre. */
enum EnuUpsSysTypeParametre TypeValeur;
   /* Type du parametre. */
TypUpsVmShort EnMinuscule;
   /* Si Vrai, les parametres de type caractere doivent etre converti en minuscule. */
TypUpsVmPointeurDonnees Valeur;
   /* Pointeur sur la variable ou doit etre rangee la valeur */
   /* du parametre. */
TypUpsVmShort *Lu;
   /* Pointeur sur un indicateur de lecture optionnel. */
} TypUpsSysContexte;

typedef TypUpsVmShort UpsVmAPI (*TypUpsSysDetruireObjetTable)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Objet);
#define UpsSysChercherElementTable(Table, Numero) (((Numero>=1)||(Numero<=Table.IndexMax)) ? Table.TableObjets[Numero-1] : NULL)
#define UpsSysChercherElementExtension(Table, Numero) ((Table) ? (Table[Numero]) : NULL)

/****************************************************************/
typedef struct typupssystable
/* Objet: Memorise d'une table d'objets.                        */
/****************************************************************/
{
TypUpsVmPointeurDonnees *TableObjets;
   /* Table des objets. */
TypUpsVmLong NbObjetsAlloues;
   /* Nombre d'objets alloues. */
TypUpsVmLong IndexMax;
   /* Numero du dernier objet alloue. */
TypUpsVmLong TailleTable;
   /* Taille de la table des objets. */
TypUpsVmLong TailleObjet;
   /* Taille d'un objet. */
TypUpsVmShort TailleIncrement;
   /* Taille d'incrementation de la table. */
TypUpsVmLong Allocateur;
   /* Si non zero, allocateur de la table. */
TypUpsVmShort AllocationDirecte;
   /* Si Vrai, l'allocation est directe. Reserve. */
} TypUpsSysTable;

/*--------------------------------------------------------------*/
/* Definition en forward de l'interface Iterateur.              */
/*--------------------------------------------------------------*/
typedef struct typprmupskrn_19_4_1 TypPrmUpsKrn_19_4_1;
typedef struct typprmupskrn_19_5_1 TypPrmUpsKrn_19_5_1;
typedef struct typprmupskrn_19_6_1 TypPrmUpsKrn_19_6_1;
typedef struct typprmupskrn_19_7_1 TypPrmUpsKrn_19_7_1;
typedef struct typprmupskrn_19_8_1 TypPrmUpsKrn_19_8_1;
typedef struct typprmupskrn_19_11_1 TypPrmUpsKrn_19_11_1;
typedef struct typprmupskrn_19_12_1 TypPrmUpsKrn_19_12_1;
typedef struct typprmupskrn_19_14_1 TypPrmUpsKrn_19_14_1;
typedef struct upstypupskrn_19_1_1_0 UpsTypUpsKrn_19_1_1_0;
typedef struct upstrttypupskrn_19_1_1_0 UpsTrtTypUpsKrn_19_1_1_0;
/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsKrn_19_1_1_0 UpsTypUpsKrn_19;
typedef UpsTrtTypUpsKrn_19_1_1_0 UpsTrtTypUpsKrn_19;

/****************************************************************/
typedef struct upstypupssys_1_1_1_0
/* Objet : Proprietes du type FichierListe.                     */
/****************************************************************/
{
TypUpsVmAdresse UpsChamp1;
   /* NomFichier : Caractere; */
TypUpsVmUnsignedChar UpsChamp2;
   /* EstUnRepertoire : Booleen; */
} UpsTypUpsSys_1_1_1_0;

/****************************************************************/
typedef struct upstrttypupssys_1_1_1_0
/* Objet : Methodes du type FichierListe.                       */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */
} UpsTrtTypUpsSys_1_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsSys_1_1_1_0 UpsTypUpsSys_1;
typedef UpsTrtTypUpsSys_1_1_1_0 UpsTrtTypUpsSys_1;

/****************************************************************/
typedef struct upstypupssys_2_1_1_0
/* Objet : Proprietes du type ProcessusListe.                   */
/****************************************************************/
{
TypUpsVmAdresse UpsChamp1;
   /* Programme : Caractere; */
TypUpsVmLong UpsChamp2;
   /* Numero : Entier; */
TypUpsVmLong UpsChamp3;
   /* Priorite : Entier; */
TypUpsVmDouble UpsChamp4;
   /* TempsEcoule : Reel. */
TypUpsVmDouble UpsChamp5;
   /* TempsSysteme : Reel. */
TypUpsVmDouble UpsChamp6;
   /* TempsUtilisateur: Reel. */
} UpsTypUpsSys_2_1_1_0;

/****************************************************************/
typedef struct upstrttypupssys_2_1_1_0
/* Objet : Methodes du type ProcessusListe.                     */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */
} UpsTrtTypUpsSys_2_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsSys_2_1_1_0 UpsTypUpsSys_2;
typedef UpsTrtTypUpsSys_2_1_1_0 UpsTrtTypUpsSys_2;

/****************************************************************/
typedef struct upstypupssys_3_1_1_0
/* Objet : Proprietes du type UniteListee.                      */
/****************************************************************/
{
TypUpsVmAdresse UpsChamp1;
   /* NomUnite : Caractere; */
TypUpsVmUnsignedChar UpsChamp2;
   /* Unite : SorteUnite. */
TypUpsVmDouble UpsChamp3;
   /* PlaceLibre : Reel; */
TypUpsVmDouble UpsChamp4;
   /* PlaceTotale : Reel; */
} UpsTypUpsSys_3_1_1_0;

/****************************************************************/
typedef struct upstrttypupssys_3_1_1_0
/* Objet : Methodes du type UniteListee.                        */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */
} UpsTrtTypUpsSys_3_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsSys_3_1_1_0 UpsTypUpsSys_3;
typedef UpsTrtTypUpsSys_3_1_1_0 UpsTrtTypUpsSys_3;

/****************************************************************/
typedef struct upstypupssys_4_1_1_0
/* Objet : Proprietes du type Tache.                            */
/****************************************************************/
{
TypUpsVmAdresse UpsChamp1;
   /* NomTache  : Caractere; */
TypUpsVmUnsignedChar UpsChamp2;
   /* EstTerminee : Booleen. */
TypUpsVmLong UpsChamp3;
   /* CodeRetour : Entier; */
TypUpsVmAdresse UpsChamp4;
   /* TransactionCourante : Nul Ou Transaction; */
TypUpsVmUnsignedChar UpsChamp5;
   /* RelancerAutomatiquement : Booleen; */
TypUpsVmAdresse AdresseObjetTransactionPrincipale;
   /* Adresse de l'objet de la transaction principale; */
TypUpsVmShort EstUnObjetAppel;
   /* Si Vrai, la fonction principale de la tache est definie par un objet appel. */
union
   {
   TypUpsVmAdresse AdresseObjetPrincipalTache;
      /* Objet appel de la fonction principale de la tache. */
   struct
      {
      TypUpsVmMethodeEntierAvecParametre PrincipalTache;
         /* Fonction principale de la tache. */
/**********************************/
#if defined(PLATEFORME32TRAITEMENTS)
/**********************************/
      TypUpsVmPointeurDonnees TrouPrincipalTache;
         /* Pour la compatibilite 64 bits. */
/****/
#endif
/****/
      TypUpsVmUnicode NomModule[CO_TailleIdf+1];
         /* Nom du module du provient l'appel. */
      TypUpsVmShort Version;
         /* Version du module. */
      TypUpsVmShort Revision;
         /* Revision du module. */
      TypUpsVmShort Correction;
         /* Correction du module. */
      TypUpsVmLong IndexAppel;
         /* Index de l'appel dans la table des appels. */
      TypUpsVmLong IndexCoAppel;
         /* Index du co-appel dans la table des appels. */
      } Appel;
      /* Pour un appel direct. */
   } Selection;
   /* Selection en fonction de EstUnObjetAppel. */
TypUpsVmLong NumeroThread;
   /* Numero du thread de la tache. */
TypUpsVmUnsignedShort NumeroSession;
   /* Numero de la session de la tache. */
enum EnuUpsSysTypeTache SorteTache;
   /* Sorte de la tache. */
} UpsTypUpsSys_4_1_1_0;

/****************************************************************/
typedef struct typprmupssys_4_4_1
/* Objet : Parametre de Tache.Constructeur(NT:Caractere,        */
/* Traitement:Fonction(TacheCourante:Nul Ou Tache, Relancer:    */
/* Booleen=Faux) Retourner Entier);                             */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NT:Caractere; */
TypUpsVmAdresse UpsVar2;
   /* Traitement:Fonction(TacheCourante:Nul Ou Tache) Retourner Entier; */
TypUpsVmChar UpsVar3;
   /* Relancer:Booleen; */
} TypPrmUpsSys_4_4_1;

/****************************************************************/
typedef struct typprmupssys_4_5_1
/* Objet : Parametre de Procedure ChangerPrioriteRelative(      */
/* Priorite:Entier)                                             */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Priorite:Entier; */
} TypPrmUpsSys_4_5_1;

/****************************************************************/
typedef struct typprmupssys_4_9_1
/* Objet : Parametre de Procedure ArreterTache(CR:Entier)       */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* CR:Entier; */
} TypPrmUpsSys_4_9_1;

/****************************************************************/
typedef struct typprmupssys_4_11_1
/*  Objet : Procedure EnvoyerException(E:Nul Ou Exception, P1:  */
/* Nul Ou Caractere=Nul, P2:Nul Ou Caractere=Nul, P3:Nul Ou     */
/* Caractere=Nul, P4:Nul Ou Caractere=Nul, P5:Nul Ou Caractere= */
/* Nul);                                                        */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E:Nul Ou Exception. */
TypUpsVmAdresse UpsVar2;
   /* P1:Nul Ou Caractere. */
TypUpsVmAdresse UpsVar3;
   /* P2:Nul Ou Caractere. */
TypUpsVmAdresse UpsVar4;
   /* P3:Nul Ou Caractere. */
TypUpsVmAdresse UpsVar5;
   /* P4:Nul Ou Caractere. */
TypUpsVmAdresse UpsVar6;
   /* P5:Nul Ou Caractere. */
} TypPrmUpsSys_4_11_1;

/****************************************************************/
typedef struct upstrttypupssys_4_1_1_0
/* Objet : Methodes du type Tache.                              */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmAdresse UpsVmAPI *(*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsSys_4_4_1 *UpsPrm);
   /* Constructeur(NT:Caractere, Traitement:Fonction(TacheCourante:Nul Ou Tache, P:Nul Ou Objet) Retourner Entier); */
TypUpsVmVoid UpsVmAPI (*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsSys_4_5_1 *UpsPrm);
   /* Objet : Procedure ChangerPrioriteRelative(Priorite:Entier). */
TypUpsVmLong UpsVmAPI (*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Fonction LirePrioriteRelative() Retourner Entier. */
TypUpsVmVoid UpsVmAPI (*Mth_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Procedure SuspendreTache(). */
TypUpsVmVoid UpsVmAPI (*Mth_8_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Procedure ReprendreTache(). */
TypUpsVmVoid UpsVmAPI (*Mth_9_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsSys_4_9_1 *UpsPrm);
   /* Objet : Procedure ArreterTache(CR:Entier). */
TypUpsVmUnsignedChar UpsVmAPI (*Mth_10_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Fonction EstSuspendue() Retourner Booleen. */
TypUpsVmVoid UpsVmAPI (*Mth_11_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsSys_4_11_1 *UpsPrm);
   /*  Objet : Procedure EnvoyerException(E:Nul Ou Exception, P1:Nul Ou Caractere=Nul, P2:Nul Ou Caractere=Nul, P3:Nul Ou Caractere=Nul, P4:Nul Ou Caractere=Nul, P5:Nul Ou Caractere=Nul); */

TypUpsVmCoAppel CoMth_4_1;
   /* Constructeur(NT:Caractere, Traitement:Fonction(TacheCourante:Nul Ou Tache) Retourner Entier); */
TypUpsVmCoAppel CoMth_5_1;
   /* Objet : Procedure ChangerPrioriteRelative(Priorite:Entier). */
TypUpsVmCoAppel CoMth_6_1;
   /* Objet : Fonction LirePrioriteRelative() Retourner Entier. */
TypUpsVmCoAppel CoMth_7_1;
   /* Objet : Procedure SuspendreTache(). */
TypUpsVmCoAppel CoMth_8_1;
   /* Objet : Procedure ReprendreTache(). */
TypUpsVmCoAppel CoMth_9_1;
   /* Objet : Procedure ArreterTache(CR:Entier). */
TypUpsVmCoAppel CoMth_10_1;
   /* Objet : Fonction EstSuspendue() Retourner Booleen. */
TypUpsVmCoAppel CoMth_11_1;
   /*  Objet : Procedure EnvoyerException(E:Nul Ou Exception, P1:Nul Ou Caractere=Nul, P2:Nul Ou Caractere=Nul, P3:Nul Ou Caractere=Nul, P4:Nul Ou Caractere=Nul, P5:Nul Ou Caractere=Nul); */
} UpsTrtTypUpsSys_4_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsSys_4_1_1_0 UpsTypUpsSys_4;
typedef UpsTrtTypUpsSys_4_1_1_0 UpsTrtTypUpsSys_4;

/****************************************************************/
typedef struct upstypupssys_5_1_1_0
/* Objet : Proprietes du type Synchronisation.                  */
/****************************************************************/
{
TypUpsVmAdresse UpsChamp1;
   /* NomSynchronisation : Caractere. */
TypUpsVmUnsignedChar UpsChamp2;
   /* Acces : AccesSynchronisation. */
} UpsTypUpsSys_5_1_1_0;

/****************************************************************/
typedef struct typprmupssys_5_4_1
/* Objet : Parametre de Synchronisation.Constructeur(NS:        */
/* Caractere, AccesDemande:AccesSynchronisation)                */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NT:Caractere; */
TypUpsVmUnsignedChar UpsVar2;
   /* AccesDemande:AccesSynchronisation; */
} TypPrmUpsSys_5_4_1;

/****************************************************************/
typedef struct typprmupssys_5_5_1
/* Objet : Parametre de Synchronisation.Prendre(Mode:           */
/* ModeSynchronisation);                                        */
/****************************************************************/
{
TypUpsVmUnsignedChar UpsVar1;
   /* Mode:ModeSynchronisation; */
} TypPrmUpsSys_5_5_1;

/****************************************************************/
typedef struct typprmupssys_5_6_1
/* Objet : Parametre de Synchronisation.TenterDePrendre(Mode:   */
/* ModeSynchronisation);                                        */
/****************************************************************/
{
TypUpsVmUnsignedChar UpsVar1;
   /* Mode:ModeSynchronisation; */
} TypPrmUpsSys_5_6_1;

/****************************************************************/
typedef struct upstrttypupssys_5_1_1_0
/* Objet : Methodes du type Synchronisation.                    */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmAdresse UpsVmAPI *(*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsSys_5_4_1 *UpsPrm);
   /* Constructeur(Nom:Caractere, AccesDemande:AccesSynchronisation); */
TypUpsVmVoid UpsVmAPI (*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsSys_5_5_1 *UpsPrm);
   /* Objet : Procedure Prendre(Mode:ModeSynchronisation). */
TypUpsVmUnsignedChar UpsVmAPI (*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsSys_5_6_1 *UpsPrm);
   /* Objet : Fonction TenterDePrendre(Mode:ModeSynchronisation) Retourner Booleen; */
TypUpsVmVoid UpsVmAPI (*Mth_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Procedure Lacher(). */

TypUpsVmCoAppel CoMth_4_1;
   /* Constructeur(Nom:Caractere, AccesDemande:AccesSynchronisation); */
TypUpsVmCoAppel CoMth_5_1;
   /* Objet : Procedure Prendre(Mode:ModeSynchronisation). */
TypUpsVmCoAppel CoMth_6_1;
   /* Objet : Fonction TenterDePrendre(Mode:ModeSynchronisation) Retourner Booleen; */
TypUpsVmCoAppel CoMth_7_1;
   /* Objet : Procedure Lacher(). */
} UpsTrtTypUpsSys_5_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsSys_5_1_1_0 UpsTypUpsSys_5;
typedef UpsTrtTypUpsSys_5_1_1_0 UpsTrtTypUpsSys_5;

/****************************************************************/
typedef struct upstypupssys_6_1_1_0
/* Objet : Proprietes d'une FileDAttente.                       */
/****************************************************************/
{
TypUpsVmAdresse UpsObjet1;
   /* Objet pour l'iterateur; */
TypUpsVmAdresse UpsChamp1;
   /* NomFile:Caractere. */
TypUpsVmLong UpsChamp2;
   /* NbServeurs : Entier. */
TypUpsVmAdresse UpsChamp3;
   /* ModuleOrigine:Nul Ou Module. */
TypUpsVmAdresse TableTachesServeurs;
   /* Table des taches des serveurs. */
TypUpsVmAdresse ListeTravauxAuPlusTot;
   /* Liste des travaux a faire a partir d'une date. */ 
TypUpsVmAdresse ListeTravauxAuPlusTard;
   /* Liste des travaux a faire avant une date. */ 
TypUpsVmAdresse ListeTravauxSynchronises;
   /* Liste des travaux synchronises sur d'autres travaux. */ 
TypUpsVmAdresse ListeTravauxPeriodiques;
   /* Liste des travaux periodiques. */ 
TypUpsVmShort ActiverJournal;
   /* Si Vrai, il faut activer le journal. */
TypUpsVmShort NbServeursAlloues;
   /* Nombre de serveurs alloues. */
TypUpsVmShort NbServeursLibres;
   /* Nombre de serveurs alloues qui ne font rien. */
TypUpsVmUnsignedChar TableTypePlanification[CO_NbIterateurs];
   /* Table des iterateurs pour passer d'une planification a l'autre. */
TypUpsVmLong TableIndexIterateurs[CO_NbIterateurs];
   /* Table des index des iterateurs. */
} UpsTypUpsSys_6_1_1_0;

/****************************************************************/
typedef struct typprmupssys_6_20_1
/* Objet : Parametre de ActiverJournal(B:Booleen)               */
/****************************************************************/
{
TypUpsVmUnsignedChar UpsVar1;
   /* B:Booleen. */
} TypPrmUpsSys_6_20_1;

/****************************************************************/
typedef struct upstrttypupssys_6_1_1_0
/* Objet : Methodes du type FileDAttente.                       */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

/*--------------------------------------------------------------*/
/* Methodes heritees de Iterateur.                              */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_4_1 *UpsPrm);
   /* Fonction ParcoursAuDebut(NumeroIterateur : Entier=0) Retourner Nul Ou Tache; */
TypUpsVmAdresse UpsVmAPI *(*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_5_1 *UpsPrm);
   /* Fonction ParcoursALaFin(NumeroIterateur : Entier=0) Retourner Nul Ou Tache; */
TypUpsVmAdresse UpsVmAPI *(*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_6_1 *UpsPrm);
   /* Fonction ParcoursAuMilieu(Position:Nul Ou Entier, NumeroIterateur : Entier=0) Retourner Nul Ou Tache; */
TypUpsVmAdresse UpsVmAPI *(*Mth_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_7_1 *UpsPrm);
   /* Fonction Suivant(NumeroIterateur : Entier=0) Retourner Nul Ou Tache; */
TypUpsVmAdresse UpsVmAPI *(*Mth_8_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_8_1 *UpsPrm);
   /* Fonction Precedent(NumeroIterateur : Entier=0) Retourner Nul Ou Tache; */
TypUpsVmAdresse UpsVmAPI *(*Mth_9_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet);
   /* Fonction PremierElement() Retourner Nul Ou Tache; */
TypUpsVmAdresse UpsVmAPI *(*Mth_10_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet);
   /* Fonction DernierElement() Retourner Nul Ou Tache; */
TypUpsVmAdresse UpsVmAPI *(*Mth_11_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_11_1 *UpsPrm);
   /* Fonction NumeroElement(NumeroIterateur : Entier=0) Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_12_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_12_1 *UpsPrm);
   /* Fonction Element(NumeroIterateur : Entier=0) Retourner Nul Ou Tache; */
TypUpsVmLong UpsVmAPI (*Mth_13_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Fonction AllouerIterateur() Retourner Entier; */
TypUpsVmVoid UpsVmAPI (*Mth_14_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_14_1 *UpsPrm);
   /* Procedure LibererIterateur(NumeroIterateur : Entier); */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmLong UpsVmAPI (*Mth_15_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Fonction NbTravaux() Retourner Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_16_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet);
   /* Fonction DatePremierTravailPlanifie() Retourner Nul Ou Date; */
TypUpsVmAdresse UpsVmAPI *(*Mth_17_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet);
   /* Fonction DateDernierTravailPlanifie() Retourner Nul Ou Date; */
TypUpsVmVoid UpsVmAPI (*Mth_18_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Procedure Suspendre(); */
TypUpsVmVoid UpsVmAPI (*Mth_19_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Procedure Reprendre(); */
TypUpsVmVoid UpsVmAPI (*Mth_20_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_6_20_1 *UpsPrm);
   /* Procedure ActiverJournal(B:Booleen); */

/*--------------------------------------------------------------*/
/* Methodes heritees de Iterateur.                              */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_4_1;
   /* Fonction ParcoursAuDebut(NumeroIterateur : Entier=0) Retourner Nul Ou Tache; */
TypUpsVmCoAppel CoMth_5_1;
   /* Fonction ParcoursALaFin(NumeroIterateur : Entier=0) Retourner Nul Ou Tache; */
TypUpsVmCoAppel CoMth_6_1;
   /* Fonction ParcoursAuMilieu(Position:Nul Ou Entier, Iterateur : Entier=0) Retourner Nul Ou Tache; */
TypUpsVmCoAppel CoMth_7_1;
   /* Fonction Suivant(NumeroIterateur : Entier=0) Retourner Nul Ou Tache; */
TypUpsVmCoAppel CoMth_8_1;
   /* Fonction Precedent(NumeroIterateur : Entier=0) Retourner Nul Ou Tache; */
TypUpsVmCoAppel CoMth_9_1;
   /* Fonction PremierElement() Retourner Nul Ou Tache; */
TypUpsVmCoAppel CoMth_10_1;
   /* Fonction DernierElement() Retourner Nul Ou Tache; */
TypUpsVmCoAppel CoMth_11_1;
   /* Fonction NumeroElement(NumeroIterateur : Entier=0) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_12_1;
   /* Fonction Element(NumeroIterateur : Entier=0) Retourner Nul Ou Tache; */
TypUpsVmCoAppel CoMth_13_1;
   /* Fonction AllouerIterateur() Retourner Entier; */
TypUpsVmCoAppel CoMth_14_1;
   /* Procedure LibererIterateur(NumeroIterateur : Entier); */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_15_1;
   /* Fonction NbTravaux() Retourner Entier; */
TypUpsVmCoAppel CoMth_16_1;
   /* Fonction DatePremierTravailPlanifie() Retourner Nul Ou Date; */
TypUpsVmCoAppel CoMth_17_1;
   /* Fonction DateDernierTravailPlanifie() Retourner Nul Ou Date; */
TypUpsVmCoAppel CoMth_18_1;
   /* Procedure Suspendre(); */
TypUpsVmCoAppel CoMth_19_1;
   /* Procedure Reprendre(); */
TypUpsVmCoAppel CoMth_20_1;
   /* Procedure ActiverJournal(B:Booleen); */
} UpsTrtTypUpsSys_6_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsSys_6_1_1_0 UpsTypUpsSys_6;
typedef UpsTrtTypUpsSys_6_1_1_0 UpsTrtTypUpsSys_6;

/****************************************************************/
typedef struct upstypupssys_7_1_1_0
/* Objet : Proprietes d'un Travail.                             */
/****************************************************************/
{
TypUpsVmAdresse UpsChamp1;
   /* NomTravail:Caractere. */
TypUpsVmUnsignedChar UpsChamp2;
   /* Etat : EtatTravail. */
TypUpsVmAdresse UpsChamp3;
   /* MessageErreur:Nul Ou Caractere. */
TypUpsVmLong UpsChamp4;
   /* CodeErreur:Entier. */
TypUpsVmAdresse UpsChamp5;
   /* FileDAttente : Nul Ou File. */
TypUpsVmUnsignedChar UpsChamp6;
   /* Planification : TypePlanification. */
TypUpsVmLong UpsChamp7;
   /* Priorite du travail. */
TypUpsVmAdresse UpsChamp8;
   /* DatePlanification : Nul Ou Date. */
TypUpsVmLong UpsChamp9;
   /* DureeEstimee:Entier. */
TypUpsVmLong UpsChamp10;
   /* Numero:Entier. */
TypUpsVmAdresse UpsChamp11;
   /* CalendrierDExecution : Nul Ou Calendrier. */
TypUpsVmAdresse AdresseObjetAppel;
   /* Adresse de l'objet du travail a effectuer. */
TypUpsVmAdresse AdresseListeDependances;
   /* Adresse de la liste des dependances par rapport aux autres travaux. */
TypUpsVmValeur Resultat;
   /* Resultat de l'appel. */
TypUpsVmAdresse ObjetBufferParametres;
   /* Buffer des parametres. */
TypUpsVmLong IndexBufferParametres;
   /* Index du buffer dans le segment. */
TypUpsVmLong NbBuffersParametres;
   /* Nombre d'elements consecutifs occupes par le buffer. */
TypUpsVmLong TailleParametre;
   /* Taille de l'objet des parametres. */
} UpsTypUpsSys_7_1_1_0;

/****************************************************************/
typedef struct typprmupssys_7_4_1
/* Objet : Parametre de Travail.PlanifierAuPlusTot(DateDebut:   */
/* Date, Duree:Entier, PrioriteTravail:Entier=2)                */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* DateDebut : Date. */
TypUpsVmLong UpsVar2;
   /* Duree : Entier. */
TypUpsVmLong UpsVar3;
   /* PrioriteTravail : Entier. */
} TypPrmUpsSys_7_4_1;

/****************************************************************/
typedef struct typprmupssys_7_5_1
/* Objet : Parametre de Travail.PlanifierAuPlusTard(DateDebut:  */
/* Date, Duree:Entier, PrioriteTravail:Entier=2)                */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* DateDebut : Date. */
TypUpsVmLong UpsVar2;
   /* Duree : Entier. */
TypUpsVmLong UpsVar3;
   /* PrioriteTravail : Entier. */
} TypPrmUpsSys_7_5_1;

/****************************************************************/
typedef struct typprmupssys_7_6_1
/* Objet : Parametre de Travail.PlanifierApres(T:Nul Ou         */
/* ListeDe Travail, Duree:Entier, PrioriteTravail:Entier=2)     */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* T : Nul Ou ListeDe Travail. */
TypUpsVmLong UpsVar2;
   /* Duree : Entier. */
TypUpsVmLong UpsVar3;
   /* PrioriteTravail : Entier. */
} TypPrmUpsSys_7_6_1;

/****************************************************************/
typedef struct typprmupssys_7_7_1
/* Objet : Parametre de Travail.PlanifierPeriodiquement(C:Nul Ou*/
/* Calendrier, Duree:Entier, PrioriteTravail:Entier=2)          */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* C : Nul Ou Calendrier. */
TypUpsVmLong UpsVar2;
   /* Duree : Entier. */
TypUpsVmLong UpsVar3;
   /* PrioriteTravail : Entier. */
} TypPrmUpsSys_7_7_1;

/****************************************************************/
typedef struct typprmupssys_7_9_1
/* Objet : Parametre de Travail.LireValeurEnumere(              */
/* NumeroParametre:Entier) Retourner Enumere                    */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* NumeroParametre : Entier. */
} TypPrmUpsSys_7_9_1;

/****************************************************************/
typedef struct typprmupssys_7_10_1
/* Objet : Parametre de Travail.LireValeurEntier(               */
/* NumeroParametre:Entier) Retourner Entier                     */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* NumeroParametre : Entier. */
} TypPrmUpsSys_7_10_1;

/****************************************************************/
typedef struct U
/* Objet : Parametre de Travail.LireValeurReel(                 */
/* NumeroParametre:Entier) Retourner Reel                       */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* NumeroParametre : Entier. */
} TypPrmUpsSys_7_11_1;

/****************************************************************/
typedef struct typprmupssys_7_12_1
/* Objet : Parametre de Travail.LireValeurObjet(                */
/* NumeroParametre:Entier) Retourner Nul Ou Objet               */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* NumeroParametre : Entier. */
} TypPrmUpsSys_7_12_1;

/****************************************************************/
typedef struct upstrttypupssys_7_1_1_0
/* Objet : Methodes du type Travail.                            */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmVoid UpsVmAPI (*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsSys_7_4_1 *UpsPrm);
   /* Procedure PlanifierAuPlusTot(DateDebut:Date, Duree:UpsKrnEntier, PrioriteTravail:Entier=2); */
TypUpsVmVoid UpsVmAPI (*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsSys_7_5_1 *UpsPrm);
   /* Procedure PlanifierAuPlusTard(DateDebut:Date, Duree:UpsKrnEntier, PrioriteTravail:Entier=2); */
TypUpsVmVoid UpsVmAPI (*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsSys_7_6_1 *UpsPrm);
   /* Procedure PlanifierApres(T:Nul Ou ListeDe Travail, Duree:UpsKrnEntier, PrioriteTravail:Entier=2); */
TypUpsVmVoid UpsVmAPI (*Mth_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsSys_7_7_1 *UpsPrm);
   /* Procedure PlanifierPeriodiquement(C:Nul Ou Calendrier, Duree:UpsKrnEntier, PrioriteTravail:Entier=2); */
TypUpsVmVoid UpsVmAPI (*Mth_8_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Procedure Supprimer(); */
TypUpsVmUnsignedShort UpsVmAPI (*Mth_9_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsSys_7_9_1 *UpsPrm);
   /* Fonction LireValeurEnumere(NumeroParametre:Entier) Retourner Enumere; */
TypUpsVmLong UpsVmAPI (*Mth_10_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsSys_7_10_1 *UpsPrm);
   /* Fonction LireValeurEntier(NumeroParametre:Entier) Retourner Entier; */
TypUpsVmDouble UpsVmAPI (*Mth_11_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsSys_7_11_1 *UpsPrm);
   /* Fonction LireValeurReel(NumeroParametre:Entier) Retourner Reel; */
TypUpsVmAdresse UpsVmAPI *(*Mth_12_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsSys_7_12_1 *UpsPrm);
   /* Fonction LireValeurObjet(NumeroParametre:Entier) Retourner Nul Ou Objet; */

TypUpsVmCoAppel CoMth_4_1;
   /* Procedure PlanifierAuPlusTot(DateDebut:Date, Duree:UpsKrnEntier, PrioriteTravail:Entier=2); */
TypUpsVmCoAppel CoMth_5_1;
   /* Procedure PlanifierAuPlusTard(DateDebut:Date, Duree:UpsKrnEntier, PrioriteTravail:Entier=2); */
TypUpsVmCoAppel CoMth_6_1;
   /* Procedure PlanifierApres(T:Nul Ou ListeDe Travail, Duree:UpsKrnEntier, PrioriteTravail:Entier=2); */
TypUpsVmCoAppel CoMth_7_1;
   /* Procedure PlanifierPeriodiquement(C:Nul Ou Calendrier, Duree:UpsKrnEntier, PrioriteTravail:Entier=2); */
TypUpsVmCoAppel CoMth_8_1;
   /* Procedure Supprimer(); */
TypUpsVmCoAppel CoMth_9_1;
   /* Fonction LireValeurEnumere(NumeroParametre:Entier) Retourner Enumere; */
TypUpsVmCoAppel CoMth_10_1;
   /* Fonction LireValeurEntier(NumeroParametre:Entier) Retourner Entier; */
TypUpsVmCoAppel CoMth_11_1;
   /* Fonction LireValeurReel(NumeroParametre:Entier) Retourner Reel; */
TypUpsVmCoAppel CoMth_12_1;
   /* Fonction LireValeurObjet(NumeroParametre:Entier) Retourner Nul Ou Objet; */
} UpsTrtTypUpsSys_7_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsSys_7_1_1_0 UpsTypUpsSys_7;
typedef UpsTrtTypUpsSys_7_1_1_0 UpsTrtTypUpsSys_7;

/****************************************************************/
typedef struct upstypupssys_12_1_1_0
/* Objet : Proprietes du type Flux.                             */
/****************************************************************/
{
TypUpsVmUnsignedChar UpsChamp1;
   /* Mode:ModeOuvertureFlux Lecture Public; */
TypUpsVmAdresse UpsChamp2;
   /* NomFlux : Caractere. */
TypUpsVmUnsignedChar UpsChamp3;
   /* FinDeFlux:Booleen; */
} UpsTypUpsSys_12_1_1_0;

/****************************************************************/
typedef struct typprmupssys_12_5_1
/* Objet : Parametre de Flux.Lire(B:Booleen Sortie)             */
/****************************************************************/
{
TypUpsVmUnsignedChar UpsVar1;
   /* B : Booleen. */
} TypPrmUpsSys_12_5_1;

/****************************************************************/
typedef struct typprmupssys_12_5_2
/* Objet : Parametre de Flux.Lire(B:Binaire Sortie,             */
/* Nombre:Nul Ou Entier) Retourner Nul Ou Entier                */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* B : Binaire. */
TypUpsVmAdresse UpsVar2;
   /* Nombre : Nul Ou Entier. */
} TypPrmUpsSys_12_5_2;

/****************************************************************/
typedef struct typprmupssys_12_5_3
/* Objet : Parametre de Flux.Lire(C:Caractere Sortie,           */
/* Nombre:Nul Ou Entier) Retourner Nul Ou Entier                */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* C : Caractere. */
TypUpsVmAdresse UpsVar2;
   /* Nombre : Nul Ou Entier. */
} TypPrmUpsSys_12_5_3;

/****************************************************************/
typedef struct typprmupssys_12_5_4
/* Objet : Parametre de Flux.Lire(E:Entier Sortie)              */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* E : Entier. */
} TypPrmUpsSys_12_5_4;

/****************************************************************/
typedef struct typprmupssys_12_5_5
/* Objet : Parametre de Flux.Lire(R:Reel Sortie)                */
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* R : Reel. */
} TypPrmUpsSys_12_5_5;

/****************************************************************/
typedef struct typprmupssys_12_6_1
/* Objet : Parametre de Flux.LireUneLigne(C:Nul Ou Caractere    */
/* Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier        */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* C : Nul Ou Caractere. */
TypUpsVmAdresse UpsVar2;
   /* Nombre : Nul Ou Entier. */
} TypPrmUpsSys_12_6_1;

/****************************************************************/
typedef struct typprmupssys_12_7_1
/* Objet : Parametre de Flux.LireUnMot(C:Nul Ou Caractere       */
/* Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier        */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* C : Nul Ou Caractere. */
TypUpsVmAdresse UpsVar2;
   /* Nombre : Nul Ou Entier. */
} TypPrmUpsSys_12_7_1;

/****************************************************************/
typedef struct typprmupssys_12_8_1
/* Objet : Parametre de Flux.Ecrire(B:Nul Ou Booleen)           */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* B : Nul Ou Booleen. */
} TypPrmUpsSys_12_8_1;

/****************************************************************/
typedef struct typprmupssys_12_8_2
/* Objet : Parametre de Flux.Ecrire(B:Nul Ou Binaire)           */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* B : Nul Ou Binaire. */
} TypPrmUpsSys_12_8_2;

/****************************************************************/
typedef struct typprmupssys_12_8_3
/* Objet : Parametre de Flux.Ecrire(C:Nul Ou Caractere)         */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* C : Nul Ou Caractere. */
} TypPrmUpsSys_12_8_3;

/****************************************************************/
typedef struct typprmupssys_12_8_4
/* Objet : Parametre de Flux.Ecrire(C:Nul Ou Entier)            */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* C : Nul Ou Entier. */
} TypPrmUpsSys_12_8_4;

/****************************************************************/
typedef struct typprmupssys_12_8_5
/* Objet : Parametre de Flux.Ecrire(C:Nul Ou Reel)              */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* C : Nul Ou Reel. */
} TypPrmUpsSys_12_8_5;

/****************************************************************/
typedef struct typprmupssys_12_11_1
/* Objet : ChangerPageDeCode(P:PagesDeCodesSupportees)          */ 
/****************************************************************/
{
TypUpsVmUnsignedChar UpsVar1;
   /* P:PagesDeCodesSupportees. */
} TypPrmUpsSys_12_11_1;

/****************************************************************/
typedef struct upstrttypupssys_12_1_1_0
/* Objet : Methodes du type Flux.                               */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmVoid UpsVmAPI (*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_5_1 *UpsPrm);
   /* Procedure Lire(B:Booleen Sortie); */
TypUpsVmAdresse UpsVmAPI *(*Mth_5_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_5_2 *UpsPrm);
   /* Fonction Lire(C:Binaire Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_5_3)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_5_3 *UpsPrm);
   /* Fonction Lire(C:Caractere Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmVoid UpsVmAPI (*Mth_5_4)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_5_4 *UpsPrm);
   /* Procedure Lire(E:Entier Sortie); */
TypUpsVmVoid UpsVmAPI (*Mth_5_5)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_5_5 *UpsPrm);
   /* Procedure Lire(R:Reel Sortie); */
TypUpsVmAdresse UpsVmAPI *(*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_6_1 *UpsPrm);
   /* Fonction LireUnMot(C:Nul Ou Caractere Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_7_1 *UpsPrm);
   /* Fonction LireUneLigne(C:Nul Ou Caractere Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmVoid UpsVmAPI (*Mth_8_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_8_1 *UpsPrm);
   /* Procedure Ecrire(B:Nul Ou Booleen); */
TypUpsVmVoid UpsVmAPI (*Mth_8_2)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_8_2 *UpsPrm);
   /* Procedure Ecrire(C:Nul Ou Binaire); */
TypUpsVmVoid UpsVmAPI (*Mth_8_3)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_8_3 *UpsPrm);
   /* Procedure Ecrire(C:Nul Ou Caractere); */
TypUpsVmVoid UpsVmAPI (*Mth_8_4)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_8_4 *UpsPrm);
   /* Procedure Ecrire(E:Nul Ou Entier); */
TypUpsVmVoid UpsVmAPI (*Mth_8_5)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_8_5 *UpsPrm);
   /* Procedure Ecrire(R:Nul Ou Reel); */
TypUpsVmVoid UpsVmAPI (*Mth_9_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Procedure Fermer(); */
TypUpsVmUnsignedChar UpsVmAPI (*Mth_10_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Objet : LirePageDeCode() Retourner PagesDeCodesSupportees. */ 
TypUpsVmVoid UpsVmAPI (*Mth_11_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_11_1 *UpsPrm);
   /* Objet : ChangerPageDeCode(P:PagesDeCodesSupportees). */ 

TypUpsVmCoAppel CoMth_5_1;
   /* Procedure Lire(B:Booleen Sortie); */
TypUpsVmCoAppel CoMth_5_2;
   /* Fonction Lire(C:Binaire Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_5_3;
   /* Fonction Lire(C:Caractere Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_5_4;
   /* Procedure Lire(E:Entier Sortie); */
TypUpsVmCoAppel CoMth_5_5;
   /* Procedure Lire(R:Reel Sortie); */
TypUpsVmCoAppel CoMth_6_1;
   /* Fonction LireUnMot(C:Nul Ou Caractere Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_7_1;
   /* Fonction LireUneLigne(C:Nul Ou Caractere Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_8_1;
   /* Procedure Ecrire(B:Nul Ou Booleen); */
TypUpsVmCoAppel CoMth_8_2;
   /* Procedure Ecrire(C:Nul Ou Binaire); */
TypUpsVmCoAppel CoMth_8_3;
   /* Procedure Ecrire(C:Nul Ou Caractere); */
TypUpsVmCoAppel CoMth_8_4;
   /* Procedure Ecrire(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_8_5;
   /* Procedure Ecrire(R:Nul Ou Reel); */
TypUpsVmCoAppel CoMth_9_1;
   /* Procedure Fermer(); */
TypUpsVmCoAppel CoMth_10_1;
   /* Objet : LirePageDeCode() Retourner PagesDeCodesSupportees. */ 
TypUpsVmCoAppel CoMth_11_1;
   /* Objet : ChangerPageDeCode(P:PagesDeCodesSupportees). */ 
} UpsTrtTypUpsSys_12_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsSys_12_1_1_0 UpsTypUpsSys_12;
typedef UpsTrtTypUpsSys_12_1_1_0 UpsTrtTypUpsSys_12;

/****************************************************************/
typedef struct upstypupssys_8_1_1_0
/* Objet : Proprietes du type Fichier.                          */
/****************************************************************/
{
TypUpsVmAdresse UpsObjet1;
   /* Objet pour le flux; */
TypUpsVmFlux Fichier;
   /* Descripteur du fichier. */
TypUpsVmLong Position;
   /* Position dans le fichier suite a la derniere ecriture ou lecture. */
} UpsTypUpsSys_8_1_1_0;

/****************************************************************/
typedef struct typprmupssys_8_4_2
/* Objet : Parametre de Constructeur(NomDuFichier:Nul Ou        */
/* Caractere, ModeOuverture:ModeOuvertureFichier,               */
/* ModeOptimisation:ModeOptimisationFlux);                      */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomDuFichier : Nul Ou Caractere. */
TypUpsVmUnsignedChar UpsVar2;
   /* ModeOuverture : ModeOuvertureFichier. */
TypUpsVmUnsignedChar UpsVar3;
   /* ModeOptimisation : ModeOptimisationFlux. */
} TypPrmUpsSys_8_4_2;

/****************************************************************/
typedef struct typprmupssys_8_13_1
/* Objet : Parametre de Fichier.FixerPosition(Position:Entier)  */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Position : Caractere. */
} TypPrmUpsSys_8_13_1;

/****************************************************************/
typedef struct upstrttypupssys_8_1_1_0
/* Objet : Methodes du type Fichier.                            */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

/*--------------------------------------------------------------*/
/* Methodes heritees de Flux.                                   */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*Mth_4_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsSys_8_4_2 *UpsPrm);
   /* Constructeur(NomDuFichier:Nul Ou Caractere, ModeOuverture:ModeOuvertureFichier, ModeOptimisation:ModeOptimisationFlux); */
TypUpsVmVoid UpsVmAPI (*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_5_1 *UpsPrm);
   /* Procedure Lire(B:Booleen Sortie); */
TypUpsVmAdresse UpsVmAPI *(*Mth_5_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_5_2 *UpsPrm);
   /* Fonction Lire(C:Binaire Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_5_3)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_5_3 *UpsPrm);
   /* Fonction Lire(C:Caractere Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmVoid UpsVmAPI (*Mth_5_4)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_5_4 *UpsPrm);
   /* Procedure Lire(E:Entier Sortie); */
TypUpsVmVoid UpsVmAPI (*Mth_5_5)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_5_5 *UpsPrm);
   /* Procedure Lire(R:Reel Sortie); */
TypUpsVmAdresse UpsVmAPI *(*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_6_1 *UpsPrm);
   /* Fonction LireUnMot(C:Nul Ou Caractere Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_7_1 *UpsPrm);
   /* Fonction LireUneLigne(C:Nul Ou Caractere Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmVoid UpsVmAPI (*Mth_8_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_8_1 *UpsPrm);
   /* Procedure Ecrire(B:Nul Ou Booleen); */
TypUpsVmVoid UpsVmAPI (*Mth_8_2)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_8_2 *UpsPrm);
   /* Procedure Ecrire(C:Nul Ou Binaire); */
TypUpsVmVoid UpsVmAPI (*Mth_8_3)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_8_3 *UpsPrm);
   /* Procedure Ecrire(C:Nul Ou Caractere); */
TypUpsVmVoid UpsVmAPI (*Mth_8_4)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_8_4 *UpsPrm);
   /* Procedure Ecrire(E:Nul Ou Entier); */
TypUpsVmVoid UpsVmAPI (*Mth_8_5)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_8_5 *UpsPrm);
   /* Procedure Ecrire(R:Nul Ou Reel); */
TypUpsVmVoid UpsVmAPI (*Mth_9_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Procedure Fermer(); */
TypUpsVmUnsignedChar UpsVmAPI (*Mth_10_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Objet : LirePageDeCode() Retourner PagesDeCodesSupportees. */ 
TypUpsVmVoid UpsVmAPI (*Mth_11_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_11_1 *UpsPrm);
   /* Objet : ChangerPageDeCode(P:PagesDeCodesSupportees). */ 
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*Mth_12_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet);
   /* Fonction LirePosition() Retourner Entier; */
TypUpsVmVoid UpsVmAPI (*Mth_13_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_8_13_1 *UpsPrm);
   /* Procedure FixerPosition(Position:Entier); */
TypUpsVmVoid UpsVmAPI (*Mth_14_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Procedure DeposerSurDisque(); */
TypUpsVmVoid UpsVmAPI (*Mth_15_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Procedure Vider(); */
TypUpsVmVoid UpsVmAPI (*Mth_16_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Procedure Effacer(); */

/*--------------------------------------------------------------*/
/* Methodes heritees de Flux.                                   */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_4_2;
   /* Constructeur(NomDuFichier:Nul Ou Caractere, ModeOuverture:ModeOuvertureFichier, ModeOptimisation:ModeOptimisationFlux); */
TypUpsVmCoAppel CoMth_5_1;
   /* Procedure Lire(B:Booleen Sortie); */
TypUpsVmCoAppel CoMth_5_2;
   /* Fonction Lire(C:Binaire Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_5_3;
   /* Fonction Lire(C:Caractere Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_5_4;
   /* Procedure Lire(E:Entier Sortie); */
TypUpsVmCoAppel CoMth_5_5;
   /* Procedure Lire(R:Reel Sortie); */
TypUpsVmCoAppel CoMth_6_1;
   /* Fonction LireUnMot(C:Nul Ou Caractere Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_7_1;
   /* Fonction LireUneLigne(C:Nul Ou Caractere Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_8_1;
   /* Procedure Ecrire(B:Nul Ou Booleen); */
TypUpsVmCoAppel CoMth_8_2;
   /* Procedure Ecrire(C:Nul Ou Binaire); */
TypUpsVmCoAppel CoMth_8_3;
   /* Procedure Ecrire(C:Nul Ou Caractere); */
TypUpsVmCoAppel CoMth_8_4;
   /* Procedure Ecrire(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_8_5;
   /* Procedure Ecrire(R:Nul Ou Reel); */
TypUpsVmCoAppel CoMth_9_1;
   /* Procedure Fermer(); */
TypUpsVmCoAppel CoMth_10_1;
   /* Objet : LirePageDeCode() Retourner PagesDeCodesSupportees. */ 
TypUpsVmCoAppel CoMth_11_1;
   /* Objet : ChangerPageDeCode(P:PagesDeCodesSupportees). */ 
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_12_1;
   /* Fonction LirePosition() Retourner Entier; */
TypUpsVmCoAppel CoMth_13_1;
   /* Procedure FixerPosition(Position:Entier); */
TypUpsVmCoAppel CoMth_14_1;
   /* Procedure DeposerSurDisque(); */
TypUpsVmCoAppel CoMth_15_1;
   /* Procedure Vider(); */
TypUpsVmCoAppel CoMth_16_1;
   /* Procedure Effacer(); */
} UpsTrtTypUpsSys_8_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsSys_8_1_1_0 UpsTypUpsSys_8;
typedef UpsTrtTypUpsSys_8_1_1_0 UpsTrtTypUpsSys_8;

/****************************************************************/
typedef struct upstypupssys_9_1_1_0
/* Objet : Proprietes du type Segment.                          */
/****************************************************************/
{
TypUpsVmUnsignedChar UpsChamp1;
   /* AccesSegment:SorteSegment. */
} UpsTypUpsSys_9_1_1_0;

/****************************************************************/
typedef struct upstrttypupssys_9_1_1_0
/* Objet : Methodes du type Segment.                            */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmLong UpsVmAPI (*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Fonction NbUtilisations() Retourner Entier; */

TypUpsVmCoAppel CoMth_4_1;
   /* Fonction NbUtilisations() Retourner Entier; */
} UpsTrtTypUpsSys_9_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsSys_9_1_1_0 UpsTypUpsSys_9;
typedef UpsTrtTypUpsSys_9_1_1_0 UpsTrtTypUpsSys_9;

/****************************************************************/
typedef struct upstypupssys_10_1_1_0
/* Objet : Proprietes d'un PeriodeCalendrier.                   */
/****************************************************************/
{
TypUpsVmUnsignedChar UpsChamp1;
   /* TypePeriode:TypePeriodeCalendrier; */
TypUpsVmAdresse UpsChamp2;
   /* DatePlanification:Date; */
TypUpsVmLong UpsChamp3;
   /* FrequenceRepetition:Entier. */
TypUpsVmAdresse UpsChamp4;
   /* DateArret:Nul Ou Date; */
TypUpsVmAdresse UpsChamp5;
   /* HeureArret:Nul Ou Date; */
TypUpsVmAdresse DatePremierePlanification;
   /* Date de la premiere planification. */
} UpsTypUpsSys_10_1_1_0;

/****************************************************************/
typedef struct typprmupssys_10_4_1
/* Objet : Parametre de Constructeur(TypeDeLaPeriode:           */
/* TypePeriodeCalendrier,DatePremierePlanification:Date,        */
/* FrequenceDeRepetition:Entier=0,DateDArret:Nul Ou Date=Nul,   */
/* HeureDArret:Nul Ou Date=Nul);                                */
/****************************************************************/
{
TypUpsVmUnsignedChar UpsVar1;
   /* TypeDeLaPeriode:TypePeriodeCalendrier; */
TypUpsVmAdresse UpsVar2;
   /* DatePremierePlanification:Date; */
TypUpsVmLong UpsVar3;
   /* FrequenceDeRepetition:Entier. */
TypUpsVmAdresse UpsVar4;
   /* DateDArret:Nul Ou Date; */
TypUpsVmAdresse UpsVar5;
   /* HeureDArret:Nul Ou Date; */
} TypPrmUpsSys_10_4_1;

/****************************************************************/
typedef struct upstrttypupssys_10_1_1_0
/* Objet : Methodes du type PeriodeCalendrier.                  */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */
TypUpsVmAdresse UpsVmAPI *(*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsSys_10_4_1 *UpsPrm);
   /* Constructeur(TypeDeLaPeriode:TypePeriodeCalendrier,DatePremierePlanification:Date,
      FrequenceDeRepetition:Entier=0,DateDArret:Nul Ou Date=Nul, HeureDArret:Nul Ou Date=Nul); */

TypUpsVmCoAppel CoMth_4_1;
   /* Constructeur(TypeDeLaPeriode:TypePeriodeCalendrier,DatePremierePlanification:Date,
      FrequenceDeRepetition:Entier=0,DateDArret:Nul Ou Date=Nul, HeureDArret:Nul Ou Date=Nul); */
} UpsTrtTypUpsSys_10_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsSys_10_1_1_0 UpsTypUpsSys_10;
typedef UpsTrtTypUpsSys_10_1_1_0 UpsTrtTypUpsSys_10;

/****************************************************************/
typedef struct upstypupssys_11_1_1_0
/* Objet : Proprietes d'un Calendrier.                          */
/****************************************************************/
{
TypUpsVmAdresse UpsChamp1;
   /* NomCalendrier : Caractere; */
TypUpsVmAdresse UpsChamp2;
   /* PeriodesIncluses:Nul Ou ListeDe Nul Ou PeriodeCalendrier; */
TypUpsVmAdresse UpsChamp3;
   /* PeriodesExclues:Nul Ou ListeDe Nul Ou PeriodeCalendrier. */
TypUpsVmAdresse UpsChamp4;
   /* DatePlanification:Nul Ou Date; */
TypUpsVmAdresse ListeTravaux;
   /* Liste de travaux rattaches a ce calendrier; */
} UpsTypUpsSys_11_1_1_0;

/****************************************************************/
typedef struct typprmupssys_11_4_1
/* Objet : Parametre de Constructeur(NomDuCalendrier:Caractere);*/
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomDuCalendrier:Caractere; */
} TypPrmUpsSys_11_4_1;

/****************************************************************/
typedef struct typprmupssys_11_5_1
/* Objet : Parametre de AjouterPeriodeIncluse(P:Nul Ou          */
/* PeriodeCalendrier);                                          */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* P:Nul Ou PeriodeCalendrier; */
} TypPrmUpsSys_11_5_1;

/****************************************************************/
typedef struct typprmupssys_11_6_1
/* Objet : Parametre de AjouterPeriodeExclue(P:Nul Ou           */
/* PeriodeCalendrier);                                          */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* P:Nul Ou PeriodeCalendrier; */
} TypPrmUpsSys_11_6_1;

/****************************************************************/
typedef struct typprmupssys_11_7_1
/* Objet : Parametre de SupprimerPeriodeIncluse(P:Nul Ou        */
/* PeriodeCalendrier);                                          */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* P:Nul Ou PeriodeCalendrier; */
} TypPrmUpsSys_11_7_1;

/****************************************************************/
typedef struct typprmupssys_11_8_1
/* Objet : Parametre de SupprimerPeriodeExclue(P:Nul Ou         */
/* PeriodeCalendrier);                                          */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* P:Nul Ou PeriodeCalendrier; */
} TypPrmUpsSys_11_8_1;

/****************************************************************/
typedef struct upstrttypupssys_11_1_1_0
/* Objet : Methodes du type Calendrier.                         */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmAdresse UpsVmAPI *(*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsSys_11_4_1 *UpsPrm);
   /* Constructeur(NomDuCalendrier:Caractere); */
TypUpsVmVoid UpsVmAPI (*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsSys_11_5_1 *UpsPrm);
   /* AjouterPeriodeIncluse(P:Nul Ou PeriodeCalendrier); */
TypUpsVmVoid UpsVmAPI (*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsSys_11_6_1 *UpsPrm);
   /* AjouterPeriodeExclue(P:Nul Ou PeriodeCalendrier); */
TypUpsVmVoid UpsVmAPI (*Mth_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsSys_11_7_1 *UpsPrm);
   /* SupprimerPeriodeIncluse(P:Nul Ou PeriodeCalendrier); */
TypUpsVmVoid UpsVmAPI (*Mth_8_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsSys_11_8_1 *UpsPrm);
   /* SupprimerPeriodeExclue(P:Nul Ou PeriodeCalendrier); */

TypUpsVmCoAppel CoMth_4_1;
   /* Constructeur(NomDuCalendrier:Caractere); */
TypUpsVmCoAppel CoMth_5_1;
   /* AjouterPeriodeIncluse(P:Nul Ou PeriodeCalendrier); */
TypUpsVmCoAppel CoMth_6_1;
   /* AjouterPeriodeExclue(P:Nul Ou PeriodeCalendrier); */
TypUpsVmCoAppel CoMth_7_1;
   /* SupprimerPeriodeIncluse(P:Nul Ou PeriodeCalendrier); */
TypUpsVmCoAppel CoMth_8_1;
   /* SupprimerPeriodeExclue(P:Nul Ou PeriodeCalendrier); */
} UpsTrtTypUpsSys_11_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsSys_11_1_1_0 UpsTypUpsSys_11;
typedef UpsTrtTypUpsSys_11_1_1_0 UpsTrtTypUpsSys_11;

/****************************************************************/
typedef struct typprmupssys_1_1
/* Objet : Parametre de CreerFichier(NomFichier:Nul Ou          */
/* Caractere)                                                   */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomFichier : Nul Ou Caractere. */
} TypPrmUpsSys_1_1;

/****************************************************************/
typedef struct typprmupssys_2_1
/* Objet : Parametre de CreerRepertoire(NomRepertoire:Nul Ou    */
/* Caractere)                                                   */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomRepertoire : Nul Ou Caractere. */
} TypPrmUpsSys_2_1;

/****************************************************************/
typedef struct typprmupssys_3_1
/* Objet : Parametre de SupprimerFichier(NomFichier:Nul Ou      */
/* Caractere)                                                   */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomFichier : Nul Ou Caractere. */
} TypPrmUpsSys_3_1;

/****************************************************************/
typedef struct typprmupssys_4_1
/* Objet : Parametre de SupprimerRepertoire(NomRepertoire:Nul Ou*/
/* Caractere)                                                   */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomRepertoire : Nul Ou Caractere. */
} TypPrmUpsSys_4_1;

/****************************************************************/
typedef struct typprmupssys_5_1
/* Objet : Parametre de ChangerRepertoireCourant(NomRepertoire: */
/* Nul Ou Caractere)                                            */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomRepertoire : Nul Ou Caractere. */
} TypPrmUpsSys_5_1;

/****************************************************************/
typedef struct typprmupssys_7_1
/* Objet : Parametre de RenommerFichier(FichierDepart:Caractere */
/* Ou Nul, FichierArrive:Caractere Ou Nul)                      */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* FichierDepart : Nul Ou Caractere. */
TypUpsVmAdresse UpsVar2;
   /* FichierArrivee : Nul Ou Caractere. */
} TypPrmUpsSys_7_1;

/****************************************************************/
typedef struct typprmupssys_8_1
/* Objet : Parametre de RenommerRepertoire(RepertoireDepart:    */
/* Caractere Ou Nul, RepertoireArrive:Caractere Ou Nul)         */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* RepertoireDepart : Nul Ou Caractere. */
TypUpsVmAdresse UpsVar2;
   /* RepertoireArrive : Nul Ou Caractere. */
} TypPrmUpsSys_8_1;

/****************************************************************/
typedef struct typprmupssys_9_1
/* Objet : Parametre de ChangerPriorite(Priorite:Entier)        */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Cle : Nul Ou Caractere. */
} TypPrmUpsSys_9_1;

/****************************************************************/
typedef struct typprmupssys_11_1
/* Objet : Parametre de ChangerDroitDAcces(NomFichier:Nul Ou    */
/* Caractere, DroitsUtilisateur:DroitsDAcces, DroitsGroupe:     */
/* DroitsDAcces, DroitsAutres:DroitsDAcces)                     */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomFichier : Nul Ou Caractere. */
TypUpsVmUnsignedChar UpsVar2;
   /* DroitsUtilisateur:DroitsDAcces. */
TypUpsVmUnsignedChar UpsVar3;
   /* DroitsGroupe:DroitsDAcces. */
TypUpsVmUnsignedChar UpsVar4;
   /* DroitsAutres:DroitsDAcces. */
} TypPrmUpsSys_11_1;

/****************************************************************/
typedef struct typprmupssys_12_1
/* Objet : Parametre de LireDroitDAcces(NomFichier:Nul Ou       */
/* Caractere, DroitsGroupe:Nul Ou DroitsDAcces Sortie,          */
/* DroitsAutres:Nul Ou DroitsDAcces Sortie)                     */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomFichier : Nul Ou Caractere. */
TypUpsVmAdresse UpsVar2;
   /* DroitsGroupe:DroitsDAcces. */
TypUpsVmAdresse UpsVar3;
   /* DroitsAutres:DroitsDAcces. */
} TypPrmUpsSys_12_1;

/****************************************************************/
typedef struct typprmupssys_15_1
/* Objet : Parametre de Alarme(Traitement:Procedure (),         */
/* DelaiEnSecondes:Entier, Periodique:Booleen)                  */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Traitement : Procedure (). */
TypUpsVmLong UpsVar2;
   /* DelaiEnSecondes:Entier. */
TypUpsVmUnsignedChar UpsVar3;
   /* Periodique:Booleen. */
} TypPrmUpsSys_15_1;

/****************************************************************/
typedef struct typprmupssys_16_1
/* Objet : Parametre de Attendre(DelaiEnSecondes:Reel)          */
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* DelaiEnSecondes:Reel. */
} TypPrmUpsSys_16_1;

/****************************************************************/
typedef struct typprmupssys_17_1
/* Objet : Parametre de BornerRepertoire(NomRepertoire:Nul Ou   */
/* Caractere)                                                   */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomRepertoire:Nul Ou Caractere. */
} TypPrmUpsSys_17_1;

/****************************************************************/
typedef struct typprmupssys_18_1
/* Objet : Executer(Commande:Nul Ou Caractere, Synchroniser:    */
/* Booleen, Cacher:Booleen, NumeroProcessusFils:Entier Sortie,  */
/* RepertoireInitial:Nul Ou Caractere=Nul, EcrireEntree:Nul Ou  */
/* Fonction() Retourner Nul Ou Caractere=Nul, LireSortie:Nul Ou */
/* Procedure(M:Caractere)=Nul) Retourner Entier.                */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomFichierDuProgramme:Nul Ou Caractere. */
TypUpsVmUnsignedChar UpsVar2;
   /* Synchroniser:Booleen. */
TypUpsVmUnsignedChar UpsVar3;
   /* Cacher:Booleen. */
TypUpsVmLong UpsVar4;
   /* NumeroProcessusFils. */
TypUpsVmAdresse UpsVar5;
   /* RepertoireInitial:Nul Ou Caractere. */
TypUpsVmAdresse UpsVar6;
   /* EcrireEntree:Nul Ou Fonction() Retourner Nul Ou Caractere. */
TypUpsVmAdresse UpsVar7;
   /* LireSortie:Nul Ou Procedure(M:Caractere). */
} TypPrmUpsSys_18_1;

/****************************************************************/
typedef struct typprmupssys_19_1
/* Objet : Parametre de RechercherFichierDansChemin(NomFichier: */
/* Nul Ou Caractere, ListeDeRepertoires:Nul Ou Caractere)       */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomFichier:Nul Ou Caractere. */
TypUpsVmAdresse UpsVar2;
   /* ListeDeRepertoires:Nul Ou Caractere. */
TypUpsVmAdresse UpsVar3;
   /* ExtensionParDefaut:Nul Ou Caractere. */
} TypPrmUpsSys_19_1;

/****************************************************************/
typedef struct typprmupssys_20_1
/* Objet : Parametre de LireCaracteristiquesFichier(NomFichier: */
/* Nul Ou Caractere)                                            */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomFichier:Nul Ou Caractere. */
} TypPrmUpsSys_20_1;

/****************************************************************/
typedef struct typprmupssys_20_2
/* Objet : Parametre de LireCaracteristiquesFichier(NomFichier: */
/* Nul Ou Caractere, UtilisateurProprietaire:Entier Sortie,     */
/* GroupeProprietaire:Entier Sortie, DateDernierAcces:Date      */
/* Sortie, DateDerniereModification:Date Sortie, DateCreation:  */
/* Date Sortie, EstCache:Booleen Sortie)                        */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomFichier:Nul Ou Caractere. */
TypUpsVmLong UpsVar2;
   /* UtilisateurProprietaire:Entier. */
TypUpsVmLong UpsVar3;
   /* GroupeProprietaire:Entier. */
TypUpsVmAdresse UpsVar4;
   /* DateDernierAcces:Date. */
TypUpsVmAdresse UpsVar5;
   /* DateDerniereModification:Date. */
TypUpsVmAdresse UpsVar6;
   /* DateCreation:Date. */
TypUpsVmUnsignedChar UpsVar7;
   /* EstCache:Booleen. */
} TypPrmUpsSys_20_2;

/****************************************************************/
typedef struct typprmupssys_21_1
/* Objet : Parametre de ListerFichier(NomRepertoire:Nul Ou      */
/* Caractere, Filtre:Nul Ou Caractere)                          */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomRepertoire:Nul Ou Caractere. */
TypUpsVmAdresse UpsVar2;
   /* Filtre:Nul Ou Caractere. */
} TypPrmUpsSys_21_1;

/****************************************************************/
typedef struct typprmupssys_23_1
/* Objet : Parametre de CopierFichier(FichierDepart:Caractere   */
/* Ou Nul, FichierArrive:Caractere Ou Nul)                      */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* FichierDepart : Nul Ou Caractere. */
TypUpsVmAdresse UpsVar2;
   /* FichierArrivee : Nul Ou Caractere. */
} TypPrmUpsSys_23_1;

/****************************************************************/
typedef struct typprmupssys_24_1
/* Objet : Parametre de CopierRepertoire(RepertoireDepart:      */
/* Caractere Ou Nul, RepertoireArrive:Caractere Ou Nul)         */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* RepertoireDepart : Nul Ou Caractere. */
TypUpsVmAdresse UpsVar2;
   /* RepertoireArrive : Nul Ou Caractere. */
} TypPrmUpsSys_24_1;

/****************************************************************/
typedef struct typprmupssys_25_1
/* Objet : Parametre de IlExisteFichier(NomFichier:Nul Ou       */
/* Caractere) Retourner Booleen.                                */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomFichier : Nul Ou Caractere. */
} TypPrmUpsSys_25_1;

/****************************************************************/
typedef struct typprmupssys_26_1
/* Objet : Parametre de IlExisteRepertoire(NomFichier:Nul Ou    */
/* Caractere) Retourner Booleen.                                */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomRepertoire : Nul Ou Caractere. */
} TypPrmUpsSys_26_1;

/****************************************************************/
typedef struct typprmupssys_27_1
/* Objet : Parametre de ListerUnites(Filtre:Nul Ou Caractere)   */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Filtre:Nul Ou Caractere. */
} TypPrmUpsSys_27_1;

/****************************************************************/
typedef struct typprmupssys_28_1
/* Objet : Parametre de Procedure ArreterProcessus(             */
/* NumeroProcessus:Entier)                                      */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* NumeroProcessus:Entier. */
} TypPrmUpsSys_28_1;

/****************************************************************/
typedef struct typprmupssys_29_1
/* Objet : Fonction LireCodeRetour(NumeroProcessus:Entier,      */
/* CodeRetour:Entier Sortie) Retourner Booleen                  */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* NumeroProcessus:Entier. */
TypUpsVmLong UpsVar2;
   /* CodeRetour:Entier. */
} TypPrmUpsSys_29_1;

/****************************************************************/
typedef struct typprmupssys_30_1
/* Objet : Fonction LireTempsProcessus(TempsSysteme:Date Sortie)*/
/* Retourner Reel;                                              */
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* TempsSysteme : Reel. */
} TypPrmUpsSys_30_1;

/****************************************************************/
typedef struct typprmupssys_31_1
/* Objet : LireEnvironnement(VariableEnvironnement:Caractere)   */
/* Retourner Nul Ou Caractere;                                  */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* VariableEnvironnement:Caractere. */
} TypPrmUpsSys_31_1;

/****************************************************************/
typedef struct typprmupssys_32_1
/* Objet : ChangerEnvironnement(VariableEnvironnement:Caractere,*/
/* Valeur:Nul Ou Caractere);                                    */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* VariableEnvironnement:Caractere. */
TypUpsVmAdresse UpsVar2;
   /* Valeur:Nul Ou Caractere. */
} TypPrmUpsSys_32_1;

/****************************************************************/
typedef struct typprmupssys_34_1
/* Objet : CommuterInstance(I:Entier)                           */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* I:Entier. */
} TypPrmUpsSys_34_1;

/****************************************************************/
typedef struct typprmupssys_35_1
/* Objet : ArreterInstance(I:Entier)                            */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* I:Entier. */
} TypPrmUpsSys_35_1;

/****************************************************************/
typedef struct typprmupssys_36_1
/* Objet : DemarrerService(NomService:Caractere)                */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomService:Caractere. */
} TypPrmUpsSys_36_1;

/****************************************************************/
typedef struct typprmupssys_37_1
/* Objet : ArreterService(NomService:Caractere, ForcerArret:    */
/* Booleen)                                                     */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomService:Caractere. */
TypUpsVmUnsignedChar UpsVar2;
   /* ForcerArret:Booleen. */
} TypPrmUpsSys_37_1;

/****************************************************************/
typedef struct typprmupssys_38_1
/* Objet : ChercherService(NomService:Caractere)                */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomService:Caractere. */
} TypPrmUpsSys_38_1;

/****************************************************************/
typedef struct typprmupssys_39_1
/* Objet : LireParametre(M:Module, NomDeParametre:Caractere,    */
/* NomDeLaSection:Caractere, Valeur:Booleen Sortie) Retourner   */
/* Booleen                                                      */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* M:Module. */
TypUpsVmAdresse UpsVar2;
   /* NomDeParametre:Caractere. */
TypUpsVmAdresse UpsVar3;
   /* NomDeLaSection:Caractere. */
TypUpsVmUnsignedChar UpsVar4;
   /* Valeur:Booleen. */
} TypPrmUpsSys_39_1;

/****************************************************************/
typedef struct typprmupssys_39_2
/* Objet : LireParametre(M:Module, NomDeParametre:Caractere,    */
/* NomDeLaSection:Caractere, Valeur:Entier Sortie) Retourner    */
/* Booleen                                                      */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* M:Module. */
TypUpsVmAdresse UpsVar2;
   /* NomDeParametre:Caractere. */
TypUpsVmAdresse UpsVar3;
   /* NomDeLaSection:Caractere. */
TypUpsVmLong UpsVar4;
   /* Valeur:Entier. */
} TypPrmUpsSys_39_2;

/****************************************************************/
typedef struct typprmupssys_39_3
/* Objet : LireParametre(M:Module, NomDeParametre:Caractere,    */
/* NomDeLaSection:Caractere, Valeur:Reel Sortie) Retourner      */
/* Booleen                                                      */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* M:Module. */
TypUpsVmAdresse UpsVar2;
   /* NomDeParametre:Caractere. */
TypUpsVmAdresse UpsVar3;
   /* NomDeLaSection:Caractere. */
TypUpsVmDouble UpsVar4;
   /* Valeur:Reel. */
} TypPrmUpsSys_39_3;

/****************************************************************/
typedef struct typprmupssys_39_4
/* Objet : LireParametre(M:Module, NomDeParametre:Caractere,    */
/* NomDeLaSection:Caractere, Valeur:Caractere Sortie) Retourner */
/* Booleen                                                      */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* M:Module. */
TypUpsVmAdresse UpsVar2;
   /* NomDeParametre:Caractere. */
TypUpsVmAdresse UpsVar3;
   /* NomDeLaSection:Caractere. */
TypUpsVmAdresse UpsVar4;
   /* Valeur:Caractere. */
} TypPrmUpsSys_39_4;

/****************************************************************/
typedef struct typprmupssys_39_5
/* Objet : LireParametre(M:Module, NomDeParametre:Caractere,    */
/* NomDeLaSection:Caractere, Valeur:Date Sortie) Retourner      */
/* Booleen                                                      */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* M:Module. */
TypUpsVmAdresse UpsVar2;
   /* NomDeParametre:Caractere. */
TypUpsVmAdresse UpsVar3;
   /* NomDeLaSection:Caractere. */
TypUpsVmAdresse UpsVar4;
   /* Valeur:Date. */
} TypPrmUpsSys_39_5;

/****************************************************************/
typedef struct typprmupssys_40_1
/* Objet : Procedure EnvoyerExceptionAToutesLesTaches(E:Nul Ou  */
/* Exception, P1:Nul Ou Caractere=Nul, P2:Nul Ou Caractere=Nul, */
/* P3:Nul Ou Caractere=Nul, P4:Nul Ou Caractere=Nul, P5:Nul Ou  */
/* Caractere=Nul);                                              */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E:Nul Ou Exception. */
TypUpsVmAdresse UpsVar2;
   /* P1:Nul Ou Caractere. */
TypUpsVmAdresse UpsVar3;
   /* P2:Nul Ou Caractere. */
TypUpsVmAdresse UpsVar4;
   /* P3:Nul Ou Caractere. */
TypUpsVmAdresse UpsVar5;
   /* P4:Nul Ou Caractere. */
TypUpsVmAdresse UpsVar6;
   /* P5:Nul Ou Caractere. */
} TypPrmUpsSys_40_1;

/****************************************************************/
typedef struct typprmupssys_41_1
/* Objet : Fonction ExtraireNomFichier(NomFichierComplet:Nul Ou */
/* Caractere) Retourner Nul Ou Caractere;                       */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomFichierComplet:Nul Ou Caractere. */
} TypPrmUpsSys_41_1;

/****************************************************************/
typedef struct typprmupssys_42_1
/* Objet : Fonction ExtraireNomRepertoire(NomFichierComplet:Nul */
/* Ou Caractere) Retourner Nul Ou Caractere;                    */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomFichierComplet:Nul Ou Caractere. */
} TypPrmUpsSys_42_1;

typedef TypUpsVmUnicode UpsVmAPI (*TypUpsSysAnalyserChaine)(TypUpsVmPointeurDonnees Handle);

/*******************************************************************/
typedef struct typupssyssystemedefichiersinterface_1_1_0
/* Objet : Interface avec le systeme de fichiers pour Up ! System. */ 
/*******************************************************************/
{
/*--------------------------------------------------------------*/
/* API pour le systeme de fichiers.                             */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*ListerUnites)(TypUpsVmSession *Session, TypUpsVmShort PremiereFois, TypUpsVmUnicode *NomUnite, TypUpsVmLong TailleNomUnite,
   TypUpsVmShort *TypeUnite, TypUpsVmDouble *PlaceLibre, TypUpsVmDouble *PlaceTotale);
   /* Objet : Liste les unites disponibles. */
TypUpsVmShort UpsVmAPI (*LireInformations)(TypUpsVmSession *Session, TypUpsVmUnicode *NomFichier,  TypUpsVmDateEtHeure *DateCreation, TypUpsVmDateEtHeure *DateDerniereModification, 
   TypUpsVmDateEtHeure *DateDernierAcces, TypUpsVmShort *EstUnRepertoire, TypUpsVmUnsignedLong *Taille, TypUpsVmShort *EstCache);
   /* Objet : Informations sur un fichier ou un repertoire. */ 
TypUpsVmShort (*ChangerDroitsDAcces)(TypUpsVmSession *Session, TypUpsVmUnicode *NomFichier, TypUpsVmShort Utilisateur, TypUpsVmShort Groupe, TypUpsVmShort Autre);
   /* Objet : Change les droits d'acces d'un fichier ou d'un repertoire. */
TypUpsVmShort UpsVmAPI (*LireDroitsDAcces)(TypUpsVmSession *Session, TypUpsVmUnicode *NomFichier, TypUpsVmShort *Groupe, TypUpsVmShort *Autre);
   /* Objet : Lit les droits d'acces du fichier ou du repertoire. */
TypUpsVmVoid UpsVmAPI (*Synchroniser)(TypUpsVmVoid);
   /* Objet : Synchronise les disques. */
TypUpsVmShort UpsVmAPI (*CreerUnRaccourci)(TypUpsVmSession *Session, TypUpsVmUnicode *NomInitial, TypUpsVmUnicode *NomRaccourci);
   /* Objet : Cree un raccourci. */
TypUpsVmShort UpsVmAPI (*MonterUnVolumeAmovible)(TypUpsVmSession *Session, TypUpsVmUnicode *NomDuVolume, TypUpsVmUnicode *PointDeMontage);
   /* Objet : Monte un volume amovible. */
TypUpsVmShort UpsVmAPI (*DemonterUnVolumeAmovible)(TypUpsVmSession *Session, TypUpsVmUnicode *NomDuVolume, TypUpsVmUnicode *PointDeMontage);
   /* Objet : Demonte un volume amovible. */
/*--------------------------------------------------------------*/
/* API pour les repertoires.                                    */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*CreerRepertoire)(TypUpsVmSession *Session, TypUpsVmUnicode *Fichier);
   /* Objet : Cree un repertoire. */
TypUpsVmShort UpsVmAPI (*EffacerRepertoire)(TypUpsVmSession *Session, TypUpsVmUnicode *Fichier);
   /* Objet : Efface un repertoire. */
TypUpsVmShort UpsVmAPI (*ChangerRepertoire)(TypUpsVmSession *Session, TypUpsVmUnicode *Fichier);
   /* Objet : Change de repertoire. */
TypUpsVmUnicode UpsVmAPI *(*LireRepertoireCourant)(TypUpsVmSession *Session, TypUpsVmUnicode *Reponse, TypUpsVmLong TailleReponse);
   /* Objet : Change de repertoire. */
TypUpsVmShort UpsVmAPI (*RenommerRepertoire)(TypUpsVmSession *Session, TypUpsVmUnicode *AncienNom, TypUpsVmUnicode *NouveauNom);
   /* Objet : Renomme le repertoire. */
TypUpsVmUnicode UpsVmAPI *(*ListerFichiers)(TypUpsVmSession *Session, TypUpsVmUnicode *NomRepertoire, TypUpsVmShort PremiereFois, 
   TypUpsVmShort *EstUnRepertoire);
   /* Objet : Liste les fichiers d'un repertoire. */
TypUpsVmShort UpsVmAPI  (*IlExisteRepertoire)(TypUpsVmSession *Session, TypUpsVmUnicode *NomRepertoire);
   /* Objet : Retourne Vrai si le repertoire existe. */
TypUpsVmShort UpsVmAPI (*CopierRepertoire)(TypUpsVmSession *Session, TypUpsVmUnicode *NomRepertoireDepart, 
   TypUpsVmUnicode *NomRepertoireArrivee);
   /* Objet : Copie le repertoire et son contenu. */
TypUpsVmShort UpsVmAPI (*EstUnCheminAbsolu)(TypUpsVmUnicode *Chemin);
   /* Objet: Retourne Vrai si le chemin est absolu. */
/*--------------------------------------------------------------*/
/* API pour les fichiers.                                       */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*TraduireFichier)(TypUpsVmSession *Session, TypUpsVmUnicode *Fichier, TypUpsVmUnicode *FichierTraduit, 
   TypUpsVmLong TailleFichierTraduit, TypUpsVmShort PourUneInclusion);
   /* Objet : Traduit les separateurs de repertoires. */
TypUpsVmShort UpsVmAPI (*Ouvrir)(TypUpsVmSession *Session, TypUpsVmFlux *Descripteur, TypUpsVmUnicode *NomFichier, TypUpsVmUnicode *Masque, 
   enum EnuUpsVmTailleBuffer TailleBuffer);
   /* Objet : Ouvre le fichier. */
TypUpsVmShort UpsVmAPI (*EffacerFichier)(TypUpsVmSession *Session, TypUpsVmUnicode *NomFichier);
   /* Objet : Efface un fichier. */
TypUpsVmShort UpsVmAPI (*RenommerFichier)(TypUpsVmSession *Session, TypUpsVmUnicode *AncienNom, TypUpsVmUnicode *NouveauNom);
   /* Objet : Renomme le fichier. */
TypUpsVmShort UpsVmAPI  (*IlExisteFichier)(TypUpsVmSession *Session, TypUpsVmUnicode *NomFichier);
   /* Objet : Retourne Vrai si le fichier existe. */
TypUpsVmShort UpsVmAPI (*CopierFichier)(TypUpsVmSession *Session, TypUpsVmUnicode *AncienNom, 
   TypUpsVmUnicode *NouveauNom);
   /* Objet : Copie le fichier. */
TypUpsVmVoid UpsVmAPI (*AjouterExtension)(TypUpsVmUnicode *NomFichier, TypUpsVmUnicode *Extension);
   /* Objet : Ajoute l'extension au nom du fichier si necessaire. */
TypUpsVmVoid UpsVmAPI (*SupprimerExtension)(TypUpsVmUnicode *NomFichier);
   /* Objet : Supprimer l'extension du nom du fichier. */
TypUpsVmVoid UpsVmAPI (*RemplacerExtension)(TypUpsVmUnicode *NomFichier, TypUpsVmUnicode *Extension);
   /* Objet : Remplace l'extension au nom du fichier. */
} *TypUpsSysSystemeDeFichiersInterface_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsSysSystemeDeFichiersInterface_1_1_0 TypUpsSysSystemeDeFichiersInterface;

/*******************************************************************/
typedef struct typupssysmachineinterface_1_1_0
/* Objet : Interface avec la machine pour Up ! System.             */ 
/*******************************************************************/
{
/*--------------------------------------------------------------*/
/* Posix.                                                       */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*RetourInterAppel)(TypUpsVmRegistres Registres, TypUpsVmShort CodeRetour);
   /* Objet : Saut inter appels. */
TypUpsVmLong UpsVmAPI (*DateEnSecondes)(TypUpsVmVoid);
   /* Objet : Lecture de la date systeme en secondes. */
TypUpsVmVoid UpsVmAPI (*DateEtHeure)(TypUpsVmDateEtHeure *Date);
   /* Objet : Renvoie la date et l'heure courante. */
TypUpsVmShort UpsVmAPI (*DecoderShort)(TypUpsVmShort ValeurDepart);
   /* Objet : Permute les octets. */
TypUpsVmUnsignedShort UpsVmAPI (*DecoderUnsignedShort)(TypUpsVmUnsignedShort ValeurDepart);
   /* Objet : Permute les octets. */
TypUpsVmLong UpsVmAPI (*DecoderLong)(TypUpsVmLong ValeurDepart);
   /* Objet : Permute les octets. */
TypUpsVmUnsignedLong UpsVmAPI (*DecoderUnsignedLong)(TypUpsVmUnsignedLong ValeurDepart);
   /* Objet : Permute les octets. */
TypUpsVmPointeurDonnees UpsVmAPI (*AllouerMemoire)(TypUpsVmSession *Session, TypUpsVmUnicode *LibelleAppel, TypUpsVmLong Taille);
   /* Objet : Alloue de la memoire privee au processus. */
TypUpsVmPointeurDonnees UpsVmAPI (*ReallouerMemoire)(TypUpsVmSession *Session, TypUpsVmUnicode *LibelleAppel, TypUpsVmPointeurDonnees Adresse, 
   TypUpsVmLong AncienneTaille, TypUpsVmLong NouvelleTaille);
   /* Objet : Realloue de la memoire privee au processus. */
TypUpsVmVoid UpsVmAPI (*LibererMemoire)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Adresse);
   /* Objet : Effectue une desallocation. */
TypUpsSysSystemeDeFichiersInterface SystemeDeFichiersInterface;
   /* Objet : Interface avec le systeme de fichiers pour Up ! System. */ 
/*--------------------------------------------------------------*/
/* Contexte.                                                    */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*LirePageDeCodeSysteme)(TypUpsVmUnicode *PageDeCode, TypUpsVmLong TaillePageDeCode);
   /* Objet : Lit la page de code systeme. */
TypUpsVmUnicode UpsVmAPI *(*RepertoireInstallationSysteme)(TypUpsVmUnicode *Repertoire, TypUpsVmLong TailleRepertoire);
   /* Objet : Retourne le repertoire d'installation du systeme. */
TypUpsVmUnicode UpsVmAPI *(*LireEnvironnement)(TypUpsVmUnicode *NomVariable, TypUpsVmUnicode *Valeur, TypUpsVmLong TailleValeur);
   /* Objet : Lit une variable environnement. */
TypUpsVmShort UpsVmAPI (*ChangerEnvironnement)(TypUpsVmUnicode *NomVariable, TypUpsVmUnicode *Valeur);
   /* Objet : Modifie une variable environnement. */
TypUpsVmShort UpsVmAPI (*LireInformationsSystemeDExploitation)(TypUpsVmUnicode *NomDuSysteme, TypUpsVmLong TailleNomDuSysteme, TypUpsVmUnicode *NomDuNoeud, 
   TypUpsVmLong TailleNomDuNoeud, TypUpsVmUnicode *Version, TypUpsVmLong TailleVersion, TypUpsVmUnicode *Revision, 
   TypUpsVmLong TailleRevision, TypUpsVmUnicode *PlateForme, TypUpsVmLong TaillePlateForme);
   /* Objet : Recupere les informations sur le systeme d'exploitation. */
TypUpsVmShort UpsVmAPI (*LireNomUtilisateur)(TypUpsVmUnicode *NomUtilisateur, TypUpsVmLong TailleNomUtilisateur);
   /* Objet : Renvoie le nom de l'utilisateur. */
TypUpsVmShort UpsVmAPI (*LireNomGroupe)(TypUpsVmUnicode *NomGroupe, TypUpsVmLong TailleNomGroupe);
   /* Objet : Retourne le nom du groupe. */
TypUpsVmLong UpsVmAPI (*LireNumeroGroupe)(TypUpsVmVoid);
   /* Objet : Renvoie le numero de groupe. */
TypUpsVmLong UpsVmAPI (*LireNumeroUtilisateur)(TypUpsVmVoid);
   /* Objet : Renvoie le numero d'utilisateur. */
TypUpsVmLong UpsVmAPI (*LireCodeErreur)(TypUpsVmUnicode *MessageErreur, TypUpsVmLong TailleMessageErreur);
   /* Objet : Renvoie le code erreur du dernier appel systeme. */
TypUpsVmShort UpsVmAPI (*FermerSession)(TypUpsVmVoid);
   /* Objet : Ferme la session de l'utilisateur. */
TypUpsVmShort UpsVmAPI (*ArreterSysteme)(TypUpsVmVoid);
   /* Objet : Arrete le systeme. */
TypUpsVmShort UpsVmAPI (*RelancerSysteme)(TypUpsVmVoid);
   /* Objet : Relance le systeme. */
TypUpsVmShort UpsVmAPI (*ArreterProgramme)(TypUpsVmShort Forcer);
   /* Objet : Arrete le programme. */
TypUpsVmShort UpsVmAPI (*RelancerProgramme)(TypUpsVmUnicode *ParametresRelancer);
   /* Objet : Relance le programme. */
/*--------------------------------------------------------------*/
/* Taches.                                                      */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*Executer)(TypUpsVmSession *Session, TypUpsVmUnicode *Commande, TypUpsVmUnicode *RepertoireInitial,
   TypUpsVmShort Cacher, TypUpsVmShort Synchroniser, TypUpsVmLong *NumeroProcessusFils, TypUpsVmLong *CodeRetour,
   TypUpsVmFonctionObjetSansParametre EcrireEntree, TypUpsVmAdresse *AdresseObjetEcrireEntree, 
   TypUpsVmProcedureAvecParametre LireSortie, TypUpsVmAdresse *AdresseObjetLireSortie);
   /* Objet : Execute un nouveau programme. */
TypUpsVmLong UpsVmAPI (*ListerProcessus)(TypUpsVmSession *Session, TypUpsVmShort PremiereFois, TypUpsVmLong *Priorite,
   TypUpsVmDouble *TempsEcoule,  TypUpsVmDouble *TempsSysteme,  TypUpsVmDouble *TempsUser, 
   TypUpsVmUnicode *NomProgramme, TypUpsVmLong TailleNomProgramme);
   /* Objet : Liste les processus. */
TypUpsVmShort (*ChangerPrioriteProcessus)(TypUpsVmShort Priorite, TypUpsVmShort PrioriteRelative);
   /* Objet : Change la priorite du processus. */
TypUpsVmShort (*LirePrioriteProcessus)(TypUpsVmShort *PrioriteRelative);
   /* Objet : Lit la priorite du processus. */
TypUpsVmShort UpsVmAPI (*ArreterProcessus)(TypUpsVmLong NumeroProcessus);
   /* Objet : Arrete un processus. */
TypUpsVmLong UpsVmAPI (*LireNumeroProcessus)(TypUpsVmVoid);
   /* Objet : Renvoie le numero de processus. */
TypUpsVmShort UpsVmAPI (*LireCodeRetourProcessus)(TypUpsVmLong NumeroProcessus, TypUpsVmLong *CodeRetour, TypUpsVmShort *CodeRetourDisponible);
   /* Objet : Lit le code retour d'un processus. */
TypUpsVmShort UpsVmAPI (*LireTempsProcessus)(TypUpsVmDouble *TempsSysteme, TypUpsVmDouble *TempsUser);
   /* Objet : Lit les temps d'execution du processus. */
TypUpsVmVoid UpsVmAPI (*GererSignaux)(TypUpsVmShort Proteger);
   /* Objet : Genere les signaux recus par le thread. */
TypUpsVmLong UpsVmAPI (*CreerThread)(TypUpsVmSession *Session, TypUpsVmPrincipalThread PrincipalThread, TypUpsVmAdresse *AdresseObjetTache,
   TypUpsVmPointeurDonnees Parametre, TypUpsVmShort Lancer);
   /* Objet : Cree un nouveau thread. */
TypUpsVmShort UpsVmAPI (*SuspendreExecutionThread)(TypUpsVmSession *Session);
   /* Objet : Suspend l'execution du thread. */
TypUpsVmShort UpsVmAPI (*ReprendreExecutionThread)(TypUpsVmSession *Session, TypUpsVmLong NumeroThread);
   /* Objet : Repend l'execution du thread. */
TypUpsVmShort UpsVmAPI (*LireEtatSuspensionThread)(TypUpsVmSession *Session, TypUpsVmLong NumeroThread);
   /* Objet : Retourne Vrai si le thread est suspendu. */
TypUpsVmLong UpsVmAPI (*ArreterThread)(TypUpsVmSession *Session, TypUpsVmLong NumeroThread);
   /* Objet : Arreter thread. */
TypUpsVmLong UpsVmAPI (*LireNumeroThread)(TypUpsVmVoid);
   /* Objet : Renvoie le numero de thread. */
TypUpsVmShort UpsVmAPI (*ThreadEstEnVie)(TypUpsVmSession *Session, TypUpsVmLong NumeroThread);
   /* Objet : Retourne Vrai si le thread est en vie. */
TypUpsVmVoid (*CommuterThreads)(TypUpsVmVoid);
   /* Objet : Commute le thread. */
TypUpsVmShort (*DemarrerService)(TypUpsVmSession *Session, TypUpsVmUnicode *NomService);
   /* Objet : Demarre un service. */
TypUpsVmShort (*ArreterService)(TypUpsVmSession *Session, TypUpsVmUnicode *NomService, TypUpsVmShort Forcer);
   /* Objet : Arrete un service. */
TypUpsVmShort (*ChercherService)(TypUpsVmSession *Session, TypUpsVmUnicode *NomService);
   /* Objet : Cherche un service. */
TypUpsVmVoid UpsVmAPI (*Attendre)(TypUpsVmSession *Session, TypUpsVmLong Temps);
   /* Objet : Suspend le processus pour un certain nombre de secondes. */
/*--------------------------------------------------------------*/
/* Verrous.                                                     */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*DebuterSectionCritique)(TypUpsVmSession *Session, enum EnuUpsSysSectionCritique Numero);
   /* Objet : Debut d'une section critique. */ 
TypUpsVmShort UpsVmAPI (*TerminerSectionCritique)(TypUpsVmSession *Session, enum EnuUpsSysSectionCritique Numero);
   /* Objet : Fin d'une section critique. */ 
TypUpsVmShort UpsVmAPI (*EstEnSectionSectionCritiqueSaufException)(TypUpsVmSession *Session);
   /* Objet : Retourne Vrai si la tache est en session section critique sauf pour SC_Exception. */ 
/*--------------------------------------------------------------*/
/* Fichiers.                                                    */
/*--------------------------------------------------------------*/
TypUpsVmFlux UpsVmAPI *(*LireSortieStandard)(TypUpsVmVoid);
   /* Objet : Lit le flux associe a l'ecran. */
TypUpsVmFlux UpsVmAPI *(*LireErreurStandard)(TypUpsVmVoid);
   /* Objet : Lit le flux associe a la sortie d'erreur. */
TypUpsVmFlux UpsVmAPI *(*LireEntreeStandard)(TypUpsVmVoid);
   /* Objet : Lit le flux associe au clavier. */
TypUpsVmVoid UpsVmAPI (*Imprimer)(TypUpsVmSession *Session, TypUpsVmUnicode *SpoolImpression);
   /* Objet : Imprime le fichier.  */
TypUpsVmVoid UpsVmAPI (*EffacerEcran)(TypUpsVmSession *Session);
   /* Objet : Efface l'ecran. */
TypUpsVmVoid UpsVmAPI (*SynchroniserEcran)(TypUpsVmSession *Session);
   /* Objet : Synchronise l'affichage de l'ecran. */
/*--------------------------------------------------------------*/
/* Services pour Up ! Object Management System.                 */
/*--------------------------------------------------------------*/
TypUpsVmPointeurDonnees UpsVmAPI (*AllouerMemoirePartagee)(TypUpsVmSession *Session, TypUpsVmUnicode *NomMemoire, TypUpsVmShort Creer, 
   TypUpsVmLong Taille, TypUpsVmLong *NumeroMemoire);
   /* Objet : Cree ou retrouve une memoire partagee. */
TypUpsVmShort UpsVmAPI (*LibererMemoirePartagee)(TypUpsVmSession *Session, TypUpsVmLong NumeroMemoire);
   /* Objet : Libere une memoire partagee. */
TypUpsVmLong UpsVmAPI (*AllouerMutex)(TypUpsVmSession *Session, TypUpsVmUnicode *NomMutex, TypUpsVmShort PourUneQueue); 
   /* Objet : Cree ou retrouve un mutex. */
TypUpsVmShort UpsVmAPI (*LibererMutex)(TypUpsVmSession *Session, TypUpsVmLong NumeroMutex);
   /* Objet : Libere un mutex. */
TypUpsVmShort UpsVmAPI (*PrendreMutex)(TypUpsVmSession *Session, TypUpsVmLong NumeroMutex, TypUpsVmLong TempsDeGarde);
   /* Objet : Actionne le mutex et dort au besoin. */
TypUpsVmShort UpsVmAPI (*RemettreMutex)(TypUpsVmSession *Session, TypUpsVmLong NumeroMutex);
   /* Objet : Actionne le mutex. */
TypUpsVmLong UpsVmAPI (*AllouerSemaphore)(TypUpsVmSession *Session, TypUpsVmUnicode *NomSemaphore, TypUpsVmShort Creer, TypUpsVmShort PourUneQueue);
   /* Objet : Cree ou retrouve une memoire partagee. */
TypUpsVmShort UpsVmAPI (*LibererSemaphore)(TypUpsVmSession *Session, TypUpsVmLong NumeroSemaphore);
   /* Objet : Libere un semaphore. */
TypUpsVmShort UpsVmAPI (*PrendreJetonSemaphore)(TypUpsVmSession *Session, TypUpsVmLong NumeroSemaphore, 
   TypUpsVmShort NumeroSousSemaphore, TypUpsVmLong TempsDeGarde);
   /* Objet : Actionne le semaphore et dort au besoin. */
TypUpsVmShort UpsVmAPI (*RemettreJetonSemaphore)(TypUpsVmSession *Session, TypUpsVmLong NumeroSemaphore, TypUpsVmShort NumeroSousSemaphore);
   /* Objet : Actionne le semaphore et dort au besoin. */
TypUpsVmVoid UpsVmAPI (*TransfererAffiliationSemaphoreEtMutex)(TypUpsVmSession *Session);
   /* Objet : Transfert l'affiliation des semaphores et des mutex de la session interne a la session principale. */
TypUpsVmVoid UpsVmAPI (*LibererRessourceSectionsCritiques)(TypUpsVmSession *Session);
   /* Objet : Libere les sections critiques posees par la session. */
/*--------------------------------------------------------------*/
/* Services pour Up ! Script Engine.                            */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*Invoquer)(TypUpsVmPointeurTraitements Appel, TypUpsVmShort NbParametres, TypUpsSysValeurC *TableParametresC, 
   enum EnuUpsSysSorteDonneeC SorteDonneeResultat, TypUpsSysValeurC *Resultat, enum EnuUpsSysSorteAppelC SorteAppelC);
   /* Objet : Invoque dynamiquement un appel natif. */
} *TypUpsSysMachineInterface_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsSysMachineInterface_1_1_0 TypUpsSysMachineInterface;

/****************************************************************/
typedef struct typupssysdonnees
/* Objet: Interface des donnees de Ups Sys.                     */
/****************************************************************/
{
struct typupsvmentetedonneesmodule EnteteDonneesModule;
   /* Entete generique du module. */

TypUpsVmUnicode UpsUser[CO_TailleIdf+1];
   /* Valeur de UPS_USER. */
TypUpsVmUnicode UpsProject[CO_TailleIdf+1];
   /* Valeur de UPS_PROJECT. */
TypUpsVmUnicode UpsDocument[CO_TailleNomFichier+1];
   /* Valeur de UPS_DOCUMENT. */
TypUpsVmUnicode NomProgramme[CO_TailleIdf+1];
   /* Nom du programme. */
TypUpsVmUnicode NomProgrammeAvecChemin[CO_TailleNomFichier+1];
   /* Nom du programme du programme avec le chemin d'acces. */
TypUpsVmUnicode SepRepertoire[CO_TailleIdf+1];
   /* Separateur de repertoires. */
TypUpsVmUnicode SepChemin[CO_TailleIdf+1];
   /* Separateur de chemins. */
TypUpsVmUnsignedChar PageDeCode;
   /* Page de code du systeme. */
TypUpsVmShort TracerRessources;
   /* Si Vrai, il faut tracer l'usage des ressources. */
TypUpsVmShort TracerObjets;
   /* Si Vrai, il faut tracer les utilisations des objets. */
/*--------------------------------------------------------------*/
/* Libelle des APIs frequentes dans la langue courante.         */
/*--------------------------------------------------------------*/
TypUpsVmUnicode *ActiverJournal;
   /* Libelle de ActiverJournal. */ 
TypUpsVmUnicode *AjouterPeriodeExclue;
   /* Libelle de AjouterPeriodeExclue. */ 
TypUpsVmUnicode *AjouterPeriodeIncluse;
   /* Libelle de AjouterPeriodeIncluse. */ 
TypUpsVmUnicode *ArreterInstance;
   /* Libelle de ArreterInstance. */ 
TypUpsVmUnicode *ArreterProcessus;
   /* Libelle de ArreterProcessus. */ 
TypUpsVmUnicode *ArreterService;
   /* Libelle de ArreterService. */ 
TypUpsVmUnicode *ArreterTache;
   /* Libelle de ArreterTache. */ 
TypUpsVmUnicode *Calendrier;
   /* Libelle de Calendrier. */ 
TypUpsVmUnicode *ChangerEnvironnement;
   /* Libelle de ChangerEnvironnement. */ 
TypUpsVmUnicode *ChangerPrioriteRelative;
   /* Libelle de ChangerPrioriteRelative. */ 
TypUpsVmUnicode *CommuterInstance;
   /* Libelle de CommuterInstance. */ 
TypUpsVmUnicode *CreerInstance;
   /* Libelle de CreerInstance. */ 
TypUpsVmUnicode *DemarrerService;
   /* Libelle de DemarrerService. */ 
TypUpsVmUnicode *EnvoyerException;
   /* Libelle de EnvoyerException. */ 
TypUpsVmUnicode *EnvoyerExceptionAToutesLesTaches;
   /* Libelle de EnvoyerExceptionAToutesLesTaches. */ 
TypUpsVmUnicode *Faux;
   /* Libelle de Faux. */ 
TypUpsVmUnicode *Fichier;
   /* Libelle de Fichier. */ 
TypUpsVmUnicode *FichierListe;
   /* Libelle de FichierListe. */ 
TypUpsVmUnicode *FileDAttente;
   /* Libelle de FileDAttente. */ 
TypUpsVmUnicode *IFlux;
   /* Libelle de IFlux. */ 
TypUpsVmUnicode *Non;
   /* Libelle de Non. */ 
TypUpsVmUnicode *Oui;
   /* Libelle de Oui. */ 
TypUpsVmUnicode *PeriodeCalendrier;
   /* Libelle de PeriodeCalendrier. */ 
TypUpsVmUnicode *PlanifierApres;
   /* Libelle de PlanifierApres. */ 
TypUpsVmUnicode *PlanifierAuPlusTard;
   /* Libelle de PlanifierAuPlusTard. */ 
TypUpsVmUnicode *PlanifierAuPlusTot;
   /* Libelle de PlanifierAuPlusTot. */ 
TypUpsVmUnicode *PlanifierPeriodiquement;
   /* Libelle de PlanifierPeriodiquement. */ 
TypUpsVmUnicode *ProcessusListe;
   /* Libelle de ProcessusListe. */ 
TypUpsVmUnicode *Reprendre;
   /* Libelle de Reprendre. */ 
TypUpsVmUnicode *ReprendreTache;
   /* Libelle de ReprendreTache. */ 
TypUpsVmUnicode *Segment;
   /* Libelle de Segment. */ 
TypUpsVmUnicode *Supprimer;
   /* Libelle de Supprimer. */ 
TypUpsVmUnicode *SupprimerPeriodeExclue;
   /* Libelle de SupprimerPeriodeExclue. */ 
TypUpsVmUnicode *SupprimerPeriodeIncluse;
   /* Libelle de SupprimerPeriodeIncluse. */ 
TypUpsVmUnicode *Suspendre;
   /* Libelle de Suspendre. */ 
TypUpsVmUnicode *SuspendreTache;
   /* Libelle de SuspendreTache. */ 
TypUpsVmUnicode *Synchronisation;
   /* Libelle de Synchronisation. */ 
TypUpsVmUnicode *Tache;
   /* Libelle de Tache. */ 
TypUpsVmUnicode *Travail;
   /* Libelle de Travail. */ 
TypUpsVmUnicode *UniteListee;
   /* Libelle de UniteListee. */ 
TypUpsVmUnicode *Vrai;
   /* Libelle de Vrai. */ 
} *TypUpsSysDonnees;

/****************************************************************/
/* Methodes d'une console.                    					    */
/****************************************************************/
typedef TypUpsVmShort UpsVmAPI (*TypUpsSysEcranEcrire)(TypUpsVmSession *Session, TypUpsVmUnicode *Buffer, TypUpsVmLong TailleAEcrire, TypUpsVmLong *TailleEcrite);
   /* Objet : Ecrit a l'ecran. */
typedef TypUpsVmVoid UpsVmAPI (*TypUpsSysEcranEffacer)(TypUpsVmSession *Session);
   /* Objet : Efface l'ecran. */
typedef TypUpsVmShort UpsVmAPI (*TypUpsSysEcranVider)(TypUpsVmSession *Session);
   /* Objet : Vide le buffer l'ecran. */
typedef TypUpsVmShort UpsVmAPI (*TypUpsSysClavierLire)(TypUpsVmSession *Session, TypUpsVmUnicode *Buffer, TypUpsVmLong TailleALire, TypUpsVmLong *TailleLue);
    /* Objet : Lit au clavier. */
typedef TypUpsVmVoid UpsVmAPI (*TypUpsSysAttenteActive)(TypUpsVmSession *Session);
   /* Objet : Realise une attente active. */
typedef TypUpsVmShort UpsVmAPI (*TypUpsSysImprimer)(TypUpsVmSession *Session, TypUpsVmUnicode *SpoolImpression);
   /* Objet : Imprime le fichier sur l'imprimante par defaut. */
typedef TypUpsVmShort UpsVmAPI (*TypUpsSysInitialiserEncapsulationKernel)(TypUpsVmVoid);
   /* Objet : Initialisation de l'extension de la console pour Ups Krn. */
typedef TypUpsVmVoid UpsVmAPI (*TypUpsSysTerminerEncapsulationKernel)(TypUpsVmVoid);
   /* Objet : Terminaison de l'extension de la console pour Ups Krn. */

/****************************************************************/
/* Operation sur les elements alloues en bloc. 					    */
/****************************************************************/
typedef TypUpsVmShort UpsVmAPI (*TypUpsSysOperationElementBloc)(TypUpsVmSession *Session, enum EnuUpsSysOperationElement Operation, 
   enum EnuUpsSysUtiliteElement UtiliteDemandee, TypUpsVmPointeurDonnees AdresseElement, TypUpsVmPointeurDonnees Parametre);
   /* Methode optionnelle realisant une operation sur un element. */
   
/****************************************************************/
/* Usage des objets.                           					    */
/****************************************************************/
/**********************/
#if defined(MISEAUPOINT)
/**********************/
#define UpsSysIncrementerUtilisationObjet(Module,Session,Nature,AdressePointant,AdressePointe,LibelleObjet,LibelleUtilisation,NbUtilisations) \
   (*Module##IntTrtUpsSys->IncrementerUtilisation)(Session,Nature,AdressePointant,AdressePointe,LibelleObjet,LibelleUtilisation,__WFILE__,__LINE__,&(NbUtilisations),NULL)
#define UpsSysIncrementerUtilisationObjet2(Module,Session,Nature,AdressePointant,AdressePointe,LibelleObjet,LibelleUtilisation,NbUtilisations,NbUtilisationsRecurrence) \
   (*Module##IntTrtUpsSys->IncrementerUtilisation)(Session,Nature,AdressePointant,AdressePointe,LibelleObjet,LibelleUtilisation,__WFILE__,__LINE__,&(NbUtilisations),&(NbUtilisationsRecurrence))
#define UpsSysDecrementerUtilisationObjet(Module,Session,Nature,AdressePointant,AdressePointe,LibelleObjet,LibelleUtilisation,NbUtilisations) \
   (*Module##IntTrtUpsSys->DecrementerUtilisation)(Session,Nature,AdressePointant,AdressePointe,LibelleObjet,LibelleUtilisation,__WFILE__,__LINE__,&(NbUtilisations),NULL)
#define UpsSysDecrementerUtilisationObjet2(Module,Session,Nature,AdressePointant,AdressePointe,LibelleObjet,LibelleUtilisation,NbUtilisations,NbUtilisationsRecurrence) \
   (*Module##IntTrtUpsSys->DecrementerUtilisation)(Session,Nature,AdressePointant,AdressePointe,LibelleObjet,LibelleUtilisation,__WFILE__,__LINE__,&(NbUtilisations),&(NbUtilisationsRecurrence))
/***/
#else
/***/
#define UpsSysIncrementerUtilisationObjet(Module,Session,Nature,AdressePointant,AdressePointe,LibelleObjet,LibelleUtilisation,NbUtilisations) \
   ++(NbUtilisations)
#define UpsSysIncrementerUtilisationObjet2(Module,Session,Nature,AdressePointant,AdressePointe,LibelleObjet,LibelleUtilisation,NbUtilisations,NbUtilisationsRecurrence) \
   ++(NbUtilisations)
#define UpsSysDecrementerUtilisationObjet(Module,Session,Nature,AdressePointant,AdressePointe,LibelleObjet,LibelleUtilisation,NbUtilisations) \
   --(NbUtilisations)
#define UpsSysDecrementerUtilisationObjet2(Module,Session,Nature,AdressePointant,AdressePointe,LibelleObjet,LibelleUtilisation,NbUtilisations,NbUtilisationsRecurrence) \
   --(NbUtilisations)
/****/
#endif
/****/

/****************************************************************/
typedef struct typupskrngestionconsole
/* Objet : Gestion d'une console.                               */
/****************************************************************/
{
TypUpsSysEcranEcrire EcranEcrire;
   /* Objet : Ecrit a l'ecran. */
TypUpsSysEcranEffacer EcranEffacer;
   /* Objet : Efface l'ecran. */
TypUpsSysEcranVider EcranVider;
   /* Objet : Vide le buffer de l'ecran. */
TypUpsSysClavierLire ClavierLire;
    /* Objet : Lit au clavier. */
TypUpsSysAttenteActive AttenteActive;
   /* Objet : Realise une attente active. */
TypUpsSysImprimer Imprimer;
   /* Objet : Imprime le fichier sur l'imprimante par defaut. */
TypUpsSysInitialiserEncapsulationKernel InitialiserEncapsulationKernel;
   /* Objet : Initialisation de l'extension de la console pour Ups Krn. */
TypUpsSysTerminerEncapsulationKernel TerminerEncapsulationKernel;
   /* Objet : Terminaison de l'extension de la console pour Ups Krn. */
} TypUpsSysGestionConsole;

/****************************************************************/
typedef struct typupssystraitements_1_1_0
/* Objet: Interface des traitements de Ups Sys.                 */
/****************************************************************/
{
struct typupsvmentetemethodesmodule EnteteMethodesModule;
   /* Methodes generiques au module. */ 

/*--------------------------------------------------------------*/
/* Procedures et fonctions.                                     */
/*--------------------------------------------------------------*/
TypUpsVmLong UpsVmAPI (*CalculerIndexAppel)(TypUpsVmPointeurDonnees InterfaceAppel, TypUpsVmPointeurDonnees AppelCourant);
   /* Objet : Calcule l'index de l'appel. */
TypUpsVmVoid UpsVmAPI (*Trt_1_1)(TypUpsVmSession *Session, TypPrmUpsSys_1_1 *UpsPrm);
   /* Objet : Procedure CreerFichier(NomFichier:Nul Ou Caractere). */
TypUpsVmVoid UpsVmAPI (*Trt_2_1)(TypUpsVmSession *Session, TypPrmUpsSys_2_1 *UpsPrm);
   /* Objet : Procedure CreerRepertoire(NomRepertoire:Nul Ou Caractere). */
TypUpsVmVoid UpsVmAPI (*Trt_3_1)(TypUpsVmSession *Session, TypPrmUpsSys_3_1 *UpsPrm);
   /* Objet : Procedure SupprimerFichier(NomFichier:Nul Ou Caractere). */
TypUpsVmVoid UpsVmAPI (*Trt_4_1)(TypUpsVmSession *Session, TypPrmUpsSys_4_1 *UpsPrm);
   /* Objet : Procedure SupprimerRepertoire(NomRepertoire:Nul Ou Caractere). */
TypUpsVmVoid UpsVmAPI (*Trt_5_1)(TypUpsVmSession *Session, TypPrmUpsSys_5_1 *UpsPrm);
   /* Objet : Procedure ChangerRepertoireCourant(NomRepertoire:Nul Ou Caractere). */
TypUpsVmAdresse UpsVmAPI *(*Trt_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsResultat);
   /* Objet : Fonction LireRepertoireCourant() Retourner Caractere. */
TypUpsVmVoid UpsVmAPI (*Trt_7_1)(TypUpsVmSession *Session, TypPrmUpsSys_7_1 *UpsPrm);
   /* Objet : Procedure RenommerFichier(FichierDepart:Caractere Ou Nul, FichierArrive:Caractere Ou Nul). */
TypUpsVmVoid UpsVmAPI (*Trt_8_1)(TypUpsVmSession *Session, TypPrmUpsSys_8_1 *UpsPrm);
   /* Objet : RenommerRepertoire(RepertoireDepart:Caractere Ou Nul, RepertoireArrive:Caractere Ou Nul). */
TypUpsVmVoid UpsVmAPI (*Trt_9_1)(TypUpsVmSession *Session, TypPrmUpsSys_9_1 *UpsPrm);
   /* Objet : Procedure ChangerPriorite(Priorite:Entier). */
TypUpsVmLong UpsVmAPI (*Trt_10_1)(TypUpsVmSession *Session);
   /* Objet : Fonction LirePriorite() Retourner Entier. */
TypUpsVmVoid UpsVmAPI (*Trt_11_1)(TypUpsVmSession *Session, TypPrmUpsSys_11_1 *UpsPrm);
   /* Objet : Procedure ChangerDroitDAcces(NomFichier,Nul Ou Caractere, DroitsUtilisateur:DroitsDAcces,
   DroitsGroupe:DroitsDAcces, DroitsAutres:DroitsDAcces) Implemente. */
TypUpsVmAdresse UpsVmAPI *(*Trt_12_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsResultat, TypPrmUpsSys_12_1 *UpsPrm);
   /* Objet : Fonction LireDroitDAcces(NomFichier,Nul Ou Caractere, DroitsGroupe:Nul Ou DroitsDAcces Sortie,
   DroitsAutres:Nul Ou DroitsDAcces Sortie) Retourner Nul Ou DroitsDAcces. */
TypUpsVmAdresse UpsVmAPI *(*Trt_13_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsResultat);
   /* Objet : Fonction DateSysteme() Retourner Date. */
TypUpsVmLong UpsVmAPI (*Trt_14_1)(TypUpsVmSession *Session);
   /* Objet : Fonction Aleatoire() Retourner Entier. */
TypUpsVmVoid UpsVmAPI (*Trt_15_1)(TypUpsVmSession *Session, TypPrmUpsSys_15_1 *UpsPrm);
   /* Objet : Procedure Alarme(Traitement:Procedure (), DelaiEnSecondes:Entier, Periodique:Booleen). */
TypUpsVmVoid UpsVmAPI (*Trt_16_1)(TypUpsVmSession *Session, TypPrmUpsSys_16_1 *UpsPrm);
   /* Objet : Procedure Attendre(DelaiEnSecondes:Reel). */
TypUpsVmAdresse UpsVmAPI *(*Trt_17_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsResultat, TypPrmUpsSys_17_1 *UpsPrm);
   /* Objet : Fonction BornerRepertoire(NomRepertoire:Nul Ou Caractere) Retourner Nul Ou Caractere. */
TypUpsVmLong UpsVmAPI (*Trt_18_1)(TypUpsVmSession *Session, TypPrmUpsSys_18_1 *UpsPrm);
   /* Objet : Executer(Commande:Nul Ou Caractere, Synchroniser:Booleen, Cacher:Booleen,
   NumeroProcessusFils:Entier Sortie, RepertoireInitial:Nul Ou Caractere=Nul, 
   EcrireEntree:Nul Ou Fonction() Retourner Nul Ou Caractere=Nul, LireSortie:Nul Ou Procedure(M:Caractere)=Nul) Retourner Entier. */
TypUpsVmAdresse UpsVmAPI *(*Trt_19_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsResultat, TypPrmUpsSys_19_1 *UpsPrm);
   /* Objet : Fonction RechercherFichierDansChemin(NomFichier:Nul Ou Caractere, ListeDeRepertoires:Nul Ou Caractere) 
   Retourner Nul Ou Caractere. */
TypUpsVmLong UpsVmAPI (*Trt_20_1)(TypUpsVmSession *Session, TypPrmUpsSys_20_1 *UpsPrm);
   /* Objet : LireCaracteristiquesFichier(NomFichier:Nul Ou Caractere) Retourner Entier. */
TypUpsVmLong UpsVmAPI (*Trt_20_2)(TypUpsVmSession *Session, TypPrmUpsSys_20_2 *UpsPrm);
   /* Objet : LireCaracteristiquesFichier(NomFichier:Nul Ou Caractere, UtilisateurProprietaire:Entier Sortie, GroupeProprietaire:Entier Sortie,
   DateDernierAcces:Date Sortie, DateDerniereModification:Date Sortie, DateCreation:Date Sortie,
   EstCache:Booleen Sortie)
   Retourner Entier. */
TypUpsVmAdresse UpsVmAPI *(*Trt_21_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsResultat, TypPrmUpsSys_21_1 *UpsPrm);
   /* Objet : Fonction ListerFichier(NomRepertoire:Nul Ou Caractere, Filtre:Nul Ou Caractere) 
   Retourner Nul Ou ListeDe FichierListe. */
TypUpsVmAdresse UpsVmAPI *(*Trt_22_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsResultat);
   /* Objet : Fonction ListerProcessus() Retourner Nul Ou ListeDe ProcessusListe. */
TypUpsVmVoid UpsVmAPI (*Trt_23_1)(TypUpsVmSession *Session, TypPrmUpsSys_23_1 *UpsPrm);
   /* Objet : Procedure CopierFichier(FichierDepart:Caractere Ou Nul, FichierArrive:Caractere Ou Nul). */
TypUpsVmVoid UpsVmAPI (*Trt_24_1)(TypUpsVmSession *Session, TypPrmUpsSys_24_1 *UpsPrm);
   /* Objet : CopierRepertoire(RepertoireDepart:Caractere Ou Nul, RepertoireArrive:Caractere Ou Nul). */
TypUpsVmUnsignedChar UpsVmAPI (*Trt_25_1)(TypUpsVmSession *Session, TypPrmUpsSys_25_1 *UpsPrm);
   /* Objet : Fonction IlExisteFichier(NomFichier:Caractere Ou Nul) Retourner Booleen. */
TypUpsVmUnsignedChar UpsVmAPI (*Trt_26_1)(TypUpsVmSession *Session, TypPrmUpsSys_26_1 *UpsPrm);
   /* Objet : Fonction IlExisteRepertoire(NomRepertoire:Caractere Ou Nul) Retourner Booleen. */
TypUpsVmAdresse UpsVmAPI *(*Trt_27_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsResultat, TypPrmUpsSys_27_1 *UpsPrm);
   /* Objet : Fonction ListerUnites(Filtre:Nul Ou Caractere) Retourner Nul Ou ListeDe UniteListe. */
TypUpsVmVoid UpsVmAPI (*Trt_28_1)(TypUpsVmSession *Session, TypPrmUpsSys_28_1 *UpsPrm);
   /* Objet : Procedure ArreterProcessus(NumeroProcessus:Entier). */
TypUpsVmUnsignedChar UpsVmAPI (*Trt_29_1)(TypUpsVmSession *Session, TypPrmUpsSys_29_1 *UpsPrm);
   /* Objet : Fonction LireCodeRetour(NumeroProcessus:Entier, CodeRetour:Entier Sortie) Retourner Booleen. */
TypUpsVmDouble UpsVmAPI (*Trt_30_1)(TypUpsVmSession *Session, TypPrmUpsSys_30_1 *UpsPrm);
   /* Objet : LireTempsProcessus(TempsSysteme:Reel Sortie) Retourner Reel. */
TypUpsVmAdresse UpsVmAPI *(*Trt_31_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsResultat, TypPrmUpsSys_31_1 *UpsPrm);
   /* Objet : Fonction LireEnvironnement(VariableEnvironnement:Caractere) Retourner Nul Ou Caractere Implemente; */
TypUpsVmVoid UpsVmAPI (*Trt_32_1)(TypUpsVmSession *Session, TypPrmUpsSys_32_1 *UpsPrm);
   /* Procedure ChangerEnvironnement(VariableEnvironnement:Caractere, Valeur:Nul Ou Caractere) Implemente; */
TypUpsVmLong UpsVmAPI (*Trt_33_1)(TypUpsVmSession *Session);
   /* Fonction CreerInstance() Retourner Entier Implemente; */
TypUpsVmVoid UpsVmAPI (*Trt_34_1)(TypUpsVmSession *Session, TypPrmUpsSys_34_1 *UpsPrm);
   /* Procedure CommuterInstance(I:Entier) Implemente; */
TypUpsVmVoid UpsVmAPI (*Trt_35_1)(TypUpsVmSession *Session, TypPrmUpsSys_35_1 *UpsPrm);
   /* Procedure ArreterInstance(I:Entier) Implemente; */
TypUpsVmVoid UpsVmAPI (*Trt_36_1)(TypUpsVmSession *Session, TypPrmUpsSys_36_1 *UpsPrm);
   /* Procedure DemarrerService(NomService:Caractere) Implemente; */
TypUpsVmVoid UpsVmAPI (*Trt_37_1)(TypUpsVmSession *Session, TypPrmUpsSys_37_1 *UpsPrm);
   /* Procedure ArreterService(NomService:Caractere, ForcerArret:Booleen) Implemente; */
TypUpsVmUnsignedChar UpsVmAPI (*Trt_38_1)(TypUpsVmSession *Session, TypPrmUpsSys_38_1 *UpsPrm);
   /* Fonction ChercherService(NomService:Caractere) Implemente; */
TypUpsVmUnsignedChar UpsVmAPI (*Trt_39_1)(TypUpsVmSession *Session, TypPrmUpsSys_39_1 *UpsPrm);
   /* Fonction LireParametre(M:Module, NomDeParametre:Caractere, NomDeLaSection:Caractere, Valeur:Booleen Sortie) Retourner Booleen Implemente; */
TypUpsVmUnsignedChar UpsVmAPI (*Trt_39_2)(TypUpsVmSession *Session, TypPrmUpsSys_39_2 *UpsPrm);
   /* Fonction LireParametre(M:Module, NomDeParametre:Caractere, NomDeLaSection:Caractere, Valeur:Entier Sortie) Retourner Booleen Implemente; */
TypUpsVmUnsignedChar UpsVmAPI (*Trt_39_3)(TypUpsVmSession *Session, TypPrmUpsSys_39_3 *UpsPrm);
   /* Fonction LireParametre(M:Module, NomDeParametre:Caractere, NomDeLaSection:Caractere, Valeur:Reel Sortie) Retourner Booleen Implemente; */
TypUpsVmUnsignedChar UpsVmAPI (*Trt_39_4)(TypUpsVmSession *Session, TypPrmUpsSys_39_4 *UpsPrm);
   /* Fonction LireParametre(M:Module, NomDeParametre:Caractere, NomDeLaSection:Caractere, Valeur:Caractere Sortie) Retourner Booleen Implemente; */
TypUpsVmUnsignedChar UpsVmAPI (*Trt_39_5)(TypUpsVmSession *Session, TypPrmUpsSys_39_5 *UpsPrm);
   /* Fonction LireParametre(M:Module, NomDeParametre:Caractere, NomDeLaSection:Caractere, Valeur:Date Sortie) Retourner Booleen Implemente; */
TypUpsVmVoid UpsVmAPI (*Trt_40_1)(TypUpsVmSession *Session, TypPrmUpsSys_40_1 *UpsPrm);
   /* Procedure EnvoyerExceptionAToutesLesTaches(E:Nul Ou Exception, P1:Nul Ou Caractere=Nul, P2:Nul Ou Caractere=Nul, 
   P3:Nul Ou Caractere=Nul, P4:Nul Ou Caractere=Nul, P5:Nul Ou Caractere=Nul); */
TypUpsVmAdresse UpsVmAPI *(*Trt_41_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsSys_41_1 *UpsPrm);
   /* Fonction ExtraireNomFichier(NomFichierComplet:Nul Ou Caractere) Retourner Nul Ou Caractere; */
TypUpsVmAdresse UpsVmAPI *(*Trt_42_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsSys_42_1 *UpsPrm);
   /* Fonction ExtraireNomRepertoire(NomFichierComplet:Nul Ou Caractere) Retourner Nul Ou Caractere; */

TypUpsVmCoAppel CoTrt_1_1;
   /* Objet : Procedure CreerFichier(NomFichier:Nul Ou Caractere). */
TypUpsVmCoAppel CoTrt_2_1;
   /* Objet : Procedure CreerRepertoire(NomRepertoire:Nul Ou Caractere). */
TypUpsVmCoAppel CoTrt_3_1;
   /* Objet : Procedure SupprimerFichier(NomFichier:Nul Ou Caractere). */
TypUpsVmCoAppel CoTrt_4_1;
   /* Objet : Procedure SupprimerRepertoire(NomRepertoire:Nul Ou Caractere). */
TypUpsVmCoAppel CoTrt_5_1;
   /* Objet : Procedure ChangerRepertoireCourant(NomRepertoire:Nul Ou Caractere). */
TypUpsVmCoAppel CoTrt_6_1;
   /* Objet : Fonction LireRepertoireCourant() Retourner Caractere. */
TypUpsVmCoAppel CoTrt_7_1;
   /* Objet : Procedure RenommerFichier(FichierDepart:Caractere Ou Nul, FichierArrive:Caractere Ou Nul). */
TypUpsVmCoAppel CoTrt_8_1;
   /* Objet : RenommerRepertoire(RepertoireDepart:Caractere Ou Nul, RepertoireArrive:Caractere Ou Nul). */
TypUpsVmCoAppel CoTrt_9_1;
   /* Objet : Procedure ChangerPriorite(Priorite:Entier). */
TypUpsVmCoAppel CoTrt_10_1;
   /* Objet : Fonction LirePriorite() Retourner Entier. */
TypUpsVmCoAppel CoTrt_11_1;
   /* Objet : Procedure ChangerDroitDAcces(NomFichier,Nul Ou Caractere, DroitsUtilisateur:DroitsDAcces,
   DroitsGroupe:DroitsDAcces, DroitsAutres:DroitsDAcces) Implemente. */
TypUpsVmCoAppel CoTrt_12_1;
   /* Objet : Fonction LireDroitDAcces(NomFichier,Nul Ou Caractere, DroitsGroupe:Nul Ou DroitsDAcces Sortie,
   DroitsAutres:Nul Ou DroitsDAcces Sortie) Retourner Nul Ou DroitsDAcces. */
TypUpsVmCoAppel CoTrt_13_1;
   /* Objet : Fonction DateSysteme() Retourner Date. */
TypUpsVmCoAppel CoTrt_14_1;
   /* Objet : Fonction Aleatoire() Retourner Entier. */
TypUpsVmCoAppel CoTrt_15_1;
   /* Objet : Procedure Alarme(Traitement:Procedure (), DelaiEnSecondes:Entier, Periodique:Booleen). */
TypUpsVmCoAppel CoTrt_16_1;
   /* Objet : Procedure Attendre(DelaiEnSecondes:Reel). */
TypUpsVmCoAppel CoTrt_17_1;
   /* Objet : Fonction BornerRepertoire(NomRepertoire:Nul Ou Caractere) Retourner Nul Ou Caractere. */
TypUpsVmCoAppel CoTrt_18_1;
   /* Objet : Executer(Commande:Nul Ou Caractere, Synchroniser:Booleen, Cacher:Booleen,
   NumeroProcessusFils:Entier Sortie, RepertoireInitial:Nul Ou Caractere=Nul, 
   EcrireEntree:Nul Ou Fonction() Retourner Nul Ou Caractere=Nul, LireSortie:Nul Ou Procedure(M:Caractere)=Nul) Retourner Entier. */
TypUpsVmCoAppel CoTrt_19_1;
   /* Objet : Fonction RechercherFichierDansChemin(NomFichier:Nul Ou Caractere, ListeDeRepertoires:Nul Ou Caractere) 
   Retourner Nul Ou Caractere. */
TypUpsVmCoAppel CoTrt_20_1;
   /* Objet : LireCaracteristiquesFichier(NomFichier:Nul Ou Caractere) Retourner Entier. */
TypUpsVmCoAppel CoTrt_20_2;
   /* Objet : LireCaracteristiquesFichier(NomFichier:Nul Ou Caractere, UtilisateurProprietaire:Entier Sortie, GroupeProprietaire:Entier Sortie,
   DateDernierAcces:Date Sortie, DateDerniereModification:Date Sortie, DateCreation:Date Sortie,
   EstCache:Booleen Sortie)
   Retourner Entier. */
TypUpsVmCoAppel CoTrt_21_1;
   /* Objet : Fonction ListerFichier(NomRepertoire:Nul Ou Caractere, Filtre:Nul Ou Caractere) 
   Retourner Nul Ou ListeDe FichierListe. */
TypUpsVmCoAppel CoTrt_22_1;
   /* Objet : Fonction ListerProcessus() Retourner Nul Ou ListeDe ProcessusListe. */
TypUpsVmCoAppel CoTrt_23_1;
   /* Objet : Procedure CopierFichier(FichierDepart:Caractere Ou Nul, FichierArrive:Caractere Ou Nul). */
TypUpsVmCoAppel CoTrt_24_1;
   /* Objet : CopierRepertoire(RepertoireDepart:Caractere Ou Nul, RepertoireArrive:Caractere Ou Nul). */
TypUpsVmCoAppel CoTrt_25_1;
   /* Objet : Fonction IlExisteFichier(NomFichier:Caractere Ou Nul) Retourner Booleen. */
TypUpsVmCoAppel CoTrt_26_1;
   /* Objet : Fonction IlExisteRepertoire(NomRepertoire:Caractere Ou Nul) Retourner Booleen. */
TypUpsVmCoAppel CoTrt_27_1;
   /* Objet : Fonction ListerUnites(Filtre:Nul Ou Caractere) Retourner Nul Ou ListeDe UniteListe. */
TypUpsVmCoAppel CoTrt_28_1;
   /* Objet : Procedure ArreterProcessus(NumeroProcessus:Entier). */
TypUpsVmCoAppel CoTrt_29_1;
   /* Objet : Fonction LireCodeRetour(NumeroProcessus:Entier, CodeRetour:Entier Sortie) Retourner Booleen. */
TypUpsVmCoAppel CoTrt_30_1;
   /* Objet : LireTempsProcessus(TempsSysteme:Reel Sortie) Retourner Reel. */
TypUpsVmCoAppel CoTrt_31_1;
   /* Objet : Fonction LireEnvironnement(VariableEnvironnement:Caractere) Retourner Nul Ou Caractere Implemente; */
TypUpsVmCoAppel CoTrt_32_1;
   /* Procedure ChangerEnvironnement(VariableEnvironnement:Caractere, Valeur:Nul Ou Caractere) Implemente; */
TypUpsVmCoAppel CoTrt_33_1;
   /* Fonction CreerInstance() Retourner Entier Implemente; */
TypUpsVmCoAppel CoTrt_34_1;
   /* Procedure CommuterInstance(I:Entier) Implemente; */
TypUpsVmCoAppel CoTrt_35_1;
   /* Procedure ArreterInstance(I:Entier) Implemente; */
TypUpsVmCoAppel CoTrt_36_1;
   /* Procedure DemarrerService(NomService:Caractere) Implemente; */
TypUpsVmCoAppel CoTrt_37_1;
   /* Procedure ArreterService(NomService:Caractere, ForcerArret:Booleen) Implemente; */
TypUpsVmCoAppel CoTrt_38_1;
   /* Fonction ChercherService(NomService:Caractere) Implemente; */
TypUpsVmCoAppel CoTrt_39_1;
   /* Fonction LireParametre(M:Module, NomDeParametre:Caractere, NomDeLaSection:Caractere, Valeur:Booleen Sortie) Retourner Booleen Implemente; */
TypUpsVmCoAppel CoTrt_39_2;
   /* Fonction LireParametre(M:Module, NomDeParametre:Caractere, NomDeLaSection:Caractere, Valeur:Entier Sortie) Retourner Booleen Implemente; */
TypUpsVmCoAppel CoTrt_39_3;
   /* Fonction LireParametre(M:Module, NomDeParametre:Caractere, NomDeLaSection:Caractere, Valeur:Reel Sortie) Retourner Booleen Implemente; */
TypUpsVmCoAppel CoTrt_39_4;
   /* Fonction LireParametre(M:Module, NomDeParametre:Caractere, NomDeLaSection:Caractere, Valeur:Caractere Sortie) Retourner Booleen Implemente; */
TypUpsVmCoAppel CoTrt_39_5;
   /* Fonction LireParametre(M:Module, NomDeParametre:Caractere, NomDeLaSection:Caractere, Valeur:Date Sortie) Retourner Booleen Implemente; */
TypUpsVmCoAppel CoTrt_40_1;
   /* Procedure EnvoyerExceptionAToutesLesTaches(E:Nul Ou Exception, P1:Nul Ou Caractere=Nul, P2:Nul Ou Caractere=Nul, 
   P3:Nul Ou Caractere=Nul, P4:Nul Ou Caractere=Nul, P5:Nul Ou Caractere=Nul); */
TypUpsVmCoAppel CoTrt_41_1;
   /* Fonction ExtraireNomFichier(NomFichierComplet:Nul Ou Caractere) Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoTrt_42_1;
   /* Fonction ExtraireNomRepertoire(NomFichierComplet:Nul Ou Caractere) Retourner Nul Ou Caractere; */

/*--------------------------------------------------------------*/
/* Tables des methodes.                                         */
/*--------------------------------------------------------------*/
UpsTrtTypUpsSys_1 *UpsTrt1;
   /* Methodes de FichierListe. */ 
UpsTrtTypUpsSys_2 *UpsTrt2;
   /* Methodes de ProcessusListe. */ 
UpsTrtTypUpsSys_3 *UpsTrt3;
   /* Methodes de UniteListee. */ 
UpsTrtTypUpsSys_4 *UpsTrt4;
   /* Methodes de Tache. */ 
UpsTrtTypUpsSys_5 *UpsTrt5;
   /* Methodes de Synchronisation. */ 
UpsTrtTypUpsSys_6 *UpsTrt6;
   /* Methodes de FileDAttente. */ 
UpsTrtTypUpsKrn_19 *UpsTrt6_1;
   /* Methodes de FileDAttente.Iterateur. */ 
UpsTrtTypUpsSys_7 *UpsTrt7;
   /* Methodes de Travail. */ 
UpsTrtTypUpsSys_8 *UpsTrt8;
   /* Methodes de Fichier. */ 
UpsTrtTypUpsSys_12 *UpsTrt8_1;
   /* Methodes de Fichier.Flux. */ 
UpsTrtTypUpsSys_9 *UpsTrt9;
   /* Methodes de Segment. */ 
UpsTrtTypUpsSys_10 *UpsTrt10;
   /* Methodes de PeriodeCalendrier. */ 
UpsTrtTypUpsSys_11 *UpsTrt11;
   /* Methodes de Calendrier. */ 
UpsTrtTypUpsSys_12 *UpsTrt12;
   /* Methodes de Flux. */ 

/*--------------------------------------------------------------*/
/* Enumeres.			              				                   */
/*--------------------------------------------------------------*/
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_1_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_1_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* DroitsDAcces. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_2_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_2_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* SorteUnite. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_3_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_3_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* AccesSynchronisation. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_4_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* ModeSynchronisation. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_5_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* EtatTravail. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_6_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* TypePlanification. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_7_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* ModeOuvertureFlux. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_8_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_8_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* SorteAccesSegment. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_9_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_9_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* TypePeriodeCalendrier. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_10_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_10_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* PagesDeCodesSupportees. */

/*--------------------------------------------------------------*/
/* Entrepots.          								                   */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Types et interfaces.                                         */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*UpsType1_get)(TypUpsVmSession *Session);
   /* Type FichierListe. */
TypUpsVmLong UpsVmAPI (*UpsIndex1_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type FichierListe. */ 
TypUpsVmAdresse UpsVmAPI *(*UpsType2_get)(TypUpsVmSession *Session);
   /* Type ProcessusListe. */
TypUpsVmLong UpsVmAPI (*UpsIndex2_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type ProcessusListe. */ 
TypUpsVmAdresse UpsVmAPI *(*UpsType3_get)(TypUpsVmSession *Session);
   /* Type UniteListee. */
TypUpsVmLong UpsVmAPI (*UpsIndex3_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type UniteListee. */ 
TypUpsVmAdresse UpsVmAPI *(*UpsType4_get)(TypUpsVmSession *Session);
   /* Type Tache. */
TypUpsVmLong UpsVmAPI (*UpsIndex4_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Tache. */ 
TypUpsVmAdresse UpsVmAPI *(*UpsType5_get)(TypUpsVmSession *Session);
   /* Type Synchronisation. */
TypUpsVmLong UpsVmAPI (*UpsIndex5_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Synchronisation. */ 
TypUpsVmAdresse UpsVmAPI *(*UpsType6_get)(TypUpsVmSession *Session);
   /* Type FileDAttente. */
TypUpsVmLong UpsVmAPI (*UpsIndex6_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type FileDAttente. */ 
TypUpsVmAdresse UpsVmAPI *(*UpsType7_get)(TypUpsVmSession *Session);
   /* Type Travail. */
TypUpsVmLong UpsVmAPI (*UpsIndex7_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Travail. */ 
TypUpsVmAdresse UpsVmAPI *(*UpsType8_get)(TypUpsVmSession *Session);
   /* Type Fichier. */
TypUpsVmLong UpsVmAPI (*UpsIndex8_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Fichier. */ 
TypUpsVmAdresse UpsVmAPI *(*UpsType9_get)(TypUpsVmSession *Session);
   /* Type Segment. */
TypUpsVmLong UpsVmAPI (*UpsIndex9_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Segment. */ 
TypUpsVmAdresse UpsVmAPI *(*UpsType10_get)(TypUpsVmSession *Session);
   /* Type PeriodeCalendrier. */
TypUpsVmLong UpsVmAPI (*UpsIndex10_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type PeriodeCalendrier. */ 
TypUpsVmAdresse UpsVmAPI *(*UpsType11_get)(TypUpsVmSession *Session);
   /* Type Calendrier. */
TypUpsVmLong UpsVmAPI (*UpsIndex11_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Calendrier. */ 
TypUpsVmAdresse UpsVmAPI *(*UpsType12_get)(TypUpsVmSession *Session);
   /* Type Flux. */
TypUpsVmLong UpsVmAPI (*UpsIndex12_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Flux. */ 

/*--------------------------------------------------------------*/
/* Variables globales.                                          */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*UpsVar1_get)(TypUpsVmSession *Session);
   /* NomNoeud : Caractere; */
TypUpsVmAdresse UpsVmAPI *(*UpsVar2_get)(TypUpsVmSession *Session);
   /* NomMachine:Caractere; */
TypUpsVmAdresse UpsVmAPI *(*UpsVar3_get)(TypUpsVmSession *Session);
   /* NomProgramme:Caractere; */
TypUpsVmAdresse UpsVmAPI *(*UpsVar4_get)(TypUpsVmSession *Session);
   /* NomUtilisateur:Caractere; */
TypUpsVmAdresse UpsVmAPI *(*UpsVar5_get)(TypUpsVmSession *Session);
   /* NomGroupe:Caractere; */
TypUpsVmLong UpsVmAPI (*UpsVar6_get)(TypUpsVmSession *Session);
   /* NumeroProcessus:Entier; */
TypUpsVmLong UpsVmAPI (*UpsVar7_get)(TypUpsVmSession *Session);
   /* NumeroGroupe:Entier; */
TypUpsVmLong UpsVmAPI (*UpsVar8_get)(TypUpsVmSession *Session);
   /* NumeroUtilisateur:Entier; */
TypUpsVmAdresse UpsVmAPI *(*UpsVar9_get)(TypUpsVmSession *Session);
   /* SystemeDExploitation : Caractere; */
TypUpsVmAdresse UpsVmAPI *(*UpsVar10_get)(TypUpsVmSession *Session);
   /* SeparateurRepertoire:Caractere; */
TypUpsVmAdresse UpsVmAPI *(*UpsVar11_get)(TypUpsVmSession *Session);
   /* UpsHome. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar12_get)(TypUpsVmSession *Session);
   /* UpsPath. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar13_get)(TypUpsVmSession *Session);
   /* UpsUser. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar14_get)(TypUpsVmSession *Session);
   /* TachePrincipale. */
TypUpsVmLong UpsVmAPI (*UpsVar15_get)(TypUpsVmSession *Session);
   /* NumeroInstance. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar16_get)(TypUpsVmSession *Session);
   /* Clavier. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar17_get)(TypUpsVmSession *Session);
   /* Ecran. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar18_get)(TypUpsVmSession *Session);
   /* Imprimante. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar19_get)(TypUpsVmSession *Session);
   /* Journal. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar20_get)(TypUpsVmSession *Session);
   /* MiseAuPoint. */
TypUpsVmUnsignedChar UpsVmAPI (*UpsVar21_get)(TypUpsVmSession *Session);
   /* PageDeCode. */

/*--------------------------------------------------------------*/
/* Exceptions.                                                  */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*UpsException1_get)(TypUpsVmSession *Session);
   /* Exception CreationFichierImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException2_get)(TypUpsVmSession *Session);
   /* Exception SuppressionImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException3_get)(TypUpsVmSession *Session);
   /* Exception ChangementRepertoireImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException4_get)(TypUpsVmSession *Session);
   /* Exception RepertoireCourantImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException5_get)(TypUpsVmSession *Session);
   /* Exception RenommageImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException6_get)(TypUpsVmSession *Session);
   /* Exception ExecutionImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException7_get)(TypUpsVmSession *Session);
   /* Exception ChangementDroitDAccesImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException8_get)(TypUpsVmSession *Session);
   /* Exception LireDroitDAccesImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException9_get)(TypUpsVmSession *Session);
   /* Exception AlarmeImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException10_get)(TypUpsVmSession *Session);
   /* Exception LireCaracteristiquesImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException11_get)(TypUpsVmSession *Session);
   /* Exception ArretTacheImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException12_get)(TypUpsVmSession *Session);
   /* Exception LireCodeRetourImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException13_get)(TypUpsVmSession *Session);
   /* Exception LireTempsImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException14_get)(TypUpsVmSession *Session);
   /* Exception CopieImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException15_get)(TypUpsVmSession *Session);
   /* Exception PrendreImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException16_get)(TypUpsVmSession *Session);
   /* Exception ActionTacheImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException17_get)(TypUpsVmSession *Session);
   /* Exception Interblocage. */
TypUpsVmAdresse UpsVmAPI *(*UpsException18_get)(TypUpsVmSession *Session);
   /* Exception VerrouNonPose. */
TypUpsVmAdresse UpsVmAPI *(*UpsException19_get)(TypUpsVmSession *Session);
   /* Exception SignalRecu. */
TypUpsVmAdresse UpsVmAPI *(*UpsException20_get)(TypUpsVmSession *Session);
   /* Exception ArretInstanceImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException21_get)(TypUpsVmSession *Session);
   /* Exception CommuterInstanceImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException22_get)(TypUpsVmSession *Session);
   /* Exception ArretServiceImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException23_get)(TypUpsVmSession *Session);
   /* Exception ServiceInconnu. */
TypUpsVmAdresse UpsVmAPI *(*UpsException24_get)(TypUpsVmSession *Session);
   /* Exception ParametreImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException25_get)(TypUpsVmSession *Session);
   /* Exception OuvertureLecture. */
TypUpsVmAdresse UpsVmAPI *(*UpsException26_get)(TypUpsVmSession *Session);
   /* Exception OuvertureEcriture. */
TypUpsVmAdresse UpsVmAPI *(*UpsException27_get)(TypUpsVmSession *Session);
   /* Exception FluxNonOuvert. */
TypUpsVmAdresse UpsVmAPI *(*UpsException28_get)(TypUpsVmSession *Session);
   /* Exception FluxNonOuvertEnLecture. */
TypUpsVmAdresse UpsVmAPI *(*UpsException29_get)(TypUpsVmSession *Session);
   /* Exception FluxNonOuvertEnEcriture. */

/*--------------------------------------------------------------*/
/* Files d'attente.                                             */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Application Program Interfaces proprietaires.                */
/*--------------------------------------------------------------*/
TypUpsSysMachineInterface UpsVmAPI (*LireMachineInterface)(TypUpsVmVoid);
    /* Objet : Lit l'interface avec la machine pour Ups System. */
TypUpsVmShort UpsVmAPI (*ChangerRessources)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees HandleInstancePrecedente, TypUpsVmPointeurDonnees HandleInstanceSuivante);
   /* Objet : Change les ressources suite a un changement de langue. Pour Ups Nls. */
TypUpsVmShort UpsVmAPI (*InitialiserEncapsulationKernel)(TypUpsVmVoid);
   /* Objet : Initialisation de l'extension de Ups Sys pour Ups Krn. */
TypUpsVmVoid UpsVmAPI (*TerminerEncapsulationKernel)(TypUpsVmVoid);
   /* Objet : Terminaison de l'extension de Ups Sys pour Ups Krn. */
TypUpsVmVoid UpsVmAPI (*CopierNomFileDAttente)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetFileDAttente, 
   TypUpsVmUnicode *NomFileDAttente, TypUpsVmLong TailleNomFileDAttente);
   /* Objet : Recupere le nom de la file d'attente. */
TypUpsVmShort UpsVmAPI (*ReferencerConsole)(TypUpsSysGestionConsole *GestionConsole);
   /* Objet : Referencie une extension pour une console. */
TypUpsSysGestionConsole UpsVmAPI *(*LireConsoleParDefaut)(TypUpsVmVoid);
   /* Objet : Lit la table des methodes de la console par defaut. */
/*--------------------------------------------------------------*/
/* Posix.                                                       */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*BornerRepertoire)(TypUpsVmUnicode *Repertoire, TypUpsVmLong TailleRepertoire);
   /* Objet : Borne le repertoire. */
TypUpsVmShort UpsVmAPI (*AnalyserChaine)(TypUpsVmSession *Session, TypUpsVmUnicode *Chaine, TypUpsVmUnicode *Filtre, 
   TypUpsVmPointeurDonnees P1, TypUpsVmPointeurDonnees P2, TypUpsVmPointeurDonnees P3,
   TypUpsVmPointeurDonnees P4, TypUpsVmPointeurDonnees P5, TypUpsVmPointeurDonnees P6);
   /* Objet : Analyse une chaine lue dans le flux. */
TypUpsVmVoid UpsVmAPI (*FormaterChaine)(TypUpsVmSession *Session, TypUpsVmUnicode *Chaine, TypUpsVmLong TailleChaine, TypUpsVmUnicode *Filtre, 
   TypUpsVmPointeurDonnees P1, TypUpsVmPointeurDonnees P2, TypUpsVmPointeurDonnees P3, 
   TypUpsVmPointeurDonnees P4, TypUpsVmPointeurDonnees P5, TypUpsVmPointeurDonnees P6);
   /* Objet : Formate une chaine et ecrit la dans le flux. */
TypUpsVmLong UpsVmAPI (*PrincipalTacheAlarme)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *ObjetTache, TypUpsVmPointeurDonnees Parametres);
   /* Objet : Fonction pricipale de la tache gerant les alarmes. */
TypUpsVmVoid UpsVmAPI (*LancerTacheAlarme)(TypUpsVmSession *Session);
   /* Objet : Lance la tache gerant les alarmes. */
TypUpsVmShort UpsVmAPI (*AjouterAlarme)(TypUpsVmSession *Session, TypUpsVmFonctionEnumereCourtSansParametre PrincipalAlarme, 
   TypUpsVmAdresse *AdresseObjetAppel, TypUpsVmLong DelaiEnSecondes, TypUpsVmShort EstPeriodique);
   /* Objet : Ajoute une alarme. */
TypUpsVmShort UpsVmAPI (*IlYAUnAccesDistant)(TypUpsVmUnicode *NomRessourceComplet, 
   TypUpsVmUnicode *NomRessource, TypUpsVmLong TailleNomRessource, TypUpsVmUnicode *NomServeur, TypUpsVmLong TailleNomServeur);
   /* Objet : Retourne Vrai s'il y a un acces distant. */
TypUpsVmLong UpsVmAPI (*AjouterAllocateurBloc)(TypUpsVmSession *Session, TypUpsVmUnicode *Libelle,
   TypUpsVmLong TailleElement, TypUpsVmLong NbElements, TypUpsSysOperationElementBloc Operation, TypUpsVmShort CalculerUtilisation);
   /* Objet : Alloue un nouvel allocateur. */
TypUpsVmPointeurDonnees UpsVmAPI (*AllouerElementBloc)(TypUpsVmSession *Session, TypUpsVmLong Numero);
   /* Objet : Alloue un nouvel element a l'allocateur bloc. */
TypUpsVmVoid UpsVmAPI (*LibererElementBloc)(TypUpsVmSession *Session, TypUpsVmLong Numero, TypUpsVmPointeurDonnees Objet);
   /* Objet : Libere un element a l'allocateur bloc. */
TypUpsVmVoid UpsVmAPI (*LibererAllocateurBloc)(TypUpsVmSession *Session, TypUpsVmLong Numero);
   /* Objet : Libere un allocateur. */
TypUpsVmShort UpsVmAPI (*CompacterAllocateurBloc)(TypUpsVmSession *Session, TypUpsVmLong Numero, TypUpsVmPointeurDonnees Parametre);
   /* Objet : Compacte un allocateur. */
TypUpsVmShort UpsVmAPI (*CompacterAllocateursBlocs)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Parametre);
   /* Objet : Compacte les allocateurs blocs. */
enum EnuUpsSysUtiliteElement UpsVmAPI (*OuUtilite)(enum EnuUpsSysUtiliteElement Utilite1, enum EnuUpsSysUtiliteElement Utilite2);
   /* Objet : Realise un ou sur l'utilite. */
TypUpsVmShort UpsVmAPI (*InitialiserTable)(TypUpsVmSession *Session, TypUpsSysTable *Table, TypUpsVmUnicode *Libelle, TypUpsVmLong TailleObjet, TypUpsVmShort TailleIncrement);
   /* Objet : Initialise une table. */
TypUpsVmPointeurDonnees UpsVmAPI (*AllouerElementTable)(TypUpsVmSession *Session, TypUpsSysTable *Table, TypUpsVmLong *Numero);
   /* Objet : Alloue un element dans une table. */
TypUpsVmShort UpsVmAPI (*LibererElementTable)(TypUpsVmSession *Session, TypUpsSysTable *Table, TypUpsVmLong Numero);
   /* Objet : Libere un element dans une table. */
TypUpsVmShort UpsVmAPI (*LibererTable)(TypUpsVmSession *Session, TypUpsSysTable *Table, TypUpsSysDetruireObjetTable DetruireObjetTable);
   /* Objet : Libere une table. */
TypUpsVmShort UpsVmAPI (*AllouerExtension)(TypUpsVmSession *Session, TypUpsVmShort NbOptionsMax, TypUpsVmOption *TableOptions,
   TypUpsVmLong OffsetTaille, TypUpsVmPointeurDonnees **TableExtensions, TypUpsVmUnicode *LibelleExtension);
   /* Objet : Alloue une extension d'un objet. */
TypUpsVmVoid UpsVmAPI (*LibererExtension)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees **TableExtensions);
   /* Objet : Libere une extension d'un objet. */
TypUpsVmShort UpsVmAPI (*ChargerOptions)(TypUpsVmSession *Session, TypUpsVmShort NbOptionsMax, 
   TypUpsVmOption *TableOptions, TypUpsVmUnicode *NomGenerique, TypUpsVmUnicode *NomSectionOption, 
   TypUpsVmShort NumeroModule, TypUpsVmShort *NbOptions, TypUpsVmShort AllouerTableGestionOptions);
   /* Objet : Charge les options d'un module. */
TypUpsVmVoid UpsVmAPI (*ChangerInstanceOption)(TypUpsVmShort NbOptionsMax, TypUpsVmOption *TableOptions,
   TypUpsVmUnicode *NomModule, TypUpsVmDonneesOption *Interface);
   /* Objet : Previent le module d'un changement d'instance. */
TypUpsVmShort UpsVmAPI (*ReferencerExtension)(TypUpsVmShort NbOptionsMax, TypUpsVmOption *TableOptions,
   TypUpsVmUnicode *NomOption, TypUpsVmDonneesOption *IntDon, TypUpsVmTraitementsOption *IntTrt, TypUpsVmShort *NbExtensions);
   /* Objet : Reference une extension ne correspondant pas a une option. */
TypUpsVmVoid UpsVmAPI (*DechargerOptions)(TypUpsVmSession *Session, TypUpsVmShort NbOptionsMax, 
   TypUpsVmOption *TableOptions);
   /* Objet : Decharge les options d'un module. */
TypUpsVmShort UpsVmAPI (*InitialiserApresNls)(TypUpsVmVoid);
   /* Objet : Initialisation du composant apres Ups Nls. */
TypUpsVmShort UpsVmAPI (*InitialiserApresNls2)(TypUpsVmVoid);
   /* Objet : Initialisation du composant apres Ups Nls. */
TypUpsVmVoid UpsVmAPI (*TerminerAvantNls2)(TypUpsVmVoid);
   /* Objet : Terminaison du composant avant Ups Nls. */
/*--------------------------------------------------------------*/
/* Flux.                                                        */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*OuvrirUnFlux)(TypUpsVmSession *Session, TypUpsVmFlux *Descripteur, TypUpsVmUnicode *NomFlux, 
   TypUpsVmUnicode *Masque, enum EnuUpsVmTailleBuffer, TypUpsVmMethodesFlux Methodes);
   /* Objet : Ouvre le flux. */
TypUpsVmLong UpsVmAPI (*FluxLireOctets)(TypUpsVmSession *Session, TypUpsVmFlux *Descripteur, TypUpsVmChar *Buffer, TypUpsVmLong Taille, 
   TypUpsVmShort *FinDeFlux);
   /* Objet : Lit un paquet d'octets dans le flux. */
TypUpsVmLong UpsVmAPI (*FluxLireCaracteres)(TypUpsVmSession *Session, TypUpsVmFlux *Descripteur, TypUpsVmUnicode *Buffer, TypUpsVmLong Taille, 
   TypUpsVmShort *FinDeFlux);
   /* Objet : Lit un paquet de caracteres dans le flux. */
TypUpsVmUnicode UpsVmAPI *(*FluxLireUneLigne)(TypUpsVmSession *Session, TypUpsVmFlux *Descripteur, TypUpsVmUnicode *Ligne, 
   TypUpsVmLong TailleMaxLigne, TypUpsVmShort *FinDeFlux);
   /* Objet : Lit une ligne dans le flux. */
TypUpsVmUnicode UpsVmAPI *(*FluxLireUnMot)(TypUpsVmSession *Session, TypUpsVmFlux *Descripteur, TypUpsVmUnicode *Mot, 
   TypUpsVmLong TailleMaxMot, TypUpsVmShort *FinDeFlux);
   /* Objet : Lit un mot. */
TypUpsVmChar UpsVmAPI (*FluxLireUnOctet)(TypUpsVmSession *Session, TypUpsVmFlux *Descripteur, TypUpsVmShort *FinDeFlux);
   /* Objet : Lit un octet dans le flux. */
TypUpsVmChar UpsVmAPI (*FluxLireUnOctetText)(TypUpsVmSession *Session, TypUpsVmFlux *Descripteur, TypUpsVmShort *FinDeFlux);
   /* Objet : Lit un octet dans le flux en mode texte. */
TypUpsVmUnicode UpsVmAPI (*FluxLireUnCaractere)(TypUpsVmSession *Session, TypUpsVmFlux *Descripteur, TypUpsVmShort *FinDeFlux);
   /* Objet : Lecture d'un caractere. */
TypUpsVmUnicode UpsVmAPI (*FluxLireUnCaractereText)(TypUpsVmSession *Session, TypUpsVmFlux *Descripteur, TypUpsVmShort *FinDeFlux);
   /* Objet : Lit un caractere dans le flux en mode texte. */
TypUpsVmShort UpsVmAPI (*FluxAnalyserChaine)(TypUpsVmSession *Session, TypUpsVmFlux *Descripteur, TypUpsVmUnicode *Filtre, 
   TypUpsVmPointeurDonnees P1, TypUpsVmPointeurDonnees P2, TypUpsVmPointeurDonnees P3,
   TypUpsVmPointeurDonnees P4, TypUpsVmPointeurDonnees P5, TypUpsVmPointeurDonnees P6);
   /* Objet : Analyse une chaine lue dans le flux. */
TypUpsVmShort UpsVmAPI (*FluxEcrireOctets)(TypUpsVmSession *Session, TypUpsVmFlux *Descripteur, TypUpsVmChar *Buffer, TypUpsVmLong Taille);
   /* Objet : Ecriture par paquet. */
TypUpsVmShort UpsVmAPI (*FluxEcrireCaracteres)(TypUpsVmSession *Session, TypUpsVmFlux *Descripteur, TypUpsVmUnicode *Buffer, TypUpsVmLong Taille);
   /* Objet : Ecrit un paquet de caracteres dans le flux. */
TypUpsVmShort UpsVmAPI (*FluxEcrireUnOctet)(TypUpsVmSession *Session, TypUpsVmFlux *Descripteur, TypUpsVmChar O);
   /* Objet : Ecrit un octet dans le flux. */
TypUpsVmShort UpsVmAPI (*FluxEcrireUnCaractere)(TypUpsVmSession *Session, TypUpsVmFlux *Descripteur, TypUpsVmUnicode C);
   /* Objet : Ecrit un caractere dans le flux. */
TypUpsVmShort UpsVmAPI (*FluxRejeterUnOctet)(TypUpsVmSession *Session, TypUpsVmFlux *Descripteur, TypUpsVmChar O);
   /* Objet : Rejette un octet dans le flux. */
TypUpsVmShort UpsVmAPI (*FluxRejeterUnCaractere)(TypUpsVmSession *Session, TypUpsVmFlux *Descripteur, TypUpsVmUnicode C);
   /* Objet : Rejette un caractere dans le flux. */
TypUpsVmVoid UpsVmAPI (*FluxFormaterChaine)(TypUpsVmSession *Session, TypUpsVmFlux *Descripteur, TypUpsVmUnicode *Filtre, 
   TypUpsVmPointeurDonnees P1, TypUpsVmPointeurDonnees P2, TypUpsVmPointeurDonnees P3, 
   TypUpsVmPointeurDonnees P4, TypUpsVmPointeurDonnees P5, TypUpsVmPointeurDonnees P6);
   /* Objet : Formate une chaine et ecrit la dans le flux. */
TypUpsVmLong UpsVmAPI (*FluxLirePositionPointeur)(TypUpsVmSession *Session, TypUpsVmFlux *Descripteur);
   /* Objet : Lit la position dans le flux. */
TypUpsVmShort UpsVmAPI (*FluxDeplacerPointeur)(TypUpsVmSession *Session, TypUpsVmFlux *Descripteur, enum EnuUpsVmDeplacement Reference, 
   TypUpsVmLong Position);
   /* Objet : Fixe la position dans le flux. */
TypUpsVmShort UpsVmAPI (*FluxVider)(TypUpsVmSession *Session, TypUpsVmFlux *Descripteur);
   /* Objet : Vide le flux. */
TypUpsVmShort UpsVmAPI (*FluxFermer)(TypUpsVmSession *Session, TypUpsVmFlux *Descripteur);
   /* Objet : Ferme le fichier. */
TypUpsVmVoid UpsVmAPI (*TracerRessources)(TypUpsVmSession *Session, TypUpsVmUnicode *LibelleTrace, TypUpsVmShort Forcer);
   /* Objet : Trace l'emploi des ressources systemes. */
TypUpsVmVoid UpsVmAPI (*TracerRessources2)(TypUpsVmSession *Session, TypUpsVmUnicode *Message);
   /* Objet : Trace l'emploi des ressources systemes. */
TypUpsVmLong UpsVmAPI (*IncrementerUtilisation)(TypUpsVmSession *Session, TypUpsVmUnicode *Nature, TypUpsVmPointeurDonnees AdressePointant, TypUpsVmPointeurDonnees AdressePointe, 
   TypUpsVmUnicode *LibelleObjet, TypUpsVmUnicode *LibelleUtilisation, TypUpsVmUnicode *NomFichierSource, TypUpsVmLong NumeroLigne, TypUpsVmLong *NbUtilisations, 
   TypUpsVmLong *NbUtilisationsRecurrences);
   /* Objet : Incremente l'utilisation d'un objet. */
TypUpsVmLong UpsVmAPI (*DecrementerUtilisation)(TypUpsVmSession *Session, TypUpsVmUnicode *Nature, TypUpsVmPointeurDonnees AdressePointant, TypUpsVmPointeurDonnees AdressePointe, 
   TypUpsVmUnicode *LibelleObjet, TypUpsVmUnicode *LibelleUtilisation, TypUpsVmUnicode *NomFichierSource, TypUpsVmLong NumeroLigne, TypUpsVmLong *NbUtilisations, 
   TypUpsVmLong *NbUtilisationsRecurrences);
   /* Objet : Incremente l'utilisation d'un objet. */
TypUpsVmVoid UpsVmAPI (*TracerUtilisation)(TypUpsVmSession *Session);
   /* Objet : Trace l'utilisation des objets. */
/*--------------------------------------------------------------*/
/* Contexte.                                                    */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*InitialiserContexte)(TypUpsSysContexte *TableContexte, TypUpsVmShort NbEntrees);
   /* Objet: Initialise la table. Le nombre d'entrees utilisables  */
   /* est egal a NbEntrees-1.                                      */
TypUpsVmShort UpsVmAPI (*AjouterEntreeContexte)(TypUpsSysContexte *TabCon, TypUpsVmUnicode *NomValeur, 
   enum EnuUpsSysTypeParametre TypeValeur, TypUpsVmPointeurDonnees Valeur, TypUpsVmShort EnMinuscule, TypUpsVmShort *Lu);
   /* Objet: Ajoute une entree a une table de contexte. */
TypUpsVmShort UpsVmAPI (*Contexte)(TypUpsVmSession *Session, TypUpsSysContexte *TableContexte, TypUpsVmShort LireDansProfil, TypUpsVmShort Module,
	TypUpsVmUnicode *Profil, TypUpsVmUnicode *Section);
   /* Objet: Lit le contexte dans env, puis Complement, puis argv. */
TypUpsVmUnicode UpsVmAPI *(*CalculerRepertoireIni)(TypUpsVmUnicode *Reponse, TypUpsVmLong TailleReponse);
   /* Objet : Calcule le repertoire dans lequel sont ranges les fichiers ini de l'utilisateur. */
TypUpsVmShort UpsVmAPI (*PartagerUpsIni)(TypUpsVmSession *Session);
   /* Objet : Recherche si upsaps.ini est partage. */
TypUpsVmShort UpsVmAPI (*PartagerPrgUpsIni)(TypUpsVmSession *Session);
   /* Objet : Recherche si les ini particuliers sont partages. */
TypUpsVmUnicode UpsVmAPI *(*PartagerIni)(TypUpsVmSession *Session, TypUpsVmUnicode *Reponse, TypUpsVmLong TailleReponse);
   /* Objet : Recherche le repertoire des fichiers ini lorsqu'il est partage. */
TypUpsVmUnicode UpsVmAPI *(*CalculerFichierIni)(TypUpsVmSession *Session, TypUpsVmUnicode *Source, TypUpsVmShort *EstParticulier, 
	TypUpsVmUnicode *Reponse, TypUpsVmLong TailleReponse);
   /* Objet : Recherche le fichier ini correspondant a un programme. */
TypUpsVmVoid UpsVmAPI (*PartagerGeneration)(TypUpsVmSession *Session, TypUpsVmUnicode **Source, TypUpsVmUnicode **Interface, 
   TypUpsVmUnicode **Genere, TypUpsVmUnicode **Objet, TypUpsVmUnicode **Exe, TypUpsVmUnicode **Classe, 
   TypUpsVmUnicode **Message, TypUpsVmUnicode **IdlCom, TypUpsVmUnicode **IdlTlb, TypUpsVmUnicode **IdlCorba, 
   TypUpsVmUnicode **IdlCom2, TypUpsVmUnicode **TlbCom2, TypUpsVmUnicode **IdlCorba2, TypUpsVmUnicode **ClasseJava2);
   /* Objet : Recherche des repertoires partages pour la generation. */
TypUpsVmVoid UpsVmAPI (*PartagerKernel)(TypUpsVmSession *Session, TypUpsVmUnicode **Tmp);
   /* Objet : Recherche des repertoires partages pour le noyau. */
TypUpsVmUnicode UpsVmAPI *(*ConvertirVariablesEnvironnement)(TypUpsVmSession *Session, TypUpsVmUnicode *Source, TypUpsVmUnicode *ExtensionDefaut);
   /* Objet : Convertit les variables environnement precedees de $. */
TypUpsVmUnicode UpsVmAPI *(*RechercherFichierDansChemin)(TypUpsVmSession *Session, TypUpsVmUnicode *ListeChemins, TypUpsVmUnicode *Source, 
   TypUpsVmUnicode *ExtensionDefaut, TypUpsVmShort Directement, TypUpsVmShort SousRepertoireLangue);
   /* Objet : Recherche un fichier dans une liste de chemins. */
/*--------------------------------------------------------------*/
/* Taches.                                                      */
/*--------------------------------------------------------------*/
TypUpsVmLong UpsVmAPI (*CreerObjetTache)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmShort CreerUnNouveauThread, TypUpsVmAdresse *AdresseNomTache, 
   TypUpsVmMethodeEntierAvecParametre PrincipalTache, TypUpsVmAdresse *AdresseObjetPrincipalTache, TypUpsVmPointeurDonnees Parametres, 
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, 
   TypUpsVmShort Relancer, enum EnuUpsSysTypeTache SorteTache, TypUpsVmShort Lancer);
   /* Objet : Cree une nouvelle tache. */
TypUpsVmShort UpsVmAPI (*CreerTache)(TypUpsVmAdresse *AdresseResultat, TypUpsVmUnicode *NomTache, TypUpsVmMethodeEntierAvecParametre PrincipalTache, TypUpsVmPointeurDonnees Parametres, 
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, 
   TypUpsVmShort Relancer, enum EnuUpsSysTypeTache SorteTache);
   /* Objet : Cree une tache. */
TypUpsVmVoid UpsVmAPI (*TerminerTache)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetTache, TypUpsVmLong CodeRetour);
   /* Objet : Terminaison propre d'une tache. */
TypUpsVmVoid UpsVmAPI (*AttenteFinTachesAnnexes)(TypUpsVmShort CodeRetour);
   /* Objet : La tache principale attend que les taches annexes s'arretent. */
TypUpsVmShort UpsVmAPI (*CreerTachePrincipale)(TypUpsVmMethodeEntierAvecParametre PrincipalTache, TypUpsVmUnicode *NomModule, 
   TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel);
   /* Objet : Cree la tache principale. */
TypUpsVmVoid UpsVmAPI (*ControlerTache)(TypUpsVmSession *Session);
   /* Objet : Controle si une action sur cette tache est en attente. */
TypUpsVmAdresse UpsVmAPI *(*RechercherObjetTache)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat);
   /* Objet : Recherche l'objet representant une tache par son numero de session. */
/*--------------------------------------------------------------*/
/* Verrous.                                                     */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*LibererVerrousPourException)(TypUpsVmSession *Session, TypUpsVmUnsignedLong NumeroVerrou);
   /* Objet : Libere un verrou suite a une exception. */
/*--------------------------------------------------------------*/
/* Files d'attente.                                             */
/*--------------------------------------------------------------*/
TypUpsVmLong UpsVmAPI (*PrincipalTacheFile)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetTache, 
   TypUpsVmAdresse *AdresseObjetFile);
   /* Objet : Fonction principale d'une tache traitant les travaux en attente d'une file. */
TypUpsVmVoid UpsVmAPI (*LancerTacheFile)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetFile);
   /* Objet : Creation d'une tache pour la file d'attente. */
TypUpsVmVoid UpsVmAPI (*LibererTacheFile)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetFile, TypUpsVmAdresse *AdresseObjetTache);
   /* Objet : Libere les ressources d'une tache pour la file d'attente. */
TypUpsVmAdresse UpsVmAPI *(*CreerObjetFile)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat,
   TypUpsVmUnicode *NomFile, TypUpsVmShort NbTachesServeurs, TypUpsVmAdresse *AdresseObjetModule);
   /* Objet : Fabrique une File a partir de son nom et du nombre de taches serveur. */
/*--------------------------------------------------------------*/
/* Travaux.                                                     */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*CreerObjetTravail)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat,
   TypUpsVmUnicode *NomTravail, TypUpsVmAdresse *AdresseObjetFile, TypUpsVmAdresse *AdresseObjetAppel, 
   TypUpsVmChar *Parametres);
   /* Objet : Fabrique un Travail a partir d'un file, d'un appel et de ses parametres. */
/*--------------------------------------------------------------*/
/* Fichiers.                                                    */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*CreerObjetFichier)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat);
   /* Objet : Fabrique un Fichier ferme. */
TypUpsVmVoid UpsVmAPI (*OuvrirJournal)(TypUpsVmSession *Session, TypUpsVmUnicode *FichierJournal);
   /* Objet : Ouvre le fichier journal. */
TypUpsVmVoid UpsVmAPI (*EcrireJournal)(TypUpsVmSession *Session, TypUpsVmUnicode *Buffer, TypUpsVmLong Taille);
   /* Objet : Ecrit le message dans le journal. */
TypUpsVmVoid UpsVmAPI (*FermerJournal)(TypUpsVmSession *Session);
   /* Objet : Ferme le fichier journal. */
/*--------------------------------------------------------------*/
/* Calendriers.                                                 */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*CalculerDatePlanificationCalendrier)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Calcule la prochaine date de planification. */   
} *TypUpsSysTraitements_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsSysTraitements_1_1_0 TypUpsSysTraitements;

extern DllExport TypUpsVtmDemarrer UpsVmAPI UpsSysDemarrerModule(TypUpsVmShort Numero, TypUpsVtmMachineInterface MachineInterfaceUpsVtm,
   TypUpsVtmTraitements IntTrtUpsVtm, TypUpsVtmDonnees IntDonUpsVtm);
   /* Objet : Retourne la description de Ups Sys. */

/**********************/
#if defined(__cplusplus)
/**********************/
}
/****/
#endif
/****/

/****/
#endif
/****/
