/*-------------------------------------------------------------------
Fichier     : upssec.e
Objet       : En-tete du module Up ! Security Management System.

Module      : Up ! Security Management System
Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.
---------------------------------------------------------------------
                         Observations

 
---------------------------------------------------------------------*/

/*****************************/
#if !defined(PasseModuleUpsSec)
/*****************************/
#define PasseModuleUpsSec 1

/**********************/
#if defined(__cplusplus)
/**********************/
extern "C"
{
/****/
#endif
/****/

/*******************************/
/* Enumere SorteHabilitation.  */
/*******************************/
#define UpsEnuUpsSec_1_1 1
   /* Valeur : HabilitationModule */
#define UpsEnuUpsSec_1_2 2
   /* Valeur : HabilitationType */
#define UpsEnuUpsSec_1_3 3
   /* Valeur : HabilitationObjet */

/*************************/
/* Enumere SorteLicence. */
/*************************/
#define UpsEnuUpsSec_2_1 1
   /* Valeur : LicenceDeveloppement. */
#define UpsEnuUpsSec_2_2 2
   /* Valeur : LicencePersonnalisation. */
#define UpsEnuUpsSec_2_3 3
   /* Valeur : LicenceExecutionInteractive. */
#define UpsEnuUpsSec_2_4 4
   /* Valeur : LicenceExecutionBatch. */

/************************************/
/* Enumere SorteDeploiementLicence. */
/************************************/
#define UpsEnuUpsSec_3_1 1
    /* Valeur DeploiementLicenceNonAttribuee. */
#define UpsEnuUpsSec_3_2 2
   /* Valeur : DeploiementLicenceNoeud. */
#define UpsEnuUpsSec_3_3 4
   /* Valeur : DeploiementLicenceUtilisateur. */

/************************************/
/* Enumere SorteQuota.              */
/************************************/
#define UpsEnuUpsSec_4_1 1
   /* Valeur QuotaModule. */ 
#define UpsEnuUpsSec_4_2 2
   /* Valeur QuotaType. */
#define UpsEnuUpsSec_4_3 3
   /* Valeur QuotaObjet. */

/****************************************************************/
/* Codification des verifications habilitations.                */
/****************************************************************/
enum EnuUpsSecVerificationHabilitation
   {
   VH_CreationAutorisee=1,
   VH_DestructionAutorisee=2,
   VH_LectureAutorisee=3,
   VH_ModificationAutorisee=4,
   VH_ExecutionAutorisee=5
   };

/****************************************************************/
typedef struct upstypupssec_1_1_1_0
/* Objet : Proprietes du type Utilisateur.                      */
/****************************************************************/
{
TypUpsVmAdresse UpsChamp1;
   /* Nom : Caractere; */
TypUpsVmAdresse UpsChamp2;
   /* Description : Caractere; */
TypUpsVmLong UpsChamp3;
   /* Numero : Entier; */
TypUpsVmAdresse UpsChamp4;
   /* CalendrierDeConnexion:Nul Ou Calendrier; */
TypUpsVmAdresse UpsChamp5;
   /* HeureDebut:Nul Ou Date; */
TypUpsVmAdresse UpsChamp6;
   /* HeureFin:Nul Ou Date; */
TypUpsVmAdresse UpsChamp7;
   /* RoleDHabilitation : Role; */
TypUpsVmAdresse ObjetMotDePasse;
   /* Mot de passe encrypte; */
TypUpsVmShort EstSupprime;
   /* Si Vrai, l'utilisateur est supprime. */
} UpsTypUpsSec_1_1_1_0;

/****************************************************************/
typedef struct typprmupssec_1_4_1
/* Objet : Parametre de Utilisateur.Constructeur(NomUtilisateur:*/
/* Caractere, DescriptionUtilisateur:Nul Ou Caractere,          */
/* MotDePasse:Nul Ou Caractere=Nul)                             */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomUtilisateur : Caractere. */
TypUpsVmAdresse UpsVar2;
   /* DescriptionUtilisateur : Nul Ou Caractere. */
TypUpsVmAdresse UpsVar3;
   /* MotDePasse : Nul Ou Caractere. */
} TypPrmUpsSec_1_4_1;

/****************************************************************/
typedef struct typprmupssec_1_5_1
/* Objet : Parametre de Utilisateur.ModifierMotDePasse(         */
/* AncienMotDePasse:Nul Ou Caractere, NouveauMotDePasse:Nul Ou  */
/* Caractere)                                                   */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* AncienMotDePasse : Nul Ou Caractere. */
TypUpsVmAdresse UpsVar2;
   /* NouveauMotDePasse : Nul Ou Caractere. */
} TypPrmUpsSec_1_5_1;

/****************************************************************/
typedef struct typprmupssec_1_6_1
/* Objet : Parametre de Utilisateur.ModifierCalendrier(C:Nul Ou */
/* Calendrier)                                                  */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* C : Nul Ou Calendrier. */
} TypPrmUpsSec_1_6_1;

/****************************************************************/
typedef struct typprmupssec_1_7_1
/* Objet : Parametre de Utilisateur.ModifierHeure(HD:Nul Ou     */
/* Date, HF:Nul Ou Date)                                        */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* HD : Nul Ou Date. */
TypUpsVmAdresse UpsVar2;
   /* HF : Nul Ou Date. */
} TypPrmUpsSec_1_7_1;

/****************************************************************/
typedef struct upstrttypupssec_1_1_1_0
/* Objet : Methodes du type Utilisateur.                        */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmAdresse UpsVmAPI *(*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsSec_1_4_1 *UpsPrm);
   /* Constructeur(NomUtilisateur:Caractere, DescriptionUtilisateur:Nul Ou Caractere, MotDePasse:Nul Ou Caractere=Nul); */
TypUpsVmVoid UpsVmAPI (*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_1_5_1 *UpsPrm);
   /* Procedure ModifierMotDePasse(AncienMotDePasse:Nul Ou Caractere, NouveauMotDePasse:Nul Ou Caractere); */
TypUpsVmVoid UpsVmAPI (*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_1_6_1 *UpsPrm);
   /* Procedure ModifierCalendrier(C:Nul Ou Calendrier); */
TypUpsVmVoid UpsVmAPI (*Mth_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_1_7_1 *UpsPrm);
   /* Procedure ModifierHeure(HD:Nul Ou Date, HF:Nul Ou Date); */
TypUpsVmVoid UpsVmAPI (*Mth_8_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Procedure Supprimer(); */

TypUpsVmCoAppel CoMth_4_1;
   /* Constructeur(NomUtilisateur:Caractere, DescriptionUtilisateur:Nul Ou Caractere, MotDePasse:Nul Ou Caractere=Nul); */
TypUpsVmCoAppel CoMth_5_1;
   /* Procedure ModifierMotDePasse(AncienMotDePasse:Nul Ou Caractere, NouveauMotDePasse:Nul Ou Caractere); */
TypUpsVmCoAppel CoMth_6_1;
   /* Procedure ModifierCalendrier(C:Nul Ou Calendrier); */
TypUpsVmCoAppel CoMth_7_1;
   /* Procedure ModifierHeure(HD:Nul Ou Date, HF:Nul Ou Date); */
TypUpsVmCoAppel CoMth_8_1;
   /* Procedure Supprimer(); */
} UpsTrtTypUpsSec_1_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsSec_1_1_1_0 UpsTypUpsSec_1;
typedef UpsTrtTypUpsSec_1_1_1_0 UpsTrtTypUpsSec_1;

/****************************************************************/
typedef struct upstypupssec_2_1_1_0
/* Objet : Proprietes du type Role.                             */ 
/****************************************************************/
{
TypUpsVmAdresse UpsChamp1;
   /* Nom : Caractere; */
TypUpsVmAdresse UpsChamp2;
   /* Description : Caractere; */
TypUpsVmLong UpsChamp3;
   /* Numero : Entier; */
TypUpsVmAdresse UpsChamp4;
   /* RolePere : Nul Ou Role; */
TypUpsVmAdresse UpsChamp5;
   /* ListeDUtilisateurs:Nul Ou ListeDe Utilisateur; */
TypUpsVmAdresse UpsChamp6;
   /* ListeDHabilitations:Nul Ou ListeDe Habilitations; */
TypUpsVmAdresse UpsChamp7;
   /* ListeDeQuotas:Nul Ou ListeDe Nul Ou Quotas; */
TypUpsVmShort EstSupprime;
   /* Si Vrai, le role est supprime. */
TypUpsVmAdresse AdresseListeUtilisateurs;
   /* Adresse de la liste des utilisateurs directement rattaches a ce role. */
TypUpsVmAdresse AdresseListeRolesFils;
   /* Adresse de la liste des roles fils de ce role. */
TypUpsVmExtension ExtensionQuota;
   /* Extension des quotas sur les entrepots. */
} UpsTypUpsSec_2_1_1_0;

/****************************************************************/
typedef struct typprmupssec_2_4_1
/* Objet : Parametre de Role.Constructeur(NomRole:Caractere,    */
/* DescriptionRole:Caractere)                                   */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomRole:Caractere. */
TypUpsVmAdresse UpsVar2;
   /* DescriptionRole:Caractere. */
} TypPrmUpsSec_2_4_1;

/****************************************************************/
typedef struct typprmupssec_2_5_1
/* Objet : Parametre de Role.HeriterDuRole(R:Nul Ou Role)       */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomRole:Caractere. */
TypUpsVmAdresse UpsVar2;
   /* DescriptionRole:Caractere. */
} TypPrmUpsSec_2_5_1;

/****************************************************************/
typedef struct typprmupssec_2_6_1
/* Objet : Parametre de Role.HeriterDuRole(R:Nul Ou Role)       */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* R:Nul Ou Role. */
} TypPrmUpsSec_2_6_1;

/****************************************************************/
typedef struct typprmupssec_2_7_1
/* Objet : Parametre de Role.AjouterUtilisateur(U:Nul Ou        */
/* Utilisateur)                                                 */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* U:Nul Ou Utilisateur. */
} TypPrmUpsSec_2_7_1;

/****************************************************************/
typedef struct typprmupssec_2_8_1
/* Objet : Parametre de Role.SupprimerUtilisateur(U:Nul Ou      */
/* Utilisateur)                                                 */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* U:Nul Ou Utilisateur. */
} TypPrmUpsSec_2_8_1;

/****************************************************************/
typedef struct typprmupssec_2_9_1
/* Objet : Parametre de Role.AjouterHabilitationAppel(A:Nul Ou  */
/* Appel, ExecutionAutorisee:Booleen)                           */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* A:Nul Ou Appel. */
TypUpsVmUnsignedChar UpsVar2;
   /* ExecutionAutorisee:Booleen. */
} TypPrmUpsSec_2_9_1;

/****************************************************************/
typedef struct typprmupssec_2_10_1
/* Objet : Parametre de Role.ModifierHabilitationAppel(A:Nul Ou */
/* Appel, ExecutionAutorisee:Booleen)                           */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* A:Nul Ou Appel. */
TypUpsVmUnsignedChar UpsVar2;
   /* ExecutionAutorisee:Booleen. */
} TypPrmUpsSec_2_10_1;

/****************************************************************/
typedef struct typprmupssec_2_11_1
/* Objet : Parametre de Role.LireHabilitationAppel(A:Nul Ou     */
/* Appel, ExecutionAutorisee:Booleen Sortie)                    */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* A:Nul Ou Appel. */
TypUpsVmUnsignedChar UpsVar2;
   /* ExecutionAutorisee:Booleen. */
} TypPrmUpsSec_2_11_1;

/****************************************************************/
typedef struct typprmupssec_2_12_1
/* Objet : Parametre de Role.SupprimerHabilitationAppel(A:Nul Ou*/
/* Appel)                                                       */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* A:Nul Ou Appel. */
TypUpsVmUnsignedChar UpsVar2;
   /* ExecutionAutorisee:Booleen. */
} TypPrmUpsSec_2_12_1;

/****************************************************************/
typedef struct typprmupssec_2_13_1
/* Objet : Parametre de Role.AjouterHabilitationType(T:Nul Ou   */
/* Type, CreationAutorisee:Booleen, DestructionAutorisee:       */
/* Booleen, LectureAutorisee:Booleen, ModificationAutorisee:    */
/* Booleen, ExecutionAutorisee:Booleen)                         */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* T:Nul Ou Type. */
TypUpsVmUnsignedChar UpsVar2;
   /* CreationAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar3;
   /* DestructionAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar4;
   /* LectureAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar5;
   /* ModificationAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar6;
   /* ExecutionAutorisee:Booleen. */
} TypPrmUpsSec_2_13_1;

/****************************************************************/
typedef struct typprmupssec_2_14_1
/* Objet : Parametre de Role.ModifierHabilitationType(T:Nul Ou  */
/* Type, CreationAutorisee:Booleen, DestructionAutorisee:       */
/* Booleen, LectureAutorisee:Booleen, ModificationAutorisee:    */
/* Booleen, ExecutionAutorisee:Booleen, AppliquerAuxObjets:     */
/* Booleen=Faux)                                                */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* T:Nul Ou Type. */
TypUpsVmUnsignedChar UpsVar2;
   /* CreationAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar3;
   /* DestructionAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar4;
   /* LectureAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar5;
   /* ModificationAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar6;
   /* ExecutionAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar7;
   /* AppliquerAuxObjets:Booleen. */
} TypPrmUpsSec_2_14_1;

/****************************************************************/
typedef struct typprmupssec_2_15_1
/* Objet : Parametre de Role.LireHabilitationType(T:Nul Ou Type,*/
/* CreationAutorisee:Booleen Sortie, DestructionAutorisee:      */
/* Booleen Sortie, LectureAutorisee:Booleen  Sortie,            */
/* ModificationAutorisee:Booleen Sortie, ExecutionAutorisee:    */
/* Booleen Sortie)                                              */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* T:Nul Ou Type. */
TypUpsVmUnsignedChar UpsVar2;
   /* CreationAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar3;
   /* DestructionAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar4;
   /* LectureAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar5;
   /* ModificationAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar6;
   /* ExecutionAutorisee:Booleen. */
} TypPrmUpsSec_2_15_1;

/****************************************************************/
typedef struct typprmupssec_2_16_1
/* Objet : Parametre de Role.SupprimerHabilitationType(T:Nul Ou */
/* Type, AppliquerAuxObjets:Booleen=Faux)                       */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* T:Nul Ou Type. */
TypUpsVmUnsignedChar UpsVar2;
   /* AppliquerAuxObjets:Booleen. */
} TypPrmUpsSec_2_16_1;

/****************************************************************/
typedef struct typprmupssec_2_17_1
/* Objet : Parametre de Role.AjouterHabilitationMethodeType(M:  */
/* Nul Ou Appel, ExecutionAutorisee:Booleen)                    */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* M:Nul Ou Appel. */
TypUpsVmUnsignedChar UpsVar2;
   /* ExecutionAutorisee:Booleen. */
} TypPrmUpsSec_2_17_1;

/****************************************************************/
typedef struct typprmupssec_2_18_1
/* Objet : Parametre de Role.AjouterHabilitationMethodeType(M:  */
/* Nul Ou Appel, ExecutionAutorisee:Booleen, AppliquerAuxObjets:*/
/* Booleen=Faux)                                                */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* M:Nul Ou Appel. */
TypUpsVmUnsignedChar UpsVar2;
   /* ExecutionAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar3;
   /* AppliquerAuxObjets:Booleen. */
} TypPrmUpsSec_2_18_1;

/****************************************************************/
typedef struct typprmupssec_2_19_1
/* Objet : Parametre de Role.LireHabilitationMethodeType(M:Nul  */
/* Ou Appel, ExecutionAutorisee:Booleen Sortie)                 */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* M:Nul Ou Appel. */
TypUpsVmUnsignedChar UpsVar2;
   /* ExecutionAutorisee:Booleen. */
} TypPrmUpsSec_2_19_1;

/****************************************************************/
typedef struct typprmupssec_2_20_1
/* Objet : Parametre de Role.SupprimerHabilitationMethodeType(  */
/* M:Nul Ou Appel, AppliquerAuxObjets:Booleen=Faux)             */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* M:Nul Ou Appel. */
TypUpsVmUnsignedChar UpsVar2;
   /* AppliquerAuxObjets:Booleen. */
} TypPrmUpsSec_2_20_1;

/****************************************************************/
typedef struct typprmupssec_2_21_1
/* Objet : Parametre de Role.AjouterHabilitationProprieteType(T:*/
/* Nul Ou Type, N:Caractere, CreationAutorisee:Booleen,         */
/* DestructionAutorisee:Booleen, LectureAutorisee:Booleen,      */
/* ModificationAutorisee:Booleen)                               */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* T:Nul Ou Type. */
TypUpsVmAdresse UpsVar2;
   /* N:Caractere. */
TypUpsVmUnsignedChar UpsVar3;
   /* CreationAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar4;
   /* DestructionAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar5;
   /* LectureAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar6;
   /* ModificationAutorisee:Booleen. */
} TypPrmUpsSec_2_21_1;

/****************************************************************/
typedef struct typprmupssec_2_22_1
/* Objet : Parametre de Role.ModifierHabilitationProprieteType( */
/* T:Nul Ou Type, N:Caractere, CreationAutorisee:Booleen,       */
/* DestructionAutorisee:Booleen, LectureAutorisee:Booleen,      */
/* ModificationAutorisee:Booleen, AppliquerAuxObjets:Booleen=   */
/* Faux)                                                        */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* T:Nul Ou Type. */
TypUpsVmAdresse UpsVar2;
   /* N:Caractere. */
TypUpsVmUnsignedChar UpsVar3;
   /* CreationAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar4;
   /* DestructionAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar5;
   /* LectureAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar6;
   /* ModificationAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar7;
   /* AppliquerAuxObjets:Booleen. */
} TypPrmUpsSec_2_22_1;

/****************************************************************/
typedef struct typprmupssec_2_23_1
/* Objet : Parametre de Role.LireHabilitationProprieteType(     */
/* T:Nul Ou Type, N:Caractere, CreationAutorisee:Booleen,       */
/* DestructionAutorisee:Booleen, LectureAutorisee:Booleen,      */
/* ModificationAutorisee:Booleen)                               */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* T:Nul Ou Type. */
TypUpsVmAdresse UpsVar2;
   /* N:Caractere. */
TypUpsVmUnsignedChar UpsVar3;
   /* CreationAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar4;
   /* DestructionAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar5;
   /* LectureAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar6;
   /* ModificationAutorisee:Booleen. */
} TypPrmUpsSec_2_23_1;

/****************************************************************/
typedef struct typprmupssec_2_24_1
/* Objet : Parametre de Role.SupprimerHabilitationProprieteType(*/
/* T:Nul Ou Type, N:Caractere, AppliquerAuxObjets:Booleen=Faux) */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* T:Nul Ou Type. */
TypUpsVmAdresse UpsVar2;
   /* N:Caractere. */
TypUpsVmUnsignedChar UpsVar3;
   /* AppliquerAuxObjets:Booleen. */
} TypPrmUpsSec_2_24_1;

/****************************************************************/
typedef struct typprmupssec_2_25_1
/* Objet : Parametre de Role.AjouterHabilitationObjet(O:Nul Ou  */
/* Objet, CreationAutorisee:Booleen, DestructionAutorisee:      */
/* Booleen, LectureAutorisee:Booleen, ModificationAutorisee:    */
/* Booleen, ExecutionAutorisee:Booleen)                         */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* O:Nul Ou Objet. */
TypUpsVmUnsignedChar UpsVar2;
   /* CreationAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar3;
   /* DestructionAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar4;
   /* LectureAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar5;
   /* ModificationAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar6;
   /* ExecutionAutorisee:Booleen. */
} TypPrmUpsSec_2_25_1;

/****************************************************************/
typedef struct typprmupssec_2_26_1
/* Objet : Parametre de Role.ModifierHabilitationObjet(O:Nul Ou */
/* Objet, CreationAutorisee:Booleen, DestructionAutorisee:      */
/* Booleen, LectureAutorisee:Booleen, ModificationAutorisee:    */
/* Booleen, ExecutionAutorisee:Booleen)                         */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* O:Nul Ou Objet. */
TypUpsVmUnsignedChar UpsVar2;
   /* CreationAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar3;
   /* DestructionAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar4;
   /* LectureAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar5;
   /* ModificationAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar6;
   /* ExecutionAutorisee:Booleen. */
} TypPrmUpsSec_2_26_1;

/****************************************************************/
typedef struct typprmupssec_2_27_1
/* Objet : Parametre de Role.LireHabilitationObjet(O:Nul Ou     */
/* Objet, CreationAutorisee:Booleen, DestructionAutorisee:      */
/* Booleen, LectureAutorisee:Booleen, ModificationAutorisee:    */
/* Booleen, ExecutionAutorisee:Booleen)                         */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* O:Nul Ou Objet. */
TypUpsVmUnsignedChar UpsVar2;
   /* CreationAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar3;
   /* DestructionAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar4;
   /* LectureAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar5;
   /* ModificationAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar6;
   /* ExecutionAutorisee:Booleen. */
} TypPrmUpsSec_2_27_1;

/****************************************************************/
typedef struct typprmupssec_2_28_1
/* Objet : Parametre de Role.SupprimerHabilitationObjet(O:Nul Ou*/
/* Objet)                                                       */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* O:Nul Ou Objet. */
} TypPrmUpsSec_2_28_1;

/****************************************************************/
typedef struct typprmupssec_2_29_1
/* Objet : Parametre de Role.AjouterHabilitationMethodeObjet(O: */
/* Nul Ou Objet, M:Nul Ou Appel, ExecutionAutorisee:Booleen)    */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* O:Nul Ou Objet. */
TypUpsVmAdresse UpsVar2;
   /* M:Nul Ou Appel. */
TypUpsVmUnsignedChar UpsVar3;
   /* ExecutionAutorisee:Booleen. */
} TypPrmUpsSec_2_29_1;

/****************************************************************/
typedef struct typprmupssec_2_30_1
/* Objet : Parametre de Role.ModifierHabilitationMethodeObjet(O:*/
/* Nul Ou Objet, M:Nul Ou Appel, ExecutionAutorisee:Booleen)    */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* O:Nul Ou Objet. */
TypUpsVmAdresse UpsVar2;
   /* M:Nul Ou Appel. */
TypUpsVmUnsignedChar UpsVar3;
   /* ExecutionAutorisee:Booleen. */
} TypPrmUpsSec_2_30_1;

/****************************************************************/
typedef struct typprmupssec_2_31_1
/* Objet : Parametre de Role.LireHabilitationMethodeObjet(O:Nul */
/* Ou Objet, M:Nul Ou Appel, ExecutionAutorisee:Booleen Sortie) */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* O:Nul Ou Objet. */
TypUpsVmAdresse UpsVar2;
   /* M:Nul Ou Appel. */
TypUpsVmUnsignedChar UpsVar3;
   /* ExecutionAutorisee:Booleen. */
} TypPrmUpsSec_2_31_1;

/****************************************************************/
typedef struct typprmupssec_2_32_1
/* Objet : Parametre de Role.SupprimerHabilitationMethodeObjet( */
/* O:Nul Ou Objet, M:Nul Ou Appel)                              */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* O:Nul Ou Objet. */
TypUpsVmAdresse UpsVar2;
   /* M:Nul Ou Appel. */
} TypPrmUpsSec_2_32_1;

/****************************************************************/
typedef struct typprmupssec_2_33_1
/* Objet : Parametre de Role.AjouterHabilitationProprieteObjet( */
/* O:Nul Ou Objet, N:Caractere, CreationAutorisee:Booleen,      */
/* DestructionAutorisee:Booleen, LectureAutorisee:Booleen,      */
/* ModificationAutorisee:Booleen)                               */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* O:Nul Ou Objet. */
TypUpsVmAdresse UpsVar2;
   /* N:Caractere. */
TypUpsVmUnsignedChar UpsVar3;
   /* CreationAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar4;
   /* DestructionAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar5;
   /* LectureAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar6;
   /* ModificationAutorisee:Booleen. */
} TypPrmUpsSec_2_33_1;

/****************************************************************/
typedef struct typprmupssec_2_34_1
/* Objet : Parametre de Role.ModifierHabilitationProprieteObjet(*/
/* O:Nul Ou Objet, N:Caractere, CreationAutorisee:Booleen,      */
/* DestructionAutorisee:Booleen, LectureAutorisee:Booleen,      */
/* ModificationAutorisee:Booleen)                               */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* O:Nul Ou Objet. */
TypUpsVmAdresse UpsVar2;
   /* N:Caractere. */
TypUpsVmUnsignedChar UpsVar3;
   /* CreationAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar4;
   /* DestructionAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar5;
   /* LectureAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar6;
   /* ModificationAutorisee:Booleen. */
} TypPrmUpsSec_2_34_1;

/****************************************************************/
typedef struct typprmupssec_2_35_1
/* Objet : Parametre de Role.LireHabilitationProprieteObjet(O:  */
/* Nul Ou Objet, N:Caractere, CreationAutorisee:Booleen Sortie, */
/* DestructionAutorisee:Booleen Sortie, LectureAutorisee:Booleen*/
/* Sortie, ModificationAutorisee:Booleen Sortie)                */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* O:Nul Ou Objet. */
TypUpsVmAdresse UpsVar2;
   /* N:Caractere. */
TypUpsVmUnsignedChar UpsVar3;
   /* CreationAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar4;
   /* DestructionAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar5;
   /* LectureAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar6;
   /* ModificationAutorisee:Booleen. */
} TypPrmUpsSec_2_35_1;

/****************************************************************/
typedef struct typprmupssec_2_36_1
/* Objet : Parametre de Role.SupprimerHabilitationProprieteObjet*/
/* (O:Nul Ou Objet, N:Caractere)                                */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* O:Nul Ou Objet. */
TypUpsVmAdresse UpsVar2;
   /* N:Caractere. */
} TypPrmUpsSec_2_36_1;

/****************************************************************/
typedef struct typprmupssec_2_37_1
/* Objet : Parametre de Role.AjouterHabilitationVariable(M:Nul  */
/* Ou Module, N:Caractere, LectureAutorisee:Booleen,            */
/* ModificationAutorisee:Booleen)                               */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* M:Nul Ou Module. */
TypUpsVmAdresse UpsVar2;
   /* N:Caractere. */
TypUpsVmUnsignedChar UpsVar3;
   /* LectureAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar4;
   /* ModificationAutorisee:Booleen. */
} TypPrmUpsSec_2_37_1;

/****************************************************************/
typedef struct typprmupssec_2_38_1
/* Objet : Parametre de Role.ModifierHabilitationVariable(M:Nul */
/* Ou Module, N:Caractere, LectureAutorisee:Booleen,            */
/* ModificationAutorisee:Booleen)                               */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* M:Nul Ou Module. */
TypUpsVmAdresse UpsVar2;
   /* N:Caractere. */
TypUpsVmUnsignedChar UpsVar3;
   /* LectureAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar4;
   /* ModificationAutorisee:Booleen. */
} TypPrmUpsSec_2_38_1;

/****************************************************************/
typedef struct typprmupssec_2_39_1
/* Objet : Parametre de Role.LireHabilitationVariable(M:Nul Ou  */
/* Module, N:Caractere, LectureAutorisee:Booleen Sortie,        */
/* ModificationAutorisee:Booleen Sortie)                        */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* M:Nul Ou Module. */
TypUpsVmAdresse UpsVar2;
   /* N:Caractere. */
TypUpsVmUnsignedChar UpsVar3;
   /* LectureAutorisee:Booleen. */
TypUpsVmUnsignedChar UpsVar4;
   /* ModificationAutorisee:Booleen. */
} TypPrmUpsSec_2_39_1;

/****************************************************************/
typedef struct typprmupssec_2_40_1
/* Objet : Parametre de Role.SupprimerHabilitationVariable(M:Nul*/
/* Ou Module, N:Caractere)                                      */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* M:Nul Ou Module. */
TypUpsVmAdresse UpsVar2;
   /* N:Caractere. */
} TypPrmUpsSec_2_40_1;

/****************************************************************/
typedef struct typprmupssec_2_41_1
/* Procedure FixerQuotaEntrepot(E:Nul Ou Entrepot, Q:Entier);   */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E:Nul Ou Entrepot. */
TypUpsVmLong UpsVar2;
   /* Q:Entier. */
} TypPrmUpsSec_2_41_1;

/****************************************************************/
typedef struct typprmupssec_2_42_1
/* Procedure LireQuotaEntrepot(E:Nul Ou Entrepot);              */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E:Nul Ou Entrepot. */
} TypPrmUpsSec_2_42_1;

/****************************************************************/
typedef struct typprmupssec_2_43_1
/* Procedure AjouterQuotaAppel(A:Nul Ou Appel, QuotaMaximal:    */
/* Entier, QuotaProportionnel:Reel);                            */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* A:Nul Ou Appel. */
TypUpsVmLong UpsVar2;
   /* QuotaMaximal:Entier. */
TypUpsVmDouble UpsVar3;
   /* QuotaProportionnel:Reel. */
} TypPrmUpsSec_2_43_1;

/****************************************************************/
typedef struct typprmupssec_2_44_1
/* Procedure ModifierQuotaAppel(A:Nul Ou Appel, QuotaMaximal:   */
/* Entier, QuotaProportionnel:Reel);                            */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* A:Nul Ou Appel. */
TypUpsVmLong UpsVar2;
   /* QuotaMaximal:Entier. */
TypUpsVmDouble UpsVar3;
   /* QuotaProportionnel:Reel. */
} TypPrmUpsSec_2_44_1;

/****************************************************************/
typedef struct typprmupssec_2_45_1
/* Procedure LireQuotaAppel(A:Nul Ou Appel, QuotaMaximal:Entier */
/* Sortie, QuotaProportionnel:Reel Sortie);                     */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* A:Nul Ou Appel. */
TypUpsVmLong UpsVar2;
   /* QuotaMaximal:Entier. */
TypUpsVmDouble UpsVar3;
   /* QuotaProportionnel:Reel. */
} TypPrmUpsSec_2_45_1;

/****************************************************************/
typedef struct typprmupssec_2_46_1
/* Procedure SupprimerQuotaAppel(A:Nul Ou Appel);               */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* A:Nul Ou Appel. */
} TypPrmUpsSec_2_46_1;

/****************************************************************/
typedef struct typprmupssec_2_47_1
/* Procedure AjouterQuotaType(T:Nul Ou Type, Q:Entier,          */
/* QuotaMaximal:Entier, QuotaProportionnel:Reel);               */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* T:Nul Ou Type. */
TypUpsVmLong UpsVar2;
   /* QuotaMaximal:Entier. */
TypUpsVmDouble UpsVar3;
   /* QuotaProportionnel:Reel. */
} TypPrmUpsSec_2_47_1;

/****************************************************************/
typedef struct typprmupssec_2_48_1
/* Procedure ModifierQuotaType(T:Nul Ou Type, QuotaMaximal:     */
/* Entier, QuotaProportionnel:Reel, AppliquerAuxObjets:Booleen);*/
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* T:Nul Ou Type. */
TypUpsVmLong UpsVar2;
   /* QuotaMaximal:Entier. */
TypUpsVmDouble UpsVar3;
   /* QuotaProportionnel:Reel. */
TypUpsVmUnsignedChar UpsVar4;
   /* AppliquerAuxObjets:Booleen. */
} TypPrmUpsSec_2_48_1;

/****************************************************************/
typedef struct typprmupssec_2_49_1
/* Fonction LireQuotaType(T:Nul Ou Type, QuotaMaximal:Entier    */
/* Sortie, QuotaProportionnel:Reel Sortie);                     */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* T:Nul Ou Type. */
TypUpsVmLong UpsVar2;
   /* QuotaMaximal:Entier. */
TypUpsVmDouble UpsVar3;
   /* QuotaProportionnel:Reel. */
} TypPrmUpsSec_2_49_1;

/****************************************************************/
typedef struct typprmupssec_2_50_1
/* Procedure SupprimerQuotaType(T:Nul Ou Type);                 */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* T:Nul Ou Type. */
TypUpsVmUnsignedChar UpsVar2;
   /* AppliquerAuxObjets:Booleen. */
} TypPrmUpsSec_2_50_1;

/****************************************************************/
typedef struct typprmupssec_2_51_1
/* Procedure AjouterQuotaMethodeType(M:Nul Ou Appel,            */
/* QuotaMaximal:Entier, QuotaProportionnel:Reel);               */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* M:Nul Ou Appel. */
TypUpsVmLong UpsVar2;
   /* QuotaMaximal:Entier. */
TypUpsVmDouble UpsVar3;
   /* QuotaProportionnel:Reel. */
} TypPrmUpsSec_2_51_1;

/****************************************************************/
typedef struct typprmupssec_2_52_1
/* Procedure ModifierQuotaMethodeType(M:Nul Ou Appel,           */
/* QuotaMaximal:Entier, QuotaProportionnel:Reel,                */
/* AppliquerAuxObjets:Booleen));                                */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* M:Nul Ou Appel. */
TypUpsVmLong UpsVar2;
   /* QuotaMaximal:Entier. */
TypUpsVmDouble UpsVar3;
   /* QuotaProportionnel:Reel. */
TypUpsVmUnsignedChar UpsVar4;
   /* AppliquerAuxObjets:Booleen. */
} TypPrmUpsSec_2_52_1;

/****************************************************************/
typedef struct typprmupssec_2_53_1
/* Fonction LireQuotaMethodeType(M:Nul Ou Appel, QuotaMaximal:  */
/* Entier Sortie, QuotaProportionnel:Reel Sortie)               */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* M:Nul Ou Appel. */
TypUpsVmLong UpsVar2;
   /* QuotaMaximal:Entier. */
TypUpsVmDouble UpsVar3;
   /* QuotaProportionnel:Reel. */
} TypPrmUpsSec_2_53_1;

/****************************************************************/
typedef struct typprmupssec_2_54_1
/* Procedure SupprimerQuotaMethodeType(M:Nul Ou Appel,          */
/* AppliquerAuxObjets:Booleen=Faux);                            */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* M:Nul Ou Appel. */
TypUpsVmUnsignedChar UpsVar2;
   /* AppliquerAuxObjets:Booleen. */
} TypPrmUpsSec_2_54_1;

/****************************************************************/
typedef struct typprmupssec_2_55_1
/* Procedure AjouterQuotaObjet(O:Nul Ou Objet, QuotaMaximal:    */
/* Entier, QuotaProportionnel:Reel);                            */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* O:Nul Ou Objet. */
TypUpsVmLong UpsVar2;
   /* QuotaMaximal:Entier. */
TypUpsVmDouble UpsVar3;
   /* QuotaProportionnel:Reel. */
} TypPrmUpsSec_2_55_1;

/****************************************************************/
typedef struct typprmupssec_2_56_1
/* Procedure ModifierQuotaObjet(O:Nul Ou Objet, QuotaMaximal:   */
/* Entier, QuotaProportionnel:Reel);                            */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* O:Nul Ou Objet. */
TypUpsVmLong UpsVar2;
   /* QuotaMaximal:Entier. */
TypUpsVmDouble UpsVar3;
   /* QuotaProportionnel:Reel. */
} TypPrmUpsSec_2_56_1;

/****************************************************************/
typedef struct typprmupssec_2_57_1
/* Procedure LireQuotaObjet(O:Nul Ou Objet, QuotaMaximal:Entier */
/* Sortie, QuotaProportionnel:Reel Sortie);                     */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* O:Nul Ou Objet. */
TypUpsVmLong UpsVar2;
   /* QuotaMaximal:Entier. */
TypUpsVmDouble UpsVar3;
   /* QuotaProportionnel:Reel. */
} TypPrmUpsSec_2_57_1;

/****************************************************************/
typedef struct typprmupssec_2_58_1
/* Procedure SupprimerQuotaObjet(O:Nul Ou Objet);               */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* O:Nul Ou Objet. */
} TypPrmUpsSec_2_58_1;

/****************************************************************/
typedef struct typprmupssec_2_59_1
/* Procedure AjouterQuotaMethodeObjet(O:Nul Ou Objet, M:Nul Ou  */
/* Appel, QuotaMaximal:Entier, QuotaProportionnel:Reel);        */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* O:Nul Ou Objet. */
TypUpsVmAdresse UpsVar2;
   /* M:Nul Ou Appel. */
TypUpsVmLong UpsVar3;
   /* QuotaMaximal:Entier. */
TypUpsVmDouble UpsVar4;
   /* QuotaProportionnel:Reel. */
} TypPrmUpsSec_2_59_1;

/****************************************************************/
typedef struct typprmupssec_2_60_1
/* Procedure ModifierQuotaMethodeObjet(O:Nul Ou Objet, M:Nul Ou */
/* Appel, Q:Entier);                                            */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* O:Nul Ou Objet. */
TypUpsVmAdresse UpsVar2;
   /* M:Nul Ou Appel. */
TypUpsVmLong UpsVar3;
   /* QuotaMaximal:Entier. */
TypUpsVmDouble UpsVar4;
   /* QuotaProportionnel:Reel. */
} TypPrmUpsSec_2_60_1;

/****************************************************************/
typedef struct typprmupssec_2_61_1
/* Fonction LireQuotaMethodeObjet(O:Nul Ou Objet, M:Nul Ou      */
/* Appel, QuotaMaximal:Entier Sortie, QuotaProportionnel:Reel   */
/* Sortie);                                                     */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* O:Nul Ou Objet. */
TypUpsVmAdresse UpsVar2;
   /* M:Nul Ou Appel. */
TypUpsVmLong UpsVar3;
   /* QuotaMaximal:Entier. */
TypUpsVmDouble UpsVar4;
   /* QuotaProportionnel:Reel. */
} TypPrmUpsSec_2_61_1;

/****************************************************************/
typedef struct typprmupssec_2_62_1
/* Procedure SupprimerQuotaMethodeObjet(O:Nul Ou Objet, M:Nul Ou*/
/* Appel);                                                      */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* O:Nul Ou Objet. */
TypUpsVmAdresse UpsVar2;
   /* M:Nul Ou Appel. */
} TypPrmUpsSec_2_62_1;

/****************************************************************/
typedef struct upstrttypupssec_2_1_1_0
/* Objet : Methodes du type Role.                               */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmAdresse UpsVmAPI *(*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsSec_2_4_1 *UpsPrm);
   /* Constructeur(NomRole:Caractere, DescriptionRole:Caractere); */
TypUpsVmVoid UpsVmAPI (*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Procedure Supprimer(); */
TypUpsVmVoid UpsVmAPI (*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_6_1 *UpsPrm);
   /* Procedure HeriterDuRole(R:Nul Ou Role); */
TypUpsVmVoid UpsVmAPI (*Mth_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_7_1 *UpsPrm);
   /* Procedure AjouterUtilisateur(U:Nul Ou Utilisateur); */
TypUpsVmVoid UpsVmAPI (*Mth_8_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_8_1 *UpsPrm);
   /* Procedure SupprimerUtilisateur(U:Nul Ou Utilisateur); */
TypUpsVmVoid UpsVmAPI (*Mth_9_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_9_1 *UpsPrm);
   /* Procedure AjouterHabilitationAppel(A:Nul Ou Appel, ExecutionAutorisee:Booleen); */
TypUpsVmVoid UpsVmAPI (*Mth_10_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_10_1 *UpsPrm);
   /* Procedure ModifierHabilitationAppel(A:Nul Ou Appel, ExecutionAutorisee:Booleen); */
TypUpsVmVoid UpsVmAPI (*Mth_11_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_11_1 *UpsPrm);
   /* Procedure LireHabilitationAppel(A:Nul Ou Appel, ExecutionAutorisee:Booleen Sortie); */
TypUpsVmVoid UpsVmAPI (*Mth_12_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_12_1 *UpsPrm);
   /* Procedure SupprimerHabilitationAppel(A:Nul Ou Appel); */
TypUpsVmVoid UpsVmAPI (*Mth_13_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_13_1 *UpsPrm);
   /* Procedure AjouterHabilitationType(T:Nul Ou Type, CreationAutorisee:Booleen, DestructionAutorisee:Booleen, 
      LectureAutorisee:Booleen, ModificationAutorisee:Booleen, ExecutionAutorisee:Booleen); */
TypUpsVmVoid UpsVmAPI (*Mth_14_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_14_1 *UpsPrm);
   /* Procedure ModifierHabilitationType(T:Nul Ou Type, CreationAutorisee:Booleen, DestructionAutorisee:Booleen, 
      LectureAutorisee:Booleen, ModificationAutorisee:Booleen, ExecutionAutorisee:Booleen, AppliquerAuxObjets:Booleen=Faux); */
TypUpsVmVoid UpsVmAPI (*Mth_15_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_15_1 *UpsPrm);
   /* Procedure LireHabilitationType(T:Nul Ou Type, CreationAutorisee:Booleen Sortie, DestructionAutorisee:Booleen Sortie, 
      LectureAutorisee:Booleen  Sortie, ModificationAutorisee:Booleen Sortie, ExecutionAutorisee:Booleen Sortie); */
TypUpsVmVoid UpsVmAPI (*Mth_16_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_16_1 *UpsPrm);
   /* Procedure SupprimerHabilitationType(T:Nul Ou Type, AppliquerAuxObjets:Booleen=Faux); */
TypUpsVmVoid UpsVmAPI (*Mth_17_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_17_1 *UpsPrm);
   /* Procedure AjouterHabilitationMethodeType(M:Nul Ou Appel, ExecutionAutorisee:Booleen); */
TypUpsVmVoid UpsVmAPI (*Mth_18_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_18_1 *UpsPrm);
   /* Procedure ModifierHabilitationMethodeType(M:Nul Ou Appel, ExecutionAutorisee:Booleen, AppliquerAuxObjets:Booleen=Faux); */
TypUpsVmVoid UpsVmAPI (*Mth_19_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_19_1 *UpsPrm);
   /* Procedure LireHabilitationMethodeType(M:Nul Ou Appel, ExecutionAutorisee:Booleen Sortie); */
TypUpsVmVoid UpsVmAPI (*Mth_20_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_20_1 *UpsPrm);
   /* Procedure SupprimerHabilitationMethodeType(M:Nul Ou Appel, AppliquerAuxObjets:Booleen=Faux); */
TypUpsVmVoid UpsVmAPI (*Mth_21_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_21_1 *UpsPrm);
   /* Procedure AjouterHabilitationProprieteType(T:Nul Ou Type, N:Caractere, CreationAutorisee:Booleen, DestructionAutorisee:Booleen, 
      LectureAutorisee:Booleen, ModificationAutorisee:Booleen); */
TypUpsVmVoid UpsVmAPI (*Mth_22_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_22_1 *UpsPrm);
   /* Procedure ModifierHabilitationProprieteType(T:Nul Ou Type, N:Caractere, CreationAutorisee:Booleen, DestructionAutorisee:Booleen, 
      LectureAutorisee:Booleen, ModificationAutorisee:Booleen, AppliquerAuxObjets:Booleen=Faux); */
TypUpsVmVoid UpsVmAPI (*Mth_23_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_23_1 *UpsPrm);
   /* Procedure LireHabilitationProprieteType(T:Nul Ou Type, N:Caractere, CreationAutorisee:Booleen Sortie, DestructionAutorisee:Booleen Sortie, 
      LectureAutorisee:Booleen  Sortie, ModificationAutorisee:Booleen Sortie); */
TypUpsVmVoid UpsVmAPI (*Mth_24_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_24_1 *UpsPrm);
   /* Procedure SupprimerHabilitationProprieteType(T:Nul Ou Type, N:Caractere, AppliquerAuxObjets:Booleen=Faux); */
TypUpsVmVoid UpsVmAPI (*Mth_25_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_25_1 *UpsPrm);
   /* Procedure AjouterHabilitationObjet(O:Nul Ou Objet, CreationAutorisee:Booleen, DestructionAutorisee:Booleen, 
      LectureAutorisee:Booleen, ModificationAutorisee:Booleen, ExecutionAutorisee:Booleen); */
TypUpsVmVoid UpsVmAPI (*Mth_26_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_26_1 *UpsPrm);
   /* Procedure ModifierHabilitationObjet(O:Nul Ou Objet, CreationAutorisee:Booleen, DestructionAutorisee:Booleen, 
      LectureAutorisee:Booleen, ModificationAutorisee:Booleen, ExecutionAutorisee:Booleen); */
TypUpsVmVoid UpsVmAPI (*Mth_27_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_27_1 *UpsPrm);
   /* Procedure LireHabilitationObjet(O:Nul Ou Objet, CreationAutorisee:Booleen Sortie, DestructionAutorisee:Booleen Sortie, 
      LectureAutorisee:Booleen  Sortie, ModificationAutorisee:Booleen Sortie, ExecutionAutorisee:Booleen Sortie); */
TypUpsVmVoid UpsVmAPI (*Mth_28_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_28_1 *UpsPrm);
   /* Procedure SupprimerHabilitationObjet(O:Nul Ou Objet); */
TypUpsVmVoid UpsVmAPI (*Mth_29_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_29_1 *UpsPrm);
   /* Procedure AjouterHabilitationMethodeObjet(O:Nul Ou Objet, M:Nul Ou Appel, ExecutionAutorisee:Booleen); */
TypUpsVmVoid UpsVmAPI (*Mth_30_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_30_1 *UpsPrm);
   /* Procedure ModifierHabilitationMethodeObjet(O:Nul Ou Objet, M:Nul Ou Appel, ExecutionAutorisee:Booleen); */
TypUpsVmVoid UpsVmAPI (*Mth_31_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_31_1 *UpsPrm);
   /* Procedure LireHabilitationMethodeObjet(O:Nul Ou Objet, M:Nul Ou Appel, ExecutionAutorisee:Booleen Sortie); */
TypUpsVmVoid UpsVmAPI (*Mth_32_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_32_1 *UpsPrm);
   /* Procedure SupprimerHabilitationMethodeObjet(O:Nul Ou Objet, M:Nul Ou Appel); */
TypUpsVmVoid UpsVmAPI (*Mth_33_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_33_1 *UpsPrm);
   /* Procedure AjouterHabilitationProprieteObjet(O:Nul Ou Objet, N:Caractere, CreationAutorisee:Booleen, DestructionAutorisee:Booleen, 
      LectureAutorisee:Booleen, ModificationAutorisee:Booleen); */
TypUpsVmVoid UpsVmAPI (*Mth_34_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_34_1 *UpsPrm);
   /* Procedure ModifierHabilitationProprieteObjet(O:Nul Ou Objet, N:Caractere, CreationAutorisee:Booleen, DestructionAutorisee:Booleen, 
      LectureAutorisee:Booleen, ModificationAutorisee:Booleen); */
TypUpsVmVoid UpsVmAPI (*Mth_35_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_35_1 *UpsPrm);
   /* Procedure LireHabilitationProprieteObjet(O:Nul Ou Objet, N:Caractere, CreationAutorisee:Booleen Sortie, DestructionAutorisee:Booleen Sortie, 
      LectureAutorisee:Booleen  Sortie, ModificationAutorisee:Booleen Sortie); */
TypUpsVmVoid UpsVmAPI (*Mth_36_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_36_1 *UpsPrm);
   /* Procedure SupprimerHabilitationProprieteObjet(O:Nul Ou Objet, N:Caractere); */
TypUpsVmVoid UpsVmAPI (*Mth_37_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_37_1 *UpsPrm);
   /* Procedure AjouterHabilitationVariable(M:Nul Ou Module, N:Caractere, LectureAutorisee:Booleen, ModificationAutorisee:Booleen); */
TypUpsVmVoid UpsVmAPI (*Mth_38_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_38_1 *UpsPrm);
   /* Procedure ModifierHabilitationVariable(M:Nul Ou Module, N:Caractere, CreationAutorisee:Booleen, DestructionAutorisee:Booleen, 
      LectureAutorisee:Booleen, ModificationAutorisee:Booleen); */
TypUpsVmVoid UpsVmAPI (*Mth_39_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_39_1 *UpsPrm);
   /* Procedure LireHabilitationVariable(M:Nul Ou Module, N:Caractere, LectureAutorisee:Booleen  Sortie, ModificationAutorisee:Booleen Sortie); */
TypUpsVmVoid UpsVmAPI (*Mth_40_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_40_1 *UpsPrm);
   /* Procedure SupprimerHabilitationVariable(M:Nul Ou Module, N:Caractere); */
TypUpsVmVoid UpsVmAPI (*Mth_41_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_41_1 *UpsPrm);
   /* Procedure FixerQuotaEntrepot(E:Nul Ou Entrepot, Q:Entier); */
TypUpsVmLong UpsVmAPI (*Mth_42_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_42_1 *UpsPrm);
   /* Fonction LireQuotaEntrepot(E:Nul Ou Entrepot); */
TypUpsVmVoid UpsVmAPI (*Mth_43_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_43_1 *UpsPrm);
   /* Procedure AjouterQuotaAppel(A:Nul Ou Appel, QuotaMaximal:Entier, QuotaProportionnel:Reel); */
TypUpsVmVoid UpsVmAPI (*Mth_44_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_44_1 *UpsPrm);
   /* Procedure ModifierQuotaAppel(A:Nul Ou Appel, QuotaMaximal:Entier, QuotaProportionnel:Reel); */
TypUpsVmVoid UpsVmAPI (*Mth_45_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_45_1 *UpsPrm);
   /* Procedure LireQuotaAppel(A:Nul Ou Appel, QuotaMaximal:Entier Sortie, QuotaProportionnel:Reel Sortie); */
TypUpsVmVoid UpsVmAPI (*Mth_46_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_46_1 *UpsPrm);
   /* Procedure SupprimerQuotaAppel(A:Nul Ou Appel); */
TypUpsVmVoid UpsVmAPI (*Mth_47_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_47_1 *UpsPrm);
   /* Procedure AjouterQuotaType(T:Nul Ou Type, Q:Entier, QuotaMaximal:Entier, QuotaProportionnel:Reel); */
TypUpsVmVoid UpsVmAPI (*Mth_48_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_48_1 *UpsPrm);
   /* Procedure ModifierQuotaType(T:Nul Ou Type, Q:Entier, QuotaMaximal:Entier, QuotaProportionnel:Reel); */
TypUpsVmVoid UpsVmAPI (*Mth_49_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_49_1 *UpsPrm);
   /* Procedure LireQuotaType(T:Nul Ou Type, QuotaMaximal:Entier Sortie, QuotaProportionnel:Reel Sortie); */
TypUpsVmVoid UpsVmAPI (*Mth_50_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_50_1 *UpsPrm);
   /* Procedure SupprimerQuotaType(T:Nul Ou Type); */
TypUpsVmVoid UpsVmAPI (*Mth_51_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_51_1 *UpsPrm);
   /* Procedure AjouterQuotaMethodeType(M:Nul Ou Appel, Q:Entier, QuotaMaximal:Entier, QuotaProportionnel:Reel); */
TypUpsVmVoid UpsVmAPI (*Mth_52_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_52_1 *UpsPrm);
   /* Procedure ModifierQuotaMethodeType(M:Nul Ou Appel, Q:Entier, QuotaMaximal:Entier, QuotaProportionnel:Reel, AppliquerAuxObjets:Booleen=Faux); */
TypUpsVmVoid UpsVmAPI (*Mth_53_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_53_1 *UpsPrm);
   /* Procedure LireQuotaMethodeType(M:Nul Ou Appel, QuotaMaximal:Entier Sortie, QuotaProportionnel:Reel Sortie); */
TypUpsVmVoid UpsVmAPI (*Mth_54_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_54_1 *UpsPrm);
   /* Procedure SupprimerQuotaMethodeType(M:Nul Ou Appel, AppliquerAuxObjets:Booleen=Faux); */
TypUpsVmVoid UpsVmAPI (*Mth_55_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_55_1 *UpsPrm);
   /* Procedure AjouterQuotaObjet(O:Nul Ou Objet, Q:Entier, QuotaMaximal:Entier, QuotaProportionnel:Reel); */
TypUpsVmVoid UpsVmAPI (*Mth_56_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_56_1 *UpsPrm);
   /* Procedure ModifierQuotaObjet(O:Nul Ou Objet, Q:Entier, QuotaMaximal:Entier, QuotaProportionnel:Reel); */
TypUpsVmVoid UpsVmAPI (*Mth_57_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_57_1 *UpsPrm);
   /* Procedure LireQuotaObjet(O:Nul Ou Objet, QuotaMaximal:Entier Sortie, QuotaProportionnel:Reel Sortie); */
TypUpsVmVoid UpsVmAPI (*Mth_58_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_58_1 *UpsPrm);
   /* Procedure SupprimerQuotaObjet(O:Nul Ou Objet); */
TypUpsVmVoid UpsVmAPI (*Mth_59_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_59_1 *UpsPrm);
   /* Procedure AjouterQuotaMethodeObjet(O:Nul Ou Objet, M:Nul Ou Appel, QuotaMaximal:Entier, QuotaProportionnel:Reel); */
TypUpsVmVoid UpsVmAPI (*Mth_60_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_60_1 *UpsPrm);
   /* Procedure ModifierQuotaMethodeObjet(O:Nul Ou Objet, M:Nul Ou Appel, QuotaMaximal:Entier, QuotaProportionnel:Reel); */
TypUpsVmVoid UpsVmAPI (*Mth_61_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_61_1 *UpsPrm);
   /* Procedure LireQuotaMethodeObjet(O:Nul Ou Objet, M:Nul Ou Appel, QuotaMaximal:Entier Sortie, QuotaProportionnel:Reel Sortie); */
TypUpsVmVoid UpsVmAPI (*Mth_62_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_2_62_1 *UpsPrm);
   /* Procedure SupprimerQuotaMethodeObjet(O:Nul Ou Objet, M:Nul Ou Appel); */

TypUpsVmCoAppel CoMth_4_1;
   /* Constructeur(NomRole:Caractere, DescriptionRole:Caractere); */
TypUpsVmCoAppel CoMth_5_1;
   /* Procedure Supprimer(); */
TypUpsVmCoAppel CoMth_6_1;
   /* Procedure HeriterDuRole(R:Nul Ou Role); */
TypUpsVmCoAppel CoMth_7_1;
   /* Procedure AjouterUtilisateur(U:Nul Ou Utilisateur); */
TypUpsVmCoAppel CoMth_8_1;
   /* Procedure SupprimerUtilisateur(U:Nul Ou Utilisateur); */
TypUpsVmCoAppel CoMth_9_1;
   /* Procedure AjouterHabilitationAppel(A:Nul Ou Appel, ExecutionAutorisee:Booleen); */
TypUpsVmCoAppel CoMth_10_1;
   /* Procedure ModifierHabilitationAppel(A:Nul Ou Appel, ExecutionAutorisee:Booleen); */
TypUpsVmCoAppel CoMth_11_1;
   /* Procedure LireHabilitationAppel(A:Nul Ou Appel, ExecutionAutorisee:Booleen Sortie); */
TypUpsVmCoAppel CoMth_12_1;
   /* Procedure SupprimerHabilitationAppel(A:Nul Ou Appel); */
TypUpsVmCoAppel CoMth_13_1;
   /* Procedure AjouterHabilitationType(T:Nul Ou Type, CreationAutorisee:Booleen, DestructionAutorisee:Booleen, 
      LectureAutorisee:Booleen, ModificationAutorisee:Booleen, ExecutionAutorisee:Booleen); */
TypUpsVmCoAppel CoMth_14_1;
   /* Procedure ModifierHabilitationType(T:Nul Ou Type, CreationAutorisee:Booleen, DestructionAutorisee:Booleen, 
      LectureAutorisee:Booleen, ModificationAutorisee:Booleen, ExecutionAutorisee:Booleen, AppliquerAuxObjets:Booleen=Faux); */
TypUpsVmCoAppel CoMth_15_1;
   /* Procedure LireHabilitationType(T:Nul Ou Type, CreationAutorisee:Booleen Sortie, DestructionAutorisee:Booleen Sortie, 
      LectureAutorisee:Booleen  Sortie, ModificationAutorisee:Booleen Sortie, ExecutionAutorisee:Booleen Sortie); */
TypUpsVmCoAppel CoMth_16_1;
   /* Procedure SupprimerHabilitationType(T:Nul Ou Type, AppliquerAuxObjets:Booleen=Faux); */
TypUpsVmCoAppel CoMth_17_1;
   /* Procedure AjouterHabilitationMethodeType(M:Nul Ou Appel, ExecutionAutorisee:Booleen); */
TypUpsVmCoAppel CoMth_18_1;
   /* Procedure ModifierHabilitationMethodeType(M:Nul Ou Appel, ExecutionAutorisee:Booleen, AppliquerAuxObjets:Booleen=Faux); */
TypUpsVmCoAppel CoMth_19_1;
   /* Procedure LireHabilitationMethodeType(M:Nul Ou Appel, ExecutionAutorisee:Booleen Sortie); */
TypUpsVmCoAppel CoMth_20_1;
   /* Procedure SupprimerHabilitationMethodeType(M:Nul Ou Appel, AppliquerAuxObjets:Booleen=Faux); */
TypUpsVmCoAppel CoMth_21_1;
   /* Procedure AjouterHabilitationProprieteType(T:Nul Ou Type, N:Caractere, CreationAutorisee:Booleen, DestructionAutorisee:Booleen, 
      LectureAutorisee:Booleen, ModificationAutorisee:Booleen); */
TypUpsVmCoAppel CoMth_22_1;
   /* Procedure ModifierHabilitationProprieteType(T:Nul Ou Type, N:Caractere, CreationAutorisee:Booleen, DestructionAutorisee:Booleen, 
      LectureAutorisee:Booleen, ModificationAutorisee:Booleen, AppliquerAuxObjets:Booleen=Faux); */
TypUpsVmCoAppel CoMth_23_1;
   /* Procedure LireHabilitationProprieteType(T:Nul Ou Type, N:Caractere, CreationAutorisee:Booleen Sortie, DestructionAutorisee:Booleen Sortie, 
      LectureAutorisee:Booleen  Sortie, ModificationAutorisee:Booleen Sortie); */
TypUpsVmCoAppel CoMth_24_1;
   /* Procedure SupprimerHabilitationProprieteType(T:Nul Ou Type, N:Caractere, AppliquerAuxObjets:Booleen=Faux); */
TypUpsVmCoAppel CoMth_25_1;
   /* Procedure AjouterHabilitationObjet(O:Nul Ou Objet, CreationAutorisee:Booleen, DestructionAutorisee:Booleen, 
      LectureAutorisee:Booleen, ModificationAutorisee:Booleen, ExecutionAutorisee:Booleen); */
TypUpsVmCoAppel CoMth_26_1;
   /* Procedure ModifierHabilitationObjet(O:Nul Ou Objet, CreationAutorisee:Booleen, DestructionAutorisee:Booleen, 
      LectureAutorisee:Booleen, ModificationAutorisee:Booleen, ExecutionAutorisee:Booleen); */
TypUpsVmCoAppel CoMth_27_1;
   /* Procedure LireHabilitationObjet(O:Nul Ou Objet, CreationAutorisee:Booleen Sortie, DestructionAutorisee:Booleen Sortie, 
      LectureAutorisee:Booleen  Sortie, ModificationAutorisee:Booleen Sortie, ExecutionAutorisee:Booleen Sortie); */
TypUpsVmCoAppel CoMth_28_1;
   /* Procedure SupprimerHabilitationObjet(O:Nul Ou Objet); */
TypUpsVmCoAppel CoMth_29_1;
   /* Procedure AjouterHabilitationMethodeObjet(O:Nul Ou Objet, M:Nul Ou Appel, ExecutionAutorisee:Booleen); */
TypUpsVmCoAppel CoMth_30_1;
   /* Procedure ModifierHabilitationMethodeObjet(O:Nul Ou Objet, M:Nul Ou Appel, ExecutionAutorisee:Booleen); */
TypUpsVmCoAppel CoMth_31_1;
   /* Procedure LireHabilitationMethodeObjet(O:Nul Ou Objet, M:Nul Ou Appel, ExecutionAutorisee:Booleen Sortie); */
TypUpsVmCoAppel CoMth_32_1;
   /* Procedure SupprimerHabilitationMethodeObjet(O:Nul Ou Objet, M:Nul Ou Appel); */
TypUpsVmCoAppel CoMth_33_1;
   /* Procedure AjouterHabilitationProprieteObjet(O:Nul Ou Objet, N:Caractere, CreationAutorisee:Booleen, DestructionAutorisee:Booleen, 
      LectureAutorisee:Booleen, ModificationAutorisee:Booleen); */
TypUpsVmCoAppel CoMth_34_1;
   /* Procedure ModifierHabilitationProprieteObjet(O:Nul Ou Objet, N:Caractere, CreationAutorisee:Booleen, DestructionAutorisee:Booleen, 
      LectureAutorisee:Booleen, ModificationAutorisee:Booleen); */
TypUpsVmCoAppel CoMth_35_1;
   /* Procedure LireHabilitationProprieteObjet(O:Nul Ou Objet, N:Caractere, CreationAutorisee:Booleen Sortie, DestructionAutorisee:Booleen Sortie, 
      LectureAutorisee:Booleen  Sortie, ModificationAutorisee:Booleen Sortie); */
TypUpsVmCoAppel CoMth_36_1;
   /* Procedure SupprimerHabilitationProprieteObjet(O:Nul Ou Objet, N:Caractere); */
TypUpsVmCoAppel CoMth_37_1;
   /* Procedure AjouterHabilitationVariable(M:Nul Ou Module, N:Caractere, CreationAutorisee:Booleen, DestructionAutorisee:Booleen, 
      LectureAutorisee:Booleen, ModificationAutorisee:Booleen); */
TypUpsVmCoAppel CoMth_38_1;
   /* Procedure ModifierHabilitationVariable(M:Nul Ou Module, N:Caractere, N:Caractere, CreationAutorisee:Booleen, DestructionAutorisee:Booleen, 
      LectureAutorisee:Booleen, ModificationAutorisee:Booleen, AppliquerAuxObjets:Booleen=Faux); */
TypUpsVmCoAppel CoMth_39_1;
   /* Procedure LireHabilitationVariable(M:Nul Ou Module, N:Caractere, CreationAutorisee:Booleen Sortie, DestructionAutorisee:Booleen Sortie, 
      LectureAutorisee:Booleen  Sortie, ModificationAutorisee:Booleen Sortie); */
TypUpsVmCoAppel CoMth_40_1;
   /* Procedure SupprimerHabilitationVariable(M:Nul Ou Module, N:Caractere, AppliquerAuxObjets:Booleen=Faux); */
TypUpsVmCoAppel CoMth_41_1;
   /* Procedure FixerQuotaEntrepot(E:Nul Ou Entrepot, Q:Entier); */
TypUpsVmCoAppel CoMth_42_1;
   /* Fonction LireQuotaEntrepot(E:Nul Ou Entrepot); */
TypUpsVmCoAppel CoMth_43_1;
   /* Procedure AjouterQuotaAppel(A:Nul Ou Appel, QuotaMaximal:Entier, QuotaProportionnel:Reel); */
TypUpsVmCoAppel CoMth_44_1;
   /* Procedure ModifierQuotaAppel(A:Nul Ou Appel, QuotaMaximal:Entier, QuotaProportionnel:Reel); */
TypUpsVmCoAppel CoMth_45_1;
   /* Procedure LireQuotaAppel(A:Nul Ou Appel, QuotaMaximal:Entier Sortie, QuotaProportionnel:Reel Sortie); */
TypUpsVmCoAppel CoMth_46_1;
   /* Procedure SupprimerQuotaAppel(A:Nul Ou Appel); */
TypUpsVmCoAppel CoMth_47_1;
   /* Procedure AjouterQuotaType(T:Nul Ou Type, Q:Entier, QuotaMaximal:Entier, QuotaProportionnel:Reel); */
TypUpsVmCoAppel CoMth_48_1;
   /* Procedure ModifierQuotaType(T:Nul Ou Type, Q:Entier, QuotaMaximal:Entier, QuotaProportionnel:Reel); */
TypUpsVmCoAppel CoMth_49_1;
   /* Procedure LireQuotaType(T:Nul Ou Type, QuotaMaximal:Entier Sortie, QuotaProportionnel:Reel Sortie); */
TypUpsVmCoAppel CoMth_50_1;
   /* Procedure SupprimerQuotaType(T:Nul Ou Type); */
TypUpsVmCoAppel CoMth_51_1;
   /* Procedure AjouterQuotaMethodeType(M:Nul Ou Appel, Q:Entier, QuotaMaximal:Entier, QuotaProportionnel:Reel); */
TypUpsVmCoAppel CoMth_52_1;
   /* Procedure ModifierQuotaMethodeType(M:Nul Ou Appel, Q:Entier, QuotaMaximal:Entier, QuotaProportionnel:Reel, AppliquerAuxObjets:Booleen=Faux); */
TypUpsVmCoAppel CoMth_53_1;
   /* Procedure LireQuotaMethodeType(M:Nul Ou Appel, QuotaMaximal:Entier Sortie, QuotaProportionnel:Reel Sortie); */
TypUpsVmCoAppel CoMth_54_1;
   /* Procedure SupprimerQuotaMethodeType(M:Nul Ou Appel, AppliquerAuxObjets:Booleen=Faux); */
TypUpsVmCoAppel CoMth_55_1;
   /* Procedure AjouterQuotaObjet(O:Nul Ou Objet, Q:Entier, QuotaMaximal:Entier, QuotaProportionnel:Reel); */
TypUpsVmCoAppel CoMth_56_1;
   /* Procedure ModifierQuotaObjet(O:Nul Ou Objet, Q:Entier, QuotaMaximal:Entier, QuotaProportionnel:Reel); */
TypUpsVmCoAppel CoMth_57_1;
   /* Procedure LireQuotaObjet(O:Nul Ou Objet, QuotaMaximal:Entier Sortie, QuotaProportionnel:Reel Sortie); */
TypUpsVmCoAppel CoMth_58_1;
   /* Procedure SupprimerQuotaObjet(O:Nul Ou Objet); */
TypUpsVmCoAppel CoMth_59_1;
   /* Procedure AjouterQuotaMethodeObjet(O:Nul Ou Objet, M:Nul Ou Appel, QuotaMaximal:Entier, QuotaProportionnel:Reel); */
TypUpsVmCoAppel CoMth_60_1;
   /* Procedure ModifierQuotaMethodeObjet(O:Nul Ou Objet, M:Nul Ou Appel, QuotaMaximal:Entier, QuotaProportionnel:Reel); */
TypUpsVmCoAppel CoMth_61_1;
   /* Procedure LireQuotaMethodeObjet(O:Nul Ou Objet, M:Nul Ou Appel, QuotaMaximal:Entier Sortie, QuotaProportionnel:Reel Sortie); */
TypUpsVmCoAppel CoMth_62_1;
   /* Procedure SupprimerQuotaMethodeObjet(O:Nul Ou Objet, M:Nul Ou Appel); */
} UpsTrtTypUpsSec_2_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsSec_2_1_1_0 UpsTypUpsSec_2;
typedef UpsTrtTypUpsSec_2_1_1_0 UpsTrtTypUpsSec_2;

/****************************************************************/
typedef struct upstypupssec_3_1_1_0
/* Objet : Proprietes du type Habilitations.                    */ 
/****************************************************************/
{
TypUpsVmAdresse UpsChamp1;
   /* HabilitationsMere : Nul Ou Habilitations */
TypUpsVmAdresse UpsChamp2;
   /* RolePere : Nul Ou Role */
TypUpsVmUnsignedChar UpsChamp3;
   /* Sorte : SorteHabilitation */
union
   {
   struct
      {
      TypUpsVmAdresse UpsChamp4;
         /* ModuleHabilite : Nul Ou Module */
      TypUpsVmAdresse UpsChamp5;
         /* HabilitationCycleDeVie : Nul Ou HabilitationUnitaire */
      TypUpsVmAdresse UpsChamp6;
         /* ListeDHabilitationsAppels:Nul Ou ListeDe HabilitationUnitaire */
      TypUpsVmAdresse UpsChamp7;
         /* ListeDHabilitationsTypes:Nul Ou ListeDe Habilitations */
      TypUpsVmAdresse UpsChamp8;
         /* ListeDHabilitationsVariables:Nul Ou ListeDe HabilitationUnitaire */
      } UpsCas1;
   /* Pour HabilitationModule */
   struct
      {
      TypUpsVmAdresse UpsChamp9;
         /* TypeHabilite : Nul Ou Type */
      TypUpsVmAdresse UpsChamp10;
         /* HabilitationCycleDeVie : Nul Ou HabilitationUnitaire */
      TypUpsVmAdresse UpsChamp11;
         /* ListeDHabilitationsMethodes:Nul Ou ListeDe HabilitationUnitaire */
      TypUpsVmAdresse UpsChamp12;
         /* ListeDHabilitationsProprietes:Nul Ou ListeDe HabilitationUnitaire */
      TypUpsVmAdresse UpsChamp13;
         /* ListeDHabilitationsObjets:Nul Ou ListeDe Habilitations */
      } UpsCas2;
   /* Pour HabilitationType */
   struct
      {
      TypUpsVmAdresse UpsChamp14;
         /* ObjetHabilite : Nul Ou Objet */
      TypUpsVmAdresse UpsChamp15;
         /* HabilitationCycleDeVie : Nul Ou HabilitationUnitaire */
      TypUpsVmAdresse UpsChamp16;
         /* ListeDHabilitationsMethodes:Nul Ou ListeDe HabilitationUnitaire */
      TypUpsVmAdresse UpsChamp17;
         /* ListeDHabilitationsProprietes:Nul Ou ListeDe HabilitationUnitaire */
      } UpsCas3;
   /* Pour HabilitationObjet */
   } UpsSelon1;
} UpsTypUpsSec_3_1_1_0;

/****************************************************************/
typedef struct upstrttypupssec_3_1_1_0
/* Objet : Methodes du type Habilitations.                      */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmShort UpsVmAPI (*CasSelon1)(TypUpsVmUnsignedShort Valeur);
   /* Sorte. */
TypUpsVmVoid UpsVmAPI (*MAJSelon1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmUnsignedShort ValeurSuivante);
   /* Sorte. */
} UpsTrtTypUpsSec_3_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsSec_3_1_1_0 UpsTypUpsSec_3;
typedef UpsTrtTypUpsSec_3_1_1_0 UpsTrtTypUpsSec_3;

/****************************************************************/
typedef struct upstypupssec_4_1_1_0
/* Objet : Proprietes du type HabilitationUnitaire.             */ 
/****************************************************************/
{
TypUpsVmAdresse UpsChamp1;
   /* HabilitationsMere : Nul Ou Habilitations */
TypUpsVmAdresse UpsChamp2;
   /* Nom : Nul Ou Caractere */
TypUpsVmUnsignedChar UpsChamp3;
   /* CreationAutorisee : Booleen */
TypUpsVmUnsignedChar UpsChamp4;
   /* DestructionAutorisee : Booleen */
TypUpsVmUnsignedChar UpsChamp5;
   /* LectureAutorisee : Booleen */
TypUpsVmUnsignedChar UpsChamp6;
   /* ModificationAutorisee : Booleen */
TypUpsVmUnsignedChar UpsChamp7;
   /* ExecutionAutorisee : Booleen */
} UpsTypUpsSec_4_1_1_0;

/****************************************************************/
typedef struct upstrttypupssec_4_1_1_0
/* Objet : Methodes du type HabilitationUnitaire.               */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */
} UpsTrtTypUpsSec_4_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsSec_4_1_1_0 UpsTypUpsSec_4;
typedef UpsTrtTypUpsSec_4_1_1_0 UpsTrtTypUpsSec_4;

/****************************************************************/
typedef struct upstypupssec_5_1_1_0
/* Objet : Proprietes du type Licences.                         */ 
/****************************************************************/
{
TypUpsVmAdresse UpsChamp1;
   /* LicencesMere : Nul Ou Licences. */
TypUpsVmUnsignedChar UpsChamp2;
   /* Sorte : SorteDeploiementLicence */
union
   {
   struct
      {
      TypUpsVmAdresse UpsChamp3;
         /* ListeDeLicences:Nul Ou ListeDe LicenceUnitaire; */
      TypUpsVmAdresse UpsChamp4;
         /* ListeDeLicencesNoeud:Nul Ou ListeDe Licences; */
      } UpsCas1;
   /* Pour DeploiementLicenceNonAttribuee. */
   struct
      {
      TypUpsVmAdresse UpsChamp5;
         /* NomNoeud : Caractere; */
      TypUpsVmAdresse UpsChamp6;
         /* NomServeur : Caractere; */
      TypUpsVmAdresse UpsChamp7;
         /* ListeDeLicences:Nul Ou ListeDe LicenceUnitaire; */
      TypUpsVmAdresse UpsChamp8;
         /* ListeDeLicencesUtilisateur:Nul Ou ListeDe Licences; */
      } UpsCas2;
   /* Pour DeploiementLicenceNoeud. */
   struct
      {
      TypUpsVmAdresse UpsChamp9;
         /* NomUtilisateur : Caractere; */
      TypUpsVmAdresse UpsChamp10;
         /* ListeDeLicences:Nul Ou ListeDe LicenceUnitaire; */
      } UpsCas3;
   /* Pour DeploiementLicenceUtilisateur. */
   } UpsSelon1;
} UpsTypUpsSec_5_1_1_0;

/****************************************************************/
typedef struct upstrttypupssec_5_1_1_0
/* Objet : Methodes du type Licences.                           */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmShort UpsVmAPI (*CasSelon1)(TypUpsVmUnsignedShort Valeur);
   /* Sorte. */
TypUpsVmVoid UpsVmAPI (*MAJSelon1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmUnsignedShort ValeurSuivante);
   /* Sorte. */
} UpsTrtTypUpsSec_5_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsSec_5_1_1_0 UpsTypUpsSec_5;
typedef UpsTrtTypUpsSec_5_1_1_0 UpsTrtTypUpsSec_5;

/****************************************************************/
typedef struct upstypupssec_6_1_1_0
/* Objet : Proprietes du type LicenceUnitaire.                  */ 
/****************************************************************/
{
TypUpsVmAdresse UpsChamp1;
   /* LicencesMere : Nul Ou Licences */
TypUpsVmAdresse UpsChamp2;
   /* Nom : Caractere */
TypUpsVmAdresse UpsChamp3;
   /* Description : Caractere */
TypUpsVmAdresse UpsChamp4;
   /* NomModuleLicencie : Caractere */
TypUpsVmAdresse UpsChamp5;
   /* Echeance:Nul Ou Date */
TypUpsVmLong UpsChamp6;
   /* NbExecutionsConcurrentesMax:Entier */
TypUpsVmUnsignedChar UpsChamp7;
   /* Sorte: SorteLicence */
TypUpsVmAdresse UpsChamp8;
   /* Editeur : Caractere Lecture Public; */
TypUpsVmAdresse UpsChamp9;
   /* Integrateur : Nul Ou Caractere Lecture Public; */
TypUpsVmAdresse UpsChamp10;
   /* Distributeur : Caractere Lecture Public; */
TypUpsVmAdresse UpsChamp11;
   /* NumeroDeSerie : Caractere Lecture Public; */
TypUpsVmAdresse UpsChamp12;
   /* DateInstallation : Caractere Lecture Public; */
TypUpsVmShort EstSupprimee;
   /* Si Vrai, la licence est supprimee. */
TypUpsVmLong NbExecutionsConcurrentes;
   /* Nombre d'executions concurrentes. */
} UpsTypUpsSec_6_1_1_0;

/****************************************************************/
typedef struct typprmupssec_6_4_1
/* Objet : Parametre de Licence.Constructeur(NomLicence:        */
/* Caractere, DescriptionLicence:Caractere,NomModule:Caractere, */
/* E:Caractere, I:Nul Ou Caractere, D:Caractere, N:Caractere);	 */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomLicence:Caractere. */
TypUpsVmAdresse UpsVar2;
   /* DescriptionLicence:Caractere. */
TypUpsVmAdresse UpsVar3;
   /* NomModule:Caractere. */
TypUpsVmAdresse UpsVar4;
   /* E:Caractere. */
TypUpsVmAdresse UpsVar5;
   /* I:Caractere. */
TypUpsVmAdresse UpsVar6;
   /* D:Nul Ou Caractere. */
TypUpsVmAdresse UpsVar7;
   /* N:Caractere. */
} TypPrmUpsSec_6_4_1;

/****************************************************************/
typedef struct typprmupssec_6_5_1
/* Objet : Parametre de Licence.FixerEcheance(E:Nul Ou Date)    */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E:Nul Ou Date. */
} TypPrmUpsSec_6_5_1;

/****************************************************************/
typedef struct typprmupssec_6_6_1
/* Objet : Parametre de Licence.FixerNbExecutionsConcurrentesMax*/
/*(N:Entier)                                                    */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* N:Entier. */
} TypPrmUpsSec_6_6_1;

/****************************************************************/
typedef struct typprmupssec_6_7_1
/* Objet : Parametre de Licence.FixerSorteLicence(S:            */
/* SorteLicence)                                                */
/****************************************************************/
{
TypUpsVmUnsignedChar UpsVar1;
   /* S:SorteLicence. */
} TypPrmUpsSec_6_7_1;

/****************************************************************/
typedef struct typprmupssec_6_10_1
/* Objet : Procedure Deployer(NomDuNoeud : Nul Ou Caractere,    */
/* NomDuServeur: Nul Ou Caractere, NomDeLUtilisateur : Nul Ou   */
/* Caractere);                                                  */ 
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomDuNoeud:Nul Ou Caractere. */
TypUpsVmAdresse UpsVar2;
   /* NomDuServeur:Nul Ou Caractere. */
TypUpsVmAdresse UpsVar3;
   /* NomDeLUtilisateur:Nul Ou Caractere. */
} TypPrmUpsSec_6_10_1;

/****************************************************************/
typedef struct upstrttypupssec_6_1_1_0
/* Objet : Methodes du type LicenceUnitaire.                    */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmAdresse UpsVmAPI *(*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsSec_6_4_1 *UpsPrm);
   /* Constructeur(NomLicence:Caractere, DescriptionLicence:		 */
   /* Caractere,NomModule:Caractere,E:Caractere, I:Nul Ou			 */
   /* Caractere, D:Caractere, N:Caractere);								 */
TypUpsVmVoid UpsVmAPI (*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_6_5_1 *UpsPrm);
   /* Procedure FixerEcheance(E:Nul Ou Date); */
TypUpsVmVoid UpsVmAPI (*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_6_6_1 *UpsPrm);
   /* Procedure FixerNbExecutionsConcurrentesMax(N:Entier); */
TypUpsVmVoid UpsVmAPI (*Mth_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_6_7_1 *UpsPrm);
   /* Procedure FixerSorteLicence(S:SorteLicence); */
TypUpsVmVoid UpsVmAPI (*Mth_8_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Procedure Supprimer(); */
TypUpsVmLong UpsVmAPI (*Mth_9_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Fonction NbExecutionsConcurrentes() Retourner Entier; */
TypUpsVmVoid UpsVmAPI (*Mth_10_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSec_6_10_1 *UpsPrm);
   /* Procedure Deployer(NomDuNoeud : Nul Ou Caractere, NomDuServeur: Nul Ou Caractere, NomDeLUtilisateur : Nul Ou Caractere); */ 

TypUpsVmCoAppel CoMth_4_1;
   /* Constructeur(NomLicence:Caractere, DescriptionLicence:		 */
   /* Caractere,NomModule:Caractere,E:Caractere, I:Nul Ou			 */
   /* Caractere, D:Caractere, N:Caractere);								 */
TypUpsVmCoAppel CoMth_5_1;
   /* Procedure FixerEcheance(E:Nul Ou Date); */
TypUpsVmCoAppel CoMth_6_1;
   /* Procedure FixerNbExecutionsConcurrentesMax(N:Entier); */
TypUpsVmCoAppel CoMth_7_1;
   /* Procedure FixerSorteLicence(S:SorteLicence); */
TypUpsVmCoAppel CoMth_8_1;
   /* Procedure Supprimer(); */
TypUpsVmCoAppel CoMth_9_1;
   /* Fonction NbExecutionsConcurrentes() Retourner Entier; */
TypUpsVmCoAppel CoMth_10_1;
   /* Procedure Deployer(NomDuNoeud : Nul Ou Caractere, NomDuServeur: Nul Ou Caractere, NomDeLUtilisateur : Nul Ou Caractere); */ 
} UpsTrtTypUpsSec_6_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsSec_6_1_1_0 UpsTypUpsSec_6;
typedef UpsTrtTypUpsSec_6_1_1_0 UpsTrtTypUpsSec_6;

/****************************************************************/
typedef struct upstypupssec_7_1_1_0
/* Objet : Proprietes du type Quotas.                           */ 
/****************************************************************/
{
TypUpsVmAdresse UpsChamp1;
   /* QuotaMere : Nul Ou Quotas; */
TypUpsVmAdresse UpsChamp2;
   /* RolePere : Nul Ou Role */
TypUpsVmUnsignedChar UpsChamp3;
   /* Sorte : SorteQuota; */
union
   {
   struct
      {
      TypUpsVmAdresse UpsChamp4;
         /* ModuleQuantifie : Nul Ou Module */
      TypUpsVmAdresse UpsChamp5;
         /* QuotaParDefaut : Nul Ou QuantiteUnitaire */
      TypUpsVmAdresse UpsChamp6;
         /* ListeDeQuotasAppels:Nul Ou ListeDe QuotaUnitaire */
      TypUpsVmAdresse UpsChamp7;
         /* ListeDeQuotasTypes:Nul Ou ListeDe Nul Ou Quotas */
      } UpsCas1;
   /* Pour QuotaModule. */ 
   struct
      {
      TypUpsVmAdresse UpsChamp8;
         /* TypeQuantifie : Nul Ou Type */
      TypUpsVmAdresse UpsChamp9;
         /* QuotaParDefaut : Nul Ou QuantiteUnitaire */
      TypUpsVmAdresse UpsChamp10;
         /* ListeDeQuotasMethodes:Nul Ou ListeDe QuotaUnitaire */
      TypUpsVmAdresse UpsChamp11;
         /* ListeDeQuotasObjets:Nul Ou ListeDe Nul Ou Quotas */
      } UpsCas2;
   /* Pour QuotaType. */
   struct
      {
      TypUpsVmAdresse UpsChamp12;
         /* ObjetQuantifie : Nul Ou Objet */
      TypUpsVmAdresse UpsChamp13;
         /* QuotaParDefaut : Nul Ou QuantiteUnitaire */
      TypUpsVmAdresse UpsChamp14;
         /* ListeDeQuotasMethodes:Nul Ou ListeDe QuotaUnitaire */
      } UpsCas3;
   /* Pour QuotaObjet. */
   } UpsSelon1;
} UpsTypUpsSec_7_1_1_0;

/****************************************************************/
typedef struct upstrttypupssec_7_1_1_0
/* Objet : Methodes du type Quotas.                             */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmShort UpsVmAPI (*CasSelon1)(TypUpsVmUnsignedShort Valeur);
   /* Sorte. */
TypUpsVmVoid UpsVmAPI (*MAJSelon1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmUnsignedShort ValeurSuivante);
   /* Sorte. */
} UpsTrtTypUpsSec_7_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsSec_7_1_1_0 UpsTypUpsSec_7;
typedef UpsTrtTypUpsSec_7_1_1_0 UpsTrtTypUpsSec_7;

/****************************************************************/
typedef struct upstypupssec_8_1_1_0
/* Objet : Proprietes du type QuotaUnitaire.                    */ 
/****************************************************************/
{
TypUpsVmAdresse UpsChamp1;
   /* QuotasMere : Nul Ou Quotas */
TypUpsVmAdresse UpsChamp2;
   /* Nom : Nul Ou Caractere */
TypUpsVmLong UpsChamp3;
   /* QuotaMaximal : Entier */
TypUpsVmDouble UpsChamp4;
   /* QuotaProportionnel : Reel */
} UpsTypUpsSec_8_1_1_0;

/****************************************************************/
typedef struct upstrttypupssec_8_1_1_0
/* Objet : Methodes du type QuotaUnitaire.                      */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */
} UpsTrtTypUpsSec_8_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsSec_8_1_1_0 UpsTypUpsSec_8;
typedef UpsTrtTypUpsSec_8_1_1_0 UpsTrtTypUpsSec_8;

/****************************************************************/
typedef struct typupssecdonnees
/* Objet: Interface des donnees de Ups Sec.                     */
/****************************************************************/
{
struct typupsvmentetedonneesmodule EnteteDonneesModule;
   /* Entete generique du module. */
} *TypUpsSecDonnees;

/****************************************************************/
typedef struct typprmupssec_1_1
/* Objet : Procedure Connecter(U:Caractere, M:Caractere, S:Nul  */
/* Ou Serveur=Nul);								                      */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* U:Caractere. */
TypUpsVmAdresse UpsVar2;
   /* M:Caractere. */
TypUpsVmAdresse UpsVar3;
   /* S : Nul Ou Serveur. */
} TypPrmUpsSec_1_1;

/****************************************************************/
typedef struct typprmupssec_2_1
/* Objet : Procedure Deconnecter(S:Nul Ou Serveur);             */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* S:Nul Ou Serveur. */
} TypPrmUpsSec_2_1;

/****************************************************************/
typedef struct typprmupssec_4_1
/* Objet : Fonction Optimiser Crypter(Cle:Nul Ou Caractere,     */
/* Chaine:Nul Ou Caractere) Retourner Nul Ou Caractere;         */ 
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Cle:Nul Ou Caractere. */
TypUpsVmAdresse UpsVar2;
   /* Chaine:Nul Ou Caractere. */
} TypPrmUpsSec_4_1;

/****************************************************************/
typedef struct typprmupssec_5_1
/* Objet : Fonction Optimiser Decrypter(Cle:Nul Ou Caractere,   */
/* Chaine:Nul Ou Caractere) Retourner Nul Ou Caractere.         */ 
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Cle:Nul Ou Caractere. */
TypUpsVmAdresse UpsVar2;
   /* Chaine:Nul Ou Caractere. */
} TypPrmUpsSec_5_1;

/****************************************************************/
typedef struct typupssectraitements_1_1_0
/* Objet: Interface des traitements de Ups Sec.                 */
/****************************************************************/
{
struct typupsvmentetemethodesmodule EnteteMethodesModule;
   /* Methodes generiques au module. */ 

/*--------------------------------------------------------------*/
/* Procedures et fonctions.                                     */
/*--------------------------------------------------------------*/
TypUpsVmLong UpsVmAPI (*CalculerIndexAppel)(TypUpsVmPointeurDonnees InterfaceAppel, TypUpsVmPointeurDonnees AppelCourant);
   /* Objet : Calcule l'index de l'appel. */
TypUpsVmVoid UpsVmAPI (*Trt_1_1)(TypUpsVmSession *Session, TypPrmUpsSec_1_1 *UpsPrm);
   /* Objet : Procedure Connecter(U:Caractere, M:Caractere, S:Nul Ou Serveur=Nul); */
TypUpsVmVoid UpsVmAPI (*Trt_2_1)(TypUpsVmSession *Session, TypPrmUpsSec_2_1 *UpsPrm);
   /* Objet : Procedure Deconnecter(S:Nul Ou Serveur);  */
TypUpsVmAdresse UpsVmAPI *(*Trt_3_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat);
   /* Objet : Fonction LireUtilisateurCourant() Retourner Nul Ou Utilisateur. */ 
TypUpsVmAdresse UpsVmAPI *(*Trt_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat,
   TypPrmUpsSec_4_1 *UpsPrm);
   /* Objet : Fonction Optimiser Crypter(Cle:Nul Ou Caractere, Chaine:Nul Ou Caractere) Retourner Nul Ou Caractere. */ 
TypUpsVmAdresse UpsVmAPI *(*Trt_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat,
   TypPrmUpsSec_5_1 *UpsPrm);
   /* Objet : Fonction Optimiser Decrypter(Cle:Nul Ou Caractere, Chaine:Nul Ou Caractere) Retourner Nul Ou Caractere. */ 

TypUpsVmCoAppel CoTrt_1_1;
   /* Objet : Procedure Connecter(U:Caractere, M:Caractere, S:Nul Ou Serveur=Nul); */
TypUpsVmCoAppel CoTrt_2_1;
   /* Objet : Procedure Deconnecter(S:Nul Ou Serveur);  */
TypUpsVmCoAppel CoTrt_3_1;
   /* Objet : Fonction LireUtilisateurCourant() Retourner Nul Ou Utilisateur. */ 
TypUpsVmCoAppel CoTrt_4_1;
   /* Objet : Fonction Optimiser Crypter(Cle:Nul Ou Caractere, Chaine:Nul Ou Caractere) Retourner Nul Ou Caractere. */ 
TypUpsVmCoAppel CoTrt_5_1;
   /* Objet : Fonction Optimiser Decrypter(Cle:Nul Ou Caractere, Chaine:Nul Ou Caractere) Retourner Nul Ou Caractere. */ 

/*--------------------------------------------------------------*/
/* Tables des methodes.                                         */
/*--------------------------------------------------------------*/
UpsTrtTypUpsSec_1 *UpsTrt1;
   /* Methodes de Utilisateur. */ 
UpsTrtTypUpsSec_2 *UpsTrt2;
   /* Methodes de Role. */ 
UpsTrtTypUpsSec_3 *UpsTrt3;
   /* Methodes de Habilitations. */ 
UpsTrtTypUpsSec_4 *UpsTrt4;
   /* Methodes de HabilitationUnitaire. */ 
UpsTrtTypUpsSec_5 *UpsTrt5;
   /* Methodes de Licences. */ 
UpsTrtTypUpsSec_6 *UpsTrt6;
   /* Methodes de LicenceUnitaire. */ 
UpsTrtTypUpsSec_7 *UpsTrt7;
   /* Methodes de Quotas. */ 
UpsTrtTypUpsSec_8 *UpsTrt8;
   /* Methodes de QuotaUnitaire. */ 

/*--------------------------------------------------------------*/
/* Enumeres.			              				                   */
/*--------------------------------------------------------------*/
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_1_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_1_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* SorteHabilitation. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_2_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_2_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* SorteLicence. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_3_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_3_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* SorteDeploiementLicence. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_4_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* SorteQuota. */

/*--------------------------------------------------------------*/
/* Entrepots.          								                   */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Types et interfaces.                                         */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*UpsType1_get)(TypUpsVmSession *Session);
   /* Type Utilisateur. */
TypUpsVmLong UpsVmAPI (*UpsIndex1_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Utilisateur. */ 
TypUpsVmAdresse UpsVmAPI *(*UpsType2_get)(TypUpsVmSession *Session);
   /* Type Role. */
TypUpsVmLong UpsVmAPI (*UpsIndex2_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Role. */ 
TypUpsVmAdresse UpsVmAPI *(*UpsType3_get)(TypUpsVmSession *Session);
   /* Type Habilitations. */
TypUpsVmLong UpsVmAPI (*UpsIndex3_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Habilitations. */ 
TypUpsVmAdresse UpsVmAPI *(*UpsType4_get)(TypUpsVmSession *Session);
   /* Type HabilitationUnitaire. */
TypUpsVmLong UpsVmAPI (*UpsIndex4_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type HabilitationUnitaire. */ 
TypUpsVmAdresse UpsVmAPI *(*UpsType5_get)(TypUpsVmSession *Session);
   /* Type Licences. */
TypUpsVmLong UpsVmAPI (*UpsIndex5_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Licences. */ 
TypUpsVmAdresse UpsVmAPI *(*UpsType6_get)(TypUpsVmSession *Session);
   /* Type LicenceUnitaire. */
TypUpsVmLong UpsVmAPI (*UpsIndex6_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type LicenceUnitaire. */ 
TypUpsVmAdresse UpsVmAPI *(*UpsType7_get)(TypUpsVmSession *Session);
   /* Type Quotas. */
TypUpsVmLong UpsVmAPI (*UpsIndex7_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Quotas. */ 
TypUpsVmAdresse UpsVmAPI *(*UpsType8_get)(TypUpsVmSession *Session);
   /* Type QuotaUnitaire. */
TypUpsVmLong UpsVmAPI (*UpsIndex8_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type QuotaUnitaire. */ 

/*--------------------------------------------------------------*/
/* Variables globales.                                          */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*UpsVar1_get)(TypUpsVmSession *Session);
   /* UtilisateurAdministrateur : Nul Ou Utilisateur Lecture Public; */
TypUpsVmAdresse UpsVmAPI *(*UpsVar2_get)(TypUpsVmSession *Session);
   /* UtilisateurSpoule : Nul Ou Utilisateur Lecture Public; */
TypUpsVmAdresse UpsVmAPI *(*UpsVar3_get)(TypUpsVmSession *Session);
   /* RoleAdministrateur : Nul Ou Role Lecture Public; */
TypUpsVmAdresse UpsVmAPI *(*UpsVar4_get)(TypUpsVmSession *Session);
   /* RolePublic : Nul Ou Role Lecture Public; */
TypUpsVmAdresse UpsVmAPI *(*UpsVar5_get)(TypUpsVmSession *Session);
   /* ListeDeLicences : Nul Ou Licences; */

/*--------------------------------------------------------------*/
/* Exceptions.                                                  */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*UpsException1_get)(TypUpsVmSession *Session);
   /* Exception ConnectionImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException2_get)(TypUpsVmSession *Session);
   /* Exception CreationUtilisateurImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException3_get)(TypUpsVmSession *Session);
   /* Exception ChangementMotDePasseImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException4_get)(TypUpsVmSession *Session);
   /* Exception CreationRoleImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException5_get)(TypUpsVmSession *Session);
   /* Exception HeritageRoleImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException6_get)(TypUpsVmSession *Session);
   /* Exception CreationHabilitationImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException7_get)(TypUpsVmSession *Session);
   /* Exception LireHabilitationImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException8_get)(TypUpsVmSession *Session);
   /* Exception ModificationHabilitationImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException9_get)(TypUpsVmSession *Session);
   /* Exception SuppressionHabilitationImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException10_get)(TypUpsVmSession *Session);
   /* Exception HabilitationViolee. */
TypUpsVmAdresse UpsVmAPI *(*UpsException11_get)(TypUpsVmSession *Session);
   /* Exception LicenceViolee. */
TypUpsVmAdresse UpsVmAPI *(*UpsException12_get)(TypUpsVmSession *Session);
   /* Exception AjoutUtilisateurImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException13_get)(TypUpsVmSession *Session);
   /* Exception SuppressionUtilisateurImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException14_get)(TypUpsVmSession *Session);
   /* Exception QuotaEntrepotDepasse. */
TypUpsVmAdresse UpsVmAPI *(*UpsException15_get)(TypUpsVmSession *Session);
   /* Exception CreationQuotaImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException16_get)(TypUpsVmSession *Session);
   /* Exception LireQuotaImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException17_get)(TypUpsVmSession *Session);
   /* Exception ModificationQuotaImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException18_get)(TypUpsVmSession *Session);
   /* Exception SuppressionQuotaImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException19_get)(TypUpsVmSession *Session);
   /* Exception QuotaTempsDepasse. */

/*--------------------------------------------------------------*/
/* Files d'attente.                                             */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Application Program Interfaces proprietaires.                */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*InitialiserEncapsulationKernel)(TypUpsVmVoid);
   /* Objet : Initialisation de l'extension de Ups Sec pour Ups Krn. */
TypUpsVmVoid UpsVmAPI (*TerminerEncapsulationKernel)(TypUpsVmVoid);
   /* Objet : Terminaison de l'extension de Ups Sec pour Ups Krn. */
TypUpsVmUnicode UpsVmAPI *(*Crypter)(TypUpsVmSession *Session, TypUpsVmUnicode *Chaine, TypUpsVmUnicode *Buffer, 
	TypUpsVmLong TailleBuffer);
   /* Objet : Crypte le message. */
TypUpsVmUnicode UpsVmAPI *(*Decrypter)(TypUpsVmSession *Session, TypUpsVmUnicode *Chaine, TypUpsVmUnicode *Buffer,
	TypUpsVmLong TailleBuffer);
   /* Objet : Decrypte le message. */
TypUpsVmVoid UpsVmAPI (*ConnecterServeur)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetUtilisateur);
   /* Objet : Connexion rapide pour un serveur sans interaction avec la gestion des transactions. */ 
TypUpsVmVoid UpsVmAPI (*VerifierHabilitationAppel)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetAppel, TypUpsVmUnicode *NomAppel, 
   TypUpsVmAdresse *AdresseObjetModule, enum EnuUpsSecVerificationHabilitation Action);
   /* Objet : Verifie une habilitation sur un appel. */
TypUpsVmVoid UpsVmAPI (*VerifierHabilitationType)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetType, enum EnuUpsSecVerificationHabilitation Action);
   /* Objet : Verifie une habilitation sur un objet. */
TypUpsVmVoid UpsVmAPI (*VerifierHabilitationObjet)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, enum EnuUpsSecVerificationHabilitation Action);
   /* Objet : Verifie une habilitation sur un objet. */
TypUpsVmVoid UpsVmAPI (*VerifierHabilitationMethode)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
	TypUpsVmUnicode *NomMethode, enum EnuUpsSecVerificationHabilitation Action);
   /* Objet : Verifie une habilitation sur une methode. */
TypUpsVmVoid UpsVmAPI (*VerifierHabilitationPropriete)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
	TypUpsVmUnicode *NomPropriete, enum EnuUpsSecVerificationHabilitation Action);
   /* Objet : Verifie une habilitation sur une propriete. */
TypUpsVmVoid UpsVmAPI (*VerifierHabilitationVariable)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetNomVariable, 
   TypUpsVmUnicode *NomVariable, TypUpsVmAdresse *AdresseObjetModule, enum EnuUpsSecVerificationHabilitation Action);
   /* Objet : Verifie une habilitation sur une variable. */
TypUpsVmEnteteMethodesModule UpsVmAPI (*LireInterfaceModule)(TypUpsVmSession *Session, TypUpsVmUnicode *NomModule, 
	TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction,
   enum EnuUpsVtmLireInterface ChargerSiNonExistant, TypUpsVmShort SorteLicence);
   /* Lit l'interface des traitements du module demande et retourne le au module appelant. */
TypUpsVmVoid UpsVmAPI (*LireInterfaceModule2)(TypUpsVmSession *Session, TypUpsVmUnicode *NomModule, 
   TypUpsVmUnicode *NomNoeud, TypUpsVmUnicode *NomServeur, TypUpsVmShort NbChargements, TypUpsVmShort SorteLicence);
   /* Objet : Verifie la licence. */
TypUpsVmShort UpsVmAPI (*SupprimerModule)(TypUpsVmSession *Session, TypUpsVmShort NumeroModule, TypUpsVmShort SorteLicence);
   /* Objet : Libere un jeton sur une licence. */
TypUpsVmVoid UpsVmAPI (*SupprimerModule2)(TypUpsVmSession *Session, TypUpsVmUnicode *NomModule, 
	TypUpsVmUnicode *NomNoeud, TypUpsVmUnicode *NomServeur, TypUpsVmShort NbChargements);
   /* Objet : Libere un jeton sur une licence. */
TypUpsVmUnsignedChar UpsVmAPI (*ExtraireChampEnumereCourt)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmLong Offset, TypUpsVmUnicode *NomPropriete);
   /* Objet : Extrait un champ enumere court de l'objet. */
TypUpsVmUnsignedShort UpsVmAPI (*ExtraireChampEnumereLong)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmLong Offset, TypUpsVmUnicode *NomPropriete);
   /* Objet : Extrait un champ TypUpsVmLong court de l'objet. */
TypUpsVmLong UpsVmAPI (*ExtraireChampEntier)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmLong Offset, TypUpsVmUnicode *NomPropriete);
   /* Objet : Extrait un champ entier de l'objet. */
TypUpsVmDouble UpsVmAPI (*ExtraireChampReel)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmLong Offset, TypUpsVmUnicode *NomPropriete);
   /* Objet : Extrait un champ reel de l'objet. */
TypUpsVmAdresse UpsVmAPI *(*ExtraireChampObjet)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat,
   TypUpsVmAdresse *AdresseObjet, TypUpsVmLong Offset, TypUpsVmUnicode *NomPropriete);
   /* Objet : Extrait un champ de l'objet. */
TypUpsVmVoid UpsVmAPI (*MiseAJourChampEnumereCourt)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmLong Offset, TypUpsVmUnsignedChar EnumereCourt, TypUpsVmUnicode *NomPropriete);
   /* Objet : Met a jour d'un champ enumere court de l'objet. */
TypUpsVmVoid UpsVmAPI (*MiseAJourChampEnumereLong)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmLong Offset, TypUpsVmUnsignedShort EnumereLong, TypUpsVmUnicode *NomPropriete);
   /* Objet : Mise a jour d'un champ TypUpsVmLong court de l'objet. */
TypUpsVmVoid UpsVmAPI (*MiseAJourChampEntier)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmLong Offset, TypUpsVmLong Entier, enum EnuUpsVmOperateur Operateur, TypUpsVmUnicode *NomPropriete);
   /* Objet : Mise a jour d'un champ entier de l'objet. */
TypUpsVmVoid UpsVmAPI (*MiseAJourChampReel)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmLong Offset, TypUpsVmDouble Reel, enum EnuUpsVmOperateur Operateur, TypUpsVmUnicode *NomPropriete);
   /* Objet : Mise a jour d'un champ reel de l'objet. */
TypUpsVmVoid UpsVmAPI (*MiseAJourChampObjet)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypUpsVmLong Offset, 
   TypUpsVmAdresse *AdresseObjet2, TypUpsVmUnicode *NomPropriete);
   /* Objet : Mise a jour d'un champ de l'objet. */
TypUpsVmVoid UpsVmAPI (*MethodeComposerChampObjet)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypUpsVmLong Offset,
   TypUpsVmAdresse *ObjetP, TypUpsKrnAppliquerMethodeAComposer MethodeComposer, enum EnuUpsVmOperateur Operateur, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, TypUpsVmUnicode *NomPropriete);
   /* Objet : Applique un operateur compose a un champ d'un type. */
TypUpsVmVoid UpsVmAPI (*MiseAJourChampNul)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypUpsVmLong Offset, TypUpsVmUnicode *NomPropriete);
   /* Objet : Mise a jour d'un champ de l'objet a Nul. */
TypUpsVmLong UpsVmAPI (*IncrementerDecrementerChampEntier)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmLong Offset, TypUpsVmChar Incrementer, TypUpsVmChar Prefixe, TypUpsVmUnicode *NomPropriete);
   /* Objet : Incremente ou decremente un champ entier de l'objet. */
TypUpsVmDouble UpsVmAPI (*IncrementerDecrementerChampReel)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmLong Offset, TypUpsVmChar Incrementer, TypUpsVmChar Prefixe, TypUpsVmUnicode *NomPropriete);
   /* Objet : Incremente ou decremente un champ reel de l'objet. */
TypUpsVmAdresse UpsVmAPI *(*IncrementerDecrementerChampObjet)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmAdresse *AdresseObjet, TypUpsVmLong Offset, TypUpsVmChar Incrementer, TypUpsVmChar Prefixe, TypUpsKrnAppliquerMethodeAIncrementer Methode, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, TypUpsVmUnicode *NomPropriete);
   /* Objet : Incremente ou decremente un champ d'un objet. */
TypUpsVmVoid UpsVmAPI (*DetruireChampObjet)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmLong Offset, TypUpsVmUnicode *NomPropriete);
   /* Objet : Detruit le champ de l'objet. */
TypUpsVmVoid UpsVmAPI (*AugmenterUsageEntrepot)(TypUpsVmSession *Session, TypUpsVmUnsignedShort NumeroEntrepot,
	TypUpsVmLong Taille);
   /* Objet : Augmente l'usage de l'entrepot vis-a-vis des quotas. */
TypUpsVmVoid UpsVmAPI (*DiminuerUsageEntrepot)(TypUpsVmSession *Session, TypUpsVmUnsignedShort NumeroEntrepot,
	TypUpsVmLong Taille);
   /* Objet : Diminue l'usage de l'entrepot vis-a-vis des quotas. */
TypUpsVmVoid UpsVmAPI (*FixerUsageEntrepot)(TypUpsVmSession *Session, TypUpsVmUnsignedShort NumeroEntrepot, 
   TypUpsVmLong TailleMaximale);
   /* Objet : Fixe l'usage de l'entrepot vis-a-vis des quotas. */
TypUpsVmLong UpsVmAPI (*LireUsageEntrepot)(TypUpsVmSession *Session, TypUpsVmUnsignedShort NumeroEntrepot);
   /* Objet : Lire l'usage de l'entrepot vis-a-vis des quotas. */
TypUpsVmVoid UpsVmAPI (*LireQuotaAppel)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetAppel, 
	TypUpsVmUnicode *NomAppel, TypUpsVmAdresse *AdresseObjetModule, TypUpsVmLong *QuotaMaximal, TypUpsVmDouble *QuotaProportionnel);
   /* Objet : Lit le quota sur un appel. */
TypUpsVmVoid UpsVmAPI (*LireQuotaMethode)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
	TypUpsVmUnicode *NomMethode, TypUpsVmLong *QuotaMaximal, TypUpsVmDouble *QuotaProportionnel);
   /* Objet : Lite le quota sur une methode. */
TypUpsVmShort UpsVmAPI (*ChargerFichierLicences)(TypUpsVmVoid);
   /* Objet : Chargement du fichier de licences. */
TypUpsVmVoid UpsVmAPI (*SupprimerHabilitationsEtQuotasModule)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetModule);
   /* Objet : Supprime les habilitations et les quotas sur le module et ses definitions. */
} *TypUpsSecTraitements_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsSecTraitements_1_1_0 TypUpsSecTraitements;

extern DllExport TypUpsVtmDemarrer UpsVmAPI UpsSecDemarrerModule(TypUpsVmShort Numero, TypUpsVtmMachineInterface MachineInterfaceUpsVtm,
   TypUpsVtmTraitements IntTrtUpsVtm, TypUpsVtmDonnees IntDonUpsVtm);

/**********************/
#if defined(__cplusplus)
/**********************/
}
/****/
#endif
/****/

/****/
#endif
/****/
