/*-------------------------------------------------------------------
Fichier     : upsorb.e
Objet       : En-tete du module Up ! Object Request Broker.

Module      : Up ! Object Request Broker
Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.
---------------------------------------------------------------------
                         Observations

 
---------------------------------------------------------------------*/

/*****************************/
#if !defined(PasseModuleUpsOrb)
/*****************************/
#define PasseModuleUpsOrb 1

/**********************/
#if defined(__cplusplus)
/**********************/
extern "C"
{
/****/
#endif
/****/

/****************************************************************/
typedef struct upstypupsorb_1_1_1_0
/* Objet : Proprietes du type Annuaire.                         */
/****************************************************************/
{
TypUpsVmAdresse UpsChamp1;
   /* NomAnnuaire : Caractere. */
TypUpsVmShort EstCharge;
   /* Si Vrai, l'annuaire est charge. */
TypUpsVmShort EstModifie;
   /* Si Vrai, l'annuaire est modifie. */
TypUpsVmAdresse AdresseListePremiersNiveaux;
   /* Liste des premiers niveaux; */
} UpsTypUpsOrb_1_1_1_0;

/****************************************************************/
typedef struct typprmupsorb_1_4_1
/* Objet : Parametre de Annuaire.Constructeur(                  */
/* NomDeLAnnuaire:Caractere);                                   */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomDeLAnnuaire:Caractere; */
} TypPrmUpsOrb_1_4_1;

/****************************************************************/
typedef struct typprmupsorb_1_5_1
/* Objet : Parametre de Annuaire.LireArborescenceAnnuaire(      */
/* Chemin:Nul Ou Caractere) Retourner Nul Ou ListeDe Caractere; */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Chemin:Nul Ou Caractere; */
} TypPrmUpsOrb_1_5_1;

/****************************************************************/
typedef struct typprmupsorb_1_6_1
/* Objet : Parametre de Annuaire.LireEntree(NomEntree:Nul Ou    */
/* Caractere) Retourner Nul Ou Objet;                           */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomEntree:Nul Ou Caractere; */
} TypPrmUpsOrb_1_6_1;

/****************************************************************/
typedef struct typprmupsorb_1_7_1
/* Objet : Parametre de EcrireEntree(NomEntree:Nul Ou Caractere,*/
/* ValeurEntree:Nul Ou Objet);                                  */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomEntree:Nul Ou Caractere; */
TypUpsVmAdresse UpsVar2;
   /* ValeurEntree:Nul Ou Objet; */
} TypPrmUpsOrb_1_7_1;

/****************************************************************/
typedef struct typprmupsorb_1_8_1
/* Objet : Parametre de SupprimerEntree(NomEntree:Nul Ou        */
/* Caractere, SupprimerRecursivement:Booleen=Faux);             */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomEntree:Nul Ou Caractere; */
TypUpsVmChar UpsVar2;
  /* SupprimerRecursivement:Booleen. */
} TypPrmUpsOrb_1_8_1;

/****************************************************************/
typedef struct typprmupsorb_1_9_1
/* Objet : Parametre de RenommerEntree(NomEntreeAvant:Nul Ou    */
/* Caractere, NomEntreeApres:Nul Ou Caractere,                  */
/* RenommerRecursivement:Booleen);                              */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomEntreeAvant:Nul Ou Caractere; */
TypUpsVmAdresse UpsVar2;
   /* NomEntreeApres:Nul Ou Caractere; */
TypUpsVmChar UpsVar3;
   /* RenommerRecursivement:Booleen; */
} TypPrmUpsOrb_1_9_1;

/****************************************************************/
typedef struct upstrttypupsorb_1_1_1_0
/* Objet : Methodes du type Annuaire.                           */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmAdresse UpsVmAPI *(*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsOrb_1_4_1 *UpsPrm);
   /* Objet : Constructeur(NomDeLAnnuaire:Caractere) Retourner Entier); */
TypUpsVmAdresse UpsVmAPI *(*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsOrb_1_5_1 *UpsPrm);
   /* Objet : Fonction LireArborescenceAnnuaire(Chemin:Nul Ou Caractere) Retourner Nul Ou ListeDe Caractere. */
TypUpsVmAdresse UpsVmAPI *(*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsOrb_1_6_1 *UpsPrm);
   /* Objet : Fonction LireEntree(NomEntree:Nul Ou Caractere) Retourner Nul Ou Objet; */
TypUpsVmVoid UpsVmAPI (*Mth_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsOrb_1_7_1 *UpsPrm);
   /* Objet : Procedure EcrireEntree(NomEntree:Nul Ou Caractere, ValeurEntree:Nul Ou Objet). */
TypUpsVmVoid UpsVmAPI (*Mth_8_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsOrb_1_8_1 *UpsPrm);
   /* Objet : Procedure SupprimerEntree(NomEntree:Nul Ou Caractere, SupprimerRecursivement:Booleen=Faux). */
TypUpsVmVoid UpsVmAPI (*Mth_9_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsOrb_1_9_1 *UpsPrm);
   /* Objet : Procedure RenommerEntree(NomEntreeAvant:Nul Ou Caractere, NomEntreeApres:Nul Ou Caractere, RenommerRecursivement:Booleen). */
TypUpsVmVoid UpsVmAPI (*Mth_10_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Procedure Enregistrer(). */

TypUpsVmCoAppel CoMth_4_1;
   /* Objet : Constructeur(NomDeLAnnuaire:Caractere) Retourner Entier); */
TypUpsVmCoAppel CoMth_5_1;
   /* Objet : Fonction LireArborescenceAnnuaire(Chemin:Nul Ou Caractere) Retourner Nul Ou ListeDe Caractere. */
TypUpsVmCoAppel CoMth_6_1;
   /* Objet : Fonction LireEntree(NomEntree:Nul Ou Caractere) Retourner Nul Ou Objet; */
TypUpsVmCoAppel CoMth_7_1;
   /* Objet : Procedure EcrireEntree(NomEntree:Nul Ou Caractere, ValeurEntree:Nul Ou Objet). */
TypUpsVmCoAppel CoMth_8_1;
   /* Objet : Procedure SupprimerEntree(NomEntree:Nul Ou Caractere, SupprimerRecursivement:Booleen=Faux). */
TypUpsVmCoAppel CoMth_9_1;
   /* Objet : Procedure RenommerEntree(NomEntreeAvant:Nul Ou Caractere, NomEntreeApres:Nul Ou Caractere, RenommerRecursivement:Booleen). */
TypUpsVmCoAppel CoMth_10_1;
   /* Objet : Procedure Enregistrer(). */
} UpsTrtTypUpsOrb_1_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsOrb_1_1_1_0 UpsTypUpsOrb_1;
typedef UpsTrtTypUpsOrb_1_1_1_0 UpsTrtTypUpsOrb_1;

/****************************************************************/
typedef struct upstypupsorb_2_1_1_0
/* Objet : Proprietes du type Annuaire.                         */
/****************************************************************/
{
TypUpsVmAdresse AdresseNomEntree;
   /* Nom de l'entree. */
TypUpsVmAdresse AdresseValeurEntree;
   /* Valeur de l'entree. */
TypUpsVmAdresse AdresseListeSousNiveaux;
   /* Liste des sous-niveaux; */
} UpsTypUpsOrb_2_1_1_0;

/****************************************************************/
typedef struct upstrttypupsorb_2_1_1_0
/* Objet : Methodes du type NiveauAnnuaire.                     */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */
} UpsTrtTypUpsOrb_2_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsOrb_2_1_1_0 UpsTypUpsOrb_2;
typedef UpsTrtTypUpsOrb_2_1_1_0 UpsTrtTypUpsOrb_2;

/****************************************************************/
typedef struct typprmupsorb_3_1
/* Objet : AjouterNoeud(NomDuNoeud:Caractere,						 */
/* AdresseDeLOrbDuNoeud:Caractere);				                   */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomDuNoeud:Caractere. */
TypUpsVmAdresse UpsVar2;
   /* AdresseDeLOrbDuNoeud:Caractere. */
} TypPrmUpsOrb_3_1;

/****************************************************************/
typedef struct typprmupsorb_4_1
/* Objet : SupprimerNoeud(NomNoeud:Caractere)                   */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomDuNoeud:Caractere. */
} TypPrmUpsOrb_4_1;

/****************************************************************/
typedef struct typprmupsorb_6_1
/* Objet : ArreterNoeud(NomNoeud:Caractere)                     */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomDuNoeud:Caractere. */
} TypPrmUpsOrb_6_1;

/****************************************************************/
typedef struct typprmupsorb_7_1
/* Objet : AjouterServeur(NomDuNoeud:Caractere, NomDuServeur:   */
/* Caractere, AdresseDuServeur:Caractere)                       */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomDuNoeud:Caractere. */
TypUpsVmAdresse UpsVar2;
   /* NomDuServeur:Caractere. */
TypUpsVmAdresse UpsVar3;
   /* AdresseDuServeur:Caractere. */
} TypPrmUpsOrb_7_1;

/****************************************************************/
typedef struct typprmupsorb_8_1
/* Objet : SupprimerServeur(NomDuNoeud:Caractere, NomDuServeur: */
/* Caractere)                                                   */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomDuNoeud:Caractere. */
TypUpsVmAdresse UpsVar2;
   /* NomDuServeur:Caractere. */
} TypPrmUpsOrb_8_1;

/****************************************************************/
typedef struct typprmupsorb_9_1
/* Objet : ChercherModule(NomDuModule:Caractere, VersionDuModule*/
/* :Entier, RevisionDuModule:Entier, CorrectionDuModule:Entier, */
/* NomDuNoeud:Nul Ou Caractere Entree Sortie, NomDuServeur:Nul  */
/* Ou Caractere Entree Sortie, AdresseDuServeur:Nul Ou          */
/* Caractere Sortie)                                            */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomDuModule:Caractere. */
TypUpsVmLong UpsVar2;
   /* VersionDuModule. */
TypUpsVmLong UpsVar3;
   /* RevisionDuModule. */
TypUpsVmLong UpsVar4;
   /* CorrectionDuModule. */
TypUpsVmAdresse UpsVar5;
   /* NomDuNoeud:Caractere. */
TypUpsVmAdresse UpsVar6;
   /* NomDuServeur:Caractere. */
TypUpsVmAdresse UpsVar7;
   /* AdresseDuServeur:Caractere. */
} TypPrmUpsOrb_9_1;

/****************************************************************/
typedef struct typprmupsorb_10_1
/* Objet : AjouterModule(NomDuNoeud:Caractere, NomDuServeur:    */
/* Caractere, NomDuModule:Caractere, VersionDuModule:Entier,    */
/* RevisionDuModule:Entier, CorrectionDuModule:Entier)          */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomDuNoeud:Caractere. */
TypUpsVmAdresse UpsVar2;
   /* NomDuServeur:Caractere. */
TypUpsVmAdresse UpsVar3;
   /* NomDuModule:Caractere. */
TypUpsVmLong UpsVar4;
   /* VersionDuModule : Entier; */
TypUpsVmLong UpsVar5;
   /* RevisionDuModule : Entier; */
TypUpsVmLong UpsVar6;
   /* CorrectionDuModule : Entier; */
} TypPrmUpsOrb_10_1;

/****************************************************************/
typedef struct typprmupsorb_11_1
/* Objet : SupprimerModule(NomDuNoeud:Caractere, NomDuServeur:  */
/* Caractere, NomDuModule:Caractere, VersionDuModule:Entier,    */
/* RevisionDuModule:Entier, CorrectionDuModule:Entier)          */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomDuNoeud:Caractere. */
TypUpsVmAdresse UpsVar2;
   /* NomDuServeur:Caractere. */
TypUpsVmAdresse UpsVar3;
   /* NomDuModule:Caractere. */
TypUpsVmLong UpsVar4;
   /* VersionDuModule : Entier; */
TypUpsVmLong UpsVar5;
   /* RevisionDuModule : Entier; */
TypUpsVmLong UpsVar6;
   /* CorrectionDuModule : Entier; */
} TypPrmUpsOrb_11_1;

/****************************************************************/
typedef struct typprmupsorb_12_1
/* Procedure StatistiquesServeurs(NomDuNoeud:Caractere,         */
/* NomDuServeur:Caractere, NbSecondesTravaillees:Entier,        */
/* NbSecondesTravailleesAuTotal:Entier, NbSoumissions:Entier,   */
/* NbSoumissionsAuTotal:Entier, PourcentageUtilisation:Reel);   */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomDuNoeud:Caractere. */
TypUpsVmAdresse UpsVar2;
   /* NomDuServeur:Caractere. */
TypUpsVmLong UpsVar3;
   /* NbSecondesTravaillees:Entier. */
TypUpsVmLong UpsVar4;
   /* NbSecondesTravailleesAuTotal:Entier. */
TypUpsVmLong UpsVar5;
   /* NbSoumissions:Entier. */
TypUpsVmLong UpsVar6;
   /* NbSoumissionsAuTotal:Entier. */
TypUpsVmDouble UpsVar7;
   /* PourcentageUtilisation:Reel. */
} TypPrmUpsOrb_12_1;

/****************************************************************/
typedef struct typprmupsorb_16_1
/* Objet : LireEntreeAnnuaireGlobal(E:Nul Ou Caractere)         */
/* Retourner Nul Ou Objet                                       */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E:Nul Ou Caractere. */
} TypPrmUpsOrb_16_1;

/****************************************************************/
typedef struct typprmupsorb_17_1
/* Objet : LireArborescenceAnnuaireGlobal(Chemin:Nul Ou         */
/* Caractere) Retourner Nul Ou ListeDe Caractere                */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Chemin:Nul Ou Caractere. */
} TypPrmUpsOrb_17_1;

/****************************************************************/
typedef struct typupsorbdonnees
/* Interface de donnees publiques de UpsOrb.                    */
/****************************************************************/
{
struct typupsvmentetedonneesmodule EnteteDonneesModule;
   /* Entete generique du module. */
TypUpsVmUnicode NomNoeudMaitre[CO_TailleIdf+1];
   /* Nom de la machine d'execution de Ups Orb maitre. */
TypUpsVmUnsignedShort NumeroNoeudMaitre;
   /* Numero du noeud du serveur Ups Orb maitre. */
TypUpsVmUnsignedShort NumeroNoeud;
   /* Numero du noeud du serveur Ups Orb local. */
TypUpsVmUnsignedShort NumeroServeur;
   /* Numero du serveur local. */
TypUpsVmUnsignedShort NumeroServeurOrb;
   /* Numero du serveur Orb local. */
/*--------------------------------------------------------------*/
/* Libelle des APIs frequentes dans la langue courante.         */
/*--------------------------------------------------------------*/
TypUpsVmUnicode *AjouterModule;
   /* Libelle de AjouterModule. */
TypUpsVmUnicode *AjouterNoeud;
   /* Libelle de AjouterNoeud. */
TypUpsVmUnicode *AjouterServeur;
   /* Libelle de AjouterServeur. */
TypUpsVmUnicode *ArreterServeursLocaux;
   /* Libelle de ArreterServeursLocaux. */
TypUpsVmUnicode *ArreterServeursUpsOrb;
   /* Libelle de ArreterServeursUpsOrb. */
TypUpsVmUnicode *ChargerConfiguration;
   /* Libelle de ChargerConfiguration. */
TypUpsVmUnicode *DemarrerNoeud;
   /* Libelle de DemarrerNoeud. */
TypUpsVmUnicode *Enregistrer;
   /* Libelle de Enregistrer. */
TypUpsVmUnicode *EcrireEntree;
   /* Libelle de EcrireEntree. */
TypUpsVmUnicode *EnregistrerConfiguration;
   /* Libelle de EnregistrerConfiguration. */
TypUpsVmUnicode *RenommerEntree;
   /* Libelle de RenommerEntree. */
TypUpsVmUnicode *StatistiquesServeur;
   /* Libelle de StatistiquesServeur. */
TypUpsVmUnicode *SupprimerEntree;
   /* Libelle de SupprimerEntree. */
TypUpsVmUnicode *SupprimerModule;
   /* Libelle de SupprimerModule. */
TypUpsVmUnicode *SupprimerNoeud;
   /* Libelle de SupprimerNoeud. */
TypUpsVmUnicode *SupprimerServeur;
   /* Libelle de SupprimerServeur. */
} *TypUpsOrbDonnees;

/****************************************************************/
typedef struct typupsorbtraitements_1_1_0
/* Interface de traitements de UpsOrb.                          */
/****************************************************************/
{
struct typupsvmentetemethodesmodule EnteteMethodesModule;
   /* Entete generique du module. */

/*--------------------------------------------------------------*/
/* Procedures et fonctions.                                     */
/*--------------------------------------------------------------*/
TypUpsVmLong UpsVmAPI (*CalculerIndexAppel)(TypUpsVmPointeurDonnees InterfaceAppel, TypUpsVmPointeurDonnees AppelCourant);
   /* Objet : Calcule l'index de l'appel. */
TypUpsVmVoid UpsVmAPI (*Trt_1_1)(TypUpsVmSession *Session);
   /* Procedure ChargerConfiguration(); */
TypUpsVmVoid UpsVmAPI (*Trt_2_1)(TypUpsVmSession *Session);
   /* LireConfiguration(); */
TypUpsVmVoid UpsVmAPI (*Trt_3_1)(TypUpsVmSession *Session, TypPrmUpsOrb_3_1 *UpsPrm);
   /* Procedure AjouterNoeud(NomNoeud:Caractere, AdresseDeLOrbDuNoeud:Caractere); */
TypUpsVmVoid UpsVmAPI (*Trt_4_1)(TypUpsVmSession *Session, TypPrmUpsOrb_4_1 *UpsPrm);
   /* Procedure SupprimerNoeud(NomNoeud:Caractere); */
TypUpsVmVoid UpsVmAPI (*Trt_5_1)(TypUpsVmSession *Session);
   /* Procedure DemarrerNoeud(); */
TypUpsVmVoid UpsVmAPI (*Trt_6_1)(TypUpsVmSession *Session, TypPrmUpsOrb_6_1 *UpsPrm);
   /* Procedure ArreterNoeud(NomNoeud:Caractere); */
TypUpsVmVoid UpsVmAPI (*Trt_7_1)(TypUpsVmSession *Session, TypPrmUpsOrb_7_1 *UpsPrm);
   /* Procedure AjouterServeur(NomDuNoeud:Caractere, NomDuServeur:Caractere, AdresseDuServeur:Caractere); */
TypUpsVmVoid UpsVmAPI (*Trt_8_1)(TypUpsVmSession *Session, TypPrmUpsOrb_8_1 *UpsPrm);
   /* Procedure SupprimerServeur(NomDuNoeud:Caractere, NomDuServeur:Caractere); */
TypUpsVmVoid UpsVmAPI (*Trt_9_1)(TypUpsVmSession *Session, TypPrmUpsOrb_9_1 *UpsPrm);
   /* Procedure ChercherModule(NomDuModule:Caractere, VersionDuModule:Entier, */
   /* RevisionDuModule:Entier, CorrectionDuModule:Entier, NomDuNoeud:Nul Ou Caractere Entree Sortie, */
   /* NomDuServeur:Nul Ou Caractere Entree Sortie, AdresseDuServeur:Nul Ou Caractere Sortie) */
TypUpsVmVoid UpsVmAPI (*Trt_10_1)(TypUpsVmSession *Session, TypPrmUpsOrb_10_1 *UpsPrm);
   /* Procedure AjouterModule(NomDuNoeud:Caractere, NomDuServeur:Caractere, NomDuModule:Caractere, */
   /* VersionDuModule:Entier, RevisionDuModule:Entier, CorrectionDuModule:Entier); */
TypUpsVmVoid UpsVmAPI (*Trt_11_1)(TypUpsVmSession *Session, TypPrmUpsOrb_11_1 *UpsPrm);
   /* Procedure SupprimerModule(NomDuNoeud:Caractere, NomDuServeur:Caractere, NomDuModule:Caractere, */
   /* VersionDuModule:Entier, RevisionDuModule:Entier, CorrectionDuModule:Entier); */
TypUpsVmVoid UpsVmAPI (*Trt_12_1)(TypUpsVmSession *Session, TypPrmUpsOrb_12_1 *UpsPrm);
   /* Procedure StatistiquesServeurs(NomDuNoeud:Caractere, NomDuServeur:Caractere, */
   /* NbSecondesTravaillees2:Entier, NbSecondesTravailleesAuTotal2:Entier, NbTransactions2:Entier, */
   /* NbTransactionsAuTotal2:Entier, PourcentageUtilisation2:Reel); */
TypUpsVmVoid UpsVmAPI (*Trt_13_1)(TypUpsVmSession *Session);
   /* Procedure ArreterServeursUpsOrb(); */
TypUpsVmVoid UpsVmAPI (*Trt_14_1)(TypUpsVmSession *Session);
   /* Procedure ArreterServeursLocaux(); */
TypUpsVmVoid UpsVmAPI (*Trt_15_1)(TypUpsVmSession *Session);
   /* Procedure EnregistrerConfiguration(); */
TypUpsVmAdresse UpsVmAPI *(*Trt_16_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsOrb_16_1 *UpsPrm);
   /* Fonction LireEntreeAnnuaireGlobal(E:Nul Ou Caractere) Retourner Nul Ou Objet; */
TypUpsVmAdresse UpsVmAPI *(*Trt_17_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsOrb_17_1 *UpsPrm);
   /* Fonction LireArborescenceAnnuaireGlobal(Chemin:Nul Ou Caractere) Retourner Nul Ou ListeDe Caractere; */

TypUpsVmCoAppel CoTrt_1_1;
   /* Procedure ChargerConfiguration(); */
TypUpsVmCoAppel CoTrt_2_1;
   /* LireConfiguration(); */
TypUpsVmCoAppel CoTrt_3_1;
   /* Procedure AjouterNoeud(NomNoeud:Caractere, AdresseDeLOrbDuNoeud:Caractere); */
TypUpsVmCoAppel CoTrt_4_1;
   /* Procedure SupprimerNoeud(NomNoeud:Caractere); */
TypUpsVmCoAppel CoTrt_5_1;
   /* Procedure DemarrerNoeud(); */
TypUpsVmCoAppel CoTrt_6_1;
   /* Procedure ArreterNoeud(NomNoeud:Caractere); */
TypUpsVmCoAppel CoTrt_7_1;
   /* Procedure AjouterServeur(NomDuNoeud:Caractere, NomDuServeur:Caractere, AdresseDuServeur:Caractere); */
TypUpsVmCoAppel CoTrt_8_1;
   /* Procedure SupprimerServeur(NomDuNoeud:Caractere, NomDuServeur:Caractere); */
TypUpsVmCoAppel CoTrt_9_1;
   /* Procedure ChercherModule(NomDuModule:Caractere, VersionDuModule:Entier, */
   /* RevisionDuModule:Entier, CorrectionDuModule:Entier, NomDuNoeud:Nul Ou Caractere Entree Sortie, */
   /* NomDuServeur:Nul Ou Caractere Entree Sortie, AdresseDuServeur:Nul Ou Caractere Sortie) */
TypUpsVmCoAppel CoTrt_10_1;
   /* Procedure AjouterModule(NomDuNoeud:Caractere, NomDuServeur:Caractere, NomDuModule:Caractere, */
   /* VersionDuModule:Entier, RevisionDuModule:Entier, CorrectionDuModule:Entier); */
TypUpsVmCoAppel CoTrt_11_1;
   /* Procedure SupprimerModule(NomDuNoeud:Caractere, NomDuServeur:Caractere, NomDuModule:Caractere, */
   /* VersionDuModule:Entier, RevisionDuModule:Entier, CorrectionDuModule:Entier); */
TypUpsVmCoAppel CoTrt_12_1;
   /* Procedure StatistiquesServeurs(NomDuNoeud:Caractere, NomDuServeur:Caractere, */
   /* NbSecondesTravaillees2:Entier, NbSecondesTravailleesAuTotal2:Entier, NbTransactions2:Entier, */
   /* NbTransactionsAuTotal2:Entier, PourcentageUtilisation2:Reel); */
TypUpsVmCoAppel CoTrt_13_1;
   /* Procedure ArreterServeursUpsOrb(); */
TypUpsVmCoAppel CoTrt_14_1;
   /* Procedure ArreterServeursLocaux(); */
TypUpsVmCoAppel CoTrt_15_1;
   /* Procedure EnregistrerConfiguration(); */
TypUpsVmCoAppel CoTrt_16_1;
   /* Fonction LireEntreeAnnuaireGlobal(E:Nul Ou Caractere) Retourner Nul Ou Objet; */
TypUpsVmCoAppel CoTrt_17_1;
   /* Fonction LireArborescenceAnnuaireGlobal(Chemin:Nul Ou Caractere) Retourner Nul Ou ListeDe Caractere; */

/*--------------------------------------------------------------*/
/* Tables des methodes.                                         */
/*--------------------------------------------------------------*/
UpsTrtTypUpsOrb_1 *UpsTrt1;
   /* Methodes de Annuaire. */ 
UpsTrtTypUpsOrb_2 *UpsTrt2;
   /* Methodes de NiveauAnnuaire. */ 

/*--------------------------------------------------------------*/
/* Enumeres.			              				                   */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Entrepots.          								                   */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Types et interfaces.                                         */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*UpsType1_get)(TypUpsVmSession *Session);
   /* Type Annuaire. */
TypUpsVmLong UpsVmAPI (*UpsIndex1_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Annuaire. */ 
TypUpsVmAdresse UpsVmAPI *(*UpsType2_get)(TypUpsVmSession *Session);
   /* Type NiveauAnnuaire. */
TypUpsVmLong UpsVmAPI (*UpsIndex2_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type NiveauAnnuaire. */ 

/*--------------------------------------------------------------*/
/* Variables globales.                                          */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*UpsVar1_get)(TypUpsVmSession *Session);
   /* NomNoeudMaitre. */
TypUpsVmChar UpsVmAPI (*UpsVar2_get)(TypUpsVmSession *Session);
   /* EstLeServeurMaitre. */
TypUpsVmLong UpsVmAPI (*UpsVar3_get)(TypUpsVmSession *Session);
   /* NbNoeuds. */
TypUpsVmLong UpsVmAPI (*UpsVar4_get)(TypUpsVmSession *Session);
   /* NbServeursPersistantsMax. */
TypUpsVmLong UpsVmAPI (*UpsVar5_get)(TypUpsVmSession *Session);
   /* NbSecondesTravaillees. */
TypUpsVmLong UpsVmAPI (*UpsVar6_get)(TypUpsVmSession *Session);
   /* NbSecondesTravailleesAuTotal. */
TypUpsVmLong UpsVmAPI (*UpsVar7_get)(TypUpsVmSession *Session);
   /* NbSoumissions. */
TypUpsVmLong UpsVmAPI (*UpsVar8_get)(TypUpsVmSession *Session);
   /* NbSoumissionsAuTotal. */
TypUpsVmDouble UpsVmAPI (*UpsVar9_get)(TypUpsVmSession *Session);
   /* PourcentageUtilisation. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar10_get)(TypUpsVmSession *Session);
   /* AnnuaireLocal. */

/*--------------------------------------------------------------*/
/* Exceptions.                                                  */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*UpsException1_get)(TypUpsVmSession *Session);
   /* Exception NoeudInconnu. */
TypUpsVmAdresse UpsVmAPI *(*UpsException2_get)(TypUpsVmSession *Session);
   /* Exception ServeurInconnu2. */
TypUpsVmAdresse UpsVmAPI *(*UpsException3_get)(TypUpsVmSession *Session);
   /* Exception ModuleInconnu2. */
TypUpsVmAdresse UpsVmAPI *(*UpsException4_get)(TypUpsVmSession *Session);
   /* Exception NoeudExisteDeja. */
TypUpsVmAdresse UpsVmAPI *(*UpsException5_get)(TypUpsVmSession *Session);
   /* Exception ServeurExisteDeja. */
TypUpsVmAdresse UpsVmAPI *(*UpsException6_get)(TypUpsVmSession *Session);
   /* Exception ModuleExisteDeja. */
TypUpsVmAdresse UpsVmAPI *(*UpsException7_get)(TypUpsVmSession *Session);
   /* Exception NoeudDejaDemarre. */
TypUpsVmAdresse UpsVmAPI *(*UpsException8_get)(TypUpsVmSession *Session);
   /* Exception NoeudDejaArrete. */
TypUpsVmAdresse UpsVmAPI *(*UpsException9_get)(TypUpsVmSession *Session);
   /* Exception NumeroPersistantImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException10_get)(TypUpsVmSession *Session);
   /* Exception NumeroServeurPersistantExisteDeja. */
TypUpsVmAdresse UpsVmAPI *(*UpsException11_get)(TypUpsVmSession *Session);
   /* Exception EntreeAnnuaireInconnue. */

/*--------------------------------------------------------------*/
/* Files d'attente.                                             */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Application Program Interfaces proprietaires.                */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*InitialiserEncapsulationKernel)(TypUpsVmVoid);
   /* Objet : Initialisation de l'extension de Ups Orb pour Ups Krn*/
TypUpsVmVoid UpsVmAPI (*TerminerEncapsulationKernel)(TypUpsVmVoid);
   /* Objet : Terminaison de l'extension de Ups Orb pour Ups Krn. */
TypUpsVmVoid UpsVmAPI (*AjouterProxyServeur)(TypUpsVmSession *Session, TypUpsVmUnicode *NomNoeud, TypUpsVmUnsignedShort NumeroNoeud,
   TypUpsNetCanal *CanalServeur, TypUpsVmUnsignedChar EstBigEndian, TypUpsVmUnsignedChar NbBits, 
   TypUpsVmUnicode *NomServeur, TypUpsVmUnsignedShort NumeroServeur, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction);
   /* Objet : Ajoute un nouveau serveur pour le proxy d'un orb. */
TypUpsVmVoid UpsVmAPI (*ChercherProxyServeur)(TypUpsVmSession *Session, TypUpsVmUnsignedShort NumeroNoeud,
   TypUpsVmUnsignedShort NumeroServeur, TypUpsNetCanal *CanalServeur);
   /* Objet : Cherche un serveur pour le proxy d'un orb. */
TypUpsVmVoid UpsVmAPI (*InformerServeurAjoute)(TypUpsVmSession *Session);
   /* Objet : On informe Ups Orb qu'un serveur est ajoute. */
TypUpsVmVoid UpsVmAPI (*InformerServeurSupprime)(TypUpsVmSession *Session);
   /* Objet : On informe Ups Orb qu'un serveur est supprime. */
TypUpsVmVoid UpsVmAPI (*InformerModuleAjoute)(TypUpsVmSession *Session, TypUpsVmUnicode *NomModule, TypUpsVmShort Version,
   TypUpsVmShort Revision, TypUpsVmShort Correction);
   /* Objet : On informe Ups Orb qu'un module est ajoute. */
TypUpsVmVoid UpsVmAPI (*InformerModuleSupprime)(TypUpsVmSession *Session, TypUpsVmUnicode *NomModule, TypUpsVmShort Version,
   TypUpsVmShort Revision, TypUpsVmShort Correction);
   /* Objet : On informe Ups Orb qu'un module est supprime. */
TypUpsVmVoid UpsVmAPI (*LireEntreeAnnuaireGlobal)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjetNomEntree);
   /* Objet : Lit une entree dans l'annuaire global. */
TypUpsVmVoid UpsVmAPI (*EcrireEntreeAnnuaireGlobal)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetNomEntree, TypUpsVmAdresse *AdresseObjetValeurEntree);
   /* Objet : Ecrit une entree dans l'annuaire global. */
TypUpsVmVoid UpsVmAPI (*SupprimerEntreeAnnuaireGlobal)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetNomEntree, TypUpsVmChar SupprimerRecursivement);
   /* Objet : Supprime une entree dans l'annuaire global. */
TypUpsVmVoid UpsVmAPI (*RenommerEntreeAnnuaireGlobal)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetNomEntreeAvant, TypUpsVmAdresse *AdresseObjetNomEntreeApres);
   /* Objet : Ecrit une entree dans l'annuaire global. */
TypUpsVmVoid UpsVmAPI (*LireArborescenceAnnuaireGlobal)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjetNomEntree);
   /* Objet : Lit un niveau dans l'annuaire global. */
TypUpsVmVoid UpsVmAPI (*LireConfiguration)(TypUpsVmSession *Session, TypUpsNetProtocoleUpsNet *BufferProtocoleUpsNet);
   /* Objet : Lit la configuration d'un noeud. */
TypUpsVmVoid UpsVmAPI (*AjouterNoeud)(TypUpsVmSession *Session, TypUpsNetProtocoleUpsNet *BufferProtocoleUpsNet);
   /* Objet : Recherche le module demande. */
TypUpsVmVoid UpsVmAPI (*SupprimerNoeud)(TypUpsVmSession *Session, TypUpsNetProtocoleUpsNet *BufferProtocoleUpsNet);
   /* Objet : Supprime un noeud. */
TypUpsVmVoid UpsVmAPI (*DemarrerNoeud)(TypUpsVmSession *Session, TypUpsNetProtocoleUpsNet *BufferProtocoleUpsNet);
   /* Objet : Demarre un noeud. */
TypUpsVmVoid UpsVmAPI (*ArreterNoeud)(TypUpsVmSession *Session, TypUpsNetProtocoleUpsNet *BufferProtocoleUpsNet);
   /* Objet : Arrete un noeud. */
TypUpsVmVoid UpsVmAPI (*AjouterServeur)(TypUpsVmSession *Session, TypUpsNetProtocoleUpsNet *BufferProtocoleUpsNet);
   /* Objet : Ajoute un nouveau serveur. */
TypUpsVmVoid UpsVmAPI (*SupprimerServeur)(TypUpsVmSession *Session, TypUpsNetProtocoleUpsNet *BufferProtocoleUpsNet);
   /* Objet : Supprime un serveur. */
TypUpsVmVoid UpsVmAPI (*ChercherServeur)(TypUpsVmSession *Session, TypUpsNetProtocoleUpsNet *BufferProtocoleUpsNet);
   /* Objet : Recherche le serveur demande. */
TypUpsVmVoid UpsVmAPI (*ChercherModule)(TypUpsVmSession *Session, TypUpsNetProtocoleUpsNet *BufferProtocoleUpsNet);
   /* Objet : Recherche le module demande. */
TypUpsVmVoid UpsVmAPI (*AjouterModule)(TypUpsVmSession *Session, TypUpsNetProtocoleUpsNet *BufferProtocoleUpsNet);
   /* Objet : Ajoute un nouveau module. */
TypUpsVmVoid UpsVmAPI (*SupprimerModule)(TypUpsVmSession *Session, TypUpsNetProtocoleUpsNet *BufferProtocoleUpsNet);
   /* Objet : Supprime un module. */
TypUpsVmVoid UpsVmAPI (*StatistiquesServeur)(TypUpsVmSession *Session, TypUpsNetProtocoleUpsNet *BufferProtocoleUpsNet);
   /* Objet : Met a jour les statistiques sur le serveur. */
TypUpsVmVoid UpsVmAPI (*Photographier)(TypUpsVmSession *Session, TypUpsNetProtocoleUpsNet *BufferProtocoleUpsNet);
   /* Objet : Envoie une demande de photographie a tous les serveurs. */
TypUpsVmVoid UpsVmAPI (*EffectuerActionDistribueeServeurMaitre)(TypUpsVmSession *Session, TypUpsNetProtocoleUpsNet *BufferProtocoleUpsNet);
   /* Objet : Effectue une action vers le serveur maitre. */
TypUpsVmUnicode UpsVmAPI *(*LireNomCanalOrbLocal)(TypUpsVmSession *Session);
   /* Objet : Retourne le nom du canal du serveur Ups Orb local. */
TypUpsVmVoid UpsVmAPI (*VerifierVersionProtocole)(TypUpsVmSession *Session, TypUpsVmShort VersionDemandee, 
   TypUpsVmShort RevisionDemandee, TypUpsVmShort CorrectionDemandee, TypUpsVmUnsignedShort NumeroNoeud,
   TypUpsVmUnsignedShort NumeroServeur);
   /* Objet : Verifie si la version du protocole est supportee. */
TypUpsVmVoid UpsVmAPI (*MemoriserVersionProtocole)(TypUpsVmSession *Session, TypUpsVmShort Version,
   TypUpsVmShort Revision, TypUpsVmShort Correction, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur);
   /* Objet : Memorise la version du protocole pour le serveur. */
TypUpsVmVoid UpsVmAPI (*EnvoyerStatistiques)(TypUpsVmSession *Session, TypUpsVmUnsignedLong NbSecondesTravaillees,
   TypUpsVmUnsignedLong NbSecondesTravailleesAuTotal, TypUpsVmUnsignedLong NbSoumissions,
   TypUpsVmUnsignedLong NbSoumissionsAuTotal);
   /* Objet : Met a jour les statistiques. */
} *TypUpsOrbTraitements_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsOrbTraitements_1_1_0 TypUpsOrbTraitements;

extern DllExport TypUpsVtmDemarrer UpsVmAPI UpsOrbDemarrerModule(TypUpsVmShort Numero, TypUpsVtmMachineInterface MachineInterfaceUpsVtm,
   TypUpsVtmTraitements IntTrtUpsVtm, TypUpsVtmDonnees IntDonUpsVtm);

/**********************/
#if defined(__cplusplus)
/**********************/
}
/****/
#endif
/****/

/****/
#endif
/****/
