/*-------------------------------------------------------------------
Fichier     : upsoms.e
Objet       : En-tete du module Up ! Object Management System.

Module      : Up ! Object Management System
Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.
---------------------------------------------------------------------
                         Observations

 
---------------------------------------------------------------------*/

/*****************************/
#if !defined(PasseModuleUpsOms)
/*****************************/
#define PasseModuleUpsOms 1

/**********************/
#if defined(__cplusplus)
/**********************/
extern "C"
{
/****/
#endif
/****/

/****************************************************************/
/* Codification de l'etat du noyau.	        							 */
/****************************************************************/
enum EnuUpsOmsEtatNoyau
   {
   EN_Arrete=0,
   EN_DemarrageEnCours=1,
   EN_Demarre=2,
   EN_ArretEnCours=3,
   EN_PresqueArrete=4
   };

/****************************************************************/
/* Codification des verrous utilisateurs.                       */
/****************************************************************/
enum EnuUpsOmsVerrou
   {
   VR_TousLesBlocs=20,
      /* TousLesBlocs. Ce verrou est local au cache. Verrou a queue. */
   VR_ObjetLecturePartagee=21,
      /* Bloc. Ce verrou est local au cache. Verrou a queue. */
   VR_ObjetLectureExclusive=22,
      /* Bloc. Ce verrou est local au cache. Verrou a queue. */
   VR_ObjetEcriturePartagee=23,
      /* Bloc. Ce verrou est local au cache. Verrou a queue. */
   VR_ObjetEcritureExclusive=24
      /* Bloc. Ce verrou est local au cache. Verrou a queue. */
   };

/****************************************************************/
/* Codification des types des contraintes.   			        	*/
/****************************************************************/
enum EnuUpsOmsTypeContrainte
   {
   TC_ContrainteNul=1,
   TC_ContrainteEntier=2,
   TC_ContrainteReel=3,
   TC_ContrainteObjet=4
   };

/****************************************************************/
/* Codification de la trace du noyau.          			        	 */
/****************************************************************/
enum EnuUpsOmsTraceKernel 
   {
   TK_Tout=1,
   TK_CycleDeVie=2
   };
   
#define CO_NbBlocsContigusMax 0xFF
   /* Nombre de blocs contigus au maximum. */
#define CO_SessionInterne 0xFFFF
   /* Identifiant de la session interne. */
#define CO_ProcessusInterne 0xFFFF
   /* Identifiant du processus interne. */
#define CO_NumeroEntrepotSysteme 1
   /* Numero de l'entrepot systeme. */

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef struct upstypupskrn_7_1_1_0 UpsTypUpsKrn_7_1_1_0;
typedef UpsTypUpsKrn_7_1_1_0 UpsTypUpsKrn_7;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef struct upstypupskrn_9_1_1_0 UpsTypUpsKrn_9_1_1_0;
typedef UpsTypUpsKrn_9_1_1_0 UpsTypUpsKrn_9;

/****************************************************************/
typedef struct typprmcritereexportation
/* Objet: Parametres de la fonction du critere d'exportation.   */
/****************************************************************/
{
TypUpsVmAdresse AdresseObjet1;
   /* Premier objet. */
TypUpsVmAdresse AdresseObjet2;
   /* Second objet. */
} TypPrmCritereExportation;

/****************************************************************/
typedef struct typupsomsliensegmentstype
/* Objet: Description de liens entre les segments d'un type.    */
/****************************************************************/
{
TypUpsVmLong NbSegmentsARetasser;
   /* Nombre de segments a retasser pour ce type. */
TypUpsVmAdresse PremierSegmentLibre;
   /* Premier segment des objets alloues dans lequel il reste au moins un objet libre. */ 
TypUpsVmAdresse DernierSegmentLibre;
   /* Dernier segment des objets alloues dans lequel il reste au moins un objet libre. */ 
TypUpsVmAdresse PremierSegmentARetasser;
   /* Premier segment a retasser. */ 
TypUpsVmAdresse DernierSegmentARetasser;
   /* Dernier segment a retasser. */ 
} TypUpsOmsLienSegmentsType;

/****************************************************************/
typedef struct typupsomsdonnees
/* Objet: Interface des donnees de Ups Oms.                     */
/****************************************************************/
{
struct typupsvmentetedonneesmodule EnteteDonneesModule;
   /* Entete generique du module. */

TypUpsVmLong TempsDeGarde;
   /* Temps de garde maximal en secondes pour un mutex ou un semaphore. */
TypUpsVmUnsignedShort NumeroProcessus;
   /* Numero du processus. */
TypUpsVmAdresse AdresseNulle;
   /* Objet Nul. */
TypUpsVmSession SessionPrincipal;
   /* Numero de la session de la tache principale. */
enum EnuUpsOmsTraceKernel TraceKernel;
   /* Si Vrai, il faut tracer l'execution du cache. */
TypUpsVmShort IlExisteFichierPersistantEnLecture;
   /* Si Vrai, il existe un fichier persistant en lecture. */
TypUpsVmShort IlExisteFichierPersistantEnEcriture;
   /* Si Vrai, il existe un fichier persistant en ecriture. */
TypUpsVmUnicode RepertoireTmp[CO_TailleNomFichier+1];
   /* Repertoire des temporaires. */
TypUpsVmUnsignedShort NumeroEntrepotRetour;
   /* Numero de l'entrepot de retour. */
} *TypUpsOmsDonnees;

typedef TypUpsVmVoid (*TypUpsOmsEcrire)(TypUpsVmSession *Session, TypUpsVmChar *Buffer, TypUpsVmLong TailleBuffer);
typedef TypUpsVmLong (*TypUpsOmsLire)(TypUpsVmSession *Session, TypUpsVmChar *Buffer, TypUpsVmLong TailleBufferDemandee);
typedef TypUpsVmVoid UpsVmAPI (*TypUpsOmsRepondreClient)(TypUpsVmSession *Session, TypUpsNetProtocoleUpsNet *BufferProtocoleUpsNet, TypUpsVmPointeurDonnees Parametres);
typedef TypUpsVmVoid UpsVmAPI (*TypUpsOmsExporterClient)(TypUpsVmSession *Session, TypUpsVmChar *Buffer, TypUpsVmLong TailleBuffer);
typedef TypUpsVmLong UpsVmAPI (*TypUpsOmsImporterClient)(TypUpsVmSession *Session, TypUpsVmChar *Buffer, TypUpsVmLong TailleBufferDemandee);
typedef TypUpsVmVoid UpsVmAPI (*TypUpsOmsDelaiExpire)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Handle);

/****************************************************************/
typedef struct typupsomstraitements_1_1_0
/* Objet: Interface des traitements de Ups Oms.                 */
/****************************************************************/
{
struct typupsvmentetemethodesmodule EnteteMethodesModule;
   /* Methodes generiques au module. */ 

/*--------------------------------------------------------------*/
/* Procedures et fonctions.                                     */
/*--------------------------------------------------------------*/
TypUpsVmLong UpsVmAPI (*CalculerIndexAppel)(TypUpsVmPointeurDonnees InterfaceAppel, TypUpsVmPointeurDonnees AppelCourant);
   /* Objet : Calcule l'index de l'appel. */

/*--------------------------------------------------------------*/
/* Tables des methodes.                                         */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Enumeres.			              				                   */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Entrepots.          								                   */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Types et interfaces.                                         */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Variables globales.                                          */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Exceptions.                                                  */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Files d'attente.                                             */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Application Program Interfaces proprietaires.                */
/*--------------------------------------------------------------*/
TypUpsVmLong UpsVmAPI (*Aligner)(TypUpsVmLong Taille);
   /* Objet : Aligne une zone memoire sur un pointeur. */
TypUpsVmAdresse UpsVmAPI *(*CopierAdresse)(TypUpsVmAdresse *A1, TypUpsVmAdresse *A2);
   /* Objet : Copie une adresse de Ups Kernel. */
TypUpsVmShort UpsVmAPI (*AdressesEgales)(TypUpsVmAdresse *A1, TypUpsVmAdresse *A2);
   /* Objet : Copie une adresse de Ups Kernel. */
TypUpsVmAdresse UpsVmAPI *(*AdresseANul)(TypUpsVmAdresse *A);
   /* Objet : Copie une adresse de Ups Kernel. */
TypUpsVmVoid UpsVmAPI (*FixerRessourceMemoire)(TypUpsVmAdresse *A, TypUpsVmUnsignedShort Entrepot, TypUpsVmUnsignedShort FichierEchange);
   /* Objet : Met a jour la ressource memoire. */
TypUpsVmShort (*PermuterOctets)(TypUpsVmAdresse *AdresseObjet);
   /* Objet : Si Vrai, il est necessaire de permuter les octets. */
TypUpsVmUnsignedShort UpsVmAPI (*LireNbSessions)(TypUpsVmVoid);
   /* Objet : Lit la valeur du parametre nbsessions. */
TypUpsVmUnsignedShort UpsVmAPI (*LireNbEntrepots)(TypUpsVmVoid);
   /* Objet : Lit le nombre d'entrepots. */
TypUpsVmLong UpsVmAPI (*LireNbBuffersMax)(TypUpsVmUnsignedShort Entrepot);
   /* Objet : Retourne le nombre de buffer allouable au maximum. */
TypUpsVmShort UpsVmAPI (*EstLeServeurDeSysteme)(TypUpsVmVoid);
   /* Objet : Si Vrai, le processus est le serveur de l'entrepot systeme. */
TypUpsVmAdresse UpsVmAPI *(*AllouerObjetStandard)(TypUpsVmSession *Session, TypUpsVmAdresse *Objet, TypUpsVmAdresse *ObjetType);
   /* Objet : Allocation standard d'un objet. */
struct upstypupskrn_7_1_1_0 UpsVmAPI *(*AllouerUnObjet)(TypUpsVmSession *Session,TypUpsVmAdresse *Objet, TypUpsVmAdresse *ObjetType, 
   TypUpsVmUnsignedLong *NumeroVerrouObjet, TypUpsVmPointeurDonnees *Implementation);
   /* Objet : Allocation d'un objet. L'objet est verrouille. */
TypUpsVmVoid UpsVmAPI (*LibererObjetStandard)(TypUpsVmSession *Session, TypUpsVmAdresse *Objet);
   /* Objet : Liberation standard d'un objet. */
TypUpsVmVoid UpsVmAPI (*CalculerVerrousNecessaires)(TypUpsVmVoid);
   /* Objet : Calcule quand les verrous sont necessaires. */
TypUpsVmVoid UpsVmAPI (*AjouterTacheActive)(TypUpsVmVoid);
   /* Objet : Ajoute une tache active. */
TypUpsVmVoid UpsVmAPI (*SupprimerTacheActive)(TypUpsVmVoid);
   /* Objet : Supprime une tache active. */
TypUpsVmSession UpsVmAPI *(*OuvrirSession)(TypUpsVmVoid);
   /* Objet : Ouvre une session au noyau d'execution. */
TypUpsVmVoid UpsVmAPI (*FermerSession)(TypUpsVmSession *Session);
   /* Objet : Ferme une session au noyau d'execution. */
TypUpsVmVoid UpsVmAPI (*ArmerAlarmeDelai)(TypUpsVmSession *Session, TypUpsVmLong Delai, TypUpsOmsDelaiExpire RappelDelaiExpire, TypUpsVmPointeurDonnees Handle);
   /* Objet : Arme une alarme pour detecte un delai expire. */
TypUpsVmVoid UpsVmAPI (*DesarmerAlarmeDelai)(TypUpsVmSession *Session);
   /* Objet : Desarme une alarme pour detecte un delai expire. */
TypUpsVmShort UpsVmAPI (*DelaiAttenteDepasse)(TypUpsVmSession *Session);
   /* Objet : Retourne Vrai si le dernier delai d'attente est depasse. */
TypUpsVmSession UpsVmAPI *(*RechercherSessionThread)(TypUpsVmVoid);
   /* Objet : Retourne la session correspondant au thread courant. */
TypUpsVmLong UpsVmAPI (*NumeroSessionEstEmploye)(TypUpsVmUnsignedShort NumeroSession, TypUpsVmShort *AppartientAuProcessus);
   /* Objet : Retourne le numero de thread si le numero de session est employe. */
TypUpsVmPointeurDonnees UpsVmAPI (*RechercherObjet)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmUnsignedLong *NumeroVerrou, enum EnuUpsOmsVerrou TypeVerrou, TypUpsVmPointeurDonnees *AdresseImplementation);
   /* Objet : Recherche l'objet dans la memoire et verrouille-le. Le client doit le deverouiller apres usage. */
TypUpsVmPointeurDonnees UpsVmAPI (*RechercherObjetSansBloquer)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmUnsignedLong *NumeroVerrou, enum EnuUpsOmsVerrou TypeVerrou, TypUpsVmPointeurDonnees *AdresseImplementation);
   /* Objet : Recherche l'objet dans la memoire et verrouille-le. Le client doit le deverouiller apres usage. */
TypUpsVmAdresse UpsVmAPI *(*RechercherObjetImplementant)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmUnsignedLong *VerrouObjetImplementant, enum EnuUpsOmsVerrou TypeVerrou);
   /* Objet : Recherche l'objet implementant l'objet. */
TypUpsVmAdresse UpsVmAPI *(*LireObjetListeProprietesDynamiques)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmAdresse *AdresseObjet);
   /* Objet : Lit la liste des proprietes dynamiques de l'objet. */
TypUpsVmVoid UpsVmAPI (*EcrireObjetListeProprietesDynamiques)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmAdresse *AdresseObjetListeProprietes);
   /* Objet : Ecrit la liste des proprietes dynamiques de l'objet. */
TypUpsVmAdresse UpsVmAPI *(*LireObjetAppartenance)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmAdresse *AdresseObjet);
   /* Objet : Lit l'appartenance de l'objet. */
TypUpsVmVoid UpsVmAPI (*EcrireObjetAppartenance)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjet, TypUpsVmAdresse *AdresseObjetAppartenance);
   /* Objet : Ecrit l'appartenance de l'objet. */
TypUpsVmVoid UpsVmAPI (*ObjetEstModifie)(TypUpsVmSession *Session, TypUpsVmUnsignedLong NumeroVerrou, TypUpsVmShort TousLesBlocs);
   /* Objet : Marque qu'un objet est modifie. */
TypUpsVmVoid UpsVmAPI (*LibererVerrou)(TypUpsVmSession *Session, TypUpsVmUnsignedLong NumeroVerrou, TypUpsVmShort EstModifie);
   /* Objet : Libere un verrou en notifiant une eventuelle modification de l'objet verrouille. */
TypUpsVmVoid UpsVmAPI (*LibererVerrousPourException)(TypUpsVmSession *Session, TypUpsVmLong IndicePointDeRetour,
   TypUpsVmUnsignedLong VerrouObjetException);
   /* Objet : Libere tous les verrous restant du fait d'une exception. */
TypUpsVmShort UpsVmAPI (*ObjetAppartientALaMachine)(TypUpsVmAdresse *AdresseObjet);
   /* Objet : Retourne Vrai si l'objet appartient a un processus de la machine. */
TypUpsVmShort UpsVmAPI (*ObjetAppartientAuProcessus)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmUnsignedShort *NumeroNoeud, TypUpsVmUnsignedShort *NumeroServeur);
   /* Objet : Retourne Vrai si l'objet appartient au processus. */
TypUpsVmShort UpsVmAPI (*ObjetAppartientAUnEntrepotAccessible)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmUnsignedShort *NumeroNoeud, TypUpsVmUnsignedShort *NumeroServeur);
   /* Objet : Retourne Vrai si l'objet appartient a un entrepot accessible. */
TypUpsVmAdresse UpsVmAPI *(*CreerObjet)(TypUpsVmSession *Session, TypUpsVmAdresse *Objet, TypUpsVmAdresse *ObjetType);
   /* Objet : Cree un nouvel objet. */
TypUpsVmVoid UpsVmAPI (*SurclasserObjet2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmEnteteMethodes *EnteteMethodes, TypUpsVmAdresse *AdresseChamp, UpsTypUpsKrn_7 *ObjetChamp);
   /* Objet : Surclasse un objet standard. */
TypUpsVmAdresse *(*SurclasserObjet)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypUpsVmLong Offset, 
   TypUpsVmAdresse *AdresseObjetValeurChamp, TypUpsVmEnteteMethodes *EnteteMethodes);
   /* Objet : Creation standard d'un objet mais avec surclassage. */
TypUpsVmAdresse UpsVmAPI *(*UtiliserObjet)(TypUpsVmSession *Session, TypUpsVmAdresse *Objet);
   /* Objet : Utilise plus un objet. */
TypUpsVmAdresse UpsVmAPI *(*CopierEtUtiliserObjet)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetA, TypUpsVmAdresse *AdresseObjetB);
 /* Objet : Utilise un objet. */
TypUpsVmAdresse UpsVmAPI *(*NePlusUtiliserObjet)(TypUpsVmSession *Session, TypUpsVmAdresse *Objet);
   /* Objet : N'utilise plus un objet. */
TypUpsVmAdresse UpsVmAPI *(*NePlusUtiliserEtEffacerObjet)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : N'utilise plus un objet. */
TypUpsVmAdresse UpsVmAPI *(*NePlusUtiliserObjetSiUtilise)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : N'utilise plus un objet s'il est utilise. */
TypUpsVmAdresse UpsVmAPI *(*NePlusUtiliserEtEffacerObjetSiUtilise)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : N'utilise plus un objet s'il est utilise. */
TypUpsVmAdresse UpsVmAPI *(*LibererObjet)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Libere un objet s'il n'est plus utilise. */
TypUpsVmAdresse UpsVmAPI *(*CreerObjetType)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetType, TypUpsVmUnicode *NomType2, 
   TypUpsVmAllouer Allouer, TypUpsVmLong TailleObjet, TypUpsVmEnteteMethodes *EnteteMethodes, 
   TypUpsVmLong NbObjets, TypUpsVmUnsignedShort Entrepot, TypUpsVmUnsignedShort FichierEchange, TypUpsVmUnicode *NomModule,
   TypUpsVmAdresse *AdresseObjetModule, TypUpsVmChar EstUneInterface, TypUpsVmChar EstUneRessource, 
   TypUpsVmChar ProprietesDynamiques, TypUpsVmChar Com, TypUpsVmChar Corba, TypUpsVmChar Java, TypUpsVmChar Transaction,
   TypUpsVmChar SupporteHabilitation, TypUpsVmChar Appartenance, TypUpsVmChar Quota);
   /* Objet : Alloue un nouveau type de donnees. */
TypUpsVmShort UpsVmAPI (*RechercherEntrepot)(TypUpsVmUnicode *NomEntrepot);
   /* Objet : Recherche un entrepot. */
TypUpsVmVoid UpsVmAPI (*RechercherObjetEntrepot)(TypUpsVmAdresse *ObjetEntrepot, TypUpsVmUnsignedShort NumeroEntrepot);
   /* Objet : Recherche l'objet representant l'entrepot. */ 
TypUpsVmUnicode UpsVmAPI *(*LireRepertoireTmp)(TypUpsVmVoid);
   /* Objet : Lit la valeur du parametre tmp. */
TypUpsVmLong UpsVmAPI (*LireTailleBlocSysteme)(TypUpsVmVoid);
   /* Objet : Retourne la taille des blocs de l'entrepot systeme. */
TypUpsVmVoid UpsVmAPI (*CreerObjetEntrepot)(TypUpsVmSession *Session, TypUpsVmUnsignedShort NumeroEntrepot, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Alimente la description d'un entrepot. */
TypUpsVmLong UpsVmAPI (*TailleMemoireAllouee)(TypUpsVmSession *Session, TypUpsVmUnsignedShort NumeroEntrepot);
   /* Objet : Calcule la taille de la memoire allouee pour l'entrepot. */
TypUpsVmLong UpsVmAPI (*TailleMemoireTotale)(TypUpsVmSession *Session, TypUpsVmUnsignedShort NumeroEntrepot);
   /* Objet : Calcule la taille de la memoire totale pour l'entrepot. */
TypUpsVmLong UpsVmAPI (*TailleFichierEchangeAlloue)(TypUpsVmSession *Session, TypUpsVmUnsignedShort NumeroEntrepot);
   /* Objet : Calcule la taille du fichier d'echange alloue pour l'entrepot. */
TypUpsVmLong UpsVmAPI (*TailleFichierEchangeTotal)(TypUpsVmSession *Session, TypUpsVmUnsignedShort NumeroEntrepot);
   /* Objet : Calcule la taille du fichier d'echange totale pour l'entrepot. */
TypUpsVmLong UpsVmAPI (*NbVerrousPoses)(TypUpsVmSession *Session, TypUpsVmUnsignedShort NumeroEntrepot);
   /* Objet : Calcule le nombre de verrous poses pour l'entrepot. */
TypUpsVmLong UpsVmAPI (*NbVerrousTotal)(TypUpsVmSession *Session, TypUpsVmUnsignedShort NumeroEntrepot);
   /* Objet : Calcule le nombre de verrous au total pour l'entrepot. */
TypUpsVmLong UpsVmAPI (*NbObjetsAlloues)(TypUpsVmSession *Session, TypUpsVmUnsignedShort NumeroEntrepot);
   /* Objet : Calcule le nombre d'objets dans l'entrepot. */
TypUpsVmVoid UpsVmAPI (*TracerRessources)(TypUpsVmSession *Session, TypUpsVmFlux *FTrace);
   /* Objet : Trace l'emploi des ressources systemes. */
TypUpsVmVoid UpsVmAPI (*ChangerEtat)(TypUpsVmSession *Session, TypUpsVmUnsignedShort NumeroEntrepot, TypUpsVmUnsignedChar NouvelEtat, TypUpsVmShort Forcer);
   /* Objet : Change l'etat de l'entrepot. */
TypUpsVmUnsignedChar UpsVmAPI (*LireEtat)(TypUpsVmSession *Session, TypUpsVmUnsignedShort NumeroEntrepot);
   /* Objet : Lit l'etat de l'entrepot. */
TypUpsVmShort UpsVmAPI (*InitialiserEncapsulationKernel)(TypUpsVmVoid);
   /* Objet : Initialisation de l'extension de Ups Oms pour Ups Krn. */
TypUpsVmVoid UpsVmAPI (*TerminerEncapsulationKernel)(TypUpsVmVoid);
   /* Objet : Terminaison de l'extension de Ups Oms pour Ups Krn. */
TypUpsVmVoid UpsVmAPI (*TerminerApresEncapsulationKernel)(TypUpsVmVoid);
   /* Objet : Terminaison de l'extension de Ups Oms pour Ups Krn apres l'arret du noyau. */
TypUpsVmVoid UpsVmAPI (*TracerKernel)(TypUpsVmSession *Session, TypUpsVmUnicode *Filtre, TypUpsVmPointeurDonnees P1, 
   TypUpsVmPointeurDonnees P2, TypUpsVmPointeurDonnees P3, TypUpsVmPointeurDonnees P4,
   TypUpsVmPointeurDonnees P5, TypUpsVmPointeurDonnees P6);
   /* Objet : Trace une action de Ups Oms. */
TypUpsVmShort UpsVmAPI (*TracerObjetsAlloues)(TypUpsVmSession *Session, TypUpsVmUnicode *LibelleTrace, TypUpsVmAdresse *AdresseObjetTypeDemande, TypUpsVmShort TypeSeulement);
   /* Objet : Trace les objets alloues. */
TypUpsVmPointeurDonnees UpsVmAPI (*AllouerBuffer)(TypUpsVmSession *Session, TypUpsVmLong TailleObjet, 
   TypUpsVmAdresse *AdresseObjetLibre, TypUpsVmLong *IndexBuffer, TypUpsVmLong *NbBuffers,
   TypUpsVmUnsignedLong *VerrouObjetLibre);
   /* Objet : Alloue un objet dans le buffer comportant au moins TailleObjet. */
TypUpsVmPointeurDonnees UpsVmAPI (*CalculerBuffer)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmLong IndexBuffer, TypUpsVmLong NbBuffers, enum EnuUpsOmsVerrou TypeVerrou,
   TypUpsVmUnsignedLong *NumeroVerrou);
   /* Objet : Recherche l'emplacement du buffer. */
TypUpsVmVoid UpsVmAPI (*LibererBuffer)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetLibre, 
   TypUpsVmLong IndexBuffer, TypUpsVmLong NbBuffers);
   /* Objet : Alloue un objet dans le buffer comportant au moins TailleObjet. */
TypUpsVmVoid UpsVmAPI (*ExporterAdresseObjet)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Exporte l'adresse d'un objet du fait d'une optimisation. */
TypUpsVmVoid UpsVmAPI (*ExporterBinaire)(TypUpsVmSession *Session, TypUpsVmLong Taille, TypUpsVmChar *Buffer);
   /* Objet : Exporte un binaire avec la taille en prefixe. */
TypUpsVmVoid UpsVmAPI (*ExporterBinaire2)(TypUpsVmSession *Session, TypUpsVmLong Taille, TypUpsVmChar *Buffer);
   /* Objet : Exporte un binaire sans la taille en prefixe. */
TypUpsVmVoid UpsVmAPI (*ExporterEntier)(TypUpsVmSession *Session, TypUpsVmLong Entier);
   /* Objet : Exporte un entier. */
TypUpsVmVoid UpsVmAPI (*ExporterReel)(TypUpsVmSession *Session, TypUpsVmDouble Reel);
   /* Objet : Exporte un reel. */
TypUpsVmVoid UpsVmAPI (*ExporterVersionRevision)(TypUpsVmSession *Session, TypUpsVmShort Version, 
   TypUpsVmShort Revision, TypUpsVmShort Correction);
   /* Objet : Exporte une signature de version revision. */
TypUpsVmVoid UpsVmAPI (*ExporterObjet)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Retourne Vrai si l'objet est deja exporte ou s'il est passe par adresse. */
TypUpsVmShort UpsVmAPI (*ObjetDejaExporte)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Retourne Vrai si l'objet est deja exporte ou s'il est passe par adresse. */
TypUpsVmVoid UpsVmAPI (*ErreurLorsDeLImportationVersion)(TypUpsVmSession *Session, TypUpsVmShort Version, 
   TypUpsVmShort Revision, TypUpsVmShort Correction, TypUpsVmUnicode *NomType);
   /* Objet : Envoie une erreur d'importation suite a une incompatibilite. */
TypUpsVmVoid UpsVmAPI (*ErreurLorsDeLImportationImporter)(TypUpsVmSession *Session, TypUpsVmUnicode *NomType);
   /* Objet : Envoie une erreur d'importation suite a une incompatibilite. */
TypUpsVmVoid UpsVmAPI (*DebuterExportation)(TypUpsVmSession *Session, TypUpsOmsEcrire Ecrire, TypUpsVmShort OptimiserExportation, 
   TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur, TypUpsVmUnicode *NomServeurSysteme, TypUpsVmShort EstImplicite);
   /* Objet : Debute une exportation. */
TypUpsVmVoid UpsVmAPI (*DebuterExportation2)(TypUpsVmSession *Session, 
   TypUpsVmShort OptimiserExportation, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsNetCanal *CanalServeur, TypUpsVmUnsignedShort NumeroSessionClient, TypUpsVmUnsignedChar EstBigEndian, 
   TypUpsVmShort PageDeCode, TypUpsVmShort EstImplicite);
   /* Objet : Debute une exportation. */
TypUpsVmVoid UpsVmAPI (*TerminerExportation)(TypUpsVmSession *Session);
   /* Objet : Termine une exportation. */
TypUpsVmAdresse UpsVmAPI *(*ImporterAdresseObjet)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Importe l'adresse d'un objet du fait d'une optimisation. */
TypUpsVmLong UpsVmAPI (*ImporterEntier)(TypUpsVmSession *Session);
   /* Objet : Importe un entier. */
TypUpsVmDouble UpsVmAPI (*ImporterReel)(TypUpsVmSession *Session);
   /* Objet : Importe un reel. */
TypUpsVmVoid UpsVmAPI (*ImporterVersionRevision)(TypUpsVmSession *Session, TypUpsVmShort *Version, 
   TypUpsVmShort *Revision, TypUpsVmShort *Correction);
   /* Objet : Importe une signature de version revision. */
TypUpsVmVoid UpsVmAPI (*ImporterBinaire)(TypUpsVmSession *Session, TypUpsVmChar *Buffer, TypUpsVmLong Taille);
   /* Objet : Importe un binaire. */
TypUpsVmAdresse UpsVmAPI *(*ImporterObjet)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat);
   /* Objet : Importe un objet. */
TypUpsVmVoid UpsVmAPI (*DebuterImportation)(TypUpsVmSession *Session, TypUpsOmsLire Lire, TypUpsVmAdresse *AdresseObjetEntrepot, 
   TypUpsVmShort EstImplicite);
   /* Objet : Debute une importation. */
TypUpsVmVoid UpsVmAPI (*DebuterImportation2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetEntrepot,
   TypUpsNetCanal *CanalServeur, TypUpsVmUnsignedShort NumeroSessionClient);
   /* Objet : Debute une exportation. */
TypUpsVmVoid UpsVmAPI (*TerminerImportation)(TypUpsVmSession *Session);
   /* Objet : Termine une importation. */
TypUpsVmVoid UpsVmAPI (*LireEntrepotImportation)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetEntrepot);
   /* Objet : Lit l'entrepot d'importation. */
TypUpsVmLong UpsVmAPI (*AjouterObjetImporte)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Ajoute un objet non encore importe. */
TypUpsVmVoid UpsVmAPI (*ChangerObjetImporte)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypUpsVmLong NumeroObjet);
   /* Objet : Change un objet importe partiellement. */
TypUpsVmShort UpsVmAPI (*ImportExportEstImplicite)(TypUpsVmSession *Session);
   /* Objet : Retourne vrai si l'import ou l'export est implicite. */
TypUpsVmAdresse *(*EnumererObjets)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet,
   TypUpsVmAdresse *AdresseObjetType);
   /* Objet : Retrouve le n ieme objet d'un type. */
TypUpsVmShort UpsVmAPI (*CalculerDelaiAttente)(TypUpsVmLong TempsDebut, TypUpsVmLong TempsCourant);
   /* Objet : Retourne le delai d'attente pour une attente active. */
TypUpsVmShort UpsVmAPI (*DebuterChargementPersistance)(TypUpsVmSession *Session);
   /* Objet : Debute le chargement persistent du programme. */
TypUpsVmShort UpsVmAPI (*DebuterChargementPersistanceModule)(TypUpsVmUnicode *NomModule);
   /* Objet : Debute le chargement persistent d'un module. */
TypUpsVmShort UpsVmAPI (*TerminerChargementPersistance)(TypUpsVmVoid);
   /* Objet : Termine le chargement persistant du programme. */
TypUpsVmVoid UpsVmAPI (*TerminerChargementPersistanceModule)(TypUpsVmVoid);
   /* Objet : Termine le chargement persistant d'un module. */
TypUpsVmShort UpsVmAPI (*EnregistrerPersistanceModules)(TypUpsVmVoid);
   /* Objet : Enregistre les modules dans le fichier de persistance. */
TypUpsVmVoid UpsVmAPI (*MiseAJourEnteteMethodesObjets)(TypUpsVmAdresse *AdresseObjetType, TypUpsVmEnteteMethodes *EnteteMethodes);
   /* Objet : Met a jour l'entete des methodes du type et de ses objets. */
TypUpsVmEnteteMethodes UpsVmAPI *(*LireEnteteMethodes)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypUpsVmShort EstLeType);
   /* Objet : Lit l'entete des methodes du type qui a pu ne pas etre construit dans le processus courant. */
TypUpsVmLong UpsVmAPI (*PrincipalTacheRetasserType)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetTache, TypUpsVmUnsignedShort *NumeroEntrepot);
   /* Objet : Fonction principale de la tache retassant les types  */
   /* dont le processus est proprietaire du fait de big-endian. */
TypUpsVmLong UpsVmAPI (*PrincipalTacheRetasserTousLesTypes)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetTache, TypUpsVmUnsignedShort *NumeroEntrepot);
   /* Objet : Retasse les segments de tous les types. */
TypUpsVmLong UpsVmAPI (*PrincipalTacheFichierEchange)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetTache, TypUpsVmPointeurDonnees AdresseFichierCourant);
   /* Objet : Fonction principale d'un thread gerant un fichier. */
TypUpsVmLong UpsVmAPI (*PrincipalTacheMoniteur)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetTache, TypUpsVmPointeurDonnees Parametres);
   /* Objet : Fonction principale d'une tache gerant les anomalies de fonctionnement. */
TypUpsVmLong UpsVmAPI (*PrincipalTacheEnregistrementJournal)(TypUpsVmSession *Session,
   TypUpsVmAdresse *AdresseObjetTache, TypUpsVmPointeurDonnees AdresseFichierCourant);
   /* Objet : Fonction principale d'un thread gerant le fichier journal. */
TypUpsVmLong UpsVmAPI (*PrincipalTacheArchivage)(TypUpsVmSession *Session,
   TypUpsVmAdresse *AdresseObjetTache, TypUpsVmPointeurDonnees NumeroFichierJournalPrecedent);
   /* Objet : Fonction principale d'un thread gerant l'archivage. */
TypUpsVmVoid UpsVmAPI (*SynchroniserEntrepotsEtJournal)(TypUpsVmSession *Session);
   /* Objet : Synchronise les entrepots et les journaux. */
TypUpsVmUnsignedChar UpsVmAPI (*CritereExportationParAdresse)(TypUpsVmSession *Session, TypPrmCritereExportation *UpsPrm);
   /* Objet : Critere de comparaison des arbres binaires. */
TypUpsVmUnsignedChar UpsVmAPI (*CritereExportationParNumero)(TypUpsVmSession *Session, TypPrmCritereExportation *UpsPrm);
   /* Objet : Critere de comparaison des arbres binaires. */
TypUpsVmUnsignedChar UpsVmAPI (*CoCritereExportationParAdresse)(TypUpsVmSession *Session,
   TypUpsVmShort NumeroParametre, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm);
   /* Objet : Critere de comparaison des arbres binaires. */
TypUpsVmUnsignedChar UpsVmAPI (*CoCritereExportationParNumero)(TypUpsVmSession *Session,
   TypUpsVmShort NumeroParametre, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm);
   /* Objet : Critere de comparaison des arbres binaires. */
TypUpsVmVoid UpsVmAPI (*SynchroniserSecondeTache)(TypUpsVmVoid);
   /* Objet : Synchronise l'entree d'une seconde tache si possible.*/
TypUpsVmAdresse UpsVmAPI *(*LireObjetTypeElementExporte)(TypUpsVmVoid);
   /* Objet : Lit l'adresse de l'objet representant le type ElementExporte. */
TypUpsVmEnteteMethodes UpsVmAPI *(*LireMethodesTypeElementExporte)(TypUpsVmVoid);
   /* Objet : Lit la table des methodes du type ElementExporte. */
TypUpsVmAdresse UpsVmAPI *(*LireObjetTypeBuffer)(TypUpsVmVoid);
   /* Objet : Lit l'adresse de l'objet representant le type Buffer. */
TypUpsVmEnteteMethodes UpsVmAPI *(*LireMethodesTypeBuffer)(TypUpsVmVoid);
   /* Objet : Lit la table des methodes du type Buffer. */
TypUpsVmAdresse UpsVmAPI *(*LireObjetTypeImageAvant)(TypUpsVmVoid);
   /* Objet : Lit l'adresse de l'objet representant le type ImageAvant. */
TypUpsVmEnteteMethodes UpsVmAPI *(*LireMethodesTypeImageAvant)(TypUpsVmVoid);
   /* Objet : Lit la table des methodes du type ImageAvant. */
TypUpsVmAdresse UpsVmAPI *(*LireObjetTypeEnregistrementJournal)(TypUpsVmVoid);
   /* Objet : Lit l'adresse de l'objet representant le type EnregistrementJournal. */
TypUpsVmEnteteMethodes UpsVmAPI *(*LireMethodesTypeEnregistrementJournal)(TypUpsVmVoid);
   /* Objet : Lit la table des methodes du type EnregistrementJournal. */
TypUpsVmVoid UpsVmAPI (*MemoriserContrainte)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
	TypUpsVmAdresse *AdresseObjetType, TypUpsVmLong OffsetChamp, enum EnuUpsOmsTypeContrainte TypeContrainte);
   /* Objet : Memorise une contrainte qui est mise en attente. */ 
TypUpsVmVoid UpsVmAPI (*ValiderTransaction)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetTransaction);
   /* Objet : Valide la transaction. */
TypUpsVmVoid UpsVmAPI (*InvaliderTransaction)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetTransaction);
   /* Objet : Invalide la transaction. */
TypUpsVmVoid UpsVmAPI (*Photographier2)(TypUpsVmSession *Session, TypUpsVmShort Activite, TypUpsVmShort Portee,
	TypUpsVmUnsignedShort NumeroNoeudClient, TypUpsVmUnsignedShort NumeroServeurClient, TypUpsVmUnsignedShort NumeroSessionClient,
	TypUpsVmLong DatePhotographie);
   /* Objet : Prend une photographie des donnees. */
TypUpsVmVoid UpsVmAPI (*Photographier)(TypUpsVmSession *Session, TypUpsVmShort Activite, TypUpsVmShort Portee);
   /* Objet : Prend une photographie des donnees. */
TypUpsVmUnsignedChar UpsVmAPI (*IlExistePhotographie)(TypUpsVmSession *Session, TypUpsVmShort Portee);
   /* Objet : Retourne Vrai s'il existe une photographie des donnees. */
TypUpsVmShort UpsVmAPI (*ContrainteReseau)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetType,
   TypUpsVmLong Entier, TypUpsVmDouble Reel, TypUpsVmAdresse *AdresseObjet);
/* Objet : Verifie que la contrainte est respectee.				 */
TypUpsVmSession UpsVmAPI *(*CopierSession)(TypUpsVmSession *SessionCopie, TypUpsVmSession *SessionOrigine,
	TypUpsVmUnsignedShort NumeroEntrepot, TypUpsVmUnsignedShort NumeroFichierEchange);
   /* Objet : Copie la session et modifie l'entrepot par defaut. */
TypUpsVmShort UpsVmAPI (*EstBigEndian)(TypUpsVmAdresse *AdresseObjet);
   /* Objet : Retourne Vrai si l'objet a ete cree sur un ordinateur big endian. */
TypUpsVmShort UpsVmAPI (*IlExisteEntrepotProtegeeOuPublique)(TypUpsVmVoid);
   /* Objet : Retourne Vrai s'il existe un entrepot protegee ou publique. */
TypUpsVmSession UpsVmAPI *(*CalculerSession)(TypUpsVmUnsignedShort NumeroSession);
   /* Objet : Calcule une session. */
TypUpsVmShort UpsVmAPI (*DemarrerTachesServeur)(TypUpsVmSession *Session);
   /* Objet : Demarre les taches annexes realisant les services Ups Net. */
TypUpsVmVoid UpsVmAPI (*ArreterTachesServeur)(TypUpsVmSession *Session);
   /* Objet : Arrete les taches annexes realisant les services Ups Net. */
enum EnuUpsOmsEtatNoyau UpsVmAPI (*LireEtatNoyau)(TypUpsVmVoid);
   /* Etat du noyau d'execution. */
TypUpsVmVoid UpsVmAPI (*ModifierEtatNoyau)(TypUpsVmSession *Session, enum EnuUpsOmsEtatNoyau EtatNoyauDemande);
   /* Objet : Met a jour l'etat du noyau ainsi que les dates. */
TypUpsVmShort UpsVmAPI (*Reprise)(TypUpsVmSession *Session);
   /* Objet : Tente de faire une reprise suite a un crash si cela est necessaire. */
TypUpsVmVoid UpsVmAPI (*CalculerPlusPetitCanal)(TypUpsVmSession *Session, TypUpsNetCanal *CanalLibre);
   /* Objet : Compare les canaux pour ceux utilises par Ups Oms. */
TypUpsNetCanal UpsVmAPI *(*CalculerCanalEntrepot)(TypUpsVmUnsignedShort NumeroEntrepot,
   TypUpsVmUnsignedShort *NumeroNoeud, TypUpsVmUnsignedShort *NumeroServeur);
   /* Objet : Calcule le canal pour acceder au serveur de l'entrepot. */
TypUpsVmVoid UpsVmAPI (*TraitementServeurAccesDistant)(TypUpsVmSession *Session, TypUpsVmLong Token,
	TypUpsNetProtocoleUpsNet *BufferProtocoleUpsNet, TypUpsOmsRepondreClient RepondreClient,TypUpsOmsLire Lire,
   TypUpsOmsEcrire Ecrire,TypUpsOmsExporterClient ExporterClient,TypUpsOmsImporterClient ImporterClient);
   /* Objet : Traite les demandes des acces distants pour Ups Oms. */
TypUpsVmLong UpsVmAPI (*LireNumeroUtilisateurSuivant)(TypUpsVmSession *Session);
   /* Objet : Lit le numero d'utilisateur suivant. */
TypUpsVmLong UpsVmAPI (*LireNumeroRoleSuivant)(TypUpsVmSession *Session);
   /* Objet : Lit le numero de role suivant. */
TypUpsVmUnicode UpsVmAPI *(*NomServeurSysteme)(TypUpsVmUnicode *NomServeur, TypUpsVmLong TailleNomServeur);
   /* Objet : Retourne le nom du serveur de Systeme. */
TypUpsVmUnicode UpsVmAPI *(*CalculerNomEntrepot)(TypUpsVmLong Entrepot);
   /* Objet : Calcule le nom d'un entrepot. */
TypUpsVmLong UpsVmAPI (*LireNbQuotasMax)(TypUpsVmVoid);
   /* Objet : Retourne la taille maxiale de la table des quotas.	*/
TypUpsVmUnsignedShort UpsVmAPI (*LireSessionEnregistrementJournal)(TypUpsVmVoid);
   /* Objet : Retourne le numero de la session de la tache d'enregistrement dans le journal. */
} *TypUpsOmsTraitements_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsOmsTraitements_1_1_0 TypUpsOmsTraitements;

extern DllExport TypUpsVtmDemarrer UpsVmAPI UpsOmsDemarrerModule(TypUpsVmShort Numero, TypUpsVtmMachineInterface MachineInterfaceUpsVtm,
   TypUpsVtmTraitements IntTrtUpsVtm, TypUpsVtmDonnees IntDonUpsVtm);
   /* Objet : Retourne la description de Ups Oms. */

/**********************/
#if defined(__cplusplus)
/**********************/
}
/****/
#endif
/****/

/****/
#endif
/****/
