/*-------------------------------------------------------------------
Fichier     : upsnls.e
Objet       : En-tete du module Up ! Natural Language Support.

Module      : Up ! Natural Language Support
Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.
---------------------------------------------------------------------
                         Observations

 
---------------------------------------------------------------------*/

/*****************************/
#if !defined(PasseModuleUpsNls)
/*****************************/
#define PasseModuleUpsNls 1

/**********************/
#if defined(__cplusplus)
/**********************/
extern "C"
{
/****/
#endif
/****/

/*------------------------------*/
/* Enumere SectionsSupportees.  */
/*------------------------------*/
#define UpsEnuUpsNls_1_1 1
   /* Valeur : Divers */
#define UpsEnuUpsNls_1_2 2
   /* Valeur : LibelleMessage */
#define UpsEnuUpsNls_1_3 3
   /* Valeur : LibelleParametreModule */
#define UpsEnuUpsNls_1_4 4
   /* Valeur : LibelleParametreAppel */
#define UpsEnuUpsNls_1_5 5
   /* Valeur : LibelleInstruction */
#define UpsEnuUpsNls_1_6 6
   /* Valeur : LibelleAPI */
#define UpsEnuUpsNls_1_7 7
   /* Valeur : LibelleEnvironnement */
#define UpsEnuUpsNls_1_8 8
   /* Valeur : SectionAide */
#define UpsEnuUpsNls_1_9 9
   /* Valeur : SectionRegle*/

/*------------------------------*/
/* Liste PaysSupportees.        */
/*------------------------------*/
#define UpsEnuUpsNls_2_1 1
   /* Valeur : Allemagne */
#define UpsEnuUpsNls_2_2 2
   /* Valeur : Angleterre */
#define UpsEnuUpsNls_2_3 3
   /* Valeur : Chine */
#define UpsEnuUpsNls_2_4 4
   /* Valeur : CoreeSud */
#define UpsEnuUpsNls_2_5 5
   /* Valeur : Danemark */
#define UpsEnuUpsNls_2_6 6
   /* Valeur : Espagne */
#define UpsEnuUpsNls_2_7 7
   /* Valeur : EtatsUnis */
#define UpsEnuUpsNls_2_8 8
   /* Valeur : Finlande */
#define UpsEnuUpsNls_2_9 9
   /* Valeur : France */
#define UpsEnuUpsNls_2_10 10
   /* Valeur : Grece */
#define UpsEnuUpsNls_2_11 11
   /* Valeur : Hollande */
#define UpsEnuUpsNls_2_12 12
   /* Valeur : Israel */
#define UpsEnuUpsNls_2_13 13
   /* Valeur : Italie */
#define UpsEnuUpsNls_2_14 14
   /* Valeur : Japon */
#define UpsEnuUpsNls_2_15 15
   /* Valeur : Norvege */
#define UpsEnuUpsNls_2_16 16
   /* Valeur : Pologne */
#define UpsEnuUpsNls_2_17 17
   /* Valeur : Portugal */
#define UpsEnuUpsNls_2_18 18
   /* Valeur : Russie */
#define UpsEnuUpsNls_2_19 19
   /* Valeur : Suede */
#define UpsEnuUpsNls_2_20 20
   /* Valeur : Suisse */

/*----------------------------------*/
/* Enumere LanguesSupportees        */
/*----------------------------------*/
#define UpsEnuUpsNls_3_1 1
   /* Valeur : LangueAllemand. */
#define UpsEnuUpsNls_3_2 2
   /* Valeur : LangueAnglais. */
#define UpsEnuUpsNls_3_3 3
   /* Valeur : LangueArabe. */
#define UpsEnuUpsNls_3_4 4
   /* Valeur : LangueChinois. */
#define UpsEnuUpsNls_3_5 5 
   /* Valeur : LangueEspagnol. */
#define UpsEnuUpsNls_3_6 6 
   /* Valeur : LangueFrancais. */
#define UpsEnuUpsNls_3_7 7
   /* Valeur : LangueItalien. */
#define UpsEnuUpsNls_3_8 8
   /* Valeur : LangueJaponais. */
#define UpsEnuUpsNls_3_9 9
   /* Valeur : LanguePortugais. */
#define UpsEnuUpsNls_3_10 10
   /* Valeur : LangueRusse. */

/*----------------------------------*/
/* Enumere FuseauxHorairesSupportes */
/*----------------------------------*/
#define UpsEnuUpsNls_4_1 1
   /* Valeur : FuseauEniwetokKwajalein. */
#define UpsEnuUpsNls_4_2 2
   /* Valeur : FuseauMidwaySamoa. */
#define UpsEnuUpsNls_4_3 3
   /* Valeur : FuseauHawai. */
#define UpsEnuUpsNls_4_4 4
   /* Valeur : FuseauAlaska. */
#define UpsEnuUpsNls_4_5 5
   /* Valeur : FuseauTijuana. */
#define UpsEnuUpsNls_4_6 6
   /* Valeur : FuseauArizona. */
#define UpsEnuUpsNls_4_7 7
   /* Valeur : FuseauRocheuseAmerique. */
#define UpsEnuUpsNls_4_8 8
   /* Valeur : FuseauCentreAmerique. */
#define UpsEnuUpsNls_4_9 9
   /* Valeur : FuseauMexicoTegucigalpa. */
#define UpsEnuUpsNls_4_10 10
   /* Valeur : FuseauSaskatchevan. */
#define UpsEnuUpsNls_4_11 11
   /* Valeur : FuseauBogotaLimaQuito. */
#define UpsEnuUpsNls_4_12 12
   /* Valeur : FuseauEstAmerique. */
#define UpsEnuUpsNls_4_13 13
   /* Valeur : FuseauIndiana. */
#define UpsEnuUpsNls_4_14 14
   /* Valeur : FuseauAtlantique. */
#define UpsEnuUpsNls_4_15 15
   /* Valeur : FuseauCaracasLaPaz. */
#define UpsEnuUpsNls_4_16 16
   /* Valeur : FuseauTerreNeuve. */
#define UpsEnuUpsNls_4_17 17
   /* Valeur : FuseauBresil. */
#define UpsEnuUpsNls_4_18 18
   /* Valeur : FuseauBuenosAiresGeorgeTown. */
#define UpsEnuUpsNls_4_19 19
   /* Valeur : FuseauMilieuAtlantique. */
#define UpsEnuUpsNls_4_20 20
   /* Valeur : FuseauAcoresCapVert. */
#define UpsEnuUpsNls_4_21 21
   /* Valeur : FuseauCasablancaMonrovia. */
#define UpsEnuUpsNls_4_22 22
   /* Valeur : FuseauGreenwich. */
#define UpsEnuUpsNls_4_23 23
   /* Valeur : FuseauAmsterdamBerlinBernRome. */
#define UpsEnuUpsNls_4_24 24
   /* Valeur : FuseauBelgradeBudapestPrague. */
#define UpsEnuUpsNls_4_25 25
   /* Valeur : FuseauBruxellesMadridParis. */
#define UpsEnuUpsNls_4_26 26
   /* Valeur : FuseauSarajevoSofiaVarsovie. */
#define UpsEnuUpsNls_4_27 27
   /* Valeur : FuseauAthenesIstanbulMinsk. */
#define UpsEnuUpsNls_4_28 28
   /* Valeur : FuseauBucarest. */
#define UpsEnuUpsNls_4_29 29
   /* Valeur : FuseauCaire. */
#define UpsEnuUpsNls_4_30 30
   /* Valeur : FuseauPretoria. */
#define UpsEnuUpsNls_4_31 31
   /* Valeur : FuseauHelsinkiRigaTallinn. */
#define UpsEnuUpsNls_4_32 32
   /* Valeur : FuseauIsrael. */
#define UpsEnuUpsNls_4_33 33
   /* Valeur : FuseauBagdhadKoweitRiyadh. */
#define UpsEnuUpsNls_4_34 34
   /* Valeur : FuseauMoscouStPetersbourg. */
#define UpsEnuUpsNls_4_35 35
   /* Valeur : FuseauNairobi. */
#define UpsEnuUpsNls_4_36 36
   /* Valeur : FuseauTeheran. */
#define UpsEnuUpsNls_4_37 37
   /* Valeur : FuseauAbuDhabiMuscat. */
#define UpsEnuUpsNls_4_38 38
   /* Valeur : FuseauBakouTbilisi. */
#define UpsEnuUpsNls_4_39 39
   /* Valeur : FuseauKabul. */
#define UpsEnuUpsNls_4_40 40
   /* Valeur : FuseauEkaterinburg. */
#define UpsEnuUpsNls_4_41 41
   /* Valeur : FuseauIsmalabadKarachiTaschkent. */
#define UpsEnuUpsNls_4_42 42
   /* Valeur : FuseauBombayCalcuttaNewDelhi. */
#define UpsEnuUpsNls_4_43 43
   /* Valeur : FuseauAlmatyDhaka. */
#define UpsEnuUpsNls_4_44 44
   /* Valeur : FuseauColombo. */
#define UpsEnuUpsNls_4_45 45
   /* Valeur : FuseauBangkokHanoiJakarta. */
#define UpsEnuUpsNls_4_46 46
   /* Valeur : FuseauPekinHongKongUrumqi. */
#define UpsEnuUpsNls_4_47 47
   /* Valeur : FuseauPerth. */
#define UpsEnuUpsNls_4_48 48
   /* Valeur : FuseauSingapour. */
#define UpsEnuUpsNls_4_49 49
   /* Valeur : FuseauCeylan. */
#define UpsEnuUpsNls_4_50 50
   /* Valeur : FuseauOsakaSapporoTokyo. */
#define UpsEnuUpsNls_4_51 51
   /* Valeur : FuseauSeoul. */
#define UpsEnuUpsNls_4_52 52
   /* Valeur : FuseauYakutsk. */
#define UpsEnuUpsNls_4_53 53
   /* Valeur : FuseauAdelaide. */
#define UpsEnuUpsNls_4_54 54
   /* Valeur : FuseauDarwin. */
#define UpsEnuUpsNls_4_55 55
   /* Valeur : FuseauBrisbane. */
#define UpsEnuUpsNls_4_56 56
   /* Valeur : FuseauCanberraMelbourneSydney. */
#define UpsEnuUpsNls_4_57 57
   /* Valeur : FuseauGuamPortMoresby. */
#define UpsEnuUpsNls_4_58 58
   /* Valeur : FuseauHobart. */
#define UpsEnuUpsNls_4_59 59
   /* Valeur : FuseauVladivostok. */
#define UpsEnuUpsNls_4_60 60
   /* Valeur : FuseauMagadanSalomonNouvelleCaledonie. */
#define UpsEnuUpsNls_4_61 61
   /* Valeur : FuseauAucklandWellington. */
#define UpsEnuUpsNls_4_62 62
   /* Valeur : FuseauFijiKamchatkaMarshall. */

/*------------------------------*/
/* Enumere MetriquesSupportees. */
/*------------------------------*/
#define UpsEnuUpsNls_5_1 1
   /* Valeur : Metre. */
#define UpsEnuUpsNls_5_2 2
   /* Valeur : Yard. */

/*----------------------------------*/
/* Enumere SousMetriquesSupportees. */
/*----------------------------------*/
#define UpsEnuUpsNls_6_1 1
   /* Valeur : CentiMetre. */
#define UpsEnuUpsNls_6_2 2
   /* Valeur : Pouce. */
#define UpsEnuUpsNls_6_3 3
   /* Valeur : Pied. */

/*---------------------------------*/
/* Enumere SubMetriquesSupportees. */
/*---------------------------------*/
#define UpsEnuUpsNls_7_1 1
   /* Valeur : KiloMetre. */
#define UpsEnuUpsNls_7_2 2
   /* Valeur : MilleTerrestre. */
#define UpsEnuUpsNls_7_3 3
   /* Valeur : MilleMarin. */

/*------------------------------*/
/* Enumere PoidsSupportes.      */
/*------------------------------*/
#define UpsEnuUpsNls_8_1 1
   /* Valeur : KiloGramme. */
#define UpsEnuUpsNls_8_2 2
   /* Valeur : Livre. */
#define UpsEnuUpsNls_8_3 3
   /* Valeur : Once. */

/*---------------------------------*/
/* Enumere TemperaturesSupportees. */
/*---------------------------------*/
#define UpsEnuUpsNls_9_1 1
   /* Valeur : Kelvin. */
#define UpsEnuUpsNls_9_2 2
   /* Valeur : Celsius. */
#define UpsEnuUpsNls_9_3 3
   /* Valeur : Fahrenheit. */

/*------------------------------*/
/* Enumere AnglesSupportes.     */
/*------------------------------*/
#define UpsEnuUpsNls_10_1 1
   /* Valeur : Radian. */
#define UpsEnuUpsNls_10_2 2
   /* Valeur : Degres. */
#define UpsEnuUpsNls_10_3 3
   /* Valeur : Grade. */
   
/*------------------------------*/
/* Enumere AnglesSupportes.     */
/*------------------------------*/
#define UpsEnuUpsNls_10_1 1
   /* Valeur : Radian. */
#define UpsEnuUpsNls_10_2 2
   /* Valeur : Degres. */
#define UpsEnuUpsNls_10_3 3
   /* Valeur : Grade. */

/*------------------------------*/
/* Enumere DureesSupportees.    */
/*------------------------------*/
#define UpsEnuUpsNls_11_1 1
   /* Valeur : DureeAn. */
#define UpsEnuUpsNls_11_2 2
   /* Valeur : DureeMois. */
#define UpsEnuUpsNls_11_3 3
   /* Valeur : DureeJour. */
#define UpsEnuUpsNls_11_4 4
   /* Valeur : DureeHeure. */
#define UpsEnuUpsNls_11_5 5
   /* Valeur : DureeSeconde. */

/*------------------------------*/
/* Enumere MonnaiesSupportees.  */
/*------------------------------*/
#define UpsEnuUpsNls_12_1 1
   /* Valeur : MonnaieLivre. */
#define UpsEnuUpsNls_12_2 2
   /* Valeur : MonnaieEuro. */
#define UpsEnuUpsNls_12_3 3
   /* Valeur : MonnaieDollar. */
#define UpsEnuUpsNls_12_4 4
   /* Valeur : MonnaieYen. */
#define UpsEnuUpsNls_12_5 5
   /* Valeur : MonnaieYuan. */
#define UpsEnuUpsNls_12_6 6
   /* Valeur : MonnaieRouble. */

/*--------------------------------------------------------------*/
/* Codification des pages de code pour les caracteres usuels.   */
/*--------------------------------------------------------------*/
enum EnuUpsNlsFamillePagesDeCodes
   {
   PC_Ascii=1,
   PC_Ebcdic=2
   };
   
/*-----------------------------------*/
/* Codification des symboles usuels. */
/*-----------------------------------*/
enum EnuUpsNlsCodesUnicode
   {
   UN_Tabulation=9,
   UN_SautDeLigne=10,
   UN_SautDePage=12,
   UN_RetourChariot=13,
   UN_Echappement=27,
   UN_Espace=32,
   UN_PointDExclamation=33,
   UN_Guillemet=34,
   UN_Diese=35,
   UN_Dollar=36,
   UN_Pourcent=37,
   UN_Ampersand=38,
   UN_Apostrophe=39,
   UN_ParentheseOuvrante=40,
   UN_ParentheseFermante=41,
   UN_Multiplication=42,
   UN_Addition=43,
   UN_Virgule=44,
   UN_Soustraction=45,
   UN_Point=46,
   UN_Division=47,
   UN_Zero=48,
   UN_Un=49,
   UN_Deux=50,
   UN_Trois=51,
   UN_Quatre=52,
   UN_Cinq=53,
   UN_Six=54,
   UN_Sept=55,
   UN_Huit=56,
   UN_Neuf=57,
   UN_DeuxPoints=58,
   UN_PointVirgule=59,
   UN_Inferieur=60,
   UN_Egal=61,
   UN_Superieur=62,
   UN_PointDInterrogation=63,
   UN_Arrobase=64,
   UN_AMajuscule=65,
   UN_BMajuscule=66,
   UN_CMajuscule=67,
   UN_DMajuscule=68,
   UN_EMajuscule=69,
   UN_FMajuscule=70,
   UN_GMajuscule=71,
   UN_HMajuscule=72,
   UN_IMajuscule=73,
   UN_JMajuscule=74,
   UN_KMajuscule=75,
   UN_LMajuscule=76,
   UN_MMajuscule=77,
   UN_NMajuscule=78,
   UN_OMajuscule=79,
   UN_PMajuscule=80,
   UN_QMajuscule=81,
   UN_RMajuscule=82,
   UN_SMajuscule=83,
   UN_TMajuscule=84,
   UN_UMajuscule=85,
   UN_VMajuscule=86,
   UN_WMajuscule=87,
   UN_XMajuscule=88,
   UN_YMajuscule=89,
   UN_ZMajuscule=90,
   UN_CrochetOuvrant=91,
   UN_DivisionInverse=92,
   UN_CrochetFermant=93,
   UN_AccentCirconflexe=94,
   UN_Souligne=95,
   UN_AccentGrave=96,
   UN_A=97,
   UN_B=98,
   UN_C=99,
   UN_D=100,
   UN_E=101,
   UN_F=102,
   UN_G=103,
   UN_H=104,
   UN_I=105,
   UN_J=106,
   UN_K=107,
   UN_L=108,
   UN_M=109,
   UN_N=110,
   UN_O=111,
   UN_P=112,
   UN_Q=113,
   UN_R=114,
   UN_S=115,
   UN_T=116,
   UN_U=117,
   UN_V=118,
   UN_W=119,
   UN_X=120,
   UN_Y=121,
   UN_Z=122,
   UN_AccoladeOuvrante=123,
   UN_Tuyau=124,
   UN_AccoladeFermante=125,
   UN_Tilde=126
   };

/****************************************************************/
/* Enumere Section.                                             */
/****************************************************************/
enum EnuUpsNlsSection
   {
   SC_Divers=1,
   SC_Message=2,
   SC_ParametreModule=3,
   SC_ParametreAppel=4,
   SC_Instruction=5,
   SC_Api=6,
   SC_Environnement=7,
   SC_Aide=8,
   SC_Regle=9
   };
   
/****************************************************************/
/* Enumere LanguesSupportees.                           	       */
/****************************************************************/
enum EnuUpsNlsLanguesSupportees
   {
   LS_Allemand=1,
   LS_Anglais=2,
   LS_Arabe=3,
   LS_Chinois=4,
   LS_Espagnol=5,
   LS_Francais=6,
   LS_Italien=7,
   LS_Japonais=8,
   LS_Portugais=9,
   LS_Russe=10
   };

#define CO_TailleTableUnicodes 128
   /* Taille de la table des premiers caracteres Unicode. */
#define CO_Thesaurus 0
   /* Numero du thesaurus. */
#define CO_NbThesaurusMax 10
   /* Nombre maximal de thesaurus pour les traductions dynamiques. */
#define CO_NbSectionsMax 10
   /* Nombre maximal de sections. */
#define CO_NbLanguesMax 25
   /* Nombre maximal de langues. */
   
/****************************************************************/
typedef struct typprmupsnls_1_1
/* Objet : Fonction Traduire(M:Module, S:SectionsSupportes,     */
/* MotCle:Caractere) Retourner Caractere;								 */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* M:Module. */
TypUpsVmUnsignedChar UpsVar2;
   /* S:SectionsSupportes. */
TypUpsVmAdresse UpsVar3;
   /* MotCle : Caractere. */
} TypPrmUpsNls_1_1;

/****************************************************************/
typedef struct typprmupsnls_2_1
/* Objet : Fonction Message(M:Module, MotCle:Caractere, P1:Nul  */
/* Ou Caractere=Nul, P2:Nul Ou Caractere=Nul, P3:Nul Ou         */
/* Caractere=Nul, P4:Nul Ou Caractere=Nul, P5:Nul Ou            */
/* Caractere=Nul) Retourner Caractere;                          */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* M:Module. */
TypUpsVmAdresse UpsVar2;
   /* MotCle : Caractere. */
TypUpsVmAdresse UpsVar3;
   /* P1 : Nul Ou Caractere. */
TypUpsVmAdresse UpsVar4;
   /* P2 : Nul Ou Caractere. */
TypUpsVmAdresse UpsVar5;
   /* P3 : Nul Ou Caractere. */
TypUpsVmAdresse UpsVar6;
   /* P4 : Nul Ou Caractere. */
TypUpsVmAdresse UpsVar7;
   /* P5 : Nul Ou Caractere. */
} TypPrmUpsNls_2_1;

/****************************************************************/
typedef struct typprmupsnls_3_1
/* Objet : ChangerFuseauHoraire(D:Nul Ou Date, FuseauDepart:    */
/* FuseauxHorairesSupportes, FuseauArrivee:                     */
/* FuseauxHorairesSupportes) Retourner Nul Ou Date.             */ 
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* D:Nul Ou Date. */
TypUpsVmUnsignedChar UpsVar2;
   /* FuseauDepart:FuseauxHorairesSupportes. */
TypUpsVmUnsignedChar UpsVar3;
   /* FuseauArrivee:FuseauxHorairesSupportes. */
} TypPrmUpsNls_3_1;

/****************************************************************/
typedef struct typprmupsnls_4_1
/* Objet : ConvertirMetrique(L:Reel, MetriqueDepart:            */
/* MetriquesSupportees, MetriqueArrivee:MetriquesSupportees)    */
/* Retourner Reel.                                              */ 
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* L:Reel. */
TypUpsVmUnsignedChar UpsVar2;
   /* MetriqueDepart:MetriquesSupportees. */
TypUpsVmUnsignedChar UpsVar3;
   /* MetriqueArrivee:MetriquesSupportees. */
} TypPrmUpsNls_4_1;

/****************************************************************/
typedef struct typprmupsnls_5_1
/* Objet : ConvertirSousMetrique(L:Reel, SousMetriqueDepart:    */
/* SousMetriquesSupportees, SousMetriqueArrivee:                */
/* SousMetriquesSupportees) Retourner Reel.                     */ 
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* L:Reel. */
TypUpsVmUnsignedChar UpsVar2;
   /* SousMetriqueDepart:SousMetriquesSupportees. */
TypUpsVmUnsignedChar UpsVar3;
   /* SousMetriqueArrivee:SousMetriquesSupportees. */
} TypPrmUpsNls_5_1;

/****************************************************************/
typedef struct typprmupsnls_6_1
/* Objet : ConvertirSubMetrique(L:Reel, SubMetriqueDepart:      */
/* SubMetriquesSupportees, SubMetriqueArrivee:                  */
/* SubMetriquesSupportees) Retourner Reel.                      */ 
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* L:Reel. */
TypUpsVmUnsignedChar UpsVar2;
   /* SubMetriqueDepart:SubMetriquesSupportees. */
TypUpsVmUnsignedChar UpsVar3;
   /* SubMetriqueArrivee:SubMetriquesSupportees. */
} TypPrmUpsNls_6_1;

/****************************************************************/
typedef struct typprmupsnls_7_1
/* Objet : ConvertirPoids(P:Reel, PoidsDepart:PoidsSupportes,   */
/* PoidsArrivee:PoidsSupportes) Retourner Reel.                 */ 
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* P:Reel. */
TypUpsVmUnsignedChar UpsVar2;
   /* PoidsDepart:PoidsSupportes. */
TypUpsVmUnsignedChar UpsVar3;
   /* PoidsArrivee:PoidsSupportes. */
} TypPrmUpsNls_7_1;

/****************************************************************/
typedef struct typprmuslnls_8_1
/* Objet : ConvertirTemperature(T:Reel, TemperatureDepart:      */
/* TemperaturesSupportees, TemperaturesArrivee:                 */
/* TemperaturesSupportees) Retourner Reel.                      */ 
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* T:Reel. */
TypUpsVmUnsignedChar UpsVar2;
   /* TemperatureDepart:TemperaturesSupportees. */
TypUpsVmUnsignedChar UpsVar3;
   /* TemperaturesArrivee:TemperaturesSupportees. */
} TypPrmUpsNls_8_1;

/****************************************************************/
typedef struct typprmupsnls_9_1
/* Objet : ConvertirAngle(A:Reel, AngleDepart:AnglesSupportes,  */
/* AnglesArrivee:AnglesSupportes) Retourner Reel.               */ 
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* A:Reel. */
TypUpsVmUnsignedChar UpsVar2;
   /* AngleDepart:AnglesSupportes. */
TypUpsVmUnsignedChar UpsVar3;
   /* AnglesArrivee:AnglesSupportes. */
} TypPrmUpsNls_9_1;

/****************************************************************/
typedef struct typprmupsnls_10_1
/* Objet : ConvertirSousMetriqueEnMetrique(L:Reel,              */
/* SousMetriqueDepart:SousMetriquesSupportees,  MetriqueArrivee */
/* :MetriquesSupportees) Retourner Reel.                        */ 
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* L:Reel. */
TypUpsVmUnsignedChar UpsVar2;
   /* SousMetriqueDepart:SousMetriquesSupportees. */
TypUpsVmUnsignedChar UpsVar3;
   /* MetriqueArrivee:MetriquesSupportees. */
} TypPrmUpsNls_10_1;

/****************************************************************/
typedef struct typprmupsnls_11_1
/* Objet : ConvertirMetriqueEnSousMetrique(L:Reel,              */
/* MetriqueDepart:MetriquesSupportees, SousMetriqueArrivee:     */
/* SousMetriquesSupportees) Retourner Reel.                     */ 
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* L:Reel. */
TypUpsVmUnsignedChar UpsVar2;
   /* MetriqueDepart:MetriquesSupportees. */
TypUpsVmUnsignedChar UpsVar3;
   /* SousMetriqueArrivee:SousMetriquesSupportees. */
} TypPrmUpsNls_11_1;

/****************************************************************/
typedef struct typprmupsnls_12_1
/* Objet : ConvertirSubMetriqueEnMetrique(L:Reel,               */
/* SubMetriqueDepart:SubMetriquesSupportees, MetriqueArrivee:   */
/* MetriquesSupportees) Retourner Reel.                         */ 
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* L:Reel. */
TypUpsVmUnsignedChar UpsVar2;
   /* SubMetriqueDepart:SubMetriquesSupportees. */
TypUpsVmUnsignedChar UpsVar3;
   /* MetriqueArrivee:MetriquesSupportees. */
} TypPrmUpsNls_12_1;

/****************************************************************/
typedef struct typprmupsnls_13_1
/* Objet : ConvertirMetriqueEnSubMetrique(L:Reel, MetriqueDepart*/
/* :MetriquesSupportees, SubMetriqueArrivee:                    */
/* SubMetriquesSupportees) Retourner Reel.                      */ 
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* L:Reel. */
TypUpsVmUnsignedChar UpsVar2;
   /* MetriqueDepart:MetriquesSupportees. */
TypUpsVmUnsignedChar UpsVar3;
   /* SubMetriqueArrivee:SubMetriquesSupportees. */
} TypPrmUpsNls_13_1;

/****************************************************************/
typedef struct typprmupsnls_14_1
/* Objet : ConvertirDuree(D:Reel, DureeDepart:DureesSupportes,  */
/* DureeArrivee:DureesSupportes) Retourner Reel.                */ 
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* D:Reel. */
TypUpsVmUnsignedChar UpsVar2;
   /* DureeDepart:DureesSupportes. */
TypUpsVmUnsignedChar UpsVar3;
   /* DureeArrivee:DureesSupportes. */
} TypPrmUpsNls_14_1;

/****************************************************************/
typedef struct typupsnlsdonnees
/* Objet: Interface des donnees de Ups Nls.                     */
/****************************************************************/
{
struct typupsvmentetedonneesmodule EnteteDonneesModule;
   /* Entete generique du module. */

TypUpsVmUnicode TableUnicodes[CO_TailleTableUnicodes];
   /* Table des 128 premiers caracteres Unicode pour tenir compte de RISC / CISC. */
TypUpsVmUnicode UpsHome[CO_TailleNomFichier+1];
   /* Valeur de UPS_HOME. */
TypUpsVmUnicode UpsPath[CO_TailleLigneMax+1];
   /* Valeur de UPS_PATH. */
TypUpsVmUnicode UpsNls[CO_TailleLigneMax+1];
   /* Valeur de UPS_NLS. */
TypUpsVmUnicode UpsLanguage[CO_TailleIdf+1];
   /* Valeur de UPS_LANGUAGE. */
} *TypUpsNlsDonnees;

typedef TypUpsVmShort UpsVmAPI (*TypUpsNlsChangerRessources)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees HandleInstancePrecedente, TypUpsVmPointeurDonnees HandleInstanceSuivante);
typedef TypUpsVmShort UpsVmAPI (*TypUpsNlsEnumererThesaurus)(TypUpsVmSession *Session, TypUpsVmUnicode *MotCle, TypUpsVmUnicode *Traduction);

/****************************************************************/
typedef struct typupsnlstraitements_1_1_0
/* Objet: Interface des traitements de Ups Nls.                 */
/****************************************************************/
{
struct typupsvmentetemethodesmodule EnteteMethodesModule;
   /* Methodes generiques au module. */ 

/*--------------------------------------------------------------*/
/* Procedures et fonctions.                                     */
/*--------------------------------------------------------------*/
TypUpsVmLong UpsVmAPI (*CalculerIndexAppel)(TypUpsVmPointeurDonnees InterfaceAppel, TypUpsVmPointeurDonnees AppelCourant);
   /* Objet : Calcule l'index de l'appel. */
TypUpsVmAdresse UpsVmAPI *(*Trt_1_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypPrmUpsNls_1_1 *UpsPrm);
   /* Objet : Fonction Traduire(M:Module, S:SectionsSupportes, MotCle:Caractere) Retourner Caractere; */
TypUpsVmAdresse UpsVmAPI *(*Trt_2_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat,
   TypPrmUpsNls_2_1 *UpsPrm);
   /* Objet : Fonction Message(M:Module, MotCle:Caractere, P1:Nul  */
   /* Ou Caractere=Nul, P2:Nul Ou Caractere=Nul, P3:Nul Ou         */
   /* Caractere=Nul, P4:Nul Ou Caractere=Nul, P5:Nul Ou            */
   /* Caractere=Nul) Retourner Caractere;                          */
TypUpsVmAdresse UpsVmAPI *(*Trt_3_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat,
   TypPrmUpsNls_3_1 *UpsPrm);
   /* Objet : ChangerFuseauHoraire(D:Nul Ou Date, FuseauDepart:FuseauxHorairesSupportes, 
   FuseauArrivee:FuseauxHorairesSupportes) Retourner Nul Ou Date. */ 
TypUpsVmDouble UpsVmAPI (*Trt_4_1)(TypUpsVmSession *Session, TypPrmUpsNls_4_1 *UpsPrm);
   /* Objet : ConvertirMetrique(L:Reel, MetriqueDepart:MetriquesSupportees, 
   MetriqueArrivee:MetriquesSupportees) Retourner Reel. */ 
TypUpsVmDouble UpsVmAPI (*Trt_5_1)(TypUpsVmSession *Session, TypPrmUpsNls_5_1 *UpsPrm);
   /* Objet : ConvertirSousMetrique(L:Reel, SousMetriqueDepart:SousMetriquesSupportees, 
   SousMetriqueArrivee:SousMetriquesSupportees) Retourner Reel. */ 
TypUpsVmDouble UpsVmAPI (*Trt_6_1)(TypUpsVmSession *Session, TypPrmUpsNls_6_1 *UpsPrm);
   /* Objet : ConvertirSubMetrique(L:Reel, SubMetriqueDepart:SubMetriquesSupportees, 
   SubMetriqueArrivee:SubMetriquesSupportees) Retourner Reel. */ 
TypUpsVmDouble UpsVmAPI (*Trt_7_1)(TypUpsVmSession *Session, TypPrmUpsNls_7_1 *UpsPrm);
   /* Objet : ConvertirPoids(P:Reel, PoidsDepart:PoidsSupportes, PoidsArrivee:PoidsSupportes) Retourner Reel. */ 
TypUpsVmDouble UpsVmAPI (*Trt_8_1)(TypUpsVmSession *Session, TypPrmUpsNls_8_1 *UpsPrm);
   /* Objet : ConvertirTemperature(T:Reel, TemperatureDepart:TemperaturesSupportees, 
   TemperaturesArrivee:TemperaturesSupportees) Retourner Reel. */ 
TypUpsVmDouble UpsVmAPI (*Trt_9_1)(TypUpsVmSession *Session, TypPrmUpsNls_9_1 *UpsPrm);
   /* Objet : ConvertirAngle(A:Reel, AngleDepart:AnglesSupportes, AnglesArrivee:AnglesSupportes) Retourner Reel. */ 
TypUpsVmDouble UpsVmAPI (*Trt_10_1)(TypUpsVmSession *Session, TypPrmUpsNls_10_1 *UpsPrm);
   /* Objet : ConvertirSousMetriqueEnMetrique(L:Reel, SousMetriqueDepart:SousMetriquesSupportees, 
   MetriqueArrivee:MetriquesSupportees) Retourner Reel. */ 
TypUpsVmDouble UpsVmAPI (*Trt_11_1)(TypUpsVmSession *Session, TypPrmUpsNls_11_1 *UpsPrm);
   /* Objet : ConvertirMetriqueEnSousMetrique(L:Reel, MetriqueDepart:MetriquesSupportees, 
   SousMetriqueArrivee:SousMetriquesSupportees) Retourner Reel. */ 
TypUpsVmDouble UpsVmAPI (*Trt_12_1)(TypUpsVmSession *Session, TypPrmUpsNls_12_1 *UpsPrm);
   /* Objet : ConvertirSubMetriqueEnMetrique(L:Reel, SubMetriqueDepart:SubMetriquesSupportees, 
   MetriqueArrivee:MetriquesSupportees) Retourner Reel. */ 
TypUpsVmDouble UpsVmAPI (*Trt_13_1)(TypUpsVmSession *Session, TypPrmUpsNls_13_1 *UpsPrm);
   /* Objet : ConvertirMetriqueEnSubMetrique(L:Reel, MetriqueDepart:MetriquesSupportees, 
   SubMetriqueArrivee:SubMetriquesSupportees) Retourner Reel. */ 
TypUpsVmDouble UpsVmAPI (*Trt_14_1)(TypUpsVmSession *Session, TypPrmUpsNls_14_1 *UpsPrm);
   /* Objet : ConvertirDuree(D:Reel, DureeDepart:DureesSupportes, DureeArrivee:DureesSupportes) Retourner Reel. */ 

TypUpsVmCoAppel CoTrt_1_1;
   /* Objet : Fonction Traduire(M:Module, S:SectionsSupportes, MotCle:Caractere) Retourner Caractere; */
TypUpsVmCoAppel CoTrt_2_1;
   /* Objet : Fonction Message(M:Module, MotCle:Caractere, P1:Nul  */
   /* Ou Caractere=Nul, P2:Nul Ou Caractere=Nul, P3:Nul Ou         */
   /* Caractere=Nul, P4:Nul Ou Caractere=Nul, P5:Nul Ou            */
   /* Caractere=Nul) Retourner Caractere;                          */
TypUpsVmCoAppel CoTrt_3_1;
   /* Objet : ChangerFuseauHoraire(D:Nul Ou Date, FuseauDepart:FuseauxHorairesSupportes, 
   FuseauArrivee:FuseauxHorairesSupportes) Retourner Nul Ou Date. */ 
TypUpsVmCoAppel CoTrt_4_1;
   /* Objet : ConvertirMetrique(L:Reel, MetriqueDepart:MetriquesSupportees, 
   MetriqueArrivee:MetriquesSupportees) Retourner Reel. */ 
TypUpsVmCoAppel CoTrt_5_1;
   /* Objet : ConvertirSousMetrique(L:Reel, SousMetriqueDepart:SousMetriquesSupportees, 
   SousMetriqueArrivee:SousMetriquesSupportees) Retourner Reel. */ 
TypUpsVmCoAppel CoTrt_6_1;
   /* Objet : ConvertirSubMetrique(L:Reel, SubMetriqueDepart:SubMetriquesSupportees, 
   SubMetriqueArrivee:SubMetriquesSupportees) Retourner Reel. */ 
TypUpsVmCoAppel CoTrt_7_1;
   /* Objet : ConvertirPoids(P:Reel, PoidsDepart:PoidsSupportes, PoidsArrivee:PoidsSupportes) Retourner Reel. */ 
TypUpsVmCoAppel CoTrt_8_1;
   /* Objet : ConvertirTemperature(T:Reel, TemperatureDepart:TemperaturesSupportees, 
   TemperaturesArrivee:TemperaturesSupportees) Retourner Reel. */ 
TypUpsVmCoAppel CoTrt_9_1;
   /* Objet : ConvertirAngle(A:Reel, AngleDepart:AnglesSupportes, AnglesArrivee:AnglesSupportes) Retourner Reel. */ 
TypUpsVmCoAppel CoTrt_10_1;
   /* Objet : ConvertirSousMetriqueEnMetrique(L:Reel, SousMetriqueDepart:SousMetriquesSupportees, 
   MetriqueArrivee:MetriquesSupportees) Retourner Reel. */ 
TypUpsVmCoAppel CoTrt_11_1;
   /* Objet : ConvertirMetriqueEnSousMetrique(L:Reel, MetriqueDepart:MetriquesSupportees, 
   SousMetriqueArrivee:SousMetriquesSupportees) Retourner Reel. */ 
TypUpsVmCoAppel CoTrt_12_1;
   /* Objet : ConvertirSubMetriqueEnMetrique(L:Reel, SubMetriqueDepart:SubMetriquesSupportees, 
   MetriqueArrivee:MetriquesSupportees) Retourner Reel. */ 
TypUpsVmCoAppel CoTrt_13_1;
   /* Objet : ConvertirMetriqueEnSubMetrique(L:Reel, MetriqueDepart:MetriquesSupportees, 
   SubMetriqueArrivee:SubMetriquesSupportees) Retourner Reel. */ 
TypUpsVmCoAppel CoTrt_14_1;
   /* Objet : ConvertirDuree(D:Reel, DureeDepart:DureesSupportes, DureeArrivee:DureesSupportes) Retourner Reel. */ 

/*--------------------------------------------------------------*/
/* Tables des methodes.                                         */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Enumeres.			              				                   */
/*--------------------------------------------------------------*/
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_1_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_1_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* SectionsSupportees. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_2_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_2_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* PaysSupportes. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_3_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_3_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_3_3)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm, TypUpsVmAdresse *UpsPrm2);
   /* LanguesSupportees. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_4_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
TypUpsVmDouble UpsVmAPI (*TrtEnu_4_3)(TypUpsVmSession *Session, TypUpsVmUnsignedChar UpsPrm, TypUpsVmAdresse *UpsPrm2);
   /* FuseauxHorairesSupportes. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_5_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* MetriquesSupportees. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_6_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* SousMetriquesSupportees. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_7_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* SubMetriquesSupportees. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_8_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_8_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* PoidsSupportes. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_9_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_9_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* TemperaturesSupportees. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_10_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_10_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* AnglesSupportes. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_11_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_11_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* DureesSupportees. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_12_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_12_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* MonnaiesSupportees. */

/*--------------------------------------------------------------*/
/* Entrepots.          								                   */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Types et interfaces.                                         */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Variables globales.                                          */
/*--------------------------------------------------------------*/
TypUpsVmUnsignedChar UpsVmAPI (*UpsVar1_get)(TypUpsVmSession *Session);
   /* Pays. */
TypUpsVmUnsignedChar UpsVmAPI (*UpsVar2_get)(TypUpsVmSession *Session);
   /* Langue. */
TypUpsVmUnsignedChar UpsVmAPI (*UpsVar3_get)(TypUpsVmSession *Session);
   /* FuseauHoraire. */
TypUpsVmUnsignedChar UpsVmAPI (*UpsVar4_get)(TypUpsVmSession *Session);
   /* Metrique. */
TypUpsVmUnsignedChar UpsVmAPI (*UpsVar5_get)(TypUpsVmSession *Session);
   /* SousMetrique. */
TypUpsVmUnsignedChar UpsVmAPI (*UpsVar6_get)(TypUpsVmSession *Session);
   /* SubMetrique. */
TypUpsVmUnsignedChar UpsVmAPI (*UpsVar7_get)(TypUpsVmSession *Session);
   /* Poids. */
TypUpsVmUnsignedChar UpsVmAPI (*UpsVar8_get)(TypUpsVmSession *Session);
   /* Temperature. */
TypUpsVmUnsignedChar UpsVmAPI (*UpsVar9_get)(TypUpsVmSession *Session);
   /* Angle. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar10_get)(TypUpsVmSession *Session);
   /* SymboleDecimale. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar11_get)(TypUpsVmSession *Session);
   /* SymboleVirgule. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar12_get)(TypUpsVmSession *Session);
   /* SymboleMonetaire. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar13_get)(TypUpsVmSession *Session);
   /* SymboleMetrique. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar14_get)(TypUpsVmSession *Session);
   /* SymboleSousMetrique. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar15_get)(TypUpsVmSession *Session);
   /* SymboleSubMetrique. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar16_get)(TypUpsVmSession *Session);
   /* SymbolePoids. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar17_get)(TypUpsVmSession *Session);
   /* SymboleTemperature. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar18_get)(TypUpsVmSession *Session);
   /* SymboleAngle. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar19_get)(TypUpsVmSession *Session);
   /* UniteMonetaire. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar20_get)(TypUpsVmSession *Session);
   /* UniteMetrique. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar21_get)(TypUpsVmSession *Session);
   /* UniteSousMetrique. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar22_get)(TypUpsVmSession *Session);
   /* UniteSubMetrique. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar23_get)(TypUpsVmSession *Session);
   /* UnitePoids. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar24_get)(TypUpsVmSession *Session);
   /* UniteTemperature. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar25_get)(TypUpsVmSession *Session);
   /* UniteAngle. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar26_get)(TypUpsVmSession *Session);
   /* FiltreEntier. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar27_get)(TypUpsVmSession *Session);
   /* FiltreReel. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar28_get)(TypUpsVmSession *Session);
   /* FiltreMonnaieEntier. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar29_get)(TypUpsVmSession *Session);
   /* FiltreMonnaieReel. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar30_get)(TypUpsVmSession *Session);
   /* FiltreHeure. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar31_get)(TypUpsVmSession *Session);
   /* FiltreDate. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar32_get)(TypUpsVmSession *Session);
   /* FiltreDateHeure. */
TypUpsVmUnsignedChar UpsVmAPI (*UpsVar33_get)(TypUpsVmSession *Session);
   /* Duree. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar34_get)(TypUpsVmSession *Session);
   /* SymboleDuree. */
TypUpsVmAdresse UpsVmAPI *(*UpsVar35_get)(TypUpsVmSession *Session);
   /* UniteDuree. */
TypUpsVmUnsignedChar UpsVmAPI (*UpsVar36_get)(TypUpsVmSession *Session);
   /* Monnaie. */
TypUpsVmDouble UpsVmAPI (*UpsVar37_get)(TypUpsVmSession *Session);
   /* UnDollar. */
TypUpsVmVoid UpsVmAPI (*UpsVar37_set)(TypUpsVmSession *Session, TypUpsVmDouble UpsPrm, enum EnuUpsVmOperateur Operateur);
   /* UnDollar. */
TypUpsVmDouble UpsVmAPI (*UpsVar37_inc)(TypUpsVmSession *Session, TypUpsVmChar Incrementer, TypUpsVmChar Prefixe);
   /* UnDollar. */
TypUpsVmDouble UpsVmAPI (*UpsVar38_get)(TypUpsVmSession *Session);
   /* UneLivre. */
TypUpsVmVoid UpsVmAPI (*UpsVar38_set)(TypUpsVmSession *Session, TypUpsVmDouble UpsPrm, enum EnuUpsVmOperateur Operateur);
   /* UneLivre. */
TypUpsVmDouble UpsVmAPI (*UpsVar38_inc)(TypUpsVmSession *Session, TypUpsVmChar Incrementer, TypUpsVmChar Prefixe);
   /* UneLivre. */
TypUpsVmDouble UpsVmAPI (*UpsVar39_get)(TypUpsVmSession *Session);
   /* CentYens. */
TypUpsVmVoid UpsVmAPI (*UpsVar39_set)(TypUpsVmSession *Session, TypUpsVmDouble UpsPrm, enum EnuUpsVmOperateur Operateur);
   /* CentYens. */
TypUpsVmDouble UpsVmAPI (*UpsVar39_inc)(TypUpsVmSession *Session, TypUpsVmChar Incrementer, TypUpsVmChar Prefixe);
   /* CentYens. */
TypUpsVmDouble UpsVmAPI (*UpsVar40_get)(TypUpsVmSession *Session);
   /* UnEuro. */
TypUpsVmVoid UpsVmAPI (*UpsVar40_set)(TypUpsVmSession *Session, TypUpsVmDouble UpsPrm, enum EnuUpsVmOperateur Operateur);
   /* UnEuro. */
TypUpsVmDouble UpsVmAPI (*UpsVar40_inc)(TypUpsVmSession *Session, TypUpsVmChar Incrementer, TypUpsVmChar Prefixe);
   /* UnEuro. */
TypUpsVmDouble UpsVmAPI (*UpsVar41_get)(TypUpsVmSession *Session);
   /* UnYuan. */
TypUpsVmVoid UpsVmAPI (*UpsVar41_set)(TypUpsVmSession *Session, TypUpsVmDouble UpsPrm, enum EnuUpsVmOperateur Operateur);
   /* UnYuan. */
TypUpsVmDouble UpsVmAPI (*UpsVar41_inc)(TypUpsVmSession *Session, TypUpsVmChar Incrementer, TypUpsVmChar Prefixe);
   /* UnYuan. */
TypUpsVmDouble UpsVmAPI (*UpsVar42_get)(TypUpsVmSession *Session);
   /* UnRouble. */
TypUpsVmVoid UpsVmAPI (*UpsVar42_set)(TypUpsVmSession *Session, TypUpsVmDouble UpsPrm, enum EnuUpsVmOperateur Operateur);
   /* UnRouble. */
TypUpsVmDouble UpsVmAPI (*UpsVar42_inc)(TypUpsVmSession *Session, TypUpsVmChar Incrementer, TypUpsVmChar Prefixe);
   /* UnRouble. */

/*--------------------------------------------------------------*/
/* Exceptions.                                                  */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Files d'attente.                                             */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Application Program Interfaces proprietaires.                */
/*--------------------------------------------------------------*/
TypUpsVmUnicode UpsVmAPI *(*Traduire)(TypUpsVmSession *Session, TypUpsVmShort NumeroModule, enum EnuUpsNlsSection Section, TypUpsVmUnicode *MotCle);
   /* Objet : Traduit le  mot-cle pour le module concerne. */
TypUpsVmUnicode UpsVmAPI *(*TraduireThesaurus)(TypUpsVmSession *Session, enum EnuUpsNlsLanguesSupportees Langue, enum EnuUpsNlsSection Section, TypUpsVmUnicode *MotCle);
   /* Objet : Traduit le  mot-cle pour le thesaurus concerne. Mode normal. */
TypUpsVmUnicode UpsVmAPI *(*TraduireInverseThesaurus)(TypUpsVmSession *Session, enum EnuUpsNlsLanguesSupportees Langue, enum EnuUpsNlsSection Section, TypUpsVmUnicode *MotCle);
   /* Objet : Traduit le  mot-cle pour le thesaurus concerne. Mode inverse. */
TypUpsVmShort UpsVmAPI (*EnumererThesaurus)(TypUpsVmSession *Session, enum EnuUpsNlsLanguesSupportees Langue, 
   enum EnuUpsNlsSection Section, TypUpsNlsEnumererThesaurus Appel);
   /* Objet : Enumere les mots-cles du thesaurus par ordre alphabetique. */
TypUpsVmUnicode UpsVmAPI *(*Message0)(TypUpsVmSession *Session, TypUpsVmShort NumeroModule, TypUpsVmUnicode *MotCle);
   /* Objet: Formate un message sans parametre. */
TypUpsVmUnicode UpsVmAPI *(*Message1)(TypUpsVmSession *Session, TypUpsVmShort NumeroModule, TypUpsVmUnicode *MotCle, TypUpsVmUnicode *C1);
   /* Objet: Formate un message a 1 parametre. */
TypUpsVmUnicode UpsVmAPI *(*Message2)(TypUpsVmSession *Session, TypUpsVmShort NumeroModule, TypUpsVmUnicode *MotCle, TypUpsVmUnicode *C1, 
	TypUpsVmUnicode *C2);
   /* Objet: Formate un message a 2 parametres. */
TypUpsVmUnicode UpsVmAPI *(*Message3)(TypUpsVmSession *Session, TypUpsVmShort NumeroModule, TypUpsVmUnicode *MotCle, TypUpsVmUnicode *C1, 
	TypUpsVmUnicode *C2, TypUpsVmUnicode *C3);
   /* Objet: Formate un message a 3 parametres. */
TypUpsVmUnicode UpsVmAPI *(*Message4)(TypUpsVmSession *Session, TypUpsVmShort NumeroModule, TypUpsVmUnicode *MotCle, TypUpsVmUnicode *C1, 
	TypUpsVmUnicode *C2, TypUpsVmUnicode *C3, TypUpsVmUnicode *C4);
   /* Objet: Formate un message a 4 parametres. */
TypUpsVmUnicode UpsVmAPI *(*Message5)(TypUpsVmSession *Session, TypUpsVmShort NumeroModule, TypUpsVmUnicode *MotCle, TypUpsVmUnicode *C1, 
   TypUpsVmUnicode *C2, TypUpsVmUnicode *C3, TypUpsVmUnicode *C4, TypUpsVmUnicode *C5);
   /* Objet: Formate un message a 5 parametres. */
TypUpsVmShort UpsVmAPI (*DecoderLigneEtSection)(TypUpsVmUnicode *Ligne, enum EnuUpsNlsSection *NumeroSection, TypUpsVmShort SupprimerCommentaire);
   /* Objet : Decode une ligne et une section. Retourne Vrai si la ligne est valide. */
enum EnuUpsNlsLanguesSupportees UpsVmAPI (*DecoderLangue)(TypUpsVmSession *Session, TypUpsVmUnicode *Langue);
   /* Objet: Decode la langue supportee. */
TypUpsVmUnicode UpsVmAPI *(*CalculerLibelleSection)(TypUpsVmShort NumeroSection, TypUpsVmUnicode *LibelleSection);
   /* Objet: Calcule le libelle de la section demandee. */
TypUpsVmUnicode UpsVmAPI *(*CalculerRepertoireLangue)(enum EnuUpsNlsLanguesSupportees Langue);
   /* Objet: Calcule le repertoire de la langue demandee. */
TypUpsVmUnicode UpsVmAPI *(*CalculerRepertoireUtilisateur)(enum EnuUpsNlsLanguesSupportees Langue);
   /* Objet: Calcule le repertoire de l'utilisateur type dans la langue demandee. */
TypUpsVmUnicode UpsVmAPI *(*CalculerCodeMime)(enum EnuUpsNlsLanguesSupportees Langue);
   /* Objet: Calcule le code mime dans la langue demandee. */
TypUpsVmShort UpsVmAPI (*ChargerModule)(TypUpsVmShort NumeroModule, TypUpsNlsChangerRessources ChangerRessources, TypUpsVmShort IlExisteDllRessources);
   /* Chargement d'un module. */
TypUpsVmShort UpsVmAPI (*ChargerThesaurus)(enum EnuUpsNlsLanguesSupportees Langue, TypUpsVmUnicode *NomFichierThesaurus, TypUpsVmShort Inverser);
   /* Objet : Chargement d'un thesaurus pour une traduction. */
TypUpsVmShort UpsVmAPI (*DechargerThesaurus)(enum EnuUpsNlsLanguesSupportees Langue);
   /* Objet : Dechargement d'un thesaurus pour une traduction. */
TypUpsVmShort UpsVmAPI (*ConvertirPageDeCode)(TypUpsVmSession *Session, TypUpsVmUnicode *ChaineDepart, TypUpsVmUnicode *ChaineArrivee, 
   TypUpsVmLong TailleChaineArrivee, TypUpsVmUnsignedChar IndicePageDeCodeDepart, TypUpsVmUnsignedChar IndicePageDeCodeArrivee);
   /* Objet : Convertit une chaine de caracteres d'une page de code vers une autre page de code. */
TypUpsVmShort UpsVmAPI (*InitialiserEncapsulationKernel)(TypUpsVmVoid);
   /* Objet : Initialisation de l'extension de Ups Nls pour Ups Krn. */
TypUpsVmVoid UpsVmAPI (*TerminerEncapsulationKernel)(TypUpsVmVoid);
   /* Objet : Terminaison de l'extension de Ups Nls pour Ups Krn. */
TypUpsVmVoid UpsVmAPI (*ChaineTropCourte)(TypUpsVmUnicode *ModuleEtApi);
	/* Objet : Envoie un message d'erreur suite a une chaine trop courte. */
TypUpsVmVoid UpsVmAPI (*StrCpy)(TypUpsVmUnicode *ChaineArrivee, TypUpsVmLong TailleChaineArrivee, TypUpsVmUnicode *ChaineDepart);
   /* Objet : Copie d'une chaine dans une autre. */
TypUpsVmVoid UpsVmAPI (*StrNCpy)(TypUpsVmUnicode *ChaineArrivee, TypUpsVmLong TailleChaineArrivee, TypUpsVmUnicode *ChaineDepart,
   TypUpsVmLong Taille);
   /* Objet : Copie d'une chaine dans une autre dans la limite d'une certaine taille. */
TypUpsVmUnicode UpsVmAPI *(*StrCat)(TypUpsVmUnicode *ChaineArrivee, TypUpsVmLong TailleChaineArrivee, TypUpsVmUnicode 
   *ChaineDepart);
   /* Objet : Concatene une chaine dans une autre. */
TypUpsVmUnicode UpsVmAPI *(*StrNCat)(TypUpsVmUnicode *ChaineArrivee, TypUpsVmLong TailleChaineArrivee, TypUpsVmUnicode 
   *ChaineDepart, TypUpsVmLong Taille);
   /* Objet : Concatene une chaine dans une autre dans la limite d'une certaine taille. */
TypUpsVmShort UpsVmAPI (*StrCmp)(TypUpsVmUnicode *Chaine1, TypUpsVmUnicode *Chaine2);
   /* Objet : Compare deux chaines. */
TypUpsVmShort UpsVmAPI (*StrNCmp)(TypUpsVmUnicode *Chaine1, TypUpsVmUnicode *Chaine2, 
   TypUpsVmLong Taille);
   /* Objet : Compare deux chaines dans la limite d'une certaine taille. */
TypUpsVmShort UpsVmAPI (*StrNCmp2)(TypUpsVmUnicode *Chaine1, TypUpsVmUnicode *Chaine2);
   /* Objet : Compare deux chaines dans la limite de la taille de la chaine droite. */
TypUpsVmShort UpsVmAPI (*StrICmp)(TypUpsVmUnicode *Chaine1, TypUpsVmUnicode *Chaine2);
   /* Objet : Compare deux chaines en ignorant les differences entre majuscules et minuscules. */
TypUpsVmShort UpsVmAPI (*StrNICmp)(TypUpsVmUnicode *Chaine1, TypUpsVmUnicode *Chaine2, 
   TypUpsVmLong Taille);
   /* Objet : Compare deux chaines en ignorant les differences entre majuscules et */
   /* minuscules dans la limite d'une certaine taille. */
TypUpsVmShort UpsVmAPI (*StrNICmp2)(TypUpsVmUnicode *Chaine1, TypUpsVmUnicode *Chaine2);
   /* Objet : Compare deux chaines en ignorant les differences entre majuscules et minuscules dans la limite de la taille de la chaine droite. */
TypUpsVmLong UpsVmAPI (*StrLen)(TypUpsVmUnicode *Chaine);
   /* Objet : Calcule la taille d'une chaine en caracteres. */
TypUpsVmLong UpsVmAPI (*StrLenB)(TypUpsVmUnicode *Chaine);
   /* Objet : Calcule la taille d'une chaine en octets. */
TypUpsVmLong UpsVmAPI (*StrLenB2)(TypUpsVmChar *Chaine);
   /* Objet : Calcule la taille d'une chaine en octets. */
TypUpsVmShort UpsVmAPI (*IsNul)(TypUpsVmUnicode *Chaine);
   /* Objet : Retourne Vrai si la chaine est nulle. */
TypUpsVmShort UpsVmAPI (*IsAlpha)(TypUpsVmUnicode C);
   /* Objet : Retourne Vrai si le caractere est alphabetique. */
TypUpsVmShort UpsVmAPI (*IsUpper)(TypUpsVmUnicode C);
   /* Objet : Retourne Vrai si le caractere est une majuscule. */
TypUpsVmShort UpsVmAPI (*IsLower)(TypUpsVmUnicode C);
   /* Objet : Retourne Vrai si le caractere est une minuscule. */
TypUpsVmShort UpsVmAPI (*IsDigit)(TypUpsVmUnicode C);
   /* Objet : Retourne Vrai si le caractere est un chiffre. */
TypUpsVmShort UpsVmAPI (*IsSpace)(TypUpsVmUnicode C);
   /* Objet : Retourne Vrai si le caractere est un espace. */
TypUpsVmShort UpsVmAPI (*IsMark)(TypUpsVmUnicode C);
   /* Objet : Retourne Vrai si le caractere est une marque. */
TypUpsVmShort UpsVmAPI (*IsAlphaNum)(TypUpsVmUnicode C);
   /* Objet : Retourne Vrai si le caractere est alphabetique ou un chiffre. */
TypUpsVmShort UpsVmAPI (*IsMiror)(TypUpsVmUnicode C);
   /* Objet : Retourne Vrai si le caractere est un caractere miroir. */
TypUpsVmLong UpsVmAPI (*IntegerValue)(TypUpsVmUnicode C);
   /* Objet : Retourne la valeur entiere equivalente. */
TypUpsVmDouble UpsVmAPI (*RealValue)(TypUpsVmUnicode C);
   /* Objet : Retourne la valeur reelle equivalente. */
TypUpsVmUnicode UpsVmAPI (*Upper2)(TypUpsVmUnicode C);
   /* Objet : Bascule le caractere en majuscule. */
TypUpsVmUnicode UpsVmAPI (*Lower2)(TypUpsVmUnicode C);
   /* Objet : Bascule le caractere en minuscule. */
TypUpsVmUnicode UpsVmAPI (*UpLower2)(TypUpsVmUnicode C);
   /* Objet : Bascule le caractere en majminuscule. */
TypUpsVmUnicode UpsVmAPI *(*Upper)(TypUpsVmUnicode *Chaine);
   /* Objet : Bascule la chaine en majuscule. */
TypUpsVmUnicode UpsVmAPI *(*Lower)(TypUpsVmUnicode *Chaine);
   /* Objet : Bascule la chaine en minuscule. */
TypUpsVmUnicode UpsVmAPI *(*UpLower)(TypUpsVmUnicode *Chaine);
   /* Objet : Bascule la chaine en minuscule sauf l'initiale en en majuscule. */
TypUpsVmUnicode UpsVmAPI *(*Long2Ascii)(TypUpsVmUnicode *Resultat, TypUpsVmLong TailleChaineResultat, TypUpsVmLong L);
   /* Objet : Convertit un TypUpsVmLong en chaine. */
TypUpsVmUnicode UpsVmAPI *(*UnsignedLong2Ascii)(TypUpsVmUnicode *Resultat, TypUpsVmLong TailleChaineResultat, TypUpsVmUnsignedLong L);
   /* Objet : Convertit un TypUpsVmLong en chaine. */
TypUpsVmUnicode UpsVmAPI *(*Double2Ascii)(TypUpsVmUnicode *Resultat, TypUpsVmLong TailleChaineResultat, TypUpsVmDouble D);
   /* Objet : Convertit un TypUpsVmDouble en chaine. */
TypUpsVmLong UpsVmAPI (*DecoderHexadecimal)(TypUpsVmUnicode *Chaine);
   /* Objet : Decode un nombre en hexadecimal. */
TypUpsVmLong UpsVmAPI (*DecoderDecimal)(TypUpsVmUnicode *Chaine);
   /* Objet : Decode un nombre en decimal. */
TypUpsVmLong UpsVmAPI (*Ascii2Long)(TypUpsVmUnicode *Chaine);
   /* Objet : Convertit une chaine en TypUpsVmLong. */
TypUpsVmUnsignedLong UpsVmAPI (*Ascii2UnsignedLong)(TypUpsVmUnicode *Chaine);
   /* Objet : Convertit une chaine en TypUpsVmUnsignedLong. */
TypUpsVmDouble UpsVmAPI (*Ascii2Double)(TypUpsVmUnicode *Chaine);
   /* Objet : Convertit une chaine en TypUpsVmDouble. */
TypUpsVmLong UpsVmAPI (*Unicode2Entier)(TypUpsVmUnicode C);
   /* Objet : Convertit le code unicode en un entier. */
TypUpsVmUnicode UpsVmAPI (*Entier2Unicode)(TypUpsVmLong E);
   /* Objet : Convertit l'entier en un code unicode. */
TypUpsVmUnicode UpsVmAPI (*EncoderChiffre)(TypUpsVmLong Chiffre, TypUpsVmShort Majuscule);
   /* Objet : Encode le chiffre de 0 a 9, de a a f ou de A a F selon la langue choisie. */
TypUpsVmUnicode UpsVmAPI *(*Dbcs2Unicode)(TypUpsVmUnsignedShort *Chaine1, TypUpsVmUnicode *Chaine2, 
   TypUpsVmLong TailleChaine2, TypUpsVmShort Encodage);
   /* Objet : Convertit une chaine dbcs en chaine Unicode. */
TypUpsVmUnsignedShort UpsVmAPI *(*Unicode2Dbcs)(TypUpsVmUnicode *Chaine1, 
   TypUpsVmUnsignedShort *Chaine2, TypUpsVmLong TailleChaine2, TypUpsVmShort Encodage);
   /* Objet : Convertit une chaine Unicode en chaine dbcs. */
TypUpsVmUnicode UpsVmAPI *(*Char2Unicode)(TypUpsVmChar *Chaine1, TypUpsVmUnicode 
   *Chaine2, TypUpsVmLong TailleChaine2, TypUpsVmShort Encodage);
   /* Objet : Convertit une chaine Ascii en chaine Unicode. Par convention, les chaines de */
   /* Ups Vm sont UTF-16 Little Endian quelle que soit la plate-forme. */
TypUpsVmChar UpsVmAPI *(*Unicode2Char)(TypUpsVmUnicode *Chaine1, TypUpsVmChar 
   *Chaine2, TypUpsVmLong TailleChaine2, TypUpsVmShort Encodage);
   /* Objet : Convertit une chaine Unicode en chaine Ascii. */
TypUpsVmUnicode UpsVmAPI *(*EliminerAccentues)(TypUpsVmUnicode *Chaine1, TypUpsVmUnicode *Chaine2, TypUpsVmLong TailleChaine2);
   /* Objet : Elimine les caracteres accentues ou speciaux. */
TypUpsVmLong UpsVmAPI (*TailleChaineDecomposee)(TypUpsVmUnicode *Chaine);
   /* Objet : Retourne la taille de la chaine une fois decomposee. */
TypUpsVmUnicode UpsVmAPI *(*DecomposerChaine)(TypUpsVmUnicode *ChaineDebut, TypUpsVmUnicode *ChaineFin, TypUpsVmLong TailleChaineFin);
   /* Objet : Decompose la chaine de caracteres. */
TypUpsVmUnicode UpsVmAPI *(*ComposerChaine)(TypUpsVmUnicode *Chaine, TypUpsVmShort AppliquerLigatures);
   /* Objet : Compose la chaine de caractere. */
TypUpsVmEnteteMethodesModule UpsVmAPI (*LireInterfaceModule)(TypUpsVmUnicode *NomModule, 
   enum EnuUpsVtmLireInterface TypeModule, TypUpsVmShort Version, TypUpsVmShort Revision, 
   TypUpsVmShort Correction);
	/* Objet : Lit l'interface des traitements du module demande et retourne le au module appelant. */
TypUpsVmShort UpsVmAPI (*LireNumeroModule)(TypUpsVmUnicode *NomModule, 
   enum EnuUpsVtmLireInterface ChargerSiNonExistant);
	/* Objet : Retrouve le numero d'un module. */
TypUpsVmUnicode UpsVmAPI *(*LireNomModule)(TypUpsVmShort NumeroModule, TypUpsVmUnicode *NomModule, TypUpsVmLong TailleNomModule,
   TypUpsVmShort PourUnFichier);
	/* Retrouve le nom d'un module. */
TypUpsVmUnicode UpsVmAPI *(*LireNomDuNIemeModule)(TypUpsVmShort NumeroModule, TypUpsVmUnicode *NomModule, TypUpsVmLong TailleNomModule, 
   TypUpsVmShort *Version, TypUpsVmShort *Revision, TypUpsVmShort *Correction);
	/* Objet : Retrouve le nom du iem module. */
TypUpsVmShort UpsVmAPI (*AjouterModule)(TypUpsVmUnicode *NomModule, TypUpsVmShort EnvoyerErreur,
   enum EnuUpsVtmLireInterface TypeModule);
	/* Objet : Ajoute un module dynamique. */
TypUpsVmShort UpsVmAPI (*InitialiserApresUpsMat)(TypUpsVmVoid);
   /* Objet : Initialisation le composant apres UpsMat. */
TypUpsVmShort UpsVmAPI (*ChangerLangue)(TypUpsVmSession *Session, TypUpsVmUnicode *Langue);
   /* Objet : Change de langue. */
} *TypUpsNlsTraitements_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsNlsTraitements_1_1_0 TypUpsNlsTraitements;

extern DllExport TypUpsVtmDemarrer UpsVmAPI UpsNlsDemarrerModule(TypUpsVmShort Numero, TypUpsVtmMachineInterface MachineInterfaceUpsVtm,
   TypUpsVtmTraitements IntTrtUpsVtm, TypUpsVtmDonnees IntDonUpsVtm);
   /* Objet : Retourne la description de Ups Nls. */

/**********************/
#if defined(__cplusplus)
/**********************/
}
/****/
#endif
/****/

/****/
#endif
/****/
