/*-------------------------------------------------------------------
Fichier     : upsnet.e
Objet       : En-tete du module Up ! Network.

Module      : Up ! Network
Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.
---------------------------------------------------------------------
                         Observations

 
---------------------------------------------------------------------*/

/*****************************/
#if !defined(PasseModuleUpsNet)
/*****************************/
#define PasseModuleUpsNet 1

/**********************/
#if defined(__cplusplus)
/**********************/
extern "C"
{
/****/
#endif
/****/

typedef struct typupsnetmethodescanal_1_1_0  *TypUpsNetMethodesCanal_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsNetMethodesCanal_1_1_0 TypUpsNetMethodesCanal;

/****************************************************************/
typedef struct typupsnetcanal
/* Objet: Informations generiques pour la communication selon   */
/* un protocole support.                                       */
/****************************************************************/
{
TypUpsVmFlux Descripteur;
   /* Descripteur du flux qui est associe. */
TypUpsVmUnicode NomProtocole[CO_TailleIdf+1];
   /* Nom du protocole. */
TypUpsVmUnicode Adresse[CO_TailleNomFichier+1];
   /* Adresse complete du canal sans le protocole. */
TypUpsVmShort BloquerCommunication;
   /* Si Vrai, il faut bloquer la communication. */
TypUpsVmShort NumeroExtension;
   /* Numero de l'extension selon le pilote. */
TypUpsNetMethodesCanal Methodes;
   /* Methodes de bas niveau de gestion du canal. */
} TypUpsNetCanal;

/****************************************************************/
struct typupsnetmethodescanal_1_1_0
/* Objet: Definiton des methodes d'un canal.                    */
/****************************************************************/
{
struct typupsvmmethodesflux_1_1_0 MethodesFlux;
   /* Methodes du flux. */
TypUpsVmVoid UpsVmAPI (*CalculerPlusPetitCanal)(TypUpsVmSession *Session, TypUpsNetCanal *CanalUtilise, TypUpsNetCanal *CanalLibre);
   /* Objet : Compare les parametres du canal pour trouver un canal non utilise. */
TypUpsVmShort UpsVmAPI (*CanauxEgaux)(TypUpsVmSession *Session, TypUpsNetCanal *Canal1, TypUpsNetCanal *Canal2);
   /* Objet : Retourne Vrai si les caracteristiques des canaux sont identiques. */
TypUpsVmShort UpsVmAPI (*Copier)(TypUpsVmSession *Session, TypUpsNetCanal *Canal1, TypUpsNetCanal *Canal2);
   /* Objet : Copie les informations du canal. */
TypUpsVmVoid UpsVmAPI (*FormaterParametres)(TypUpsVmSession *Session, TypUpsNetCanal *Canal, TypUpsVmUnicode *Arguments, TypUpsVmLong TailleArguments);
   /* Objet : Formate les parametres du canal. */
TypUpsVmVoid UpsVmAPI (*RecupererInformationsSession)(TypUpsVmSession *Session, TypUpsNetCanal *Canal1, TypUpsNetCanal *Canal2);
   /* Objet : Recupere les informations de session du client. */
TypUpsVmShort UpsVmAPI (*Decoder)(TypUpsVmSession *Session, TypUpsNetCanal *Canal);
   /* Objet : Decode les champs entiers du canal. */
TypUpsVmVoid UpsVmAPI (*EnregistrerParametres)(TypUpsVmSession *Session, TypUpsNetCanal *Canal, TypUpsVmFlux *Descripteur);
   /* Objet : Enregistre les parametres du noeud. */
TypUpsVmShort UpsVmAPI (*EcouterClients)(TypUpsVmSession *Session, TypUpsNetCanal *CanalServeur, TypUpsVmShort NbClients);
   /* Objet : Configure le canal pour traiter au plus NbClients. */
TypUpsVmShort UpsVmAPI (*AccepterUnClient)(TypUpsVmSession *Session, TypUpsNetCanal *CanalServeur, TypUpsNetCanal *CanalClient);
   /* Objet : Accepte un nouveau client. */
TypUpsVmShort UpsVmAPI (*Connecter)(TypUpsVmSession *Session, TypUpsNetCanal *CanalClient, TypUpsNetCanal *CanalServeur);
   /* Objet : Connexion a un serveur. */
TypUpsVmVoid UpsVmAPI (*Detruire)(TypUpsVmSession *Session, TypUpsNetCanal *Canal);
   /* Objet : Detruit le canal. */
TypUpsVmShort UpsVmAPI (*Exporter)(TypUpsVmSession *Session, TypUpsNetCanal *Canal, TypUpsVmShort Permuter);
   /* Objet : Exporte le canal de communication. */
TypUpsVmShort UpsVmAPI (*Importer)(TypUpsVmSession *Session, TypUpsNetCanal *Canal);
   /* Objet : Importe le canal de communication. */
};

/****************************************************************/
/* Codification du protocole Ups Net.                           */
/****************************************************************/
enum EnuUpsNetCodeProtocole
   {
   KN_Reponse=0,

   KN_MonterSegment=1,
   KN_AllouerSegmentMobile=2,
   KN_MettreSegmentDansBlocsLibres=3,
   KN_AllouerCache=4,
   KN_LibererCache=5,

   KN_OuvrirSession=10,
   KN_FermerSession=11,
   KN_Connecter=12,
   KN_Deconnecter=13,
   KN_ArretServeur=14,
   KN_UtiliserObjet=15,
   KN_NePlusUtiliserObjet=16,
   KN_LibererObjet=17,
   KN_RetasserType=18,
   KN_RechercherAdresse=19,
   KN_LibererVerrou=20,
   KN_RechercherImageAvant=21,
   KN_AllouerTransaction=22,
   KN_ConserverImageAvant=23,
   KN_TenterDeValiderTransaction=24,
   KN_ValiderTransaction=25,
   KN_InvaliderTransaction=26,
   KN_VerrouillerTransaction=27,
   KN_DeverrouillerTransaction=28,
   KN_Photographier=29,

   KN_LireConfiguration=50,
   KN_AjouterNoeud=51,
   KN_SupprimerNoeud=52,
   KN_DemarrerNoeud=53,
   KN_ArreterNoeud=54,
   KN_AjouterServeur=55,
   KN_SupprimerServeur=56,
   KN_StatistiquesServeur=57,
   KN_AjouterModule=58,
   KN_SupprimerModule=59,
   KN_ChercherModule=60,
   KN_ChercherServeur=61,
   KN_PrendreJetonLicence=62,
   KN_LacherJetonLicence=63,

   KN_ProcedureSansParametre=100,
   KN_ProcedureAvecParametre=101,
   KN_FonctionEnumereCourtSansParametre=102,
   KN_FonctionEnumereCourtAvecParametre=103,
   KN_FonctionEnumereLongSansParametre=104,
   KN_FonctionEnumereLongAvecParametre=105,
   KN_FonctionEntierSansParametre=106,
   KN_FonctionEntierAvecParametre=107,
   KN_FonctionReelSansParametre=108,
   KN_FonctionReelAvecParametre=109,
   KN_FonctionObjetSansParametre=110,
   KN_FonctionObjetAvecParametre=111,

   KN_MethodeSansParametre=120,
   KN_MethodeAvecParametre=121,
   KN_MethodeEnumereCourtSansParametre=122,
   KN_MethodeEnumereCourtAvecParametre=123,
   KN_MethodeEnumereLongSansParametre=124,
   KN_MethodeEnumereLongAvecParametre=125,
   KN_MethodeEntierSansParametre=126,
   KN_MethodeEntierAvecParametre=127,
   KN_MethodeReelSansParametre=128,
   KN_MethodeReelAvecParametre=129,
   KN_MethodeObjetSansParametre=130,
   KN_MethodeObjetAvecParametre=131,

   KN_ConstructeurSansParametre=140,
   KN_ConstructeurAvecParametre=141,
   KN_Destructeur=142,
   KN_MethodeAffecter=143,
   KN_MethodeEgal=144,
   KN_MethodeDifferent=145,
   KN_MethodeCloner=146,
   KN_MethodeExporter=147,
   KN_MethodeImporter=148,
   KN_MethodeLirePropriete=149,
   KN_MethodeEcrirePropriete=150,
   KN_MethodeIncrementerDecrementerPropriete=151,
   KN_MethodeSupprimerPropriete=152,
   KN_MethodeEnumererProprietes=153,
   KN_MethodeEnumererMethodes=154,
   KN_MethodeAllouerRessource=155,
   KN_MethodeLibererRessource=156,

   KN_MethodeAffecterTypeParametre=170,
   KN_MethodeEgalTypeParametre=171,
   KN_MethodeDifferentTypeParametre=172,
   KN_MethodeContrainte=173,
   KN_Exporter=174,
   KN_Importer=175,
   KN_RemettreDansImport=176,

   KN_LireAdresseType=180,
   KN_LireAdresseException=181,
   KN_LireAdresseEntrepot=182,
   KN_LireAdresseFile=183,
   KN_LireAdresseModule=184,
   KN_LireVariable=185,
   KN_EcrireVariable=186,
   KN_LireInstanceDe=187,
   KN_IncrementerDecrementerVariable=188,
   KN_DetruireChampObjet=189,
   KN_LireEnteteMethodes=191,
   KN_LireTableParametres=192,
   KN_LireNomModuleNomType=193,

   KN_ExtraireEnumereCourt=200,
   KN_ExtraireEnumereLong=201,
   KN_ExtraireEntier=202,
   KN_ExtraireReel=203,
   KN_ExtraireEtLibererEnumere=204,

   KN_LireEntreeAnnuaireGlobal=210,
   KN_EcrireEntreeAnnuaireGlobal=211,
   KN_SupprimerEntreeAnnuaireGlobal=212,
   KN_RenommerEntreeAnnuaireGlobal=213,
   KN_LireArborescenceAnnuaireGlobal=214,
   KN_TransfererObjet=215,

   KN_Exception=1000
   };

/****************************************************************/
typedef struct typupsnetprotocoleupsnet
/* Objet: Description du protocole Ups Net.                     */
/****************************************************************/
{
TypUpsVmUnsignedChar EstBigEndian;
   /* Si Vrai, la plate-forme fonctionne en Big Endian. */  
TypUpsVmUnsignedChar NbBits;
   /* 16, 32 ou 64 bits. */  
TypUpsVmUnsignedChar PageDeCode;
   /* Page de code du systeme exploitation. */  
TypUpsVmShort Version;
   /* Version du protocole. */
TypUpsVmShort Revision;
   /* Version du protocole. */
TypUpsVmShort Correction;
   /* Version du protocole. */
TypUpsVmUnsignedShort NumeroServeur;
   /* Numero du serveur emetteur. */
enum EnuUpsNetCodeProtocole Token;
   /* Token pour connaitre la nature du message. */
union
   {
   struct
      {
      TypUpsVmShort EstUnObjetAppel;
         /* Si Vrai, il s'agit d'un objet appel. */
      union
         {
         struct 
            {
            TypUpsVmUnicode NomModule[CO_TailleIdf+1];
               /* Nom du module auquel appartient l'appel. */
            TypUpsVmShort Version;
               /* Version du module. */
            TypUpsVmShort Revision;
               /* Revision du module. */
            TypUpsVmShort Correction;
               /* Correction du module. */
            TypUpsVmLong IndexAppel;
               /* Index de la methode dans l'interface public du module. */
            TypUpsVmLong IndexCoAppel;
               /* Index de la co-methode dans l'interface public du module. */
            } Appel;
            /* Pour un appel. */
         TypUpsVmAdresse AdresseObjetAppel;
            /* Pour un objet appel. */
         } Selection;
      } Appel;
      /* KN_Procedure, KN_Fonction, KN_LireTableParametres. */
   struct
      {
      TypUpsVmUnicode NomModule[CO_TailleIdf+1];
         /* Nom du module auquel appartient l'appel. */
      TypUpsVmShort Version;
         /* Version du module. */
      TypUpsVmShort Revision;
         /* Revision du module. */
      TypUpsVmShort Correction;
         /* Correction du module. */
      TypUpsVmUnicode NomType[CO_TailleIdf+1];
         /* Nom du du type. */
      TypUpsVmLong IndexAppel;
         /* Index de la methode dans la table des methodes. */
      TypUpsVmLong IndexCoAppel;
         /* Index de la co-methode dans la table des methodes. */
      TypUpsVmAdresse AdresseObjet;
         /* Adresse de l'objet s'il faut appliquer une methode. */
      } Methode;
      /* KN_Methode. */
      /* KN_ConstructeurSansParametre, KN_ConstructeurAvecParametre, KN_Destructeur, */
      /* KN_MethodeEgal, KN_MethodeDifferent, KN_MethodeAffecter, KN_MethodeCloner. */
   struct
      {
      TypUpsVmLong DateDernierTransfert;
         /* Date du dernier transfert calee sur l'horloge du serveur. */
      TypUpsVmAdresse AdresseObjet;
         /* Adresse a rechercher. */
      TypUpsVmLong PremierOctet;
         /* Pour un verrouillage par plage, debut de la plage. */
      TypUpsVmLong NbOctets;
         /* Pour un verrouillage par plage, nombre d'octets de la plage. */
      TypUpsVmShort TypeVerrou;
         /* Type de verrou. */
      TypUpsVmShort Bloquer;
         /* Si Vrai, il faut bloquer tant que le verrou n'est pas pose. */
      TypUpsVmLong Cache;
         /* Cache dans lequel est le bloc. */
      TypUpsVmShort IndexSegment;
         /* Index du bloc du segment dans le cache. */
      TypUpsVmUnsignedShort NumeroNoeudClient;
         /* Numero du noeud client. */
      TypUpsVmUnsignedShort NumeroServeurClient;
         /* Numero du serveur client. */
      TypUpsVmUnsignedShort NumeroSessionClient;
         /* Numero de la session cliente. */
      TypUpsVmAdresse AdresseObjetTransaction;
         /* Adresse de l'objet transaction pour un objet transactionnel. */ 
      } Adresse;
      /* KN_RechercherAdresse. */
   struct
      {
      TypUpsVmUnsignedShort NumeroEntrepot;
         /* Numero de l'entrepot. */
      TypUpsVmUnsignedLong NumeroVerrou;
         /* Numero du verrou liberer. */
      TypUpsVmLong Cache;
         /* Cache dans lequel est le bloc. */
      TypUpsVmShort Index;
         /* Index du bloc dans le cache. */
      TypUpsVmShort EstModifie;
         /* Si Vrai, la portion de memoire verrouillee a ete modifiee. */
      TypUpsVmShort ImplementationSeulement;
         /* Si Vrai, il faut seulement liberer la partie implementation. */
      TypUpsVmShort AlimenterEnregistrementJournal;
         /* Si Vrai, il faut enregistrer les modifications dans le journal. */
      } Verrou;
      /* KN_LibererVerrou. */
   struct
      {
      TypUpsVmUnicode NomModule[CO_TailleIdf+1];
         /* Nom du module auquel appartient l'objet. */
      TypUpsVmShort Version;
         /* Version du module. */
      TypUpsVmShort Revision;
         /* Revision du module. */
      TypUpsVmShort Correction;
         /* Correction du module. */
      TypUpsVmUnicode NomObjet[CO_TailleIdf+1];
         /* Nom de l'objet. */
      TypUpsVmChar UtiliserObjet;
         /* Si Vrai, il faut utiliser l'objet. */
      } Objet;
      /* KN_LireAdresseType, KN_LireAdresseException, KN_LireAdresseEntrepot, */
      /* KN_LireAdresseFile, KN_LireAdresseModule. */
   struct
      {
      TypUpsVmShort EstUnObjetVariable;
         /* Si Vrai, il s'agit d'un objet variable. */
      union
         {
         struct 
            {
            TypUpsVmUnicode NomModule[CO_TailleIdf+1];
               /* Nom du module auquel appartient la variable. */
            TypUpsVmShort Version;
               /* Version du module. */
            TypUpsVmShort Revision;
               /* Revision du module. */
            TypUpsVmShort Correction;
               /* Correction du module. */
            TypUpsVmUnicode NomVariable[CO_TailleIdf+1];
               /* Nom de la variable. */
            } Variable;
            /* Pour une variable. */
         TypUpsVmAdresse AdresseObjetVariable;
            /* Pour un objet variable. */
         } Selection;
      enum EnuUpsVmTypeDeDonnee TypeDeDonnees;
         /* Type de la donnee. */
      TypUpsVmChar Incrementer;
         /* Si Vrai, il faut incrementer la variable, sinon la decrementer. */
      TypUpsVmChar Prefixe;
         /* Si Vrai, l'operateur est prefixe, sinon postfixe. */
      enum EnuUpsVmOperateur Operateur;
         /* Operateur pour composer la valeur de la variable. */
      TypUpsVmShort NbSelections;
         /* Nombre de selections passees en complement. */
      TypUpsVmLong IndexAppel;
         /* Index de la methode dans la table des methodes. */
      TypUpsVmLong IndexCoAppel;
         /* Index de la co-methode dans la table des methodes. */
      TypUpsVmShort UtiliserObjet;
         /* Si Vrai, il faut utiliser l'objet en resultat. */
      } Variable;
      /* KN_LireVariable, KN_EcrireVariable, KN_IncrementerDecrementerVariable. */
   struct
      {
      TypUpsVmUnsignedShort NumeroEntrepot; 
         /* Numero de l'entrepot. */ 
      TypUpsVmAdresse AdresseObjetType;
         /* Adresse de l'objet du type a retasser. */
      } RetasserType;
      /* KN_RetasserType. */
   struct
      {
      TypUpsVmUnicode NomNoeud[CO_TailleIdf+1];
         /* Nom du noeud. */
      TypUpsVmUnsignedShort NumeroNoeud;
         /* Numero du noeud. */
      TypUpsNetCanal Canal;
         /* Canal de communication avec Ups Orb. */
      TypUpsVmUnsignedShort NumeroDernierNoeud;
         /* Numero du dernier noeud. */
      } Noeud;
      /* KN_AjouterNoeud, KN_SupprimerNoeud, KN_DemarrerNoeud, KN_ArreterNoeud. */
   struct
      {
      TypUpsVmUnicode NomNoeud[CO_TailleIdf+1];
         /* Nom du noeud. */
      TypUpsVmUnsignedShort NumeroNoeud;
         /* Numero du noeud. */
      TypUpsVmUnicode NomServeur[CO_TailleIdf+1];
         /* Nom du serveur. */
      TypUpsVmUnsignedShort NumeroServeur;
         /* Numero du serveur. */
      TypUpsNetCanal Canal;
         /* Protocole de communication avec Ups Orb. */
      TypUpsVmShort NbTaches;
         /* Nombre de taches dediees au service des modules. */
      } Serveur;
      /* KN_AjouterServeur, KN_SupprimerServeur. */
   struct
      {
      TypUpsVmUnicode NomNoeud[CO_TailleIdf+1];
         /* Nom du noeud. */
      TypUpsVmUnsignedShort NumeroNoeud;
         /* Numero du noeud. */
      TypUpsVmUnicode NomServeur[CO_TailleIdf+1];
         /* Nom du serveur. */
      TypUpsVmUnsignedShort NumeroServeur;
         /* Numero du serveur. */
      TypUpsNetCanal Canal;
         /* Canal de communication avec Ups Orb. */
      TypUpsVmUnicode NomModule[CO_TailleIdf+1];
         /* Nom du module. */
      TypUpsVmShort Version;
         /* Version du module. */
      TypUpsVmShort Revision;
         /* Revision du module. */
      TypUpsVmShort Correction;
         /* Correction du module. */
      TypUpsVmUnsignedChar EstBigEndian;
         /* Si Vrai, la plate-forme fonctionne en Big Endian. */  
      TypUpsVmUnsignedChar NbBits;
         /* 16, 32 ou 64 bits. */  
      TypUpsVmUnsignedChar PageDeCode;
         /* Page de code du systeme exploitation. */  
      } Module;
      /* KN_AjouterModule, KN_SupprimerModule, KN_ChercherModule, KN_ChercherServeur. */
   struct
      {
      TypUpsVmUnicode NomNoeud[CO_TailleIdf+1];
	      /* Nom du noeud. */
      TypUpsVmUnicode NomServeur[CO_TailleIdf+1];
	      /* Nom du serveur. */
      TypUpsVmUnicode NomModule[CO_TailleIdf+1];
	      /* Nom du module. */
      TypUpsVmShort Version;
         /* Version du module. */
      TypUpsVmShort Revision;
         /* Revision du module. */
      TypUpsVmShort Correction;
         /* Correction du module. */
      TypUpsVmShort NbChargements;
	      /* Nombre de chargements du module. */
      TypUpsVmShort SorteLicence;
         /* Sorte de la licence. */
      } Licence;
         /* KN_PrendreJetonLicence, KN_LacherJetonLicence. */
   struct
      {
      TypUpsVmUnicode NomNoeud[CO_TailleIdf+1];
         /* Nom du noeud. */
      TypUpsVmUnsignedShort NumeroNoeud;
         /* Numero du noeud. */
      TypUpsVmUnicode NomServeur[CO_TailleIdf+1];
         /* Nom du serveur. */
      TypUpsVmUnsignedShort NumeroServeur;
         /* Numero du serveur. */
      TypUpsVmUnsignedLong NbSecondesTravaillees;
         /* Nombre de secondes travaillees. */
      TypUpsVmUnsignedLong NbSecondesTravailleesAuTotal;
         /* Nombre de secondes travaillees au total. */
      TypUpsVmUnsignedLong NbSoumissions;
         /* Nombre de soumissions depuis la derniere statistique. */
      TypUpsVmUnsignedLong NbSoumissionsAuTotal;
         /* Nombre de soumissions depuis le lancement du serveur. */
      TypUpsVmDouble PourcentageUtilisation;
         /* Pourcentage d'utilisation. */
      } Statistiques;
      /* KN_StatistiquesServeur */
   struct
      {
      TypUpsVmUnsignedShort NumeroEntrepot;
         /* Numero de l'entrepot. */
      TypUpsVmAdresse Objet;
         /* Objet pour lequel il faut monter le segment. */
      TypUpsVmLong PremierOctet;
         /* Premier octet a verrouiller. */
      TypUpsVmLong NbOctets;
         /* Nombre d'octets a verrouiller. */
      TypUpsVmUnsignedLong NumeroVerrou;
         /* Numero du verrou pose une fois le segment monte. */
      TypUpsVmShort TypeVerrou;  
         /* Type de verrou a poser sur les octets. */
      TypUpsVmShort Bloquer;
         /* Si Vrai, il faut bloquer si la ressource n'est pas disponible. */
      TypUpsVmLong NumeroBlocElu;
         /* Numero du bloc memoire dans lequel est le segment une fois monte. */
      } MonterSegment;
      /* KN_MonterSegment. */
   struct
      {
      TypUpsVmUnsignedShort NumeroEntrepot;
         /* Numero de l'entrepot. */
      TypUpsVmAdresse ObjetType;
         /* Objet type pour lequel faut monter allouer le segment. */
      TypUpsVmUnsignedLong NumeroVerrou;
         /* Numero du verrou pose une fois le segment monte. */
      TypUpsVmShort Verrouiller;  
         /* Si Vrai, il faut verrouiller. */
      TypUpsVmLong NumeroBlocElu;
         /* Numero du bloc memoire dans lequel est le segment une fois monte. */
      } AllouerSegmentMobile;
      /* KN_AllouerSegmentMobile. */
   struct
      {
      TypUpsVmUnsignedShort NumeroEntrepot;
         /* Numero de l'entrepot. */
      TypUpsVmLong NumeroBloc;
         /* Numero du bloc. */
      TypUpsVmShort Verrouiller;  
         /* Si Vrai, il faut verrouiller. */
      } MettreSegmentDansBlocsLibres;
      /* KN_MettreSegmentDansBlocsLibres. */
   struct
      {
      TypUpsVmUnsignedShort NumeroEntrepot;
         /* Numero de l'entrepot. */
      TypUpsVmLong NumeroCache;
         /* Numero du cache. */
      } Cache;
      /* KN_AllouerCache, KN_LibererCache. */
   struct
      {
      TypUpsVmUnicode NomClient[CO_TailleIdf+1];
         /* Nom du client. */
      TypUpsVmUnsignedShort NumeroNoeud;
         /* Numero du noeud. */
      TypUpsVmUnsignedShort NumeroServeur;
         /* Numero du serveur. */
      TypUpsVmUnsignedShort NumeroSession;
         /* Numero de la session du client. */
      TypUpsVmUnicode NomServeurSysteme[CO_TailleIdf+1];
         /* Nom du serveur de l'entrepot systeme. */
      TypUpsNetCanal CanalClient;
         /* Canal du client. */
      } Session;
      /* KN_OuvrirSession, KN_FermerSession. */
   struct
      {
      TypUpsVmUnicode Utilisateur[CO_TailleIdf+1];
         /* Utilisateur. */
      TypUpsVmUnicode MotDePasse[CO_TailleIdf+1];
         /* Mot de passe. */
      } Connexion;
      /* KN_Connecter. */
   struct
      {
      TypUpsVmUnsignedShort NumeroSessionClient;
         /* Numero de la session du client. */
      TypUpsVmLong TailleBuffer;
         /* Taille du buffer. */
      } ImportExport;
      /* KN_Exporter, KN_Importer. */
   struct
      {
      TypUpsVmAdresse AdresseObjet;
         /* Adresse de l'objet. */
      TypUpsVmAdresse AdresseObjetP;
         /* Pour un parametre d'un type. */
      TypUpsVmLong Offset;
         /* Offset du champ. */
      } TypeParametre;
      /* KN_AffecterTypeParametre, KN_EgalTypeParametre, KN_DifferentTypeParametre. */
   TypUpsVmAdresse AdresseObjet;
      /* KN_ExtraireEnumereCourt, KN_ExtraireEnumereLong, KN_ExtraireEntier, KN_ExtraireReel. */
      /* KN_LireInstanceDe, KN_ExtraireEtLibererEnumere. */
   struct
      {
      TypUpsVmAdresse AdresseObjetType;
         /* Adresse de l'objet du type. */
	   TypUpsVmLong Entier;
		   /* Pour un entier. */
	   TypUpsVmDouble Reel;
		   /* Pour un reel. */
	   TypUpsVmAdresse AdresseObjet;
		   /* Pour un objet. */
      } Contrainte;
      /* KN_MethodeContrainte. */
    struct
      {
      TypUpsVmUnsignedShort NumeroNoeudClient;
         /* Numero du noeud du serveur client. */
      TypUpsVmUnsignedShort NumeroServeurClient;
         /* Numero du serveur client. */
      TypUpsVmUnsignedShort NumeroSessionClient;
         /* Numero de la session du client. */
      TypUpsVmUnsignedShort NumeroEntrepot; 
         /* Numero de l'entrepot dans laquelle est l'objet. */ 
      TypUpsVmAdresse AdresseObjetImageAvant;
         /* Adresse de l'objet de l'image avant. */
      TypUpsVmAdresse ObjetBufferImageAvant;
         /* Segment dans lequel est alloue le buffer de la table des images avants. */
      TypUpsVmLong IndexBufferImageAvant;
         /* Index de la table des images avants dans le segment. */
      TypUpsVmLong NbBuffersImageAvant;
         /* Nombre d'elements consecutifs occupes par le buffer. */
      TypUpsVmUnsignedLong NumeroVerrouObjet;
         /* Numero du verrou sur l'objet. */
      TypUpsVmAdresse AdresseObjet;
         /* Adresse de l'objet. */
      TypUpsVmAdresse AdresseObjetTransaction;
         /* Adresse de l'objet de la sous-transaction. */
      TypUpsVmLong Cache1;
         /* Cache de rattachement. */
      TypUpsVmShort Index1;
         /* Index du bloc dans le cache. */
      TypUpsVmLong Cache2;
         /* Cache de rattachement. */
      TypUpsVmShort Index2;
         /* Index du bloc dans le cache. */
      TypUpsVmLong DateImageAvant;
         /* Date de l'image avant. */
      TypUpsVmShort DetruireObjet;
         /* Si Vrai, il faut appeler Objet.Destructeur(). */
      } ImageAvant;
      /* KN_RechercherImageAvant, KN_ConserverImageAvant, KN_TenterDeValiderTransaction, */
      /* KN_ValiderTransaction, KN_InvaliderTransaction. */
    struct
      {
      TypUpsVmUnsignedShort NumeroNoeudClient;
         /* Numero du noeud du serveur client. */
      TypUpsVmUnsignedShort NumeroServeurClient;
         /* Numero du serveur client. */
      TypUpsVmUnsignedShort NumeroSessionClient;
         /* Numero de la session du client. */
      } Transaction;
      /* KN_AllouerTransaction, KN_VerrouillerTransaction, KN_DeverrouillerTransaction. */
   struct
      {
      TypUpsVmUnsignedShort NumeroNoeudClient;
         /* Numero du noeud du serveur client. */
      TypUpsVmUnsignedShort NumeroServeurClient;
         /* Numero du serveur client. */
      TypUpsVmUnsignedShort NumeroSessionClient;
         /* Numero de la session du client. */
      TypUpsVmShort Activite;
         /* Si Vrai, il faut prendre une photographie. */
      TypUpsVmLong DatePhotographie;
         /* Date de photographie. */
      TypUpsVmShort Portee;
         /* Portee de la photographie. */
      TypUpsVmShort SensVersOrbMaitre;
         /* Si Vrai, la diffusion de la demande se fait dans le sens vers l'Orb maitre. */
      TypUpsVmAdresse AdresseObjetTache;
         /* Adresse de la tache a l'origine de la photographie. */
      } Photographie;
      /* KN_Photographier. */
   } Origine;
TypUpsVmLong TailleParametres;
   /* Taille de la structure des parametres. */
union
   {
   TypUpsVmValeur Valeur;
      /* Valeur generique. */ 
   TypUpsVmUnicode *MessageErreur;
      /* Pour une exception. */
   TypUpsVmEnteteMethodes *EnteteMethodes;
      /* En-tete de la table des methodes. */
   } Resultat;
   /* Resultat de l'appel ou pour une variable. */
} TypUpsNetProtocoleUpsNet;

/****************************************************************/
/* Type de selection.                                           */
/****************************************************************/
enum EnuUpsNetSelection
   {
   TS_Champ=1,
   TS_Tableau=2
   };

/****************************************************************/
typedef struct typupsnetselection
/* Objet: Description d'une selection pour l'empaquetage des    */
/* parametres.                                                  */
/****************************************************************/
{
enum EnuUpsNetSelection TypeSelection;
   /* Type de selection. */
union
   {
   TypUpsVmLong Offset;
      /* Offset pour un champ. */ 
   TypUpsVmAdresse AdresseObjetIndex;
      /* Index pour un tableau. */
   } Selection;
} TypUpsNetSelection;

/****************************************************************/
typedef struct upstypupsnet_1_1_1_0
/* Objet : Proprietes du type Canal.                            */
/****************************************************************/
{
TypUpsVmAdresse UpsObjet1;
   /* Objet pour le flux; */
TypUpsNetCanal Canal;
   /* Canal pour la tache. */
TypUpsNetCanal CanalClient;
   /* Canal pour la lecture/ecriture quand on a accepte un client. */
TypUpsVmLong Taille;
   /* Taille du buffer du canal. */
TypUpsVmShort PageDeCode;
   /* Page de code. */
} UpsTypUpsNet_1_1_1_0;

typedef struct typprmupssys_12_5_1 TypPrmUpsSys_12_5_1;
typedef struct typprmupssys_12_5_2 TypPrmUpsSys_12_5_2;
typedef struct typprmupssys_12_5_3 TypPrmUpsSys_12_5_3;
typedef struct typprmupssys_12_5_4 TypPrmUpsSys_12_5_4;
typedef struct typprmupssys_12_5_5 TypPrmUpsSys_12_5_5;
typedef struct typprmupssys_12_6_1 TypPrmUpsSys_12_6_1;
typedef struct typprmupssys_12_7_1 TypPrmUpsSys_12_7_1;
typedef struct typprmupssys_12_8_1 TypPrmUpsSys_12_8_1;
typedef struct typprmupssys_12_8_2 TypPrmUpsSys_12_8_2;
typedef struct typprmupssys_12_8_3 TypPrmUpsSys_12_8_3;
typedef struct typprmupssys_12_8_4 TypPrmUpsSys_12_8_4;
typedef struct typprmupssys_12_8_5 TypPrmUpsSys_12_8_5;
typedef struct typprmupssys_12_9_1 TypPrmUpsSys_12_9_1;
typedef struct typprmupssys_12_11_1 TypPrmUpsSys_12_11_1;

typedef struct upstypupssys_12_1_1_0 UpsTypUpsSys_12_1_1_0;
typedef struct upstrttypupssys_12_1_1_0 UpsTrtTypUpsSys_12_1_1_0;

typedef UpsTypUpsSys_12_1_1_0 UpsTypUpsSys_12;
typedef UpsTrtTypUpsSys_12_1_1_0 UpsTrtTypUpsSys_12;

/****************************************************************/
typedef struct typprmupsnet_1_13_1
/* Objet : Parametre de Canal.Adresse(CanalDuClient:            */
/* Booleen=Faux) Retourner Caractere                            */
/****************************************************************/
{
TypUpsVmUnsignedChar UpsVar1;
   /* CanalDuClient : Booleen. */
} TypPrmUpsNet_1_13_1;

/****************************************************************/
typedef struct upstrttypupsnet_1_1_1_0
/* Objet : Methodes du type Canal.                              */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

/*--------------------------------------------------------------*/
/* Methodes heritees de Flux.                                   */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_5_1 *UpsPrm);
   /* Procedure Lire(B:Booleen Sortie); */
TypUpsVmAdresse UpsVmAPI *(*Mth_5_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_5_2 *UpsPrm);
   /* Fonction Lire(C:Binaire Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_5_3)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_5_3 *UpsPrm);
   /* Fonction Lire(C:Caractere Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmVoid UpsVmAPI (*Mth_5_4)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_5_4 *UpsPrm);
   /* Procedure Lire(E:Entier Sortie); */
TypUpsVmVoid UpsVmAPI (*Mth_5_5)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_5_5 *UpsPrm);
   /* Procedure Lire(R:Reel Sortie); */
TypUpsVmAdresse UpsVmAPI *(*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_6_1 *UpsPrm);
   /* Fonction LireUneLigne(C:Nul Ou Caractere Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_7_1 *UpsPrm);
   /* Fonction LireUnMot(C:Nul Ou Caractere Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmVoid UpsVmAPI (*Mth_8_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_8_1 *UpsPrm);
   /* Procedure Ecrire(B:Nul Ou Booleen); */
TypUpsVmVoid UpsVmAPI (*Mth_8_2)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_8_2 *UpsPrm);
   /* Procedure Ecrire(C:Nul Ou Binaire); */
TypUpsVmVoid UpsVmAPI (*Mth_8_3)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_8_3 *UpsPrm);
   /* Procedure Ecrire(C:Nul Ou Caractere); */
TypUpsVmVoid UpsVmAPI (*Mth_8_4)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_8_4 *UpsPrm);
   /* Procedure Ecrire(E:Nul Ou Entier); */
TypUpsVmVoid UpsVmAPI (*Mth_8_5)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_8_5 *UpsPrm);
   /* Procedure Ecrire(R:Nul Ou Reel); */
TypUpsVmVoid UpsVmAPI (*Mth_9_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Procedure Fermer(); */
TypUpsVmUnsignedChar UpsVmAPI (*Mth_10_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Objet : LirePageDeCode() Retourner PagesDeCodesSupportees. */ 
TypUpsVmVoid UpsVmAPI (*Mth_11_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_11_1 *UpsPrm);
   /* Objet : ChangerPageDeCode(P:PagesDeCodesSupportees). */ 
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*Mth_12_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmAdresse *AdresseObjet);
   /* Fonction Protocole() Retourner Caractere; */
TypUpsVmAdresse UpsVmAPI *(*Mth_13_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmAdresse *AdresseObjet, TypPrmUpsNet_1_13_1 *UpsPrm);
   /* Fonction Adresse(CanalDuClient:Booleen=Faux) Retourner Caractere; */

/*--------------------------------------------------------------*/
/* Methodes heritees de Flux.                                   */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_5_1;
   /* Procedure Lire(B:Booleen Sortie); */
TypUpsVmCoAppel CoMth_5_2;
   /* Fonction Lire(C:Binaire Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_5_3;
   /* Fonction Lire(C:Caractere Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_5_4;
   /* Procedure Lire(E:Entier Sortie); */
TypUpsVmCoAppel CoMth_5_5;
   /* Procedure Lire(R:Reel Sortie); */
TypUpsVmCoAppel CoMth_6_1;
   /* Fonction LireUneLigne(C:Nul Ou Caractere Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_7_1;
   /* Fonction LireUnMot(C:Nul Ou Caractere Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_8_1;
   /* Procedure Ecrire(B:Nul Ou Booleen); */
TypUpsVmCoAppel CoMth_8_2;
   /* Procedure Ecrire(C:Nul Ou Binaire); */
TypUpsVmCoAppel CoMth_8_3;
   /* Procedure Ecrire(C:Nul Ou Caractere); */
TypUpsVmCoAppel CoMth_8_4;
   /* Procedure Ecrire(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_8_5;
   /* Procedure Ecrire(R:Nul Ou Reel); */
TypUpsVmCoAppel CoMth_9_1;
   /* Procedure Fermer(); */
TypUpsVmCoAppel CoMth_10_1;
   /* Objet : LirePageDeCode() Retourner PagesDeCodesSupportees. */ 
TypUpsVmCoAppel CoMth_11_1;
   /* Objet : ChangerPageDeCode(P:PagesDeCodesSupportees). */ 
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_12_1;
   /* Fonction Protocole() Retourner Caractere; */
TypUpsVmCoAppel CoMth_13_1;
   /* Fonction Adresse(CanalDuClient:Booleen=Faux) Retourner Caractere; */
} UpsTrtTypUpsNet_1_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsNet_1_1_1_0 UpsTypUpsNet_1;
typedef UpsTrtTypUpsNet_1_1_1_0 UpsTrtTypUpsNet_1;

/****************************************************************/
typedef struct upstypupsnet_2_1_1_0
/* Objet : Proprietes d'un Serveur.                             */
/****************************************************************/
{
TypUpsVmAdresse UpsChamp1;
   /* NomServeur : Caractere. */
TypUpsVmAdresse UpsChamp2;
   /* NomNoeud : Caractere. */
TypUpsVmAdresse UpsChamp3;
   /* AdresseDuServeur : Caractere. */
TypUpsVmEnteteMethodesModule EnteteMethodesModule;
   /* Pour retrouver l'entete du module. */
/******************************/
#if defined(PLATEFORME32DONNEES)
/******************************/
TypUpsVmPointeurDonnees TrouAdresse;
   /* Pour la compatibilite 64 bits. */
/****/
#endif
/****/
TypUpsVmUnsignedChar EstBigEndian;
   /* Si Vrai, la plate-forme fonctionne en Big Endian. */  
TypUpsVmUnsignedChar NbBits;
   /* 16, 32 ou 64 bits. */  
TypUpsVmUnsignedChar PageDeCode;
   /* Page de code du systeme exploitation. */  
TypUpsVmUnsignedShort NumeroNoeud;
   /* Numero du noeud sur lequel est le serveur. */
TypUpsVmUnsignedShort NumeroServeur;
   /* Numero du serveur. */
TypUpsNetCanal Canal;
   /* Pour communiquer avec le serveur. */
TypUpsVmUnicode NomModule[CO_TailleIdf+1];
   /* Nom du module. */
TypUpsVmShort Version;
   /* Version du module. */
TypUpsVmShort Revision;
   /* Revision du module. */
TypUpsVmShort Correction;
   /* Correction du module. */
} UpsTypUpsNet_2_1_1_0;

/****************************************************************/
typedef struct typprmupsnet_2_4_1
/* Objet : Parametre de Constructeur(NomDuModule:Caractere,     */
/* Version : Entier, Revision : Entier, Correction : Entier,    */
/* NomDuNoeud:Nul Ou Caractere=Nul, NomDuServeur:Nul Ou         */
/* Caractere=Nul);                                              */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomModule:Caractere; */
TypUpsVmLong UpsVar2;
   /* VersionDuModule : Entier; */
TypUpsVmLong UpsVar3;
   /* RevisionDuModule : Entier; */
TypUpsVmLong UpsVar4;
   /* CorrectionDuModule : Entier; */
TypUpsVmAdresse UpsVar5;
   /* NomNoeud:Nul Ou Caractere; */
TypUpsVmAdresse UpsVar6;
   /* NomServeur:Nul Ou Caractere; */
} TypPrmUpsNet_2_4_1;

/****************************************************************/
typedef struct upstrttypupsnet_2_1_1_0
/* Objet : Methodes du type Serveur.                            */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmAdresse UpsVmAPI *(*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsNet_2_4_1 *UpsPrm);
   /* Constructeur(NomDuModule:Caractere, NomDuNoeud:Nul Ou Caractere=Nul,
      NomDuServeur:Nul Ou Caractere=Nul); */

TypUpsVmCoAppel CoMth_4_1;
   /* Constructeur(NomDuModule:Caractere, NomDuNoeud:Nul Ou Caractere=Nul,
      NomDuServeur:Nul Ou Caractere=Nul, AdresseDuServeur:Caractere=Nul); */
} UpsTrtTypUpsNet_2_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsNet_2_1_1_0 UpsTypUpsNet_2;
typedef UpsTrtTypUpsNet_2_1_1_0 UpsTrtTypUpsNet_2;

/****************************************************************/
typedef struct typupsnetxdonnees
/* Objet: Interface des donnees d'un pilote de reseau.          */
/****************************************************************/
{
TypUpsVmDonneesOption EnteteOption;
   /* EnteteGenerique. */
TypUpsNetCanal CanalMachine;
   /* Canal de communication avec la machine. */
} *TypUpsNetXDonnees;

/****************************************************************/
typedef struct typupsnetxtraitements_1_1_0
/* Objet: Interface des traitements d'un pilote de reseau.      */
/****************************************************************/
{
TypUpsVmTraitementsOption EnteteOption;
   /* Entete generique. */
TypUpsVmShort UpsVmAPI (*Initialiser)(TypUpsVmSession *Session);
   /* Objet : Initialise le pilote avant Ups Krn. */
TypUpsVmShort UpsVmAPI (*InitialiserEncapsulationKernel)(TypUpsVmSession *Session);
   /* Objet : Initialise le pilote apres Ups Krn. */
TypUpsVmVoid UpsVmAPI (*TerminerEncapsulationKernel)(TypUpsVmSession *Session);
   /* Objet : Termine le pilote avant Ups Krn. */
TypUpsNetMethodesCanal (*LireTableMethodes)(TypUpsVmSession *Session);
   /* Objet : Lit la table des methodes d'un canal. */
TypUpsVmVoid UpsVmAPI (*InitialiserCanal)(TypUpsVmSession *Session, TypUpsNetCanal *Canal);
   /* Objet : Initialise le canal. */
TypUpsVmVoid UpsVmAPI (*InitialiserCanalScrutateur)(TypUpsVmSession *Session, TypUpsNetCanal *Canal);
   /* Objet : Initialise le canal pour le scrutateur. */
TypUpsVmVoid UpsVmAPI (*InitialiserCanalOrbLocal)(TypUpsVmSession *Session, TypUpsNetCanal *Canal);
   /* Objet : Initialise le canal pour l'Orb local. */
TypUpsVmVoid UpsVmAPI (*InitialiserCanalClient)(TypUpsVmSession *Session, TypUpsNetCanal *CanalClient);
   /* Objet : Initialise le canal pour un client accepte par le scrutateur. */
TypUpsVmVoid UpsVmAPI (*InitialiserCanalEnLocal)(TypUpsVmSession *Session, TypUpsNetCanal *Canal);
   /* Objet : Initialise le canal pour travailler en local. */
TypUpsVmShort (*EstEnLocal)(TypUpsVmSession *Session);
   /* Objet : Retourne Vrai si le serveur fonctionne en local. */
TypUpsVmShort UpsVmAPI (*LireParametresCanal)(TypUpsVmSession *Session, TypUpsNetCanal *Canal, TypUpsVmUnicode *Profil, TypUpsVmUnicode *Section);
   /* Objet : Lit les parametres du canal. */
TypUpsVmVoid UpsVmAPI (*EnregistrerParametresCanalOrb)(TypUpsVmSession *Session, TypUpsVmFlux *Descripteur);
   /* Objet : Enregistre les parametres de Ups Orb. */
} *TypUpsNetXTraitements_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsNetXTraitements_1_1_0 TypUpsNetXTraitements;

/****************************************************************/
typedef struct typupsnetdonnees
/* Objet: Interface des donnees publiques de Ups Net.           */
/****************************************************************/
{
struct typupsvmentetedonneesmodule EnteteDonneesModule;
   /* Entete generique du module. */

TypUpsVmLong TempsDeGarde;
   /* Temps de garde maximal en secondes pour une communication. */
TypUpsVmLong LatenceServeur;
   /* Temps d'inactivite a partir duquel un serveur inactif est arrete. */
TypUpsVmUnsignedShort NbServeurs;
   /* Nombre de serveurs pour les acces distants. */
TypUpsVmUnsignedShort NbClients;
   /* Nombre de clients pour les acces distants. */
TypUpsVmShort ScrutateurNonDemarre;
   /* Si Vrai, le scrutateur n'a pas encore demarre. */
/*--------------------------------------------------------------*/
/* Libelle des APIs frequentes dans la langue courante.         */
/*--------------------------------------------------------------*/
TypUpsVmUnicode *ICanal;
   /* Libelle de ICanal. */
TypUpsVmUnicode *Serveur;
   /* Libelle de Serveur. */
} *TypUpsNetDonnees;

/****************************************************************/
typedef struct typupsnettraitements_1_1_0
/* Objet: Interface des traitements de Ups Net.                 */
/****************************************************************/
{
struct typupsvmentetemethodesmodule EnteteMethodesModule;
   /* Methodes generiques au module. */ 

/*--------------------------------------------------------------*/
/* Procedures et fonctions.                                     */
/*--------------------------------------------------------------*/
TypUpsVmLong UpsVmAPI (*CalculerIndexAppel)(TypUpsVmPointeurDonnees InterfaceAppel, TypUpsVmPointeurDonnees AppelCourant);
   /* Objet : Calcule l'index de l'appel. */

/*--------------------------------------------------------------*/
/* Tables des methodes.                                         */
/*--------------------------------------------------------------*/
UpsTrtTypUpsNet_1 *UpsTrt1;
   /* Methodes de Canal. */ 
UpsTrtTypUpsSys_12 *UpsTrt1_1;
   /* Methodes de Canal.Flux. */ 
UpsTrtTypUpsNet_2 *UpsTrt2;
   /* Methodes de Serveur. */ 

/*--------------------------------------------------------------*/
/* Enumeres.			              				                   */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Entrepots.          								                   */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Types et interfaces.                                         */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*UpsType1_get)(TypUpsVmSession *Session);
   /* Type Canal. */
TypUpsVmLong UpsVmAPI (*UpsIndex1_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Canal. */ 
TypUpsVmAdresse UpsVmAPI *(*UpsType2_get)(TypUpsVmSession *Session);
   /* Type Serveur. */
TypUpsVmLong UpsVmAPI (*UpsIndex2_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Serveur. */ 

/*--------------------------------------------------------------*/
/* Variables globales.                                          */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*UpsVar1_get)(TypUpsVmSession *Session);
   /* ServeurLocal. */

/*--------------------------------------------------------------*/
/* Exceptions.                                                  */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*UpsException1_get)(TypUpsVmSession *Session);
   /* PiloteReseauInconnu. */
TypUpsVmAdresse UpsVmAPI *(*UpsException2_get)(TypUpsVmSession *Session);
   /* Exception CreationCanalImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException3_get)(TypUpsVmSession *Session);
   /* Exception TropDeClients. */
TypUpsVmAdresse UpsVmAPI *(*UpsException4_get)(TypUpsVmSession *Session);
   /* Exception ChangementNbClientsImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException5_get)(TypUpsVmSession *Session);
   /* Exception AccepterImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException6_get)(TypUpsVmSession *Session);
   /* Exception ConnexionCanalImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException7_get)(TypUpsVmSession *Session);
   /* Exception CommunicationImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException8_get)(TypUpsVmSession *Session);
   /* Exception ServeurInconnu. */
TypUpsVmAdresse UpsVmAPI *(*UpsException9_get)(TypUpsVmSession *Session);
   /* Exception VersionProtocoleNonSupportee. */

/*--------------------------------------------------------------*/
/* Files d'attente.                                             */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Application Program Interfaces proprietaires.                */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*ReferencerExtension)(TypUpsVmUnicode *NomOption, TypUpsNetXDonnees IntDon, TypUpsNetXTraitements IntTrt);
   /* Objet : Reference une extension ne correspondant pas a une option. */
TypUpsVmVoid UpsVmAPI (*ChangerInstanceOption)(TypUpsVmUnicode *NomModule, TypUpsNetXDonnees IntDon);
   /* Objet : Previent le module d'un changement d'instance d'une option. */
TypUpsVmUnicode UpsVmAPI *(*EnumererLibellesOptions)(TypUpsVmSession *Session, TypUpsVmShort PremiereFois);
   /* Objet : Enumere les libelles des options. */
TypUpsVmVoid UpsVmAPI (*EffectuerActionDistribuee)(TypUpsVmSession *Session, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsNetProtocoleUpsNet *BufferProtocoleUpsNet, TypUpsVmPointeurDonnees Complement, TypUpsVmCoAppel EnumererParametres);
   /* Objet : Effectue une action sur un autre processus. */
TypUpsVmVoid UpsVmAPI (*EffectuerActionDistribuee2)(TypUpsVmSession *Session, TypUpsNetCanal *Canal, 
   TypUpsNetProtocoleUpsNet *BufferProtocoleUpsNet, TypUpsVmPointeurDonnees Complement, TypUpsVmCoAppel EnumererParametres);
   /* Objet : Effectue une action sur un autre processus. */
TypUpsVmAdresse UpsVmAPI *(*LireAdresseType)(TypUpsVmSession *Session, TypUpsVmUnicode *NomModule, 
   TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, TypUpsVmUnicode *NomType, 
   TypUpsVmAdresse *AdresseType, TypUpsVmChar UtiliserObjet);
   /* Objet : Lit l'adresse d'un type. */
TypUpsVmAdresse UpsVmAPI *(*LireAdresseException)(TypUpsVmSession *Session, TypUpsVmUnicode *NomModule, 
   TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, TypUpsVmUnicode *NomException, 
   TypUpsVmAdresse *AdresseException, TypUpsVmChar UtiliserObjet);
   /* Objet : Lit l'adresse d'une exception. */
TypUpsVmAdresse UpsVmAPI *(*LireAdresseEntrepot)(TypUpsVmSession *Session, TypUpsVmUnicode *NomModule, 
   TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, TypUpsVmUnicode *NomEntrepot, 
   TypUpsVmAdresse *AdresseEntrepot, TypUpsVmChar UtiliserObjet);
   /* Objet : Lit l'adresse d'un entrepot. */
TypUpsVmAdresse UpsVmAPI *(*LireAdresseFile)(TypUpsVmSession *Session, TypUpsVmUnicode *NomModule, 
   TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, TypUpsVmUnicode *NomFile, 
   TypUpsVmAdresse *AdresseFile, TypUpsVmChar UtiliserObjet);
   /* Objet : Lit l'adresse d'une file. */
TypUpsVmUnsignedChar UpsVmAPI (*LireValeurVariableEnumereCourt)(TypUpsVmSession *Session, 
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmUnicode *NomVariable);
   /* Objet : Lit la valeur d'une variable de type enumere court. */
TypUpsVmUnsignedShort UpsVmAPI (*LireValeurVariableEnumereLong)(TypUpsVmSession *Session, 
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmUnicode *NomVariable);
   /* Objet : Lit la valeur d'une variable de type enumere long. */
TypUpsVmLong UpsVmAPI (*LireValeurVariableEntier)(TypUpsVmSession *Session, 
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmUnicode *NomVariable);
   /* Objet : Lit la valeur d'une variable de type entier. */
TypUpsVmDouble UpsVmAPI (*LireValeurVariableReel)(TypUpsVmSession *Session, 
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmUnicode *NomVariable);
   /* Objet : Lit la valeur d'une variable de type reel. */
TypUpsVmAdresse UpsVmAPI *(*LireValeurVariableObjet)(TypUpsVmSession *Session, 
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmUnicode *NomVariable, TypUpsVmAdresse *AdresseObjet, TypUpsVmChar UtiliserObjet);
   /* Objet : Lit la valeur d'une variable de type objet. */
TypUpsVmAdresse UpsVmAPI *(*LireType)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmUnicode *NomType, TypUpsVmAdresse *AdresseType, TypUpsVmChar UtiliserObjet);
   /* Objet : Lit l'adresse d'un type. */
TypUpsVmAdresse UpsVmAPI *(*LireException)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmUnicode *NomException, TypUpsVmAdresse *AdresseException, TypUpsVmChar UtiliserObjet);
   /* Objet : Lit l'adresse d'une exception. */
TypUpsVmAdresse UpsVmAPI *(*LireEntrepot)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmUnicode *NomEntrepot, TypUpsVmAdresse *AdresseEntrepot, TypUpsVmChar UtiliserObjet);
   /* Objet : Lit l'adresse d'un entrepot. */
TypUpsVmAdresse UpsVmAPI *(*LireFile)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmUnicode *NomFile, TypUpsVmAdresse *AdresseFile, TypUpsVmChar UtiliserObjet);
   /* Objet : Lit l'adresse d'une file. */
TypUpsVmAdresse UpsVmAPI *(*LireModule)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmAdresse *AdresseModule, TypUpsVmChar UtiliserObjet);
   /* Objet : Lit l'adresse d'un module. */
TypUpsVmUnsignedChar UpsVmAPI (*LireVariableEnumereCourt)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjetVariable, TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmUnicode *NomVariable, TypUpsVmShort NbSelections, TypUpsNetSelection *TableauSelections);
   /* Objet : Lit la valeur d'une variable. */
TypUpsVmUnsignedShort UpsVmAPI (*LireVariableEnumereLong)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjetVariable, TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmUnicode *NomVariable, TypUpsVmShort NbSelections, TypUpsNetSelection *TableauSelections);
   /* Objet : Lit la valeur d'une variable. */
TypUpsVmLong UpsVmAPI (*LireVariableEntier)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjetVariable, TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmUnicode *NomVariable, TypUpsVmShort NbSelections, TypUpsNetSelection *TableauSelections);
   /* Objet : Lit la valeur d'une variable. */
TypUpsVmDouble UpsVmAPI (*LireVariableReel)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjetVariable, TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmUnicode *NomVariable, TypUpsVmShort NbSelections, TypUpsNetSelection *TableauSelections);
   /* Objet : Lit la valeur d'une variable. */
TypUpsVmAdresse UpsVmAPI *(*LireVariableObjet)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjetVariable, TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmUnicode *NomVariable, TypUpsVmAdresse *AdresseObjet, TypUpsVmShort NbSelections, TypUpsNetSelection *TableauSelections);
   /* Objet : Lit l'adresse d'une variable. */
TypUpsVmAdresse UpsVmAPI *(*LireEstInstanceDe)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjetVariable, TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmUnicode *NomVariable, TypUpsVmAdresse *AdresseObjet, TypUpsVmShort NbSelections, TypUpsNetSelection *TableauSelections);
   /* Objet : Lit l'adresse d'une variable. */
TypUpsVmVoid UpsVmAPI (*EcrireVariableEnumereCourt)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjetVariable, TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmUnicode *NomVariable, TypUpsVmUnsignedChar Valeur, TypUpsVmShort NbSelections, TypUpsNetSelection *TableauSelections);
   /* Objet : Ecrit la valeur d'une variable. */
TypUpsVmVoid UpsVmAPI (*EcrireVariableEnumereLong)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjetVariable, TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmUnicode *NomVariable, TypUpsVmUnsignedShort Valeur, TypUpsVmShort NbSelections, TypUpsNetSelection *TableauSelections);
   /* Objet : Ecrit la valeur d'une variable. */
TypUpsVmVoid UpsVmAPI (*EcrireVariableEntier)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjetVariable, TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmUnicode *NomVariable, TypUpsVmLong Valeur, enum EnuUpsVmOperateur Operateur, TypUpsVmShort NbSelections, 
   TypUpsNetSelection *TableauSelections);
   /* Objet : Ecrit la valeur d'une variable. */
TypUpsVmVoid UpsVmAPI (*EcrireVariableReel)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjetVariable, TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmUnicode *NomVariable, TypUpsVmDouble Valeur, enum EnuUpsVmOperateur Operateur, TypUpsVmShort NbSelections, 
   TypUpsNetSelection *TableauSelections);
   /* Objet : Ecrit la valeur d'une variable. */
TypUpsVmVoid UpsVmAPI (*EcrireVariableObjet)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjetVariable, TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmUnicode *NomVariable, TypUpsVmAdresse *AdresseObjet, enum EnuUpsVmOperateur Operateur, TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, 
   TypUpsVmShort NbSelections, TypUpsNetSelection *TableauSelections);
   /* Objet : Ecrit l'adresse d'une variable. */
TypUpsVmLong UpsVmAPI (*IncrementerDecrementerVariableEntier)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjetVariable, TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmUnicode *NomVariable, TypUpsVmChar Incrementer, TypUpsVmChar Prefixe, TypUpsVmShort NbSelections, 
   TypUpsNetSelection *TableauSelections);
   /* Objet : Incrementer ou decremente une variable. */
TypUpsVmDouble UpsVmAPI (*IncrementerDecrementerVariableReel)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjetVariable, TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmUnicode *NomVariable, TypUpsVmChar Incrementer, TypUpsVmChar Prefixe, TypUpsVmShort NbSelections, 
   TypUpsNetSelection *TableauSelections);
   /* Objet : Incrementer ou decremente une variable. */
TypUpsVmAdresse UpsVmAPI *(*IncrementerDecrementerVariableObjet)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjetVariable, TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmUnicode *NomVariable, TypUpsVmAdresse *AdresseObjet, TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, TypUpsVmChar Incrementer, TypUpsVmChar Prefixe, 
   TypUpsVmShort NbSelections, TypUpsNetSelection *TableauSelections);
   /* Objet : Incrementer ou decremente une variable. */
TypUpsVmUnsignedChar UpsVmAPI (*ExtraireEnumereCourt)(TypUpsVmSession *Session, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjet);
   /* Objet : Extrait la valeur enumeree courte de l'objet. */
TypUpsVmUnsignedShort UpsVmAPI (*ExtraireEnumereLong)(TypUpsVmSession *Session, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjet);
   /* Objet : Extrait la valeur enumere long de l'objet. */
TypUpsVmLong UpsVmAPI (*ExtraireEntier)(TypUpsVmSession *Session, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjet);
   /* Objet : Extrait la valeur entiere de l'objet. */
TypUpsVmDouble UpsVmAPI (*ExtraireReel)(TypUpsVmSession *Session, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjet);
   /* Objet : Extrait la valeur reelle de l'objet. */
TypUpsVmUnsignedShort UpsVmAPI (*ExtraireEtLibererEnumere)(TypUpsVmSession *Session, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjet);
   /* Objet : Extrait la valeur enumeree de l'objet et libere-le. */
TypUpsVmVoid UpsVmAPI (*DetruireChampObjet)(TypUpsVmSession *Session, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjet, TypUpsVmLong Offset);
   /* Objet : Detruit le champ de l'objet. */
TypUpsVmVoid UpsVmAPI (*AppelSansParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjetAppel, TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel);
   /* Objet : Effectue un appel distribue sans parametre. */
TypUpsVmVoid UpsVmAPI (*AppelAvecParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjetAppel, TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, TypUpsVmLong TailleParametres, TypUpsVmPointeurDonnees Parametres, TypUpsVmCoAppel EnumererParametres);
   /* Objet : Effectue un appel distribue avec parametres. */
TypUpsVmUnsignedChar UpsVmAPI (*FonctionEnumereCourtSansParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjetAppel, TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel);
   /* Objet : Effectue une fonction distribuee sans parametre. */
TypUpsVmUnsignedChar UpsVmAPI (*FonctionEnumereCourtAvecParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjetAppel, TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, TypUpsVmLong TailleParametres, TypUpsVmPointeurDonnees Parametres, TypUpsVmCoAppel EnumererParametres);
   /* Objet : Effectue un appel distribue avec parametres. */
TypUpsVmUnsignedShort UpsVmAPI (*FonctionEnumereLongSansParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjetAppel, TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel);
   /* Objet : Effectue une fonction distribuee sans parametre. */
TypUpsVmUnsignedShort UpsVmAPI (*FonctionEnumereLongAvecParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjetAppel, TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, TypUpsVmLong TailleParametres, TypUpsVmPointeurDonnees Parametres, TypUpsVmCoAppel EnumererParametres);
   /* Objet : Effectue un appel distribue avec parametres. */
TypUpsVmLong UpsVmAPI (*FonctionEntierSansParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjetAppel, TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel);
   /* Objet : Effectue une fonction distribuee sans parametre. */
TypUpsVmLong UpsVmAPI (*FonctionEntierAvecParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjetAppel, TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, TypUpsVmLong TailleParametres, TypUpsVmPointeurDonnees Parametres, TypUpsVmCoAppel EnumererParametres);
   /* Objet : Effectue un appel distribue avec parametres. */
TypUpsVmDouble UpsVmAPI (*FonctionReelSansParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjetAppel, TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel);
   /* Objet : Effectue une fonction distribuee sans parametre. */
TypUpsVmDouble UpsVmAPI (*FonctionReelAvecParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjetAppel, TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, TypUpsVmLong TailleParametres, TypUpsVmPointeurDonnees Parametres, TypUpsVmCoAppel EnumererParametres);
   /* Objet : Effectue un appel distribue avec parametres. */
TypUpsVmAdresse UpsVmAPI *(*FonctionObjetSansParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjetAppel, TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, TypUpsVmAdresse *AdresseResultat);
   /* Objet : Effectue une fonction distribuee sans parametre. */
TypUpsVmAdresse UpsVmAPI *(*FonctionObjetAvecParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjetAppel, TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, TypUpsVmAdresse *AdresseResultat, TypUpsVmLong TailleParametres, TypUpsVmPointeurDonnees Parametres, TypUpsVmCoAppel EnumererParametres);
   /* Objet : Effectue un appel distribue avec parametres. */
TypUpsVmAdresse UpsVmAPI *(*ConstructeurSansParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, 
   TypUpsVmUnicode *NomType, TypUpsVmAdresse *AdresseResultat);
   /* Objet : Effectue un constructeur distribue sans parametre. */
TypUpsVmAdresse UpsVmAPI *(*ConstructeurAvecParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, 
   TypUpsVmUnicode *NomType, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmLong TailleParametres, TypUpsVmPointeurDonnees Parametres, TypUpsVmCoAppel EnumererParametres);
   /* Objet : Effectue un appel distribue avec parametres. */
TypUpsVmAdresse UpsVmAPI *(*Destructeur)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, 
   TypUpsVmUnicode *NomType, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Effectue un destructeur distribue. */
TypUpsVmVoid UpsVmAPI (*MethodeAffecter)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, 
   TypUpsVmUnicode *NomType, TypUpsVmAdresse *AdresseObjet, TypUpsVmAdresse *AdresseObjetP);
   /* Objet : Effectue une affectation distribuee. */
TypUpsVmVoid UpsVmAPI (*MethodeAffecterTypeParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseObjet, TypUpsVmAdresse *AdresseObjetP, TypUpsVmLong Offset);
   /* Objet : Effectue une affectation distribuee. */
TypUpsVmAdresse UpsVmAPI *(*MethodeEgal)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, 
   TypUpsVmUnicode *NomType, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypUpsVmAdresse *AdresseObjetP);
   /* Objet : Effectue une affectation distribuee. */
TypUpsVmAdresse UpsVmAPI *(*MethodeEgalTypeParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypUpsVmAdresse *AdresseObjetP, TypUpsVmLong Offset);
   /* Objet : Effectue une egalite distribuee. */
TypUpsVmAdresse UpsVmAPI *(*MethodeDifferent)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, 
   TypUpsVmUnicode *NomType, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypUpsVmAdresse *AdresseObjetP);
   /* Objet : Effectue une difference distribuee. */
TypUpsVmAdresse UpsVmAPI *(*MethodeDifferentTypeParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypUpsVmAdresse *AdresseObjetP, TypUpsVmLong Offset);
   /* Objet : Effectue une difference distribuee. */
TypUpsVmAdresse UpsVmAPI *(*MethodeCloner)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, 
   TypUpsVmUnicode *NomType, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsVmCloner *UpsPrm);
   /* Objet : Effectue un clonage distribue. */
TypUpsVmVoid UpsVmAPI (*MethodeExporter)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, 
   TypUpsVmUnicode *NomType, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Effectue un clonage distribue. */
TypUpsVmAdresse UpsVmAPI *(*MethodeImporter)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, 
   TypUpsVmUnicode *NomType, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmImporter *UpsPrm);
   /* Objet : Effectue une importation distribuee. */
TypUpsVmAdresse UpsVmAPI *(*MethodeLirePropriete)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, 
   TypUpsVmUnicode *NomType, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsVmLirePropriete *UpsPrm);
   /* Objet : Methode de lecture des proprietes dynamiques. */
TypUpsVmVoid UpsVmAPI (*MethodeEcrirePropriete)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel,
   TypUpsVmUnicode *NomType, TypUpsVmAdresse *AdresseObjet, TypPrmUpsVmEcrirePropriete *UpsPrm);
   /* Objet : Methode d'ecriture des proprietes dynamiques. */
TypUpsVmAdresse UpsVmAPI *(*MethodeIncrementerDecrementerPropriete)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel,
   TypUpsVmUnicode *NomType, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsVmIncrementerDecrementerPropriete *UpsPrm);
   /* Objet : Methode d'incrementation ou de decrementation des proprietes dynamiques. */
TypUpsVmVoid UpsVmAPI (*MethodeSupprimerPropriete)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel,
   TypUpsVmUnicode *NomType, TypUpsVmAdresse *AdresseObjet, TypPrmUpsVmSupprimerPropriete *UpsPrm);
   /* Objet : Methode de suppression des proprietes dynamiques. */
TypUpsVmAdresse UpsVmAPI *(*MethodeEnumererProprietes)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel,
   TypUpsVmUnicode *NomType, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsVmEnumererProprietes *UpsPrm);
   /* Objet : Methode d'enumeration des proprietes dynamiques. */
TypUpsVmAdresse UpsVmAPI *(*MethodeEnumererMethodes)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel,
   TypUpsVmUnicode *NomType, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsVmEnumererAppels *UpsPrm);
   /* Objet : Enumere les appels. */
TypUpsVmVoid UpsVmAPI (*MethodeAllouerRessource)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel,
   TypUpsVmUnicode *NomType, TypUpsVmAdresse *AdresseObjet);
   /* Methode d'allocation de la ressource pour un Objet; */
TypUpsVmVoid UpsVmAPI (*MethodeLibererRessource)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel,
   TypUpsVmUnicode *NomType, TypUpsVmAdresse *AdresseObjet);
   /* Methode de liberation de la ressource pour un Objet; */
TypUpsVmVoid UpsVmAPI (*MethodeSansParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel,
   TypUpsVmUnicode *NomType, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Effectue un appel distribue sans parametre. */
TypUpsVmVoid UpsVmAPI (*MethodeAvecParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel,
   TypUpsVmUnicode *NomType, TypUpsVmAdresse *AdresseObjet, TypUpsVmLong TailleParametres, TypUpsVmPointeurDonnees Parametres, 
   TypUpsVmCoAppel EnumererParametres);
   /* Objet : Effectue un appel distribue avec parametres. */
TypUpsVmUnsignedChar UpsVmAPI (*MethodeEnumereCourtSansParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel,
   TypUpsVmUnicode *NomType, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Effectue une fonction distribuee sans parametre. */
TypUpsVmUnsignedChar UpsVmAPI (*MethodeEnumereCourtAvecParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel,
   TypUpsVmUnicode *NomType, TypUpsVmAdresse *AdresseObjet, TypUpsVmLong TailleParametres, TypUpsVmPointeurDonnees Parametres, 
   TypUpsVmCoAppel EnumererParametres);
   /* Objet : Effectue un appel distribue avec parametres. */
TypUpsVmUnsignedShort UpsVmAPI (*MethodeEnumereLongSansParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel,
   TypUpsVmUnicode *NomType, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Effectue une fonction distribuee sans parametre. */
TypUpsVmUnsignedShort UpsVmAPI (*MethodeEnumereLongAvecParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel,
   TypUpsVmUnicode *NomType, TypUpsVmAdresse *AdresseObjet, TypUpsVmLong TailleParametres, TypUpsVmPointeurDonnees Parametres, 
   TypUpsVmCoAppel EnumererParametres);
   /* Objet : Effectue un appel distribue avec parametres. */
TypUpsVmLong UpsVmAPI (*MethodeEntierSansParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel,
   TypUpsVmUnicode *NomType, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Effectue une fonction distribuee sans parametre. */
TypUpsVmLong UpsVmAPI (*MethodeEntierAvecParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel,
   TypUpsVmUnicode *NomType, TypUpsVmAdresse *AdresseObjet, TypUpsVmLong TailleParametres, TypUpsVmPointeurDonnees Parametres, 
   TypUpsVmCoAppel EnumererParametres);
   /* Objet : Effectue un appel distribue avec parametres. */
TypUpsVmDouble UpsVmAPI (*MethodeReelSansParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel,
   TypUpsVmUnicode *NomType, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Effectue une fonction distribuee sans parametre. */
TypUpsVmDouble UpsVmAPI (*MethodeReelAvecParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel,
   TypUpsVmUnicode *NomType, TypUpsVmAdresse *AdresseObjet, TypUpsVmLong TailleParametres, TypUpsVmPointeurDonnees Parametres, 
   TypUpsVmCoAppel EnumererParametres);
   /* Objet : Effectue un appel distribue avec parametres. */
TypUpsVmAdresse UpsVmAPI *(*MethodeObjetSansParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel,
   TypUpsVmUnicode *NomType, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Effectue une fonction distribuee sans parametre. */
TypUpsVmAdresse UpsVmAPI *(*MethodeObjetAvecParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseServeur, TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur,
   TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel,
   TypUpsVmUnicode *NomType, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmLong TailleParametres, TypUpsVmPointeurDonnees Parametres, TypUpsVmCoAppel EnumererParametres);
   /* Objet : Effectue un appel distribue avec parametres. */
TypUpsVmVoid UpsVmAPI (*RecupererLiaisonSessionInterne)(TypUpsVmVoid);
   /* Objet : Recupere la liaison ouverte pour la session interne. */
TypUpsVmShort UpsVmAPI (*ChercherServeur)(TypUpsVmSession *Session, 
   TypUpsVmUnicode *NomNoeud, TypUpsVmUnicode *NomServeur, TypUpsNetCanal *CanalServeur, 
   TypUpsVmUnsignedChar *EstBigEndian, TypUpsVmUnsignedChar *NbBits, TypUpsVmUnsignedChar *PageDeCode,
   TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur);
   /* Objet : Recherche un serveur et retourne son canal. */
TypUpsVmEnteteMethodesModule UpsVmAPI (*ChercherModule)(TypUpsVmSession *Session, 
   TypUpsVmUnicode *NomNoeud, TypUpsVmUnicode *NomServeur, TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision, TypUpsVmShort Correction, 
   TypUpsNetCanal *CanalServeur, TypUpsVmUnsignedChar *EstBigEndian, TypUpsVmUnsignedChar *NbBits, 
   TypUpsVmUnsignedChar *PageDeCode, TypUpsVmUnsignedShort *NumeroNoeud, TypUpsVmUnsignedShort *NumeroServeur);
   /* Objet : Recherche un module et retourne son canal. */
TypUpsVmLong UpsVmAPI (*PrincipalTacheServeur)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjetTache, TypUpsVmPointeurDonnees AdresseServeurCourant);
   /* Objet : Fonction principale d'une tache gerant les acces distants vers ce processus. */
TypUpsVmVoid UpsVmAPI (*LancerTacherServeur)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees ServeurCourant);
   /* Objet : Lance un serveur de traitement. */
TypUpsVmVoid UpsVmAPI (*LibererTacheServeur)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees ServeurCourant);
   /* Objet : Libere une tache serveur Ups Net. */
TypUpsVmLong UpsVmAPI (*PrincipalTacheScrutateur)(TypUpsVmSession *Session);
   /* Objet : Fonction principale du scrutateur. */
TypUpsVmShort UpsVmAPI (*LancerTacheScrutateur)(TypUpsVmSession *Session);
   /* Objet : Lance la tache du scrutateur. */
TypUpsVmLong UpsVmAPI (*PrincipalTacheStatistiques)(TypUpsVmSession *Session,
   TypUpsVmAdresse *AdresseObjetTache, TypUpsVmPointeurDonnees Parametres);
   /* Objet : Fonction principale d'une tache gerant les acces distants vers ce processus. */
TypUpsVmShort UpsVmAPI (*LancerTacheStatistiques)(TypUpsVmSession *Session);
   /* Objet : Lance la tache statistiques. */
TypUpsVmVoid UpsVmAPI (*TraiterAppelDistribue)(TypUpsVmSession *Session, TypUpsVmPointeurTraitements *TableAppels, TypUpsVmLong Offset, 
   TypUpsNetProtocoleUpsNet *BufferProtocoleUpsNet, TypUpsVmPointeurDonnees Parametres);
   /* Objet : Effectue un appel disponible dans ce processus. */
TypUpsVmVoid UpsVmAPI (*FermerSessionCliente)(TypUpsVmSession *Session);
   /* Objet : Signifie au serveur que le client ferme sa session. */
TypUpsVmVoid UpsVmAPI (*ConnecterSessionCliente)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseUtilisateur, TypUpsVmAdresse *AdresseMotDePasse,
   TypUpsVmAdresse *AdresseServeur);
   /* Objet : Connecte une session cliente. */
TypUpsVmVoid UpsVmAPI (*ConnecterSessionCliente2)(TypUpsVmSession *Session, TypUpsVmUnicode *LibelleConnexion);
   /* Objet : Connecte une session cliente. */
TypUpsVmVoid UpsVmAPI (*DeconnecterSessionCliente)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseServeur);
   /* Objet : Deconnecte une session cliente. */
TypUpsVmVoid UpsVmAPI (*InitialiserCanal)(TypUpsVmSession *Session, TypUpsNetCanal *Canal, TypUpsVmUnicode *NomOption);
   /* Objet : Initialise le canal. */
TypUpsVmVoid UpsVmAPI (*InitialiserCanalScrutateur)(TypUpsVmSession *Session, TypUpsNetCanal *Canal, TypUpsVmUnicode *NomOption);
   /* Objet : Initialise le canal pour le scrutateur. */
TypUpsVmVoid UpsVmAPI (*InitialiserCanalOrbLocal)(TypUpsVmSession *Session, TypUpsNetCanal *Canal, TypUpsVmUnicode *NomOption);
   /* Objet : Initialise le canal pour l'Orb local. */
TypUpsVmVoid UpsVmAPI (*InitialiserCanalEnLocal)(TypUpsVmSession *Session, TypUpsNetCanal *Canal, TypUpsVmUnicode *NomOption);
   /* Objet : Initialise le canal pour travailler en local. */
TypUpsVmVoid UpsVmAPI (*CalculerPlusPetitCanal)(TypUpsVmSession *Session, TypUpsNetCanal *CanalUtilise, TypUpsNetCanal *CanalLibre);
   /* Objet : Compare les parametres des canaux pour trouver un canal non utilise. */
TypUpsVmShort UpsVmAPI (*CanauxEgaux)(TypUpsVmSession *Session, TypUpsNetCanal *Canal1, TypUpsNetCanal *Canal2);
   /* Objet : Retourne Vrai si les caracteristiques des canaux sont identiques. */
TypUpsVmShort UpsVmAPI (*CopierCanal)(TypUpsVmSession *Session, TypUpsNetCanal *Canal1, TypUpsNetCanal *Canal2, TypUpsVmShort Total);
   /* Objet : Copie les informations du canal. */
TypUpsVmVoid UpsVmAPI (*DeplacerCanal)(TypUpsVmSession *Session, TypUpsNetCanal *Canal1, TypUpsNetCanal *Canal2);
   /* Objet : Deplace les informations du canal. */
TypUpsVmVoid UpsVmAPI (*FormaterAdresseCanal)(TypUpsVmSession *Session, TypUpsVmUnicode *AdresseCanal, TypUpsVmLong TailleAdresseCanam, TypUpsNetCanal *Canal);
   /* Objet : Formate le libelle de l'adresse pour un message d'erreur. */
TypUpsVmShort UpsVmAPI (*LireParametresCanal)(TypUpsVmSession *Session, TypUpsNetCanal *Canal, TypUpsVmUnicode *NomOption, TypUpsVmUnicode *Profil, TypUpsVmUnicode *Section);
   /* Objet : Lit les parametres du canal. */
TypUpsVmVoid UpsVmAPI (*FormaterParametresCanal)(TypUpsVmSession *Session, TypUpsNetCanal *Canal, TypUpsVmUnicode *Arguments, TypUpsVmLong TailleArguments);
   /* Objet : Formate les parametres du canal. */
TypUpsNetCanal UpsVmAPI *(*LireCanalMachine)(TypUpsVmSession *Session, TypUpsVmUnicode *NomOption);
   /* Objet : Lit le canal pour communiquer avec la machine. */
TypUpsVmShort UpsVmAPI (*EstUnNombre)(TypUpsVmUnicode *Libelle);
   /* Objet : Retourne Vrai si le libelle est un nombre. */
TypUpsVmVoid UpsVmAPI (*DecoderAdresse)(TypUpsVmSession *Session, TypUpsVmUnicode *Adresse, TypUpsNetCanal *Canal);
   /* Objet : Decode une adresse en un canal. */
TypUpsVmVoid UpsVmAPI (*AllouerCanal)(TypUpsVmSession *Session, TypUpsNetCanal *CanalLibre, TypUpsVmUnicode *Canal);
   /* Objet : Alloue un port dans la plage reservee. */
TypUpsVmVoid UpsVmAPI (*RecupererInformationsSession)(TypUpsVmSession *Session, TypUpsNetCanal *Canal1, TypUpsNetCanal *Canal2);
   /* Objet : Recupere les informations de session du client. */
TypUpsVmVoid UpsVmAPI (*DecoderCanal)(TypUpsVmSession *Session, TypUpsNetCanal *Canal);
   /* Objet : Decode les champs entiers du canal. */
TypUpsVmVoid UpsVmAPI (*EnregistrerParametresCanalOrb)(TypUpsVmSession *Session, TypUpsVmFlux *Descripteur, TypUpsVmUnicode *NomOption);
   /* Objet : Enregistre les parametres de Ups Orb. */
TypUpsVmVoid UpsVmAPI (*EnregistrerParametresCanal)(TypUpsVmSession *Session, TypUpsNetCanal *Canal, TypUpsVmFlux *Descripteur);
   /* Objet : Enregistre les parametres du noeud. */
TypUpsVmShort UpsVmAPI (*OuvrirUnCanal)(TypUpsVmSession *Session, TypUpsNetCanal *Canal, enum EnuUpsVmTailleBuffer TailleBuffer);
   /* Objet : Ouvre le canal de communication. */
TypUpsVmShort UpsVmAPI (*EcouterClients)(TypUpsVmSession *Session, TypUpsNetCanal *CanalServeur, TypUpsVmShort NbClients);
   /* Objet : Configure le canal pour traiter au plus NbClients. */
TypUpsVmShort UpsVmAPI (*AccepterUnClient)(TypUpsVmSession *Session, TypUpsNetCanal *CanalServeur, TypUpsNetCanal *CanalClient);
   /* Objet : Accepte un nouveau client. */
TypUpsVmShort UpsVmAPI (*Connecter)(TypUpsVmSession *Session, TypUpsNetCanal *CanalClient, TypUpsNetCanal *CanalServeur);
   /* Objet : Connexion a un serveur. */
TypUpsVmVoid UpsVmAPI (*Detruire)(TypUpsVmSession *Session, TypUpsNetCanal *Canal);
   /* Objet : Detruit le canal. */
TypUpsVmVoid UpsVmAPI (*InitialiserBufferProtocoleUpsNet)(TypUpsVmSession *Session, TypUpsNetProtocoleUpsNet *BufferProtocoleUpsNet,
   TypUpsVmShort VersionDemandee, TypUpsVmShort RevisionDemandee, TypUpsVmShort CorrectionDemandee,
   TypUpsVmUnsignedShort NumeroNoeud, TypUpsVmUnsignedShort NumeroServeur);
   /* Objet : Initialise le buffer servant a faire un appel distribue. */
TypUpsVmShort UpsVmAPI (*ExporterCanal)(TypUpsVmSession *Session, TypUpsNetCanal *Canal, TypUpsVmShort Permuter);
   /* Objet : Exporte le canal de communication. */
TypUpsVmShort UpsVmAPI (*ImporterCanal)(TypUpsVmSession *Session, TypUpsNetCanal *Canal);
   /* Objet : Importe le canal de communication. */
TypUpsVmVoid UpsVmAPI (*CanalLireBooleen)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsSys_12_5_1 *UpsPrm,
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, TypUpsVmUnicode *NomType);
   /* Procedure Lire(B:Booleen Sortie); */
TypUpsVmAdresse UpsVmAPI *(*CanalLireBinaire)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsSys_12_5_2 *UpsPrm,
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, TypUpsVmUnicode *NomType);
   /* Fonction Lire(C:Binaire Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*CanalLireCaractere)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsSys_12_5_3 *UpsPrm, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, TypUpsVmUnicode *NomType);
   /* Fonction Lire(C:Caractere Sortie, Nombre:Nul Ou Entier)      */
   /* Retourner Nul Ou Entier;                                     */
TypUpsVmVoid UpsVmAPI (*CanalLireEntier)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsSys_12_5_4 *UpsPrm, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, TypUpsVmUnicode *NomType);
   /* Procedure Lire(E:Entier Sortie); */
TypUpsVmVoid UpsVmAPI (*CanalLireReel)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsSys_12_5_5 *UpsPrm, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, TypUpsVmUnicode *NomType);
   /* Procedure Lire(R:Reel Sortie); */
TypUpsVmAdresse UpsVmAPI *(*CanalLireUneLigne)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsSys_12_6_1 *UpsPrm, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, TypUpsVmUnicode *NomType);
   /* Fonction LireUneLigne(C:Nul Ou Caractere Sortie, Nombre:Nul  */
   /* Ou Entier) Retourner Nul Ou Entier;                          */
TypUpsVmAdresse UpsVmAPI *(*CanalLireUnMot)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsSys_12_7_1 *UpsPrm, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, TypUpsVmUnicode *NomType);
   /* Fonction LireUnMot(C:Nul Ou Caractere Sortie, Nombre:Nul Ou  */
   /* Entier) Retourner Nul Ou Entier;                             */
TypUpsVmVoid UpsVmAPI (*CanalEcrireBooleen)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsSys_12_8_1 *UpsPrm, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, TypUpsVmUnicode *NomType);
   /* Procedure Ecrire(B:Nul Ou Booleen); */
TypUpsVmVoid UpsVmAPI (*CanalEcrireBinaire)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsSys_12_8_2 *UpsPrm, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, TypUpsVmUnicode *NomType);
   /* Procedure Ecrire(C:Nul Ou Binaire); */
TypUpsVmVoid UpsVmAPI (*CanalEcrireCaractere)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsSys_12_8_3 *UpsPrm, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, TypUpsVmUnicode *NomType);
   /* Procedure Ecrire(C:Nul Ou Caractere); */
TypUpsVmVoid UpsVmAPI (*CanalEcrireEntier)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsSys_12_8_4 *UpsPrm, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, TypUpsVmUnicode *NomType);
   /* Procedure Ecrire(E:Nul Ou Entier); */
TypUpsVmVoid UpsVmAPI (*CanalEcrireReel)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsSys_12_8_5 *UpsPrm, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, TypUpsVmUnicode *NomType);
   /* Procedure Ecrire(R:Nul Ou Reel); */
TypUpsVmVoid UpsVmAPI (*CanalFermer)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, TypUpsVmUnicode *NomType);
   /* Procedure Fermer(); */
TypUpsVmUnsignedChar UpsVmAPI (*CanalLirePageDeCode)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, TypUpsVmUnicode *NomType);
   /* Objet : LirePageDeCode() Retourner PagesDeCodesSupportees. */ 
TypUpsVmVoid UpsVmAPI (*CanalChangerPageDeCode)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, TypUpsVmUnicode *NomType, TypPrmUpsSys_12_11_1 *UpsPrm);
   /* Objet : ChangerPageDeCode(P:PagesDeCodesSupportees). */ 
TypUpsVmVoid UpsVmAPI (*CanalDetruire)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, TypUpsVmUnicode *NomType);
   /* Procedure Detruire(); */
TypUpsVmAdresse UpsVmAPI *(*CanalProtocole)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, TypUpsVmUnicode *NomType);
   /* Fonction Protocole() Retourner Caractere; */
TypUpsVmAdresse UpsVmAPI *(*CanalAdresse)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsNet_1_13_1 *UpsPrm, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel, TypUpsVmUnicode *NomType);
   /* Fonction Adresse(ProtocoleDuClient:Booleen=Faux) Retourner Caractere; */
TypUpsVmShort UpsVmAPI (*InitialiserUpsNet)(TypUpsVmVoid);
   /* Objet : Initialise Ups Net. */
TypUpsVmShort UpsVmAPI (*InitialiserEncapsulationKernel)(TypUpsVmVoid);
   /* Objet : Initialisation de l'extension de Ups Net pour Ups Krn. */
TypUpsVmVoid UpsVmAPI (*TerminerEncapsulationKernel)(TypUpsVmVoid);
   /* Objet : Terminaison de l'extension de Ups Net pour Ups Krn. */
TypUpsVmAdresse UpsVmAPI *(*CreerObjetServeur)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseResultat, TypUpsVmUnicode *NomModule, TypUpsVmShort Version, TypUpsVmShort Revision,
   TypUpsVmShort Correction, TypUpsVmUnicode *NomNoeud, TypUpsVmUnicode *NomServeur);
   /* Objet : Fabrique un objet Serveur. */
} *TypUpsNetTraitements_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsNetTraitements_1_1_0 TypUpsNetTraitements;

extern DllExport TypUpsVtmDemarrer UpsVmAPI UpsNetDemarrerModule(TypUpsVmShort Numero, TypUpsVtmMachineInterface MachineInterfaceUpsVtm,
   TypUpsVtmTraitements IntTrtUpsVtm, TypUpsVtmDonnees IntDonUpsVtm);
   /* Procedure de demarrage de Ups Net. */

/**********************/
#if defined(__cplusplus)
/**********************/
}
/****/
#endif
/****/

/****/
#endif
/****/
