/*-------------------------------------------------------------------
Fichier     : upsmat_nt.e
Objet       : En-tete de la bibliotheque native du module Up ! Mathematical.

Module      : Up ! Mathematical
Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.
---------------------------------------------------------------------
                         Observations

 
---------------------------------------------------------------------*/

/********************************/
#if !defined(PasseModuleUpsMatNat)
/********************************/
#define PasseModuleUpsMatNat 1

/**********************/
#if defined(__cplusplus)
/**********************/
extern "C"
{
/****/
#endif
/****/

typedef TypUpsVmVoid UpsVmAPI (*TypUpsMatNatMathErr)(TypUpsVmChar *Appel, TypUpsVmDouble Argument1, TypUpsVmDouble Argument2);
   /* Objet : matherr(). */

/****************************************************************/
typedef struct typupsmatnattraitements_1_1_0
/* Objet: Interface des traitements de Ups Mat Nat.             */
/****************************************************************/
{
TypUpsVmDouble UpsVmAPI (*ACos)(TypUpsVmDouble P1);
   /* Objet : acos(). */
TypUpsVmDouble UpsVmAPI (*ASin)(TypUpsVmDouble P1);
   /* Objet : asin(). */
TypUpsVmDouble UpsVmAPI (*ATan)(TypUpsVmDouble P1);
   /* Objet : atan(). */
TypUpsVmDouble UpsVmAPI (*Ceil)(TypUpsVmDouble P1);
   /* Objet : ceil(). */
TypUpsVmDouble UpsVmAPI (*Cos)(TypUpsVmDouble P1);
   /* Objet : cos(). */
TypUpsVmDouble UpsVmAPI (*CosH)(TypUpsVmDouble P1);
   /* Objet : cosh(). */
TypUpsVmShort UpsVmAPI (*DoubleDigit)(TypUpsVmVoid);
   /* Objet : DBL_DIG. */
TypUpsVmDouble UpsVmAPI (*ErreurDouble)(TypUpsVmVoid);
   /* Objet : DBL_EPSILON. */
TypUpsVmDouble UpsVmAPI (*Exp)(TypUpsVmDouble P1);
   /* Objet : exp(). */
TypUpsVmDouble UpsVmAPI (*FAbs)(TypUpsVmDouble P1);
   /* Objet : fabs(). */
TypUpsVmChar UpsVmAPI *(*Fcvt)(TypUpsVmDouble Double, TypUpsVmShort TaillePartieReelle, 
   TypUpsVmShort *Decimale, TypUpsVmShort *Signe);
   /* Objet : Fcvt(). */
TypUpsVmDouble UpsVmAPI (*Floor)(TypUpsVmDouble P1);
   /* Objet : floor(). */
TypUpsVmDouble UpsVmAPI (*FMod)(TypUpsVmDouble P1, TypUpsVmDouble P2);
   /* Objet : fmod(). */
TypUpsVmLong UpsVmAPI (*FToL)(TypUpsVmDouble Double);
   /* Objet : ftol(). */
TypUpsVmDouble UpsVmAPI (*Log)(TypUpsVmDouble P1);
   /* Objet : log(). */
TypUpsVmDouble UpsVmAPI (*Log10)(TypUpsVmDouble P1);
   /* Objet : log10(). */
TypUpsVmDouble UpsVmAPI (*LToF)(TypUpsVmLong Long);
   /* Objet : ltof(). */
TypUpsVmDouble UpsVmAPI (*Pow)(TypUpsVmDouble P1, TypUpsVmDouble P2);
   /* Objet : pow(). */
TypUpsVmLong UpsVmAPI (*Rand)(TypUpsVmVoid);
   /* Objet : rand(). */
TypUpsVmVoid UpsVmAPI (*SetMathErr)(TypUpsMatNatMathErr CallbackMathErr);
   /* Objet : matherr(). */
TypUpsVmDouble UpsVmAPI (*Sin)(TypUpsVmDouble P1);
   /* Objet : sin(). */
TypUpsVmDouble UpsVmAPI (*SinH)(TypUpsVmDouble P1);
   /* Objet : sinh(). */
TypUpsVmDouble UpsVmAPI (*Sqrt)(TypUpsVmDouble P1);
   /* Objet : sqrt(). */
TypUpsVmVoid (*SRand)(TypUpsVmShort Compteur);
   /* Objet : srand. */
TypUpsVmDouble UpsVmAPI (*Tan)(TypUpsVmDouble P1);
   /* Objet : tan(). */
TypUpsVmDouble UpsVmAPI (*TanH)(TypUpsVmDouble P1);
   /* Objet : tanh(). */
} *TypUpsMatNatTraitements_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsMatNatTraitements_1_1_0 TypUpsMatNatTraitements;

extern DllExport TypUpsMatNatTraitements UpsVmAPI UpsMatNatDemarrerModule(TypUpsVtmMachineInterface MachineInterfaceUpsVtm);
   /* Objet : Retourne la description de Ups Mat Nat. */

/**********************/
#if defined(__cplusplus)
/**********************/
}
/****/
#endif
/****/

/****/
#endif
/****/
