/*-------------------------------------------------------------------
Fichier     : upsmat.e
Objet       : En-tete du module Up ! Mathematical.

Module      : Up ! Mathematical
Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.
---------------------------------------------------------------------
                         Observations

 
---------------------------------------------------------------------*/

/*****************************/
#if !defined(PasseModuleUpsMat)
/*****************************/
#define PasseModuleUpsMat 1

/**********************/
#if defined(__cplusplus)
/**********************/
extern "C"
{
/****/
#endif
/****/

#define UpsConUpsMat_1 2.718281828459
   /* Constante : e */
#define UpsConUpsMat_2 3.14159265359
   /* Constante : Pi */

/****************************************************************/
typedef struct typupsmatdonnees
/* Objet: Interface des donnees de Ups Mat.                     */
/****************************************************************/
{
struct typupsvmentetedonneesmodule EnteteDonneesModule;
   /* Entete generique du module. */
} *TypUpsMatDonnees;

/****************************************************************/
typedef struct typprmupsmat_1_1
/* Objet : Parametre de Abs(E:Entier).					             */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* E : Entier. */
} TypPrmUpsMat_1_1;

/****************************************************************/
typedef struct typprmupsmat_1_2
/* Objet : Parametre de Abs(R:Reel).					             */
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* R : Reel. */
} TypPrmUpsMat_1_2;

/****************************************************************/
typedef struct typprmupsmat_2_1
/* Objet : Parametre de ACos(R:Reel).					             */
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* R : Reel. */
} TypPrmUpsMat_2_1;

/****************************************************************/
typedef struct typprmupsmat_3_1
/* Objet : Parametre de ASin(R:Reel).					             */
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* R : Reel. */
} TypPrmUpsMat_3_1;

/****************************************************************/
typedef struct typprmupsmat_4_1
/* Objet : Parametre de ATan(R:Reel).					             */
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* R : Reel. */
} TypPrmUpsMat_4_1;

/****************************************************************/
typedef struct typprmupsmat_5_1
/* Objet : Parametre de Cos(R:Reel).					             */
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* R : Reel. */
} TypPrmUpsMat_5_1;

/****************************************************************/
typedef struct typprmupsmat_6_1
/* Objet : Parametre de Sin(R:Reel).					             */
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* R : Reel. */
} TypPrmUpsMat_6_1;

/****************************************************************/
typedef struct typprmupsmat_7_1
/* Objet : Parametre de Tan(R:Reel).					             */
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* R : Reel. */
} TypPrmUpsMat_7_1;

/****************************************************************/
typedef struct typprmupsmat_8_1
/* Objet : Parametre de ACosH(R:Reel).					             */
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* R : Reel. */
} TypPrmUpsMat_8_1;

/****************************************************************/
typedef struct typprmupsmat_9_1
/* Objet : Parametre de ASinH(R:Reel).					             */
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* R : Reel. */
} TypPrmUpsMat_9_1;

/****************************************************************/
typedef struct typprmupsmat_10_1
/* Objet : Parametre de ATanH(R:Reel).					             */
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* R : Reel. */
} TypPrmUpsMat_10_1;

/****************************************************************/
typedef struct typprmupsmat_11_1
/* Objet : Parametre de CosH(R:Reel).					             */
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* R : Reel. */
} TypPrmUpsMat_11_1;

/****************************************************************/
typedef struct typprmupsmat_12_1
/* Objet : Parametre de SinH(R:Reel).					             */
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* R : Reel. */
} TypPrmUpsMat_12_1;

/****************************************************************/
typedef struct typprmupsmat_13_1
/* Objet : Parametre de TanH(R:Reel).					             */
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* R : Reel. */
} TypPrmUpsMat_13_1;

/****************************************************************/
typedef struct typprmupsmat_14_1
/* Objet : Parametre de Exp(R:Reel).					             */
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* R : Reel. */
} TypPrmUpsMat_14_1;

/****************************************************************/
typedef struct typprmupsmat_15_1
/* Objet : Parametre de Log(R:Reel).					             */
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* R : Reel. */
} TypPrmUpsMat_15_1;

/****************************************************************/
typedef struct typprmupsmat_16_1
/* Objet : Parametre de Log10(R:Reel).					             */
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* R : Reel. */
} TypPrmUpsMat_16_1;

/****************************************************************/
typedef struct typprmupsmat_17_1
/* Objet : Parametre de Racine(E:Entier).					          */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* R : Reel. */
} TypPrmUpsMat_17_1;

/****************************************************************/
typedef struct typprmupsmat_17_2
/* Objet : Parametre de Racine(R:Reel).					          */
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* R : Reel. */
} TypPrmUpsMat_17_2;

typedef UpsTypUpsKrn_8 UpsTypUpsMat_1;
typedef UpsTrtTypUpsKrn_8 UpsTrtTypUpsMat_1;
typedef UpsTypUpsKrn_8 UpsTypUpsMat_2;
typedef UpsTrtTypUpsKrn_8 UpsTrtTypUpsMat_2;

/*******************************************************************/
typedef struct typupsmatmachineinterface_1_1_0
/* Objet : Interface avec la machine pour Up ! Mathematical.      */ 
/*******************************************************************/
{
TypUpsVmDouble UpsVmAPI (*Abs)(TypUpsVmDouble P1);
   /* Objet : Valeur absolue. */
TypUpsVmDouble UpsVmAPI (*ACos)(TypUpsVmDouble P1);
   /* Objet : Arc cosinus. */
TypUpsVmLong UpsVmAPI (*Aleatoire)(TypUpsVmVoid);
   /* Objet : Tirage d'un nombre aleatoire. */
TypUpsVmDouble UpsVmAPI (*ASin)(TypUpsVmDouble P1);
   /* Objet : Arc sinus. */
TypUpsVmDouble UpsVmAPI (*ATan)(TypUpsVmDouble P1);
   /* Objet : Arc tangente. */
TypUpsVmDouble UpsVmAPI (*Cos)(TypUpsVmDouble P1);
   /* Objet : Cosinus. */
TypUpsVmDouble UpsVmAPI (*CosH)(TypUpsVmDouble P1);
   /* Objet : Cosinus hyperbolique. */
TypUpsVmLong UpsVmAPI (*Double2Long)(TypUpsVmDouble Double);
   /* Objet : Convertit un double en long. */
TypUpsVmShort UpsVmAPI (*DoubleDigit)(TypUpsVmVoid);
   /* Objet : DBL_DIG. */
TypUpsVmDouble UpsVmAPI (*ErreurDouble)(TypUpsVmVoid);
   /* Objet : DBL_EPSILON. */
TypUpsVmDouble UpsVmAPI (*Exp)(TypUpsVmDouble P1);
   /* Objet : Exponentielle de base e. */
TypUpsVmDouble UpsVmAPI (*FMod)(TypUpsVmDouble P1, TypUpsVmDouble P2);
   /* Objet : Reste de la division entire. */
TypUpsVmUnicode UpsVmAPI *(*FormaterDouble)(TypUpsVmDouble Double, TypUpsVmShort TaillePartieReelle, 
   TypUpsVmShort *Decimale, TypUpsVmShort *Signe, TypUpsVmUnicode *Valeur, TypUpsVmLong TailleChaineValeur);
   /* Objet : Fcvt(). */
TypUpsVmDouble UpsVmAPI (*Log)(TypUpsVmDouble P1);
   /* Objet : Logarithme neperien. */
TypUpsVmDouble UpsVmAPI (*Log10)(TypUpsVmDouble P1);
   /* Objet : Logarithme a base 10. */
TypUpsVmDouble UpsVmAPI (*Long2Double)(TypUpsVmLong Long);
   /* Objet : Convertit un long en double. */
TypUpsVmLong UpsVmAPI (*PartieEntiere)(TypUpsVmDouble P1);
   /* Objet : Partie entiere. */
TypUpsVmDouble UpsVmAPI (*Pow)(TypUpsVmDouble P1, TypUpsVmDouble P2);
   /* Objet : Puissance. */
TypUpsVmDouble UpsVmAPI (*Sin)(TypUpsVmDouble P1);
   /* Objet : Sinus. */
TypUpsVmDouble UpsVmAPI (*SinH)(TypUpsVmDouble P1);
   /* Objet : Sinus hyperbolique. */
TypUpsVmDouble UpsVmAPI (*Sqrt)(TypUpsVmDouble P1);
   /* Objet : Racine carree. */
TypUpsVmDouble UpsVmAPI (*Tan)(TypUpsVmDouble P1);
   /* Objet : Tangente. */
TypUpsVmDouble UpsVmAPI (*TanH)(TypUpsVmDouble P1);
   /* Objet : Tangente hyperbolique. */
} *TypUpsMatMachineInterface_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsMatMachineInterface_1_1_0 TypUpsMatMachineInterface;

/****************************************************************/
typedef struct typupsmattraitements_1_1_0
/* Objet: Interface des traitements de Ups Mat.                 */
/****************************************************************/
{
struct typupsvmentetemethodesmodule EnteteMethodesModule;
   /* Methodes generiques au module. */ 

/*--------------------------------------------------------------*/
/* Procedures et fonctions.                                     */
/*--------------------------------------------------------------*/
TypUpsVmLong UpsVmAPI (*CalculerIndexAppel)(TypUpsVmPointeurDonnees InterfaceAppel, TypUpsVmPointeurDonnees AppelCourant);
   /* Objet : Calcule l'index de l'appel. */
TypUpsVmLong UpsVmAPI (*Trt_1_1)(TypUpsVmSession *Session, TypPrmUpsMat_1_1 *UpsPrm);
   /* Objet : Abs(R:Reel). */
TypUpsVmDouble UpsVmAPI (*Trt_1_2)(TypUpsVmSession *Session, TypPrmUpsMat_1_2 *UpsPrm);
   /* Objet : Abs(R:Reel). */
TypUpsVmDouble UpsVmAPI (*Trt_2_1)(TypUpsVmSession *Session, TypPrmUpsMat_2_1 *UpsPrm);
   /* Objet : ACos(R:Reel). */
TypUpsVmDouble UpsVmAPI (*Trt_3_1)(TypUpsVmSession *Session, TypPrmUpsMat_3_1 *UpsPrm);
   /* Objet : ASin(R:Reel). */
TypUpsVmDouble UpsVmAPI (*Trt_4_1)(TypUpsVmSession *Session, TypPrmUpsMat_4_1 *UpsPrm);
   /* Objet : ATan(R:Reel). */
TypUpsVmDouble UpsVmAPI (*Trt_5_1)(TypUpsVmSession *Session, TypPrmUpsMat_5_1 *UpsPrm);
   /* Objet : Cos(R:Reel). */
TypUpsVmDouble UpsVmAPI (*Trt_6_1)(TypUpsVmSession *Session, TypPrmUpsMat_6_1 *UpsPrm);
   /* Objet : Sin(R:Reel). */
TypUpsVmDouble UpsVmAPI (*Trt_7_1)(TypUpsVmSession *Session, TypPrmUpsMat_7_1 *UpsPrm);
   /* Objet : Tan(R:Reel). */
TypUpsVmDouble UpsVmAPI (*Trt_8_1)(TypUpsVmSession *Session, TypPrmUpsMat_8_1 *UpsPrm);
   /* Objet : ACosH(R:Reel). */  
TypUpsVmDouble UpsVmAPI (*Trt_9_1)(TypUpsVmSession *Session, TypPrmUpsMat_9_1 *UpsPrm);
   /* Objet : ASinH(R:Reel). */
TypUpsVmDouble UpsVmAPI (*Trt_10_1)(TypUpsVmSession *Session, TypPrmUpsMat_10_1 *UpsPrm);
   /* Objet : ATanH(R:Reel). */
TypUpsVmDouble UpsVmAPI (*Trt_11_1)(TypUpsVmSession *Session, TypPrmUpsMat_11_1 *UpsPrm);
   /* Objet : CosH(R:Reel). */
TypUpsVmDouble UpsVmAPI (*Trt_12_1)(TypUpsVmSession *Session, TypPrmUpsMat_12_1 *UpsPrm);
   /* Objet : SinH(R:Reel). */
TypUpsVmDouble UpsVmAPI (*Trt_13_1)(TypUpsVmSession *Session, TypPrmUpsMat_13_1 *UpsPrm);
   /* Objet : ATan(R:Reel). */
TypUpsVmDouble UpsVmAPI (*Trt_14_1)(TypUpsVmSession *Session, TypPrmUpsMat_14_1 *UpsPrm);
   /* Objet : Exp(R:Reel). */
TypUpsVmDouble UpsVmAPI (*Trt_15_1)(TypUpsVmSession *Session, TypPrmUpsMat_15_1 *UpsPrm);
   /* Objet : Log(R:Reel). */
TypUpsVmDouble UpsVmAPI (*Trt_16_1)(TypUpsVmSession *Session, TypPrmUpsMat_16_1 *UpsPrm);
   /* Objet : Log10(R:Reel). */
TypUpsVmDouble UpsVmAPI (*Trt_17_1)(TypUpsVmSession *Session, TypPrmUpsMat_17_1 *UpsPrm);
   /* Objet : Racine(E:Entier). */
TypUpsVmDouble UpsVmAPI (*Trt_17_2)(TypUpsVmSession *Session, TypPrmUpsMat_17_2 *UpsPrm);
   /* Objet : Racine(R:Reel). */

TypUpsVmCoAppel CoTrt_1_1;
   /* Objet : Abs(R:Reel). */
TypUpsVmCoAppel CoTrt_1_2;
   /* Objet : Abs(R:Reel). */
TypUpsVmCoAppel CoTrt_2_1;
   /* Objet : ACos(R:Reel). */
TypUpsVmCoAppel CoTrt_3_1;
   /* Objet : ASin(R:Reel). */
TypUpsVmCoAppel CoTrt_4_1;
   /* Objet : ATan(R:Reel). */
TypUpsVmCoAppel CoTrt_5_1;
   /* Objet : Cos(R:Reel). */
TypUpsVmCoAppel CoTrt_6_1;
   /* Objet : Sin(R:Reel). */
TypUpsVmCoAppel CoTrt_7_1;
   /* Objet : Tan(R:Reel). */
TypUpsVmCoAppel CoTrt_8_1;
   /* Objet : ACosH(R:Reel). */  
TypUpsVmCoAppel CoTrt_9_1;
   /* Objet : ASinH(R:Reel). */
TypUpsVmCoAppel CoTrt_10_1;
   /* Objet : ATanH(R:Reel). */
TypUpsVmCoAppel CoTrt_11_1;
   /* Objet : CosH(R:Reel). */
TypUpsVmCoAppel CoTrt_12_1;
   /* Objet : SinH(R:Reel). */
TypUpsVmCoAppel CoTrt_13_1;
   /* Objet : ATan(R:Reel). */
TypUpsVmCoAppel CoTrt_14_1;
   /* Objet : Exp(R:Reel). */
TypUpsVmCoAppel CoTrt_15_1;
   /* Objet : Log(R:Reel). */
TypUpsVmCoAppel CoTrt_16_1;
   /* Objet : Log10(R:Reel). */
TypUpsVmCoAppel CoTrt_17_1;
   /* Objet : Racine(E:Entier). */
TypUpsVmCoAppel CoTrt_17_2;
   /* Objet : Racine(R:Reel). */

/*--------------------------------------------------------------*/
/* Tables des methodes.                                         */
/*--------------------------------------------------------------*/
UpsTrtTypUpsMat_1 *UpsTrt1;
   /* Methodes de Degre. */ 
UpsTrtTypUpsKrn_23 *UpsTrt1_1;
   /* Methodes de Degre.CorpsCommutatif. */ 
UpsTrtTypUpsKrn_22 *UpsTrt1_1_1;
   /* Methodes de Degre.CorpsCommutatif.AlgebreCommutative. */ 
UpsTrtTypUpsKrn_21 *UpsTrt1_2;
   /* Methodes de Degre.EspaceMetre. */ 
UpsTrtTypUpsMat_2 *UpsTrt2;
   /* Methodes de Radian. */ 
UpsTrtTypUpsKrn_23 *UpsTrt2_1;
   /* Methodes de Radian.CorpsCommutatif. */ 
UpsTrtTypUpsKrn_22 *UpsTrt2_1_1;
   /* Methodes de Radian.CorpsCommutatif.AlgebreCommutative. */ 
UpsTrtTypUpsKrn_21 *UpsTrt2_2;
   /* Methodes de Radian.EspaceMetre. */ 

/*--------------------------------------------------------------*/
/* Enumeres.			              				                   */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Entrepots.          								                   */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Types et interfaces.                                         */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*UpsType1_get)(TypUpsVmSession *Session);
   /* Type Degre. */
TypUpsVmLong UpsVmAPI (*UpsIndex1_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Degre. */
TypUpsVmAdresse UpsVmAPI *(*UpsType2_get)(TypUpsVmSession *Session);
   /* Type Radian. */
TypUpsVmLong UpsVmAPI (*UpsIndex2_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Radian. */

/*--------------------------------------------------------------*/
/* Variables globales.                                          */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Exceptions.                                                  */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*UpsException1_get)(TypUpsVmSession *Session);
   /* Exception CalculImpossible. */

/*--------------------------------------------------------------*/
/* Files d'attente.                                             */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Application Program Interfaces proprietaires.                */
/*--------------------------------------------------------------*/
TypUpsMatMachineInterface UpsVmAPI (*LireMachineInterface)(TypUpsVmVoid);
   /* Objet : Retrouve l'interface machine pour Ups Mathematical. */
} *TypUpsMatTraitements_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsMatTraitements_1_1_0 TypUpsMatTraitements;

extern DllExport TypUpsVtmDemarrer UpsVmAPI UpsMatDemarrerModule(TypUpsVmShort Numero, TypUpsVtmMachineInterface MachineInterfaceUpsVtm,
   TypUpsVtmTraitements IntTrtUpsVtm, TypUpsVtmDonnees IntDonUpsVtm);
   /* Objet : Retourne la description de Ups Mat. */

/**********************/
#if defined(__cplusplus)
/**********************/
}
/****/
#endif
/****/

/****/
#endif
/****/
