/*-------------------------------------------------------------------
Fichier     : upskrn_d.e
Objet       : En-tete du module Up ! Kernel - Adaptateur dictionnaire.

Module      : Up ! Kernel
Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.
---------------------------------------------------------------------
                         Observations

 
---------------------------------------------------------------------*/

/******************************/
#if !defined(PasseModuleUpsKrnD)
/******************************/
#define PasseModuleUpsKrnD 1

/**********************/
#if defined(__cplusplus)
/**********************/
extern "C"
{
/****/
#endif
/****/

/****************************************************************/
typedef struct upscotrtupskrn_1_1_1_0
/* Objet : Co-Methodes du type Binaire.                         */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmCoAppel CoMth_4_2;
   /* Constructeur(C:Nul Ou Caractere); */
TypUpsVmCoAppel CoMth_5_1;
   /* Operateur +(B:Nul Ou Binaire) Retourner Nul Ou Binaire; */
TypUpsVmCoAppel CoMth_6_1;
   /* Operateur +=(B:Nul Ou Binaire); */
TypUpsVmCoAppel CoMth_7_1;
   /* Operateur -() Retourner Nul Ou Binaire; */
TypUpsVmCoAppel CoMth_8_1;
   /* Fonction TypUpsVmLongueur() Retourner Entier; */
TypUpsVmCoAppel CoMth_9_1;
   /* Fonction Gauche(Taille:Nul Ou Entier) Retourner Nul Ou Binaire; */
TypUpsVmCoAppel CoMth_10_1;
   /* Fonction Droite(Taille:Nul Ou Entier) Retourner Nul Ou Binaire; */
TypUpsVmCoAppel CoMth_11_1;
   /* Fonction Milieu(Position:Nul Ou Entier, Taille:Nul Ou Entier) Retourner Nul Ou Binaire; */
TypUpsVmCoAppel CoMth_12_1;
   /* Fonction Unicode(Position:Nul Ou Entier) Retourner Nul Ou Entier; */
} UpsCoTrtUpsKrn_1_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsCoTrtUpsKrn_1_1_1_0 UpsCoTrtUpsKrn_1;

/****************************************************************/
typedef struct upscotrtupskrn_2_1_1_0
/* Objet : Co-Methodes du type Caractere.                       */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

/*--------------------------------------------------------------*/
/* Methodes heritees de EspaceMetre.                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_4_1;
   /* Operateur <=(C:Nul Ou Caractere) Retourner Booleen;*/
TypUpsVmCoAppel CoMth_5_1;
   /* Operateur >=(C:Nul Ou Caractere) Retourner Booleen; */
TypUpsVmCoAppel CoMth_6_1;
   /* Operateur <(C:Nul Ou Caractere) Retourner Booleen; */
TypUpsVmCoAppel CoMth_7_1;
   /* Operateur >(C:Nul Ou Caractere) Retourner Booleen; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_8_2;
   /* Constructeur(B:Nul Ou Booleen) */
TypUpsVmCoAppel CoMth_8_3;
   /* Constructeur(D:Nul Ou Date) */
TypUpsVmCoAppel CoMth_8_4;
   /* Constructeur(D:Nul Ou Date, Filtre:Nul Ou Caractere) */
TypUpsVmCoAppel CoMth_8_5;
   /* Constructeur(E:Nul Ou Entier) */
TypUpsVmCoAppel CoMth_8_6;
   /* Constructeur(E:Nul Ou Entier, Filtre:Nul Ou Caractere) */
TypUpsVmCoAppel CoMth_8_7;
   /* Constructeur(E:Nul Ou Entier, Filtre:Nul Ou Caractere, PointVirgule:Nul Ou Caractere) */
TypUpsVmCoAppel CoMth_8_8;
   /* Constructeur(R:Nul Ou Reel) */
TypUpsVmCoAppel CoMth_8_9;
   /* Constructeur(R:Nul Ou Reel, Filtre:Nul Ou Caractere) */
TypUpsVmCoAppel CoMth_8_10;
   /* Constructeur(R:Nul Ou Reel, Filtre:Nul Ou Caractere, PointVirgule:Nul Ou Caractere) */
TypUpsVmCoAppel CoMth_8_11;
   /* Constructeur(B:Nul Ou Binaire) */
TypUpsVmCoAppel CoMth_9_1;
   /* Operateur +(C:Nul Ou Caractere) Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_10_1;
   /* Operateur +=(C:Nul Ou Caractere) Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_11_1;
   /* Operateur -() Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_12_1;
   /* Fonction TypUpsVmLongueur() Retourner Entier; */
TypUpsVmCoAppel CoMth_13_1;
   /* Fonction Gauche(Taille:Nul Ou Entier) Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_14_1;
   /* Fonction Droite(Taille:Nul Ou Entier) Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_15_1;
   /* Fonction Milieu(Position:Nul Ou Entier, Taille:Nul Ou Entier) Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_16_1;
   /* Fonction Unicode(Position:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_17_1;
   /* Fonction Majuscule() Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_18_1;
   /* Fonction MajMinuscule() Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_19_1;
   /* Fonction Minuscule() Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_20_1;
   /* Fonction Inserer(Chaine:Nul Ou Caractere, Position:Nul Ou Entier) Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_21_1;
   /* Compter(Modele:Nul Ou Caractere, Position:Nul Ou Entier=Nul) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_22_1;
   /* Fonction Remplacer(Modele:Nul Ou Caractere, Remplacant:Nul Ou Caractere, Position:Nul Ou Entier=Nul) Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_23_1;
   /* Fonction Ajouter(Taille:Nul Ou Entier, Modele:Nul Ou Caractere=" ") Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_24_1;
   /* Fonction AjouterDroite(Taille:Nul Ou Entier, Modele:Nul Ou Caractere=" ") Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_25_1;
   /* Fonction AjouterGauche(Taille:Nul Ou Entier, Modele:Nul Ou Caractere=" ") Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_26_1;
   /* Fonction Supprimer(Modele:Nul Ou Caractere=" ") Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_27_1;
   /* Fonction SupprimerDroite(Modele:Nul Ou Caractere=" ") Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_28_1;
   /* Fonction SupprimerGauche(Modele:Nul Ou Caractere=" ") Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_29_1;
   /* Fonction Rechercher(Modele:Nul Ou Caractere, Position:Nul Ou Entier=Nul) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_30_1;
   /* Fonction IdentiqueMajMin(Chaine:Nul Ou Caractere) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_31_1;
   /* Operateur Comme(C:Nul Ou Caractere) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_32_1;
   /* Operateur IlExisteJoker() Retourner Nul Ou Booleen; */
} UpsCoTrtUpsKrn_2_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsCoTrtUpsKrn_2_1_1_0 UpsCoTrtUpsKrn_2;

/****************************************************************/
typedef struct upscotrtupskrn_3_1_1_0
/* Objet : Co-Methodes du type Date.                            */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

/*--------------------------------------------------------------*/
/* Methodes heritees de EspaceMetre.                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_4_1;
   /* Operateur <=(D:Date) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_5_1;
   /* Operateur >=(D:Date) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_6_1;
   /* Operateur <(D:Date) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_7_1;
   /* Operateur >(D:Date) Retourner Nul Ou Booleen; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_8_2;
   /* Constructeur(D:Nul Ou Caractere) */
TypUpsVmCoAppel CoMth_8_3;
   /* Constructeur(J:Nul Ou Entier, M:Nul Ou Entier, A:Nul Ou Entier) */
TypUpsVmCoAppel CoMth_8_4;
   /* Constructeur(J:Nul Ou Entier, M:Nul Ou Entier, A:Nul Ou Entier, H:Nul Ou Entier, Mi:Nul Ou Entier, S:Nul Ou Entier) */
TypUpsVmCoAppel CoMth_8_5;
   /* Constructeur(J:Nul Ou Entier, M:Nul Ou Entier, A:Nul Ou Entier, H:Nul Ou Entier, Mi:Nul Ou Entier, S:Nul Ou Entier, Ms:Nul Ou Entier) */
TypUpsVmCoAppel CoMth_9_1;
   /* Operateur +(S:Nul Ou Entier) Retourner Nul Ou Date; */
TypUpsVmCoAppel CoMth_10_1;
   /* Operateur +=(S:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_11_1;
   /* Operateur -(S:Nul Ou Entier) Retourner Nul Ou Date; */
TypUpsVmCoAppel CoMth_11_2;
   /* Operateur -(D:Nul Ou Date) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_12_1;
   /* Operateur -=(S:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_13_1;
   /* Fonction AjouterJours(J:Nul Ou Entier) Retourner Nul Ou Date; */
TypUpsVmCoAppel CoMth_14_1;
   /* Fonction AjouterMois(M:Nul Ou Entier) Retourner Nul Ou Date; */
TypUpsVmCoAppel CoMth_15_1;
   /* Fonction AjouterAnnees(A:Nul Ou Entier) Retourner Nul Ou Date; */
TypUpsVmCoAppel CoMth_16_1;
   /* Fonction AjouterHeures(H:Nul Ou Entier) Retourner Nul Ou Date; */
TypUpsVmCoAppel CoMth_17_1;
   /* Fonction AjouterMinutes(Mi:Nul Ou Entier) Retourner Nul Ou Date; */
TypUpsVmCoAppel CoMth_18_1;
   /* Fonction AjouterMilliemes(Ms:Nul Ou Entier) Retourner Nul Ou Date; */
TypUpsVmCoAppel CoMth_19_1;
   /* Fonction DernierJour() Retourner Nul Ou Date; */
} UpsCoTrtUpsKrn_3_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsCoTrtUpsKrn_3_1_1_0 UpsCoTrtUpsKrn_3;

/****************************************************************/
typedef struct upscotrtupskrn_4_1_1_0
/* Objet : Co-Methodes du type Entier.                          */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

/*--------------------------------------------------------------*/
/* Methodes heritees de AlgebreCommutative.                     */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_1_1;
   /* Operateur +(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_2_1;
   /* Operateur -() Retourner Nul Ou CorpsCommutatif; */
TypUpsVmCoAppel CoMth_2_2;
   /* Operateur -(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_3_1;
   /* Operateur *(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_4_1;
   /* Operateur ++(B:Booleen) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_5_1;
   /* Operateur --(B:Booleen) Retourner Nul Ou Entier; */
/*--------------------------------------------------------------*/
/* Methodes heritees de EspaceMetre.                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_9_1;
   /* Operateur <=(E:Entier) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_10_1;
   /* Operateur >=(E:Entier) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_11_1;
   /* Operateur <(E:Entier) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_12_1;
   /* Operateur >(E:Entier) Retourner Nul Ou Booleen; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_13_1;
   /* Operateur +=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_14_1;
   /* Operateur -=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_15_1;
   /* Operateur *=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_16_2;
   /* Constructeur(R:Nul Ou Reel); */
TypUpsVmCoAppel CoMth_16_3;
   /* Constructeur(C:Nul Ou Caractere); */
TypUpsVmCoAppel CoMth_1_2;
   /* Operateur +(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_2_3;
   /* Operateur -(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_3_2;
   /* Operateur *(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_17_1;
   /* Operateur /(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_17_2;
   /* Operateur /(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_18_1;
   /* Operateur \(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_18_2;
   /* Operateur \(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_19_1;
   /* Operateur \=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_19_2;
   /* Operateur \=(R:Nul Ou Reel); */
TypUpsVmCoAppel CoMth_20_1;
   /* Operateur %(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_21_1;
   /* Operateur %=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_22_1;
   /* Operateur ^(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_22_2;
   /* Operateur ^(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_23_1;
   /* Operateur ^=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_24_1;
   /* Operateur &(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_25_1;
   /* Operateur &=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_26_1;
   /* Operateur |(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_27_1;
   /* Operateur |=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_28_1;
   /* Operateur <<(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_29_1;
   /* Operateur <<=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_30_1;
   /* Operateur >>(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_31_1;
   /* Operateur >>=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_7_2;
   /* Operateur ==(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_8_2;
   /* Operateur !=(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_9_2;
   /* Operateur <=(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_10_2;
   /* Operateur >=(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_11_2;
   /* Operateur <(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_12_2;
   /* Operateur >(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_32_1;
   /* Fonction Unicode() Retourner Nul Ou Caractere; */
} UpsCoTrtUpsKrn_4_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsCoTrtUpsKrn_4_1_1_0 UpsCoTrtUpsKrn_4;

/****************************************************************/
typedef struct upscotrtupskrn_5_1_1_0
/* Objet : Co-Methodes du type Enumere.                         */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

/*--------------------------------------------------------------*/
/* Methodes heritees de EspaceMetre.                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_4_1;
   /* Operateur <=(E:Nul Ou Enumere) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_5_1;
   /* Operateur >=(E:Nul Ou Enumere) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_6_1;
   /* Operateur <(E:Nul Ou Enumere) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_7_1;
   /* Operateur >(E:Nul Ou Enumere) Retourner Nul Ou Booleen; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
} UpsCoTrtUpsKrn_5_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsCoTrtUpsKrn_5_1_1_0 UpsCoTrtUpsKrn_5;

/****************************************************************/
typedef struct upscotrtupskrn_6_1_1_0
/* Objet : Co-Methodes du type Exception.                       */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmCoAppel CoMth_4_1;
   /* Procedure Envoyer(P1:Nul Ou Caractere=Nul, P2:Nul Ou Caractere=Nul, */
   /* P3:Nul Ou Caractere=Nul, P4:Nul Ou Caractere=Nul, P5:Nul Ou Caractere=Nul); */
TypUpsVmCoAppel CoMth_5_1;
   /* Procedure Renvoyer(); */
} UpsCoTrtUpsKrn_6_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsCoTrtUpsKrn_6_1_1_0 UpsCoTrtUpsKrn_6;

/****************************************************************/
typedef struct upscotrtupskrn_7_1_1_0
/* Objet : Co-Methodes du type Objet.                           */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmCoAppel CoMth_4_1;
   /* Fonction Identique(O:Nul Ou Objet) Retourner Booleen; */
TypUpsVmCoAppel CoMth_5_1;
   /* Procedure Convertir(O:Nul Ou Objet); */
TypUpsVmCoAppel CoMth_6_1;
   /* Fonction CreeParLeServeur() Retourner Entier; */
TypUpsVmCoAppel CoMth_7_1;
   /* Fonction CreeParLeProcessus() Retourner Entier; */
TypUpsVmCoAppel CoMth_8_1;
   /* Fonction CreeDansLEntrepot() Retourner Entrepot; */
} UpsCoTrtUpsKrn_7_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsCoTrtUpsKrn_7_1_1_0 UpsCoTrtUpsKrn_7;

/****************************************************************/
typedef struct upscotrtupskrn_8_1_1_0
/* Objet : Co-Methodes du type Reel.                            */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

/*--------------------------------------------------------------*/
/* Methodes heritees de AlgebreCommutative.                     */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_1_1;
   /* Operateur +(R:Nul Ou Reel) Retourner Ou Reel; */
TypUpsVmCoAppel CoMth_2_1;
   /* Operateur -() Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_2_2;
   /* Operateur -(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_3_1;
   /* Operateur *(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_4_1;
   /* Operateur ++(B:Booleen) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_5_1;
   /* Operateur --(B:Booleen) Retourner Nul Ou Reel; */
/*--------------------------------------------------------------*/
/* Methodes heritees de CorpsCommutative.                      */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_6_1;
   /* Operateur /(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_7_1;
   /* Operateur ^(R:Nul Ou Reel) Retourner Nul Ou Reel; */
/*--------------------------------------------------------------*/
/* Methodes heritees de EspaceMetre.                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_11_1;
   /* Operateur <=(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_12_1;
   /* Operateur >=(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_13_1;
   /* Operateur <(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_14_1;
   /* Operateur >(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_15_1;
   /* Operateur +=(R:Nul Ou Reel); */
TypUpsVmCoAppel CoMth_16_1;
   /* Operateur -=(R:Nul Ou Reel); */
TypUpsVmCoAppel CoMth_17_1;
   /* Operateur *=(R:Nul Ou Reel); */
TypUpsVmCoAppel CoMth_18_1;
   /* Operateur /=(R:Nul Ou Reel); */
TypUpsVmCoAppel CoMth_19_1;
   /* Operateur ^=(R:Nul Ou Reel); */
TypUpsVmCoAppel CoMth_20_2;
   /* Constructeur(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_20_3;
   /* Constructeur(C:Nul Ou Caractere); */
TypUpsVmCoAppel CoMth_8_2;
   /* Operateur =(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_9_2;
   /* Operateur ==(E:Nul Ou Entier) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_10_2;
   /* Operateur !=(E:Nul Ou Entier) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_11_2;
   /* Operateur <=(E:Nul Ou Entier) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_12_2;
   /* Operateur >=(E:Nul Ou Entier) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_13_2;
   /* Operateur <(E:Nul Ou Entier) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_14_2;
   /* Operateur >(E:Nul Ou Entier) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_1_2;
   /* Operateur +(E:Nul Ou Entier) Retourner Reel; */
TypUpsVmCoAppel CoMth_15_2;
   /* Operateur +=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_2_3;
   /* Operateur -(E:Nul Ou Entier) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_16_2;
   /* Operateur -=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_3_2;
   /* Operateur *(E:Nul Ou Entier) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_17_2;
   /* Operateur *=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_6_2;
   /* Operateur /(E:Nul Ou Entier) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_18_2;
   /* Operateur /=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_7_2;
   /* Operateur ^(E:Nul Ou Entier) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_19_2;
   /* Operateur ^=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_21_1;
   /* Operateur \(R:Nul Ou Reel) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_21_2;
   /* Operateur \(E:Nul Ou Entier) Retourner Nul Ou Entier; */
} UpsCoTrtUpsKrn_8_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsCoTrtUpsKrn_8_1_1_0 UpsCoTrtUpsKrn_8;

/****************************************************************/
typedef struct upscotrtupskrn_9_1_1_0
/* Objet : Co-Methodes du type Type.                            */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmCoAppel CoMth_4_1;
   /* Fonction NouvelObjet() Retourner Objet; */
TypUpsVmCoAppel CoMth_5_1;
   /* Fonction EnumererObjets(O:Nul Ou Objet) Retourner Nul Ou Objet; */
TypUpsVmCoAppel CoMth_6_1;
   /* Fonction EnumererMethodes(Numero:Entier, NomAppel:Nul Ou Caractere Sortie, Aide:Nul Ou Caractere Sortie) Retourner Nul Ou Appel; */
TypUpsVmCoAppel CoMth_7_1;
   /* Procedure ActiverContrainte(A:ActiviteContrainte); */
} UpsCoTrtUpsKrn_9_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsCoTrtUpsKrn_9_1_1_0 UpsCoTrtUpsKrn_9;

/****************************************************************/
typedef struct upscotrtupskrn_10_1_1_0
/* Objet : Co-Methodes du type Liste.                           */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

/*--------------------------------------------------------------*/
/* Methodes heritees de Iterateur.                              */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_4_1;
   /* Fonction ParcoursAuDebut(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_5_1;
   /* Fonction ParcoursALaFin(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_6_1;
   /* Fonction ParcoursAuMilieu(Position:Nul Ou Entier, Iterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_7_1;
   /* Fonction Suivant(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_8_1;
   /* Fonction Precedent(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_9_1;
   /* Fonction PremierElement() Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_10_1;
   /* Fonction DernierElement() Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_11_1;
   /* Fonction NumeroElement(NumeroIterateur : Entier=0) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_12_1;
   /* Fonction Element(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_13_1;
   /* Fonction AllouerIterateur() Retourner Entier; */
TypUpsVmCoAppel CoMth_14_1;
   /* Procedure LibererIterateur(NumeroIterateur : Entier); */
/*--------------------------------------------------------------*/
/* Methodes heritees de Collection.                             */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_15_1;
   /* Fonction Gauche(Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_16_1;
   /* Fonction Droite(Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_17_1;
   /* Fonction Milieu(Position:Nul Ou Entier, Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_18_1;
   /* Fonction Inserer(L:Nul Ou Collection, Position:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_19_1;
   /* Fonction Compter(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_20_1;
   /* Fonction Rechercher(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_21_1;
   /* Procedure Supprimer(NumeroIterateur : Entier=0); */
TypUpsVmCoAppel CoMth_22_1;
   /* Procedure Remplacer(Remplacant:Nul Ou TypeElement, NumeroIterateur : Entier=0); */
TypUpsVmCoAppel CoMth_23_1;
   /* Fonction RemplacerTous(Modele:Nul Ou TypeElement, Remplacant:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_24_1;
   /* Fonction SupprimerTous(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_25_1;
   /* Fonction AjouterAuDebut(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_26_1;
   /* Fonction AjouterALaFin(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_27_1;
   /* Operateur +(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_28_1;
   /* Operateur +=(O:Nul Ou TypeElement); */
TypUpsVmCoAppel CoMth_29_1;
   /* Operateur [](Position:Nul Ou Entier) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_29_2;
   /* Operateur [](Position:Nul Ou Entier, Valeur:Nul Ou TypeElement, MethodeAComposer:Nul Ou Appel=Nul); */
TypUpsVmCoAppel CoMth_29_3;
   /* Operateur [](Position:Nul Ou Entier, Prefixe:Booleen, Methode:Nul Ou Appel) Retourner Nul Ou TypeElement; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_30_1;
   /* Constructeur(O:Nul Ou TypeElement); */
TypUpsVmCoAppel CoMth_31_1;
   /* Operateur -() Retourner Nul Ou Liste; */
TypUpsVmCoAppel CoMth_32_1;
   /* Fonction Union(L:Nul Ou Liste) Retourner Nul Ou Liste; */
TypUpsVmCoAppel CoMth_33_1;
   /* Fonction Intersection(L:Nul Ou Liste) Retourner Nul Ou Liste; */
TypUpsVmCoAppel CoMth_34_1;
   /* Fonction Soustraction(L:Nul Ou Liste) Retourner Nul Ou Liste; */
TypUpsVmCoAppel CoMth_35_1;
   /* Fonction Exclusion(L:Nul Ou Liste) Retourner Nul Ou Liste; */
TypUpsVmCoAppel CoMth_36_1;
   /* Fonction Trier(Critere:Fonction(O1:Nul Ou TypeElement, O2:Nul Ou TypeElement) Retourner ComparaisonObjet,
      Ascendant:Booleen=Vrai) Retourner Nul Ou Liste; */
TypUpsVmCoAppel CoMth_37_1;
   /* Procedure Appliquer(Traitement:Procedure (O:Nul Ou TypeElement)); */
TypUpsVmCoAppel CoMth_37_2;
   /* Procedure Appliquer(Traitement:Procedure (O1:Nul Ou TypeElement, O2:Nul Ou TypeElement), L:Nul Ou Liste); */
TypUpsVmCoAppel CoMth_37_3;
   /* Fonction Appliquer(Traitement:Fonction (O:Nul Ou TypeElement) Retourner Nul Ou TypeElement) Retourner Nul Ou Liste; */
TypUpsVmCoAppel CoMth_37_4;
   /* Fonction Appliquer(Traitement:Fonction (O1:Nul Ou TypeElement, O2:Nul Ou TypeElement) Retourner Nul Ou TypeElement, L:Nul Ou Liste) Retourner Nul Ou Liste; */
TypUpsVmCoAppel CoMth_38_1;
   /* Fonction Filtrer(Critere:Fonction (O:Nul Ou TypeElement) Retourner Nul Ou Booleen) Retourner Nul Ou Liste; */
TypUpsVmCoAppel CoMth_39_1;
   /* Fonction Grouper(Critere:Fonction(O1:Nul Ou Objet, O2:Nul Ou TypeElement) Retourner ComparaisonObjet) Retourner Nul Ou Liste; */
} UpsCoTrtUpsKrn_10_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsCoTrtUpsKrn_10_1_1_0 UpsCoTrtUpsKrn_10;

/****************************************************************/
typedef struct upscotrtupskrn_11_1_1_0
/* Objet : Co-Methodes du type Reference.                       */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmCoAppel CoMth_4_1;
   /* Constructeur(O:Nul Ou Objet); */
} UpsCoTrtUpsKrn_11_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsCoTrtUpsKrn_11_1_1_0 UpsCoTrtUpsKrn_11;

/****************************************************************/
typedef struct upscotrtupskrn_12_1_1_0
/* Objet : Co-Methodes du type Tableau.                         */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

/*--------------------------------------------------------------*/
/* Methodes heritees de Iterateur.                              */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_4_1;
   /* Fonction ParcoursAuDebut(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_5_1;
   /* Fonction ParcoursALaFin(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_6_1;
   /* Fonction ParcoursAuMilieu(Position:Nul Ou Entier, Iterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_7_1;
   /* Fonction Suivant(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_8_1;
   /* Fonction Precedent(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_9_1;
   /* Fonction PremierElement() Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_10_1;
   /* Fonction DernierElement() Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_11_1;
   /* Fonction NumeroElement(NumeroIterateur : Entier=0) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_12_1;
   /* Fonction Element(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_13_1;
   /* Fonction AllouerIterateur() Retourner Entier; */
TypUpsVmCoAppel CoMth_14_1;
   /* Procedure LibererIterateur(NumeroIterateur : Entier); */
/*--------------------------------------------------------------*/
/* Methodes heritees de Collection.                             */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_15_1;
   /* Fonction Gauche(Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_16_1;
   /* Fonction Droite(Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_17_1;
   /* Fonction Milieu(Position:Nul Ou Entier, Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_18_1;
   /* Fonction Inserer(L:Nul Ou Collection, Position:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_19_1;
   /* Fonction Compter(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_20_1;
   /* Fonction Rechercher(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_21_1;
   /* Procedure Supprimer(NumeroIterateur : Entier=0); */
TypUpsVmCoAppel CoMth_22_1;
   /* Procedure Remplacer(Remplacant:Nul Ou TypeElement, NumeroIterateur : Entier=0); */
TypUpsVmCoAppel CoMth_23_1;
   /* Fonction RemplacerTous(Modele:Nul Ou TypeElement, Remplacant:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_24_1;
   /* Fonction SupprimerTous(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_25_1;
   /* Fonction AjouterAuDebut(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_26_1;
   /* Fonction AjouterALaFin(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_27_1;
   /* Operateur +(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_28_1;
   /* Operateur +=(O:Nul Ou TypeElement); */
TypUpsVmCoAppel CoMth_29_1;
   /* Operateur [](Position:Nul Ou Entier) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_29_2;
   /* Operateur [](Position:Nul Ou Entier, Valeur:Nul Ou TypeElement, MethodeAComposer:Nul Ou Appel=Nul); */
TypUpsVmCoAppel CoMth_29_3;
   /* Operateur [](Position:Nul Ou Entier, Prefixe:Booleen, Methode:Nul Ou Appel) Retourner Nul Ou TypeElement; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_30_1;
   /* Constructeur(NbElements : Entier, O : Nul Ou TypeElement); */
TypUpsVmCoAppel CoMth_30_2;
   /* Constructeur(BMin : Entier, BMax : Entier, O : Nul Ou TypeElement); */
TypUpsVmCoAppel CoMth_31_1;
   /* Procedure Retailler(NbElements : Entier, O : Nul Ou TypeElement) Retourner Nul Ou Tableau; */
TypUpsVmCoAppel CoMth_31_2;
   /* Procedure Retailler(BMin : Entier, BMax : Entier, O : Nul Ou TypeElement) Retourner Nul Ou Tableau; */
} UpsCoTrtUpsKrn_12_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsCoTrtUpsKrn_12_1_1_0 UpsCoTrtUpsKrn_12;

/****************************************************************/
typedef struct upscotrtupskrn_13_1_1_0
/* Objet : Co-Methodes du type ArbreBinaire.                    */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

/*--------------------------------------------------------------*/
/* Methodes heritees de Iterateur.                              */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_4_1;
   /* Fonction ParcoursAuDebut(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_5_1;
   /* Fonction ParcoursALaFin(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_6_1;
   /* Fonction ParcoursAuMilieu(Position:Nul Ou Entier, Iterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_7_1;
   /* Fonction Suivant(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_8_1;
   /* Fonction Precedent(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_9_1;
   /* Fonction PremierElement() Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_10_1;
   /* Fonction DernierElement() Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_11_1;
   /* Fonction NumeroElement(NumeroIterateur : Entier=0) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_12_1;
   /* Fonction Element(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_13_1;
   /* Fonction AllouerIterateur() Retourner Entier; */
TypUpsVmCoAppel CoMth_14_1;
   /* Procedure LibererIterateur(NumeroIterateur : Entier); */
/*--------------------------------------------------------------*/
/* Methodes heritees de Collection.                             */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_15_1;
   /* Fonction Gauche(Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_16_1;
   /* Fonction Droite(Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_17_1;
   /* Fonction Milieu(Position:Nul Ou Entier, Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_18_1;
   /* Fonction Inserer(L:Nul Ou Collection, Position:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_19_1;
   /* Fonction Compter(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_20_1;
   /* Fonction Rechercher(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_21_1;
   /* Procedure Supprimer(NumeroIterateur : Entier=0); */
TypUpsVmCoAppel CoMth_22_1;
   /* Procedure Remplacer(Remplacant:Nul Ou TypeElement, NumeroIterateur : Entier=0); */
TypUpsVmCoAppel CoMth_23_1;
   /* Fonction RemplacerTous(Modele:Nul Ou TypeElement, Remplacant:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_24_1;
   /* Fonction SupprimerTous(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_25_1;
   /* Fonction AjouterAuDebut(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_26_1;
   /* Fonction AjouterALaFin(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_27_1;
   /* Operateur +(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_28_1;
   /* Operateur +=(O:Nul Ou TypeElement); */
TypUpsVmCoAppel CoMth_29_1;
   /* Operateur [](Position:Nul Ou Entier) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_29_2;
   /* Operateur [](Position:Nul Ou Entier, Valeur:Nul Ou TypeElement, MethodeAComposer:Nul Ou Appel=Nul); */
TypUpsVmCoAppel CoMth_29_3;
   /* Operateur [](Position:Nul Ou Entier, Prefixe:Booleen, Methode:Nul Ou Appel) Retourner Nul Ou TypeElement; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_30_1;
   /* Constructeur(Comparaison:Nul Ou Appel, Unique:Booleen); */
TypUpsVmCoAppel CoMth_31_1;
   /* Fonction Union(L:Nul Ou ArbreBinaire) Retourner Nul Ou ArbreBinaire; */
TypUpsVmCoAppel CoMth_32_1;
   /* Fonction Intersection(L:Nul Ou ArbreBinaire) Retourner Nul Ou ArbreBinaire; */
TypUpsVmCoAppel CoMth_33_1;
   /* Fonction Soustraction(L:Nul Ou ArbreBinaire) Retourner Nul Ou ArbreBinaire; */
TypUpsVmCoAppel CoMth_34_1;
   /* Exclusion(L:Nul Ou ArbreBinaire) Retourner Nul Ou ArbreBinaire; */
TypUpsVmCoAppel CoMth_35_1;
   /* Fonction SuivantGroupe(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_36_1;
   /* Fonction PrecedentGroupe(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_37_1;
   /* Fonction NbElementsGroupe(NumeroIterateur:Entier=0) Retourner Entier; */
TypUpsVmCoAppel CoMth_38_1;
   /* Fonction PremierElementGroupe(NumeroIterateur:Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_39_1;
   /* Fonction DernierElementGroupe(NumeroIterateur:Entier=0) Retourner Nul Ou TypeElement; */
} UpsCoTrtUpsKrn_13_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsCoTrtUpsKrn_13_1_1_0 UpsCoTrtUpsKrn_13;

/****************************************************************/
typedef struct upscotrtupskrn_14_1_1_0
/* Objet : Co-Methodes du type Entrepot.                       */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmCoAppel CoMth_4_1;
   /* Fonction TailleMemoireAllouee() Retourner Entier; */
TypUpsVmCoAppel CoMth_5_1;
   /* Fonction TailleMemoireTotale() Retourner Entier; */
TypUpsVmCoAppel CoMth_6_1;
   /* Fonction TailleFichierEchangeAlloue() Retourner Entier; */
TypUpsVmCoAppel CoMth_7_1;
   /* Fonction TailleFichierEchangeTotal() Retourner Entier; */
TypUpsVmCoAppel CoMth_8_1;
   /* Fonction NbVerrousPoses() Retourner Entier; */
TypUpsVmCoAppel CoMth_9_1;
   /* Fonction NbVerrousTotal() Retourner Entier; */
TypUpsVmCoAppel CoMth_10_1;
   /* Fonction NbObjetsAlloues() Retourner Entier; */
TypUpsVmCoAppel CoMth_11_1;
   /* Procedure ChangerEtat(NouvelEtat:EtatEntrepot); */
TypUpsVmCoAppel CoMth_12_1;
   /* Fonction Etat() Retourner EtatEntrepot; */
} UpsCoTrtUpsKrn_14_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsCoTrtUpsKrn_14_1_1_0 UpsCoTrtUpsKrn_14;

/****************************************************************/
typedef struct upscotrtupskrn_15_1_1_0
/* Objet : Co-Methodes du type Module.                          */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmCoAppel CoMth_4_1;
   /* Constructeur(ModuleACharger:Caractere, VersionDuModule:Entier, RevisionDuModule:Entier, */
   /* CorrectionDuModule:Entier); */
TypUpsVmCoAppel CoMth_5_1;
   /* Fonction NouvelObjet(InterfaceAImplementer : Type) Retourner Objet; */
TypUpsVmCoAppel CoMth_6_1;
   /* Fonction EnumererEnumere(Numero:Entier, Aide:Nul Ou Caractere Sortie) Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_7_1;
   /* Fonction EnumererValeurEnumere(NomEnumere:Caractere, Numero:Entier, Aide:Nul Ou Caractere Sortie) Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_8_1;
   /* Fonction EnumererEntrepots(Numero:Entier, Aide:Nul Ou Caractere Sortie) Retourner Nul Ou Entrepot; */
TypUpsVmCoAppel CoMth_9_1;
   /* Fonction EnumererTypes(Numero:Entier, Aide:Nul Ou Caractere Sortie) Retourner Nul Ou Type; */
TypUpsVmCoAppel CoMth_10_1;
   /* Fonction EnumererVariables(Numero:Entier, TypeVariable : Nul Ou Type, PeutEtreNul : Booleen, Aide:Nul Ou Caractere Sortie, NomEnumere : Nul Ou Caractere) Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_11_1;
   /* Fonction EnumererExceptions(Numero:Entier, Aide:Nul Ou Caractere Sortie) Retourner Nul Ou Exception; */
TypUpsVmCoAppel CoMth_12_1;
   /* Fonction EnumererAppels(Numero:Entier, Aide:Nul Ou Caractere Sortie) Retourner Nul Ou Appel; */
TypUpsVmCoAppel CoMth_13_1;
   /* Procedure EcrireVariable(NomVariable : Nul Ou UpsKrnCaractere, ValeurVariable : Nul Ou Objet); */
TypUpsVmCoAppel CoMth_14_1;
   /* Fonction LireVariable(NomVariable : Nul Ou UpsKrnCaractere) Retourner Nul Ou Objet; */
TypUpsVmCoAppel CoMth_15_1;
   /* Fonction IncrementerDecrementerVariable(NomVariable : Nul Ou Caractere, Incrementer:Booleen, Prefixe:Booleen) Retourner Nul Ou Objet; */
} UpsCoTrtUpsKrn_15_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsCoTrtUpsKrn_15_1_1_0 UpsCoTrtUpsKrn_15;

/****************************************************************/
typedef struct upscotrtupskrn_16_1_1_0
/* Objet : Co-Methodes du type Appel.                           */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmCoAppel CoMth_4_1;
   /* Fonction EnumererParametres(Numero:Entier, TypeParametre : Nul Ou Type, PeutEtreNul : Booleen, 
      Aide:Nul Ou Caractere Sortie, NomEnumere : Nul Ou Caractere) Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_5_1;
   /* Procedure ExecuterProcedure(Parametres:Nul Ou ListeDe Nul Ou Objet Entree Sortie); */
TypUpsVmCoAppel CoMth_6_1;
   /* Fonction ExecuterFonction(Parametres:Nul Ou ListeDe Nul Ou Objet Entree Sortie) Retourner Nul Ou Objet; */
} UpsCoTrtUpsKrn_16_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsCoTrtUpsKrn_16_1_1_0 UpsCoTrtUpsKrn_16;

/****************************************************************/
typedef struct upscotrtupskrn_17_1_1_0
/* Objet : Methodes du type Transaction.                        */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmCoAppel CoMth_4_1;
   /* Constructeur(NomDeLaTransaction:Caractere); */ 
TypUpsVmCoAppel CoMth_5_1;
   /* Procedure Valider(); */
TypUpsVmCoAppel CoMth_6_1;
   /* Procedure Invalider(); */
} UpsCoTrtUpsKrn_17_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsCoTrtUpsKrn_17_1_1_0 UpsCoTrtUpsKrn_17;

/****************************************************************/
typedef struct upscotrtupskrn_18_1_1_0
/* Objet : Co-Methodes du type Octet.                           */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

/*--------------------------------------------------------------*/
/* Methodes heritees de AlgebreCommutative.                     */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_1_1;
   /* Operateur +(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_2_1;
   /* Operateur -() Retourner Nul Ou CorpsCommutatif; */
TypUpsVmCoAppel CoMth_2_2;
   /* Operateur -(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_3_1;
   /* Operateur *(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_4_1;
   /* Operateur ++(B:Booleen) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_5_1;
   /* Operateur --(B:Booleen) Retourner Nul Ou Entier; */
/*--------------------------------------------------------------*/
/* Methodes heritees de EspaceMetre.                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_9_1;
   /* Operateur <=(E:Entier) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_10_1;
   /* Operateur >=(E:Entier) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_11_1;
   /* Operateur <(E:Entier) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_12_1;
   /* Operateur >(E:Entier) Retourner Nul Ou Booleen; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_13_1;
   /* Operateur +=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_14_1;
   /* Operateur -=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_15_1;
   /* Operateur *=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_16_2;
   /* Constructeur(R:Nul Ou Reel); */
TypUpsVmCoAppel CoMth_16_3;
   /* Constructeur(C:Nul Ou Caractere); */
TypUpsVmCoAppel CoMth_1_2;
   /* Operateur +(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_2_3;
   /* Operateur -(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_3_2;
   /* Operateur *(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_17_1;
   /* Operateur /(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_17_2;
   /* Operateur /(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_18_1;
   /* Operateur \(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_18_2;
   /* Operateur \(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_19_1;
   /* Operateur \=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_19_2;
   /* Operateur \=(R:Nul Ou Reel); */
TypUpsVmCoAppel CoMth_20_1;
   /* Operateur %(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_21_1;
   /* Operateur %=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_22_1;
   /* Operateur ^(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_22_2;
   /* Operateur ^(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_23_1;
   /* Operateur ^=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_24_1;
   /* Operateur &(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_25_1;
   /* Operateur &=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_26_1;
   /* Operateur |(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_27_1;
   /* Operateur |=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_28_1;
   /* Operateur <<(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_29_1;
   /* Operateur <<=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_30_1;
   /* Operateur >>(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_31_1;
   /* Operateur >>=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_7_2;
   /* Operateur ==(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_8_2;
   /* Operateur !=(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_9_2;
   /* Operateur <=(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_10_2;
   /* Operateur >=(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_11_2;
   /* Operateur <(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_12_2;
   /* Operateur >(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_32_1;
   /* Fonction Unicode() Retourner Nul Ou Caractere; */
} UpsCoTrtUpsKrn_18_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsCoTrtUpsKrn_18_1_1_0 UpsCoTrtUpsKrn_18;

/****************************************************************/
typedef struct upscotrtupskrn_19_1_1_0
/* Objet : Co-methodes de l'interface Iterateur.                */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmCoAppel CoMth_4_1;
   /* Fonction ParcoursAuDebut(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_5_1;
   /* Fonction ParcoursALaFin(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_6_1;
   /* Fonction ParcoursAuMilieu(Position:Nul Ou Entier, Iterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_7_1;
   /* Fonction Suivant(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_8_1;
   /* Fonction Precedent(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_9_1;
   /* Fonction PremierElement() Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_10_1;
   /* Fonction DernierElement() Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_11_1;
   /* Fonction NumeroElement(NumeroIterateur : Entier=0) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_12_1;
   /* Fonction Element(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_13_1;
   /* Fonction AllouerIterateur() Retourner Entier; */
TypUpsVmCoAppel CoMth_14_1;
   /* Procedure LibererIterateur(NumeroIterateur : Entier); */
} UpsCoTrtUpsKrn_19_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsCoTrtUpsKrn_19_1_1_0 UpsCoTrtUpsKrn_19;

/****************************************************************/
typedef struct upscotrtupskrn_20_1_1_0
/* Objet : Co-methodes de l'interface Collection.               */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

/*--------------------------------------------------------------*/
/* Methodes heritees de Iterateur.                              */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_4_1;
   /* Fonction ParcoursAuDebut(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_5_1;
   /* Fonction ParcoursALaFin(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_6_1;
   /* Fonction ParcoursAuMilieu(Position:Nul Ou Entier, Iterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_7_1;
   /* Fonction Suivant(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_8_1;
   /* Fonction Precedent(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_9_1;
   /* Fonction PremierElement() Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_10_1;
   /* Fonction DernierElement() Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_11_1;
   /* Fonction NumeroElement(NumeroIterateur : Entier=0) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_12_1;
   /* Fonction Element(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_13_1;
   /* Fonction AllouerIterateur() Retourner Entier; */
TypUpsVmCoAppel CoMth_14_1;
   /* Procedure LibererIterateur(NumeroIterateur : Entier); */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_15_1;
   /* Fonction Gauche(Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_16_1;
   /* Fonction Droite(Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_17_1;
   /* Fonction Milieu(Position:Nul Ou Entier, Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_18_1;
   /* Fonction Inserer(L:Nul Ou Collection, Position:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_19_1;
   /* Fonction Compter(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_20_1;
   /* Fonction Rechercher(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_21_1;
   /* Procedure Supprimer(NumeroIterateur : Entier=0); */
TypUpsVmCoAppel CoMth_22_1;
   /* Procedure Remplacer(Remplacant:Nul Ou TypeElement, NumeroIterateur : Entier=0); */
TypUpsVmCoAppel CoMth_23_1;
   /* Fonction RemplacerTous(Modele:Nul Ou TypeElement, Remplacant:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_24_1;
   /* Fonction SupprimerTous(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_25_1;
   /* Fonction AjouterAuDebut(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_26_1;
   /* Fonction AjouterALaFin(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_27_1;
   /* Operateur +(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_28_1;
   /* Operateur +=(O:Nul Ou TypeElement); */
TypUpsVmCoAppel CoMth_29_1;
   /* Operateur [](Position:Nul Ou Entier) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_29_2;
   /* Operateur [](Position:Nul Ou Entier, Valeur:Nul Ou TypeElement, MethodeAComposer:Nul Ou Appel=Nul); */
TypUpsVmCoAppel CoMth_29_3;
   /* Operateur [](Position:Nul Ou Entier, Prefixe:Booleen, Methode:Nul Ou Appel) Retourner Nul Ou TypeElement; */
} UpsCoTrtUpsKrn_20_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsCoTrtUpsKrn_20_1_1_0 UpsCoTrtUpsKrn_20;

/****************************************************************/
typedef struct upscotrtupskrn_21_1_1_0
/* Objet : Methodes du type EspaceMetre.                        */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmCoAppel CoMth_4_1;
   /* Operateur <=(E:Nul Ou EspaceMettre) Retourner Nul Ou Booleen;*/
TypUpsVmCoAppel CoMth_5_1;
   /* Operateur >=(E:Nul Ou EspaceMettre) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_6_1;
   /* Operateur <(E:Nul Ou EspaceMettre) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_7_1;
   /* Operateur >(E:Nul Ou EspaceMettre) Retourner Nul Ou Booleen; */
} UpsCoTrtUpsKrn_21_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsCoTrtUpsKrn_21_1_1_0 UpsCoTrtUpsKrn_21;

/****************************************************************/
typedef struct upscotrtupskrn_22_1_1_0
/* Objet : Methodes du type AlgebreCommutative.                 */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmCoAppel CoMth_1_1;
   /* Operateur +(A:Nul Ou AlgebreCommutative) Retourner Nul Ou AlgebreCommutative; */
TypUpsVmCoAppel CoMth_2_1;
   /* Operateur -() Retourner Nul Ou AlgebreCommutative; */
TypUpsVmCoAppel CoMth_2_2;
   /* Operateur -(A:Nul Ou AlgebreCommutative) Retourner Nul Ou AlgebreCommutative; */
TypUpsVmCoAppel CoMth_3_1;
   /* Operateur *(A:Nul Ou AlgebreCommutative) Retourner Nul Ou AlgebreCommutative; */
TypUpsVmCoAppel CoMth_4_1;
   /* Operateur ++(B:Booleen) Retourner Nul Ou AlgebreCommutative; */
TypUpsVmCoAppel CoMth_5_1;
   /* Operateur --(B:Booleen) Retourner Nul Ou AlgebreCommutative; */
} UpsCoTrtUpsKrn_22_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsCoTrtUpsKrn_22_1_1_0 UpsCoTrtUpsKrn_22;

/****************************************************************/
typedef struct upscotrtupskrn_23_1_1_0
/* Objet : Methodes du type CorpsCommutatif.                    */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

/*--------------------------------------------------------------*/
/* Methodes heritees de AlgebreCommutative.                     */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_1_1;
   /* Operateur +(C:Nul Ou CorpsCommutatif) Retourner Nul Ou CorpsCommutatif; */
TypUpsVmCoAppel CoMth_2_1;
   /* Operateur -() Retourner Nul Ou CorpsCommutatif; */
TypUpsVmCoAppel CoMth_2_2;
   /* Operateur -(C:Nul Ou CorpsCommutatif) Retourner Nul Ou CorpsCommutatif; */
TypUpsVmCoAppel CoMth_3_1;
   /* Operateur *(C:Nul Ou CorpsCommutatif) Retourner Nul Ou CorpsCommutatif; */
TypUpsVmCoAppel CoMth_4_1;
   /* Operateur ++(B:Booleen) Retourner Nul Ou CorpsCommutatif; */
TypUpsVmCoAppel CoMth_5_1;
   /* Operateur --(B:Booleen) Retourner Nul Ou CorpsCommutatif; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_6_1;
   /* Operateur /(C:Nul Ou Corps) Retourner Nul Ou Corps; */
TypUpsVmCoAppel CoMth_7_1;
   /* Operateur ^(C:Nul Ou Corps) Retourner Nul Ou Corps; */
} UpsCoTrtUpsKrn_23_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsCoTrtUpsKrn_23_1_1_0 UpsCoTrtUpsKrn_23;

/****************************************************************/
typedef struct typupskrnddonnees
/* Objet: Interface des donnees de Ups Krn D.                   */
/****************************************************************/
{
struct typupsvmentetedonneesmodule EnteteDonneesModule;
   /* Entete generique du module. */
} *TypUpsKrnDDonnees;

/****************************************************************/
typedef struct typupskrndtraitements_1_1_0
/* Objet: Interface des traitements de Ups Krn D.               */
/****************************************************************/
{
struct typupsvmentetemethodesmodule EnteteMethodesModule;
   /* Methodes generiques au module. */ 
TypUpsVmCoAppel CoTrt_1_1;
   /* Objet : ActiverMiseAuPoint. */
TypUpsVmCoAppel CoTrt_2_1;
   /* Objet : ActiverContrainte. */
TypUpsVmCoAppel CoTrt_3_1;
   /* Objet : ArreterProgramme(CodeRetour:Entier). */
TypUpsVmCoAppel CoTrt_3_2;
   /* Objet : ArreterProgramme(NumeroDuProgramme:UpsKrnEntier, Forcer:Booleen). */
TypUpsVmCoAppel CoTrt_4_1;
   /* Objet : DebuterExportation(Ecrire:Procedure(B:Binaire)). */
TypUpsVmCoAppel CoTrt_5_1;
   /* Objet : ExporterEnumere(E:Enumere). */
TypUpsVmCoAppel CoTrt_6_1;
   /* Objet : ExporterEntier(E:Entier). */
TypUpsVmCoAppel CoTrt_7_1;
   /* Objet : ExporterReel(R:Reel). */
TypUpsVmCoAppel CoTrt_8_1;
   /* Objet : TerminerExportation(). */
TypUpsVmCoAppel CoTrt_9_1;
   /* Objet : DebuterImportation(Lire:Fonction(TaillePaquet:Entier) Retourner Binaire, P:Nul Ou Entrepot=Nul). */
TypUpsVmCoAppel CoTrt_10_1;
   /* Objet : ImporterEnumere() Retourner Enumere. */
TypUpsVmCoAppel CoTrt_11_1;
   /* Objet : ImporterEntier() Retourner Entier. */
TypUpsVmCoAppel CoTrt_12_1;
   /* Objet : ImporterReel() Retourner Reel. */
TypUpsVmCoAppel CoTrt_13_1;
   /* Objet : ImporterObjet() Retourner Nul Ou Objet. */
TypUpsVmCoAppel CoTrt_14_1;
   /* Objet : TerminerImportation(). */
TypUpsVmCoAppel CoTrt_15_1;
   /* Objet : Photographier(Activite:Booleen, Portee:PorteePhotographie=PhotographiePrivee). */
TypUpsVmCoAppel CoTrt_16_1;
   /* Objet : IlExistePhotographie(Portee: PorteePhotographie=PhotographiePrivee) Retourner Booleen. */
TypUpsVmCoAppel CoTrt_17_1;
   /* Objet : Procedure SynchroniserEntrepotsEtJournal(); */

UpsCoTrtUpsKrn_1 *UpsTrt1;
   /* Co-Methodes de Binaire. */ 
UpsCoTrtUpsKrn_2 *UpsTrt2;
   /* Co-Methodes de Caractere. */ 
UpsCoTrtUpsKrn_21 *UpsTrt2_1;
   /* Methodes de Caractere.EspaceMetre. */ 
UpsCoTrtUpsKrn_3 *UpsTrt3;
   /* Methodes de Date. */ 
UpsCoTrtUpsKrn_21 *UpsTrt3_1;
   /* Methodes de Date.EspaceMetre. */ 
UpsCoTrtUpsKrn_4 *UpsTrt4;
   /* Co-Methodes de Entier. */ 
UpsCoTrtUpsKrn_22 *UpsTrt4_1;
   /* Methodes de Entier.AlgebreCommutative. */ 
UpsCoTrtUpsKrn_21 *UpsTrt4_2;
   /* Methodes de Entier.EspaceMetre. */ 
UpsCoTrtUpsKrn_5 *UpsTrt5;
   /* Co-Methodes de Enumere. */ 
UpsCoTrtUpsKrn_21 *UpsTrt5_1;
   /* Methodes de Enumere.EspaceMetre. */ 
UpsCoTrtUpsKrn_6 *UpsTrt6;
   /* Co-Methodes de Exception. */ 
UpsCoTrtUpsKrn_7 *UpsTrt7;
   /* Co-Methodes de Objet. */ 
UpsCoTrtUpsKrn_8 *UpsTrt8;
   /* Co-Methodes de Reel. */ 
UpsCoTrtUpsKrn_23 *UpsTrt8_1;
   /* Methodes de Reel.CorpsCommutatif. */ 
UpsCoTrtUpsKrn_22 *UpsTrt8_1_1;
   /* Methodes de Reel.AlgebreCommutative. */ 
UpsCoTrtUpsKrn_21 *UpsTrt8_2;
   /* Methodes de Reel.EspaceMetre. */ 
UpsCoTrtUpsKrn_9 *UpsTrt9;
   /* Co-Methodes de Type. */ 
UpsCoTrtUpsKrn_10 *UpsTrt10;
   /* Co-Methodes de Liste */
UpsCoTrtUpsKrn_20 *UpsTrt10_1;
   /* Methodes de Liste.Collection */
UpsCoTrtUpsKrn_19 *UpsTrt10_1_1;
   /* Methodes de Liste.Collection.Iterateur */
UpsCoTrtUpsKrn_11 *UpsTrt11;
   /* Co-Methodes de Reference. */
UpsCoTrtUpsKrn_12 *UpsTrt12;
   /* Co-Methodes de Tableau. */
UpsCoTrtUpsKrn_20 *UpsTrt12_1;
   /* Methodes de Tableau.Collection */
UpsCoTrtUpsKrn_19 *UpsTrt12_1_1;
   /* Methodes de Tableau.Collection.Iterateur */
UpsCoTrtUpsKrn_13 *UpsTrt13;
   /* Co-Methodes de ArbreBinaire. */ 
UpsCoTrtUpsKrn_20 *UpsTrt13_1;
   /* Methodes de ArbreBinaire.Collection */
UpsCoTrtUpsKrn_19 *UpsTrt13_1_1;
   /* Methodes de ArbreBinaire.Collection.Iterateur */
UpsCoTrtUpsKrn_14 *UpsTrt14;
   /* Co-Methodes de Entrepot. */ 
UpsCoTrtUpsKrn_15 *UpsTrt15;
   /* Co-Methodes de Module. */ 
UpsCoTrtUpsKrn_16 *UpsTrt16;
   /* Co-Methodes de Appel. */ 
UpsCoTrtUpsKrn_17 *UpsTrt17;
   /* Co-Methodes de Transaction. */ 
UpsCoTrtUpsKrn_4 *UpsTrt18;
   /* Co-Methodes de Octet. */ 
UpsCoTrtUpsKrn_22 *UpsTrt18_1;
   /* Methodes de Octet.AlgebreCommutative. */ 
UpsCoTrtUpsKrn_21 *UpsTrt18_2;
   /* Methodes de Octet.EspaceMetre. */ 
UpsCoTrtUpsKrn_19 *UpsTrt19;
   /* Co-Methodes de Iterateur. */ 
UpsCoTrtUpsKrn_20 *UpsTrt20;
   /* Co-Methodes de Collection. */ 
UpsCoTrtUpsKrn_19 *UpsTrt20_1;
   /* Methodes de Collection.Iterateur. */ 
UpsCoTrtUpsKrn_21 *UpsTrt21;
   /* Methodes de EspaceMetre. */ 
UpsCoTrtUpsKrn_22 *UpsTrt22;
   /* Methodes de AlgebreCommutative. */ 
UpsCoTrtUpsKrn_23 *UpsTrt23;
   /* Methodes de CorpsCommutatif. */ 
UpsCoTrtUpsKrn_22 *UpsTrt23_1;
   /* Methodes de AlgebreCommutatif. */ 

TypUpsVmUnsignedChar UpsVmAPI (*CoCritereExportationParAdresse)(TypUpsVmSession *Session,
   TypUpsVmShort NumeroParametre, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm);
   /* Objet : Critere de comparaison des arbres binaires. */
TypUpsVmUnsignedChar UpsVmAPI (*CoMethodeAffecter)(TypUpsVmSession *Session,
   TypUpsVmShort NumeroParametre, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm);
   /* Operateur =(P:Nul Ou Objet); */
TypUpsVmUnsignedChar UpsVmAPI (*CoMethodeEgal)(TypUpsVmSession *Session,
   TypUpsVmShort NumeroParametre, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm);
   /* Operateur =(P:Nul Ou Objet); */
TypUpsVmUnsignedChar UpsVmAPI (*CoMethodeDifferent)(TypUpsVmSession *Session,
   TypUpsVmShort NumeroParametre, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm);
   /* Operateur !=(P:Nul Ou Objet) Retourner Nul Ou Booleen; */
TypUpsVmUnsignedChar UpsVmAPI (*CoMethodeComposer)(TypUpsVmSession *Session,
   TypUpsVmShort NumeroParametre, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm);
   /* Operateur ?=(P:Nul Ou Objet); */
TypUpsVmUnsignedChar UpsVmAPI (*CoConstructeur)(TypUpsVmSession *Session,
   TypUpsVmShort NumeroParametre, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm);
   /* Constructeur(); */
TypUpsVmUnsignedChar UpsVmAPI (*CoDestructeur)(TypUpsVmSession *Session,
   TypUpsVmShort NumeroParametre, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm);
   /* Destructeur(); */
TypUpsVmUnsignedChar UpsVmAPI (*CoMethodeCloner)(TypUpsVmSession *Session,
   TypUpsVmShort NumeroParametre, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm);
   /* Cloner(EntrepotCible:Nul Ou Entrepot=Nul, Profondeur : ProfondeurClonage=ClonageObjetSeul) Retourner Nul Ou Objet */
TypUpsVmUnsignedChar UpsVmAPI (*CoMethodeExporter)(TypUpsVmSession *Session,
   TypUpsVmShort NumeroParametre, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm);
   /* Exporter(); */
TypUpsVmUnsignedChar UpsVmAPI (*CoMethodeImporter)(TypUpsVmSession *Session,
   TypUpsVmShort NumeroParametre, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm);
   /* Importer(); */
TypUpsVmAdresse UpsVmAPI *(*MethodeLirePropriete)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsVmLirePropriete *UpsPrm);
   /* Objet : Methode de lecture des proprietes dynamiques. */
TypUpsVmVoid UpsVmAPI (*MethodeEcrirePropriete)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjet, TypPrmUpsVmEcrirePropriete *UpsPrm);
   /* Objet : Methode d'ecriture des proprietes dynamiques. */
TypUpsVmAdresse UpsVmAPI *(*MethodeIncrementerDecrementerPropriete)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsVmIncrementerDecrementerPropriete *UpsPrm);
   /* Objet : Methode d'incrementation ou de decrementation des proprietes dynamiques. */
TypUpsVmVoid UpsVmAPI (*MethodeSupprimerPropriete)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjet, TypPrmUpsVmSupprimerPropriete *UpsPrm);
   /* Objet : Methode de suppression des proprietes dynamiques. */
TypUpsVmAdresse UpsVmAPI *(*MethodeEnumererProprietes)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsVmEnumererProprietes *UpsPrm);
   /* Objet : Methode d'enumeration des proprietes dynamiques. */
TypUpsVmUnsignedChar UpsVmAPI (*CoMethodeLirePropriete)(TypUpsVmSession *Session,
   TypUpsVmShort NumeroParametre, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm);
   /* LirePropriete(NomPropriete:Caractere) Retourner Nul Ou Objet; */
TypUpsVmUnsignedChar UpsVmAPI (*CoMethodeEcrirePropriete)(TypUpsVmSession *Session,
   TypUpsVmShort NumeroParametre, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm);
   /* EcrirePropriete(NomPropriete:Caractere, ValeurPropriete:Nul Ou Objet); */
TypUpsVmUnsignedChar UpsVmAPI (*CoMethodeIncrementerDecrementerPropriete)(TypUpsVmSession *Session,
   TypUpsVmShort NumeroParametre, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm);
   /* IncrementerDecrementerPropriete(NomVariable : Nul Ou Caractere, Incrementer:Booleen, Prefixe:Booleen) Retourner Nul Ou Objet; */
TypUpsVmUnsignedChar UpsVmAPI (*CoMethodeSupprimerPropriete)(TypUpsVmSession *Session,
   TypUpsVmShort NumeroParametre, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm);
   /* SupprimerProprietes(NomPropriete:Caractere); */
TypUpsVmUnsignedChar UpsVmAPI (*CoMethodeEnumererProprietes)(TypUpsVmSession *Session,
   TypUpsVmShort NumeroParametre, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm);
   /* EnumererProprietes(Numero:Entier, TypePropriete:Nul Ou Type Sortie, EstNul:Booleen Sortie, 
      Aide:Nul Ou Caractere Sortie, NomEnumere : Nul Ou Caractere Sortie) Retourner Nul Ou Caractere; */
TypUpsVmUnsignedChar UpsVmAPI (*CoMethodeEnumererMethodes)(TypUpsVmSession *Session,
   TypUpsVmShort NumeroParametre, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm);
   /* EnumererMethodes(Numero:Entier, NomAppel:Nul Ou Caractere Sortie, Aide:Nul Ou Caractere Sortie) Retourner Nul Ou Appel; */
TypUpsVmUnsignedChar UpsVmAPI (*CoMethodeLireVirtuelEnumereCourt)(TypUpsVmSession *Session,
   TypUpsVmShort NumeroParametre, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm);
   /* Virtuel() Retourner Booleen; */
TypUpsVmUnsignedChar UpsVmAPI (*CoMethodeEcrireVirtuelEnumereCourt)(TypUpsVmSession *Session,
   TypUpsVmShort NumeroParametre, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm);
   /* Virtuel(P:Booleen); */
TypUpsVmUnsignedChar UpsVmAPI (*CoMethodeLireVirtuelEnumereLong)(TypUpsVmSession *Session,
   TypUpsVmShort NumeroParametre, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm);
   /* Virtuel() Retourner Enumere; */
TypUpsVmUnsignedChar UpsVmAPI (*CoMethodeEcrireVirtuelEnumereLong)(TypUpsVmSession *Session,
   TypUpsVmShort NumeroParametre, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm);
   /* Virtuel(P:Enumere); */
TypUpsVmUnsignedChar UpsVmAPI (*CoMethodeLireVirtuelEntier)(TypUpsVmSession *Session,
   TypUpsVmShort NumeroParametre, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm);
   /* Virtuel() Retourner Entier; */
TypUpsVmUnsignedChar UpsVmAPI (*CoMethodeEcrireVirtuelEntier)(TypUpsVmSession *Session,
   TypUpsVmShort NumeroParametre, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm);
   /* Virtuel(P:Entier); */
TypUpsVmUnsignedChar UpsVmAPI (*CoMethodeLireVirtuelReel)(TypUpsVmSession *Session,
   TypUpsVmShort NumeroParametre, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm);
   /* Virtuel() Retourner Reel; */
TypUpsVmUnsignedChar UpsVmAPI (*CoMethodeEcrireVirtuelReel)(TypUpsVmSession *Session,
   TypUpsVmShort NumeroParametre, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm);
   /* Virtuel(P:Reel); */
TypUpsVmUnsignedChar UpsVmAPI (*CoMethodeLireVirtuelObjet)(TypUpsVmSession *Session,
   TypUpsVmShort NumeroParametre, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm);
   /* Virtuel() Retourner Nul Ou Objet; */
TypUpsVmUnsignedChar UpsVmAPI (*CoMethodeEcrireVirtuelObjet)(TypUpsVmSession *Session,
   TypUpsVmShort NumeroParametre, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm);
   /* Virtuel(P:Objet); */
TypUpsVmAdresse UpsVmAPI *(*MethodeEnumererMethodes)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsVmEnumererAppels *UpsPrm,
   TypUpsVmAdresse *AdresseObjetType, TypUpsVmEnteteMethodes *EnteteMethodes,
   TypUpsVmAdresse *AdresseObjetModule);
   /* Objet : Enumere les methodes generiques a tous les objets. */
TypUpsVmAdresse UpsVmAPI *(*MethodeEnumererMethodesElementListe)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsVmEnumererAppels *UpsPrm);
   /* Objet : Enumere les methodes generiques a tous les objets. */
TypUpsVmAdresse UpsVmAPI *(*MethodeEnumererMethodesElementArbre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsVmEnumererAppels *UpsPrm);
   /* Objet : Enumere les methodes generiques a tous les objets. */
} *TypUpsKrnDTraitements_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsKrnDTraitements_1_1_0 TypUpsKrnDTraitements;

extern DllExport TypUpsVtmDemarrer UpsVmAPI UpsKrnDDemarrerModule(TypUpsVmShort Numero, TypUpsVtmMachineInterface MachineInterfaceUpsVtm,
   TypUpsVtmTraitements IntTrtUpsVtm, TypUpsVtmDonnees IntDonUpsVtm);
   /* Objet : Retourne la description de Ups Krn D. */

/**********************/
#if defined(__cplusplus)
/**********************/
}
/****/
#endif
/****/

/****/
#endif
/****/
