/*-------------------------------------------------------------------
Fichier     : upskrn.e
Objet       : En-tete du module Up ! Kernel.

Module      : Up ! Kernel
Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.
---------------------------------------------------------------------
                         Observations

 
---------------------------------------------------------------------*/

/*****************************/
#if !defined(PasseModuleUpsKrn)
/*****************************/
#define PasseModuleUpsKrn 1

/**********************/
#if defined(__cplusplus)
/**********************/
extern "C"
{
/****/
#endif
/****/

/*--------------------*/
/* Enumere Booleen	 */
/*--------------------*/
#define UpsEnuUpsKrn_1_1 0
   /* Valeur : Faux */
#define UpsEnuUpsKrn_1_2 1
   /* Valeur : Vrai */

/*------------------------------*/
/* Enumere ComparaisonObjet     */
/*------------------------------*/
#define UpsEnuUpsKrn_2_1 1
   /* Valeur : ComparaisonAvant. */
#define UpsEnuUpsKrn_2_2 2
   /* Valeur : ComparaisonEgal. */
#define UpsEnuUpsKrn_2_3 3
   /* Valeur : ComparaisonApres. */
#define UpsEnuUpsKrn_2_4 4
   /* Valeur : ComparaisonNul. */

/*------------------------------*/
/* Enumere ProfondeurClonage    */
/*------------------------------*/
#define UpsEnuUpsKrn_3_1 1
   /* Valeur : ClonageObjetSeul. */
#define UpsEnuUpsKrn_3_2 2
   /* Valeur : ClonageObjetsDirects. */
#define UpsEnuUpsKrn_3_3 3
   /* Valeur : ClonageRecursif. */

/*------------------------------*/
/* Enumere AccesEntrepot        */
/*------------------------------*/
#define UpsEnuUpsKrn_4_1 1
   /* Valeur : EntrepotPrive */
#define UpsEnuUpsKrn_4_2 2
   /* Valeur : EntrepotProtege */
#define UpsEnuUpsKrn_4_3 3
   /* Valeur : EntrepotPublic */

/*------------------------------*/
/* Enumere SorteParametre       */
/*------------------------------*/
#define UpsEnuUpsKrn_5_1 1
   /* Valeur : ParametreEntree */
#define UpsEnuUpsKrn_5_2 2
   /* Valeur : ParametreSortie */
#define UpsEnuUpsKrn_5_3 3
   /* Valeur : ParametreEntreeSortie */

/*------------------------------*/
/* Enumere PorteePhotographie   */
/*------------------------------*/
#define UpsEnuUpsKrn_6_1 1
   /* Valeur : PhotographiePrivee. */
#define UpsEnuUpsKrn_6_2 2
   /* Valeur : PhotographieProtegee. */
#define UpsEnuUpsKrn_6_3 3
   /* Valeur : PhotographiePublique. */

/*------------------------------*/
/* Enumere ActiviteContrainte.  */
/*------------------------------*/
#define UpsEnuUpsKrn_7_1 1
   /* Valeur : ContrainteImmediate. */
#define UpsEnuUpsKrn_7_2 2
   /* Valeur : ContrainteValidation. */
#define UpsEnuUpsKrn_7_3 3
   /* Valeur : ContrainteSuspendue. */

/*----------------------------------*/
/* Enumere ExceptionSurTransaction. */
/*----------------------------------*/
#define UpsEnuUpsKrn_8_1 1
   /* Valeur : TransactionInchangee. */
#define UpsEnuUpsKrn_8_2 2
   /* Valeur : TransactionInvalidee. */
#define UpsEnuUpsKrn_8_3 3
   /* Valeur : TransactionsToutesInvalidees. */

/*----------------------------------*/
/* Enumere EtatEntrepot.            */
/*----------------------------------*/
#define UpsEnuUpsKrn_9_1 1
   /* Valeur : EntrepotIndisponible. */
#define UpsEnuUpsKrn_9_2 2
   /* Valeur : EntrepotFichierIndisponible. */
#define UpsEnuUpsKrn_9_3 3
   /* Valeur : EntrepotLectureSeule. */
#define UpsEnuUpsKrn_9_4 4
   /* Valeur : EntrepotLectureEcriture. */

/****************************************************************/
/* Codification des types de trace.							          */
/****************************************************************/
enum EnuUpsKrnTypeTrace
   {
   TT_Appel=1,
   TT_ParametreBooleen=2,
   TT_ParametreEntier=3,
   TT_ParametreEnumere=4,
   TT_ParametreReel=5,
   TT_ParametreObjet=6,
   TT_Retourner=7,
   TT_RetournerBooleen=8,
   TT_RetournerEntier=9,
   TT_RetournerEnumere=10,
   TT_RetournerReel=11,
   TT_RetournerObjet=12,
   TT_Exception=13
   };

/****************************************************************/
/* Codification de la verification des objets.					    */
/****************************************************************/
enum EnuUpsKrnVerificationObjet
   {
   VO_ArbreBinaireNul=1,
   VO_ArbreBinaireNonNul=2,
   VO_ICollectionNul=3,
   VO_ICollectionNonNul=4,
   VO_IIterateurNul=5,
   VO_IIterateurNonNul=6,
   VO_ListeNul=7,
   VO_ListeNonNul=8,
   VO_ReferenceNul=9,
   VO_ReferenceNonNul=10,
   VO_TableauNul=11,
   VO_TableauNonNul=12
   };

/****************************************************************/
/* Codification des reels.                    					    */
/****************************************************************/
enum EnuUpsKrnObjetReel
   {
   OR_Reel=1,
   OR_Degre=2,
   OR_Radian=3
   };

#define CO_NbMethodesObjet 15
   /* Nombre de methodes du type Objet heritees par tous les types. */
#define CO_NumeroPseudoTypeBooleen 24
   /* Numero du pseudo-type Booleen pour les adaptateurs. */

/****************************************************************/
typedef struct typprmupskrn_1_4_2
/* Objet : Parametre de Binaire.Constructeur(C:Nul Ou Caractere)*/
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* C : Nul Ou Caractere. */
} TypPrmUpsKrn_1_4_2;

/****************************************************************/
typedef struct typprmupskrn_1_5_1
/* Objet : Parametre de Binaire.+(B:Nul Ou Binaire) Retourner   */
/* Binaire.                                                     */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* B : Nul Ou Binaire. */
} TypPrmUpsKrn_1_5_1;

/****************************************************************/
typedef struct typprmupskrn_1_9_1
/* Objet : Parametre de Binaire.Gauche(Taille:Nul Ou Entier)    */
/* Retourner Nul Ou Binaire                                     */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Taille : Nul Ou Entier. */
} TypPrmUpsKrn_1_9_1;

/****************************************************************/
typedef struct typprmupskrn_1_10_1
/* Objet : Parametre de Binaire.Droite(Taille:Nul Ou Entier)    */
/* Retourner Nul Ou Binaire                                     */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Taille : Nul Ou Entier. */
} TypPrmUpsKrn_1_10_1;

/****************************************************************/
typedef struct typprmupskrn_1_11_1
/* Objet : Parametre de Binaire.Milieu(Position:Nul Ou Entier,  */
/* Taille:Nul Ou Entier) Retourner Nul Ou Binaire               */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Position : Nul Ou Entier. */
TypUpsVmAdresse UpsVar2;
   /* Taille : Nul Ou Entier. */
} TypPrmUpsKrn_1_11_1;

/****************************************************************/
typedef struct typprmupskrn_1_12_1
/* Objet : Parametre de Binaire.Unicode(Nombre:Nul Ou Entier)   */
/* Retourner Nul Ou Entier                                      */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Taille : Nul Ou Entier. */
} TypPrmUpsKrn_1_12_1;

/****************************************************************/
typedef struct upstrttypupskrn_1_1_1_0
/* Objet : Methodes du type Binaire.                            */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmAdresse UpsVmAPI *(*Mth_4_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsKrn_1_4_2 *UpsPrm);
   /* Constructeur(C:Nul Ou Caractere); */
TypUpsVmAdresse UpsVmAPI *(*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_1_5_1 *UpsPrm);
   /* Operateur +(B:Nul Ou Binaire) Retourner Nul Ou Binaire; */
TypUpsVmVoid UpsVmAPI (*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *UpsPrm);
   /* Operateur +=(B:Nul Ou Binaire); */
TypUpsVmAdresse UpsVmAPI *(*Mth_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet);
   /* Operateur -() Retourner Nul Ou Binaire; */
TypUpsVmAdresse UpsVmAPI *(*Mth_8_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet);
   /* Fonction Longueur() Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_9_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_1_9_1 *UpsPrm);
   /* Fonction Gauche(Taille:Nul Ou Entier) Retourner Nul Ou Binaire; */
TypUpsVmAdresse UpsVmAPI *(*Mth_10_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_1_10_1 *UpsPrm);
   /* Fonction Droite(Taille:Nul Ou Entier) Retourner Nul Ou Binaire; */
TypUpsVmAdresse UpsVmAPI *(*Mth_11_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_1_11_1 *UpsPrm);
   /* Fonction Milieu(Position:Nul Ou Entier, Taille:Nul Ou Entier) Retourner Nul Ou Binaire; */
TypUpsVmAdresse UpsVmAPI *(*Mth_12_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_1_12_1 *UpsPrm);
   /* Fonction Unicode(Position:Nul Ou Entier) Retourner Nul Ou Entier; */

TypUpsVmCoAppel CoMth_4_2;
   /* Constructeur(C:Nul Ou Caractere); */
TypUpsVmCoAppel CoMth_5_1;
   /* Operateur +(B:Nul Ou Binaire) Retourner Nul Ou Binaire; */
TypUpsVmCoAppel CoMth_6_1;
   /* Operateur +=(B:Nul Ou Binaire); */
TypUpsVmCoAppel CoMth_7_1;
   /* Operateur -() Retourner Nul Ou Binaire; */
TypUpsVmCoAppel CoMth_8_1;
   /* Fonction TypUpsVmLongueur() Retourner Entier; */
TypUpsVmCoAppel CoMth_9_1;
   /* Fonction Gauche(Taille:Nul Ou Entier) Retourner Nul Ou Binaire; */
TypUpsVmCoAppel CoMth_10_1;
   /* Fonction Droite(Taille:Nul Ou Entier) Retourner Nul Ou Binaire; */
TypUpsVmCoAppel CoMth_11_1;
   /* Fonction Milieu(Position:Nul Ou Entier, Taille:Nul Ou Entier) Retourner Nul Ou Binaire; */
TypUpsVmCoAppel CoMth_12_1;
   /* Fonction Unicode(Position:Nul Ou Entier) Retourner Nul Ou Entier; */
} UpsTrtTypUpsKrn_1_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTrtTypUpsKrn_1_1_1_0 UpsTrtTypUpsKrn_1;

/****************************************************************/
typedef struct typprmupskrn_21_4_1
/* Objet : Parametre de EspaceMetre.<=(E:Nul Ou EspaceMetre)    */
/* Retourner Nul Ou Booleen.                                    */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E : Nul Ou EspaceMetre. */
} TypPrmUpsKrn_21_4_1;

/****************************************************************/
typedef struct typprmupskrn_21_5_1
/* Objet : Parametre de EspaceMetre.>=(E:Nul Ou EspaceMetre)    */
/* Retourner Nul Ou Booleen.                                    */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E : Nul Ou EspaceMetre. */
} TypPrmUpsKrn_21_5_1;

/****************************************************************/
typedef struct typprmupskrn_21_6_1
/* Objet : Parametre de EspaceMetre.<(E:Nul Ou EspaceMetre)     */
/* Retourner Nul Ou Booleen.                                    */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E : Nul Ou EspaceMetre. */
} TypPrmUpsKrn_21_6_1;

/****************************************************************/
typedef struct typprmupskrn_21_7_1
/* Objet : Parametre de EspaceMetre.>(E:Nul Ou EspaceMetre)     */
/* Retourner Nul Ou Booleen.                                    */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E : Nul Ou EspaceMetre. */
} TypPrmUpsKrn_21_7_1;

/****************************************************************/
typedef struct upstrttypupskrn_21_1_1_0
/* Objet : Methodes du type EspaceMetre.                        */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmAdresse UpsVmAPI *(*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_21_4_1 *UpsPrm);
   /* Operateur <=(E:Nul Ou EspaceMettre) Retourner Nul Ou Booleen;*/
TypUpsVmAdresse UpsVmAPI *(*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_21_5_1 *UpsPrm);
   /* Operateur >=(E:Nul Ou EspaceMettre) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_21_6_1 *UpsPrm);
   /* Operateur <(E:Nul Ou EspaceMettre) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*Mth_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_21_7_1 *UpsPrm);
   /* Operateur >(E:Nul Ou EspaceMettre) Retourner Nul Ou Booleen; */

TypUpsVmCoAppel CoMth_4_1;
   /* Operateur <=(E:Nul Ou EspaceMettre) Retourner Nul Ou Booleen;*/
TypUpsVmCoAppel CoMth_5_1;
   /* Operateur >=(E:Nul Ou EspaceMettre) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_6_1;
   /* Operateur <(E:Nul Ou EspaceMettre) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_7_1;
   /* Operateur >(E:Nul Ou EspaceMettre) Retourner Nul Ou Booleen; */
} UpsTrtTypUpsKrn_21_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTrtTypUpsKrn_21_1_1_0 UpsTrtTypUpsKrn_21;

/****************************************************************/
typedef struct typprmupskrn_2_8_2
/* Objet : Parametre de Caractere.Constructeur(B:Nul Ou Booleen)*/
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* B : Nul Ou Booleen. */
} TypPrmUpsKrn_2_8_2;

/****************************************************************/
typedef struct typprmupskrn_2_8_3
/* Objet : Parametre de Caractere.Constructeur(D:Nul Ou Date)   */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* D : Nul Ou Date. */
} TypPrmUpsKrn_2_8_3;

/****************************************************************/
typedef struct typprmupskrn_2_8_4
/* Objet : Parametre de Caractere.Constructeur(D:Nul Ou Date,   */
/* Filtre:Nul Ou Caractere)                                     */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* D : Nul Ou Date. */
TypUpsVmAdresse UpsVar2;
   /* Filtre : Nul Ou Caractere. */
} TypPrmUpsKrn_2_8_4;

/****************************************************************/
typedef struct typprmupskrn_2_8_5
/* Objet : Parametre de Caractere.Constructeur(E:Nul Ou Entier) */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E : Nul Ou Entier. */
} TypPrmUpsKrn_2_8_5;

/****************************************************************/
typedef struct typprmupskrn_2_8_6
/* Objet : Parametre de Caractere.Constructeur(E:Nul Ou Entier, */
/* Filtre:Nul Ou Caractere)                                     */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E : Nul Ou Entier. */
TypUpsVmAdresse UpsVar2;
   /* Filtre : Nul Ou Caractere. */
} TypPrmUpsKrn_2_8_6;

/****************************************************************/
typedef struct typprmupskrn_2_8_7
/* Objet : Parametre de Caractere.Constructeur(E:Nul Ou Entier, */
/* Filtre:Nul Ou Caractere, PointVirgule:Nul Ou Caractere)      */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E : Nul Ou Entier. */
TypUpsVmAdresse UpsVar2;
   /* Filtre : Nul Ou Caractere. */
TypUpsVmAdresse UpsVar3;
   /* PointVirgule : Nul Ou Caractere. */
} TypPrmUpsKrn_2_8_7;

/****************************************************************/
typedef struct typprmupskrn_2_8_8
/* Objet : Parametre de Caractere.Constructeur(R:Nul Ou Reel)   */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* R : Nul Ou Reel. */
} TypPrmUpsKrn_2_8_8;

/****************************************************************/
typedef struct typprmupskrn_2_8_9
/* Objet : Parametre de Caractere.Constructeur(R:Nul Ou Reel,   */
/* Filtre:Nul Ou Caractere)                                     */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* R : Nul Ou Reel. */
TypUpsVmAdresse UpsVar2;
   /* Filtre : Nul Ou Caractere. */
} TypPrmUpsKrn_2_8_9;

/****************************************************************/
typedef struct typprmupskrn_2_8_10
/* Objet : Parametre de Caractere.Constructeur(E:Nul Ou Reel,   */
/* Filtre:Nul Ou Caractere, PointVirgule:Nul Ou Caractere)      */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E : Nul Ou Entier. */
TypUpsVmAdresse UpsVar2;
   /* Filtre : Nul Ou Caractere. */
TypUpsVmAdresse UpsVar3;
   /* PointVirgule : Nul Ou Caractere. */
} TypPrmUpsKrn_2_8_10;

/****************************************************************/
typedef struct typprmupskrn_2_8_11
/* Objet : Parametre de Caractere.Constructeur(B:Nul Ou Binaire)*/
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* B : Nul Ou Binaire. */
} TypPrmUpsKrn_2_8_11;

/****************************************************************/
typedef struct typprmupskrn_2_9_1
/* Objet : Parametre de Caractere.+(B:Nul Ou Caractere)         */
/* Retourner Binaire.                                           */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* C : Nul Ou Caractere. */
} TypPrmUpsKrn_2_9_1;

/****************************************************************/
typedef struct typprmupskrn_2_13_1
/* Objet : Parametre de Caractere.Gauche(Taille:Nul Ou Entier)  */
/* Retourner Nul Ou Caractere                                   */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Taille : Nul Ou Entier. */
} TypPrmUpsKrn_2_13_1;

/****************************************************************/
typedef struct typprmupskrn_2_14_1
/* Objet : Parametre de Caractere.Droite(Taille:Nul Ou Entier)  */
/* Retourner Nul Ou Caractere                                   */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Taille : Nul Ou Entier. */
} TypPrmUpsKrn_2_14_1;

/****************************************************************/
typedef struct typprmupskrn_2_15_1
/* Objet : Parametre de Caractere.Milieu(Position:Nul Ou Entier,*/
/* Taille:Nul Ou Entier) Retourner Nul Ou Caractere             */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Position : Nul Ou Entier. */
TypUpsVmAdresse UpsVar2;
   /* Taille : Nul Ou Entier. */
} TypPrmUpsKrn_2_15_1;

/****************************************************************/
typedef struct typprmupskrn_2_16_1
/* Objet : Parametre de Caractere.Unicode(Nombre:Nul Ou Entier)   */
/* Retourner Nul Ou Entier                                      */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Taille : Nul Ou Entier. */
} TypPrmUpsKrn_2_16_1;

/****************************************************************/
typedef struct typprmupskrn_2_20_1
/* Objet : Parametre de Caractere.Inserer(Chaine:Nul Ou         */
/* Caractere, Position:Nul Ou Entier) Retourner Nul Ou Caractere*/
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Chaine : Nul Ou Caractere. */
TypUpsVmAdresse UpsVar2;
   /* Position : Nul Ou Entier. */
} TypPrmUpsKrn_2_20_1;

/****************************************************************/
typedef struct typprmupskrn_2_21_1
/* Objet : Parametre de Caractere.Compter(Modele:Nul Ou         */
/* Caractere, Position:Nul Ou Entier=Nul) Retourner Nul Ou      */
/* Entier                                                       */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Modele : Nul Ou Caractere. */
TypUpsVmAdresse UpsVar2;
   /* Position : Nul Ou Entier. */
} TypPrmUpsKrn_2_21_1;

/****************************************************************/
typedef struct typprmupskrn_2_22_1
/* Objet : Parametre de Caractere.Remplacer(Modele:Nul Ou       */
/* Caractere, Remplacant:Nul Ou Caractere, Position:Nul Ou      */
/* Entier=Nul) Retourner Nul Ou Caractere                       */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Modele : Nul Ou Caractere. */
TypUpsVmAdresse UpsVar2;
   /* Remplacant : Nul Ou Caractere. */
TypUpsVmAdresse UpsVar3;
   /* Position : Nul Ou Entier. */
} TypPrmUpsKrn_2_22_1;

/****************************************************************/
typedef struct typprmupskrn_2_23_1
/* Objet : Parametre de Caractere.Ajouter(Taille:Nul Ou Entier, */
/* Modele:Nul Ou Caractere=" ") Retourner Nul Ou Caractere      */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Taille : Nul Ou Entier. */
TypUpsVmAdresse UpsVar2;
   /* Modele : Nul Ou Caractere. */
} TypPrmUpsKrn_2_23_1;

/****************************************************************/
typedef struct typprmupskrn_2_24_1
/* Objet : Parametre de Caractere.AjouterDroite(Taille:Nul Ou   */
/* Entier, Modele:Nul Ou Caractere=" ") Retourner Nul Ou        */
/* Caractere                                                    */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Modele : Nul Ou Entier. */
TypUpsVmAdresse UpsVar2;
   /* Modele : Nul Ou Caractere. */
} TypPrmUpsKrn_2_24_1;

/****************************************************************/
typedef struct typprmupskrn_2_25_1
/* Objet : Parametre de Caractere.AjouterGauche(Taille:Nul Ou   */
/* Entier, Modele:Nul Ou Caractere=" ") Retourner Nul Ou        */
/* Caractere                                                    */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Modele : Nul Ou Entier. */
TypUpsVmAdresse UpsVar2;
   /* Modele : Nul Ou Caractere. */
} TypPrmUpsKrn_2_25_1;

/****************************************************************/
typedef struct typprmupskrn_2_26_1
/* Objet : Parametre de Caractere.Supprimer(Modele:Nul Ou       */
/* Caractere=Nul) Retourner Nul Ou Caractere                    */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Modele : Nul Ou Caractere. */
} TypPrmUpsKrn_2_26_1;

/****************************************************************/
typedef struct typprmupskrn_2_27_1
/* Objet : Parametre de Caractere.SupprimerDroite(Modele:Nul Ou */
/* Caractere=Nul) Retourner Nul Ou Caractere                    */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Modele : Nul Ou Caractere. */
} TypPrmUpsKrn_2_27_1;

/****************************************************************/
typedef struct typprmupskrn_2_28_1
/* Objet : Parametre de Caractere.SupprimerGauche(Modele:Nul Ou */
/* Caractere=Nul) Retourner Nul Ou Caractere                    */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Modele : Nul Ou Caractere. */
} TypPrmUpsKrn_2_28_1;

/****************************************************************/
typedef struct typprmupskrn_2_29_1
/* Objet : Parametre de Caractere.Rechercher(Modele:Nul Ou      */
/* Caractere, Position:Nul Ou Entier=Nul) Retourner Nul Ou      */
/* Caractere                                                    */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Modele : Nul Ou Caractere. */
TypUpsVmAdresse UpsVar2;
   /* Position : Nul Ou Entier. */
} TypPrmUpsKrn_2_29_1;

/****************************************************************/
typedef struct typprmupskrn_2_30_1
/* Objet : Parametre de Caractere.IdentiqueMajMin(Modele:Nul Ou */
/* Caractere) Retourner Nul Ou Booleen                          */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Chaine:Nul Ou Caractere. */
} TypPrmUpsKrn_2_30_1;

/****************************************************************/
typedef struct typprmupskrn_2_31_1
/* Objet : Parametre de Caractere.Comme(M:Nul Ou Caractere)     */
/* Retourner Nul Ou Booleen                                     */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Chaine:Nul Ou Caractere. */
} TypPrmUpsKrn_2_31_1;

/****************************************************************/
typedef struct upstrttypupskrn_2_1_1_0
/* Objet : Methodes du type Caractere.                          */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

/*--------------------------------------------------------------*/
/* Methodes heritees de EspaceMetre.                            */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_21_4_1 *UpsPrm);
   /* Operateur <=(C:Nul Ou Caractere) Retourner Nul Ou Booleen;*/
TypUpsVmAdresse UpsVmAPI *(*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_21_5_1 *UpsPrm);
   /* Operateur >=(C:Nul Ou Caractere) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_21_6_1 *UpsPrm);
   /* Operateur <(C:Nul Ou Caractere) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*Mth_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_21_7_1 *UpsPrm);
   /* Operateur >(C:Nul Ou Caractere) Retourner Nul Ou Booleen; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*Mth_8_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsKrn_2_8_2 *UpsPrm);
   /* Constructeur(B:Nul Ou Booleen) */
TypUpsVmAdresse UpsVmAPI *(*Mth_8_3)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsKrn_2_8_3 *UpsPrm);
   /* Constructeur(D:Nul Ou Date) */
TypUpsVmAdresse UpsVmAPI *(*Mth_8_4)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsKrn_2_8_4 *UpsPrm);
   /* Constructeur(D:Nul Ou Date, Filtre:Nul Ou Caractere) */
TypUpsVmAdresse UpsVmAPI *(*Mth_8_5)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsKrn_2_8_5 *UpsPrm);
   /* Constructeur(E:Nul Ou Entier) */
TypUpsVmAdresse UpsVmAPI *(*Mth_8_6)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsKrn_2_8_6 *UpsPrm);
   /* Constructeur(E:Nul Ou Entier, Filtre:Nul Ou Caractere) */
TypUpsVmAdresse UpsVmAPI *(*Mth_8_7)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsKrn_2_8_7 *UpsPrm);
   /* Constructeur(E:Nul Ou Entier, Filtre:Nul Ou Caractere, PointVirgule:Nul Ou Caractere) */
TypUpsVmAdresse UpsVmAPI *(*Mth_8_8)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsKrn_2_8_8 *UpsPrm);
   /* Constructeur(R:Nul Ou Reel) */
TypUpsVmAdresse UpsVmAPI *(*Mth_8_9)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsKrn_2_8_9 *UpsPrm);
   /* Constructeur(R:Nul Ou Reel, Filtre:Nul Ou Caractere) */
TypUpsVmAdresse UpsVmAPI *(*Mth_8_10)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsKrn_2_8_10 *UpsPrm);
   /* Constructeur(R:Nul Ou Reel, Filtre:Nul Ou Caractere, PointVirgule:Nul Ou Caractere) */
TypUpsVmAdresse UpsVmAPI *(*Mth_8_11)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsKrn_2_8_11 *UpsPrm);
   /* Constructeur(B:Nul Ou Binaire) */
TypUpsVmAdresse UpsVmAPI *(*Mth_9_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_2_9_1 *UpsPrm);
   /* Operateur +(C:Nul Ou Caractere) Retourner Nul Ou Caractere; */
TypUpsVmVoid UpsVmAPI (*Mth_10_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *UpsPrm);
   /* Operateur +=(C:Nul Ou Caractere) Retourner Nul Ou Caractere; */
TypUpsVmAdresse UpsVmAPI *(*Mth_11_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet);
   /* Operateur -() Retourner Nul Ou Caractere; */
TypUpsVmAdresse UpsVmAPI *(*Mth_12_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet);
   /* Fonction Longueur() Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_13_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_2_13_1 *UpsPrm);
   /* Fonction Gauche(Taille:Nul Ou Entier) Retourner Nul Ou Caractere; */
TypUpsVmAdresse UpsVmAPI *(*Mth_14_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_2_14_1 *UpsPrm);
   /* Fonction Droite(Taille:Nul Ou Entier) Retourner Nul Ou Caractere; */
TypUpsVmAdresse UpsVmAPI *(*Mth_15_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_2_15_1 *UpsPrm);
   /* Fonction Milieu(Position:Nul Ou Entier, Taille:Nul Ou Entier) Retourner Nul Ou Caractere; */
TypUpsVmAdresse UpsVmAPI *(*Mth_16_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_2_16_1 *UpsPrm);
   /* Fonction Unicode(Position:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_17_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet);
   /* Fonction Majuscule() Retourner Nul Ou Caractere; */
TypUpsVmAdresse UpsVmAPI *(*Mth_18_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet);
   /* Fonction MajMinuscule() Retourner Nul Ou Caractere; */
TypUpsVmAdresse UpsVmAPI *(*Mth_19_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet);
   /* Fonction Minuscule() Retourner Nul Ou Caractere; */
TypUpsVmAdresse UpsVmAPI *(*Mth_20_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_2_20_1 *UpsPrm);
   /* Fonction Inserer(Chaine:Nul Ou Caractere, Position:Nul Ou Entier) Retourner Nul Ou Caractere; */
TypUpsVmAdresse UpsVmAPI *(*Mth_21_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_2_21_1 *UpsPrm);
   /* Compter(Modele:Nul Ou Caractere, Position:Nul Ou Entier=Nul) Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_22_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_2_22_1 *UpsPrm);
   /* Fonction Remplacer(Modele:Nul Ou Caractere, Remplacant:Nul Ou Caractere, Position:Nul Ou Entier=Nul) Retourner Nul Ou Caractere; */
TypUpsVmAdresse UpsVmAPI *(*Mth_23_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_2_23_1 *UpsPrm);
   /* Fonction Ajouter(Taille:Nul Ou Entier, Modele:Nul Ou Caractere=" ") Retourner Nul Ou Caractere; */
TypUpsVmAdresse UpsVmAPI *(*Mth_24_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_2_24_1 *UpsPrm);
   /* Fonction AjouterDroite(Taille:Nul Ou Entier, Modele:Nul Ou Caractere=" ") Retourner Nul Ou Caractere; */
TypUpsVmAdresse UpsVmAPI *(*Mth_25_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_2_25_1 *UpsPrm);
   /* Fonction AjouterGauche(Taille:Nul Ou Entier, Modele:Nul Ou Caractere=" ") Retourner Nul Ou Caractere; */
TypUpsVmAdresse UpsVmAPI *(*Mth_26_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_2_26_1 *UpsPrm);
   /* Fonction Supprimer(Modele:Nul Ou Caractere=" ") Retourner Nul Ou Caractere; */
TypUpsVmAdresse UpsVmAPI *(*Mth_27_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_2_27_1 *UpsPrm);
   /* Fonction SupprimerDroite(Modele:Nul Ou Caractere=" ") Retourner Nul Ou Caractere; */
TypUpsVmAdresse UpsVmAPI *(*Mth_28_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_2_28_1 *UpsPrm);
   /* Fonction SupprimerGauche(Modele:Nul Ou Caractere=" ") Retourner Nul Ou Caractere; */
TypUpsVmAdresse UpsVmAPI *(*Mth_29_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_2_29_1 *UpsPrm);
   /* Fonction Rechercher(Modele:Nul Ou Caractere, Position:Nul Ou Entier=Nul) Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_30_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_2_30_1 *UpsPrm);
   /* Fonction IdentiqueMajMin(Chaine:Nul Ou Caractere) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*Mth_31_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_2_31_1 *UpsPrm);
   /* Operateur Comme(C:Nul Ou Caractere) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*Mth_32_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet);
   /* Fonction IlExisteJoker() Retourner Nul Ou Booleen; */

/*--------------------------------------------------------------*/
/* Methodes heritees de EspaceMetre.                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_4_1;
   /* Operateur <=(C:Nul Ou Caractere) Retourner Booleen;*/
TypUpsVmCoAppel CoMth_5_1;
   /* Operateur >=(C:Nul Ou Caractere) Retourner Booleen; */
TypUpsVmCoAppel CoMth_6_1;
   /* Operateur <(C:Nul Ou Caractere) Retourner Booleen; */
TypUpsVmCoAppel CoMth_7_1;
   /* Operateur >(C:Nul Ou Caractere) Retourner Booleen; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_8_2;
   /* Constructeur(B:Nul Ou Booleen) */
TypUpsVmCoAppel CoMth_8_3;
   /* Constructeur(D:Nul Ou Date) */
TypUpsVmCoAppel CoMth_8_4;
   /* Constructeur(D:Nul Ou Date, Filtre:Nul Ou Caractere) */
TypUpsVmCoAppel CoMth_8_5;
   /* Constructeur(E:Nul Ou Entier) */
TypUpsVmCoAppel CoMth_8_6;
   /* Constructeur(E:Nul Ou Entier, Filtre:Nul Ou Caractere) */
TypUpsVmCoAppel CoMth_8_7;
   /* Constructeur(E:Nul Ou Entier, Filtre:Nul Ou Caractere, PointVirgule:Nul Ou Caractere) */
TypUpsVmCoAppel CoMth_8_8;
   /* Constructeur(R:Nul Ou Reel) */
TypUpsVmCoAppel CoMth_8_9;
   /* Constructeur(R:Nul Ou Reel, Filtre:Nul Ou Caractere) */
TypUpsVmCoAppel CoMth_8_10;
   /* Constructeur(R:Nul Ou Reel, Filtre:Nul Ou Caractere, PointVirgule:Nul Ou Caractere) */
TypUpsVmCoAppel CoMth_8_11;
   /* Constructeur(B:Nul Ou Binaire) */
TypUpsVmCoAppel CoMth_9_1;
   /* Operateur +(C:Nul Ou Caractere) Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_10_1;
   /* Operateur +=(C:Nul Ou Caractere) Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_11_1;
   /* Operateur -() Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_12_1;
   /* Fonction TypUpsVmLongueur() Retourner Entier; */
TypUpsVmCoAppel CoMth_13_1;
   /* Fonction Gauche(Taille:Nul Ou Entier) Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_14_1;
   /* Fonction Droite(Taille:Nul Ou Entier) Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_15_1;
   /* Fonction Milieu(Position:Nul Ou Entier, Taille:Nul Ou Entier) Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_16_1;
   /* Fonction Unicode(Position:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_17_1;
   /* Fonction Majuscule() Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_18_1;
   /* Fonction MajMinuscule() Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_19_1;
   /* Fonction Minuscule() Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_20_1;
   /* Fonction Inserer(Chaine:Nul Ou Caractere, Position:Nul Ou Entier) Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_21_1;
   /* Compter(Modele:Nul Ou Caractere, Position:Nul Ou Entier=Nul) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_22_1;
   /* Fonction Remplacer(Modele:Nul Ou Caractere, Remplacant:Nul Ou Caractere, Position:Nul Ou Entier=Nul) Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_23_1;
   /* Fonction Ajouter(Taille:Nul Ou Entier, Modele:Nul Ou Caractere=" ") Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_24_1;
   /* Fonction AjouterDroite(Taille:Nul Ou Entier, Modele:Nul Ou Caractere=" ") Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_25_1;
   /* Fonction AjouterGauche(Taille:Nul Ou Entier, Modele:Nul Ou Caractere=" ") Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_26_1;
   /* Fonction Supprimer(Modele:Nul Ou Caractere=" ") Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_27_1;
   /* Fonction SupprimerDroite(Modele:Nul Ou Caractere=" ") Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_28_1;
   /* Fonction SupprimerGauche(Modele:Nul Ou Caractere=" ") Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_29_1;
   /* Fonction Rechercher(Modele:Nul Ou Caractere, Position:Nul Ou Entier=Nul) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_30_1;
   /* Fonction IdentiqueMajMin(Chaine:Nul Ou Caractere) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_31_1;
   /* Operateur Comme(C:Nul Ou Caractere) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_32_1;
   /* Fonction IlExisteJoker() Retourner Nul Ou Booleen; */
} UpsTrtTypUpsKrn_2_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTrtTypUpsKrn_2_1_1_0 UpsTrtTypUpsKrn_2;

/****************************************************************/
typedef struct upstypupskrn_3_1_1_0
/* Objet : Proprietes du type Date.                             */
/****************************************************************/
{
TypUpsVmAdresse UpsObjet1;
   /* Objet pour EspaceMetre. */
TypUpsVmLong UpsChamp1;
   /* Jour:Entier; */
TypUpsVmLong UpsChamp2;
   /* Mois:Entier; */
TypUpsVmLong UpsChamp3;
   /* Annee:Entier; */
TypUpsVmLong UpsChamp4;
   /* Heure:Entier; */
TypUpsVmLong UpsChamp5;
   /* Minute:Entier; */
TypUpsVmLong UpsChamp6;
   /* Seconde:Entier; */
TypUpsVmLong UpsChamp7;
   /* Millieme:Entier; */
} UpsTypUpsKrn_3_1_1_0;

/****************************************************************/
typedef struct TypPrmUpsKrn_3_8_2
/* Objet : Parametre de Date.Constructeur(D:Nul Ou Caractere)   */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* D : Nul Ou Caractere. */
} TypPrmUpsKrn_3_8_2;

/****************************************************************/
typedef struct typprmupskrn_3_8_3
/* Objet : Parametre de Date.Constructeur(J:Nul Ou Entier, M:Nul*/
/* Ou Entier, A:Nul Ou Entier)                                  */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* J : Nul Ou Entier. */
TypUpsVmAdresse UpsVar2;
   /* M : Nul Ou Entier. */
TypUpsVmAdresse UpsVar3;
   /* A : Nul Ou Entier. */
} TypPrmUpsKrn_3_8_3;

/****************************************************************/
typedef struct typprmupskrn_3_8_4
/* Objet : Parametre de Date.Constructeur(J:Nul Ou Entier, M:Nul*/
/* Ou Entier, A:Nul Ou Entier, H:Nul Ou Entier, Mi:Nul Ou       */
/* Entier, S:Nul Ou Entier)                                     */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* J : Nul Ou Entier. */
TypUpsVmAdresse UpsVar2;
   /* M : Nul Ou Entier. */
TypUpsVmAdresse UpsVar3;
   /* A : Nul Ou Entier. */
TypUpsVmAdresse UpsVar4;
   /* H : Nul Ou Entier. */
TypUpsVmAdresse UpsVar5;
   /* Mi : Nul Ou Entier. */
TypUpsVmAdresse UpsVar6;
   /* S : Nul Ou Entier. */
} TypPrmUpsKrn_3_8_4;

/****************************************************************/
typedef struct typprmupskrn_3_8_5
/* Objet : Parametre de Date.Constructeur(J:Nul Ou Entier, M:Nul*/
/* Ou Entier, A:Nul Ou Entier, H:Nul Ou Entier, Mi:Nul Ou       */
/* Entier, S:Nul Ou Entier, Ms:Nul Ou Entier)                   */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* J : Nul Ou Entier. */
TypUpsVmAdresse UpsVar2;
   /* M : Nul Ou Entier. */
TypUpsVmAdresse UpsVar3;
   /* A : Nul Ou Entier. */
TypUpsVmAdresse UpsVar4;
   /* H : Nul Ou Entier. */
TypUpsVmAdresse UpsVar5;
   /* Mi : Nul Ou Entier. */
TypUpsVmAdresse UpsVar6;
   /* S : Nul Ou Entier. */
TypUpsVmAdresse UpsVar7;
   /* Ms : Nul Ou Entier. */
} TypPrmUpsKrn_3_8_5;

/****************************************************************/
typedef struct typprmupskrn_3_9_1
/* Objet : Parametre de Date.Operateur +(S:Nul Ou Entier)       */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* S : Nul Ou Entier. */
} TypPrmUpsKrn_3_9_1;

/****************************************************************/
typedef struct typprmupskrn_3_11_1
/* Objet : Parametre de Date.Operateur -(S:Nul Ou Entier)       */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* S : Nul Ou Entier. */
} TypPrmUpsKrn_3_11_1;

/****************************************************************/
typedef struct typprmupskrn_3_11_2
/* Objet : Parametre de Date.Operateur -(D:Nul Ou Date)         */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* S : Nul Ou Date. */
} TypPrmUpsKrn_3_11_2;

/****************************************************************/
typedef struct TypPrmUpsKrn_3_13_1
/* Objet : Parametre de Date.AjouterJours(J:Nul Ou Entier)      */
/* Retourner Nul Ou Date                                        */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* J : Nul Ou Entier. */
} TypPrmUpsKrn_3_13_1;

/****************************************************************/
typedef struct typprmupskrn_3_14_1
/* Objet : Parametre de Date.AjouterMois(J:Nul Ou Entier)       */
/* Retourner Nul Ou Date                                        */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* M : Nul Ou Entier. */
} TypPrmUpsKrn_3_14_1;

/****************************************************************/
typedef struct typprmupskrn_3_15_1
/* Objet : Parametre de Date.AjouterAnnees(A:Nul Ou Entier)     */
/* Retourner Nul Ou Date                                        */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* A : Nul Ou Entier. */
} TypPrmUpsKrn_3_15_1;

/****************************************************************/
typedef struct typprmupskrn_3_16_1
/* Objet : Parametre de Date.AjouterHeures(H:Nul Ou Entier)     */
/* Retourner Nul Ou Date                                        */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* H : Nul Ou Entier. */
} TypPrmUpsKrn_3_16_1;

/****************************************************************/
typedef struct typprmupskrn_3_17_1
/* Objet : Parametre de Date.AjouterMinutes(J:Nul Ou Entier)    */
/* Retourner Nul Ou Date                                        */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Mi : Nul Ou Entier. */
} TypPrmUpsKrn_3_17_1;

/****************************************************************/
typedef struct typprmupskrn_3_18_1
/* Objet : Parametre de Date.AjouterMilliemes(J:Nul Ou Entier)  */
/* Retourner Nul Ou Date                                        */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* S : Nul Ou Entier. */
} TypPrmUpsKrn_3_18_1;

/****************************************************************/
typedef struct upstrttypupskrn_3_1_1_0
/* Objet : Methodes du type Date.                               */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

/*--------------------------------------------------------------*/
/* Methodes heritees de EspaceMetre.                            */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_21_4_1 *UpsPrm);
   /* Operateur <=(D:Date) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_21_5_1 *UpsPrm);
   /* Operateur >=(D:Date) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_21_6_1 *UpsPrm);
   /* Operateur <(D:Date) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*Mth_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_21_7_1 *UpsPrm);
   /* Operateur >(D:Date) Retourner Nul Ou Booleen; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*Mth_8_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsKrn_3_8_2 *UpsPrm);
   /* Constructeur(D:Nul Ou Caractere) */
TypUpsVmAdresse UpsVmAPI *(*Mth_8_3)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsKrn_3_8_3 *UpsPrm);
   /* Constructeur(J:Nul Ou Entier, M:Nul Ou Entier, A:Nul Ou Entier) */
TypUpsVmAdresse UpsVmAPI *(*Mth_8_4)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsKrn_3_8_4 *UpsPrm);
   /* Constructeur(J:Nul Ou Entier, M:Nul Ou Entier, A:Nul Ou Entier, H:Nul Ou Entier, Mi:Nul Ou Entier, S:Nul Ou Entier) */
TypUpsVmAdresse UpsVmAPI *(*Mth_8_5)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsKrn_3_8_5 *UpsPrm);
   /* Constructeur(J:Nul Ou Entier, M:Nul Ou Entier, A:Nul Ou Entier, H:Nul Ou Entier, Mi:Nul Ou Entier, S:Nul Ou Entier, Ms:Nul Ou Entier) */
TypUpsVmAdresse UpsVmAPI *(*Mth_9_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_3_9_1 *UpsPrm);
   /* Operateur +(S:Nul Ou Entier) Retourner Nul Ou Date; */
TypUpsVmVoid UpsVmAPI (*Mth_10_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *UpsPrm);
   /* Operateur +=(S:Nul Ou Entier); */
TypUpsVmAdresse UpsVmAPI *(*Mth_11_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_3_11_1 *UpsPrm);
   /* Operateur -(S:Nul Ou Entier) Retourner Nul Ou Date; */
TypUpsVmAdresse UpsVmAPI *(*Mth_11_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_3_11_2 *UpsPrm);
   /* Operateur -(D:Nul Ou Date) Retourner Nul Ou Reel; */
TypUpsVmVoid UpsVmAPI (*Mth_12_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *UpsPrm);
   /* Operateur -=(S:Nul Ou Entier); */
TypUpsVmAdresse UpsVmAPI *(*Mth_13_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_3_13_1 *UpsPrm);
   /* Fonction AjouterJours(J:Nul Ou Entier) Retourner Nul Ou Date; */
TypUpsVmAdresse UpsVmAPI *(*Mth_14_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_3_14_1 *UpsPrm);
   /* Fonction AjouterMois(M:Nul Ou Entier) Retourner Nul Ou Date; */
TypUpsVmAdresse UpsVmAPI *(*Mth_15_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_3_15_1 *UpsPrm);
   /* Fonction AjouterAnnees(A:Nul Ou Entier) Retourner Nul Ou Date; */
TypUpsVmAdresse UpsVmAPI *(*Mth_16_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_3_16_1 *UpsPrm);
   /* Fonction AjouterHeures(H:Nul Ou Entier) Retourner Nul Ou Date; */
TypUpsVmAdresse UpsVmAPI *(*Mth_17_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_3_17_1 *UpsPrm);
   /* Fonction AjouterMinutes(Mi:Nul Ou Entier) Retourner Nul Ou Date; */
TypUpsVmAdresse UpsVmAPI *(*Mth_18_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_3_18_1 *UpsPrm);
   /* Fonction AjouterMilliemes(Ms:Nul Ou Entier) Retourner Nul Ou Date; */
TypUpsVmAdresse UpsVmAPI *(*Mth_19_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet);
   /* Fonction DernierJour() Retourner Nul Ou Date; */

/*--------------------------------------------------------------*/
/* Methodes heritees de EspaceMetre.                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_4_1;
   /* Operateur <=(D:Date) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_5_1;
   /* Operateur >=(D:Date) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_6_1;
   /* Operateur <(D:Date) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_7_1;
   /* Operateur >(D:Date) Retourner Nul Ou Booleen; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_8_2;
   /* Constructeur(D:Nul Ou Caractere) */
TypUpsVmCoAppel CoMth_8_3;
   /* Constructeur(J:Nul Ou Entier, M:Nul Ou Entier, A:Nul Ou Entier) */
TypUpsVmCoAppel CoMth_8_4;
   /* Constructeur(J:Nul Ou Entier, M:Nul Ou Entier, A:Nul Ou Entier, H:Nul Ou Entier, Mi:Nul Ou Entier, S:Nul Ou Entier) */
TypUpsVmCoAppel CoMth_8_5;
   /* Constructeur(J:Nul Ou Entier, M:Nul Ou Entier, A:Nul Ou Entier, H:Nul Ou Entier, Mi:Nul Ou Entier, S:Nul Ou Entier, Ms:Nul Ou Entier) */
TypUpsVmCoAppel CoMth_9_1;
   /* Operateur +(S:Nul Ou Entier) Retourner Nul Ou Date; */
TypUpsVmCoAppel CoMth_10_1;
   /* Operateur +=(S:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_11_1;
   /* Operateur -(S:Nul Ou Entier) Retourner Nul Ou Date; */
TypUpsVmCoAppel CoMth_11_2;
   /* Operateur -(D:Nul Ou Date) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_12_1;
   /* Operateur -=(S:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_13_1;
   /* Fonction AjouterJours(J:Nul Ou Entier) Retourner Nul Ou Date; */
TypUpsVmCoAppel CoMth_14_1;
   /* Fonction AjouterMois(M:Nul Ou Entier) Retourner Nul Ou Date; */
TypUpsVmCoAppel CoMth_15_1;
   /* Fonction AjouterAnnees(A:Nul Ou Entier) Retourner Nul Ou Date; */
TypUpsVmCoAppel CoMth_16_1;
   /* Fonction AjouterHeures(H:Nul Ou Entier) Retourner Nul Ou Date; */
TypUpsVmCoAppel CoMth_17_1;
   /* Fonction AjouterMinutes(Mi:Nul Ou Entier) Retourner Nul Ou Date; */
TypUpsVmCoAppel CoMth_18_1;
   /* Fonction AjouterMilliemes(Ms:Nul Ou Entier) Retourner Nul Ou Date; */
TypUpsVmCoAppel CoMth_19_1;
   /* Fonction DernierJour() Retourner Nul Ou Date; */
} UpsTrtTypUpsKrn_3_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsKrn_3_1_1_0 UpsTypUpsKrn_3;
typedef UpsTrtTypUpsKrn_3_1_1_0 UpsTrtTypUpsKrn_3;

/****************************************************************/
typedef struct typprmupskrn_22_1_1
/* Objet : Parametre de AlgebreCommutative.+(A:Nul Ou           */
/* AlgebreCommutative)                                          */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* A : Nul Ou AlgebreCommutative. */
} TypPrmUpsKrn_22_1_1;

/****************************************************************/
typedef struct typprmupskrn_22_2_2
/* Objet : Parametre de AlgebreCommutative.-(A:Nul Ou           */
/* AlgebreCommutative)                                          */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* A : Nul Ou AlgebreCommutative. */
} TypPrmUpsKrn_22_2_2;

/****************************************************************/
typedef struct typprmupskrn_22_3_1
/* Objet : Parametre de AlgebreCommutative.*(A:Nul Ou           */
/* AlgebreCommutative)                                          */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* A : Nul Ou AlgebreCommutative. */
} TypPrmUpsKrn_22_3_1;

/****************************************************************/
typedef struct typprmupskrn_22_4_1
/* Objet : Parametre de AlgebreCommutative.++(B:Booleen)        */
/****************************************************************/
{
TypUpsVmUnsignedChar UpsVar1;
   /* B : Booleen. */
} TypPrmUpsKrn_22_4_1;

/****************************************************************/
typedef struct typprmupskrn_22_5_1
/* Objet : Parametre de AlgebreCommutative.--(B:Nul Ou Booleen) */
/****************************************************************/
{
TypUpsVmUnsignedChar UpsVar1;
   /* B : Booleen. */
} TypPrmUpsKrn_22_5_1;

/****************************************************************/
typedef struct upstrttypupskrn_22_1_1_0
/* Objet : Methodes du type AlgebreCommutative.                 */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmAdresse UpsVmAPI *(*Mth_1_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_22_1_1 *UpsPrm);
   /* Operateur +(A:Nul Ou AlgebreCommutative) Retourner Nul Ou AlgebreCommutative; */
TypUpsVmAdresse UpsVmAPI *(*Mth_2_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet);
   /* Operateur -() Retourner Nul Ou AlgebreCommutative; */
TypUpsVmAdresse UpsVmAPI *(*Mth_2_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_22_2_2 *UpsPrm);
   /* Operateur -(A:Nul Ou AlgebreCommutative) Retourner Nul Ou AlgebreCommutative; */
TypUpsVmAdresse UpsVmAPI *(*Mth_3_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_22_3_1 *UpsPrm);
   /* Operateur *(A:Nul Ou AlgebreCommutative) Retourner Nul Ou AlgebreCommutative; */
TypUpsVmAdresse UpsVmAPI *(*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_22_4_1 *UpsPrmP);
   /* Operateur ++(B:Booleen) Retourner Nul Ou AlgebreCommutative; */
TypUpsVmAdresse UpsVmAPI *(*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_22_5_1 *UpsPrm);
   /* Operateur --(B:Booleen) Retourner Nul Ou AlgebreCommutative; */

TypUpsVmCoAppel CoMth_1_1;
   /* Operateur +(A:Nul Ou AlgebreCommutative) Retourner Nul Ou AlgebreCommutative; */
TypUpsVmCoAppel CoMth_2_1;
   /* Operateur -() Retourner Nul Ou AlgebreCommutative; */
TypUpsVmCoAppel CoMth_2_2;
   /* Operateur -(A:Nul Ou AlgebreCommutative) Retourner Nul Ou AlgebreCommutative; */
TypUpsVmCoAppel CoMth_3_1;
   /* Operateur *(A:Nul Ou AlgebreCommutative) Retourner Nul Ou AlgebreCommutative; */
TypUpsVmCoAppel CoMth_4_1;
   /* Operateur ++(B:Booleen) Retourner Nul Ou AlgebreCommutative; */
TypUpsVmCoAppel CoMth_5_1;
   /* Operateur --(B:Booleen) Retourner Nul Ou AlgebreCommutative; */
} UpsTrtTypUpsKrn_22_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTrtTypUpsKrn_22_1_1_0 UpsTrtTypUpsKrn_22;

/****************************************************************/
typedef struct upstypupskrn_23_1_1_0
/* Objet : Proprietes du type CorpsCommutatif.                  */
/****************************************************************/
{
TypUpsVmAdresse UpsObjet1;
   /* Objet pour AlgebreCommutative. */
} UpsTypUpsKrn_23_1_1_0;

/****************************************************************/
typedef struct TypPrmUpsKrn_23_6_1
/* Objet : Parametre de CorpsCommutatif./(C:Nul Ou              */
/* CorpsCommutatif)                                             */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* C : Nul Ou CorpsCommutatif. */
} TypPrmUpsKrn_23_6_1;

/****************************************************************/
typedef struct typprmupskrn_23_7_1
/* Objet : Parametre de CorpsCommutatif.^(C:Nul Ou              */
/* CorpsCommutatif)                                             */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* C : Nul Ou CorpsCommutatif. */
} TypPrmUpsKrn_23_7_1;

/****************************************************************/
typedef struct upstrttypupskrn_23_1_1_0
/* Objet : Methodes du type CorpsCommutatif.                    */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

/*--------------------------------------------------------------*/
/* Methodes heritees de AlgebreCommutative.                     */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*Mth_1_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_22_1_1 *UpsPrm);
   /* Operateur +(C:Nul Ou CorpsCommutatif) Retourner Nul Ou CorpsCommutatif; */
TypUpsVmAdresse UpsVmAPI *(*Mth_2_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet);
   /* Operateur -() Retourner Nul Ou CorpsCommutatif; */
TypUpsVmAdresse UpsVmAPI *(*Mth_2_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_22_2_2 *UpsPrm);
   /* Operateur -(C:Nul Ou CorpsCommutatif) Retourner Nul Ou CorpsCommutatif; */
TypUpsVmAdresse UpsVmAPI *(*Mth_3_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_22_3_1 *UpsPrm);
   /* Operateur *(C:Nul Ou CorpsCommutatif) Retourner Nul Ou CorpsCommutatif; */
TypUpsVmAdresse UpsVmAPI *(*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_22_4_1 *UpsPrmP);
   /* Operateur ++(B:Booleen) Retourner Nul Ou CorpsCommutatif; */
TypUpsVmAdresse UpsVmAPI *(*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_22_5_1 *UpsPrm);
   /* Operateur --(B:Booleen) Retourner Nul Ou CorpsCommutatif; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_23_6_1 *UpsPrm);
   /* Operateur /(C:Nul Ou Corps) Retourner Nul Ou Corps; */
TypUpsVmAdresse UpsVmAPI *(*Mth_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_23_7_1 *UpsPrm);
   /* Operateur ^(C:Nul Ou Corps) Retourner Nul Ou Corps; */

/*--------------------------------------------------------------*/
/* Methodes heritees de AlgebreCommutative.                     */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_1_1;
   /* Operateur +(C:Nul Ou CorpsCommutatif) Retourner Nul Ou CorpsCommutatif; */
TypUpsVmCoAppel CoMth_2_1;
   /* Operateur -() Retourner Nul Ou CorpsCommutatif; */
TypUpsVmCoAppel CoMth_2_2;
   /* Operateur -(C:Nul Ou CorpsCommutatif) Retourner Nul Ou CorpsCommutatif; */
TypUpsVmCoAppel CoMth_3_1;
   /* Operateur *(C:Nul Ou CorpsCommutatif) Retourner Nul Ou CorpsCommutatif; */
TypUpsVmCoAppel CoMth_4_1;
   /* Operateur ++(B:Booleen) Retourner Nul Ou CorpsCommutatif; */
TypUpsVmCoAppel CoMth_5_1;
   /* Operateur --(B:Booleen) Retourner Nul Ou CorpsCommutatif; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_6_1;
   /* Operateur /(C:Nul Ou Corps) Retourner Nul Ou Corps; */
TypUpsVmCoAppel CoMth_7_1;
   /* Operateur ^(C:Nul Ou Corps) Retourner Nul Ou Corps; */
} UpsTrtTypUpsKrn_23_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsKrn_23_1_1_0 UpsTypUpsKrn_23;
typedef UpsTrtTypUpsKrn_23_1_1_0 UpsTrtTypUpsKrn_23;

/****************************************************************/
typedef struct upstypupskrn_4_1_1_0
/* Objet : Proprietes du type Entier.                           */
/****************************************************************/
{
TypUpsVmAdresse UpsObjet1;
   /* Objet pour AlgebreCommutative. */
TypUpsVmAdresse UpsObjet2;
   /* Objet pour EspaceMetre. */
TypUpsVmLong Entier;
   /* Pour un entier. */
} UpsTypUpsKrn_4_1_1_0;

/****************************************************************/
typedef struct typprmupskrn_4_1_2
/* Objet : Parametre de Entier.+(R:Nul Ou Reel)                 */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* R : Nul Ou Reel. */
} TypPrmUpsKrn_4_1_2;

/****************************************************************/
typedef struct typprmupskrn_4_2_3
/* Objet : Parametre de Entier.-(R:Nul Ou Reel)                 */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* R : Nul Ou Reel. */
} TypPrmUpsKrn_4_2_3;

/****************************************************************/
typedef struct typprmupskrn_4_7_2
/* Objet : Parametre de Entier.==(R:Nul Ou Reel)                */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* R : Nul Ou Reel. */
} TypPrmUpsKrn_4_7_2;

/****************************************************************/
typedef struct typprmupskrn_4_8_2
/* Objet : Parametre de Entier.!=(R:Nul Ou Reel)                */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* R : Nul Ou Reel. */
} TypPrmUpsKrn_4_8_2;

/****************************************************************/
typedef struct typprmupskrn_4_9_2
/* Objet : Parametre de Entier.<=(R:Nul Ou Reel)                */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* R : Nul Ou Reel. */
} TypPrmUpsKrn_4_9_2;

/****************************************************************/
typedef struct typprmupskrn_4_10_2
/* Objet : Parametre de Entier.>=(R:Nul Ou Reel)                */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* R : Nul Ou Reel. */
} TypPrmUpsKrn_4_10_2;

/****************************************************************/
typedef struct typprmupskrn_4_11_2
/* Objet : Parametre de Entier.<(R:Nul Ou Reel)                 */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* R : Nul Ou Reel. */
} TypPrmUpsKrn_4_11_2;

/****************************************************************/
typedef struct typprmupskrn_4_12_2
/* Objet : Parametre de Entier.>(R:Nul Ou Reel)                 */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* R : Nul Ou Reel. */
} TypPrmUpsKrn_4_12_2;

/****************************************************************/
typedef struct typprmupskrn_4_16_2
/* Objet : Parametre de Entier.Constructeur(R:Nul Ou Reel)      */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* R : Nul Ou Reel. */
} TypPrmUpsKrn_4_16_2;

/****************************************************************/
typedef struct typprmupskrn_4_16_3
/* Objet : Parametre de Entier.Constructeur(C:Nul Ou Caractere) */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* C : Nul Ou Caractere. */
} TypPrmUpsKrn_4_16_3;

/****************************************************************/
typedef struct typprmupskrn_4_3_2
/* Objet : Parametre de Entier.*(R:Nul Ou Reel)                 */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* R : Nul Ou Reel. */
} TypPrmUpsKrn_4_3_2;

/****************************************************************/
typedef struct typprmupskrn_4_17_1
/* Objet : Parametre de Entier./(E:Nul Ou Entier)               */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E : Nul Ou Entier. */
} TypPrmUpsKrn_4_17_1;

/****************************************************************/
typedef struct typprmupskrn_4_17_2
/* Objet : Parametre de Entier./(R:Nul Ou Reel)                 */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* R : Nul Ou Reel. */
} TypPrmUpsKrn_4_17_2;

/****************************************************************/
typedef struct typprmupskrn_4_18_1
/* Objet : Parametre de Entier.\(E:Nul Ou Entier)               */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E : Nul Ou Entier. */
} TypPrmUpsKrn_4_18_1;

/****************************************************************/
typedef struct typprmupskrn_4_18_2
/* Objet : Parametre de Entier.\(R:Nul Ou Reel)                 */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* R : Nul Ou Reel. */
} TypPrmUpsKrn_4_18_2;

/****************************************************************/
typedef struct typprmupskrn_4_20_1
/* Objet : Parametre de Entier.%(E:Nul Ou Entier)               */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E : Nul Ou Entier. */
} TypPrmUpsKrn_4_20_1;

/****************************************************************/
typedef struct typprmupskrn_4_22_1
/* Objet : Parametre de Entier.^(E:Nul Ou Entier)               */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E : Nul Ou Entier. */
} TypPrmUpsKrn_4_22_1;

/****************************************************************/
typedef struct typprmupskrn_4_22_2
/* Objet : Parametre de Entier.^(R:Nul Ou Reel)                 */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E : Nul Ou Entier. */
} TypPrmUpsKrn_4_22_2;

/****************************************************************/
typedef struct typprmupskrn_4_24_1
/* Objet : Parametre de Entier.&(E:Nul Ou Entier)               */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E : Nul Ou Entier. */
} TypPrmUpsKrn_4_24_1;

/****************************************************************/
typedef struct typprmupskrn_4_26_1
/* Objet : Parametre de Entier.|(E:Nul Ou Entier)               */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E : Nul Ou Entier. */
} TypPrmUpsKrn_4_26_1;

/****************************************************************/
typedef struct typprmupskrn_4_28_1
/* Objet : Parametre de Entier.<<(E:Nul Ou Entier)              */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E : Nul Ou Entier. */
} TypPrmUpsKrn_4_28_1;

/****************************************************************/
typedef struct typprmupskrn_4_30_1
/* Objet : Parametre de Entier.>>(E:Nul Ou Entier)              */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E : Nul Ou Entier. */
} TypPrmUpsKrn_4_30_1;

/****************************************************************/
typedef struct upstrttypupskrn_4_1_1_0
/* Objet : Methodes du type Entier.                             */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

/*--------------------------------------------------------------*/
/* Methodes heritees de AlgebreCommutative.                     */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*Mth_1_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_22_1_1 *UpsPrm);
   /* Operateur +(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_2_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet);
   /* Operateur -() Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_2_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_22_2_2 *UpsPrm);
   /* Operateur -(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_3_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_22_3_1 *UpsPrm);
   /* Operateur *(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_22_4_1 *UpsPrmP);
   /* Operateur ++(B:Booleen) Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_22_5_1 *UpsPrm);
   /* Operateur --(B:Booleen) Retourner Nul Ou Entier; */
/*--------------------------------------------------------------*/
/* Methodes heritees de EspaceMetre.                            */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*Mth_9_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_21_4_1 *UpsPrm);
   /* Operateur <=(E:Entier) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*Mth_10_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_21_5_1 *UpsPrm);
   /* Operateur >=(E:Entier) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*Mth_11_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_21_6_1 *UpsPrm);
   /* Operateur <(E:Entier) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*Mth_12_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_21_7_1 *UpsPrm);
   /* Operateur >(E:Entier) Retourner Nul Ou Booleen; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*Mth_13_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *UpsPrm);
   /* Operateur +=(E:Nul Ou Entier); */
TypUpsVmVoid UpsVmAPI (*Mth_14_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *UpsPrm);
   /* Operateur -=(E:Nul Ou Entier); */
TypUpsVmVoid UpsVmAPI (*Mth_15_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *UpsPrm);
   /* Operateur *=(E:Nul Ou Entier); */
TypUpsVmAdresse UpsVmAPI *(*Mth_16_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsKrn_4_16_2 *UpsPrm);
   /* Constructeur(R:Nul Ou Reel); */
TypUpsVmAdresse UpsVmAPI *(*Mth_16_3)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsKrn_4_16_3 *UpsPrm);
   /* Constructeur(C:Nul Ou Caractere); */
TypUpsVmAdresse UpsVmAPI *(*Mth_1_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_4_1_2 *UpsPrm);
   /* Operateur +(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmAdresse UpsVmAPI *(*Mth_2_3)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_4_2_3 *UpsPrm);
   /* Operateur -(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmAdresse UpsVmAPI *(*Mth_3_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_4_3_2 *UpsPrm);
   /* Operateur *(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmAdresse UpsVmAPI *(*Mth_17_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_4_17_1 *UpsPrm);
   /* Operateur /(E:Nul Ou Entier) Retourner Nul Ou Reel; */
TypUpsVmAdresse UpsVmAPI *(*Mth_17_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_4_17_2 *UpsPrm);
   /* Operateur /(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmAdresse UpsVmAPI *(*Mth_18_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_4_18_1 *UpsPrm);
   /* Operateur \(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_18_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_4_18_2 *UpsPrm);
   /* Operateur \(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmVoid UpsVmAPI (*Mth_19_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *UpsPrm);
   /* Operateur \=(E:Nul Ou Entier); */
TypUpsVmVoid UpsVmAPI (*Mth_19_2)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *UpsPrm);
   /* Operateur \=(R:Nul Ou Reel); */
TypUpsVmAdresse UpsVmAPI *(*Mth_20_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_4_20_1 *UpsPrm);
   /* Operateur %(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmVoid UpsVmAPI (*Mth_21_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *UpsPrm);
   /* Operateur %=(E:Nul Ou Entier); */
TypUpsVmAdresse UpsVmAPI *(*Mth_22_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_4_22_1 *UpsPrm);
   /* Operateur ^(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_22_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_4_22_2 *UpsPrm);
   /* Operateur ^(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmVoid UpsVmAPI (*Mth_23_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *UpsPrm);
   /* Operateur ^=(E:Nul Ou Entier); */
TypUpsVmAdresse UpsVmAPI *(*Mth_24_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_4_24_1 *UpsPrm);
   /* Operateur &(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmVoid UpsVmAPI (*Mth_25_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *UpsPrm);
   /* Operateur &=(E:Nul Ou Entier); */
TypUpsVmAdresse UpsVmAPI *(*Mth_26_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_4_26_1 *UpsPrm);
   /* Operateur |(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmVoid UpsVmAPI (*Mth_27_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *UpsPrm);
   /* Operateur |=(E:Nul Ou Entier); */
TypUpsVmAdresse UpsVmAPI *(*Mth_28_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_4_28_1 *UpsPrm);
   /* Operateur <<(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmVoid UpsVmAPI (*Mth_29_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *UpsPrm);
   /* Operateur <<=(E:Nul Ou Entier); */
TypUpsVmAdresse UpsVmAPI *(*Mth_30_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_4_30_1 *UpsPrm);
   /* Operateur >>(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmVoid UpsVmAPI (*Mth_31_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *UpsPrm);
   /* Operateur >>=(E:Nul Ou Entier); */
TypUpsVmAdresse UpsVmAPI *(*Mth_7_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_4_7_2 *UpsPrm);
   /* Operateur ==(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*Mth_8_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_4_8_2 *UpsPrm);
   /* Operateur !=(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*Mth_9_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_4_9_2 *UpsPrm);
   /* Operateur <=(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*Mth_10_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_4_10_2 *UpsPrm);
   /* Operateur >=(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*Mth_11_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_4_11_2 *UpsPrm);
   /* Operateur <(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*Mth_12_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_4_12_2 *UpsPrm);
   /* Operateur >(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*Mth_32_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet);
   /* Fonction Unicode() Retourner Nul Ou Caractere; */

/*--------------------------------------------------------------*/
/* Methodes heritees de AlgebreCommutative.                     */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_1_1;
   /* Operateur +(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_2_1;
   /* Operateur -() Retourner Nul Ou CorpsCommutatif; */
TypUpsVmCoAppel CoMth_2_2;
   /* Operateur -(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_3_1;
   /* Operateur *(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_4_1;
   /* Operateur ++(B:Booleen) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_5_1;
   /* Operateur --(B:Booleen) Retourner Nul Ou Entier; */
/*--------------------------------------------------------------*/
/* Methodes heritees de EspaceMetre.                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_9_1;
   /* Operateur <=(E:Entier) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_10_1;
   /* Operateur >=(E:Entier) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_11_1;
   /* Operateur <(E:Entier) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_12_1;
   /* Operateur >(E:Entier) Retourner Nul Ou Booleen; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_13_1;
   /* Operateur +=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_14_1;
   /* Operateur -=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_15_1;
   /* Operateur *=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_16_2;
   /* Constructeur(R:Nul Ou Reel); */
TypUpsVmCoAppel CoMth_16_3;
   /* Constructeur(C:Nul Ou Caractere); */
TypUpsVmCoAppel CoMth_1_2;
   /* Operateur +(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_2_3;
   /* Operateur -(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_3_2;
   /* Operateur *(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_17_1;
   /* Operateur /(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_17_2;
   /* Operateur /(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_18_1;
   /* Operateur \(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_18_2;
   /* Operateur \(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_19_1;
   /* Operateur \=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_19_2;
   /* Operateur \=(R:Nul Ou Reel); */
TypUpsVmCoAppel CoMth_20_1;
   /* Operateur %(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_21_1;
   /* Operateur %=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_22_1;
   /* Operateur ^(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_22_2;
   /* Operateur ^(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_23_1;
   /* Operateur ^=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_24_1;
   /* Operateur &(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_25_1;
   /* Operateur &=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_26_1;
   /* Operateur |(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_27_1;
   /* Operateur |=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_28_1;
   /* Operateur <<(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_29_1;
   /* Operateur <<=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_30_1;
   /* Operateur >>(E:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_31_1;
   /* Operateur >>=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_7_2;
   /* Operateur ==(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_8_2;
   /* Operateur !=(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_9_2;
   /* Operateur <=(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_10_2;
   /* Operateur >=(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_11_2;
   /* Operateur <(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_12_2;
   /* Operateur >(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_32_1;
   /* Fonction Unicode() Retourner Nul Ou Caractere; */
} UpsTrtTypUpsKrn_4_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsKrn_4_1_1_0 UpsTypUpsKrn_4;
typedef UpsTrtTypUpsKrn_4_1_1_0 UpsTrtTypUpsKrn_4;

/****************************************************************/
typedef struct upstypupskrn_5_1_1_0
/* Objet : Proprietes du type Enumere.                          */
/****************************************************************/
{
TypUpsVmAdresse UpsObjet1;
   /* Objet pour Entier. */
TypUpsVmUnsignedShort Enumere;
   /* Pour un enumere. */
} UpsTypUpsKrn_5_1_1_0;

/****************************************************************/
typedef struct upstrttypupskrn_5
/* Objet : Methodes du type Enumere.                            */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

/*--------------------------------------------------------------*/
/* Methodes heritees de EspaceMetre.                            */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_21_4_1 *UpsPrm);
   /* Operateur <=(E:Nul Ou Enumere) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_21_5_1 *UpsPrm);
   /* Operateur >=(E:Nul Ou Enumere) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_21_6_1 *UpsPrm);
   /* Operateur <(E:Nul Ou Enumere) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*Mth_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_21_7_1 *UpsPrm);
   /* Operateur >(E:Nul Ou Enumere) Retourner Nul Ou Booleen; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Methodes heritees de EspaceMetre.                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_4_1;
   /* Operateur <=(E:Nul Ou Enumere) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_5_1;
   /* Operateur >=(E:Nul Ou Enumere) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_6_1;
   /* Operateur <(E:Nul Ou Enumere) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_7_1;
   /* Operateur >(E:Nul Ou Enumere) Retourner Nul Ou Booleen; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
} UpsTrtTypUpsKrn_5_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsKrn_5_1_1_0 UpsTypUpsKrn_5;
typedef UpsTrtTypUpsKrn_5_1_1_0 UpsTrtTypUpsKrn_5;

/****************************************************************/
typedef struct upstypupskrn_6_1_1_0
/* Objet : Proprietes du type Exception.                        */
/****************************************************************/
{
TypUpsVmAdresse UpsChamp1;
   /* MessageErreur:Caractere; */
TypUpsVmLong UpsChamp2;
   /* CodeErreur:Entier; */
TypUpsVmAdresse UpsChamp3;
   /* NomException:UpsKrnCaractere. */
TypUpsVmAdresse UpsChamp4;
   /* NomAppel:Caractere; */
TypUpsVmLong UpsChamp5;
   /* NumeroLigne:Entier; */
TypUpsVmLong UpsChamp6;
   /* NumeroColonne:Entier; */
TypUpsVmAdresse UpsChamp7;
   /* ModuleAppartenance:UpsKrnModule; */
TypUpsVmUnsignedChar UpsChamp8;
   /* EffetSurTransaction:ExceptionSurTransaction Lecture Public; */
TypUpsVmUnicode MotCle[CO_TailleIdf+1];
   /* Mot-cle du message. */
} UpsTypUpsKrn_6_1_1_0;

/****************************************************************/
typedef struct typprmupskrn_6_4_1
/* Objet : Parametre de Exception.EnvoyerEnvoyer(P1:Nul         */
/* Ou Caractere=Nul, P2:Nul Ou Caractere=Nul, P3:Nul Ou         */
/* Caractere=Nul, P4:Nul Ou Caractere=Nul, P5:Nul Ou Caractere= */
/* Nul)                                                         */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* P1 : Nul Ou Caractere. */
TypUpsVmAdresse UpsVar2;
   /* P2 : Nul Ou Caractere. */
TypUpsVmAdresse UpsVar3;
   /* P3 : Nul Ou Caractere. */
TypUpsVmAdresse UpsVar4;
   /* P4 : Nul Ou Caractere. */
TypUpsVmAdresse UpsVar5;
   /* P5 : Nul Ou Caractere. */
} TypPrmUpsKrn_6_4_1;

/****************************************************************/
typedef struct upstrttypupskrn_6_1_1_0
/* Objet : Methodes du type Exception.                          */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmVoid UpsVmAPI (*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsKrn_6_4_1 *UpsPrm);
   /* Procedure Envoyer(P1:Nul Ou Caractere=Nul, P2:Nul Ou Caractere=Nul, */
   /* P3:Nul Ou Caractere=Nul, P4:Nul Ou Caractere=Nul, P5:Nul Ou Caractere=Nul); */
TypUpsVmVoid UpsVmAPI (*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Procedure Renvoyer(); */

TypUpsVmCoAppel CoMth_4_1;
   /* Procedure Envoyer(P1:Nul Ou Caractere=Nul, P2:Nul Ou Caractere=Nul, */
   /* P3:Nul Ou Caractere=Nul, P4:Nul Ou Caractere=Nul, P5:Nul Ou Caractere=Nul); */
TypUpsVmCoAppel CoMth_5_1;
   /* Procedure Renvoyer(); */
} UpsTrtTypUpsKrn_6_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsKrn_6_1_1_0 UpsTypUpsKrn_6;
typedef UpsTrtTypUpsKrn_6_1_1_0 UpsTrtTypUpsKrn_6;

/****************************************************************/
struct upstypupskrn_7_1_1_0
/* Objet : Proprietes du type Objet.                            */
/****************************************************************/
{
TypUpsVmAdresse UpsChamp1;
   /* EstInstanceDe:Type LecturePublic; */
TypUpsVmLong IndexBuffer;
   /* Si l'implementation de l'objet est dans des buffers, index de celui-ci. */
TypUpsVmLong NbBuffers;
   /* Si l'implementation de l'objet est dans des buffers, nombre de ceux-ci. */
TypUpsVmLong NbUtilisations;
   /* Nombre d'utilisations de l'objet. */
TypUpsVmLong NbUtilisationsDestruction;
   /* Nombre d'utilisations declenchant la destruction de l'objet. Usuellement 0 sauf cas particulier. */
enum EnuUpsVmNatureObjet NatureObjet;
   /* Nature des objets a creer. */
TypUpsVmEnteteMethodes *EnteteMethodes;
   /* Entete des methodes de cet objet. */
/******************************/
#if defined(PLATEFORME32DONNEES)
/******************************/
TypUpsVmPointeurDonnees TrouMethodes;
   /* Pour la compatibilite 64 bits. */
/****/
#endif
/****/
};

/****************************************************************/
typedef struct typprmupskrn_7_4_1
/* Objet : Parametre de Objet.Identique(O:Nul Ou Objet)         */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* M : Nul Ou UpsKrnModule. */
} TypPrmUpsKrn_7_4_1;

/****************************************************************/
typedef struct upstrttypupskrn_7_1_1_0
/* Objet : Methodes du type Objet.                              */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmUnsignedChar UpsVmAPI (*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_7_4_1 *UpsPrm);
   /* Fonction Identique(O:Nul Ou Objet) Retourner Booleen; */
TypUpsVmVoid UpsVmAPI (*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Procedure Convertir(O:Nul Ou Objet); */
TypUpsVmLong UpsVmAPI (*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Fonction CreeParLeServeur() Retourner Entier; */
TypUpsVmLong UpsVmAPI (*Mth_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Fonction CreeParLeProcessus() Retourner Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_8_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet);
   /* Fonction CreeDansLEntrepot() Retourner Entrepot; */

TypUpsVmCoAppel CoMth_4_1;
   /* Fonction Identique(O:Nul Ou Objet) Retourner Booleen; */
TypUpsVmCoAppel CoMth_5_1;
   /* Procedure Convertir(O:Nul Ou Objet); */
TypUpsVmCoAppel CoMth_6_1;
   /* Fonction CreeParLeServeur() Retourner Entier; */
TypUpsVmCoAppel CoMth_7_1;
   /* Fonction CreeParLeProcessus() Retourner Entier; */
TypUpsVmCoAppel CoMth_8_1;
   /* Fonction CreeDansLEntrepot() Retourner Entrepot; */
} UpsTrtTypUpsKrn_7_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
/*
typedef UpsTypUpsKrn_7_1_1_0 UpsTypUpsKrn_7;
*/
typedef UpsTrtTypUpsKrn_7_1_1_0 UpsTrtTypUpsKrn_7;

/****************************************************************/
typedef struct upstypupskrn_8_1_1_0
/* Objet : Proprietes du type Reel.                             */
/****************************************************************/
{
TypUpsVmAdresse UpsObjet1;
   /* Objet pour CorpsCommutatif. */
TypUpsVmAdresse UpsObjet2;
   /* Objet pour EspaceMetre. */
TypUpsVmDouble Reel;
   /* Pour un reel. */
} UpsTypUpsKrn_8_1_1_0;

/****************************************************************/
typedef struct typprmupskrn_8_1_2
/* Objet : Parametre de Reel.+(E:Nul Ou Entier)                 */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E : Nul Ou Entier. */
} TypPrmUpsKrn_8_1_2;

/****************************************************************/
typedef struct typprmupskrn_8_2_3
/* Objet : Parametre de Reel.-(E:Nul Ou Entier)                 */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E : Nul Ou Entier. */
} TypPrmUpsKrn_8_2_3;

/****************************************************************/
typedef struct typprmupskrn_8_3_2
/* Objet : Parametre de Reel.*(E:Nul Ou Entier)                 */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E : Nul Ou Entier. */
} TypPrmUpsKrn_8_3_2;

/****************************************************************/
typedef struct typprmupskrn_8_6_2
/* Objet : Parametre de Reel./(E:Nul Ou Entier)                 */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E : Nul Ou Entier. */
} TypPrmUpsKrn_8_6_2;

/****************************************************************/
typedef struct typprmupskrn_8_7_2
/* Objet : Parametre de Reel.^(E:Nul Ou Entier)                 */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E : Nul Ou Entier. */
} TypPrmUpsKrn_8_7_2;

/****************************************************************/
typedef struct typprmupskrn_8_8_2
/* Objet : Parametre de Reel.=(E:Nul Ou Entier)                 */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E : Nul Ou Entier. */
} TypPrmUpsKrn_8_8_2;

/****************************************************************/
typedef struct typprmupskrn_8_9_2
/* Objet : Parametre de Reel.==(E:Nul Ou Entier)                */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E : Nul Ou Entier. */
} TypPrmUpsKrn_8_9_2;

/****************************************************************/
typedef struct typprmupskrn_8_10_2
/* Objet : Parametre de Reel.!=(E:Nul Ou Entier)                */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E : Nul Ou Entier. */
} TypPrmUpsKrn_8_10_2;

/****************************************************************/
typedef struct typprmupskrn_8_11_2
/* Objet : Parametre de Reel.<=(R:Nul Ou Reel)                  */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* R : Nul Ou Reel. */
} TypPrmUpsKrn_8_11_2;

/****************************************************************/
typedef struct typprmupskrn_8_12_2
/* Objet : Parametre de Reel.>=(R:Nul Ou Reel)                  */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* R : Nul Ou Reel. */
} TypPrmUpsKrn_8_12_2;

/****************************************************************/
typedef struct typprmupskrn_8_13_2
/* Objet : Parametre de Reel.<(R:Nul Ou Reel)                   */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* R : Nul Ou Reel. */
} TypPrmUpsKrn_8_13_2;

/****************************************************************/
typedef struct typprmupskrn_8_14_2
/* Objet : Parametre de Reel.>(R:Nul Ou Reel)                   */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* R : Nul Ou Reel. */
} TypPrmUpsKrn_8_14_2;

/****************************************************************/
typedef struct typprmupskrn_8_20_2
/* Objet : Parametre de Reel.Constructeur(E:Nul Ou Entier)      */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E : Nul Ou Entier. */
} TypPrmUpsKrn_8_20_2;

/****************************************************************/
typedef struct typprmupskrn_8_20_3
/* Objet : Parametre de Reel.Constructeur(C:Nul Ou Caractere)   */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* C : Nul Ou Caractere. */
} TypPrmUpsKrn_8_20_3;

/****************************************************************/
typedef struct typprmupskrn_8_21_1
/* Objet : Parametre de Reel.\(E:Nul Ou Entier)                 */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* E : Nul Ou Entier. */
} TypPrmUpsKrn_8_21_1;

/****************************************************************/
typedef struct typprmupskrn_8_21_2
/* Objet : Parametre de Reel.\(R:Nul Ou Reel)                   */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* R : Nul Ou Reel. */
} TypPrmUpsKrn_8_21_2;

/****************************************************************/
typedef struct upstrttypupskrn_8_1_1_0
/* Objet : Methodes du type Reel.                               */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

/*--------------------------------------------------------------*/
/* Methodes heritees de AlgebreCommutative.                     */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*Mth_1_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_22_1_1 *UpsPrm);
   /* Operateur +(R:Nul Ou Reel) Retourner Ou Reel; */
TypUpsVmAdresse UpsVmAPI *(*Mth_2_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet);
   /* Operateur -() Retourner Nul Ou Reel; */
TypUpsVmAdresse UpsVmAPI *(*Mth_2_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_22_2_2 *UpsPrm);
   /* Operateur -(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmAdresse UpsVmAPI *(*Mth_3_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_22_3_1 *UpsPrm);
   /* Operateur *(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmAdresse UpsVmAPI *(*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_22_4_1 *UpsPrmP);
   /* Operateur ++(B:Booleen) Retourner Nul Ou Reel; */
TypUpsVmAdresse UpsVmAPI *(*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_22_5_1 *UpsPrm);
   /* Operateur --(B:Booleen) Retourner Nul Ou Reel; */
/*--------------------------------------------------------------*/
/* Methodes heritees de CorpsCommutative.                      */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_23_6_1 *UpsPrm);
   /* Operateur /(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmAdresse UpsVmAPI *(*Mth_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_23_7_1 *UpsPrm);
   /* Operateur ^(R:Nul Ou Reel) Retourner Nul Ou Reel; */
/*--------------------------------------------------------------*/
/* Methodes heritees de EspaceMetre.                            */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*Mth_11_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_21_4_1 *UpsPrm);
   /* Operateur <=(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*Mth_12_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_21_5_1 *UpsPrm);
   /* Operateur >=(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*Mth_13_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_21_6_1 *UpsPrm);
   /* Operateur <(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*Mth_14_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_21_7_1 *UpsPrm);
   /* Operateur >(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*Mth_15_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *UpsPrm);
   /* Operateur +=(R:Nul Ou Reel); */
TypUpsVmVoid UpsVmAPI (*Mth_16_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *UpsPrm);
   /* Operateur -=(R:Nul Ou Reel); */
TypUpsVmVoid UpsVmAPI (*Mth_17_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *UpsPrm);
   /* Operateur *=(R:Nul Ou Reel); */
TypUpsVmVoid UpsVmAPI (*Mth_18_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *UpsPrm);
   /* Operateur /=(R:Nul Ou Reel); */
TypUpsVmVoid UpsVmAPI (*Mth_19_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *UpsPrm);
   /* Operateur ^=(R:Nul Ou Reel); */
TypUpsVmAdresse UpsVmAPI *(*Mth_20_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsKrn_8_20_2 *UpsPrm);
   /* Constructeur(E:Nul Ou Entier); */
TypUpsVmAdresse UpsVmAPI *(*Mth_20_3)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsKrn_8_20_3 *UpsPrm);
   /* Constructeur(C:Nul Ou Caractere); */
TypUpsVmVoid UpsVmAPI (*Mth_8_2)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_8_8_2 *UpsPrm);
   /* Operateur =(E:Nul Ou Entier); */
TypUpsVmAdresse UpsVmAPI *(*Mth_9_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_8_9_2 *UpsPrm);
   /* Operateur ==(E:Nul Ou Entier) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*Mth_10_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_8_10_2 *UpsPrm);
   /* Operateur !=(E:Nul Ou Entier) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*Mth_11_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_8_11_2 *UpsPrm);
   /* Operateur <=(E:Nul Ou Entier) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*Mth_12_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_8_12_2 *UpsPrm);
   /* Operateur >=(E:Nul Ou Entier) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*Mth_13_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_8_13_2 *UpsPrm);
   /* Operateur <(E:Nul Ou Entier) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*Mth_14_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_8_14_2 *UpsPrm);
   /* Operateur >(E:Nul Ou Entier) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*Mth_1_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_8_1_2 *UpsPrm);
   /* Operateur +(E:Nul Ou Entier) Retourner Reel; */
TypUpsVmVoid UpsVmAPI (*Mth_15_2)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *UpsPrm);
   /* Operateur +=(E:Nul Ou Entier); */
TypUpsVmAdresse UpsVmAPI *(*Mth_2_3)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_8_2_3 *UpsPrm);
   /* Operateur -(E:Nul Ou Entier) Retourner Nul Ou Reel; */
TypUpsVmVoid UpsVmAPI (*Mth_16_2)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *UpsPrm);
   /* Operateur -=(E:Nul Ou Entier); */
TypUpsVmAdresse UpsVmAPI *(*Mth_3_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_8_3_2 *UpsPrm);
   /* Operateur *(E:Nul Ou Entier) Retourner Nul Ou Reel; */
TypUpsVmVoid UpsVmAPI (*Mth_17_2)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *UpsPrm);
   /* Operateur *=(E:Nul Ou Entier); */
TypUpsVmAdresse UpsVmAPI *(*Mth_6_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_8_6_2 *UpsPrm);
   /* Operateur /(E:Nul Ou Entier) Retourner Nul Ou Reel; */
TypUpsVmVoid UpsVmAPI (*Mth_18_2)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *UpsPrm);
   /* Operateur /=(E:Nul Ou Entier); */
TypUpsVmAdresse UpsVmAPI *(*Mth_7_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_8_7_2 *UpsPrm);
   /* Operateur ^(E:Nul Ou Entier) Retourner Nul Ou Reel; */
TypUpsVmVoid UpsVmAPI (*Mth_19_2)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *UpsPrm);
   /* Operateur ^=(E:Nul Ou Entier); */
TypUpsVmAdresse UpsVmAPI *(*Mth_21_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_8_21_1 *UpsPrm);
   /* Operateur \(R:Nul Ou Reel) Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_21_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_8_21_2 *UpsPrm);
   /* Operateur \(E:Nul Ou Entier) Retourner Nul Ou Entier; */

/*--------------------------------------------------------------*/
/* Methodes heritees de AlgebreCommutative.                     */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_1_1;
   /* Operateur +(R:Nul Ou Reel) Retourner Ou Reel; */
TypUpsVmCoAppel CoMth_2_1;
   /* Operateur -() Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_2_2;
   /* Operateur -(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_3_1;
   /* Operateur *(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_4_1;
   /* Operateur ++(B:Booleen) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_5_1;
   /* Operateur --(B:Booleen) Retourner Nul Ou Reel; */
/*--------------------------------------------------------------*/
/* Methodes heritees de CorpsCommutative.                      */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_6_1;
   /* Operateur /(R:Nul Ou Reel) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_7_1;
   /* Operateur ^(R:Nul Ou Reel) Retourner Nul Ou Reel; */
/*--------------------------------------------------------------*/
/* Methodes heritees de EspaceMetre.                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_11_1;
   /* Operateur <=(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_12_1;
   /* Operateur >=(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_13_1;
   /* Operateur <(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_14_1;
   /* Operateur >(R:Nul Ou Reel) Retourner Nul Ou Booleen; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_15_1;
   /* Operateur +=(R:Nul Ou Reel); */
TypUpsVmCoAppel CoMth_16_1;
   /* Operateur -=(R:Nul Ou Reel); */
TypUpsVmCoAppel CoMth_17_1;
   /* Operateur *=(R:Nul Ou Reel); */
TypUpsVmCoAppel CoMth_18_1;
   /* Operateur /=(R:Nul Ou Reel); */
TypUpsVmCoAppel CoMth_19_1;
   /* Operateur ^=(R:Nul Ou Reel); */
TypUpsVmCoAppel CoMth_20_2;
   /* Constructeur(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_20_3;
   /* Constructeur(C:Nul Ou Caractere); */
TypUpsVmCoAppel CoMth_8_2;
   /* Operateur =(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_9_2;
   /* Operateur ==(E:Nul Ou Entier) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_10_2;
   /* Operateur !=(E:Nul Ou Entier) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_11_2;
   /* Operateur <=(E:Nul Ou Entier) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_12_2;
   /* Operateur >=(E:Nul Ou Entier) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_13_2;
   /* Operateur <(E:Nul Ou Entier) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_14_2;
   /* Operateur >(E:Nul Ou Entier) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMth_1_2;
   /* Operateur +(E:Nul Ou Entier) Retourner Reel; */
TypUpsVmCoAppel CoMth_15_2;
   /* Operateur +=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_2_3;
   /* Operateur -(E:Nul Ou Entier) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_16_2;
   /* Operateur -=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_3_2;
   /* Operateur *(E:Nul Ou Entier) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_17_2;
   /* Operateur *=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_6_2;
   /* Operateur /(E:Nul Ou Entier) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_18_2;
   /* Operateur /=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_7_2;
   /* Operateur ^(E:Nul Ou Entier) Retourner Nul Ou Reel; */
TypUpsVmCoAppel CoMth_19_2;
   /* Operateur ^=(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_21_1;
   /* Operateur \(R:Nul Ou Reel) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_21_2;
   /* Operateur \(E:Nul Ou Entier) Retourner Nul Ou Entier; */
} UpsTrtTypUpsKrn_8_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsKrn_8_1_1_0 UpsTypUpsKrn_8;
typedef UpsTrtTypUpsKrn_8_1_1_0 UpsTrtTypUpsKrn_8;

/****************************************************************/
struct upstypupskrn_9_1_1_0
/* Objet : Proprietes d'un type.                                */
/****************************************************************/
{
TypUpsVmAdresse UpsChamp1;
   /* NomType:Caractere LecturePublic; */
TypUpsVmUnsignedChar UpsChamp2;
   /* EstUneInterface:Booleen Lecture Public; */
TypUpsVmUnsignedChar UpsChamp3;
   /* EstUneRessource:Booleen Lecture Public. */
TypUpsVmUnsignedChar UpsChamp4;
   /* AccepteProprietesDynamique:Booleen Lecture Public. */
TypUpsVmAdresse UpsChamp5;
   /* ModuleOrigine:Nul Ou Module Lecture Public. */
TypUpsVmChar UpsChamp6;
   /* EstUneClasseCom:Booleen Lecture Public; */
TypUpsVmChar UpsChamp7;
   /* EstUneClasseCorba:Booleen Lecture Public; */
TypUpsVmUnsignedChar UpsChamp8;
   /* AccepteTransactions:Booleen Lecture Public. */
TypUpsVmUnsignedChar UpsChamp9;
   /* EtatContrainte:ActiviteContrainte Lecture Public. */
TypUpsVmChar UpsChamp10;
   /* EstUneClasseJava:Booleen Lecture Public; */
TypUpsVmChar UpsChamp11;
   /* SupporteHabilitation:Booleen Lecture Public; */
TypUpsVmChar UpsChamp12;
   /* SupporteQuota:Booleen Lecture Public; */
TypUpsVmAdresse PremierSegment;
   /* Premier segment des objets alloues. */ 
TypUpsVmAdresse DernierSegment;
   /* Dernier segment des objets alloues. */ 
TypUpsOmsLienSegmentsType LienSegmentsSystemeType;
   /* Liens entre les segments systeme et le type. */
TypUpsVmExtension ExtensionLienSegmentsType;
   /* Extension des liens entre les segments et le type. */
TypUpsVmLong TailleObjetCompactable;
   /* Taille d'un objet dans un entrepot compactable. */
TypUpsVmLong NbObjetsMaxCompactable;
   /* Nombre maximal d'objets dans un segment de ce type. */
TypUpsVmUnsignedShort NbBlocsCompactable;
   /* Nombre de blocs necessaires pour stocker un segment. */
TypUpsVmLong TailleObjetNonCompactable;
   /* Taille d'un objet dans un entrepot non compactable. */
TypUpsVmLong NbObjetsMaxNonCompactable;
   /* Nombre maximal d'objets dans un segment de ce type. */
TypUpsVmUnsignedShort NbBlocsNonCompactable;
   /* Nombre de blocs necessaires pour stocker un segment. */
TypUpsVmUnsignedChar Architecture;
   /* Architecture d'un objet du type. */
TypUpsVmUnsignedChar Options;
   /* Options d'un objet du type. */
TypUpsVmUnsignedShort NumeroEntrepot;
   /* Numero de l'entrepot par defaut dans laquelle sont stockes les objets. */
TypUpsVmUnsignedShort NumeroFichierEchange;
   /* Numero du fichier d'echange par defaut dans lequel sont stockes les objets. */
TypUpsVmLong NbSegments;
   /* Nombre de segments pour ce type. */
TypUpsVmAllouer Allouer;
   /* Methode d'allocation d'un objet. */
/**********************************/
#if defined(PLATEFORME32TRAITEMENTS)
/**********************************/
TypUpsVmPointeurDonnees TrouAllouer;
   /* Pour la compatibilite 64 bits. */
/****/
#endif
/****/
TypUpsVmEnteteMethodes *EnteteMethodes;
   /* Methodes des objets de ce type. */
};

/****************************************************************/
typedef struct typprmupskrn_9_5_1
/* Objet : Parametre de Type.EnumererObjets(O:Nul Ou Objet)     */
/* Retourner Nul Ou Objet;                                      */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* O:Nul Ou Objet. */
} TypPrmUpsKrn_9_5_1;

/****************************************************************/
typedef struct typprmupskrn_9_6_1
/* Objet : Parametre de Type.EnumererMethodes(Numero:Entier,    */
/* NomAppel:Nul Ou Caractere Sortie, Aide:Nul Ou Caractere      */
/* Sortie) Retourner Nul Ou Appel;                              */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Numero:Entier. */
TypUpsVmAdresse UpsVar2;
   /* NomAppel:Nul Ou Caractere. */
TypUpsVmAdresse UpsVar3;
   /* Aide:Nul Ou Caractere. */
} TypPrmUpsKrn_9_6_1;

/****************************************************************/
typedef struct typprmupskrn_9_7_1
/* Objet : Parametre de Type.ActiverContrainte(A:               */
/* ActiviteContrainte);                                         */
/****************************************************************/
{
TypUpsVmUnsignedChar UpsVar1;
   /* A:ActiviteContrainte. */
} TypPrmUpsKrn_9_7_1;

/****************************************************************/
typedef struct upstrttypupskrn_9_1_1_0
/* Objet : Methodes du type Type.                               */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmAdresse UpsVmAPI *(*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet);
   /* Fonction NouvelObjet() Retourner Objet; */
TypUpsVmAdresse UpsVmAPI *(*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_9_5_1 *UpsPrm);
   /* Fonction EnumererObjets(O:Nul Ou Objet) Retourner Nul Ou Objet; */
TypUpsVmAdresse UpsVmAPI *(*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_9_6_1 *UpsPrm);
   /* Fonction EnumererMethodes(Numero:Entier, NomAppel:Nul Ou Caractere Sortie, Aide:Nul Ou Caractere Sortie) Retourner Nul Ou Appel; */
TypUpsVmVoid UpsVmAPI (*Mth_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_9_7_1 *UpsPrm);
   /* Procedure ActiverContrainte(A:ActiviteContrainte); */

TypUpsVmCoAppel CoMth_4_1;
   /* Fonction NouvelObjet() Retourner Objet; */
TypUpsVmCoAppel CoMth_5_1;
   /* Fonction EnumererObjets(O:Nul Ou Objet) Retourner Nul Ou Objet; */
TypUpsVmCoAppel CoMth_6_1;
   /* Fonction EnumererMethodes(Numero:Entier, NomAppel:Nul Ou Caractere Sortie, Aide:Nul Ou Caractere Sortie) Retourner Nul Ou Appel; */
TypUpsVmCoAppel CoMth_7_1;
   /* Procedure ActiverContrainte(A:ActiviteContrainte); */
} UpsTrtTypUpsKrn_9_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
/*
typedef UpsTypUpsKrn_9_1_1_0 UpsTypUpsKrn_9;
*/
typedef UpsTrtTypUpsKrn_9_1_1_0 UpsTrtTypUpsKrn_9;

/****************************************************************/
typedef struct typprmupskrn_19
/* Objet : Parametres de Iterateur.                             */
/****************************************************************/
{
TypUpsVmAdresse UpsPrm1;
   /* TypeElement:Type; */
} TypPrmUpsKrn_19;

/****************************************************************/
struct upstypupskrn_19_1_1_0
/* Objet : Proprietes d'un iterateur.                           */
/****************************************************************/
{
TypPrmUpsKrn_19 UpsPrm;
   /* Parametre du type. */
TypUpsVmIterateur TableIterateurs[CO_NbIterateurs];
   /* Table des iterateurs. */
};

/****************************************************************/
struct typprmupskrn_19_4_1
/* Objet : Parametre de Iterateur.ParcoursAuDebut(              */
/* NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement     */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* NumeroIterateur : Entier. */
};

/****************************************************************/
struct typprmupskrn_19_5_1
/* Objet : Parametre de Iterateur.ParcoursALaFin(               */
/* NumeroIterateur : Entier=0 Retourner Nul Ou TypeElement      */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Iterateur : Entier. */
};

/****************************************************************/
struct typprmupskrn_19_6_1
/* Objet : Parametre de Iterateur.ParcoursAuMilieu(Position:Nul */
/* Ou Entier, NumeroIterateur : Entier=0) Retourner Nul Ou      */
/* TypeElement                                                  */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Position : Nul Ou Entier. */
TypUpsVmLong UpsVar2;
   /* NumeroIterateur : Entier. */
};

/****************************************************************/
struct typprmupskrn_19_7_1
/* Objet : Parametre de Iterateur.Suivant(NumeroIterateur :     */
/* Entier=0) Retourner Nul Ou TypeElement                       */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Iterateur : Entier. */
};

/****************************************************************/
struct typprmupskrn_19_8_1
/* Objet : Parametre de Iterateur.Precedent(NumeroIterateur :   */
/* Entier)=0 Retourner Nul Ou TypeElement                       */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Iterateur : Entier. */
};

/****************************************************************/
struct typprmupskrn_19_11_1
/* Objet : Parametre de Iterateur.NumeroElement(NumeroIterateur */
/* : Entier=0) Retourner Nul Ou Entier                          */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Iterateur : Entier. */
};

/****************************************************************/
struct typprmupskrn_19_12_1
/* Objet : Parametre de Iterateur.Element(NumeroIterateur :     */
/* Entier=0) Retourner Nul Ou Objet                             */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Iterateur : Entier. */
};

/****************************************************************/
struct typprmupskrn_19_14_1
/* Objet : Parametre de LibererIterateur(NumeroIterateur :      */
/* Entier);                                                     */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Iterateur : Entier. */
};

/****************************************************************/
struct upstrttypupskrn_19_1_1_0
/* Objet : Methodes de l'interface Iterateur.                   */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmAdresse UpsVmAPI *(*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_4_1 *UpsPrm);
   /* Fonction ParcoursAuDebut(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_5_1 *UpsPrm);
   /* Fonction ParcoursALaFin(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_6_1 *UpsPrm);
   /* Fonction ParcoursAuMilieu(Position:Nul Ou Entier, NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_7_1 *UpsPrm);
   /* Fonction Suivant(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_8_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_8_1 *UpsPrm);
   /* Fonction Precedent(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_9_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet);
   /* Fonction PremierElement() Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_10_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet);
   /* Fonction DernierElement() Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_11_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_11_1 *UpsPrm);
   /* Fonction NumeroElement(NumeroIterateur : Entier=0) Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_12_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_12_1 *UpsPrm);
   /* Fonction Element(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmLong UpsVmAPI (*Mth_13_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Fonction AllouerIterateur() Retourner Entier; */
TypUpsVmVoid UpsVmAPI (*Mth_14_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_14_1 *UpsPrm);
   /* Procedure LibererIterateur(NumeroIterateur : Entier); */

TypUpsVmCoAppel CoMth_4_1;
   /* Fonction ParcoursAuDebut(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_5_1;
   /* Fonction ParcoursALaFin(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_6_1;
   /* Fonction ParcoursAuMilieu(Position:Nul Ou Entier, Iterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_7_1;
   /* Fonction Suivant(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_8_1;
   /* Fonction Precedent(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_9_1;
   /* Fonction PremierElement() Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_10_1;
   /* Fonction DernierElement() Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_11_1;
   /* Fonction NumeroElement(NumeroIterateur : Entier=0) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_12_1;
   /* Fonction Element(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_13_1;
   /* Fonction AllouerIterateur() Retourner Entier; */
TypUpsVmCoAppel CoMth_14_1;
   /* Procedure LibererIterateur(NumeroIterateur : Entier); */
};

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
/*
typedef UpsTypUpsKrn_19_1_1_0 UpsTypUpsKrn_19;
typedef UpsTrtTypUpsKrn_19_1_1_0 UpsTrtTypUpsKrn_19;
*/

/****************************************************************/
typedef struct typprmupskrn_20
/* Objet : Parametres de Collection.                            */
/****************************************************************/
{
TypUpsVmAdresse UpsPrm1;
   /* TypeElement:Type; */
} TypPrmUpsKrn_20;

/****************************************************************/
typedef struct upstypupskrn_20_1_1_0
/* Objet : Proprietes d'une Collection.                         */
/****************************************************************/
{
TypPrmUpsKrn_20 UpsPrm;
   /* Parametre du type. */
TypUpsVmAdresse UpsObjet1;
   /* Objet pour l'iterateur; */
TypUpsVmLong UpsChamp1;
   /* NbElements : Entier; */
} UpsTypUpsKrn_20_1_1_0;

/****************************************************************/
typedef struct typprmupskrn_20_15_1
/* Objet : Parametre de Collection.Gauche(Taille:Nul Ou Entier) */
/* Retourner Nul Ou Collection);                                */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Taille : Nul Ou Entier. */
} TypPrmUpsKrn_20_15_1;

/****************************************************************/
typedef struct typprmupskrn_20_16_1
/* Objet : Parametre de Collection.Droite(Taille:Nul Ou Entier) */
/* Retourner Nul Ou Collection);                                */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Taille : Nul Ou Entier. */
} TypPrmUpsKrn_20_16_1;

/****************************************************************/
typedef struct typprmupskrn_20_17_1
/* Objet : Parametre de Collection.Milieu(Position:Nul Ou       */
/* Entier, Taille:Nul Ou Entier) Retourner Nul Ou Collection);  */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Position : Nul Ou Entier. */
TypUpsVmAdresse UpsVar2;
   /* Taille : Nul Ou Entier. */
} TypPrmUpsKrn_20_17_1;

/****************************************************************/
typedef struct typprmupskrn_20_18_1
/* Objet : Parametre de Collection.Inserer(L:Nul Ou Collection, */
/* Position: Nul Ou Entier) Retourner Nul Ou Collection);       */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* L : Nul Ou Collection. */
TypUpsVmAdresse UpsVar2;
   /* Position : Nul Ou Entier. */
} TypPrmUpsKrn_20_18_1;

/****************************************************************/
typedef struct typprmupskrn_20_19_1
/* Objet : Parametre de Collection.Compter(Modele:Nul Ou        */
/* TypeElement, Position Nul Ou Entier=Nul) Retourner Nul Ou    */
/* Entier;                                                      */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Modele : Nul Ou Collection. */
TypUpsVmAdresse UpsVar2;
   /* Position : Nul Ou Entier. */
} TypPrmUpsKrn_20_19_1;

/****************************************************************/
typedef struct typprmupskrn_20_20_1
/* Objet : Parametre de Collection.Rechercher(Modele:Nul Ou     */
/* TypeElement, Position Nul Ou Entier=Nul) Retourner Nul Ou    */
/* Entier;                                                      */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Modele : Nul Ou Liste. */
TypUpsVmAdresse UpsVar2;
   /* Position : Nul Ou Entier. */
} TypPrmUpsKrn_20_20_1;

/****************************************************************/
typedef struct typprmupskrn_20_21_1
/* Objet : Parametre de Collection.Supprimer(NumeroIterateur :  */
/* Entier=0)                                                    */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* NumeroIterateur : Entier. */
} TypPrmUpsKrn_20_21_1;

/****************************************************************/
typedef struct typprmupskrn_20_22_1
/* Objet : Parametre de Collection.Remplacer(Remplacant:Nul Ou  */
/* TypeElement, NumeroIterateur : Entier=0)                     */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Remplacant:Nul Ou Objet. */
TypUpsVmLong UpsVar2;
   /* Iterateur : Entier. */
} TypPrmUpsKrn_20_22_1;

/****************************************************************/
typedef struct typprmupskrn_20_23_1
/* Objet : Parametre de Collection.RemplacerTous(Modele:Nul Ou  */
/* TypeElement, Remplacant:Nul Ou TypeElement, Position:Nul Ou  */
/* Entier=Nul) Retourner Nul Ou Collection;                     */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Modele : Nul Ou TypeElement. */
TypUpsVmAdresse UpsVar2;
   /* Remplacant : Nul Ou TypeElement. */
TypUpsVmAdresse UpsVar3;
   /* Position : Nul Ou Entier. */
} TypPrmUpsKrn_20_23_1;

/****************************************************************/
typedef struct typprmupskrn_20_24_1
/* Objet : Parametre de Collection.SupprimerTous(Modele:Nul Ou  */
/* TypeElement, Position Nul Ou Entier=Nul) Retourner Nul Ou    */
/* Collection;                                                  */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Modele : Nul Ou TypeElement. */
TypUpsVmAdresse UpsVar2;
   /* Position : Nul Ou Entier. */
} TypPrmUpsKrn_20_24_1;

/****************************************************************/
typedef struct typprmupskrn_20_25_1
/* Objet : Parametre de Collection.AjouterAuDebut(O:Nul Ou      */
/* TypeElement) Retourner Nul Ou Collection);                   */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* O:Nul Ou TypeElement. */
} TypPrmUpsKrn_20_25_1;

/****************************************************************/
typedef struct typprmupskrn_20_26_1
/* Objet : Parametre de Collection.AjouterALaFin(O:Nul Ou       */
/* TypeElement) Retourner Nul Ou Collection);                   */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* O:Nul Ou TypeElement. */
} TypPrmUpsKrn_20_26_1;

/****************************************************************/
typedef struct typprmupskrn_20_27_1
/* Objet : Parametre de Collection.Operateur +(O:Nul Ou         */
/* TypeElement) Retourner Nul Ou Collection);                   */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* O:Nul Ou TypeElement. */
} TypPrmUpsKrn_20_27_1;

/****************************************************************/
typedef struct typprmupskrn_20_29_1
/* Objet : Parametre de Collection.[](Position:Nul Ou Entier)   */
/* Retourner Nul Ou TypeElement                                 */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Position : Nul Ou Entier. */
} TypPrmUpsKrn_20_29_1;

/****************************************************************/
typedef struct typprmupskrn_20_29_2
/* Objet : Parametre de Collection.[](Position:Nul Ou Entier,   */
/* Valeur:Nul Ou TypeElement, MethodeAComposer:Nul Ou Appel=Nul)*/
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Position : Nul Ou Entier. */
TypUpsVmAdresse UpsVar2;
   /* Valeur : Nul Ou TypeElement. */
TypUpsVmAdresse UpsVar3;
   /* MethodeAComposer : Nul Ou Appel. */
} TypPrmUpsKrn_20_29_2;

/****************************************************************/
typedef struct typprmupskrn_20_29_3
/* Objet : Parametre de Collection.[](Position:Nul Ou Entier,   */
/* Prefixe:Booleen, Methode:Nul Ou Appel) Retourner Nul Ou      */
/* TypeElement                                                  */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Position : Nul Ou Entier. */
TypUpsVmUnsignedChar UpsVar2;
   /* Prefixe : Booleen. */
TypUpsVmAdresse UpsVar3;
   /* Methode : Nul Ou Appel. */
} TypPrmUpsKrn_20_29_3;

/****************************************************************/
typedef struct upstrttypupskrn_20_1_1_0
/* Objet : Methodes de l'interface Collection.                  */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

/*--------------------------------------------------------------*/
/* Methodes heritees de Iterateur.                              */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_4_1 *UpsPrm);
   /* Fonction ParcoursAuDebut(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_5_1 *UpsPrm);
   /* Fonction ParcoursALaFin(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_6_1 *UpsPrm);
   /* Fonction ParcoursAuMilieu(Position:Nul Ou Entier, NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_7_1 *UpsPrm);
   /* Fonction Suivant(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_8_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_8_1 *UpsPrm);
   /* Fonction Precedent(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_9_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet);
   /* Fonction PremierElement() Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_10_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet);
   /* Fonction DernierElement() Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_11_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_11_1 *UpsPrm);
   /* Fonction NumeroElement(NumeroIterateur : Entier=0) Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_12_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_12_1 *UpsPrm);
   /* Fonction Element(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmLong UpsVmAPI (*Mth_13_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Fonction AllouerIterateur() Retourner Entier; */
TypUpsVmVoid UpsVmAPI (*Mth_14_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_14_1 *UpsPrm);
   /* Procedure LibererIterateur(NumeroIterateur : Entier); */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*Mth_15_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_15_1 *UpsPrm);
   /* Fonction Gauche(Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_16_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_16_1 *UpsPrm);
   /* Fonction Droite(Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_17_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_17_1 *UpsPrm);
   /* Fonction Milieu(Position:Nul Ou Entier, Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_18_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_18_1 *UpsPrm);
   /* Fonction Inserer(L:Nul Ou Collection, Position:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_19_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_19_1 *UpsPrm);
   /* Fonction Compter(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_20_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_20_1 *UpsPrm);
   /* Fonction Rechercher(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Entier; */
TypUpsVmVoid UpsVmAPI (*Mth_21_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_21_1 *UpsPrm);
   /* Procedure Supprimer(NumeroIterateur : Entier); */
TypUpsVmVoid UpsVmAPI (*Mth_22_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_22_1 *UpsPrm);
   /* Procedure Remplacer(Remplacant:Nul Ou TypeElement, NumeroIterateur : Entier=0); */
TypUpsVmAdresse UpsVmAPI *(*Mth_23_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_23_1 *UpsPrm);
   /* Fonction RemplacerTous(Modele:Nul Ou TypeElement, Remplacant:Nul Ou Objet, Position:Nul Ou Entier=Nul) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_24_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_24_1 *UpsPrm);
   /* Fonction SupprimerTous(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_25_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_25_1 *UpsPrm);
   /* Fonction AjouterAuDebut(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_26_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_26_1 *UpsPrm);
   /* Fonction AjouterALaFin(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_27_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_27_1 *UpsPrm);
   /* Operateur +(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmVoid UpsVmAPI (*Mth_28_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *UpsPrm);
   /* Operateur +=(O:Nul Ou TypeElement); */
TypUpsVmAdresse UpsVmAPI *(*Mth_29_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_29_1 *UpsPrm);
   /* Operateur [](Position:Nul Ou Entier) Retourner Nul Ou TypeElement; */
TypUpsVmVoid UpsVmAPI (*Mth_29_2)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_29_2 *UpsPrm);
   /* Operateur [](Position:Nul Ou Entier, Valeur:Nul Ou TypeElement, MethodeAComposer:Nul Ou Appel=Nul); */
TypUpsVmAdresse UpsVmAPI *(*Mth_29_3)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_29_3 *UpsPrm);
   /* Operateur [](Position:Nul Ou Entier, Prefixe:Booleen, Methode:Nul Ou Appel) Retourner Nul Ou TypeElement; */

/*--------------------------------------------------------------*/
/* Methodes heritees de Iterateur.                              */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_4_1;
   /* Fonction ParcoursAuDebut(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_5_1;
   /* Fonction ParcoursALaFin(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_6_1;
   /* Fonction ParcoursAuMilieu(Position:Nul Ou Entier, Iterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_7_1;
   /* Fonction Suivant(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_8_1;
   /* Fonction Precedent(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_9_1;
   /* Fonction PremierElement() Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_10_1;
   /* Fonction DernierElement() Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_11_1;
   /* Fonction NumeroElement(NumeroIterateur : Entier=0) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_12_1;
   /* Fonction Element(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_13_1;
   /* Fonction AllouerIterateur() Retourner Entier; */
TypUpsVmCoAppel CoMth_14_1;
   /* Procedure LibererIterateur(NumeroIterateur : Entier); */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_15_1;
   /* Fonction Gauche(Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_16_1;
   /* Fonction Droite(Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_17_1;
   /* Fonction Milieu(Position:Nul Ou Entier, Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_18_1;
   /* Fonction Inserer(L:Nul Ou Collection, Position:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_19_1;
   /* Fonction Compter(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_20_1;
   /* Fonction Rechercher(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_21_1;
   /* Procedure Supprimer(NumeroIterateur : Entier=0); */
TypUpsVmCoAppel CoMth_22_1;
   /* Procedure Remplacer(Remplacant:Nul Ou TypeElement, NumeroIterateur : Entier=0); */
TypUpsVmCoAppel CoMth_23_1;
   /* Fonction RemplacerTous(Modele:Nul Ou TypeElement, Remplacant:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_24_1;
   /* Fonction SupprimerTous(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_25_1;
   /* Fonction AjouterAuDebut(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_26_1;
   /* Fonction AjouterALaFin(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_27_1;
   /* Operateur +(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_28_1;
   /* Operateur +=(O:Nul Ou TypeElement); */
TypUpsVmCoAppel CoMth_29_1;
   /* Operateur [](Position:Nul Ou Entier) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_29_2;
   /* Operateur [](Position:Nul Ou Entier, Valeur:Nul Ou TypeElement, MethodeAComposer:Nul Ou Appel=Nul); */
TypUpsVmCoAppel CoMth_29_3;
   /* Operateur [](Position:Nul Ou Entier, Prefixe:Booleen, Methode:Nul Ou Appel) Retourner Nul Ou TypeElement; */
} UpsTrtTypUpsKrn_20_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsKrn_20_1_1_0 UpsTypUpsKrn_20;
typedef UpsTrtTypUpsKrn_20_1_1_0 UpsTrtTypUpsKrn_20;

/****************************************************************/
typedef struct typprmupskrn_10
/* Objet : Parametres de Liste.                                 */
/****************************************************************/
{
TypUpsVmAdresse UpsPrm1;
   /* TypeElement:Nul Ou Type; */
} TypPrmUpsKrn_10;

/****************************************************************/
typedef struct upstypupskrn_10_1_1_0
/* Objet : Proprietes d'une liste.                              */
/****************************************************************/
{
TypPrmUpsKrn_10 UpsPrm;
   /* Parametre du type. */
TypUpsVmAdresse UpsObjet1;
   /* Objet pour la collection; */
TypUpsVmAdresse PremierElement;
   /* Premier element de la liste; */
TypUpsVmAdresse DernierElement;
   /* Dernier element de la liste; */
} UpsTypUpsKrn_10_1_1_0;

/****************************************************************/
typedef struct typprmupskrn_10_30_1
/* Objet : Parametre de Liste.Constructeur(O:Nul Ou             */
/* TypeElement);                                                */
/****************************************************************/
{
TypPrmUpsKrn_10 UpsPrm;
   /* Parametre du type. */
TypUpsVmAdresse UpsVar1;
   /* O : Nul Ou TypeElement. */
} TypPrmUpsKrn_10_30_1;

/****************************************************************/
typedef struct typprmupskrn_10_32_1
/* Objet : Parametre de Liste.Union(L:Nul Ou Liste, Distinguer :*/
/* Booleen) Retourner  Nul Ou Liste);                           */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* L : Nul Ou Liste. */
} TypPrmUpsKrn_10_32_1;

/****************************************************************/
typedef struct typprmupskrn_10_33_1
/* Objet : Parametre de Liste.Intersection(L:Nul Ou Liste)      */
/* Retourner Nul Ou Liste);                                     */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* L : Nul Ou Liste. */
} TypPrmUpsKrn_10_33_1;

/****************************************************************/
typedef struct typprmupskrn_10_34_1
/* Objet : Parametre de Liste.Soustraction(L:Nul Ou Liste)      */
/* Retourner Nul Ou Liste);                                     */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* L : Nul Ou Liste. */
} TypPrmUpsKrn_10_34_1;

/****************************************************************/
typedef struct typprmupskrn_10_35_1
/* Objet : Parametre de Liste.Exclusion(L:Nul Ou Liste)         */
/* Retourner Nul Ou Liste);                                     */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* L : Nul Ou Liste. */
} TypPrmUpsKrn_10_35_1;

/****************************************************************/
typedef struct typprmupskrn_10_36_1
/* Objet : Parametre de Liste.Trier(Critere:Fonction(O1:Nul Ou  */
/* TypeElement, O2:Nul Ou TypeElement) Retourner                */
/* ComparaisonObjet) Retourner Nul Ou Liste;                    */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Critere:Fonction(O1:Nul Ou TypeElement, O2:Nul Ou TypeElement) Retourner ComparaisonObjet. */
TypUpsVmUnsignedChar UpsVar2;
   /* Ascendant:Booleen. */
} TypPrmUpsKrn_10_36_1;

/****************************************************************/
typedef struct typprmupskrn_10_37_1
/* Objet : Parametre de Appliquer(Traitement:Procedure (O:Nul Ou*/
/* TypElement));                                                */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Traitement:Procedure (O:Nul Ou TypeElement). */
} TypPrmUpsKrn_10_37_1;

/****************************************************************/
typedef struct typprmupskrn_10_37_2
/* Objet : Parametre de Appliquer(Traitement:Procedure (O1:Nul  */
/* Ou TypeElement, O2:Nul Ou TypeElement), L:Nul Ou Liste);     */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Traitement:Procedure (O:Nul Ou TypeElement). */
TypUpsVmAdresse UpsVar2;
   /* L:Nul Ou Liste. */
} TypPrmUpsKrn_10_37_2;

/****************************************************************/
typedef struct typprmupskrn_10_37_3
/* Objet : Parametre de Appliquer(Traitement:Fonction (O:Nul Ou */
/* TypeElement) Retourner Nul Ou TypeElement) Retourner Nul Ou  */
/* Liste;                                                       */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Traitement:Fonction (O:Nul Ou TypeElement) Retourner Nul Ou TypeElement. */
} TypPrmUpsKrn_10_37_3;

/****************************************************************/
typedef struct typprmupskrn_10_37_4
/* Objet : Parametre de Appliquer(Traitement:Fonction (O1:Nul Ou*/
/* TypeElement, O2:Nul Ou TypeElement) Retourner Nul Ou         */
/* TypeElement, L:Nul Ou Liste) Retourner Nul Ou Liste;         */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Traitement:Fonction (O1:Nul Ou TypeElement, O2:Nul Ou TypeElement) Retourner Nul Ou TypeElement. */
TypUpsVmAdresse UpsVar2;
   /* L:Nul Ou Liste. */
} TypPrmUpsKrn_10_37_4;

/****************************************************************/
typedef struct typprmupskrn_10_38_1
/* Objet : Parametre de Filtrer(Critere:Fonction (O:Nul Ou      */
/* TypeElement) Retourner Nul Ou Booleen) Retourner Nul Ou      */
/* Liste;                                                       */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Critere:Fonction (O:Nul Ou TypeElement) Retourner Nul Ou Booleen. */
} TypPrmUpsKrn_10_38_1;

/****************************************************************/
typedef struct typprmupskrn_10_39_1
/* Objet : Parametre de Grouper(Critere:Fonction(O1:Nul Ou      */
/* TypeElement, O2:Nul Ou TypeElement) Retourner                */
/* ComparaisonObjet) Retourner Nul Ou Liste;                    */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Critere:Fonction(O1:Nul Ou TypeElement, O2:Nul Ou TypeElement) Retourner ComparaisonObjet. */
} TypPrmUpsKrn_10_39_1;

/****************************************************************/
typedef struct upstrttypupskrn_10_1_1_0
/* Objet : Methodes du type Liste.                              */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

/*--------------------------------------------------------------*/
/* Methodes heritees de Iterateur.                              */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_4_1 *UpsPrm);
   /* Fonction ParcoursAuDebut(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_5_1 *UpsPrm);
   /* Fonction ParcoursALaFin(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_6_1 *UpsPrm);
   /* Fonction ParcoursAuMilieu(Position:Nul Ou Entier, NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_7_1 *UpsPrm);
   /* Fonction Suivant(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_8_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_8_1 *UpsPrm);
   /* Fonction Precedent(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_9_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet);
   /* Fonction PremierElement() Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_10_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet);
   /* Fonction DernierElement() Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_11_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_11_1 *UpsPrm);
   /* Fonction NumeroElement(NumeroIterateur : Entier=0) Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_12_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_12_1 *UpsPrm);
   /* Fonction Element(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmLong UpsVmAPI (*Mth_13_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Fonction AllouerIterateur() Retourner Entier; */
TypUpsVmVoid UpsVmAPI (*Mth_14_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_14_1 *UpsPrm);
   /* Procedure LibererIterateur(NumeroIterateur : Entier); */
/*--------------------------------------------------------------*/
/* Methodes heritees de Collection.                             */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*Mth_15_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_15_1 *UpsPrm);
   /* Fonction Gauche(Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_16_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_16_1 *UpsPrm);
   /* Fonction Droite(Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_17_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_17_1 *UpsPrm);
   /* Fonction Milieu(Position:Nul Ou Entier, Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_18_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_18_1 *UpsPrm);
   /* Fonction Inserer(L:Nul Ou Collection, Position:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_19_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_19_1 *UpsPrm);
   /* Fonction Compter(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_20_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_20_1 *UpsPrm);
   /* Fonction Rechercher(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Entier; */
TypUpsVmVoid UpsVmAPI (*Mth_21_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_21_1 *UpsPrm);
   /* Procedure Supprimer(NumeroIterateur : Entier); */
TypUpsVmVoid UpsVmAPI (*Mth_22_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_22_1 *UpsPrm);
   /* Procedure Remplacer(Remplacant:Nul Ou TypeElement, NumeroIterateur : Entier=0); */
TypUpsVmAdresse UpsVmAPI *(*Mth_23_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_23_1 *UpsPrm);
   /* Fonction RemplacerTous(Modele:Nul Ou TypeElement, Remplacant:Nul Ou Objet, Position:Nul Ou Entier=Nul) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_24_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_24_1 *UpsPrm);
   /* Fonction SupprimerTous(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_25_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_25_1 *UpsPrm);
   /* Fonction AjouterAuDebut(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_26_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_26_1 *UpsPrm);
   /* Fonction AjouterALaFin(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_27_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_27_1 *UpsPrm);
   /* Operateur +(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmVoid UpsVmAPI (*Mth_28_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *UpsPrm);
   /* Operateur +=(O:Nul Ou TypeElement); */
TypUpsVmAdresse UpsVmAPI *(*Mth_29_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_29_1 *UpsPrm);
   /* Operateur [](Position:Nul Ou Entier) Retourner Nul Ou TypeElement; */
TypUpsVmVoid UpsVmAPI (*Mth_29_2)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_29_2 *UpsPrm);
   /* Operateur [](Position:Nul Ou Entier, Valeur:Nul Ou TypeElement, MethodeAComposer:Nul Ou Appel=Nul); */
TypUpsVmAdresse UpsVmAPI *(*Mth_29_3)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_29_3 *UpsPrm);
   /* Operateur [](Position:Nul Ou Entier, Prefixe:Booleen, Methode:Nul Ou Appel) Retourner Nul Ou TypeElement; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*Mth_30_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsKrn_10_30_1 *UpsPrm);
   /* Constructeur(O:Nul Ou TypeElement); */
TypUpsVmAdresse UpsVmAPI *(*Mth_31_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet);
   /* Operateur -() Retourner Nul Ou Liste; */
TypUpsVmAdresse UpsVmAPI *(*Mth_32_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_10_32_1 *UpsPrm);
   /* Fonction Union(L:Nul Ou Liste) Retourner Nul Ou Liste; */
TypUpsVmAdresse UpsVmAPI *(*Mth_33_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_10_33_1 *UpsPrm);
   /* Fonction Intersection(L:Nul Ou Liste) Retourner Nul Ou Liste; */
TypUpsVmAdresse UpsVmAPI *(*Mth_34_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_10_34_1 *UpsPrm);
   /* Fonction Soustraction(L:Nul Ou Liste) Retourner Nul Ou Liste; */
TypUpsVmAdresse UpsVmAPI *(*Mth_35_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_10_35_1 *UpsPrm);
   /* Fonction Exclusion(L:Nul Ou Liste) Retourner Nul Ou Liste; */
TypUpsVmAdresse UpsVmAPI *(*Mth_36_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_10_36_1 *UpsPrm);
   /* Fonction Trier(Critere:Fonction(O1:Nul Ou TypeElement, O2:Nul Ou TypeElement) Retourner ComparaisonObjet) Retourner Nul Ou Liste; */
TypUpsVmVoid UpsVmAPI (*Mth_37_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_10_37_1 *UpsPrm);
   /* Procedure Appliquer(Traitement:Procedure (O:Nul Ou TypeElement)); */
TypUpsVmVoid UpsVmAPI (*Mth_37_2)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_10_37_2 *UpsPrm);
   /* Procedure Appliquer(Traitement:Procedure (O1:Nul Ou TypeElement, O2:Nul Ou TypeElement), L:Nul Ou Liste); */
TypUpsVmAdresse UpsVmAPI *(*Mth_37_3)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_10_37_3 *UpsPrm);
   /* Fonction Appliquer(Traitement:Fonction (O:Nul Ou TypeElement) Retourner Nul Ou TypeElement) Retourner Nul Ou Liste; */
TypUpsVmAdresse UpsVmAPI *(*Mth_37_4)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_10_37_4 *UpsPrm);
   /* Fonction Appliquer(Traitement:Fonction (O1:Nul Ou TypeElement, O2:Nul Ou TypeElement) Retourner Nul Ou Objet, L:Nul Ou Liste) Retourner Nul Ou Liste; */
TypUpsVmAdresse UpsVmAPI *(*Mth_38_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_10_38_1 *UpsPrm);
   /* Fonction Filtrer(Critere:Fonction (O:Nul Ou TypeElement) Retourner Nul Ou Booleen) Retourner Nul Ou Liste; */
TypUpsVmAdresse UpsVmAPI *(*Mth_39_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_10_39_1 *UpsPrm);
   /* Fonction Grouper(Critere:Fonction(O1:Nul Ou TypeElement, O2:Nul Ou TypeElement) Retourner ComparaisonObjet) Retourner Nul Ou Liste; */

/*--------------------------------------------------------------*/
/* Methodes heritees de Iterateur.                              */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_4_1;
   /* Fonction ParcoursAuDebut(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_5_1;
   /* Fonction ParcoursALaFin(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_6_1;
   /* Fonction ParcoursAuMilieu(Position:Nul Ou Entier, Iterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_7_1;
   /* Fonction Suivant(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_8_1;
   /* Fonction Precedent(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_9_1;
   /* Fonction PremierElement() Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_10_1;
   /* Fonction DernierElement() Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_11_1;
   /* Fonction NumeroElement(NumeroIterateur : Entier=0) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_12_1;
   /* Fonction Element(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_13_1;
   /* Fonction AllouerIterateur() Retourner Entier; */
TypUpsVmCoAppel CoMth_14_1;
   /* Procedure LibererIterateur(NumeroIterateur : Entier); */
/*--------------------------------------------------------------*/
/* Methodes heritees de Collection.                             */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_15_1;
   /* Fonction Gauche(Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_16_1;
   /* Fonction Droite(Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_17_1;
   /* Fonction Milieu(Position:Nul Ou Entier, Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_18_1;
   /* Fonction Inserer(L:Nul Ou Collection, Position:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_19_1;
   /* Fonction Compter(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_20_1;
   /* Fonction Rechercher(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_21_1;
   /* Procedure Supprimer(NumeroIterateur : Entier=0); */
TypUpsVmCoAppel CoMth_22_1;
   /* Procedure Remplacer(Remplacant:Nul Ou TypeElement, NumeroIterateur : Entier=0); */
TypUpsVmCoAppel CoMth_23_1;
   /* Fonction RemplacerTous(Modele:Nul Ou TypeElement, Remplacant:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_24_1;
   /* Fonction SupprimerTous(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_25_1;
   /* Fonction AjouterAuDebut(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_26_1;
   /* Fonction AjouterALaFin(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_27_1;
   /* Operateur +(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_28_1;
   /* Operateur +=(O:Nul Ou TypeElement); */
TypUpsVmCoAppel CoMth_29_1;
   /* Operateur [](Position:Nul Ou Entier) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_29_2;
   /* Operateur [](Position:Nul Ou Entier, Valeur:Nul Ou TypeElement, MethodeAComposer:Nul Ou Appel=Nul); */
TypUpsVmCoAppel CoMth_29_3;
   /* Operateur [](Position:Nul Ou Entier, Prefixe:Booleen, Methode:Nul Ou Appel) Retourner Nul Ou TypeElement; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_30_1;
   /* Constructeur(O:Nul Ou TypeElement); */
TypUpsVmCoAppel CoMth_31_1;
   /* Operateur -() Retourner Nul Ou Liste; */
TypUpsVmCoAppel CoMth_32_1;
   /* Fonction Union(L:Nul Ou Liste) Retourner Nul Ou Liste; */
TypUpsVmCoAppel CoMth_33_1;
   /* Fonction Intersection(L:Nul Ou Liste) Retourner Nul Ou Liste; */
TypUpsVmCoAppel CoMth_34_1;
   /* Fonction Soustraction(L:Nul Ou Liste) Retourner Nul Ou Liste; */
TypUpsVmCoAppel CoMth_35_1;
   /* Fonction Exclusion(L:Nul Ou Liste) Retourner Nul Ou Liste; */
TypUpsVmCoAppel CoMth_36_1;
   /* Fonction Trier(Critere:Fonction(O1:Nul Ou TypeElement, O2:Nul Ou TypeElement) Retourner ComparaisonObjet,
      Ascendant:Booleen=Vrai) Retourner Nul Ou Liste; */
TypUpsVmCoAppel CoMth_37_1;
   /* Procedure Appliquer(Traitement:Procedure (O:Nul Ou TypeElement)); */
TypUpsVmCoAppel CoMth_37_2;
   /* Procedure Appliquer(Traitement:Procedure (O1:Nul Ou TypeElement, O2:Nul Ou TypeElement), L:Nul Ou Liste); */
TypUpsVmCoAppel CoMth_37_3;
   /* Fonction Appliquer(Traitement:Fonction (O:Nul Ou TypeElement) Retourner Nul Ou TypeElement) Retourner Nul Ou Liste; */
TypUpsVmCoAppel CoMth_37_4;
   /* Fonction Appliquer(Traitement:Fonction (O1:Nul Ou TypeElement, O2:Nul Ou TypeElement) Retourner Nul Ou TypeElement, L:Nul Ou Liste) Retourner Nul Ou Liste; */
TypUpsVmCoAppel CoMth_38_1;
   /* Fonction Filtrer(Critere:Fonction (O:Nul Ou TypeElement) Retourner Nul Ou Booleen) Retourner Nul Ou Liste; */
TypUpsVmCoAppel CoMth_39_1;
   /* Fonction Grouper(Critere:Fonction(O1:Nul Ou Objet, O2:Nul Ou TypeElement) Retourner ComparaisonObjet) Retourner Nul Ou Liste; */
} UpsTrtTypUpsKrn_10_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsKrn_10_1_1_0 UpsTypUpsKrn_10;
typedef UpsTrtTypUpsKrn_10_1_1_0 UpsTrtTypUpsKrn_10;

/****************************************************************/
typedef struct typprmupskrn_11
/* Objet : Parametres de Reference.                             */
/****************************************************************/
{
TypUpsVmAdresse UpsPrm1;
   /* TypeElement:Type; */
} TypPrmUpsKrn_11;

/****************************************************************/
typedef struct upstypupskrn_11_1_1_0
/* Objet : Proprietes d'une Reference.                          */
/****************************************************************/
{
TypPrmUpsKrn_11 UpsPrm;
   /* Parametre du type. */
TypUpsVmAdresse UpsChamp1;
   /* Valeur : Nul Ou Objet; */
} UpsTypUpsKrn_11_1_1_0;

/****************************************************************/
typedef struct typprmupskrn_11_4_1
/* Objet : Parametre de Reference.Constructeur(O:Nul Ou Objet); */
/****************************************************************/
{
TypPrmUpsKrn_11 UpsPrm;
   /* Parametre du type. */
TypUpsVmAdresse UpsVar1;
   /* O : Nul Ou Objet. */
} TypPrmUpsKrn_11_4_1;

/****************************************************************/
typedef struct upstrttypupskrn_11_1_1_0
/* Objet : Methodes du type Reference.                          */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmAdresse UpsVmAPI *(*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsKrn_11_4_1 *UpsPrm);
   /* Constructeur(O:Nul Ou Objet); */

TypUpsVmCoAppel CoMth_4_1;
   /* Constructeur(O:Nul Ou Objet); */
} UpsTrtTypUpsKrn_11_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsKrn_11_1_1_0 UpsTypUpsKrn_11;
typedef UpsTrtTypUpsKrn_11_1_1_0 UpsTrtTypUpsKrn_11;

/****************************************************************/
typedef struct typprmupskrn_12
/* Objet : Parametres de Tableau.                               */
/****************************************************************/
{
TypUpsVmAdresse UpsPrm1;
   /* TypeElement:Type; */
} TypPrmUpsKrn_12;

/****************************************************************/
typedef struct upstypupskrn_12_1_1_1_0
/* Objet : Proprietes d'un Tableau.                             */
/****************************************************************/
{
TypPrmUpsKrn_12 UpsPrm;
   /* Parametre du type. */
TypUpsVmAdresse UpsObjet1;
   /* Objet pour la collection; */
TypUpsVmLong UpsChamp1;
   /* BorneMin : Entier; */
TypUpsVmLong UpsChamp2;
   /* BorneMax : Entier; */
TypUpsVmAdresse ObjetBuffer;
   /* Segment dans lequel est alloue le buffer. Si nul, l'objet est Nul. */
TypUpsVmLong IndexBuffer;
   /* Index du buffer dans le segment. */
TypUpsVmLong NbBuffers;
   /* Nombre d'elements consecutifs occupes par le buffer. */
TypUpsVmAdresse ElementNul;
   /* Element pour l'index Nul. */
} UpsTypUpsKrn_12_1_1_0;

/****************************************************************/
typedef struct typprmupskrn_12_30_1
/* Objet : Parametre de Tableau.Constructeur(NbElements:Entier, */
/* O : Nul Ou TypeElement);                                     */
/****************************************************************/
{
TypPrmUpsKrn_12 UpsPrm;
   /* Parametre du type. */
TypUpsVmLong UpsVar1;
   /* NbElements : Entier; */
TypUpsVmAdresse UpsVar2;
   /* O : Nul Ou TypeElement; */
} TypPrmUpsKrn_12_30_1;

/****************************************************************/
typedef struct typprmupskrn_12_30_2
/* Objet : Parametre de Tableau.Constructeur(BMin : Entier,     */
/* BMax : Entier, O : Nul Ou TypeElement);                      */
/****************************************************************/
{
TypPrmUpsKrn_12 UpsPrm;
   /* Parametre du type. */
TypUpsVmLong UpsVar1;
   /* BMin : Entier; */
TypUpsVmLong UpsVar2;
   /* BMax : Entier; */
TypUpsVmAdresse UpsVar3;
   /* O : Nul Ou TypeElement. */
} TypPrmUpsKrn_12_30_2;

/****************************************************************/
typedef struct typprmupskrn_12_31_1
/* Objet : Parametre de Tableau.Retailler(NbElements : Entier,  */
/* O : Nul Ou TypeElement) Retourner Nul Ou Tableau             */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* NbElements : Entier; */
TypUpsVmAdresse UpsVar2;
   /* O : Nul Ou TypeElement; */
} TypPrmUpsKrn_12_31_1;

/****************************************************************/
typedef struct typprmupskrn_12_31_2
/* Objet : Parametre de Tableau.Retailler(BMin : Entier, BMax : */
/* Entier, O : Nul Ou TypeElement);                             */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* BMin : Entier; */
TypUpsVmLong UpsVar2;
   /* BMax : Entier; */
TypUpsVmAdresse UpsVar3;
   /* O : Nul Ou TypeElement; */
} TypPrmUpsKrn_12_31_2;

/****************************************************************/
typedef struct upstrttypupskrn_12_1_1_0
/* Objet : Methodes du type Tableau.                            */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

/*--------------------------------------------------------------*/
/* Methodes heritees de Iterateur.                              */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_4_1 *UpsPrm);
   /* Fonction ParcoursAuDebut(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_5_1 *UpsPrm);
   /* Fonction ParcoursALaFin(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_6_1 *UpsPrm);
   /* Fonction ParcoursAuMilieu(Position:Nul Ou Entier, NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_7_1 *UpsPrm);
   /* Fonction Suivant(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_8_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_8_1 *UpsPrm);
   /* Fonction Precedent(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_9_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet);
   /* Fonction PremierElement() Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_10_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet);
   /* Fonction DernierElement() Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_11_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_11_1 *UpsPrm);
   /* Fonction NumeroElement(NumeroIterateur : Entier=0) Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_12_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_12_1 *UpsPrm);
   /* Fonction Element(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmLong UpsVmAPI (*Mth_13_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Fonction AllouerIterateur() Retourner Entier; */
TypUpsVmVoid UpsVmAPI (*Mth_14_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_14_1 *UpsPrm);
   /* Procedure LibererIterateur(NumeroIterateur : Entier); */
/*--------------------------------------------------------------*/
/* Methodes heritees de Collection.                             */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*Mth_15_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_15_1 *UpsPrm);
   /* Fonction Gauche(Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_16_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_16_1 *UpsPrm);
   /* Fonction Droite(Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_17_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_17_1 *UpsPrm);
   /* Fonction Milieu(Position:Nul Ou Entier, Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_18_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_18_1 *UpsPrm);
   /* Fonction Inserer(L:Nul Ou Collection, Position:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_19_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_19_1 *UpsPrm);
   /* Fonction Compter(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_20_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_20_1 *UpsPrm);
   /* Fonction Rechercher(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Entier; */
TypUpsVmVoid UpsVmAPI (*Mth_21_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_21_1 *UpsPrm);
   /* Procedure Supprimer(NumeroIterateur : Entier); */
TypUpsVmVoid UpsVmAPI (*Mth_22_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_22_1 *UpsPrm);
   /* Procedure Remplacer(Remplacant:Nul Ou TypeElement, NumeroIterateur : Entier=0); */
TypUpsVmAdresse UpsVmAPI *(*Mth_23_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_23_1 *UpsPrm);
   /* Fonction RemplacerTous(Modele:Nul Ou TypeElement, Remplacant:Nul Ou Objet, Position:Nul Ou Entier=Nul) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_24_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_24_1 *UpsPrm);
   /* Fonction SupprimerTous(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_25_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_25_1 *UpsPrm);
   /* Fonction AjouterAuDebut(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_26_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_26_1 *UpsPrm);
   /* Fonction AjouterALaFin(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_27_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_27_1 *UpsPrm);
   /* Operateur +(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmVoid UpsVmAPI (*Mth_28_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *UpsPrm);
   /* Operateur +=(O:Nul Ou TypeElement); */
TypUpsVmAdresse UpsVmAPI *(*Mth_29_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_29_1 *UpsPrm);
   /* Operateur [](Position:Nul Ou Entier) Retourner Nul Ou TypeElement; */
TypUpsVmVoid UpsVmAPI (*Mth_29_2)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_29_2 *UpsPrm);
   /* Operateur [](Position:Nul Ou Entier, Valeur:Nul Ou TypeElement, MethodeAComposer:Nul Ou Appel=Nul); */
TypUpsVmAdresse UpsVmAPI *(*Mth_29_3)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_29_3 *UpsPrm);
   /* Operateur [](Position:Nul Ou Entier, Prefixe:Booleen, Methode:Nul Ou Appel) Retourner Nul Ou TypeElement; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*Mth_30_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsKrn_12_30_1 *UpsPrm);
   /* Constructeur(NbElements : Entier, O : Nul Ou TypeElement); */
TypUpsVmAdresse UpsVmAPI *(*Mth_30_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsKrn_12_30_2 *UpsPrm);
   /* Constructeur(BMin : Entier, BMax : Entier, O : Nul Ou TypeElement); */
TypUpsVmAdresse UpsVmAPI *(*Mth_31_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_12_31_1 *UpsPrm);
   /* Fonction Retailler(NbElements : Entier, O : Nul Ou TypeElement) Retourner Nul Ou Tableau; */
TypUpsVmAdresse UpsVmAPI *(*Mth_31_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_12_31_2 *UpsPrm);
   /* Fonction Retailler(BMin : Entier, BMax : Entier, O : Nul Ou TypeElement) Retourner Nul Ou Tableau; */

/*--------------------------------------------------------------*/
/* Methodes heritees de Iterateur.                              */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_4_1;
   /* Fonction ParcoursAuDebut(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_5_1;
   /* Fonction ParcoursALaFin(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_6_1;
   /* Fonction ParcoursAuMilieu(Position:Nul Ou Entier, Iterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_7_1;
   /* Fonction Suivant(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_8_1;
   /* Fonction Precedent(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_9_1;
   /* Fonction PremierElement() Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_10_1;
   /* Fonction DernierElement() Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_11_1;
   /* Fonction NumeroElement(NumeroIterateur : Entier=0) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_12_1;
   /* Fonction Element(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_13_1;
   /* Fonction AllouerIterateur() Retourner Entier; */
TypUpsVmCoAppel CoMth_14_1;
   /* Procedure LibererIterateur(NumeroIterateur : Entier); */
/*--------------------------------------------------------------*/
/* Methodes heritees de Collection.                             */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_15_1;
   /* Fonction Gauche(Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_16_1;
   /* Fonction Droite(Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_17_1;
   /* Fonction Milieu(Position:Nul Ou Entier, Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_18_1;
   /* Fonction Inserer(L:Nul Ou Collection, Position:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_19_1;
   /* Fonction Compter(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_20_1;
   /* Fonction Rechercher(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_21_1;
   /* Procedure Supprimer(NumeroIterateur : Entier=0); */
TypUpsVmCoAppel CoMth_22_1;
   /* Procedure Remplacer(Remplacant:Nul Ou TypeElement, NumeroIterateur : Entier=0); */
TypUpsVmCoAppel CoMth_23_1;
   /* Fonction RemplacerTous(Modele:Nul Ou TypeElement, Remplacant:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_24_1;
   /* Fonction SupprimerTous(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_25_1;
   /* Fonction AjouterAuDebut(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_26_1;
   /* Fonction AjouterALaFin(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_27_1;
   /* Operateur +(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_28_1;
   /* Operateur +=(O:Nul Ou TypeElement); */
TypUpsVmCoAppel CoMth_29_1;
   /* Operateur [](Position:Nul Ou Entier) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_29_2;
   /* Operateur [](Position:Nul Ou Entier, Valeur:Nul Ou TypeElement, MethodeAComposer:Nul Ou Appel=Nul); */
TypUpsVmCoAppel CoMth_29_3;
   /* Operateur [](Position:Nul Ou Entier, Prefixe:Booleen, Methode:Nul Ou Appel) Retourner Nul Ou TypeElement; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_30_1;
   /* Constructeur(NbElements : Entier, O : Nul Ou TypeElement); */
TypUpsVmCoAppel CoMth_30_2;
   /* Constructeur(BMin : Entier, BMax : Entier, O : Nul Ou TypeElement); */
TypUpsVmCoAppel CoMth_31_1;
   /* Procedure Retailler(NbElements : Entier, O : Nul Ou TypeElement) Retourner Nul Ou Tableau; */
TypUpsVmCoAppel CoMth_31_2;
   /* Procedure Retailler(BMin : Entier, BMax : Entier, O : Nul Ou TypeElement) Retourner Nul Ou Tableau; */
} UpsTrtTypUpsKrn_12_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsKrn_12_1_1_0 UpsTypUpsKrn_12;
typedef UpsTrtTypUpsKrn_12_1_1_0 UpsTrtTypUpsKrn_12;

/****************************************************************/
typedef struct upstyplisteelementarbre
/* Objet : Proprietes d'une liste d'un element de l'arbre.      */
/****************************************************************/
{
TypUpsVmLong NbElements;
   /* Nombre d'elements; */
TypUpsVmAdresse PremierElement;
   /* Premier element de la liste; */
TypUpsVmAdresse DernierElement;
   /* Dernier element de la liste; */
TypUpsVmLong NumeroObjet;
   /* Numero de l'objet. */
} UpsTypListeElementArbre;

/****************************************************************/
typedef struct typprmupskrn_13
/* Objet : Parametres de Tableau.                               */
/****************************************************************/
{
TypUpsVmAdresse UpsPrm1;
   /* TypeElement:Type; */
} TypPrmUpsKrn_13;

/****************************************************************/
typedef struct upstypupskrn_13_1_1_0
/* Objet : Proprietes d'un ArbreBinaire.                        */
/****************************************************************/
{
TypPrmUpsKrn_13 UpsPrm;
   /* Parametre du type. */
TypUpsVmAdresse UpsObjet1;
   /* Objet pour la collection; */
TypUpsVmAdresse UpsChamp1;
   /* Comparaison:Nul Ou Appel. */
TypUpsVmUnsignedChar UpsChamp2;
   /* Unique:Booleen. */ 
TypUpsVmLong UpsChamp3;
   /* NbGroupes : Entier. */
TypUpsVmAdresse AdresseRacineElementArbre;
   /* Racine de l'arbre. */
TypUpsVmAdresse AdressePremierElementArbre;
   /* Adresse du premier element d'arbre; */
TypUpsVmAdresse AdresseDernierElementArbre;
   /* Adresse de dernier element d'arbre; */
TypUpsVmLong NumeroObjet;
   /* Numero du dernier objet. */
UpsTypListeElementArbre ListeElementArbreNul;
   /* Liste d'elements pour l'element modelisant le nul. */ 
} UpsTypUpsKrn_13_1_1_0;

/****************************************************************/
typedef struct typprmupskrn_13_30_1
/* Objet : Parametre de ArbreBinaire.Constructeur(Comparaison:  */
/* Nul Ou Appel, Unique:Booleen)                                */
/****************************************************************/
{
TypPrmUpsKrn_13 UpsPrm;
   /* Parametre du type. */
TypUpsVmAdresse UpsVar1;
   /* Comparaison : Nul Ou Appel. */
TypUpsVmUnsignedChar UpsVar2;
   /* Unique : Booleen. */
} TypPrmUpsKrn_13_30_1;

/****************************************************************/
typedef struct typprmupskrn_13_31_1
/* Objet : Parametre de Union(A:Nul Ou ArbreBinaire) Retourner  */
/* Nul Ou ArbreBinaire                                          */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* A:Nul Ou ArbreBinaire. */
} TypPrmUpsKrn_13_31_1;

/****************************************************************/
typedef struct typprmupskrn_13_32_1
/* Objet : Parametre de Intersection(A:Nul Ou ArbreBinaire)     */
/* Retourner Nul Ou ArbreBinaire                                */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* A:Nul Ou ArbreBinaire. */
} TypPrmUpsKrn_13_32_1;

/****************************************************************/
typedef struct typprmupskrn_13_33_1
/* Objet : Parametre de Soustraction(A:Nul Ou ArbreBinaire)     */
/* Retourner Nul Ou ArbreBinaire                                */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* A:Nul Ou ArbreBinaire. */
} TypPrmUpsKrn_13_33_1;

/****************************************************************/
typedef struct typprmupskrn_13_34_1
/* Objet : Parametre de Exclusion(A:Nul Ou ArbreBinaire)        */
/* Retourner Nul Ou ArbreBinaire                                */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* A:Nul Ou ArbreBinaire. */
} TypPrmUpsKrn_13_34_1;

/****************************************************************/
typedef struct typprmupskrn_13_35_1
/* Objet : Parametre de SuivantGroupe(NumeroIterateur :         */
/* Entier=0) Retourner Nul Ou TypeElement                       */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Iterateur:Entier. */
} TypPrmUpsKrn_13_35_1;

/****************************************************************/
typedef struct typprmupskrn_13_36_1
/* Objet : Parametre de PrecedentGroupe(NumeroIterateur :       */
/* Entier=0) Retourner Nul Ou TypeElement                       */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* NumeroIterateur:Entier. */
} TypPrmUpsKrn_13_36_1;

/****************************************************************/
typedef struct typprmupskrn_13_37_1
/* Objet : Parametre de NbElementsGroupe(NumeroIterateur:       */
/* Entier=1) Retourner Entier;                                  */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* NumeroIterateur : Entier. */
} TypPrmUpsKrn_13_37_1;

/****************************************************************/
typedef struct typprmupskrn_13_38_1
/* Objet : Parametre de PremierElementGroupe(NumeroIterateur:   */
/* Entier=0) Retourner Nul Ou TypeElement;                      */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* NumeroIterateur : Entier. */
} TypPrmUpsKrn_13_38_1;

/****************************************************************/
typedef struct typprmupskrn_13_39_1
/* Objet : Parametre de DernierElementGroupe(NumeroIterateur:   */
/* Entier=0) Retourner Nul Ou TypeElement;                      */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* NumeroIterateur : Entier. */
} TypPrmUpsKrn_13_39_1;

/****************************************************************/
typedef struct upstrttypupskrn_13_1_1_0
/* Objet : Methodes du type ArbreBinaire.                       */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

/*--------------------------------------------------------------*/
/* Methodes heritees de Iterateur.                              */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_4_1 *UpsPrm);
   /* Fonction ParcoursAuDebut(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_5_1 *UpsPrm);
   /* Fonction ParcoursALaFin(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_6_1 *UpsPrm);
   /* Fonction ParcoursAuMilieu(Position:Nul Ou Entier, NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_7_1 *UpsPrm);
   /* Fonction Suivant(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_8_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_8_1 *UpsPrm);
   /* Fonction Precedent(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_9_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet);
   /* Fonction PremierElement() Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_10_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet);
   /* Fonction DernierElement() Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_11_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_11_1 *UpsPrm);
   /* Fonction NumeroElement(NumeroIterateur : Entier=0) Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_12_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_12_1 *UpsPrm);
   /* Fonction Element(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmLong UpsVmAPI (*Mth_13_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Fonction AllouerIterateur() Retourner Entier; */
TypUpsVmVoid UpsVmAPI (*Mth_14_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_19_14_1 *UpsPrm);
   /* Procedure LibererIterateur(NumeroIterateur : Entier); */
/*--------------------------------------------------------------*/
/* Methodes heritees de Collection.                             */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*Mth_15_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_15_1 *UpsPrm);
   /* Fonction Gauche(Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_16_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_16_1 *UpsPrm);
   /* Fonction Droite(Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_17_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_17_1 *UpsPrm);
   /* Fonction Milieu(Position:Nul Ou Entier, Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_18_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_18_1 *UpsPrm);
   /* Fonction Inserer(L:Nul Ou Collection, Position:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_19_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_19_1 *UpsPrm);
   /* Fonction Compter(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_20_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_20_1 *UpsPrm);
   /* Fonction Rechercher(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Entier; */
TypUpsVmVoid UpsVmAPI (*Mth_21_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_21_1 *UpsPrm);
   /* Procedure Supprimer(NumeroIterateur : Entier); */
TypUpsVmVoid UpsVmAPI (*Mth_22_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_22_1 *UpsPrm);
   /* Procedure Remplacer(Remplacant:Nul Ou TypeElement, NumeroIterateur : Entier=0); */
TypUpsVmAdresse UpsVmAPI *(*Mth_23_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_23_1 *UpsPrm);
   /* Fonction RemplacerTous(Modele:Nul Ou TypeElement, Remplacant:Nul Ou Objet, Position:Nul Ou Entier=Nul) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_24_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_24_1 *UpsPrm);
   /* Fonction SupprimerTous(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_25_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_25_1 *UpsPrm);
   /* Fonction AjouterAuDebut(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_26_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_26_1 *UpsPrm);
   /* Fonction AjouterALaFin(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmAdresse UpsVmAPI *(*Mth_27_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_27_1 *UpsPrm);
   /* Operateur +(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmVoid UpsVmAPI (*Mth_28_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *UpsPrm);
   /* Operateur +=(O:Nul Ou TypeElement); */
TypUpsVmAdresse UpsVmAPI *(*Mth_29_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_29_1 *UpsPrm);
   /* Operateur [](Position:Nul Ou Entier) Retourner Nul Ou TypeElement; */
TypUpsVmVoid UpsVmAPI (*Mth_29_2)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_29_2 *UpsPrm);
   /* Operateur [](Position:Nul Ou Entier, Valeur:Nul Ou TypeElement, MethodeAComposer:Nul Ou Appel=Nul); */
TypUpsVmAdresse UpsVmAPI *(*Mth_29_3)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_20_29_3 *UpsPrm);
   /* Operateur [](Position:Nul Ou Entier, Prefixe:Booleen, Methode:Nul Ou Appel) Retourner Nul Ou TypeElement; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*Mth_30_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsKrn_13_30_1 *UpsPrm);
   /* Constructeur(Comparaison:Nul Ou Appel, Unique:Booleen); */
TypUpsVmAdresse UpsVmAPI *(*Mth_31_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsKrn_13_31_1 *UpsPrm);
   /* Fonction Union(L:Nul Ou ArbreBinaire) Retourner Nul Ou ArbreBinaire; */
TypUpsVmAdresse UpsVmAPI *(*Mth_32_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsKrn_13_32_1 *UpsPrm);
   /* Fonction Intersection(L:Nul Ou ArbreBinaire) Retourner Nul Ou ArbreBinaire; */
TypUpsVmAdresse UpsVmAPI *(*Mth_33_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsKrn_13_33_1 *UpsPrm);
   /* Fonction Soustraction(L:Nul Ou ArbreBinaire) Retourner Nul Ou ArbreBinaire; */
TypUpsVmAdresse UpsVmAPI *(*Mth_34_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsKrn_13_34_1 *UpsPrm);
   /* Exclusion(L:Nul Ou ArbreBinaire) Retourner Nul Ou ArbreBinaire; */
TypUpsVmAdresse UpsVmAPI *(*Mth_35_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsKrn_13_35_1 *UpsPrm);
   /* Fonction SuivantGroupe(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_36_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsKrn_13_36_1 *UpsPrm);
   /* Fonction PrecedentGroupe(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmLong UpsVmAPI (*Mth_37_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_13_37_1 *UpsPrm);
   /* Fonction NbElementsGroupe(NumeroIterateur:Entier=0) Retourner Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_38_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_13_38_1 *UpsPrm);
   /* Fonction PremierElementGroupe(NumeroIterateur:Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmAdresse UpsVmAPI *(*Mth_39_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_13_39_1 *UpsPrm);
   /* Fonction DernierElementGroupe(NumeroIterateur:Entier=0) Retourner Nul Ou TypeElement; */

/*--------------------------------------------------------------*/
/* Methodes heritees de Iterateur.                              */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_4_1;
   /* Fonction ParcoursAuDebut(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_5_1;
   /* Fonction ParcoursALaFin(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_6_1;
   /* Fonction ParcoursAuMilieu(Position:Nul Ou Entier, Iterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_7_1;
   /* Fonction Suivant(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_8_1;
   /* Fonction Precedent(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_9_1;
   /* Fonction PremierElement() Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_10_1;
   /* Fonction DernierElement() Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_11_1;
   /* Fonction NumeroElement(NumeroIterateur : Entier=0) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_12_1;
   /* Fonction Element(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_13_1;
   /* Fonction AllouerIterateur() Retourner Entier; */
TypUpsVmCoAppel CoMth_14_1;
   /* Procedure LibererIterateur(NumeroIterateur : Entier); */
/*--------------------------------------------------------------*/
/* Methodes heritees de Collection.                             */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_15_1;
   /* Fonction Gauche(Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_16_1;
   /* Fonction Droite(Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_17_1;
   /* Fonction Milieu(Position:Nul Ou Entier, Taille:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_18_1;
   /* Fonction Inserer(L:Nul Ou Collection, Position:Nul Ou Entier) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_19_1;
   /* Fonction Compter(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_20_1;
   /* Fonction Rechercher(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_21_1;
   /* Procedure Supprimer(NumeroIterateur : Entier=0); */
TypUpsVmCoAppel CoMth_22_1;
   /* Procedure Remplacer(Remplacant:Nul Ou TypeElement, NumeroIterateur : Entier=0); */
TypUpsVmCoAppel CoMth_23_1;
   /* Fonction RemplacerTous(Modele:Nul Ou TypeElement, Remplacant:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_24_1;
   /* Fonction SupprimerTous(Modele:Nul Ou TypeElement, Position:Nul Ou Entier=Nul) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_25_1;
   /* Fonction AjouterAuDebut(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_26_1;
   /* Fonction AjouterALaFin(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_27_1;
   /* Operateur +(O:Nul Ou TypeElement) Retourner Nul Ou Collection; */
TypUpsVmCoAppel CoMth_28_1;
   /* Operateur +=(O:Nul Ou TypeElement); */
TypUpsVmCoAppel CoMth_29_1;
   /* Operateur [](Position:Nul Ou Entier) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_29_2;
   /* Operateur [](Position:Nul Ou Entier, Valeur:Nul Ou TypeElement, MethodeAComposer:Nul Ou Appel=Nul); */
TypUpsVmCoAppel CoMth_29_3;
   /* Operateur [](Position:Nul Ou Entier, Prefixe:Booleen, Methode:Nul Ou Appel) Retourner Nul Ou TypeElement; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_30_1;
   /* Constructeur(Comparaison:Nul Ou Appel, Unique:Booleen); */
TypUpsVmCoAppel CoMth_31_1;
   /* Fonction Union(L:Nul Ou ArbreBinaire) Retourner Nul Ou ArbreBinaire; */
TypUpsVmCoAppel CoMth_32_1;
   /* Fonction Intersection(L:Nul Ou ArbreBinaire) Retourner Nul Ou ArbreBinaire; */
TypUpsVmCoAppel CoMth_33_1;
   /* Fonction Soustraction(L:Nul Ou ArbreBinaire) Retourner Nul Ou ArbreBinaire; */
TypUpsVmCoAppel CoMth_34_1;
   /* Exclusion(L:Nul Ou ArbreBinaire) Retourner Nul Ou ArbreBinaire; */
TypUpsVmCoAppel CoMth_35_1;
   /* Fonction SuivantGroupe(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_36_1;
   /* Fonction PrecedentGroupe(NumeroIterateur : Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_37_1;
   /* Fonction NbElementsGroupe(NumeroIterateur:Entier=0) Retourner Entier; */
TypUpsVmCoAppel CoMth_38_1;
   /* Fonction PremierElementGroupe(NumeroIterateur:Entier=0) Retourner Nul Ou TypeElement; */
TypUpsVmCoAppel CoMth_39_1;
   /* Fonction DernierElementGroupe(NumeroIterateur:Entier=0) Retourner Nul Ou TypeElement; */
} UpsTrtTypUpsKrn_13_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsKrn_13_1_1_0 UpsTypUpsKrn_13;
typedef UpsTrtTypUpsKrn_13_1_1_0 UpsTrtTypUpsKrn_13;

/****************************************************************/
typedef struct upstypupskrn_14_1_1_0
/* Objet : Proprietes d'un entrepot.                            */
/****************************************************************/
{
TypUpsVmAdresse UpsChamp1;
   /* NomEntrepot : Caractere; */
TypUpsVmAdresse UpsChamp2;
   /* Serveur : Nul Ou Caractere; */
TypUpsVmUnsignedChar UpsChamp3;
   /* Acces : AccesEntrepot; */
TypUpsVmUnsignedChar UpsChamp4;
   /* MemoireEstMobile : Booleen; */
TypUpsVmAdresse UpsChamp5;
   /* ModuleOrigine : Nul Ou Module; */
TypUpsVmUnsignedShort NumeroEntrepot;
  /* Numero de l'entrepot. */
} UpsTypUpsKrn_14_1_1_0;

/****************************************************************/
typedef struct typprmupskrn_14_11_1
/* Objet : Parametre de Procedure ChangerEtat(NouvelEtat:       */
/* EtatEntrepot);                                               */
/****************************************************************/
{
TypUpsVmUnsignedChar UpsVar1;
   /* NouvelEtat : EtatEntrepot. */
} TypPrmUpsKrn_14_11_1;

/****************************************************************/
typedef struct upstrttypupskrn_14_1_1_0
/* Objet : Methodes du type Entrepot.                          */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmLong UpsVmAPI (*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Fonction TailleMemoireAllouee() Retourner Entier; */
TypUpsVmLong UpsVmAPI (*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Fonction TailleMemoireTotale() Retourner Entier; */
TypUpsVmLong UpsVmAPI (*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Fonction TailleFichierEchangeAlloue() Retourner Entier; */
TypUpsVmLong UpsVmAPI (*Mth_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Fonction TailleFichierEchangeTotal() Retourner Entier; */
TypUpsVmLong UpsVmAPI (*Mth_8_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Fonction NbVerrousPoses() Retourner Entier; */
TypUpsVmLong UpsVmAPI (*Mth_9_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Fonction NbVerrousTotal() Retourner Entier; */
TypUpsVmLong UpsVmAPI (*Mth_10_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Fonction NbObjetsAlloues() Retourner Entier; */
TypUpsVmVoid UpsVmAPI (*Mth_11_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsKrn_14_11_1 *UpsPrm);
   /* Procedure ChangerEtat(NouvelEtat:EtatEntrepot); */
TypUpsVmUnsignedChar UpsVmAPI (*Mth_12_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Fonction Etat() Retourner EtatEntrepot; */

TypUpsVmCoAppel CoMth_4_1;
   /* Fonction TailleMemoireAllouee() Retourner Entier; */
TypUpsVmCoAppel CoMth_5_1;
   /* Fonction TailleMemoireTotale() Retourner Entier; */
TypUpsVmCoAppel CoMth_6_1;
   /* Fonction TailleFichierEchangeAlloue() Retourner Entier; */
TypUpsVmCoAppel CoMth_7_1;
   /* Fonction TailleFichierEchangeTotal() Retourner Entier; */
TypUpsVmCoAppel CoMth_8_1;
   /* Fonction NbVerrousPoses() Retourner Entier; */
TypUpsVmCoAppel CoMth_9_1;
   /* Fonction NbVerrousTotal() Retourner Entier; */
TypUpsVmCoAppel CoMth_10_1;
   /* Fonction NbObjetsAlloues() Retourner Entier; */
TypUpsVmCoAppel CoMth_11_1;
   /* Procedure ChangerEtat(NouvelEtat:EtatEntrepot); */
TypUpsVmCoAppel CoMth_12_1;
   /* Fonction Etat() Retourner EtatEntrepot; */
} UpsTrtTypUpsKrn_14_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsKrn_14_1_1_0 UpsTypUpsKrn_14;
typedef UpsTrtTypUpsKrn_14_1_1_0 UpsTrtTypUpsKrn_14;

/****************************************************************/
typedef struct upstypupskrn_15_1_1_0
/* Objet : Proprietes du type Module.                           */
/****************************************************************/
{
TypUpsVmAdresse UpsChamp1;
   /* NomModule:Caractere; */
TypUpsVmLong UpsChamp2;
   /* NumeroModule:Entier; */
TypUpsVmLong UpsChamp3;
   /* PrioriteModule:Entier. */
TypUpsVmLong UpsChamp4;
   /* Version:Entier. */
TypUpsVmLong UpsChamp5;
   /* Revision:Entier. */
TypUpsVmLong UpsChamp6;
   /* Correction:Entier. */
TypUpsVmShort EstDistribue;
   /* Pour memorise si le module est distribue. */
} UpsTypUpsKrn_15_1_1_0;

/****************************************************************/
typedef struct typprmupskrn_15_4_1
/* Objet : Parametre de Constructeur(ModuleACharger:Caractere,  */
/* VersionDuModule:Entier, RevisionDuModule:Entier,             */
/* CorrectionDuModule:Entier);                                  */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* ModuleACharger : Nul Ou Caractere. */
TypUpsVmLong UpsVar2;
   /* VersionDuModule:Entier. */
TypUpsVmLong UpsVar3;
   /* RevisionDuModule:Entier. */
TypUpsVmLong UpsVar4;
   /* CorrectionDuModule:Entier. */
} TypPrmUpsKrn_15_4_1;

/****************************************************************/
typedef struct typprmupskrn_15_5_1
/* Objet : Parametre NouvelObjet(InterfaceAImplementer : Type)  */
/* Retourner Objet                                              */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* InterfaceAImplementer : Type. */
} TypPrmUpsKrn_15_5_1;

/****************************************************************/
typedef struct typprmupskrn_15_6_1
/* Objet : Parametre EnumererEnumeres(Numero:Entier, Aide:Nul Ou*/
/* Caractere Sortie) Retourner Nul Ou Caractere                 */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Numero:Entier; */
TypUpsVmAdresse UpsVar2;
   /* Aide:Nul Ou Caractere Sortie; */
} TypPrmUpsKrn_15_6_1;

/****************************************************************/
typedef struct typprmupskrn_15_7_1
/* Objet : Parametre EnumererValeursEnumeres(NomEnumere:        */
/* Caractere, Numero:Entier, Aide:Nul Ou Caractere Sortie)      */
/* Retourner Nul Ou Caractere                                   */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomEnumere:Caractere; */
TypUpsVmLong UpsVar2;
   /* Numero:Entier; */
TypUpsVmAdresse UpsVar3;
   /* Aide:Nul Ou Caractere Sortie; */
} TypPrmUpsKrn_15_7_1;

/****************************************************************/
typedef struct typprmupskrn_15_8_1
/* Objet : Parametre EnumererEntrepots(Numero:Entier, Aide:Nul */
/* Ou Caractere Sortie) Retourner Nul Ou Entrepot              */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Numero:Entier; */
TypUpsVmAdresse UpsVar2;
   /* Aide:Nul Ou Caractere Sortie; */
} TypPrmUpsKrn_15_8_1;

/****************************************************************/
typedef struct typprmupskrn_15_9_1
/* Objet : Parametre EnumererTypes(Numero:Entier, Aide:Nul      */
/* Ou Caractere Sortie) Retourner Nul Ou Type                   */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Numero:Entier; */
TypUpsVmAdresse UpsVar2;
   /* Aide:Nul Ou Caractere Sortie; */
} TypPrmUpsKrn_15_9_1;

/****************************************************************/
typedef struct typprmupskrn_15_10_1
/* Objet : Parametre EnumererVariables(Numero:Entier,           */
/* TypeVariable : Nul Ou Type, PeutEtreNul : Booleen, Aide:Nul  */
/* Ou Caractere Sortie, NomEnumere : Nul Ou Caractere) Retourner*/
/* Nul Ou Caractere                                             */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Numero : Entier. */
TypUpsVmAdresse UpsVar2;
   /* TypeVariable : Nul Ou Type. */
TypUpsVmUnsignedChar UpsVar3;
   /* PeutEtreNul : Booleen. */
TypUpsVmAdresse UpsVar4;
   /* Aide : Nul Ou Caractere. */
TypUpsVmAdresse UpsVar5;
   /* NomEnumere : Nul Ou Caractere. */
} TypPrmUpsKrn_15_10_1;

/****************************************************************/
typedef struct typprmupskrn_15_11_1
/* Objet : Parametre EnumererExceptions(Numero:Entier, Aide:Nul */
/* Ou Caractere Sortie) Retourner Nul Ou Exception              */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Numero:Entier; */
TypUpsVmAdresse UpsVar2;
   /* Aide:Nul Ou Caractere Sortie; */
} TypPrmUpsKrn_15_11_1;

/****************************************************************/
typedef struct typprmupskrn_15_12_1
/* Objet : Parametre EnumererAppels(Numero:Entier, NomAppel:    */
/* Caractere Sortie, Aide:Nul Ou Caractere Sortie) Retourner    */
/* Nul Ou Appel                                                 */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Numero:Entier; */
TypUpsVmAdresse UpsVar2;
   /* NomAppel:Caractere Sortie; */
TypUpsVmAdresse UpsVar3;
   /* Aide:Nul Ou Caractere Sortie; */
} TypPrmUpsKrn_15_12_1;

/****************************************************************/
typedef struct typprmupskrn_15_13_1
/* Objet : Parametre EcrireVariable(NomVariable : Nul Ou        */
/* Caractere, ValeurVariable : Nul Ou Objet);                   */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomVariable:Nul Ou Caractere; */
TypUpsVmAdresse UpsVar2;
   /* ValeurVariable : Nul Ou Objet; */
} TypPrmUpsKrn_15_13_1;

/****************************************************************/
typedef struct typprmupskrn_15_14_1
/* Objet : Parametre LireVariable(NomVariable : Nul Ou          */
/* Caractere) Retourner Nul Ou Objet;                           */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomVariable:Nul Ou Caractere; */
} TypPrmUpsKrn_15_14_1;

/****************************************************************/
typedef struct typprmupskrn_15_15_1
/* Objet : Parametres IncrementerDecrementerVariable(NomVariable*/
/* : Nul Ou Caractere, Incrementer:Booleen, Prefixe:Booleen)    */
/* Retourner Nul Ou Objet.                                      */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomVariable:Nul Ou Caractere; */
TypUpsVmUnsignedChar UpsVar2;
   /* Incrementer : booleen. */
TypUpsVmUnsignedChar UpsVar3;
   /* Prefixe : booleen. */
} TypPrmUpsKrn_15_15_1;

/****************************************************************/
typedef struct upstrttypupskrn_15_1_1_0
/* Objet : Methodes du type Module.                             */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

TypUpsVmAdresse UpsVmAPI *(*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsKrn_15_4_1 *UpsPrm);
   /* Constructeur(ModuleACharger:Caractere, VersionDuModule:Entier, RevisionDuModule:Entier, */
   /* CorrectionDuModule:Entier); */
TypUpsVmAdresse UpsVmAPI *(*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_15_5_1 *UpsPrm);
   /* Fonction NouvelObjet(InterfaceAImplementer : Type) Retourner Objet; */
TypUpsVmAdresse UpsVmAPI *(*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_15_6_1 *UpsPrm);
   /* Fonction EnumererEnumeres(Numero:Entier, Aide:Nul Ou Caractere Sortie) Retourner Nul Ou Caractere; */
TypUpsVmAdresse UpsVmAPI *(*Mth_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_15_7_1 *UpsPrm);
   /* Fonction EnumererValeursEnumeres(NomEnumere:Caractere, Numero:Entier, Aide:Nul Ou Caractere Sortie) Retourner Nul Ou Caractere; */
TypUpsVmAdresse UpsVmAPI *(*Mth_8_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_15_8_1 *UpsPrm);
   /* Fonction EnumererEntrepots(Numero:Entier, Aide:Nul Ou Caractere Sortie) Retourner Nul Ou Entrepot; */
TypUpsVmAdresse UpsVmAPI *(*Mth_9_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_15_9_1 *UpsPrm);
   /* Fonction EnumererTypes(Numero:Entier, Aide:Nul Ou Caractere Sortie) Retourner Nul Ou Type; */
TypUpsVmAdresse UpsVmAPI *(*Mth_10_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_15_10_1 *UpsPrm);
   /* Fonction EnumererVariables(Numero:Entier, TypeVariable : Nul Ou Type, PeutEtreNul : Booleen, Aide:Nul Ou Caractere Sortie, NomEnumere : Nul Ou Caractere) Retourner Nul Ou Caractere; */
TypUpsVmAdresse UpsVmAPI *(*Mth_11_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_15_11_1 *UpsPrm);
   /* Fonction EnumererExceptions(Numero:Entier, Aide:Nul Ou Caractere Sortie) Retourner Nul Ou Exceptions; */
TypUpsVmAdresse UpsVmAPI *(*Mth_12_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_15_12_1 *UpsPrm);
   /* Fonction EnumererAppels(Numero:Entier, Aide:Nul Ou Caractere Sortie) Retourner Nul Ou Appel; */
TypUpsVmVoid UpsVmAPI (*Mth_13_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_15_13_1 *UpsPrm);
   /* Procedure EcrireVariable(NomVariable : Nul Ou UpsKrnCaractere, ValeurVariable : Nul Ou Objet); */
TypUpsVmAdresse UpsVmAPI *(*Mth_14_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_15_14_1 *UpsPrm);
   /* Fonction LireVariable(NomVariable : Nul Ou UpsKrnCaractere) Retourner Nul Ou Objet; */
TypUpsVmAdresse UpsVmAPI *(*Mth_15_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsKrn_15_15_1 *UpsPrm);
   /* Fonction IncrementerDecrementerVariable(NomVariable : Nul Ou Caractere, Incrementer:Booleen, Prefixe:Booleen) Retourner Nul Ou Objet; */

TypUpsVmCoAppel CoMth_4_1;
   /* Constructeur(ModuleACharger:Caractere, VersionDuModule:Entier, RevisionDuModule:Entier, */
   /* CorrectionDuModule:Entier); */
TypUpsVmCoAppel CoMth_5_1;
   /* Fonction NouvelObjet(InterfaceAImplementer : Type) Retourner Objet; */
TypUpsVmCoAppel CoMth_6_1;
   /* Fonction EnumererEnumere(Numero:Entier, Aide:Nul Ou Caractere Sortie) Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_7_1;
   /* Fonction EnumererValeurEnumere(NomEnumere:Caractere, Numero:Entier, Aide:Nul Ou Caractere Sortie) Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_8_1;
   /* Fonction EnumererEntrepots(Numero:Entier, Aide:Nul Ou Caractere Sortie) Retourner Nul Ou Entrepot; */
TypUpsVmCoAppel CoMth_9_1;
   /* Fonction EnumererTypes(Numero:Entier, Aide:Nul Ou Caractere Sortie) Retourner Nul Ou Type; */
TypUpsVmCoAppel CoMth_10_1;
   /* Fonction EnumererVariables(Numero:Entier, TypeVariable : Nul Ou Type, PeutEtreNul : Booleen, Aide:Nul Ou Caractere Sortie, NomEnumere : Nul Ou Caractere) Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_11_1;
   /* Fonction EnumererExceptions(Numero:Entier, Aide:Nul Ou Caractere Sortie) Retourner Nul Ou Exception; */
TypUpsVmCoAppel CoMth_12_1;
   /* Fonction EnumererAppels(Numero:Entier, Aide:Nul Ou Caractere Sortie) Retourner Nul Ou Appel; */
TypUpsVmCoAppel CoMth_13_1;
   /* Procedure EcrireVariable(NomVariable : Nul Ou UpsKrnCaractere, ValeurVariable : Nul Ou Objet); */
TypUpsVmCoAppel CoMth_14_1;
   /* Fonction LireVariable(NomVariable : Nul Ou UpsKrnCaractere) Retourner Nul Ou Objet; */
TypUpsVmCoAppel CoMth_15_1;
   /* Fonction IncrementerDecrementerVariable(NomVariable : Nul Ou Caractere, Incrementer:Booleen, Prefixe:Booleen) Retourner Nul Ou Objet; */
} UpsTrtTypUpsKrn_15_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsKrn_15_1_1_0 UpsTypUpsKrn_15;
typedef UpsTrtTypUpsKrn_15_1_1_0 UpsTrtTypUpsKrn_15;

/****************************************************************/
typedef struct typprmupskrn_16_4_1
/* Objet : Parametre EnumererParametres(Numero:Entier,          */
/* TypeParametre : Nul Ou Type, PeutEtreNul : Booleen, Aide:Nul */
/* Ou Caractere Sortie, NomEnumere : Nul Ou Caractere,          */
/* SorteDuParametre: SorteParametre, IlExisteValeurParDefaut:   */
/* Booleen) Retourner Nul Ou Caractere;                         */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Numero : Entier. */
TypUpsVmAdresse UpsVar2;
   /* TypeParametre : Nul Ou Type. */
TypUpsVmUnsignedChar UpsVar3;
   /* PeutEtreNul : Booleen. */
TypUpsVmAdresse UpsVar4;
   /* Aide : Nul Ou Caractere. */
TypUpsVmAdresse UpsVar5;
   /* NomEnumere : Nul Ou Caractere. */
TypUpsVmUnsignedChar UpsVar6;
   /* SorteDuParametre:SorteParametre; */
TypUpsVmUnsignedChar UpsVar7;
   /* IlExisteValeurParDefaut:Booleen; */
} TypPrmUpsKrn_16_4_1;

/****************************************************************/
typedef struct typprmupskrn_16_5_1
/* Objet : Parametre ExecuterProcedure(Parametres:Nul Ou        */
/* ListeDe Nul Ou Objet Entree Sortie);                         */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Parametres:Nul Ou ListeDe Nul Ou Objet. */
} TypPrmUpsKrn_16_5_1;

/****************************************************************/
typedef struct typprmupskrn_16_5_2
/* Objet : Parametre ExecuterProcedure(O:Nul Ou Objet,          */
/* Parametres:Nul Ou ListeDe Nul Ou Objet Entree Sortie);       */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* O:Nul Ou Objet, . */
TypUpsVmAdresse UpsVar2;
   /* Parametres:Nul Ou ListeDe Nul Ou Objet. */
} TypPrmUpsKrn_16_5_2;

/****************************************************************/
typedef struct typprmupskrn_16_6_1
/* Objet : Parametre ExecuterFonction(Parametres:Nul Ou ListeDe */
/* Nul Ou Objet Entree Sortie) Retourner Nul Ou Objet;          */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Parametres:Nul Ou ListeDe Nul Ou Objet. */
} TypPrmUpsKrn_16_6_1;

/****************************************************************/
typedef struct typprmupskrn_16_6_2
/* Objet : ExecuterFonction(O:Nul Ou Objet, Parametres:Nul Ou   */
/* ListeDe Nul Ou Objet Entree Sortie) Retourner Nul Ou Objet;  */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* O:Nul Ou Objet, . */
TypUpsVmAdresse UpsVar2;
   /* Parametres:Nul Ou ListeDe Nul Ou Objet. */
} TypPrmUpsKrn_16_6_2;

/****************************************************************/
typedef struct upstypupskrn_16_1_1_0
/* Objet : Proprietes d'un Appel.                               */
/****************************************************************/
{
TypUpsVmAdresse UpsChamp1;
   /* ModuleOrigine: Caractere; */
TypUpsVmAdresse UpsChamp2;
   /* NomAppel: Caractere; */
TypUpsVmAdresse UpsChamp3;
   /* TypeOrigine:Nul Ou Type; */
enum EnuUpsVmModeDAppel TypeAppel;
   /* Type de l'appel. */
enum EnuUpsVmTypeDeTraitements TypeDeTraitements;
   /* Type de traitements. */
union
   {
   struct
      {
      TypUpsVmPointeurTraitements Appel;
         /* Appel en soi. */
/**********************************/
#if defined(PLATEFORME32TRAITEMENTS)
/**********************************/
      TypUpsVmPointeurDonnees TrouAppel;
         /* Pour la compatibilite 64 bits. */
/****/
#endif
/****/
      TypUpsVmCoAppel EnumererParametres;
         /* Co-appel. */
/**********************************/
#if defined(PLATEFORME32TRAITEMENTS)
/**********************************/
      TypUpsVmPointeurDonnees TrouEnumererParametres;
         /* Pour la compatibilite 64 bits. */
/****/
#endif
/****/
      TypUpsVmAdresse AdresseObjet;
         /* Pour une methode, objet d'application. */
      TypUpsVmLong IndexAppel;
         /* Index de l'appel dans la table des appels. */
      TypUpsVmLong IndexCoAppel;
         /* Index du co-appel dans la table des appels. */
      } NatifCompile;
      /* Pour TT_NatifCompile. */
   struct
      {
      TypUpsVmPointeurDonnees Extension;
         /* Extension de l'appel dans une technologie tiers. */
/******************************/
#if defined(PLATEFORME32DONNEES)
/******************************/
      TypUpsVmPointeurDonnees TrouExtension;
         /* Pour la compatibilite 64 bits. */
/****/
#endif
/****/
      } NonNatifCompile;
      /* Pour TT_ScriptInterprete, TT_NatifCorba, TT_NatifCom et TT_NatifJava. */
   } Selection;
   /* Selection en fonction du type de traitements. */
} UpsTypUpsKrn_16_1_1_0;

/****************************************************************/
typedef struct upstrttypupskrn_16_1_1_0
/* Objet : Methodes du type Appel.                              */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */
TypUpsVmAdresse UpsVmAPI *(*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsKrn_16_4_1 *UpsPrm);
   /* Fonction EnumererParametres(Numero:Entier, TypeParametre : Nul Ou Type Sortie, PeutEtreNul : Booleen Sortie, 
      Aide:Nul Ou Caractere Sortie, NomEnumere : Nul Ou Caractere Sortie, SorteDuParametre: 
      SorteParametre Sortie, IlExisteValeurParDefaut:Booleen Sortie) Retourner Nul Ou Caractere; */
TypUpsVmVoid UpsVmAPI (*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsKrn_16_5_1 *UpsPrm);
   /* Procedure ExecuterProcedure(Parametres:Nul Ou ListeDe Nul Ou Objet Entree Sortie); */
TypUpsVmAdresse UpsVmAPI *(*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsKrn_16_6_1 *UpsPrm);
   /* Fonction ExecuterFonction(Parametres:Nul Ou ListeDe Nul Ou Objet Entree Sortie) Retourner Nul Ou Objet; */

TypUpsVmCoAppel CoMth_4_1;
   /* Fonction EnumererParametres(Numero:Entier, TypeParametre : Nul Ou Type, PeutEtreNul : Booleen, 
      Aide:Nul Ou Caractere Sortie, NomEnumere : Nul Ou Caractere) Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMth_5_1;
   /* Procedure ExecuterProcedure(Parametres:Nul Ou ListeDe Nul Ou Objet Entree Sortie); */
TypUpsVmCoAppel CoMth_6_1;
   /* Fonction ExecuterFonction(Parametres:Nul Ou ListeDe Nul Ou Objet Entree Sortie) Retourner Nul Ou Objet; */
} UpsTrtTypUpsKrn_16_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsKrn_16_1_1_0 UpsTypUpsKrn_16;
typedef UpsTrtTypUpsKrn_16_1_1_0 UpsTrtTypUpsKrn_16;

/****************************************************************/
typedef struct upstypupskrn_17_1_1_0
/* Objet : Proprietes d'une Transaction.                        */
/****************************************************************/
{
TypUpsVmAdresse UpsChamp1;
   /* NomTransaction: Caractere; */
TypUpsVmAdresse UpsChamp2;
   /* TransactionMere: Nul Ou Transaction; */
TypUpsVmAdresse UpsChamp3;
   /* TransactionFille: Nul Ou Transaction; */
TypUpsVmAdresse AdresseArbreDImagesAvants;
   /* Adresse de l'arbre binaire des images avant conservees par la transaction. */
TypUpsVmAdresse AdresseListeTachesAReveiller;
   /* Adresse de la liste des taches en attente de modifications sur un objet de la transaction. */
TypUpsVmExtension ExtensionTransactionsDistribuees;
	/* Extension pour les transactions distribuees. */
} UpsTypUpsKrn_17_1_1_0;

/****************************************************************/
typedef struct typprmupskrn_17_4_1
/* Objet : Parametre Constructeur(NomDeLaTransaction:Caractere);*/
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomDeLaTransaction : Caractere. */
} TypPrmUpsKrn_17_4_1;

/****************************************************************/
typedef struct upstrttypupskrn_17_1_1_0
/* Objet : Methodes du type Transaction.                        */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */
TypUpsVmAdresse UpsVmAPI *(*Mth_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsKrn_17_4_1 *UpsPrm);
   /* Constructeur(NomDeLaTransaction:Caractere); */ 
TypUpsVmVoid UpsVmAPI (*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Procedure Valider(); */
TypUpsVmVoid UpsVmAPI (*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Procedure Invalider(); */

TypUpsVmCoAppel CoMth_4_1;
   /* Constructeur(NomDeLaTransaction:Caractere); */ 
TypUpsVmCoAppel CoMth_5_1;
   /* Procedure Valider(); */
TypUpsVmCoAppel CoMth_6_1;
   /* Procedure Invalider(); */
} UpsTrtTypUpsKrn_17_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsKrn_17_1_1_0 UpsTypUpsKrn_17;
typedef UpsTrtTypUpsKrn_17_1_1_0 UpsTrtTypUpsKrn_17;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsKrn_4 UpsTypUpsKrn_18;
typedef UpsTrtTypUpsKrn_4 UpsTrtTypUpsKrn_18;

/****************************************************************/
typedef struct typupskrndonnees
/* Objet: Interface des donnees de Ups Krn.                     */
/****************************************************************/
{
struct typupsvmentetedonneesmodule EnteteDonneesModule;
   /* Entete generique du module. */

TypUpsVmShort MiseAuPoint;
   /* Si Vrai, la mise au point est activee. */
TypUpsVmUnicode FichierMiseAuPoint[CO_TailleNomFichier+1];
   /* Fichier de mise au point. */
TypUpsVmUnicode Journal[CO_TailleNomFichier+1];
   /* Fichier journal. */
TypUpsVmShort CompteurMiseAuPoint;
   /* Pour compter l'activation de la trace. */
TypUpsVmShort CompteurAppels;
   /* Pour compter les appels. */
/*--------------------------------------------------------------*/
/* Libelle des APIs frequentes dans la langue courante.         */
/*--------------------------------------------------------------*/
TypUpsVmUnicode *ActiverContrainte;
   /* Libelle de ActiverContrainte. */
TypUpsVmUnicode *ActiverContrainteNul;
   /* Libelle de ActiverContrainteNul. */
TypUpsVmUnicode *AjouterALaFin;
   /* Libelle de AjouterALaFin. */
TypUpsVmUnicode *AjouterAuDebut;
   /* Libelle de AjouterAuDebut. */
TypUpsVmUnicode *Appel;
   /* Libelle de Appel. */
TypUpsVmUnicode *ArbreBinaire;
   /* Libelle de ArbreBinaire. */
TypUpsVmUnicode *ArreterProgramme;
   /* Libelle de ArreterProgramme. */
TypUpsVmUnicode *Binaire;
   /* Libelle de Binaire. */
TypUpsVmUnicode *Booleen;
   /* Libelle de Booleen. */
TypUpsVmUnicode *Caractere;
   /* Libelle de Caractere. */
TypUpsVmUnicode *ChangerEtat;
   /* Libelle de ChangerEtat. */
TypUpsVmUnicode *Cloner;
   /* Libelle de Cloner. */
TypUpsVmUnicode *Convertir;
   /* Libelle de Convertir. */
TypUpsVmUnicode *ComparaisonObjet;
   /* Libelle de ComparaisonObjet. */
TypUpsVmUnicode *CreeDansLEntrepot;
   /* Libelle de CreeDansLEntrepot. */
TypUpsVmUnicode *CreeParLeProcessus;
   /* Libelle de CreeParLeProcessus. */
TypUpsVmUnicode *CreeParLeServeur;
   /* Libelle de CreeParLeServeur. */
TypUpsVmUnicode *Date;
   /* Libelle de Date. */
TypUpsVmUnicode *DebuterExportation;
   /* Libelle de DebuterExportation. */
TypUpsVmUnicode *DebuterImportation;
   /* Libelle de DebuterImportation. */
TypUpsVmUnicode *EcrirePropriete;
   /* Libelle de EcrirePropriete. */
TypUpsVmUnicode *Entier;
   /* Libelle de Entier. */
TypUpsVmUnicode *Entrepot;
   /* Libelle de Entrepot. */
TypUpsVmUnicode *Enumere;
   /* Libelle de Enumere. */
TypUpsVmUnicode *EnumererMethodes;
   /* Libelle de EnumererMethodes. */
TypUpsVmUnicode *EnumererProprietes;
   /* Libelle de EnumererProprietes. */
TypUpsVmUnicode *Exception;
   /* Libelle de Exception. */
TypUpsVmUnicode *Exporter;
   /* Libelle de Exporter. */
TypUpsVmUnicode *IAlgebreCommutative;
   /* Libelle de IAlgebreCommutative. */
TypUpsVmUnicode *ICollection;
   /* Libelle de ICollection. */
TypUpsVmUnicode *ICorpsCommutatif;
   /* Libelle de ICorpsCommutatif. */
TypUpsVmUnicode *IEspaceMetre;
   /* Libelle de IEspaceMetre. */
TypUpsVmUnicode *IIterateur;
   /* Libelle de IIterateur. */
TypUpsVmUnicode *Importer;
   /* Libelle de Importer. */
TypUpsVmUnicode *IncrementerDecrementerPropriete;
   /* Libelle de IncrementerDecrementerPropriete. */
TypUpsVmUnicode *Identique;
   /* Libelle de Identique. */
TypUpsVmUnicode *LirePropriete;
   /* Libelle de LirePropriete. */
TypUpsVmUnicode *Liste;
   /* Libelle de Liste. */
TypUpsVmUnicode *Module;
   /* Libelle de Module. */
TypUpsVmUnicode *NouvelObjet;
   /* Libelle de NouvelObjet. */
TypUpsVmUnicode *Nul;
   /* Libelle de Nul. */
TypUpsVmUnicode *Objet;
   /* Libelle de Objet. */
TypUpsVmUnicode *Octet;
   /* Libelle de Octet. */
TypUpsVmUnicode *Photographier;
   /* Libelle de Photographier. */
TypUpsVmUnicode *ProfondeurClonage;
   /* Libelle de ProfondeurClonage. */
TypUpsVmUnicode *Reel;
   /* Libelle de Reel. */
TypUpsVmUnicode *Reference;
   /* Libelle de Reference. */
TypUpsVmUnicode *Remplacer;
   /* Libelle de Remplacer. */
TypUpsVmUnicode *RemplacerTous;
   /* Libelle de RemplacerTous. */
TypUpsVmUnicode *Retailler;
   /* Libelle de Retailler. */
TypUpsVmUnicode *Supprimer;
   /* Libelle de Supprimer. */
TypUpsVmUnicode *SupprimerPropriete;
   /* Libelle de SupprimerPropriete. */
TypUpsVmUnicode *SupprimerTous;
   /* Libelle de SupprimerTous. */
TypUpsVmUnicode *SynchroniserEntrepotsEtJournal;
   /* Libelle de SynchroniserEntrepotsEtJournal. */
TypUpsVmUnicode *Tableau;
   /* Libelle de Tableau. */
TypUpsVmUnicode *Transaction;
   /* Libelle de Transaction. */
TypUpsVmUnicode *Type;
   /* Libelle de Type. */
} *TypUpsKrnDonnees;

/****************************************************************/
typedef struct typprmupskrn_1_1
/* Objet : Parametre de ActiverMiseAuPoint(B:Nul Ou Booleen)    */
/****************************************************************/
{
TypUpsVmUnsignedChar UpsVar1;
   /* B : Booleen. */
} TypPrmUpsKrn_1_1;

/****************************************************************/
typedef struct typprmupskrn_2_1
/* Objet : Parametre de ActiverContrainteNul(A:                 */
/* ActiviteContrainte)                                          */
/****************************************************************/
{
TypUpsVmUnsignedChar UpsVar1;
   /* A:ActiviteContrainte. */
} TypPrmUpsKrn_2_1;

/****************************************************************/
typedef struct typprmupskrn_3_1
/* Objet : Parametre de ArreterProgramme(CodeRetour:Entier)     */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* CodeRetour : Entier. */
} TypPrmUpsKrn_3_1;

/****************************************************************/
typedef struct typprmupskrn_3_2
/* Objet : Parametre de ArreterProgramme(NumeroDuProgramme:     */
/* Entier, Forcer:Booleen)                                      */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* NumeroDuProgramme : Entier. */
TypUpsVmUnsignedChar UpsVar2;
   /* Forcer : Booleen. */
} TypPrmUpsKrn_3_2;

/****************************************************************/
typedef struct typprmupskrn_4_1
/* Objet : Parametre de DebuterExportation(Ecrire:Procedure(B:  */
/* Binaire))                                                    */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Ecrire:Procedure(B:Binaire). */
} TypPrmUpsKrn_4_1;

/****************************************************************/
typedef struct typprmupskrn_5_1
/* Objet : Parametre de ExporterEnumere(E:Enumere)              */
/****************************************************************/
{
TypUpsVmUnsignedShort UpsVar1;
   /* E:Enumere. */
} TypPrmUpsKrn_5_1;

/****************************************************************/
typedef struct typprmupskrn_6_1
/* Objet : Parametre de ExporterEntier(E:Entier)                */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* E:Entier. */
} TypPrmUpsKrn_6_1;

/****************************************************************/
typedef struct typprmupskrn_7_1
/* Objet : Parametre de ExporterReel(R:Reel)                    */
/****************************************************************/
{
TypUpsVmDouble UpsVar1;
   /* R:Reel. */
} TypPrmUpsKrn_7_1;

/****************************************************************/
typedef struct typprmupskrn_9_1
/* Objet : Parametre de DebuterImportation(Lire:Fonction(       */
/* TaillePaquet:Entier) Retourner Binaire, P:Nul Ou Entrepot=  */
/* Nul)                                                         */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Lire:Fonction(TaillePaquet:Entier) Retourner Binaire. */
TypUpsVmAdresse UpsVar2;
   /* P:Nul Ou Entrepot=Nul. */
} TypPrmUpsKrn_9_1;

/****************************************************************/
typedef struct typprmupskrn_15_1
/* Objet : Parametre de Photographier(Activite:Booleen, Portee: */
/* PorteePhotographie)                                          */
/****************************************************************/
{
TypUpsVmUnsignedChar UpsVar1;
   /* Activite:Booleen. */
TypUpsVmUnsignedChar UpsVar2;
   /* Portee:PorteePhotographie. */
} TypPrmUpsKrn_15_1;

/****************************************************************/
typedef struct typprmupskrn_16_1
/* Objet : Parametre de IlExistePhotographie(Portee:            */
/* PorteePhotographie)                                          */
/****************************************************************/
{
TypUpsVmUnsignedChar UpsVar1;
   /* Portee:PorteePhotographie. */
} TypPrmUpsKrn_16_1;

/**********************************************************************************/
/* Objet : Definition des appels standardises pour la composition des operateurs. */
/**********************************************************************************/
typedef  TypUpsVmAdresse *(*TypUpsKrnMethodeAComposer)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet,
   TypUpsVmPointeurDonnees UpsPrm);
typedef TypUpsVmAdresse *(*TypUpsKrnAppliquerMethodeAComposer)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmPointeurDonnees UpsPrm);
typedef TypUpsVmAdresse UpsVmAPI *(*TypUpsKrnAppliquerMethodeAIncrementer)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmAdresse *UpsObjet, TypUpsVmPointeurDonnees UpsPrmP);

/***************************************************************************/
/* Objet : Definition des appels standardises pour les variables globales. */
/***************************************************************************/
typedef TypUpsVmUnsignedChar UpsVmAPI (*TypUpsKrnGlobalVariableEnumereCourtLecture)(TypUpsVmSession *Session);
typedef TypUpsVmVoid UpsVmAPI (*TypUpsKrnVariableEnumereCourtEcriture)(TypUpsVmSession *Session, TypUpsVmUnsignedChar UpsPrm);
typedef TypUpsVmUnsignedShort UpsVmAPI (*TypUpsKrnGlobalVariableEnumereLongLecture)(TypUpsVmSession *Session);
typedef TypUpsVmVoid UpsVmAPI (*TypUpsKrnGlobalVariableEnumereLongEcriture)(TypUpsVmSession *Session, TypUpsVmUnsignedShort UpsPrm);
typedef TypUpsVmLong UpsVmAPI (*TypUpsKrnGlobalVariableEntierLecture)(TypUpsVmSession *Session);
typedef TypUpsVmVoid UpsVmAPI (*TypUpsKrnGlobalVariableEntierEcriture)(TypUpsVmSession *Session, TypUpsVmLong UpsPrm, enum EnuUpsVmOperateur Operateur);
typedef TypUpsVmLong UpsVmAPI (*TypUpsKrnGlobalVariableEntierIncrementationDecrementation)(TypUpsVmSession *Session, TypUpsVmChar Incrementer, TypUpsVmChar Prefixe);
typedef  TypUpsVmDouble UpsVmAPI (*TypUpsKrnGlobalVariableReelLecture)(TypUpsVmSession *Session);
typedef  TypUpsVmVoid UpsVmAPI (*TypUpsKrnGlobalVariableReelEcriture)(TypUpsVmSession *Session, TypUpsVmDouble UpsPrm, enum EnuUpsVmOperateur Operateur);
typedef TypUpsVmDouble UpsVmAPI (*TypUpsKrnGlobalVariableReelIncrementationDecrementation)(TypUpsVmSession *Session, TypUpsVmChar Incrementer, TypUpsVmChar Prefixe);
typedef TypUpsVmAdresse UpsVmAPI *(*TypUpsKrnGlobalVariableObjetLecture)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat);
typedef TypUpsVmVoid UpsVmAPI (*TypUpsKrnGlobalVariableObjetEcriture)(TypUpsVmSession *Session, TypUpsVmAdresse *Parametres);

/*****************************************************************************/
/* Objet : Definition des appels standardises pour les variables virtuelles. */
/*****************************************************************************/
typedef TypUpsVmUnsignedChar UpsVmAPI (*TypUpsKrnVirtuelVariableEnumereCourtLecture)(TypUpsVmSession *Session);
typedef TypUpsVmVoid UpsVmAPI (*TypUpsKrnVirtuelVariableEnumereCourtEcriture)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees UpsPrm);
typedef TypUpsVmUnsignedShort UpsVmAPI (*TypUpsKrnVirtuelVariableEnumereLongLecture)(TypUpsVmSession *Session);
typedef TypUpsVmVoid UpsVmAPI (*TypUpsKrnVirtuelVariableEnumereLongEcriture)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees UpsPrm);
typedef TypUpsVmLong UpsVmAPI (*TypUpsKrnVirtuelVariableEntierLecture)(TypUpsVmSession *Session);
typedef TypUpsVmVoid UpsVmAPI (*TypUpsKrnVirtuelVariableEntierEcriture)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees UpsPrm);
typedef  TypUpsVmDouble UpsVmAPI (*TypUpsKrnVirtuelVariableReelLecture)(TypUpsVmSession *Session);
typedef  TypUpsVmVoid UpsVmAPI (*TypUpsKrnVirtuelVariableReelEcriture)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees UpsPrm);
typedef TypUpsVmAdresse UpsVmAPI *(*TypUpsKrnVirtuelVariableObjetLecture)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat);
typedef TypUpsVmVoid UpsVmAPI (*TypUpsKrnVirtuelVariableObjetEcriture)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Parametres);

/************************************************************************/
/* Objet : Definition des appels standardises pour les champs virtuels. */
/************************************************************************/
typedef TypUpsVmUnsignedChar UpsVmAPI (*TypUpsKrnVirtuelChampEnumereCourtLecture)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
typedef TypUpsVmVoid UpsVmAPI (*TypUpsKrnVirtuelChampEnumereCourtEcriture)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmPointeurDonnees UpsPrm);
typedef TypUpsVmUnsignedShort UpsVmAPI (*TypUpsKrnVirtuelChampEnumereLongLecture)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
typedef TypUpsVmVoid UpsVmAPI (*TypUpsKrnVirtuelChampEnumereLongEcriture)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmPointeurDonnees UpsPrm);
typedef TypUpsVmLong UpsVmAPI (*TypUpsKrnVirtuelChampEntierLecture)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
typedef TypUpsVmVoid UpsVmAPI (*TypUpsKrnVirtuelChampEntierEcriture)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmPointeurDonnees UpsPrm);
typedef  TypUpsVmDouble UpsVmAPI (*TypUpsKrnVirtuelChampReelLecture)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
typedef  TypUpsVmVoid UpsVmAPI (*TypUpsKrnVirtuelChampReelEcriture)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmPointeurDonnees UpsPrm);
typedef TypUpsVmAdresse UpsVmAPI *(*TypUpsKrnVirtuelChampObjetLecture)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet);
typedef TypUpsVmVoid UpsVmAPI (*TypUpsKrnVirtuelChampObjetEcriture)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmPointeurDonnees Parametres);

typedef TypUpsVmVoid UpsVmAPI (*TypUpsKrnInterrompreTache)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Handle);

/****************************************************************/
/* Methodes des appels en technologie tierce.					    */
/****************************************************************/
typedef TypUpsVmUnsignedChar UpsVmAPI (*TypUpsKrnCoAppel)(TypUpsVmSession *Session, 
   TypUpsVmShort NumeroParametre, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm,
   TypUpsVmPointeurDonnees DescriptionAppel);
typedef TypUpsVmVoid UpsVmAPI (*TypUpsKrnDestructeurAppel)(TypUpsVmSession *Session, UpsTypUpsKrn_16 *ObjetAppel);
typedef TypUpsVmShort UpsVmAPI (*TypUpsKrnMethodeComparerAppels)(TypUpsVmSession *Session, UpsTypUpsKrn_16 *ObjetAppel, UpsTypUpsKrn_16 *ObjetAppelA);
typedef TypUpsVmVoid UpsVmAPI (*TypUpsKrnMethodeClonerAppel)(TypUpsVmSession *Session, UpsTypUpsKrn_16 *ObjetAppel, UpsTypUpsKrn_16 *RObjetAppel, TypPrmUpsVmCloner *UpsPrm);
typedef TypUpsVmVoid UpsVmAPI (*TypUpsKrnMethodeExporterAppel)(TypUpsVmSession *Session, UpsTypUpsKrn_16 *ObjetAppel);
typedef TypUpsVmVoid UpsVmAPI (*TypUpsKrnMethodeImporterAppel)(TypUpsVmSession *Session, UpsTypUpsKrn_16 *ObjetAppel, TypPrmUpsVmImporter *UpsPrm);
typedef TypUpsVmVoid UpsVmAPI (*TypUpsKrnExecuterProcedureSansParametre)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees DescriptionAppelTiers);
typedef TypUpsVmVoid UpsVmAPI (*TypUpsKrnExecuterProcedureAvecParametre)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Parametres, TypUpsVmPointeurDonnees DescriptionAppelTiers);
typedef TypUpsVmUnsignedChar UpsVmAPI (*TypUpsKrnExecuterFonctionEnumereCourtSansParametre)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees DescriptionAppelTiers);
typedef TypUpsVmUnsignedChar UpsVmAPI (*TypUpsKrnExecuterFonctionEnumereCourtAvecParametre)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Parametres, TypUpsVmPointeurDonnees DescriptionAppelTiers);
typedef TypUpsVmUnsignedShort UpsVmAPI (*TypUpsKrnExecuterFonctionEnumereLongSansParametre)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees DescriptionAppelTiers);
typedef TypUpsVmUnsignedShort UpsVmAPI (*TypUpsKrnExecuterFonctionEnumereLongAvecParametre)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Parametres, TypUpsVmPointeurDonnees DescriptionAppelTiers);
typedef TypUpsVmLong UpsVmAPI (*TypUpsKrnExecuterFonctionEntierSansParametre)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees DescriptionAppelTiers);
typedef TypUpsVmLong UpsVmAPI (*TypUpsKrnExecuterFonctionEntierAvecParametre)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Parametres, TypUpsVmPointeurDonnees DescriptionAppelTiers);
typedef TypUpsVmDouble UpsVmAPI (*TypUpsKrnExecuterFonctionReelSansParametre)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees DescriptionAppelTiers);
typedef TypUpsVmDouble UpsVmAPI (*TypUpsKrnExecuterFonctionReelAvecParametre)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Parametres, TypUpsVmPointeurDonnees DescriptionAppelTiers);
typedef TypUpsVmAdresse UpsVmAPI *(*TypUpsKrnExecuterFonctionObjetSansParametre)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmPointeurDonnees DescriptionAppelTiers);
typedef TypUpsVmAdresse UpsVmAPI *(*TypUpsKrnExecuterFonctionObjetAvecParametre)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmPointeurDonnees Parametres, TypUpsVmPointeurDonnees DescriptionAppelTiers);

/****************************************************************/
typedef struct typupskrngestionappeltiers
/* Objet : Gestion des appels tiers.                            */
/****************************************************************/
{
TypUpsKrnCoAppel CoAppel;
   /* Description d'appel dans une technologie tierce. */
TypUpsKrnDestructeurAppel Destructeur;
   /* Destructeur d'un appel tiers. */
TypUpsKrnMethodeComparerAppels MethodeComparerAppels;
   /* Comparaison de deux appels. */
TypUpsKrnMethodeClonerAppel MethodeCloner;
   /* Clonage d'un appel tiers. */
TypUpsKrnMethodeExporterAppel MethodeExporter;
   /* Exportation d'un appel tiers. */
TypUpsKrnMethodeImporterAppel MethodeImporter;
   /* Importation d'un appel tiers. */
TypUpsKrnExecuterProcedureSansParametre ExecuterProcedureSansParametre;
   /* Execution d'une procedure sans parametre. */
TypUpsKrnExecuterProcedureAvecParametre ExecuterProcedureAvecParametre;
   /* Execution d'une procedure avec parametres. */
TypUpsKrnExecuterFonctionEnumereCourtSansParametre ExecuterFonctionEnumereCourtSansParametre;
   /* Execution d'une fonction retournant un enumere court sans parametre. */
TypUpsKrnExecuterFonctionEnumereCourtAvecParametre ExecuterFonctionEnumereCourtAvecParametre;
   /* Execution d'une fonction retournant un enumere court avec parametres. */
TypUpsKrnExecuterFonctionEnumereLongSansParametre ExecuterFonctionEnumereLongSansParametre;
   /* Execution d'une fonction retournant un enumere long sans parametre. */
TypUpsKrnExecuterFonctionEnumereLongAvecParametre ExecuterFonctionEnumereLongAvecParametre;
   /* Execution d'une fonction retournant un enumere long avec parametres. */
TypUpsKrnExecuterFonctionEntierSansParametre ExecuterFonctionEntierSansParametre;
   /* Execution d'une fonction retournant un entier sans parametre. */
TypUpsKrnExecuterFonctionEntierAvecParametre ExecuterFonctionEntierAvecParametre;
   /* Execution d'une fonction retournant un entier avec parametres. */
TypUpsKrnExecuterFonctionReelSansParametre ExecuterFonctionReelSansParametre;
   /* Execution d'une fonction retournant un reel sans parametre. */
TypUpsKrnExecuterFonctionReelAvecParametre ExecuterFonctionReelAvecParametre;
   /* Execution d'une fonction retournant un reel avec parametres. */
TypUpsKrnExecuterFonctionObjetSansParametre ExecuterFonctionObjetSansParametre;
   /* Execution d'une fonction retournant un objet sans parametre. */
TypUpsKrnExecuterFonctionObjetAvecParametre ExecuterFonctionObjetAvecParametre;
   /* Execution d'une fonction retournant un objet avec parametres. */
} TypUpsKrnGestionAppelTiers;

/****************************************************************/
typedef struct upstypprmcomparaison
/* Objet : Parametre de la fonction de comparaison.             */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Premier parametre. */
TypUpsVmAdresse UpsVar2;
   /* Premier parametre. */
} UpsTypPrmComparaison;

/****************************************************************/
typedef struct typupskrntraitements_1_1_0
/* Objet: Interface des traitements de Ups Krn.                 */
/****************************************************************/
{
struct typupsvmentetemethodesmodule EnteteMethodesModule;
   /* Methodes generiques au module. */ 

/*--------------------------------------------------------------*/
/* Procedures et fonctions.                                     */
/*--------------------------------------------------------------*/
TypUpsVmLong UpsVmAPI (*CalculerIndexAppel)(TypUpsVmPointeurDonnees InterfaceAppel, TypUpsVmPointeurDonnees AppelCourant);
   /* Objet : Calcule l'index de l'appel. */
TypUpsVmVoid UpsVmAPI (*Trt_1_1)(TypUpsVmSession *Session, TypPrmUpsKrn_1_1 *UpsPrm);
   /* Objet : ActiverMiseAuPoint. */
TypUpsVmVoid UpsVmAPI (*Trt_2_1)(TypUpsVmSession *Session, TypPrmUpsKrn_2_1 *UpsPrm);
   /* Objet : ActiverContrainteNul. */
TypUpsVmVoid UpsVmAPI (*Trt_3_1)(TypUpsVmSession *Session, TypPrmUpsKrn_3_1 *UpsPrm);
   /* Objet : ArreterProgramme(CodeRetour:Entier). */
TypUpsVmVoid UpsVmAPI (*Trt_3_2)(TypUpsVmSession *Session, TypPrmUpsKrn_3_2 *UpsPrm);
   /* Objet : ArreterProgramme(NumeroDuProgramme:Entier, Forcer:Booleen). */
TypUpsVmVoid UpsVmAPI (*Trt_4_1)(TypUpsVmSession *Session, TypPrmUpsKrn_4_1 *UpsPrm);
   /* Objet : DebuterExportation(Ecrire:Procedure(B:Binaire)). */
TypUpsVmVoid UpsVmAPI (*Trt_5_1)(TypUpsVmSession *Session, TypPrmUpsKrn_5_1 *UpsPrm);
   /* Objet : ExporterEnumere(E:Enumere). */
TypUpsVmVoid UpsVmAPI (*Trt_6_1)(TypUpsVmSession *Session, TypPrmUpsKrn_6_1 *UpsPrm);
   /* Objet : ExporterEntier(E:Entier). */
TypUpsVmVoid UpsVmAPI (*Trt_7_1)(TypUpsVmSession *Session, TypPrmUpsKrn_7_1 *UpsPrm);
   /* Objet : ExporterReel(R:Reel). */
TypUpsVmVoid UpsVmAPI (*Trt_8_1)(TypUpsVmSession *Session);
   /* Objet : TerminerExportation(). */
TypUpsVmVoid UpsVmAPI (*Trt_9_1)(TypUpsVmSession *Session, TypPrmUpsKrn_9_1 *UpsPrm);
   /* Objet : DebuterImportation(Lire:Fonction(TaillePaquet:Entier) Retourner Binaire, P:Nul Ou Entrepot=Nul). */
TypUpsVmUnsignedShort UpsVmAPI (*Trt_10_1)(TypUpsVmSession *Session);
   /* Objet : ImporterEnumere() Retourner Enumere. */
TypUpsVmLong UpsVmAPI (*Trt_11_1)(TypUpsVmSession *Session);
   /* Objet : ImporterEntier() Retourner Entier. */
TypUpsVmDouble UpsVmAPI (*Trt_12_1)(TypUpsVmSession *Session);
   /* Objet : ImporterReel() Retourner Reel. */
TypUpsVmAdresse UpsVmAPI *(*Trt_13_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat);
   /* Objet : ImporterObjet() Retourner Nul Ou Objet. */
TypUpsVmVoid UpsVmAPI (*Trt_14_1)(TypUpsVmSession *Session);
   /* Objet : TerminerImportation(). */
TypUpsVmVoid UpsVmAPI (*Trt_15_1)(TypUpsVmSession *Session, TypPrmUpsKrn_15_1 *UpsPrm);
   /* Objet : Photographier(Activite:Booleen, Portee:PorteePhotographie). */
TypUpsVmUnsignedChar  UpsVmAPI (*Trt_16_1)(TypUpsVmSession *Session, TypPrmUpsKrn_16_1 *UpsPrm);
   /* Objet : IlExistePhotographie(Portee:PorteePhotographie). */
TypUpsVmVoid UpsVmAPI (*Trt_17_1)(TypUpsVmSession *Session);
   /* Procedure SynchroniserEntrepotsEtJournal(); */

TypUpsVmCoAppel CoTrt_1_1;
   /* Objet : ActiverMiseAuPoint. */
TypUpsVmCoAppel CoTrt_2_1;
   /* Objet : ActiverContrainteNul. */
TypUpsVmCoAppel CoTrt_3_1;
   /* Objet : ArreterProgramme(CodeRetour:Entier). */
TypUpsVmCoAppel CoTrt_3_2;
   /* Objet : ArreterProgramme(NumeroDuProgramme:Entier, Forcer:Booleen). */
TypUpsVmCoAppel CoTrt_4_1;
   /* Objet : DebuterExportation(Ecrire:Procedure(B:Binaire)). */
TypUpsVmCoAppel CoTrt_5_1;
   /* Objet : ExporterEnumere(E:Enumere). */
TypUpsVmCoAppel CoTrt_6_1;
   /* Objet : ExporterEntier(E:Entier). */
TypUpsVmCoAppel CoTrt_7_1;
   /* Objet : ExporterReel(R:Reel). */
TypUpsVmCoAppel CoTrt_8_1;
   /* Objet : TerminerExportation(). */
TypUpsVmCoAppel CoTrt_9_1;
   /* Objet : DebuterImportation(Lire:Fonction(TaillePaquet:Entier) Retourner Binaire, P:Nul Ou Entrepot=Nul). */
TypUpsVmCoAppel CoTrt_10_1;
   /* Objet : ImporterEnumere() Retourner Enumere. */
TypUpsVmCoAppel CoTrt_11_1;
   /* Objet : ImporterEntier() Retourner Entier. */
TypUpsVmCoAppel CoTrt_12_1;
   /* Objet : ImporterReel() Retourner Reel. */
TypUpsVmCoAppel CoTrt_13_1;
   /* Objet : ImporterObjet() Retourner Nul Ou Objet. */
TypUpsVmCoAppel CoTrt_14_1;
   /* Objet : TerminerImportation(). */
TypUpsVmCoAppel CoTrt_15_1;
   /* Objet : Photographier(Activite:Booleen, Portee:PorteePhotographie). */
TypUpsVmCoAppel CoTrt_16_1;
   /* Objet : IlExistePhotographie(Portee:PorteePhotographie). */
TypUpsVmCoAppel CoTrt_17_1;
   /* Procedure SynchroniserEntrepotsEtJournal(); */

/*--------------------------------------------------------------*/
/* Tables des methodes.                                         */
/*--------------------------------------------------------------*/
UpsTrtTypUpsKrn_1 *UpsTrt1;
   /* Methodes de Binaire. */ 
UpsTrtTypUpsKrn_2 *UpsTrt2;
   /* Methodes de Caractere. */ 
UpsTrtTypUpsKrn_21 *UpsTrt2_1;
   /* Methodes de Caractere.EspaceMetre. */ 
UpsTrtTypUpsKrn_3 *UpsTrt3;
   /* Methodes de Date. */ 
UpsTrtTypUpsKrn_21 *UpsTrt3_1;
   /* Methodes de Date.EspaceMetre. */ 
UpsTrtTypUpsKrn_4 *UpsTrt4;
   /* Methodes de Entier. */ 
UpsTrtTypUpsKrn_22 *UpsTrt4_1;
   /* Methodes de Entier.AlgebreCommutative. */ 
UpsTrtTypUpsKrn_21 *UpsTrt4_2;
   /* Methodes de Entier.EspaceMetre. */ 
UpsTrtTypUpsKrn_5 *UpsTrt5;
   /* Methodes de Enumere. */ 
UpsTrtTypUpsKrn_21 *UpsTrt5_1;
   /* Methodes de Enumere.EspaceMetre. */ 
UpsTrtTypUpsKrn_6 *UpsTrt6;
   /* Methodes de Exception. */ 
UpsTrtTypUpsKrn_7 *UpsTrt7;
   /* Methodes de Objet. */ 
UpsTrtTypUpsKrn_8 *UpsTrt8;
   /* Methodes de Reel. */ 
UpsTrtTypUpsKrn_23 *UpsTrt8_1;
   /* Methodes de Reel.CorpsCommutatif. */ 
UpsTrtTypUpsKrn_22 *UpsTrt8_1_1;
   /* Methodes de Reel.CorpsCommutatif.AlgebreCommutative. */ 
UpsTrtTypUpsKrn_21 *UpsTrt8_2;
   /* Methodes de Reel.EspaceMetre. */ 
UpsTrtTypUpsKrn_9 *UpsTrt9;
   /* Methodes de Type. */ 
UpsTrtTypUpsKrn_10 *UpsTrt10;
   /* Methodes de Liste */
UpsTrtTypUpsKrn_20 *UpsTrt10_1;
   /* Methodes de Liste.Collection */
UpsTrtTypUpsKrn_19 *UpsTrt10_1_1;
   /* Methodes de Liste.Collection.Iterateur */
UpsTrtTypUpsKrn_11 *UpsTrt11;
   /* Methodes de Reference. */
UpsTrtTypUpsKrn_12 *UpsTrt12;
   /* Methodes de Tableau. */
UpsTrtTypUpsKrn_20 *UpsTrt12_1;
   /* Methodes de Tableau.Collection */
UpsTrtTypUpsKrn_19 *UpsTrt12_1_1;
   /* Methodes de Tableau.Collection.Iterateur */
UpsTrtTypUpsKrn_13 *UpsTrt13;
   /* Methodes de ArbreBinaire. */ 
UpsTrtTypUpsKrn_20 *UpsTrt13_1;
   /* Methodes de ArbreBinaire.Collection */
UpsTrtTypUpsKrn_19 *UpsTrt13_1_1;
   /* Methodes de ArbreBinaire.Collection.Iterateur */
UpsTrtTypUpsKrn_14 *UpsTrt14;
   /* Methodes de Entrepot. */ 
UpsTrtTypUpsKrn_15 *UpsTrt15;
   /* Methodes de Module. */ 
UpsTrtTypUpsKrn_16 *UpsTrt16;
   /* Methodes de Appel. */ 
UpsTrtTypUpsKrn_17 *UpsTrt17;
   /* Methodes de Transaction. */ 
UpsTrtTypUpsKrn_18 *UpsTrt18;
   /* Methodes de Octet. */ 
UpsTrtTypUpsKrn_22 *UpsTrt18_1;
   /* Methodes de Octet.AlgebreCommutative. */ 
UpsTrtTypUpsKrn_21 *UpsTrt18_2;
   /* Methodes de Octet.EspaceMetre. */ 
UpsTrtTypUpsKrn_19 *UpsTrt19;
   /* Methodes de Iterateur. */ 
UpsTrtTypUpsKrn_20 *UpsTrt20;
   /* Methodes de Collection. */ 
UpsTrtTypUpsKrn_19 *UpsTrt20_1;
   /* Methodes de Collection.Iterateur. */ 
UpsTrtTypUpsKrn_21 *UpsTrt21;
   /* Methodes de EspaceMetre. */ 
UpsTrtTypUpsKrn_22 *UpsTrt22;
   /* Methodes de AlgebreCommutative. */ 
UpsTrtTypUpsKrn_23 *UpsTrt23;
   /* Methodes de CorpsCommutatif. */ 
UpsTrtTypUpsKrn_22 *UpsTrt23_1;
   /* Methodes de AlgebreCommutatif. */ 

/*--------------------------------------------------------------*/
/* Enumeres.			              				                   */
/*--------------------------------------------------------------*/
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_1_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_1_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* Booleen. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_2_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_2_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* ComparaisonObjet. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_3_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_3_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* ProfondeurClonage. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_4_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_4_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* AccesEntrepot. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_5_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* SorteParametre. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_6_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* PorteePhotographie. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_7_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* ActiviteContrainte. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_8_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_8_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* ExceptionSurTransaction. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_9_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_9_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* EtatEntrepot. */

/*--------------------------------------------------------------*/
/* Entrepots.          								                   */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*UpsEntrepot1_get)(TypUpsVmSession *Session);
   /* Entrepot Systeme. */
TypUpsVmUnsignedShort UpsVmAPI (*UpsNumeroEntrepot1_get)(TypUpsVmSession *Session);
   /* Numero de l'entrepot Systeme. */

/*--------------------------------------------------------------*/
/* Types et interfaces.                                         */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*UpsType1_get)(TypUpsVmSession *Session);
   /* Type Binaire. */
TypUpsVmLong UpsVmAPI (*UpsIndex1_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Binaire. */
TypUpsVmAdresse UpsVmAPI *(*UpsType2_get)(TypUpsVmSession *Session);
   /* Type Caractere. */
TypUpsVmLong UpsVmAPI (*UpsIndex2_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Caractere. */
TypUpsVmAdresse UpsVmAPI *(*UpsType3_get)(TypUpsVmSession *Session);
   /* Type Date. */
TypUpsVmLong UpsVmAPI (*UpsIndex3_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Date. */
TypUpsVmAdresse UpsVmAPI *(*UpsType4_get)(TypUpsVmSession *Session);
   /* Type Entier. */
TypUpsVmLong UpsVmAPI (*UpsIndex4_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Entier. */
TypUpsVmAdresse UpsVmAPI *(*UpsType5_get)(TypUpsVmSession *Session);
   /* Type Enumere. */
TypUpsVmLong UpsVmAPI (*UpsIndex5_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Enumere. */
TypUpsVmAdresse UpsVmAPI *(*UpsType6_get)(TypUpsVmSession *Session);
   /* Type Exception. */
TypUpsVmLong UpsVmAPI (*UpsIndex6_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Exception. */
TypUpsVmAdresse UpsVmAPI *(*UpsType7_get)(TypUpsVmSession *Session);
   /* Type Objet. */
TypUpsVmLong UpsVmAPI (*UpsIndex7_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Objet. */
TypUpsVmAdresse UpsVmAPI *(*UpsType8_get)(TypUpsVmSession *Session);
   /* Type Reel. */
TypUpsVmLong UpsVmAPI (*UpsIndex8_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Reel. */
TypUpsVmAdresse UpsVmAPI *(*UpsType9_get)(TypUpsVmSession *Session);
   /* Type Type. */
TypUpsVmLong UpsVmAPI (*UpsIndex9_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Type. */
TypUpsVmAdresse UpsVmAPI *(*UpsType10_get)(TypUpsVmSession *Session);
   /* Type Liste. */
TypUpsVmLong UpsVmAPI (*UpsIndex10_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Liste. */
TypUpsVmAdresse UpsVmAPI *(*UpsType11_get)(TypUpsVmSession *Session);
   /* Type Reference. */
TypUpsVmLong UpsVmAPI (*UpsIndex11_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Reference. */
TypUpsVmAdresse UpsVmAPI *(*UpsType12_get)(TypUpsVmSession *Session);
   /* Type Tableau. */
TypUpsVmLong UpsVmAPI (*UpsIndex12_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Tableau. */
TypUpsVmAdresse UpsVmAPI *(*UpsType13_get)(TypUpsVmSession *Session);
   /* Type ArbreBinaire. */
TypUpsVmLong UpsVmAPI (*UpsIndex13_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type ArbreBinaire. */
TypUpsVmAdresse UpsVmAPI *(*UpsType14_get)(TypUpsVmSession *Session);
   /* Type Entrepot. */
TypUpsVmLong UpsVmAPI (*UpsIndex14_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Entrepot. */
TypUpsVmAdresse UpsVmAPI *(*UpsType15_get)(TypUpsVmSession *Session);
   /* Type Module. */
TypUpsVmLong UpsVmAPI (*UpsIndex15_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Module. */
TypUpsVmAdresse UpsVmAPI *(*UpsType16_get)(TypUpsVmSession *Session);
   /* Type Appel. */
TypUpsVmLong UpsVmAPI (*UpsIndex16_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Appel. */
TypUpsVmAdresse UpsVmAPI *(*UpsType17_get)(TypUpsVmSession *Session);
   /* Type Transaction. */
TypUpsVmLong UpsVmAPI (*UpsIndex17_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Transaction. */
TypUpsVmAdresse UpsVmAPI *(*UpsType18_get)(TypUpsVmSession *Session);
   /* Type Octet. */
TypUpsVmLong UpsVmAPI (*UpsIndex18_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Octet. */
TypUpsVmAdresse UpsVmAPI *(*UpsType19_get)(TypUpsVmSession *Session);
   /* Type Iterateur. */
TypUpsVmLong UpsVmAPI (*UpsIndex19_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Iterateur. */
TypUpsVmAdresse UpsVmAPI *(*UpsType20_get)(TypUpsVmSession *Session);
   /* Type Collection. */
TypUpsVmLong UpsVmAPI (*UpsIndex20_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type Collection. */
TypUpsVmAdresse UpsVmAPI *(*UpsType21_get)(TypUpsVmSession *Session);
   /* Type EspaceMetre. */
TypUpsVmLong UpsVmAPI (*UpsIndex21_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type EspaceMetre. */
TypUpsVmAdresse UpsVmAPI *(*UpsType22_get)(TypUpsVmSession *Session);
   /* Type AlgebreCommutative. */
TypUpsVmLong UpsVmAPI (*UpsIndex22_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type AlgebreCommutative. */
TypUpsVmAdresse UpsVmAPI *(*UpsType23_get)(TypUpsVmSession *Session);
   /* Type CorpsCommutatif. */
TypUpsVmLong UpsVmAPI (*UpsIndex23_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type CorpsCommutatif. */

/*--------------------------------------------------------------*/
/* Variables globales.                                          */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*UpsVar1_get)(TypUpsVmSession *Session);
   /* RepertoireTmp. */

/*--------------------------------------------------------------*/
/* Exceptions.                                                  */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*UpsException1_get)(TypUpsVmSession *Session);
   /* Exception PlusDeMemoire. */
TypUpsVmAdresse UpsVmAPI *(*UpsException2_get)(TypUpsVmSession *Session);
   /* Exception BufferTropGrand. */
TypUpsVmAdresse UpsVmAPI *(*UpsException3_get)(TypUpsVmSession *Session);
   /* Exception DivisionParZero. */
TypUpsVmAdresse UpsVmAPI *(*UpsException4_get)(TypUpsVmSession *Session);
   /* Exception PasDeConstructeurImplicite. */
TypUpsVmAdresse UpsVmAPI *(*UpsException5_get)(TypUpsVmSession *Session);
   /* Exception DateInvalide. */
TypUpsVmAdresse UpsVmAPI *(*UpsException6_get)(TypUpsVmSession *Session);
   /* Exception ConvertirImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException7_get)(TypUpsVmSession *Session);
   /* Exception TropDeBlocsVerrouilles. */
TypUpsVmAdresse UpsVmAPI *(*UpsException8_get)(TypUpsVmSession *Session);
   /* Exception FichierEchangeLecture. */
TypUpsVmAdresse UpsVmAPI *(*UpsException9_get)(TypUpsVmSession *Session);
   /* Exception FichierErreurEcriture. */
TypUpsVmAdresse UpsVmAPI *(*UpsException10_get)(TypUpsVmSession *Session);
   /* Exception PlusDeVerrou. */
TypUpsVmAdresse UpsVmAPI *(*UpsException11_get)(TypUpsVmSession *Session);
   /* Exception SessionInvalide. */
TypUpsVmAdresse UpsVmAPI *(*UpsException12_get)(TypUpsVmSession *Session);
   /* Exception VerrouInvalide. */
TypUpsVmAdresse UpsVmAPI *(*UpsException13_get)(TypUpsVmSession *Session);
   /* Exception AdresseInvalide. */
TypUpsVmAdresse UpsVmAPI *(*UpsException14_get)(TypUpsVmSession *Session);
   /* Exception EntrepotOuFichierEchangeInvalide. */
TypUpsVmAdresse UpsVmAPI *(*UpsException15_get)(TypUpsVmSession *Session);
   /* Exception AdresseExceptionInvalide. */
TypUpsVmAdresse UpsVmAPI *(*UpsException16_get)(TypUpsVmSession *Session);
   /* Exception EntrepotInconnu. */
TypUpsVmAdresse UpsVmAPI *(*UpsException17_get)(TypUpsVmSession *Session);
   /* Exception IterateurInvalide. */
TypUpsVmAdresse UpsVmAPI *(*UpsException18_get)(TypUpsVmSession *Session);
   /* Exception IterateurSuivantImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException19_get)(TypUpsVmSession *Session);
   /* Exception IterateurPrecedentImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException20_get)(TypUpsVmSession *Session);
   /* Exception CollectionIndexImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException21_get)(TypUpsVmSession *Session);
   /* Exception TableauTropGrand. */
TypUpsVmAdresse UpsVmAPI *(*UpsException22_get)(TypUpsVmSession *Session);
   /* Exception PasDOperateurImplicite. */
TypUpsVmAdresse UpsVmAPI *(*UpsException23_get)(TypUpsVmSession *Session);
   /* Exception ContrainteNonNulNonRespectee. */
TypUpsVmAdresse UpsVmAPI *(*UpsException24_get)(TypUpsVmSession *Session);
   /* Exception ContrainteSelonNonRespectee. */
TypUpsVmAdresse UpsVmAPI *(*UpsException25_get)(TypUpsVmSession *Session);
   /* Exception ContrainteTypeNonRespectee. */
TypUpsVmAdresse UpsVmAPI *(*UpsException26_get)(TypUpsVmSession *Session);
   /* Exception AdresseProtegee. */
TypUpsVmAdresse UpsVmAPI *(*UpsException27_get)(TypUpsVmSession *Session);
   /* Exception ArretProgramme. */
TypUpsVmAdresse UpsVmAPI *(*UpsException28_get)(TypUpsVmSession *Session);
   /* Exception TempsDeGardeDepasse. */
TypUpsVmAdresse UpsVmAPI *(*UpsException29_get)(TypUpsVmSession *Session);
   /* Exception ModificationImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException30_get)(TypUpsVmSession *Session);
   /* Exception BlocTropPetit. */
TypUpsVmAdresse UpsVmAPI *(*UpsException31_get)(TypUpsVmSession *Session);
   /* Exception ExceptionTraitementDistribue. */
TypUpsVmAdresse UpsVmAPI *(*UpsException32_get)(TypUpsVmSession *Session);
   /* Exception ObjetInconnu. */
TypUpsVmAdresse UpsVmAPI *(*UpsException33_get)(TypUpsVmSession *Session);
   /* Exception InsertionArbreImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException34_get)(TypUpsVmSession *Session);
   /* Exception ComparaisonArbreDifferente. */
TypUpsVmAdresse UpsVmAPI *(*UpsException35_get)(TypUpsVmSession *Session);
   /* Exception PlusDIterateur. */
TypUpsVmAdresse UpsVmAPI *(*UpsException36_get)(TypUpsVmSession *Session);
   /* Exception ExportationImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException37_get)(TypUpsVmSession *Session);
   /* Exception ImportationImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException38_get)(TypUpsVmSession *Session);
   /* Exception ClonageImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException39_get)(TypUpsVmSession *Session);
   /* Exception EnumerationImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException40_get)(TypUpsVmSession *Session);
   /* Exception AppelImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException41_get)(TypUpsVmSession *Session);
   /* Exception ModuleInconnu. */
TypUpsVmAdresse UpsVmAPI *(*UpsException42_get)(TypUpsVmSession *Session);
   /* Exception InterfaceNonImplementee. */
TypUpsVmAdresse UpsVmAPI *(*UpsException43_get)(TypUpsVmSession *Session);
   /* Exception ProprieteDynamiqueImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException44_get)(TypUpsVmSession *Session);
   /* Exception ProprieteInconnue. */
TypUpsVmAdresse UpsVmAPI *(*UpsException45_get)(TypUpsVmSession *Session);
   /* Exception ProprieteEnLectureSeule. */
TypUpsVmAdresse UpsVmAPI *(*UpsException46_get)(TypUpsVmSession *Session);
   /* Exception VariableEnLectureSeule. */
TypUpsVmAdresse UpsVmAPI *(*UpsException47_get)(TypUpsVmSession *Session);
   /* Exception AdaptateurDictionnaireNonTrouve. */
TypUpsVmAdresse UpsVmAPI *(*UpsException48_get)(TypUpsVmSession *Session);
   /* Exception AdaptateurUpsNetNonTrouve. */
TypUpsVmAdresse UpsVmAPI *(*UpsException49_get)(TypUpsVmSession *Session);
   /* Exception ExecutionDynamiqueImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException50_get)(TypUpsVmSession *Session);
   /* Exception ValidationImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException51_get)(TypUpsVmSession *Session);
   /* Exception TransactionImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException52_get)(TypUpsVmSession *Session);
   /* Exception PhotographieTropAncienne. */
TypUpsVmAdresse UpsVmAPI *(*UpsException53_get)(TypUpsVmSession *Session);
   /* Exception AppartenanceImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException54_get)(TypUpsVmSession *Session);
   /* Exception IndexProprieteImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException55_get)(TypUpsVmSession *Session);
   /* Exception ErreurInterne. */

/*--------------------------------------------------------------*/
/* Files d'attente.                                             */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Application Program Interfaces proprietaires.                */
/*--------------------------------------------------------------*/
TypUpsVmChar UpsVmAPI *(*CalculerBuffer)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseBinaireOuCaractere, 
   TypUpsVmUnsignedLong *NumeroVerrouBuffer, enum EnuUpsOmsVerrou TypeVerrou);
   /* Objet : Calcule l'adresse du buffer binaire ou caractere. */
TypUpsVmLong UpsVmAPI (*CalculerTailleBinaire)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Calcule la taille du buffer Binaire en octets. */
TypUpsVmLong UpsVmAPI (*CalculerTailleCaractere)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Calcule la taille du buffer Caractere en caractere. */
TypUpsVmAdresse UpsVmAPI *(*CreerObjetBinaire)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat,
   TypUpsVmChar *Chaine, TypUpsVmLong Taille);
   /* Objet : Creation d'un objet Binaire. */
TypUpsVmAdresse UpsVmAPI *(*CreerObjetCaractere)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat,
   TypUpsVmUnicode *Chaine, TypUpsVmLong Taille);
   /* Objet : Creation d'un objet Caractere. -1 pour prendre toute la chaine. */
TypUpsVmAdresse UpsVmAPI *(*CreerObjetDate)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmLong Jour, TypUpsVmLong Mois, TypUpsVmLong Annee, TypUpsVmLong Heures, TypUpsVmLong Minutes, TypUpsVmLong Secondes, TypUpsVmLong Milliemes);
   /* Objet : Cree une date a partir de ses valeurs de champs. */
TypUpsVmAdresse UpsVmAPI *(*CreerObjetDate2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat,
   TypUpsVmUnicode *Chaine);
   /* Objet : Creation d'un objet Date. */
TypUpsVmAdresse UpsVmAPI *(*CreerObjetEntier)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat,
   TypUpsVmLong Entier);
   /* Objet : Fabrique un Entier a partir de la valeur entiere. */
TypUpsVmAdresse UpsVmAPI *(*CreerObjetEnumere)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat,
   TypUpsVmUnsignedShort ValeurEnumere);
   /* Objet : Fabrique un Enumere a partir de la valeur entiere. */
TypUpsVmUnsignedShort UpsVmAPI (*ExtraireEtLibererEnumere)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Objet : Extrait et libere un enumere pour un test. */
TypUpsVmAdresse UpsVmAPI *(*CreerObjetException)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat,
   TypUpsVmUnicode *MotCle, TypUpsVmLong CodeErreur, TypUpsVmAdresse *ModuleAppartenance, TypUpsVmUnsignedChar EffetSurTransaction);
   /* Objet : Construit une exception. */
TypUpsVmAdresse UpsVmAPI *(*CreerObjetReel)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat,
   TypUpsVmDouble Reel);
   /* Objet : Fabrique un Reel a partir de la valeur reelle. */
TypUpsVmAdresse UpsVmAPI *(*CreerObjetReel2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat,
   TypUpsVmDouble Reel, enum EnuUpsKrnObjetReel Sorte);
   /* Objet : Fabrique un Reel a partir de la valeur reelle. */
TypUpsVmAdresse UpsVmAPI *(*CreerObjetListe)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat,
   TypUpsVmAdresse *ParametreType, TypUpsVmAdresse *ObjetInitialisation);
   /* Objet : Fabrique une Liste a partir d'un objet servant d'initialisation. */
TypUpsVmAdresse UpsVmAPI *(*CreerObjetReference)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat,
   TypUpsVmAdresse *ParametreType, TypUpsVmAdresse *ObjetInitialisation);
   /* Objet : Fabrique un Reference a partir d'un objet servant d'initialisation. */
TypUpsVmAdresse UpsVmAPI *(*CreerObjetTableau)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat,
   TypUpsVmLong BorneMin, TypUpsVmLong BorneMax, TypUpsVmAdresse *ParametreType, TypUpsVmAdresse *ObjetInitialisation);
   /* Objet : Fabrique un Tableau a partir d'un objet servant d'initialisation. */
TypUpsVmAdresse UpsVmAPI *(*CreerObjetArbreBinaire)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *ParametreType, TypUpsVmAdresse *ObjetInitialisation);
   /* Objet : Fabrique un ArbreBinaire a partir d'un objet servant d'initialisation. */
TypUpsVmVoid UpsVmAPI (*RenvoyerException)(TypUpsVmSession *Session);
   /* Objet : Renvoie l'exception courante. */ 
TypUpsVmVoid UpsVmAPI (*EnvoyerExceptionStandard)(TypUpsVmSession *Session, TypUpsVmAdresse *Objet, 
   TypUpsVmUnicode *P1, TypUpsVmUnicode *P2, TypUpsVmUnicode *P3, TypUpsVmUnicode *P4, 
   TypUpsVmUnicode *P5);
   /* Objet : Envoie une exception standard. */ 
TypUpsVmVoid UpsVmAPI (*TraiterExceptionEnAttente)(TypUpsVmSession *Session);
   /* Objet : Traite une eventuelle exception en attente. */
TypUpsVmRegistres UpsVmAPI *(*EmpilerPointDeRetour)(TypUpsVmSession *Session);
   /* Objet : Empile un point de retour. */ 
TypUpsVmVoid UpsVmAPI (*DepilerPointDeRetour)(TypUpsVmSession *Session);
   /* Objet : Depile un point de retour. */ 
TypUpsVmLong UpsVmAPI (*LireIndicePointDeRetour)(TypUpsVmSession *Session);
   /* Objet : Renvoie l'indice du point de retour courant. */
TypUpsVmShort UpsVmAPI (*ExceptionEnCours)(TypUpsVmSession *Session);
   /* Objet : Retourne Vrai si une exception est lancee. */
TypUpsVmVoid UpsVmAPI (*ArreterProgramme)(TypUpsVmSession *Session, TypUpsVmLong CodeRetour, TypUpsVmShort Forcer,
   TypUpsVmShort CallbackEnCours);
   /* Objet : Arrete le programme. */
TypUpsVmVoid UpsVmAPI (*MiseAJourInterrompreTache)(TypUpsVmSession *Session, TypUpsKrnInterrompreTache RappelInterrompreTache, TypUpsVmPointeurDonnees Handle);
   /* Objet : Met a jour la fonction de rappel d'interruption d'une tache bloquee. */
TypUpsVmAdresse UpsVmAPI *(*LireAdresseTemporaire)(TypUpsVmSession *Session);
   /* Objet : Lit l'adresse d'un temporaire d'objet. */
TypUpsVmVoid UpsVmAPI (*MiseAJourSourceCourant)(TypUpsVmSession *Session, TypUpsVmUnicode *SourceCourant);
   /* Objet : Met a jour la chaine donnant le source courant. */
TypUpsVmVoid UpsVmAPI (*MiseAJourLigneEtColonneCourant)(TypUpsVmSession *Session, TypUpsVmLong NumeroLigne, TypUpsVmLong NumeroColonne);
   /* Objet : Met a jour le numero de ligne et de colonne courant. */
TypUpsVmUnicode UpsVmAPI *(*LireLigneEtColonneCourant)(TypUpsVmSession *Session, TypUpsVmLong *NumeroLigne, TypUpsVmLong *NumeroColonne);
   /* Objet : Lit le numero de ligne et de colonne courant. */
TypUpsVmLong UpsVmAPI (*LireCodeRetour)(TypUpsVmSession *Session);
   /* Objet : Lit le code retour d'une tache. */
TypUpsVmAdresse UpsVmAPI *(*LireExceptionEnvoyee)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseExceptionEnvoyee);
   /* Objet : Lit l'exception envoyee. */
TypUpsVmVoid UpsVmAPI (*AnnulerExceptionEnAttente)(TypUpsVmSession *Session);
   /* Objet : Annule l'exception en attente. */
TypUpsVmVoid UpsVmAPI (*LacherException)(TypUpsVmSession *Session);
   /* Objet : Lache l'exception ce qui traduit la fin d'une cascade de AttraperException. */
TypUpsVmVoid UpsVmAPI (*EnvoyerExceptionAUneTache)(TypUpsVmSession *Session, 
   TypUpsVmSession *SessionTache, TypUpsVmAdresse *AdresseObjetException, TypUpsVmAdresse *AdresseObjetP1, 
	TypUpsVmAdresse *AdresseObjetP2, TypUpsVmAdresse *AdresseObjetP3, TypUpsVmAdresse *AdresseObjetP4, TypUpsVmAdresse *AdresseObjetP5);
   /* Objet : Envoie une exception a une tache. */
TypUpsVmVoid UpsVmAPI (*EmpilerQuotaAppel)(TypUpsVmSession *Session, TypUpsVmUnicode *NomAppel, TypUpsVmAdresse *AdresseObjetModule);
   /* Objet : Empile un quota pour un appel. */ 
TypUpsVmVoid UpsVmAPI (*EmpilerQuotaMethode)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypUpsVmUnicode *NomAppel);
   /* Objet : Empile un quota pour une methode. */ 
TypUpsVmVoid UpsVmAPI (*DepilerQuota)(TypUpsVmSession *Session);
   /* Objet : Depile un point de retour. */ 
TypUpsVmVoid UpsVmAPI (*RecupererLibelleErreurDeLException)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseExceptionNonRattrapee, 
   TypUpsVmUnicode **LibelleErreur);
   /* Objet : Recupere le libelle de l'erreur de l'exception. */
TypUpsVmAdresse UpsVmAPI *(*VerifierOrigineObjet)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjet, enum EnuUpsKrnVerificationObjet *TableLiaisons, TypUpsVmAdresse *AdresseObjetType);
   /* Objet : Verifie l'origine de l'objet. */
TypUpsVmVoid UpsVmAPI (*MethodeAffecter)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *ObjetP);
   /* Operateur =(P:Nul Ou Objet); */
TypUpsVmAdresse UpsVmAPI *(*MethodeEgal)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *ObjetP);
   /* Operateur ==(P:Nul Ou Objet) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*MethodeDifferent)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmAdresse *UpsObjet, TypUpsVmAdresse *ObjetP);
   /* Operateur !=(P:Nul Ou Objet) Retourner Nul Ou Booleen; */
TypUpsVmVoid UpsVmAPI (*MethodeComposer)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, 
	TypUpsVmAdresse *ObjetP, TypUpsKrnMethodeAComposer MethodeOperateur, enum EnuUpsVmOperateur Operateur, 
   TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel);
  /* Operateur ?=(P:Nul Ou Objet); */
TypUpsVmVoid UpsVmAPI (*AnnulerUtilisation)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Annule le nombre d'utilisations de l'objet. */
TypUpsVmAdresse UpsVmAPI *(*BooleenEt)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat,
   TypUpsVmAdresse *AdresseObjet, TypUpsVmAdresse *AdresseObjetB);
   /* Operateur Et(B:Nul Ou Booleen) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*BooleenOu)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat,
   TypUpsVmAdresse *AdresseObjet, TypUpsVmAdresse *AdresseObjetB);
   /* Operateur Ou(B:Nul Ou Booleen) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*BooleenOuExclusif)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat,
   TypUpsVmAdresse *AdresseObjet, TypUpsVmAdresse *AdresseObjetB);
   /* Operateur OuExclusif(B:Nul Ou Booleen) Retourner Nul Ou Booleen; */
TypUpsVmAdresse UpsVmAPI *(*BooleenNon)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat,
   TypUpsVmAdresse *AdresseObjet);
   /* Operateur Non() Retourner Nul Ou Booleen; */
TypUpsVmShort UpsVmAPI (*InitialiserApresUpsMat)(TypUpsVmVoid);
   /* Objet : Initialisation le composant apres UpsMat. */
TypUpsVmLong UpsVmAPI (*DiviserEntier)(TypUpsVmSession *Session, TypUpsVmLong E1, TypUpsVmLong E2);
   /* Division entiere. */
TypUpsVmDouble UpsVmAPI (*DiviserReel)(TypUpsVmSession *Session, TypUpsVmDouble D1, TypUpsVmDouble D2);
   /* Division entiere. */
TypUpsVmLong UpsVmAPI (*ModulerEntier)(TypUpsVmSession *Session, TypUpsVmLong E1, TypUpsVmLong E2);
   /* Congruence entiere. */
TypUpsVmDouble UpsVmAPI (*ModulerReel)(TypUpsVmSession *Session, TypUpsVmDouble E1, TypUpsVmLong E2);
   /* Congruence reelle. */
TypUpsVmVoid UpsVmAPI (*ErreurNonRattrapee)(TypUpsVmSession *Session);
   /* Envoie le message d'erreur pour une exception non rattrapee. */
TypUpsVmVoid UpsVmAPI (*MiseAuPoint)(TypUpsVmSession *Session, TypUpsVmUnicode *Message, enum EnuUpsKrnTypeTrace TypeTrace, TypUpsVmChar Booleen, 
   TypUpsVmLong Entier, TypUpsVmUnsignedShort ValeurEnumere, TypUpsVmDouble Reel, TypUpsVmAdresse *AdresseObjet);
   /* Objet : ActiverMiseAuPoint. */
TypUpsVmAdresse UpsVmAPI *(*ConvertirReelVersObjetEntier)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat,
   TypUpsVmAdresse *AdresseObjetReel, TypUpsVmDouble Reel);
   /* Objet : Fabrique un Entier a partir d'une valeur reelle. */
TypUpsVmAdresse UpsVmAPI *(*ConvertirEntierVersObjetReel)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat,
   TypUpsVmAdresse *AdresseObjetEntier, TypUpsVmLong Entier);
   /* Objet : Fabrique un Reel a partir d'une valeur entiere. */
TypUpsVmUnsignedChar UpsVmAPI (*ExtraireEnumereCourt)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Extrait la valeur enumeree courte de l'objet. */
TypUpsVmUnsignedShort UpsVmAPI (*ExtraireEnumereLong)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Extrait la valeur enumere longue de l'objet. */
TypUpsVmLong UpsVmAPI (*ExtraireEntier)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Extrait la valeur entiere de l'objet. */
TypUpsVmLong UpsVmAPI (*ExtraireEntierOuEnumere)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Extrait la valeur entiere ou enumere de l'objet. */
TypUpsVmDouble UpsVmAPI (*ExtraireReel)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Extrait la valeur reelle de l'objet. */
TypUpsVmVoid UpsVmAPI (*MiseAJourVariableEntier)(TypUpsVmSession *Session, TypUpsVmLong *Variable, 
   TypUpsVmLong Entier, enum EnuUpsVmOperateur Operateur);
   /* Objet : Mise a jour d'une variable entiere. */
TypUpsVmLong UpsVmAPI (*IncrementerDecrementerVariableEntier)(TypUpsVmSession *Session, TypUpsVmLong *Variable, 
   TypUpsVmChar Incrementer, TypUpsVmChar Prefixe);
   /* Objet : Incremente ou decremente une variable entiere. */
TypUpsVmVoid UpsVmAPI (*MiseAJourVariableReel)(TypUpsVmSession *Session, TypUpsVmDouble *Variable, 
   TypUpsVmDouble Reel, enum EnuUpsVmOperateur Operateur);
   /* Objet : Mise a jour d'une variable reel de l'objet. */
TypUpsVmDouble UpsVmAPI (*IncrementerDecrementerVariableReel)(TypUpsVmSession *Session, TypUpsVmDouble *Variable, 
   TypUpsVmChar Incrementer, TypUpsVmChar Prefixe);
   /* Objet : Incremente ou decremente une variable reelle. */
TypUpsVmUnsignedChar UpsVmAPI (*ExtraireChampEnumereCourt)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmLong Offset);
   /* Objet : Extrait un champ enumere court de l'objet. */
TypUpsVmUnsignedShort UpsVmAPI (*ExtraireChampEnumereLong)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmLong Offset);
   /* Objet : Extrait un champ TypUpsVmLong court de l'objet. */
TypUpsVmLong UpsVmAPI (*ExtraireChampEntier)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmLong Offset);
   /* Objet : Extrait un champ entier de l'objet. */
TypUpsVmDouble UpsVmAPI (*ExtraireChampReel)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmLong Offset);
   /* Objet : Extrait un champ reel de l'objet. */
TypUpsVmAdresse UpsVmAPI *(*ExtraireChampObjet)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat,
   TypUpsVmAdresse *AdresseObjet, TypUpsVmLong Offset);
   /* Objet : Extrait un champ de l'objet. */
TypUpsVmAdresse UpsVmAPI *(*ExtraireInstanceDe)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmAdresse *AdresseObjet);
   /* Objet : Extrait instance de l'objet. */
TypUpsVmVoid UpsVmAPI (*MiseAJourChampEnumereCourt)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmLong Offset, TypUpsVmUnsignedChar EnumereCourt);
   /* Objet : Met a jour d'un champ enumere court de l'objet. */
TypUpsVmVoid UpsVmAPI (*MiseAJourChampEnumereLong)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmLong Offset, TypUpsVmUnsignedShort EnumereLong);
   /* Objet : Mise a jour d'un champ TypUpsVmLong court de l'objet. */
TypUpsVmVoid UpsVmAPI (*MiseAJourChampEntier)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmLong Offset, TypUpsVmLong Entier, enum EnuUpsVmOperateur Operateur);
   /* Objet : Mise a jour d'un champ entier de l'objet. */
TypUpsVmVoid UpsVmAPI (*MiseAJourChampReel)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmLong Offset, TypUpsVmDouble Reel, enum EnuUpsVmOperateur Operateur);
   /* Objet : Mise a jour d'un champ reel de l'objet. */
TypUpsVmVoid UpsVmAPI (*MiseAJourChampObjet)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypUpsVmLong Offset, TypUpsVmAdresse *AdresseObjet2);
   /* Objet : Mise a jour d'un champ de l'objet. */
TypUpsVmVoid UpsVmAPI (*MethodeComposerChampObjet)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjet, TypUpsVmLong Offset, TypUpsVmAdresse *AdresseObjetP, 
   TypUpsKrnAppliquerMethodeAComposer MethodeComposer, enum EnuUpsVmOperateur Operateur, TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel);
   /* Objet : Applique un operateur compose a un champ d'un type. */
TypUpsVmVoid UpsVmAPI (*MiseAJourChampNul)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypUpsVmLong Offset);
   /* Objet : Mise a jour d'un champ de l'objet a Nul. */
TypUpsVmLong UpsVmAPI (*IncrementerDecrementerChampEntier)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmLong Offset, TypUpsVmChar Incrementer, TypUpsVmChar Prefixe);
   /* Objet : Incremente ou decremente un champ entier de l'objet. */
TypUpsVmDouble UpsVmAPI (*IncrementerDecrementerChampReel)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmLong Offset, TypUpsVmChar Incrementer, TypUpsVmChar Prefixe);
   /* Objet : Incremente ou decremente un champ reel de l'objet. */
TypUpsVmAdresse UpsVmAPI *(*IncrementerDecrementerChampObjet)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmAdresse *AdresseObjet, TypUpsVmLong Offset, TypUpsVmChar Incrementer, TypUpsVmChar Prefixe, TypUpsKrnAppliquerMethodeAIncrementer Methode, 
	TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel);
   /* Objet : Incremente ou decremente un champ d'un objet. */
TypUpsVmVoid UpsVmAPI (*DetruireChampObjet)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmLong Offset);
   /* Objet : Detruit le champ de l'objet. */
TypUpsVmVoid UpsVmAPI (*VirtuelVariableEntier)(TypUpsVmSession *Session,
   TypUpsKrnVirtuelVariableEntierLecture Lecture, TypUpsKrnVirtuelVariableEntierEcriture Ecriture, 
   TypUpsVmLong ValeurDroite, enum EnuUpsVmOperateur Operateur);
   /* Objet : Mise a jour une variable virtuelle avec un operateur de composition. */
TypUpsVmVoid UpsVmAPI (*VirtuelVariableReel)(TypUpsVmSession *Session,
   TypUpsKrnVirtuelVariableReelLecture Lecture, TypUpsKrnVirtuelVariableReelEcriture Ecriture, 
   TypUpsVmDouble ValeurDroite, enum EnuUpsVmOperateur Operateur);
   /* Objet : Mise a jour une variable virtuelle avec un operateur de composition. */
TypUpsVmVoid UpsVmAPI (*VirtuelVariableObjet)(TypUpsVmSession *Session,
   TypUpsKrnVirtuelVariableObjetLecture Lecture, TypUpsKrnVirtuelVariableObjetEcriture Ecriture, 
   TypUpsVmAdresse *ValeurDroite, TypUpsKrnAppliquerMethodeAComposer MethodeComposer);
   /* Objet : Mise a jour une variable virtuelle avec un operateur de composition. */
TypUpsVmLong UpsVmAPI (*IncrementerDecrementerVirtuelVariableEntier)(TypUpsVmSession *Session,
   TypUpsKrnVirtuelVariableEntierLecture Lecture, TypUpsKrnVirtuelVariableEntierEcriture Ecriture, 
      TypUpsVmShort Incrementer, TypUpsVmShort Prefixe);
   /* Objet : Mise a jour une variable virtuelle avec un operateur d'incrementation ou de decrementation. */
TypUpsVmDouble UpsVmAPI (*IncrementerDecrementerVirtuelVariableReel)(TypUpsVmSession *Session,
   TypUpsKrnVirtuelVariableReelLecture Lecture, TypUpsKrnVirtuelVariableReelEcriture Ecriture, 
   TypUpsVmShort Incrementer, TypUpsVmShort Prefixe);
   /* Objet : Mise a jour une variable virtuelle avec un operateur d'incrementation ou de decrementation. */
TypUpsVmAdresse UpsVmAPI *(*IncrementerDecrementerVirtuelVariableObjet)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat,
   TypUpsKrnVirtuelVariableObjetLecture Lecture, TypUpsKrnVirtuelVariableObjetEcriture Ecriture, 
   TypUpsVmShort Prefixe, TypUpsKrnAppliquerMethodeAIncrementer Methode);
   /* Objet : Mise a jour une variable virtuelle avec un operateur d'incrementation ou de decrementation. */
TypUpsVmVoid UpsVmAPI (*VirtuelChampEntier)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, 
   TypUpsKrnVirtuelChampEntierLecture Lecture, TypUpsKrnVirtuelChampEntierEcriture Ecriture, 
   TypUpsVmLong ValeurDroite, enum EnuUpsVmOperateur Operateur);
   /* Objet : Mise a jour un champ virtuel avec un operateur de composition. */
TypUpsVmVoid UpsVmAPI (*VirtuelChampReel)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, 
   TypUpsKrnVirtuelChampReelLecture Lecture, TypUpsKrnVirtuelChampReelEcriture Ecriture, 
   TypUpsVmDouble ValeurDroite, enum EnuUpsVmOperateur Operateur);
   /* Objet : Mise a jour un champ virtuel avec un operateur de composition. */
TypUpsVmVoid UpsVmAPI (*VirtuelChampObjet)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, 
   TypUpsKrnVirtuelChampObjetLecture Lecture, TypUpsKrnVirtuelChampObjetEcriture Ecriture, 
   TypUpsVmAdresse *ValeurDroite, TypUpsKrnAppliquerMethodeAComposer MethodeComposer);
   /* Objet : Mise a jour un champ virtuel avec un operateur de composition. */
TypUpsVmLong UpsVmAPI (*IncrementerDecrementerVirtuelChampEntier)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, 
   TypUpsKrnVirtuelChampEntierLecture Lecture, TypUpsKrnVirtuelChampEntierEcriture Ecriture, 
   TypUpsVmShort Incrementer, TypUpsVmShort Prefixe);
   /* Objet : Mise a jour un champ virtuel avec un operateur d'incrementation ou de decrementation. */
TypUpsVmDouble UpsVmAPI (*IncrementerDecrementerVirtuelChampReel)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, 
   TypUpsKrnVirtuelChampReelLecture Lecture, TypUpsKrnVirtuelChampReelEcriture Ecriture, 
   TypUpsVmShort Incrementer, TypUpsVmShort Prefixe);
   /* Objet : Mise a jour un champ virtuel avec un operateur d'incrementation ou de decrementation. */
TypUpsVmAdresse UpsVmAPI *(*IncrementerDecrementerVirtuelChampObjet)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmAdresse *UpsObjet, TypUpsKrnVirtuelChampObjetLecture Lecture,
   TypUpsKrnVirtuelChampObjetEcriture Ecriture, TypUpsVmShort Prefixe,
   TypUpsKrnAppliquerMethodeAIncrementer Methode);
   /* Objet : Mise a jour une variable virtuelle avec un operateur d'incrementation ou de decrementation. */
TypUpsVmAdresse UpsVmAPI *(*IConstructeurSansParametre)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat);
   /* Objet : Execute l'appel d'une interface.                     */
TypUpsVmAdresse UpsVmAPI *(*IConstructeurAvecParametre)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmPointeurDonnees Parametres, 
	TypUpsVmLong TailleParametres, TypUpsVmCoAppel EnumererParametres, TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel);
   /* Objet : Execute l'appel d'une interface.                     */
TypUpsVmVoid UpsVmAPI (*IDestructeur)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Execute l'appel d'une interface. */
TypUpsVmVoid UpsVmAPI (*IMethodeAffecter)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjet, TypUpsVmAdresse *AdresseObjetP);
   /* Objet : Execute l'appel d'une interface. */
TypUpsVmAdresse UpsVmAPI *(*IMethodeEgal)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypUpsVmAdresse *AdresseObjetP);
   /* Objet : Execute l'appel d'une interface. */
TypUpsVmAdresse UpsVmAPI *(*IMethodeDifferent)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypUpsVmAdresse *AdresseObjetP);
   /* Objet : Execute l'appel d'une interface. */
TypUpsVmAdresse UpsVmAPI *(*IMethodeCloner)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsVmCloner *UpsPrm);
   /* Methode de clonage pour un Objet; */
TypUpsVmVoid UpsVmAPI (*IMethodeExporter)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Methode d'exportation pour un Objet; */
TypUpsVmAdresse UpsVmAPI *(*IMethodeImporter)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmImporter *UpsPrm);
   /* Methode d'importation pour un Objet; */
TypUpsVmAdresse UpsVmAPI *(*IMethodeLirePropriete)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsVmLirePropriete *UpsPrm);
   /* Objet : Methode de lecture des proprietes dynamiques. */
TypUpsVmVoid UpsVmAPI (*IMethodeEcrirePropriete)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsVmEcrirePropriete *UpsPrm);
   /* Objet : Methode d'ecriture des proprietes dynamiques. */
TypUpsVmAdresse UpsVmAPI *(*IMethodeIncrementerDecrementerPropriete)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsVmIncrementerDecrementerPropriete *UpsPrm);
   /* Objet : Methode d'incrementation ou de decrementation des    */
   /* proprietes dynamiques.                                       */
TypUpsVmVoid UpsVmAPI (*IMethodeSupprimerPropriete)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypPrmUpsVmSupprimerPropriete *UpsPrm);
   /* Objet : Methode de suppression des proprietes dynamiques.    */
TypUpsVmAdresse UpsVmAPI *(*IMethodeEnumererProprietes)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsVmEnumererProprietes *UpsPrm);
   /* Objet : Methode d'enumeration des proprietes dynamiques. */
TypUpsVmAdresse UpsVmAPI *(*IMethodeEnumererMethodes)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsVmEnumererAppels *UpsPrm);
   /* Objet : Enumere les appels. */
TypUpsVmVoid UpsVmAPI (*IMethodeAllouerRessource)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Methode d'allocation de la ressource pour un Objet; */
TypUpsVmVoid UpsVmAPI (*IProcedureSansParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjet, TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel);
   /* Objet : Execute l'appel d'une interface. */
TypUpsVmVoid UpsVmAPI (*IMethodeLibererRessource)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Methode de liberation de la ressource pour un Objet; */
TypUpsVmVoid UpsVmAPI (*IProcedureAvecParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjet, TypUpsVmPointeurDonnees Parametres, TypUpsVmLong TailleParametres, 
   TypUpsVmCoAppel EnumererParametres, TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel);
   /* Objet : Execute l'appel d'une interface. */
TypUpsVmUnsignedChar UpsVmAPI (*IFonctionEnumereCourtSansParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjet, TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel);
   /* Objet : Execute l'appel d'une interface. */
TypUpsVmUnsignedChar UpsVmAPI (*IFonctionEnumereCourtAvecParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjet, TypUpsVmPointeurDonnees Parametres, TypUpsVmLong TailleParametres, 
   TypUpsVmCoAppel EnumererParametres, TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel);
   /* Objet : Execute l'appel d'une interface. */
TypUpsVmUnsignedShort UpsVmAPI (*IFonctionEnumereLongSansParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjet, TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel);
   /* Objet : Execute l'appel d'une interface. */
TypUpsVmUnsignedShort UpsVmAPI (*IFonctionEnumereLongAvecParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjet, TypUpsVmPointeurDonnees Parametres, TypUpsVmLong TailleParametres, 
   TypUpsVmCoAppel EnumererParametres, TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel);
   /* Objet : Execute l'appel d'une interface. */
TypUpsVmLong UpsVmAPI (*IFonctionEntierSansParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjet, TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel);
   /* Objet : Execute l'appel d'une interface. */
TypUpsVmLong UpsVmAPI (*IFonctionEntierAvecParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjet, TypUpsVmPointeurDonnees Parametres, TypUpsVmLong TailleParametres, 
   TypUpsVmCoAppel EnumererParametres, TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel);
   /* Objet : Execute l'appel d'une interface. */
TypUpsVmDouble UpsVmAPI (*IFonctionReelSansParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjet, TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel);
   /* Objet : Execute l'appel d'une interface. */
TypUpsVmDouble UpsVmAPI (*IFonctionReelAvecParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjet, TypUpsVmPointeurDonnees Parametres, TypUpsVmLong TailleParametres, 
   TypUpsVmCoAppel EnumererParametres, TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel);
   /* Objet : Execute l'appel d'une interface. */
TypUpsVmAdresse UpsVmAPI *(*IFonctionObjetSansParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel);
   /* Objet : Execute l'appel d'une interface. */
TypUpsVmAdresse UpsVmAPI *(*IFonctionObjetAvecParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypUpsVmPointeurDonnees Parametres, TypUpsVmLong TailleParametres, 
   TypUpsVmCoAppel EnumererParametres, TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel);
   /* Objet : Execute l'appel d'une interface. */
TypUpsVmVoid UpsVmAPI (*MethodeAffecterTypeParametre)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmAdresse *ObjetP, TypUpsVmLong Offset);
   /* Objet : Applique la methode = a un objet dont le type est un parametre. */
TypUpsVmAdresse UpsVmAPI *(*MethodeEgalTypeParametre)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat,
   TypUpsVmAdresse *AdresseObjet, TypUpsVmAdresse *ObjetP, TypUpsVmLong Offset);
   /* Objet : Applique la methode == a un objet dont le type est un parametre. */
TypUpsVmAdresse UpsVmAPI *(*MethodeDifferentTypeParametre)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat,
   TypUpsVmAdresse *AdresseObjet, TypUpsVmAdresse *ObjetP, TypUpsVmLong Offset);
   /* Objet : Applique la methode != a un objet dont le type est un parametre. */
TypUpsVmVoid UpsVmAPI (*VerifierContrainteNonNul)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjet, TypUpsVmLong OffsetChamp, TypUpsVmAdresse *AdresseObjet2);
   /* Objet : Verifie que la contrainte Non Nul est respectee. */ 
TypUpsVmVoid UpsVmAPI (*VerifierContrainteSelon)(TypUpsVmSession *Session, TypUpsVmUnsignedShort NumeroCas, TypUpsVmUnsignedShort NumeroCasAttendu, 
   TypUpsVmUnicode *LibelleCas);
   /* Objet : Verifie que la contrainte du Selon est respectee. */ 
TypUpsVmVoid UpsVmAPI (*VerifierContrainteEntier)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjetType, TypUpsVmAdresse *AdresseObjet, TypUpsVmLong OffsetChamp,
	TypUpsVmLong Entier, TypUpsVmAdresse *AdresseObjet2);
   /* Objet : Verifie que la contrainte sur un entier est respectee. */ 
TypUpsVmVoid UpsVmAPI (*VerifierContrainteReel)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjetType, TypUpsVmAdresse *AdresseObjet, TypUpsVmLong OffsetChamp,
	TypUpsVmDouble Reel, TypUpsVmAdresse *AdresseObjet2);
   /* Objet : Verifie que la contrainte sur un reel est respectee. */ 
TypUpsVmVoid UpsVmAPI (*VerifierContrainteObjet)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjetType, TypUpsVmAdresse *AdresseObjet, TypUpsVmLong OffsetChamp,
	TypUpsVmAdresse *AdresseObjet2);
   /* Objet : Verifie que la contrainte sur un reel est respectee. */ 
TypUpsVmShort UpsVmAPI (*TenterDeValiderContraintes)(TypUpsVmSession *Session, TypUpsVmUnicode **LibelleErreur);
   /* Objet : Tente de valider les contraintes en attente. */
TypUpsVmVoid UpsVmAPI (*LibererContraintes)(TypUpsVmSession *Session);
   /* Objet : Liberer les contraintes en attente. */
TypUpsVmChar UpsVmAPI (*ComparerReel)(TypUpsVmSession *Session, TypUpsVmDouble R1, TypUpsVmDouble R2, enum EnuUpsVmOperateur Operateur);
   /* Objet : Compare les nombres reels en tenant compte des arrondis de calcul. */
TypUpsVmShort UpsVmAPI (*Comme)(TypUpsVmUnicode *Chaine, TypUpsVmUnicode *Modele);
   /* Objet : Calcule l'appariemment de la chaine par rapport au modele. */
TypUpsVmShort UpsVmAPI (*IlExisteJoker)(TypUpsVmUnicode *Chaine);
   /* Objet : Retourne Vrai si la chaine comporte un joker. */
TypUpsVmEnteteMethodes UpsVmAPI *(*LireMethodesObjet)(TypUpsVmVoid);
   /* Objet : Retourne la table des methodes du type Objet. */
TypUpsVmEnteteMethodes UpsVmAPI *(*LireMethodesType)(TypUpsVmVoid);
   /* Objet : Retourne la table des methodes du type Type. */
TypUpsVmAdresse UpsVmAPI *(*ClonerObjet)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmAdresse *AdresseObjet, TypPrmUpsVmCloner *UpsPrm);
   /* Objet : Clone un objet. */
TypUpsVmShort UpsVmAPI (*CalculerEntrepotCloner)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetEntrepot);
   /* Objet : Calcule l'entrepot de clonage. */
TypUpsVmVoid UpsVmAPI (*EmpilerIterateur)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmShort NumeroIterateur);
   /* Objet : Empile un iterateur. */ 
TypUpsVmVoid UpsVmAPI (*DepilerIterateur)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmLong NumeroIterateur);
   /* Objet : Depile un interateur. */ 
TypUpsVmAdresse UpsVmAPI *(*CreerObjetEntrepot)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmUnsignedShort NumeroEntrepot, TypUpsVmAdresse *AdresseObjetModule);
   /* Objet : Fabrique un objet Entrepot. */
TypUpsVmVoid UpsVmAPI (*ErreurVersionModule)(TypUpsVmSession *Session, TypUpsVmUnicode *NomModule, TypUpsVmShort Version, 
   TypUpsVmShort Revision, TypUpsVmShort Correction);
   /* Objet : Envoie une erreur d'importation suite a une incompatibilite. */
TypUpsVmAdresse UpsVmAPI *(*CreerObjetModule)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat,
   TypUpsVmUnicode *NomModule, TypUpsVmLong Numero, TypUpsVmLong Priorite, TypUpsVmShort EstDistribue);
   /* Objet : Construit un module. */
TypUpsVmVoid UpsVmAPI (*AjouterModule)(TypUpsVmSession *Session, TypUpsNetProtocoleUpsNet *BufferProtocoleUpsNet);
   /* Objet : Ajoute un module en le chargeant dynamiquement. */
TypUpsVmVoid UpsVmAPI (*SupprimerModule)(TypUpsVmSession *Session, TypUpsNetProtocoleUpsNet *BufferProtocoleUpsNet);
   /* Objet : Supprime un module en le dechargeant dynamiquement. */
TypUpsVmShort UpsVmAPI (*AttacherTache)(TypUpsVmSession *Session);
   /* Objet : Attache une tache a un systeme tiers. */
TypUpsVmVoid UpsVmAPI (*DetacherTache)(TypUpsVmSession *Session);
   /* Objet : Detache une tache d'un systeme tiers. */
TypUpsVmAdresse UpsVmAPI *(*CreerObjetAppel)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmUnicode *NomAppel, enum EnuUpsVmModeDAppel TypeAppel, enum EnuUpsVmTypeDeTraitements TypeDeTraitements,
   TypUpsVmPointeurTraitements Appel, TypUpsVmCoAppel EnumererParametres, TypUpsVmAdresse *AdresseObjetType, 
   TypUpsVmAdresse *AdresseObjet, TypUpsVmAdresse *AdresseObjetModule, TypUpsVmLong IndexAppel, TypUpsVmLong IndexCoAppel,
   TypUpsVmPointeurDonnees DescriptionAppelTiers);
   /* Objet : Fabrique un Appel a partir d'un pointeur de traitement d'initialisation. */
TypUpsVmUnsignedChar UpsVmAPI (*EnumererParametres)(TypUpsVmSession *Session, TypUpsVmShort NumeroParametre, 
   TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm, TypUpsVmAdresse *AdresseObjetAppel);
   /* Objet : Enumere le n-ieme parametre de l'appel. */
TypUpsVmVoid UpsVmAPI (*ProcedureSansParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjet);
   /* Objet : Execute l'appel. */
TypUpsVmVoid UpsVmAPI (*ProcedureAvecParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjet, TypUpsVmPointeurDonnees Parametres, TypUpsVmLong TailleParametres);
   /* Objet : Execute l'appel. */
TypUpsVmUnsignedChar UpsVmAPI (*FonctionEnumereCourtSansParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjet);
   /* Objet : Execute l'appel. */
TypUpsVmUnsignedChar UpsVmAPI (*FonctionEnumereCourtAvecParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjet, TypUpsVmPointeurDonnees Parametres, TypUpsVmLong TailleParametres);
   /* Objet : Execute l'appel. */
TypUpsVmUnsignedShort UpsVmAPI (*FonctionEnumereLongSansParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjet);
   /* Objet : Execute l'appel. */
TypUpsVmUnsignedShort UpsVmAPI (*FonctionEnumereLongAvecParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjet, TypUpsVmPointeurDonnees Parametres, TypUpsVmLong TailleParametres);
   /* Objet : Execute l'appel. */
TypUpsVmLong UpsVmAPI (*FonctionEntierSansParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjet);
   /* Objet : Execute l'appel. */
TypUpsVmLong UpsVmAPI (*FonctionEntierAvecParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjet, TypUpsVmPointeurDonnees Parametres, TypUpsVmLong TailleParametres);
   /* Objet : Execute l'appel. */
TypUpsVmDouble UpsVmAPI (*FonctionReelSansParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjet);
   /* Objet : Execute l'appel. */
TypUpsVmDouble UpsVmAPI (*FonctionReelAvecParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjet, TypUpsVmPointeurDonnees Parametres, TypUpsVmLong TailleParametres);
   /* Objet : Execute l'appel. */
TypUpsVmAdresse UpsVmAPI *(*FonctionObjetSansParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Execute l'appel. */
TypUpsVmAdresse UpsVmAPI *(*FonctionObjetAvecParametre)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypUpsVmPointeurDonnees Parametres, TypUpsVmLong TailleParametres);
   /* Objet : Execute l'appel. */
TypUpsVmAdresse UpsVmAPI *(*MethodeLirePropriete)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsVmLirePropriete *UpsPrm);
   /* Objet : Methode de lecture des proprietes dynamiques. */
TypUpsVmVoid UpsVmAPI (*MethodeEcrirePropriete)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjet, TypPrmUpsVmEcrirePropriete *UpsPrm);
   /* Objet : Methode d'ecriture des proprietes dynamiques. */
TypUpsVmAdresse UpsVmAPI *(*MethodeIncrementerDecrementerPropriete)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsVmIncrementerDecrementerPropriete *UpsPrm);
   /* Objet : Methode d'ecriture des proprietes dynamiques. */
TypUpsVmVoid UpsVmAPI (*MethodeSupprimerPropriete)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseObjet, TypPrmUpsVmSupprimerPropriete *UpsPrm);
   /* Objet : Methode de suppression des proprietes dynamiques. */
TypUpsVmAdresse UpsVmAPI *(*MethodeEnumererProprietes)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypPrmUpsVmEnumererProprietes *UpsPrm);
   /* Objet : Methode d'enumeration des proprietes dynamiques. */
TypUpsVmVoid UpsVmAPI (*ClonerProprietesDynamiques)(TypUpsVmSession *Session,
   TypUpsVmAdresse *AdresseObjet, TypUpsVmAdresse *AdresseObjetClone, TypPrmUpsVmCloner *UpsPrm);
   /* Objet : Clone les proprietes dynamiques de l'objet. */
TypUpsVmVoid UpsVmAPI (*ExporterProprietesDynamiques)(TypUpsVmSession *Session,
   TypUpsVmAdresse *AdresseObjet);
   /* Objet : Exporte les proprietes dynamiques de l'objet. */
TypUpsVmVoid UpsVmAPI (*ImporterProprietesDynamiques)(TypUpsVmSession *Session,
   TypUpsVmAdresse *AdresseObjet);
   /* Objet : Importe les proprietes dynamiques de l'objet. */
TypUpsVmVoid UpsVmAPI (*CalculerValeurParDefaut)(TypUpsVmSession *Session,
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Calcule la valeur par defaut de l'objet en fonction de son type. */
TypUpsVmVoid UpsVmAPI (*CopierAdresseType)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetType, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Recupere l'adresse de l'objet du type. */
TypUpsVmVoid UpsVmAPI (*CopierNomModule)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetModule, TypUpsVmUnicode *NomModule,
   TypUpsVmLong TailleNomModule, TypUpsVmShort *Version, TypUpsVmShort *Revision, TypUpsVmShort *Correction);
   /* Objet : Recupere le nom du module. */
TypUpsVmVoid UpsVmAPI (*CopierNomModule2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetType, 
   TypUpsVmUnicode *NomModule, TypUpsVmLong TailleNomModule, TypUpsVmShort *Version, TypUpsVmShort *Revision, 
   TypUpsVmShort *Correction);
   /* Objet : Recupere le nom du module. */
TypUpsVmVoid UpsVmAPI (*CopierNomModule3)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmUnicode *NomModule, TypUpsVmLong TailleNomModule, TypUpsVmShort *Version, TypUpsVmShort *Revision, 
   TypUpsVmShort *Correction);
   /* Objet : Recupere le nom du module. */
TypUpsVmVoid UpsVmAPI (*CopierNomType)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetType, TypUpsVmUnicode *NomType,
   TypUpsVmLong TailleNomType);
   /* Objet : Recupere le nom du type. */
TypUpsVmVoid UpsVmAPI (*CopierNomType2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, 
   TypUpsVmUnicode *NomType, TypUpsVmLong TailleNomType);
   /* Objet : Recupere le nom du type. */
TypUpsVmVoid UpsVmAPI (*CopierNomEntrepot)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetEntrepot, 
   TypUpsVmUnicode *NomEntrepot, TypUpsVmLong TailleNomEntrepot);
   /* Objet : Recupere le nom de l'entrepot. */
TypUpsVmVoid UpsVmAPI (*CopierNomException)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjetException, 
   TypUpsVmUnicode *NomException, TypUpsVmLong TailleNomException);
   /* Objet : Recupere le nom de l'exception. */
TypUpsVmCoAppel CoMethodeAffecter;
   /* Operateur =(P:Nul Ou Objet); */
TypUpsVmCoAppel CoMethodeEgal;
   /* Operateur ==(P:Nul Ou Objet); */
TypUpsVmCoAppel CoMethodeDifferent;
   /* Operateur !=(P:Nul Ou Objet) Retourner Nul Ou Booleen; */
TypUpsVmCoAppel CoMethodeComposer;
   /* Operateur ?=(P:Nul Ou Objet); */
TypUpsVmCoAppel CoConstructeur;
   /* Constructeur(); */
TypUpsVmCoAppel CoDestructeur;
   /* Destructeur(); */
TypUpsVmCoAppel CoMethodeCloner;
   /* Cloner(EntrepotCible:Nul Ou Entrepot=Nul, Profondeur : ProfondeurClonage=ClonageObjetSeul) Retourner Nul Ou Objet */
TypUpsVmCoAppel CoMethodeExporter;
   /* Exporter(); */
TypUpsVmCoAppel CoMethodeImporter;
   /* Importer(); */
TypUpsVmCoAppel CoMethodeLirePropriete;
   /* LirePropriete(NomPropriete:Caractere) Retourner Nul Ou Objet; */
TypUpsVmCoAppel CoMethodeEcrirePropriete;
   /* EcrirePropriete(NomPropriete:Caractere, ValeurPropriete:Nul Ou Objet); */
TypUpsVmCoAppel CoMethodeIncrementerDecrementerPropriete;
   /* IncrementerDecrementerPropriete(NomPropriete:Caractere, Prefixe:Boolenen, Incrementer:Booleen) Retourner Nul Ou Objet; */
TypUpsVmCoAppel CoMethodeSupprimerPropriete;
   /* SupprimerProprietes(NomPropriete:Caractere); */
TypUpsVmCoAppel CoMethodeEnumererProprietes;
   /* EnumererProprietes(Numero:Entier, TypePropriete:Nul Ou Type Sortie, EstNul:Booleen Sortie, 
      Aide:Nul Ou Caractere Sortie, NomEnumere : Nul Ou Caractere Sortie) Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoMethodeEnumererMethodes;
   /* EnumererMethodes(Numero:Entier, NomAppel:Nul Ou Caractere Sortie, Aide:Nul Ou Caractere Sortie) Retourner Nul Ou Appel; */
TypUpsVmCoAppel CoMethodeLireVirtuelEnumereCourt;
   /* Virtuel() Retourner Booleen; */
TypUpsVmCoAppel CoMethodeEcrireVirtuelEnumereCourt;
   /* Virtuel(P:Booleen); */
TypUpsVmCoAppel CoMethodeLireVirtuelEnumereLong;
   /* Virtuel() Retourner Enumere; */
TypUpsVmCoAppel CoMethodeEcrireVirtuelEnumereLong;
   /* Virtuel(P:Enumere); */
TypUpsVmCoAppel CoMethodeLireVirtuelEntier;
   /* Virtuel() Retourner Entier; */
TypUpsVmCoAppel CoMethodeEcrireVirtuelEntier;
   /* Virtuel(P:Entier); */
TypUpsVmCoAppel CoMethodeLireVirtuelReel;
   /* Virtuel() Retourner Reel; */
TypUpsVmCoAppel CoMethodeEcrireVirtuelReel;
   /* Virtuel(P:Reel); */
TypUpsVmCoAppel CoMethodeLireVirtuelObjet;
   /* Virtuel() Retourner Nul Ou Objet; */
TypUpsVmCoAppel CoMethodeEcrireVirtuelObjet;
   /* Virtuel(P:Nul Ou Objet); */
TypUpsVmAdresse UpsVmAPI *(*MethodeEnumererMethodes)(TypUpsVmSession *Session, 
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsVmEnumererAppels *UpsPrm,
   TypUpsVmAdresse *AdresseObjetType, TypUpsVmEnteteMethodes *EnteteMethodes, TypUpsVmAdresse *AdresseObjetModule);
   /* Objet : Enumere les methodes generiques a tous les objets. */
TypUpsVmAdresse UpsVmAPI *(*LireObjetTypeElementListe)(TypUpsVmVoid);
   /* Objet : Lit l'adresse de l'objet representant le type ElementListe. */
TypUpsVmEnteteMethodes UpsVmAPI *(*LireMethodesTypeElementListe)(TypUpsVmVoid);
   /* Objet : Lit la table des methodes du type ElementListe. */
TypUpsVmAdresse UpsVmAPI *(*LireObjetTypeElementArbre)(TypUpsVmVoid);
   /* Objet : Lit l'adresse de l'objet representant le type ElementArbre. */
TypUpsVmEnteteMethodes UpsVmAPI *(*LireMethodesTypeElementArbre)(TypUpsVmVoid);
   /* Objet : Lit la table des methodes du type ElementArbre. */
TypUpsVmAdresse UpsVmAPI *(*LireObjetTypeProprieteDynamique)(TypUpsVmVoid);
   /* Objet : Lit l'adresse de l'objet representant le type ProprieteDynamique. */
TypUpsVmEnteteMethodes UpsVmAPI *(*LireMethodesTypeProprieteDynamique)(TypUpsVmVoid);
   /* Objet : Lit la table des methodes du type ProprieteDynamique. */
TypUpsVmAdresse UpsVmAPI *(*LireObjetTypeContrainte)(TypUpsVmVoid);
   /* Objet : Lit l'adresse de l'objet representant le type Contrainte. */
TypUpsVmEnteteMethodes UpsVmAPI *(*LireMethodesTypeContrainte)(TypUpsVmVoid);
   /* Objet : Lit la table des methodes du type Contrainte. */
TypUpsVmUnsignedChar UpsVmAPI (*CritereComparaisonParAdresse)(TypUpsVmSession *Session, UpsTypPrmComparaison *UpsPrm);
   /* Objet : Critere de comparaison des arbres binaires. */
TypUpsVmUnsignedChar UpsVmAPI (*CoCritereComparaisonParAdresse)(TypUpsVmSession *Session,
   TypUpsVmShort NumeroParametre, TypUpsVmAdresse *AdresseResultat, TypPrmUpsVmEnumererParametres *UpsPrm);
   /* Objet : Critere de comparaison des arbres binaires. */
TypUpsVmVoid UpsVmAPI (*LibererIterateurPourException)(TypUpsVmSession *Session, TypUpsVmLong IndicePointDeRetour);
   /* Objet : Libere les iterateurs suite a une exception. */
TypUpsVmVoid UpsVmAPI (*AppelImpossibleApiNull)(TypUpsVmVoid);
   /* Objet : Tentative d'appel a une Api indefinie. */
TypUpsVmShort UpsVmAPI (*VerifierInterfaceTraitements)(TypUpsVmPointeurTraitements *Interface, TypUpsVmLong Taille, TypUpsVmUnicode *Module);
   /* Objet : Verifie que l'interface de traitements est bien renseignee. */
TypUpsVmShort UpsVmAPI (*VerifierInterfaceTraitementsNat)(TypUpsVmPointeurTraitements *Interface, TypUpsVmLong Taille, TypUpsVmUnicode *Module);
   /* Objet : Verifie que l'interface de traitements native est    */
   /* bien renseignee.                                             */
TypUpsVmShort UpsVmAPI (*VerifierInterfaceMethodes)(TypUpsVmPointeurTraitements *Interface, TypUpsVmLong Taille, TypUpsVmUnicode *Module);
   /* Objet : Verifie que l'interface des methodes est bien        */
   /* renseignee.                                                  */
TypUpsVmShort UpsVmAPI (*ReferencerGestionAppelTiers)(enum EnuUpsVmTypeDeTraitements TypeDeTraitements, TypUpsKrnGestionAppelTiers *GestionAppelTiers);
   /* Objet : Referencie une extension pour une technologie tierce pour la gestion des appels. */
} *TypUpsKrnTraitements_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsKrnTraitements_1_1_0 TypUpsKrnTraitements;

extern DllExport TypUpsVtmDemarrer UpsVmAPI UpsKrnDemarrerModule(TypUpsVmShort Numero, TypUpsVtmMachineInterface MachineInterfaceUpsVtm,
   TypUpsVtmTraitements IntTrtUpsVtm, TypUpsVtmDonnees IntDonUpsVtm);
   /* Objet : Retourne la description de Ups Krn. */

/**********************/
#if defined(__cplusplus)
/**********************/
}
/****/
#endif
/****/

/****/
#endif
/****/
