/*-------------------------------------------------------------------
Fichier     : upstrn.e
Objet       : En-tete du module Up ! Translator.

Module      : Up ! Translator
Auteur-Date : DUVAL Jean-Pierre - Decembre 2004.
---------------------------------------------------------------------
                         Observations

 
---------------------------------------------------------------------*/

/*****************************/
#if !defined(PasseModuleUpsTrn)
/*****************************/
#define PasseModuleUpsTrn 1

/**********************/
#if defined(__cplusplus)
/**********************/
extern "C"
{
/****/
#endif
/****/

/*--------------------------*/
/* Enumere ActionConstituer */
/*--------------------------*/
#define UpsEnuUpsTrn_1_1 1
   /* Valeur : ConstituerCreation */
#define UpsEnuUpsTrn_1_2 2
   /* Valeur : ConstituerMiseAJour */
#define UpsEnuUpsTrn_1_3 3
   /* Valeur : ConstituerSuppression */
   
/*--------------------------*/
/* Enumere FormatThesaurus */
/*--------------------------*/
#define UpsEnuUpsTrn_2_1 1
   /* Valeur : FormatThesaurusTexte */
#define UpsEnuUpsTrn_2_2 2
   /* Valeur : FormatThesaurusHtml */
#define UpsEnuUpsTrn_3_3 3
   /* Valeur : FormatThesaurusUpsTrn */
   
/****************************************************************/
/* Codification des sous-actions de l'action constituer. 	     */
/****************************************************************/
enum EnuUpsTrnActionConstituer
   {
   AC_Creation=1,
   AC_MiseAJour=2,
   AC_Suppression=3
   };

/****************************************************************/
/* Codification du mode d'ajout du message.             	       */
/****************************************************************/
enum EnuUpsTrnAjouterMessage
   {
   AM_Chargement=1,
   AM_MiseAJour=2,
   AM_Conserver=3
   };

/****************************************************************/
/* Codification du format du thesaurus.                	       */
/****************************************************************/
enum EnuUpsTrnFormatThesaurus
   {
   FT_Texte=1,
   FT_Html=2
   };

/****************************************************************/
typedef struct typupstrndonnees
/* Objet: Interface des donnees de Ups Translator.              */
/****************************************************************/
{
struct typupsvmentetedonneesmodule EnteteDonneesModule;
   /* Entete generique du module. */
} *TypUpsTrnDonnees;

/****************************************************************/
typedef struct typprmupstrn_1_1
/* Objet : Parametre de Fonction ChargerThesaurus(              */
/* NomFichierThesaurus:Caractere) Retourner Booleen;            */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomFichierThesaurus:Caractere. */
} TypPrmUpsTrn_1_1;

/****************************************************************/
typedef struct typprmupstrn_1_2
/* Objet : Fonction ChargerThesaurus(NomFichierThesaurus:       */
/* Caractere, LangueCible:LanguesSupportees, Inverser:Booleen=  */
/* Faux) Retourner Booleen;                                     */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomFichierThesaurus:Caractere. */
TypUpsVmUnsignedChar UpsVar2;
   /* LangueCible:LanguesSupportees. */
TypUpsVmUnsignedChar UpsVar3;
   /* Inverser:Booleen. */
} TypPrmUpsTrn_1_2;

/****************************************************************/
typedef struct typprmupstrn_2_1
/* Objet : Parametre de Fonction ChargerFichierMessage(         */
/* NomFichierThesaurus:Caractere) Retourner Booleen;            */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomFichierMessage:Caractere. */
} TypPrmUpsTrn_2_1;

/****************************************************************/
typedef struct typprmupstrn_3_1
/* Objet : Parametre de GenererThesaurus(NomFichierThesaurus:   */
/* Caractere, SupprimerTraductionsInutiles, EnvoyerMessage:     */
/* Procedure (LibelleSection:Caractere,MotCle:Caractere))       */
/* Retourner Booleen;                                           */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomFichierThesaurus:Caractere. */
TypUpsVmUnsignedChar UpsVar2;
   /* SupprimerTraductionsInutiles:Booleen. */
TypUpsVmAdresse UpsVar3;
   /* EnvoyerMessage:Procedure (LibelleSection:Caractere,MotCle:Caractere). */
} TypPrmUpsTrn_3_1;

/****************************************************************/
typedef struct typprmupstrn_4_1
/* Objet : Fonction TraduireFichier(NomFichier:Caractere,       */
/* LangueDepart:LanguesSupportees, LangueArrivee:               */
/* LanguesSupportees, EnvoyerMessage:Procedure (LibelleSection: */
/* Caractere,MotCle:Caractere)) Retourner Booleen Implemente;   */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomFichier:Caractere. */
TypUpsVmUnsignedChar UpsVar2;
   /* LangueDepart:LanguesSupportees. */
TypUpsVmUnsignedChar UpsVar3;
   /* LangueArrivee:LanguesSupportees. */
TypUpsVmAdresse UpsVar4;
   /* EnvoyerMessage:Procedure (LibelleSection:Caractere,MotCle:Caractere). */
} TypPrmUpsTrn_4_1;

/****************************************************************/
typedef struct typprmupstrn_5_1
/* Objet : Fonction FormaterThesaurus(NomThesaurus:Caractere,   */
/* Format:FormatThesaurus, LangueCible:LanguesSupportees,       */
/* EnvoyerMessage:Procedure (LibelleSection:Caractere,MotCle:   */
/* Caractere)) Retourner Booleen;                               */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomThesaurus:Caractere. */
TypUpsVmUnsignedChar UpsVar2;
   /* Format:FormatThesaurus. */
TypUpsVmUnsignedChar UpsVar3;
   /* LangueCible:LanguesSupportees. */
TypUpsVmAdresse UpsVar4;
   /* EnvoyerMessage:Procedure (LibelleSection:Caractere,MotCle:Caractere). */
} TypPrmUpsTrn_5_1;

/****************************************************************/
typedef struct typprmupstrn_6_1
/* Objet : Fonction FormaterInverseThesaurus(NomThesaurus:      */
/* Caractere, Format:FormatThesaurus, LangueDepart:             */
/* LanguesSupportees, LangueArrivee:LanguesSupportees           */
/* EnvoyerMessage:Procedure ( Message:Caractere),               */
/* EnvoyerMessage2:Procedure (LibelleSection: Caractere,MotCle: */
/* Caractere)) Retourner Booleen Implemente;                    */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomThesaurus:Caractere. */
TypUpsVmUnsignedChar UpsVar2;
   /* Format:FormatThesaurus. */
TypUpsVmUnsignedChar UpsVar3;
   /* LangueDepart:LanguesSupportees. */
TypUpsVmUnsignedChar UpsVar4;
   /* LangueArrivee:LanguesSupportees. */
TypUpsVmAdresse UpsVar5;
   /* EnvoyerMessage:Procedure (Message:Caractere). */
TypUpsVmAdresse UpsVar6;
   /* EnvoyerMessage2:Procedure (LibelleSection:Caractere,MotCle:Caractere). */
} TypPrmUpsTrn_6_1;

typedef TypUpsVmVoid UpsVmAPI (*TypUpsTrnEnvoyerMessageTraductionSupprimee)(TypUpsVmSession *Session, TypUpsVmUnicode *LibelleSection, TypUpsVmUnicode *MotCle);

/****************************************************************/
typedef struct typupstrntraitements_1_1_0
/* Objet: Interface des traitements de Ups Compiler.            */
/****************************************************************/
{
struct typupsvmentetemethodesmodule EnteteMethodesModule;
   /* Methodes generiques au module. */ 

/*--------------------------------------------------------------*/
/* Procedures et fonctions.                                     */
/*--------------------------------------------------------------*/
TypUpsVmLong UpsVmAPI (*CalculerIndexAppel)(TypUpsVmPointeurDonnees InterfaceAppel, TypUpsVmPointeurDonnees AppelCourant);
   /* Objet : Calcule l'index de l'appel. */
TypUpsVmUnsignedChar UpsVmAPI (*Trt_1_1)(TypUpsVmSession *Session, TypPrmUpsTrn_1_1 *UpsPrm);
   /* Objet : Fonction ChargerThesaurus(NomFichierThesaurus:Caractere) Retourner Booleen; */
TypUpsVmUnsignedChar UpsVmAPI (*Trt_1_2)(TypUpsVmSession *Session, TypPrmUpsTrn_1_2 *UpsPrm);
   /* Objet : Fonction ChargerThesaurus(NomFichierThesaurus:Caractere, LangueCible:LanguesSupportees, Inverser:Booleen=Faux) Retourner Booleen; */
TypUpsVmUnsignedChar UpsVmAPI (*Trt_2_1)(TypUpsVmSession *Session, TypPrmUpsTrn_2_1 *UpsPrm);
   /* Objet : Fonction ChargerFichierMessage(NomFichierMessage:Caractere) Retourner Booleen; */
TypUpsVmUnsignedChar UpsVmAPI (*Trt_3_1)(TypUpsVmSession *Session, TypPrmUpsTrn_3_1 *UpsPrm);
   /* Objet : Fonction GenererThesaurus(NomFichierThesaurus:Caractere, SupprimerTraductionsInutiles:Booleen, */
   /* EnvoyerMessage:Procedure (LibelleSection:Caractere,MotCle:Caractere)) Retourner Booleen; */
TypUpsVmUnsignedChar UpsVmAPI (*Trt_4_1)(TypUpsVmSession *Session, TypPrmUpsTrn_4_1 *UpsPrm);
   /* Objet : Fonction TraduireFichier(NomFichier:Caractere,       */
   /* LangueDepart:LanguesSupportees, LangueArrivee:               */
   /* LanguesSupportees, EnvoyerMessage:Procedure (LibelleSection: */
   /* Caractere,MotCle:Caractere)) Retourner Booleen Implemente;   */
TypUpsVmUnsignedChar UpsVmAPI (*Trt_5_1)(TypUpsVmSession *Session, TypPrmUpsTrn_5_1 *UpsPrm);
   /* Objet : Fonction FormaterThesaurus(NomThesaurus:Caractere, Format:FormatThesaurus, EnvoyerMessage:Procedure */
   /* (Message:Caractere)) Retourner Booleen Implemente; */
TypUpsVmUnsignedChar UpsVmAPI (*Trt_6_1)(TypUpsVmSession *Session, TypPrmUpsTrn_6_1 *UpsPrm);
   /* Objet : Fonction FormaterInverseThesaurus(NomThesaurus:      */
   /* Caractere, Format:FormatThesaurus, LangueDepart:             */
   /* LanguesSupportees, LangueArrivee:LanguesSupportees           */
   /* EnvoyerMessage:Procedure ( Message:Caractere),               */
   /* EnvoyerMessage2:Procedure (LibelleSection: Caractere,MotCle: */
   /* Caractere)) Retourner Booleen Implemente;                    */

TypUpsVmCoAppel CoTrt_1_1;
   /* Objet : Fonction ChargerThesaurus(NomFichierThesaurus:Caractere) Retourner Booleen; */
TypUpsVmCoAppel CoTrt_1_2;
   /* Objet : Fonction ChargerThesaurus(NomFichierThesaurus:Caractere, LangueCible:LanguesSupportees, Inverser:Booleen=Faux) Retourner Booleen; */
TypUpsVmCoAppel CoTrt_2_1;
   /* Objet : Fonction ChargerFichierMessage(NomFichierMessage:Caractere) Retourner Booleen; */
TypUpsVmCoAppel CoTrt_3_1;
   /* Objet : Fonction GenererThesaurus(NomFichierThesaurus:Caractere, SupprimerTraductionsInutiles:Booleen, */
   /* EnvoyerMessage:Procedure (LibelleSection:Caractere,MotCle:Caractere)) Retourner Booleen; */
TypUpsVmCoAppel CoTrt_4_1;
   /* Objet : Fonction TraduireFichier(NomFichier:Caractere,       */
   /* LangueDepart:LanguesSupportees, LangueArrivee:               */
   /* LanguesSupportees, EnvoyerMessage:Procedure (LibelleSection: */
   /* Caractere,MotCle:Caractere)) Retourner Booleen Implemente;   */
TypUpsVmCoAppel CoTrt_5_1;
   /* Objet : Fonction FormaterThesaurus(NomThesaurus:Caractere, Format:FormatThesaurus, EnvoyerMessage:Procedure */
   /* (Message:Caractere)) Retourner Booleen Implemente; */
TypUpsVmCoAppel CoTrt_6_1;
   /* Objet : Fonction FormaterInverseThesaurus(NomThesaurus:      */
   /* Caractere, Format:FormatThesaurus, LangueDepart:             */
   /* LanguesSupportees, LangueArrivee:LanguesSupportees           */
   /* EnvoyerMessage:Procedure ( Message:Caractere),               */
   /* EnvoyerMessage2:Procedure (LibelleSection: Caractere,MotCle: */
   /* Caractere)) Retourner Booleen Implemente;                    */

/*--------------------------------------------------------------*/
/* Tables des methodes.                                         */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Enumeres.			              				                   */
/*--------------------------------------------------------------*/
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_1_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_1_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* ActionConstituer. */
TypUpsVmUnsignedChar UpsVmAPI (*TrtEnu_2_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsPrm);
TypUpsVmAdresse UpsVmAPI *(*TrtEnu_2_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmUnsignedChar UpsPrm);
   /* FormatThesarus. */

/*--------------------------------------------------------------*/
/* Entrepots.          								                   */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Types et interfaces.                                         */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Variables globales.                                          */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Exceptions.                                                  */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*UpsException1_get)(TypUpsVmSession *Session);
   /* Exception ExtensionNomFichierInconnue. */
TypUpsVmAdresse UpsVmAPI *(*UpsException2_get)(TypUpsVmSession *Session);
   /* Exception SousRepertoireNonReconnu. */

/*--------------------------------------------------------------*/
/* Files d'attente.                                             */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Application Program Interfaces proprietaires.                */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*ChargerFichierMessage)(TypUpsVmSession *Session, TypUpsVmUnicode *NomFichierMessage);
   /* Objet : Charge le fichier de messages. */
TypUpsVmShort UpsVmAPI (*AjouterMessageModule)(TypUpsVmSession *Session, enum EnuUpsNlsSection Section, TypUpsVmUnicode *MotCle, 
   TypUpsVmUnicode *Message, enum EnuUpsTrnAjouterMessage Mode);
   /* Objet : Ajoute un message a la table des messages s'il n'existe pas encore. */
TypUpsVmShort UpsVmAPI (*GenererMessageModule)(TypUpsVmSession *Session, TypUpsVmUnicode *NomFichierMessage, TypUpsVmShort SupprimerAnciens, 
   TypUpsTrnEnvoyerMessageTraductionSupprimee EnvoyerMessageTraductionSupprimee);
   /* Objet : Genere les messages d'un module. */
} *TypUpsTrnTraitements_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsTrnTraitements_1_1_0 TypUpsTrnTraitements;

extern TypUpsVtmMachineInterface UpsTrnMachineInterfaceUpsVtm;
   /* Interface avec la machine pour Ups Vtm. */

extern DllExport TypUpsVtmDemarrer UpsVmAPI UpsTrnDemarrerModule(TypUpsVmShort Numero, TypUpsVtmMachineInterface MachineInterfaceUpsVtm,
   TypUpsVtmTraitements IntTrtUpsVtm, TypUpsVtmDonnees IntDonUpsVtm);
   /* Procedure de demarrage de Ups Trn. */

/**********************/
#if defined(__cplusplus)
/**********************/
}
/****/
#endif
/****/

/****/
#endif
/****/

