/*-------------------------------------------------------------------
Fichier     : upstcp.e
Objet       : En-tete de upstcp

Module      : Up ! Tcp
Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.
---------------------------------------------------------------------
                         Observations

 
---------------------------------------------------------------------*/

/*****************************/
#if !defined(PasseModuleUpsTcp)
/*****************************/
#define PasseModuleUpsTcp 1

/**********************/
#if defined(__cplusplus)
/**********************/
extern "C"
{
/****/
#endif
/****/

/****************************************************************/
typedef struct typupstcpcanal
/* Objet: Informations specifiques pour la communication selon  */
/* un canal Tcp-Ip.                                             */
/****************************************************************/
{
TypUpsNetCanal *Canal;
   /* Canal etendu. */
TypUpsVmLong Ip1;
   /* Adresse Ip, octet 1. */
TypUpsVmLong Ip2;
   /* Adresse Ip, octet 2. */
TypUpsVmLong Ip3;
   /* Adresse Ip, octet 3. */
TypUpsVmLong Ip4;
   /* Adresse Ip, octet 4. */
TypUpsVmLong Port;
   /* Port de la Canal. */
TypUpsVmPointeurDonnees Socquette;
   /* Soquette si elle est ouverte. */
enum EnuUpsVmTailleBuffer TailleBuffer;
   /* Taille du buffer. */
} TypUpsTcpCanal;

/*******************************************************************/
typedef struct typupstcpmachineinterface_1_1_0
/* Objet : Interface avec la machine pour Up ! Tcp.                */ 
/*******************************************************************/
{
TypUpsVmShort UpsVmAPI (*Ouvrir)(TypUpsVmSession *Session, enum EnuUpsVmTailleBuffer, TypUpsTcpCanal *Canal);
   /* Objet : Ouvre la socquette. */
TypUpsVmShort UpsVmAPI (*EcouterClients)(TypUpsVmSession *Session, TypUpsTcpCanal *Canal, TypUpsVmShort NbClients);
   /* Objet : Configure la socquette pour traiter au plus NbClients. */
TypUpsVmShort UpsVmAPI (*AccepterUnClient)(TypUpsVmSession *Session, TypUpsTcpCanal *CanalServeur, TypUpsTcpCanal *CanalClient);
   /* Objet : Configure la socquette pour qu'elle traite un nouveau client. */
TypUpsVmShort UpsVmAPI (*Connecter)(TypUpsVmSession *Session, TypUpsTcpCanal *CanalClient, TypUpsTcpCanal *CanalServeur);
   /* Objet : Configure la socquette pour qu'il traite avec un nouveau serveur. */
TypUpsVmShort UpsVmAPI (*Lire)(TypUpsVmSession *Session, TypUpsTcpCanal *Canal, TypUpsVmChar *Buffer, TypUpsVmLong TailleALire, 
	TypUpsVmLong *TailleLue, TypUpsVmShort TailleImposee);
   /* Objet : Lecture par paquet. */
TypUpsVmShort UpsVmAPI (*Ecrire)(TypUpsVmSession *Session, TypUpsTcpCanal *Canal, TypUpsVmChar *Buffer, TypUpsVmLong TailleAEcrire, 
   TypUpsVmLong *TailleEcrite);
   /* Objet : Ecriture par paquet. */
TypUpsVmShort UpsVmAPI (*Fermer)(TypUpsVmSession *Session, TypUpsTcpCanal *Canal);
   /* Objet : Ferme la socquette. */
TypUpsVmShort UpsVmAPI (*Detruire)(TypUpsVmSession *Session, TypUpsTcpCanal *Canal);
   /* Objet : Detruit la socquette. */
TypUpsVmUnicode UpsVmAPI *(*LireNomFichierHosts)(TypUpsVmVoid);
   /* Objet : Lit le nom du fichier host avec son chemin. */
TypUpsVmUnicode UpsVmAPI *(*LireNomFichierServices)(TypUpsVmVoid);
   /* Objet : Lit le nom du fichier services avec son chemin. */
} *TypUpsTcpMachineInterface_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsTcpMachineInterface_1_1_0 TypUpsTcpMachineInterface;

/****************************************************************/
typedef struct upstypupstcp_1_1_1_0
/* Objet : Proprietes du type CanalTcpIp.                       */
/****************************************************************/
{
TypUpsVmAdresse UpsObjet1;
   /* Objet pour le canal; */
TypUpsNetCanal Canal;
   /* Canal pour la tache. */
TypUpsNetCanal CanalClient;
   /* Canal pour la lecture/ecriture quand on a accepte un client. */
TypUpsVmLong Taille;
   /* Taille du buffer du canal. */
TypUpsVmShort PageDeCode;
   /* Page de code. */
} UpsTypUpsTcp_1_1_1_0;

/****************************************************************/
typedef struct typprmupstcp_1_4_2
/* Objet : Parametre de CanalTcpIp.Constructeur(NomDuCanal:     */
/* Caractere, Port:Entier=0, TailleBufferIO:Entier=-1);         */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomDuCanal: Caractere. */
TypUpsVmLong UpsVar2;
   /* Port:Entier; */
TypUpsVmLong UpsVar3;
   /* TailleBufferIO:Entier; */
} TypPrmUpsTcp_1_4_2;

/****************************************************************/
typedef struct typprmupstcp_1_14_1
/* Objet : Parametre de CanalTcpIp.ServirDesClients(			    */
/* NbClientsMax: Entier);                                       */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* NbClientsMax:Entier; */
} TypPrmUpsTcp_1_14_1;

/****************************************************************/
typedef struct typprmupstcp_1_15_1
/* Objet : Parametre de CanalTcpIp.AccepterUnClient(Port:		 */
/* Entier);														             */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Port:Entier; */
} TypPrmUpsTcp_1_15_1;

/****************************************************************/
typedef struct typprmupstcp_1_15_2
/* Objet : Parametre de CanalTcpIp.AccepterUnClient(Port:Entier */
/* Sortie, AdresseIp1: Entier Sortie, AdresseIp2:Entier Sortie, */
/* AdresseIp3:Entier Sortie, AdresseIp4:Entier Sortie);         */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Port:Entier; */
TypUpsVmLong UpsVar2;
   /* AdresseIp1:Entier; */
TypUpsVmLong UpsVar3;
   /* AdresseIp2:Entier; */
TypUpsVmLong UpsVar4;
   /* AdresseIp3:Entier; */
TypUpsVmLong UpsVar5;
   /* AdresseIp4:Entier; */
} TypPrmUpsTcp_1_15_2;

/****************************************************************/
typedef struct typprmupstcp_1_16_1
/* Objet : Parametre de CanalTcpIp.TenterDAccepterUnClient(     */
/* Port:Entier Sortie);                                         */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Port:Entier; */
} TypPrmUpsTcp_1_16_1;

/****************************************************************/
typedef struct typprmupstcp_1_16_2
/* Objet : Parametre de CanalTcpIp.TenterDAccepterUnClient(     */
/* Port:Entier Sortie, AdresseIp1:Entier Sortie, AdresseIp2:    */
/* Entier Sortie, AdresseIp3:Entier Sortie, AdresseIp4:Entier   */
/* Sortie, Port: Entier Sortie);                                */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Port:Entier; */
TypUpsVmLong UpsVar2;
   /* AdresseIp1:Entier; */
TypUpsVmLong UpsVar3;
   /* AdresseIp2:Entier; */
TypUpsVmLong UpsVar4;
   /* AdresseIp3:Entier; */
TypUpsVmLong UpsVar5;
   /* AdresseIp4:Entier; */
} TypPrmUpsTcp_1_16_2;

/****************************************************************/
typedef struct typprmupstcp_1_17_1
/* Objet : Parametre de CanalTcpIp.ConnecterAUnServeur(Port:	*/
/* Entier, AdresseIp1:Entier=0, AdresseIp2:Entier=0, AdresseIp3:*/
/* Entier=0, AdresseIp4:Entier=0)                               */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Port:Entier. */
TypUpsVmLong UpsVar2;
   /* AdresseIp1:Entier; */
TypUpsVmLong UpsVar3;
   /* AdresseIp2:Entier; */
TypUpsVmLong UpsVar4;
   /* AdresseIp3:Entier; */
TypUpsVmLong UpsVar5;
   /* AdresseIp4:Entier; */
} TypPrmUpsTcp_1_17_1;

/****************************************************************/
typedef struct typprmupstcp_1_17_2
/* Objet : Parametre de CanalTcpIp.ConnecterAUnServeur(			*/
/* NomDuPort:Caractere, NomDuServeur:Caractere="")              */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomDuPort:Caractere. */
TypUpsVmAdresse UpsVar2;
   /* NomDuServeur:Caractere. */
} TypPrmUpsTcp_1_17_2;

/****************************************************************/
typedef struct upstrttypupstcp_1_1_1_0
/* Objet : Methodes du type CanalTcpIp.                         */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

/*--------------------------------------------------------------*/
/* Methodes heritees de Flux.                                   */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*Mth_4_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsTcp_1_4_2 *UpsPrm);
   /* Constructeur(NomDuCanal:Caractere, Port:Entier=0, TailleBufferIO:Entier=-1); */
TypUpsVmVoid UpsVmAPI (*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_5_1 *UpsPrm);
   /* Procedure Lire(B:Booleen Sortie); */
TypUpsVmAdresse UpsVmAPI *(*Mth_5_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_5_2 *UpsPrm);
   /* Fonction Lire(C:Binaire Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_5_3)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_5_3 *UpsPrm);
   /* Fonction Lire(C:Caractere Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmVoid UpsVmAPI (*Mth_5_4)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_5_4 *UpsPrm);
   /* Procedure Lire(E:Entier Sortie); */
TypUpsVmVoid UpsVmAPI (*Mth_5_5)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_5_5 *UpsPrm);
   /* Procedure Lire(R:Reel Sortie); */
TypUpsVmAdresse UpsVmAPI *(*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_6_1 *UpsPrm);
   /* Fonction LireUneLigne(C:Nul Ou Caractere Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_7_1 *UpsPrm);
   /* Fonction LireUnMot(C:Nul Ou Caractere Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmVoid UpsVmAPI (*Mth_8_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_8_1 *UpsPrm);
   /* Procedure Ecrire(B:Nul Ou Booleen); */
TypUpsVmVoid UpsVmAPI (*Mth_8_2)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_8_2 *UpsPrm);
   /* Procedure Ecrire(C:Nul Ou Binaire); */
TypUpsVmVoid UpsVmAPI (*Mth_8_3)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_8_3 *UpsPrm);
   /* Procedure Ecrire(C:Nul Ou Caractere); */
TypUpsVmVoid UpsVmAPI (*Mth_8_4)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_8_4 *UpsPrm);
   /* Procedure Ecrire(E:Nul Ou Entier); */
TypUpsVmVoid UpsVmAPI (*Mth_8_5)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_8_5 *UpsPrm);
   /* Procedure Ecrire(R:Nul Ou Reel); */
TypUpsVmVoid UpsVmAPI (*Mth_9_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Procedure Fermer(); */
TypUpsVmUnsignedChar UpsVmAPI (*Mth_10_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Objet : LirePageDeCode() Retourner PagesDeCodesSupportees. */ 
TypUpsVmVoid UpsVmAPI (*Mth_11_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_11_1 *UpsPrm);
   /* Objet : ChangerPageDeCode(P:PagesDeCodesSupportees). */ 
/*--------------------------------------------------------------*/
/* Methodes heritees de Canal.                                  */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*Mth_12_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmAdresse *AdresseObjet);
   /* Fonction Protocole() Retourner Caractere; */
TypUpsVmAdresse UpsVmAPI *(*Mth_13_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmAdresse *AdresseObjet, TypPrmUpsNet_1_13_1 *UpsPrm);
   /* Fonction Adresse(CanalDuClient:Booleen=Faux) Retourner Caractere; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*Mth_14_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsTcp_1_14_1 *UpsPrm);
   /* Procedure ServirDesClients(NbClientsMax:Entier); */
TypUpsVmVoid UpsVmAPI (*Mth_15_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsTcp_1_15_1 *UpsPrm);
   /* Procedure AccepterUnClient(Port:Entier Sortie); */
TypUpsVmVoid UpsVmAPI (*Mth_15_2)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsTcp_1_15_2 *UpsPrm);
   /* Procedure AccepterUnClient(Port:Entier Sortie,AdresseIp1:Entier Sortie, AdresseIp2:Entier Sortie,
      AdresseIp3:Entier Sortie, AdresseIp4:Entier Sortie); */
TypUpsVmUnsignedChar UpsVmAPI (*Mth_16_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsTcp_1_16_1 *UpsPrm);
   /* Fonction TenterDAccepterUnClient(Port:Entier Sortie) Retourner Booleen; */
TypUpsVmUnsignedChar UpsVmAPI (*Mth_16_2)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsTcp_1_16_2 *UpsPrm);
   /* Fonction TenterDAccepterUnClient(Port:Entier Sortie, AdresseIp1:Entier Sortie, AdresseIp2:Entier Sortie,
      AdresseIp3:Entier Sortie, AdresseIp4:Entier Sortie) Retourner Booleen; */
TypUpsVmVoid UpsVmAPI (*Mth_17_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsTcp_1_17_1 *UpsPrm);
   /* Procedure ConnecterAUnServeur(Port:Entier, AdresseIp1:Entier=0, AdresseIp2:Entier=0, 
      AdresseIp3:Entier=0, AdresseIp4:Entier=0); */
TypUpsVmVoid UpsVmAPI (*Mth_17_2)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsTcp_1_17_2 *UpsPrm);
   /* Procedure ConnecterAUnServeur(NomDuPort:Caractere, NomDuServeur:Caractere=""); */

/*--------------------------------------------------------------*/
/* Methodes heritees de Flux.                                   */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_4_2;
   /* Constructeur(NomDuCanal:Caractere, Port:Entier=0, TailleBufferIO:Entier=-1); */
TypUpsVmCoAppel CoMth_5_1;
   /* Procedure Lire(B:Booleen Sortie); */
TypUpsVmCoAppel CoMth_5_2;
   /* Fonction Lire(C:Binaire Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_5_3;
   /* Fonction Lire(C:Caractere Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_5_4;
   /* Procedure Lire(E:Entier Sortie); */
TypUpsVmCoAppel CoMth_5_5;
   /* Procedure Lire(R:Reel Sortie); */
TypUpsVmCoAppel CoMth_6_1;
   /* Fonction LireUneLigne(C:Nul Ou Caractere Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_7_1;
   /* Fonction LireUnMot(C:Nul Ou Caractere Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_8_1;
   /* Procedure Ecrire(B:Nul Ou Booleen); */
TypUpsVmCoAppel CoMth_8_2;
   /* Procedure Ecrire(C:Nul Ou Binaire); */
TypUpsVmCoAppel CoMth_8_3;
   /* Procedure Ecrire(C:Nul Ou Caractere); */
TypUpsVmCoAppel CoMth_8_4;
   /* Procedure Ecrire(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_8_5;
   /* Procedure Ecrire(R:Nul Ou Reel); */
TypUpsVmCoAppel CoMth_9_1;
   /* Procedure Fermer(); */
TypUpsVmCoAppel CoMth_10_1;
   /* Objet : LirePageDeCode() Retourner PagesDeCodesSupportees. */ 
TypUpsVmCoAppel CoMth_11_1;
   /* Objet : ChangerPageDeCode(P:PagesDeCodesSupportees). */ 
/*--------------------------------------------------------------*/
/* Methodes heritees de Canal.                                  */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_12_1;
   /* Fonction Protocole() Retourner Caractere; */
TypUpsVmCoAppel CoMth_13_1;
   /* Fonction Adresse(CanalDuClient:Booleen=Faux) Retourner Caractere; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_14_1;
   /* Procedure ServirDesClients(NbClientsMax:Entier, Port:Entier); */
TypUpsVmCoAppel CoMth_15_1;
   /* Procedure AccepterUnClient(Port:Entier Sortie); */
TypUpsVmCoAppel CoMth_15_2;
   /* Procedure AccepterUnClient(Port:Entier Sortie,AdresseIp1:Entier Sortie, AdresseIp2:Entier Sortie,
      AdresseIp3:Entier Sortie, AdresseIp4:Entier Sortie); */
TypUpsVmCoAppel CoMth_16_1;
   /* Fonction TenterDAccepterUnClient(Port:Entier Sortie) Retourner Booleen; */
TypUpsVmCoAppel CoMth_16_2;
   /* Fonction TenterDAccepterUnClient(Port:Entier Sortie, AdresseIp1:Entier Sortie, AdresseIp2:Entier Sortie,
      AdresseIp3:Entier Sortie, AdresseIp4:Entier Sortie) Retourner Booleen; */
TypUpsVmCoAppel CoMth_17_1;
   /* Procedure ConnecterAUnServeur(Port:Entier, AdresseIp1:Entier=0, AdresseIp2:Entier=0, 
      AdresseIp3:Entier=0, AdresseIp4:Entier=0); */
TypUpsVmCoAppel CoMth_17_2;
   /* Procedure ConnecterAUnServeur(NomDuPort:Caractere, NomDuServeur:Caractere=""); */
} UpsTrtTypUpsTcp_1_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsTcp_1_1_1_0 UpsTypUpsTcp_1;
typedef UpsTrtTypUpsTcp_1_1_1_0 UpsTrtTypUpsTcp_1;

/****************************************************************/
typedef struct typprmupstcp_1_1
/* Objet : ConvertirAdresseTcpIpEnNom(Ip1:Entier, Ip2:Entier, Ip3: */
/* Entier, Ip4:Entier) Retourner Nul Ou Caractere               */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Ip1:Entier. */
TypUpsVmLong UpsVar2;
   /* Ip2:Entier. */
TypUpsVmLong UpsVar3;
   /* Ip3:Entier. */
TypUpsVmLong UpsVar4;
   /* Ip4:Entier. */
} TypPrmUpsTcp_1_1;

/****************************************************************/
typedef struct typprmupstcp_2_1
/* Objet : ConvertirNomEnAdresseTcpIp(Nom:Caractere, Ip1:Entier */
/* Sortie, Ip2:Entier Sortie, Ip3:Entier Sortie, Ip4:Entier     */
/* Sortie) Retourner Booleen                                    */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Nom:Caractere. */
TypUpsVmLong UpsVar2;
   /* Ip1:Entier. */
TypUpsVmLong UpsVar3;
   /* Ip2:Entier. */
TypUpsVmLong UpsVar4;
   /* Ip3:Entier. */
TypUpsVmLong UpsVar5;
   /* Ip4:Entier. */
} TypPrmUpsTcp_2_1;

/****************************************************************/
typedef struct typprmupstcp_3_1
/* Objet : ConvertirPortTcpIpEnNom(Port:Entier) Retourner Nul   */
/* Ou Caractere                                                 */
/****************************************************************/
{
TypUpsVmLong UpsVar1;
   /* Port:Entier. */
} TypPrmUpsTcp_3_1;

/****************************************************************/
typedef struct typprmupstcp_4_1
/* Objet : ConvertirNomEnPortTcpIp(Nom:Caractere, Port:Entier   */
/* Sortie) Retourner Booleen                                    */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* Nom:Caractere. */
TypUpsVmLong UpsVar2;
   /* Port:Entier. */
} TypPrmUpsTcp_4_1;

/****************************************************************/
typedef struct typupstcpdonnees
/* Objet: Interface des donnees de Ups Tcp.                     */
/****************************************************************/
{
struct typupsnetxdonnees InterfaceUpsNet;
   /* Interface de Ups Net. */

TypUpsVmLong PortUpsOrb;
   /* Port du serveur local UpsOrb. */
TypUpsVmLong PortUpsOrbMaitre;
   /* Port du serveur maitre UpsOrb. */
TypUpsVmLong PortServeur;
   /* Port des serveurs via le scrutateur. */
TypUpsVmLong Port;
   /* Premier port utilisable par Ups Tcp. */
} *TypUpsTcpDonnees;

/****************************************************************/
typedef struct typupstcptraitements_1_1_0
/* Objet: Interface des traitements de Ups Tcp.                 */
/****************************************************************/
{
struct typupsnetxtraitements_1_1_0 InterfaceUpsNet;
   /* Interface de Ups Net. */

/*--------------------------------------------------------------*/
/* Procedures et fonctions.                                     */
/*--------------------------------------------------------------*/
TypUpsVmLong UpsVmAPI (*CalculerIndexAppel)(TypUpsVmPointeurDonnees InterfaceAppel, TypUpsVmPointeurDonnees AppelCourant);
   /* Objet : Calcule l'index de l'appel. */
TypUpsVmAdresse UpsVmAPI *(*Trt_1_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsResultat, TypPrmUpsTcp_1_1 *UpsPrm);
   /* Fonction ConvertirAdresseTcpIpEnNom(Ip1:Entier, Ip2:Entier, Ip3:Entier, Ip4:Entier) Retourner Nul Ou Caractere; */
TypUpsVmUnsignedChar UpsVmAPI (*Trt_2_1)(TypUpsVmSession *Session, TypPrmUpsTcp_2_1 *UpsPrm);
   /* Fonction ConvertirNomEnAdresseTcpIp(Nom:Caractere, Ip1:Entier Sortie, Ip2:Entier Sortie, 
   Ip3:Entier Sortie, Ip4:Entier Sortie) Retourner Booleen Implemente; */
TypUpsVmAdresse UpsVmAPI *(*Trt_3_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsResultat, TypPrmUpsTcp_3_1 *UpsPrm);
   /* Fonction ConvertirPortTcpIpEnNom(Port:Entier) Retourner Nul Ou Caractere; */
TypUpsVmUnsignedChar UpsVmAPI (*Trt_4_1)(TypUpsVmSession *Session, TypPrmUpsTcp_4_1 *UpsPrm);
   /* Fonction ConvertirNomEnPortTcpIp(Nom:Caractere, Port:Entier Sortie) Retourner Booleen Implemente; */

TypUpsVmCoAppel CoTrt_1_1;
   /* Fonction ConvertirAdresseTcpIpEnNom(Ip1:Entier, Ip2:Entier, Ip3:Entier, Ip4:Entier) Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoTrt_2_1;
   /* Fonction ConvertirNomEnAdresseTcpIp(Nom:Caractere, Ip1:Entier Sortie, Ip2:Entier Sortie, 
   Ip3:Entier Sortie, Ip4:Entier Sortie) Retourner Booleen Implemente; */
TypUpsVmCoAppel CoTrt_3_1;
   /* Fonction ConvertirPortTcpIpEnNom(Port:Entier) Retourner Nul Ou Caractere; */
TypUpsVmCoAppel CoTrt_4_1;
   /* Fonction ConvertirNomEnPortTcpIp(Nom:Caractere, Port:Entier Sortie) Retourner Booleen Implemente; */

/*--------------------------------------------------------------*/
/* Tables des methodes.                                         */
/*--------------------------------------------------------------*/
UpsTrtTypUpsTcp_1 *UpsTrt1;
   /* Methodes de CanalTcpIp. */ 
UpsTrtTypUpsNet_1 *UpsTrt1_1;
   /* Methodes de CanalTcpIp.Canal. */ 
UpsTrtTypUpsSys_12 *UpsTrt1_1_1;
   /* Methodes de CanalTcpIp.Canal.Flux. */ 

/*--------------------------------------------------------------*/
/* Enumeres.			              				                   */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Entrepots.          								                   */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Types et interfaces.                                         */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*UpsType1_get)(TypUpsVmSession *Session);
   /* Type CanalTcpIp. */
TypUpsVmLong UpsVmAPI (*UpsIndex1_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type CanalTcpIp. */ 

/*--------------------------------------------------------------*/
/* Variables globales.                                          */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Exceptions.                                                  */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Files d'attente.                                             */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Application Program Interfaces proprietaires.                */
/*--------------------------------------------------------------*/
TypUpsTcpMachineInterface UpsVmAPI (*LireMachineInterface)(TypUpsVmVoid);
   /* Objet : Retrouve l'interface machine pour Ups Tcp. */
TypUpsVmShort UpsVmAPI (*ConvertirNomEnAdresseTcpIp)(TypUpsVmSession *Session, TypUpsVmUnicode *Nom, TypUpsVmLong *Ip1, TypUpsVmLong *Ip2, 
   TypUpsVmLong *Ip3, TypUpsVmLong *Ip4);
   /* Objet : Convertit une adresse Ip en son nom. */
TypUpsVmShort UpsVmAPI (*ConvertirAdresseTcpIpEnNom)(TypUpsVmSession *Session, TypUpsVmUnicode *Nom, TypUpsVmLong Ip1, TypUpsVmLong Ip2, 
   TypUpsVmLong Ip3, TypUpsVmLong Ip4);
   /* Objet : Convertit une adresse Ip en son nom. */
TypUpsVmShort UpsVmAPI (*ConvertirNomEnPortTcpIp)(TypUpsVmSession *Session, TypUpsVmUnicode *Nom, TypUpsVmLong *Port);
   /* Objet : Convertit un port Tcp-Ip en son nom. */
TypUpsVmShort UpsVmAPI (*ConvertirPortTcpIpEnNom)(TypUpsVmSession *Session, TypUpsVmUnicode *Nom, TypUpsVmLong Port);
   /* Objet : Convertit un port Tcp-Ip en son nom. */
} *TypUpsTcpTraitements_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsTcpTraitements_1_1_0 TypUpsTcpTraitements;

extern DllExport TypUpsVtmDemarrer UpsVmAPI UpsTcpDemarrerModule(TypUpsVmShort Numero, TypUpsVtmMachineInterface MachineInterfaceUpsVtm,
   TypUpsVtmTraitements IntTrtUpsVtm, TypUpsVtmDonnees IntDonUpsVtm);
   /* Objet : Retourne la description de Ups Tcp. */

/**********************/
#if defined(__cplusplus)
/**********************/
}
/****/
#endif
/****/

/****/
#endif
/****/
