/*-------------------------------------------------------------------
Fichier     : upsnap_nt.e
Objet       : En-tete de Up ! Tuyau nomme

Module      : Up ! Tuyau nomme
Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.
---------------------------------------------------------------------
                        Observations
                   
---------------------------------------------------------------------*/ 

/********************************/
#if !defined(PasseModuleUpsNapNat)
/********************************/
#define PasseModuleUpsNapNat 1

/**********************/
#if defined(__cplusplus)
/**********************/
extern "C"
{
/****/
#endif
/****/

/****************************/
#if defined(PLATEFORMEWINDOWS)
/****************************/
/****************************************************************/
typedef struct typupsnapoverlapped
/* Objet: Structure OVERLAPPED.                                 */
/****************************************************************/
{
TypUpsVmUnsignedLong Internal; 
TypUpsVmUnsignedLong InternalHigh; 
TypUpsVmUnsignedLong Offset; 
TypUpsVmUnsignedLong OffsetHigh; 
TypUpsVmPointeurDonnees hEvent; 
} TypUpsNapOverlapped; 
/****/
#endif
/****/

/****************************************************************/
typedef struct typupsnapnattraitements_1_1_0
/* Objet: Interface des traitements de Ups Nap Nat.             */
/****************************************************************/
{
/******************************/
#if defined(PLATEFORMEMACINTOSH)
/******************************/
TypUpsVmShort UpsVmAPI (*Close)(TypUpsVmPointeurDonnees Tuyau);
   /* Objet : close(). */
TypUpsVmLong UpsVmAPI (*Errno)(TypUpsVmVoid);
   /* Objet : errno. */
TypUpsVmShort UpsVmAPI (*FCntl)(TypUpsVmPointeurDonnees hNamedPipe, enum EnuUpsVmTailleBuffer TailleBuffer, TypUpsVmShort Bloquer);
   /* Objet : FCntl(). */
TypUpsVmShort UpsVmAPI (*MkNod)(TypUpsVmChar *NomNoeud, TypUpsVmLong Mode);
   /* Objet : mknod(). */
TypUpsVmPointeurDonnees UpsVmAPI (*Open)(TypUpsVmChar *Fichier);
   /* Objet : open(). */
TypUpsVmLong UpsVmAPI (*Read)(TypUpsVmPointeurDonnees Tuyau, TypUpsVmPointeurDonnees Buffer, TypUpsVmLong TailleALire, 
   TypUpsVmLong *TailleLue, TypUpsVmShort *Again);
   /* Objet : read(). */
TypUpsVmLong UpsVmAPI (*Write)(TypUpsVmPointeurDonnees Tuyau, TypUpsVmPointeurDonnees Buffer, TypUpsVmLong TailleAEcrire, 
   TypUpsVmLong *TailleEcrite, TypUpsVmShort *Again);
   /* Objet : write(). */
/****/
#endif
/****/
/**************************/
#if defined(PLATEFORMEOS390)
/**************************/
TypUpsVmShort UpsVmAPI (*Close)(TypUpsVmPointeurDonnees Tuyau);
   /* Objet : close(). */
TypUpsVmLong UpsVmAPI (*Errno)(TypUpsVmVoid);
   /* Objet : errno. */
TypUpsVmShort UpsVmAPI (*FCntl)(TypUpsVmPointeurDonnees hNamedPipe, enum EnuUpsVmTailleBuffer TailleBuffer, TypUpsVmShort Bloquer);
   /* Objet : FCntl(). */
TypUpsVmShort UpsVmAPI (*MkNod)(TypUpsVmChar *NomNoeud, TypUpsVmLong Mode);
   /* Objet : mknod(). */
TypUpsVmPointeurDonnees UpsVmAPI (*Open)(TypUpsVmChar *Fichier);
   /* Objet : open(). */
TypUpsVmLong UpsVmAPI (*Read)(TypUpsVmPointeurDonnees Tuyau, TypUpsVmPointeurDonnees Buffer, TypUpsVmLong TailleALire, 
   TypUpsVmLong *TailleLue, TypUpsVmShort *Again);
   /* Objet : read(). */
TypUpsVmLong UpsVmAPI (*Write)(TypUpsVmPointeurDonnees Tuyau, TypUpsVmPointeurDonnees Buffer, TypUpsVmLong TailleAEcrire, 
   TypUpsVmLong *TailleEcrite, TypUpsVmShort *Again);
   /* Objet : write(). */
/****/
#endif
/****/
/**************************/
#if defined(PLATEFORMEOS400)
/**************************/
TypUpsVmShort UpsVmAPI (*Close)(TypUpsVmPointeurDonnees Tuyau);
   /* Objet : close(). */
TypUpsVmLong UpsVmAPI (*Errno)(TypUpsVmVoid);
   /* Objet : errno. */
TypUpsVmShort UpsVmAPI (*FCntl)(TypUpsVmPointeurDonnees hNamedPipe, enum EnuUpsVmTailleBuffer TailleBuffer, TypUpsVmShort Bloquer);
   /* Objet : FCntl(). */
TypUpsVmShort UpsVmAPI (*MkNod)(TypUpsVmChar *NomNoeud, TypUpsVmLong Mode);
   /* Objet : mknod(). */
TypUpsVmPointeurDonnees UpsVmAPI (*Open)(TypUpsVmChar *Fichier);
   /* Objet : open(). */
TypUpsVmLong UpsVmAPI (*Read)(TypUpsVmPointeurDonnees Tuyau, TypUpsVmPointeurDonnees Buffer, TypUpsVmLong TailleALire, 
   TypUpsVmLong *TailleLue, TypUpsVmShort *Again);
   /* Objet : read(). */
TypUpsVmLong UpsVmAPI (*Write)(TypUpsVmPointeurDonnees Tuyau, TypUpsVmPointeurDonnees Buffer, TypUpsVmLong TailleAEcrire, 
   TypUpsVmLong *TailleEcrite, TypUpsVmShort *Again);
   /* Objet : write(). */
/****/
#endif
/****/
/*************************/
#if defined(PLATEFORMEUNIX)
/*************************/
TypUpsVmShort UpsVmAPI (*Close)(TypUpsVmPointeurDonnees Tuyau);
   /* Objet : close(). */
TypUpsVmLong UpsVmAPI (*Errno)(TypUpsVmVoid);
   /* Objet : errno. */
TypUpsVmShort UpsVmAPI (*FCntl)(TypUpsVmPointeurDonnees hNamedPipe, enum EnuUpsVmTailleBuffer TailleBuffer, TypUpsVmShort Bloquer);
   /* Objet : FCntl(). */
TypUpsVmShort UpsVmAPI (*MkNod)(TypUpsVmChar *NomNoeud, TypUpsVmLong Mode);
   /* Objet : mknod(). */
TypUpsVmPointeurDonnees UpsVmAPI (*Open)(TypUpsVmChar *Fichier);
   /* Objet : open(). */
TypUpsVmLong UpsVmAPI (*Read)(TypUpsVmPointeurDonnees Tuyau, TypUpsVmPointeurDonnees Buffer, TypUpsVmLong TailleALire, 
   TypUpsVmLong *TailleLue, TypUpsVmShort *Again);
   /* Objet : read(). */
TypUpsVmLong UpsVmAPI (*Write)(TypUpsVmPointeurDonnees Tuyau, TypUpsVmPointeurDonnees Buffer, TypUpsVmLong TailleAEcrire, 
   TypUpsVmLong *TailleEcrite, TypUpsVmShort *Again);
   /* Objet : write(). */
/****/
#endif
/****/
/****************************/
#if defined(PLATEFORMEWINDOWS)
/****************************/
TypUpsVmShort UpsVmAPI (*CloseHandle)(TypUpsVmPointeurDonnees hObject);
   /* Objet : CloseHandle(). */
TypUpsVmShort UpsVmAPI (*ConnectNamedPipe)(TypUpsVmPointeurDonnees hNamedPipe, TypUpsNapOverlapped *lpOverlapped, TypUpsVmShort *Listening);
   /* Objet : ConnectNamedPipe(). */
TypUpsVmPointeurDonnees UpsVmAPI (*CreateFile)(TypUpsVmChar *lpName);
   /* Objet : CreateFile(). */
TypUpsVmPointeurDonnees  UpsVmAPI (*CreateNamedPipe)(TypUpsVmChar *lpName, TypUpsVmShort NbClients, TypUpsVmLong TailleBufferIO, TypUpsVmLong nDefaultTimeOut);
   /* Objet : CreateNamedPipe(). */
TypUpsVmShort UpsVmAPI (*DisconnectNamedPipe)(TypUpsVmPointeurDonnees hNamedPipe);
   /* Objet : DisconnectNamedPipe(). */
TypUpsVmLong UpsVmAPI (*GetLastError)(TypUpsVmVoid);
   /* Objet : GetLastError(). */
TypUpsVmShort UpsVmAPI (*ReadFile)(TypUpsVmPointeurDonnees hFile, TypUpsVmPointeurDonnees lpBuffer, TypUpsVmLong nNumberOfBytesToRead, TypUpsVmLong *lpNumberOfBytesRead,
   TypUpsNapOverlapped *lpOverlapped, TypUpsVmShort *Pending);
   /* Objet : ReadFile(). */
TypUpsVmShort UpsVmAPI (*SetNamedPipeHandleState)(TypUpsVmPointeurDonnees hNamedPipe, enum EnuUpsVmTailleBuffer TailleBuffer, 
   TypUpsVmShort Bloquer);
   /* Objet : SetNamedPipeHandleState(). */
TypUpsVmShort UpsVmAPI (*WaitNamedPipe)(TypUpsVmChar *lpNamedPipeName);
   /* Objet : WaitNamedPipe(). */
TypUpsVmShort UpsVmAPI (*WriteFile)(TypUpsVmPointeurDonnees hFile, TypUpsVmPointeurDonnees lpBuffer, TypUpsVmLong nNumberOfBytesToWrite, TypUpsVmLong *lpNumberOfBytesWritten,
   TypUpsNapOverlapped *lpOverlapped, TypUpsVmShort *Pending);
   /* Objet : WriteFile(). */
/****/
#endif
/****/
} *TypUpsNapNatTraitements_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsNapNatTraitements_1_1_0 TypUpsNapNatTraitements;

extern DllExport TypUpsNapNatTraitements UpsVmAPI UpsNapNatDemarrerModule(TypUpsVtmMachineInterface MachineInterfaceUpsVtm);
   /* Objet : Retourne la description de Ups Nap Nat. */

/**********************/
#if defined(__cplusplus)
/**********************/
}
/****/
#endif
/****/

/****/
#endif
/****/
