/*-------------------------------------------------------------------
Fichier     : upsnap.e
Objet       : En-tete de upsnap

Module      : Up ! Tuyau Nomme
Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.
---------------------------------------------------------------------
                         Observations

 
---------------------------------------------------------------------*/

/*****************************/
#if !defined(PasseModuleUpsNap)
/*****************************/
#define PasseModuleUpsNap 1

/**********************/
#if defined(__cplusplus)
/**********************/
extern "C"
{
/****/
#endif
/****/

/****************************************************************/
typedef struct typupsnapcanal
/* Objet: Informations specifiques pour la communication selon  */
/* un canal Named Pipes.                                        */
/****************************************************************/
{
TypUpsNetCanal *Canal;
   /* Canal etendu. */
TypUpsVmUnicode NomTuyau[CO_TailleIdf+1];
   /* Nom du tuyau. */
TypUpsVmLong Port;
   /* Port du tuyau. */
TypUpsVmPointeurDonnees Tuyau;
   /* Tuyau si il est ouvert. */
enum EnuUpsVmTailleBuffer TailleBuffer;
   /* Taille du buffer. */
TypUpsVmShort EstServeur;
   /* Si Vrai, le canal est connecte cote client. */
} TypUpsNapCanal;

/*******************************************************************/
typedef struct typupsnapmachineinterface_1_1_0
/* Objet : Interface avec la machine pour Up ! Tuyau nomme.        */ 
/*******************************************************************/
{
TypUpsVmShort UpsVmAPI (*Ouvrir)(TypUpsVmSession *Session, enum EnuUpsVmTailleBuffer, TypUpsNapCanal *Canal);
   /* Objet : Ouvre le tuyau nomme. */
TypUpsVmShort UpsVmAPI (*EcouterClients)(TypUpsVmSession *Session, TypUpsNapCanal *Canal, TypUpsVmShort NbClients);
   /* Objet : Configure le tuyau nomme pour traiter au plus NbClients. */
TypUpsVmShort UpsVmAPI (*AccepterUnClient)(TypUpsVmSession *Session, TypUpsNapCanal *CanalServeur, TypUpsNapCanal *CanalClient);
   /* Objet : Configure le tuyau nomme pour qu'elle traite un nouveau client. */
TypUpsVmShort UpsVmAPI (*Connecter)(TypUpsVmSession *Session, TypUpsNapCanal *CanalClient, TypUpsNapCanal *CanalServeur);
   /* Objet : Configure le tuyau nomme pour qu'il traite avec un nouveau serveur. */
TypUpsVmShort UpsVmAPI (*Lire)(TypUpsVmSession *Session, TypUpsNapCanal *Canal, TypUpsVmChar *Buffer, TypUpsVmLong TailleALire, 
	TypUpsVmLong *TailleLue, TypUpsVmShort TailleImposee);
   /* Objet : Lecture par paquet. */
TypUpsVmShort UpsVmAPI (*Ecrire)(TypUpsVmSession *Session, TypUpsNapCanal *Canal, TypUpsVmChar *Buffer, TypUpsVmLong TailleAEcrire, 
   TypUpsVmLong *TailleEcrite);
   /* Objet : Ecriture par paquet. */
TypUpsVmShort UpsVmAPI (*Fermer)(TypUpsVmSession *Session, TypUpsNapCanal *Canal);
   /* Objet : Ferme le tuyau nomme. */
TypUpsVmShort UpsVmAPI (*Detruire)(TypUpsVmSession *Session, TypUpsNapCanal *Canal);
   /* Objet : Detruit le tuyau nomme. */
} *TypUpsNapMachineInterface_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsNapMachineInterface_1_1_0 TypUpsNapMachineInterface;

/****************************************************************/
typedef struct typprmupsnap_1_4_2
/* Objet : Parametre de CanalTuyauNomme.Constructeur(NomDuCanal:*/
/* Caractere, NomDuTuyau:Caractere, TailleBufferIO:Entier=1024);*/
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomDuCanal: Caractere. */
TypUpsVmLong UpsVar2;
   /* TailleBufferIO:Entier; */
} TypPrmUpsNap_1_4_2;

/****************************************************************/
typedef struct typprmupsnap_1_17_1
/* Objet : Parametre de CanalTuyauNomme.ConnecterAUnServeur(	*/
/* NomDuTuyau:Caractere);                                       */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* NomDuTuyau: Caractere. */
} TypPrmUpsNap_1_17_1;

/****************************************************************/
typedef struct upstypupsnap_1_1_1_0
/* Objet : Proprietes du type CanalTuyauNomme.                  */
/****************************************************************/
{
TypUpsVmAdresse UpsObjet1;
   /* Objet pour le canal; */
TypUpsNetCanal Canal;
   /* Canal pour la tache. */
TypUpsNetCanal CanalClient;
   /* Canal pour la lecture/ecriture quand on a accepte un client. */
TypUpsVmLong Taille;
   /* Taille du buffer du canal. */
TypUpsVmShort PageDeCode;
   /* Page de code. */
} UpsTypUpsNap_1_1_1_0;

/****************************************************************/
typedef struct upstrttypupsnap_1_1_1_0
/* Objet : Methodes du type CanalTuyauNomme.                    */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */

/*--------------------------------------------------------------*/
/* Methodes heritees de Flux.                                   */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*Mth_4_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypPrmUpsNap_1_4_2 *UpsPrm);
   /* Constructeur(NomDuCanal:Caractere, NomDuTuyau:Caractere, TailleBufferIO:Entier=1024); */
TypUpsVmVoid UpsVmAPI (*Mth_5_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_5_1 *UpsPrm);
   /* Procedure Lire(B:Booleen Sortie); */
TypUpsVmAdresse UpsVmAPI *(*Mth_5_2)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_5_2 *UpsPrm);
   /* Fonction Lire(C:Binaire Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_5_3)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_5_3 *UpsPrm);
   /* Fonction Lire(C:Caractere Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmVoid UpsVmAPI (*Mth_5_4)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_5_4 *UpsPrm);
   /* Procedure Lire(E:Entier Sortie); */
TypUpsVmVoid UpsVmAPI (*Mth_5_5)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_5_5 *UpsPrm);
   /* Procedure Lire(R:Reel Sortie); */
TypUpsVmAdresse UpsVmAPI *(*Mth_6_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_6_1 *UpsPrm);
   /* Fonction LireUneLigne(C:Nul Ou Caractere Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmAdresse UpsVmAPI *(*Mth_7_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_7_1 *UpsPrm);
   /* Fonction LireUnMot(C:Nul Ou Caractere Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmVoid UpsVmAPI (*Mth_8_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_8_1 *UpsPrm);
   /* Procedure Ecrire(B:Nul Ou Booleen); */
TypUpsVmVoid UpsVmAPI (*Mth_8_2)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_8_2 *UpsPrm);
   /* Procedure Ecrire(C:Nul Ou Binaire); */
TypUpsVmVoid UpsVmAPI (*Mth_8_3)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_8_3 *UpsPrm);
   /* Procedure Ecrire(C:Nul Ou Caractere); */
TypUpsVmVoid UpsVmAPI (*Mth_8_4)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_8_4 *UpsPrm);
   /* Procedure Ecrire(E:Nul Ou Entier); */
TypUpsVmVoid UpsVmAPI (*Mth_8_5)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_8_5 *UpsPrm);
   /* Procedure Ecrire(R:Nul Ou Reel); */
TypUpsVmVoid UpsVmAPI (*Mth_9_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Procedure Fermer(); */
TypUpsVmUnsignedChar UpsVmAPI (*Mth_10_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Objet : LirePageDeCode() Retourner PagesDeCodesSupportees. */ 
TypUpsVmVoid UpsVmAPI (*Mth_11_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsSys_12_11_1 *UpsPrm);
   /* Objet : ChangerPageDeCode(P:PagesDeCodesSupportees). */ 
/*--------------------------------------------------------------*/
/* Methodes heritees de Canal.                                  */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*Mth_12_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmAdresse *AdresseObjet);
   /* Fonction Protocole() Retourner Caractere; */
TypUpsVmAdresse UpsVmAPI *(*Mth_13_1)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmAdresse *AdresseObjet, TypPrmUpsNet_1_13_1 *UpsPrm);
   /* Fonction Adresse(CanalDuClient:Booleen=Faux) Retourner Caractere; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*Mth_14_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Procedure ServirDesClients(); */
TypUpsVmVoid UpsVmAPI (*Mth_15_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Procedure AccepterUnClient(); */
TypUpsVmUnsignedChar UpsVmAPI (*Mth_16_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet);
   /* Fonction TenterDAccepterUnClient() Retourner Booleen; */
TypUpsVmVoid UpsVmAPI (*Mth_17_1)(TypUpsVmSession *Session, TypUpsVmAdresse *UpsObjet, TypPrmUpsNap_1_17_1 *UpsPrm);
   /* Procedure ConnecterAUnServeur(NomDuTuyau:Caractere); */

/*--------------------------------------------------------------*/
/* Methodes heritees de Flux.                                   */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_4_2;
   /* Constructeur(NomDuCanal:Caractere, NomDuTuyau:Caractere, TailleBufferIO:Entier=1024); */
TypUpsVmCoAppel CoMth_5_1;
   /* Procedure Lire(B:Booleen Sortie); */
TypUpsVmCoAppel CoMth_5_2;
   /* Fonction Lire(C:Binaire Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_5_3;
   /* Fonction Lire(C:Caractere Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_5_4;
   /* Procedure Lire(E:Entier Sortie); */
TypUpsVmCoAppel CoMth_5_5;
   /* Procedure Lire(R:Reel Sortie); */
TypUpsVmCoAppel CoMth_6_1;
   /* Fonction LireUneLigne(C:Nul Ou Caractere Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_7_1;
   /* Fonction LireUnMot(C:Nul Ou Caractere Sortie, Nombre:Nul Ou Entier) Retourner Nul Ou Entier; */
TypUpsVmCoAppel CoMth_8_1;
   /* Procedure Ecrire(B:Nul Ou Booleen); */
TypUpsVmCoAppel CoMth_8_2;
   /* Procedure Ecrire(C:Nul Ou Binaire); */
TypUpsVmCoAppel CoMth_8_3;
   /* Procedure Ecrire(C:Nul Ou Caractere); */
TypUpsVmCoAppel CoMth_8_4;
   /* Procedure Ecrire(E:Nul Ou Entier); */
TypUpsVmCoAppel CoMth_8_5;
   /* Procedure Ecrire(R:Nul Ou Reel); */
TypUpsVmCoAppel CoMth_9_1;
   /* Procedure Fermer(); */
TypUpsVmCoAppel CoMth_10_1;
   /* Objet : LirePageDeCode() Retourner PagesDeCodesSupportees. */ 
TypUpsVmCoAppel CoMth_11_1;
   /* Objet : ChangerPageDeCode(P:PagesDeCodesSupportees). */ 
/*--------------------------------------------------------------*/
/* Methodes heritees de Canal.                                  */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_12_1;
   /* Fonction Protocole() Retourner Caractere; */
TypUpsVmCoAppel CoMth_13_1;
   /* Fonction Adresse(CanalDuClient:Booleen=Faux) Retourner Caractere; */
/*--------------------------------------------------------------*/
/* Methodes propres.                                            */
/*--------------------------------------------------------------*/
TypUpsVmCoAppel CoMth_14_1;
   /* Procedure ServirDesClients(); */
TypUpsVmCoAppel CoMth_15_1;
   /* Procedure AccepterUnClient(); */
TypUpsVmCoAppel CoMth_16_1;
   /* Fonction TenterDAccepterUnClient() Retourner Booleen; */
TypUpsVmCoAppel CoMth_17_1;
   /* Procedure ConnecterAUnServeur(NomDuTuyau:Caractere); */
} UpsTrtTypUpsNap_1_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTypUpsNap_1_1_1_0 UpsTypUpsNap_1;
typedef UpsTrtTypUpsNap_1_1_1_0 UpsTrtTypUpsNap_1;

/****************************************************************/
typedef struct typupsnapdonnees
/* Objet: Interface des donnees de Ups Nap.                     */
/****************************************************************/
{
struct typupsnetxdonnees InterfaceUpsNet;
   /* Interface de Ups Net. */

TypUpsVmUnicode NomTuyau[CO_TailleIdf+1];
   /* Nom du tuyau. */
TypUpsVmLong PortUpsOrb;
   /* Port du serveur local UpsOrb. */
TypUpsVmLong PortUpsOrbMaitre;
   /* Port du serveur maitre UpsOrb. */
TypUpsVmLong PortServeur;
   /* Port des serveurs via le scrutateur. */
TypUpsVmLong Port;
   /* Premier port utilisable par Ups Nap. */
} *TypUpsNapDonnees;

/****************************************************************/
typedef struct typupsnaptraitements_1_1_0
/* Objet: Interface des traitements de Ups Nap.                 */
/****************************************************************/
{
struct typupsnetxtraitements_1_1_0 InterfaceUpsNet;
   /* Interface de Ups Net. */

/*--------------------------------------------------------------*/
/* Procedures et fonctions.                                     */
/*--------------------------------------------------------------*/
TypUpsVmLong UpsVmAPI (*CalculerIndexAppel)(TypUpsVmPointeurDonnees InterfaceAppel, TypUpsVmPointeurDonnees AppelCourant);
   /* Objet : Calcule l'index de l'appel. */

/*--------------------------------------------------------------*/
/* Tables des methodes.                                         */
/*--------------------------------------------------------------*/
UpsTrtTypUpsNap_1 *UpsTrt1;
   /* Methodes de CanalTuyauNomme. */ 
UpsTrtTypUpsNet_1 *UpsTrt1_1;
   /* Methodes de CanalTuyauNomme.Canal. */ 
UpsTrtTypUpsSys_12 *UpsTrt1_1_1;
   /* Methodes de CanalTuyauNomme.Canal.Flux. */ 

/*--------------------------------------------------------------*/
/* Enumeres.			              				                   */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Entrepots.          								                   */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Types et interfaces.                                         */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*UpsType1_get)(TypUpsVmSession *Session);
   /* Type CanalTuyauNomme. */
TypUpsVmLong UpsVmAPI (*UpsIndex1_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type CanalTuyauNomme. */ 

/*--------------------------------------------------------------*/
/* Variables globales.                                          */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Exceptions.                                                  */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Files d'attente.                                             */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Application Program Interfaces proprietaires.                */
/*--------------------------------------------------------------*/
TypUpsNapMachineInterface UpsVmAPI (*LireMachineInterface)(TypUpsVmVoid);
   /* Objet : Retrouve l'interface machine pour Ups Tuyau Nomme. */
} *TypUpsNapTraitements_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsNapTraitements_1_1_0 TypUpsNapTraitements;

extern DllExport TypUpsVtmDemarrer UpsVmAPI UpsNapDemarrerModule(TypUpsVmShort Numero, TypUpsVtmMachineInterface MachineInterfaceUpsVtm,
   TypUpsVtmTraitements IntTrtUpsVtm, TypUpsVtmDonnees IntDonUpsVtm);
   /* Objet : Retourne la description de Ups Nap. */

/**********************/
#if defined(__cplusplus)
/**********************/
}
/****/
#endif
/****/

/****/
#endif
/****/
