/*-------------------------------------------------------------------
Fichier     : upskrn_sj.e
Objet       : En-tete du module Up ! Kernel - Adaptateur serveur Java.

Module      : Up ! Kernel
Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.
---------------------------------------------------------------------
                         Observations

 
---------------------------------------------------------------------*/

/*******************************/
#if !defined(PasseModuleUpsKrnSJ)
/*******************************/
#define PasseModuleUpsKrnSJ 1

/**********************/
#if defined(__cplusplus)
/**********************/
extern "C"
{
/****/
#endif
/****/

/****************************************************************/
typedef struct typupskrnsjdonnees
/* Objet: Interface des donnees de Ups Krn SJ.                  */
/****************************************************************/
{
struct typupsvmentetedonneesmodule EnteteDonneesModule;
   /* Entete generique du module. */
TypUpsVmPointeurDonnees  ModuleUpsKrn;
   /* Objet representant le module UpsKrn. */
} *TypUpsKrnSJDonnees;

/****************************************************************/
typedef struct typupskrnsjtraitements_1_1_0
/* Objet: Interface des traitements de Ups Krn SJ.              */
/****************************************************************/
{
struct typupsvmentetemethodesmodule EnteteMethodesModule;
   /* Methodes generiques au module. */ 

TypUpsVmPointeurDonnees UpsVmAPI (*UpsEntrepot1_get)(TypUpsVmVoid);
   /* Entrepot 'EntrepotSysteme'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsClasse1_get)(TypUpsVmVoid);
TypUpsVmPointeurDonnees UpsVmAPI (*UpsType1_get)(TypUpsVmVoid);
   /* Type 'Binaire'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsClasse2_get)(TypUpsVmVoid);
TypUpsVmPointeurDonnees UpsVmAPI (*UpsType2_get)(TypUpsVmVoid);
   /* Type 'Caractere'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsClasse3_get)(TypUpsVmVoid);
TypUpsVmPointeurDonnees UpsVmAPI (*UpsType3_get)(TypUpsVmVoid);
   /* Type 'Date'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsClasse4_get)(TypUpsVmVoid);
TypUpsVmPointeurDonnees UpsVmAPI (*UpsType4_get)(TypUpsVmVoid);
   /* Type 'Entier'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsClasse5_get)(TypUpsVmVoid);
TypUpsVmPointeurDonnees UpsVmAPI (*UpsType5_get)(TypUpsVmVoid);
   /* Type 'Enumere'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsClasse6_get)(TypUpsVmVoid);
TypUpsVmPointeurDonnees UpsVmAPI (*UpsType6_get)(TypUpsVmVoid);
   /* Type 'Exception'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsClasse7_get)(TypUpsVmVoid);
TypUpsVmPointeurDonnees UpsVmAPI (*UpsType7_get)(TypUpsVmVoid);
   /* Type 'Objet'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsClasse8_get)(TypUpsVmVoid);
TypUpsVmPointeurDonnees UpsVmAPI (*UpsType8_get)(TypUpsVmVoid);
   /* Type 'Reel'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsClasse9_get)(TypUpsVmVoid);
TypUpsVmPointeurDonnees UpsVmAPI (*UpsType9_get)(TypUpsVmVoid);
   /* Type 'Type'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsClasse10_get)(TypUpsVmVoid);
TypUpsVmPointeurDonnees UpsVmAPI (*UpsType10_get)(TypUpsVmVoid);
   /* Type 'Liste'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsClasse11_get)(TypUpsVmVoid);
TypUpsVmPointeurDonnees UpsVmAPI (*UpsType11_get)(TypUpsVmVoid);
   /* Type 'Reference'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsClasse12_get)(TypUpsVmVoid);
TypUpsVmPointeurDonnees UpsVmAPI (*UpsType12_get)(TypUpsVmVoid);
   /* Type 'Tableau'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsClasse13_get)(TypUpsVmVoid);
TypUpsVmPointeurDonnees UpsVmAPI (*UpsType13_get)(TypUpsVmVoid);
   /* Type 'ArbreBinaire'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsClasse14_get)(TypUpsVmVoid);
TypUpsVmPointeurDonnees UpsVmAPI (*UpsType14_get)(TypUpsVmVoid);
   /* Type 'Entrepot'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsClasse15_get)(TypUpsVmVoid);
TypUpsVmPointeurDonnees UpsVmAPI (*UpsType15_get)(TypUpsVmVoid);
   /* Type 'Module'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsClasse16_get)(TypUpsVmVoid);
TypUpsVmPointeurDonnees UpsVmAPI (*UpsType16_get)(TypUpsVmVoid);
   /* Type 'Appel'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsClasse17_get)(TypUpsVmVoid);
TypUpsVmPointeurDonnees UpsVmAPI (*UpsType17_get)(TypUpsVmVoid);
   /* Type 'Transaction'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsClasse18_get)(TypUpsVmVoid);
TypUpsVmPointeurDonnees UpsVmAPI (*UpsType18_get)(TypUpsVmVoid);
   /* Type 'Octet'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsClasse19_get)(TypUpsVmVoid);
TypUpsVmPointeurDonnees UpsVmAPI (*UpsType19_get)(TypUpsVmVoid);
   /* Interface 'IIterateur'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsClasse20_get)(TypUpsVmVoid);
TypUpsVmPointeurDonnees UpsVmAPI (*UpsType20_get)(TypUpsVmVoid);
   /* Interface 'ICollection'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsClasse21_get)(TypUpsVmVoid);
TypUpsVmPointeurDonnees UpsVmAPI (*UpsType21_get)(TypUpsVmVoid);
   /* Interface 'IEspaceMetre'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsClasse22_get)(TypUpsVmVoid);
TypUpsVmPointeurDonnees UpsVmAPI (*UpsType22_get)(TypUpsVmVoid);
   /* Interface 'IAlgebreCommutative'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsClasse23_get)(TypUpsVmVoid);
TypUpsVmPointeurDonnees UpsVmAPI (*UpsType23_get)(TypUpsVmVoid);
   /* Interface 'ICorpsCommutatif'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsClasse24_get)(TypUpsVmVoid);
TypUpsVmPointeurDonnees UpsVmAPI (*UpsType24_get)(TypUpsVmVoid);
   /* Type 'Booleen'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException1_get)(TypUpsVmVoid);
   /* Exception 'PlusDeMemoire'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException2_get)(TypUpsVmVoid);
   /* Exception 'BufferTropGrand'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException3_get)(TypUpsVmVoid);
   /* Exception 'DivisionParZero'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException4_get)(TypUpsVmVoid);
   /* Exception 'PasDeConstructeurImplicite'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException5_get)(TypUpsVmVoid);
   /* Exception 'DateInvalide'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException6_get)(TypUpsVmVoid);
   /* Exception 'ConvertirImpossible'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException7_get)(TypUpsVmVoid);
   /* Exception 'TropDeBlocsVerrouilles'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException8_get)(TypUpsVmVoid);
   /* Exception 'FichierEchangeLecture'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException9_get)(TypUpsVmVoid);
   /* Exception 'FichierEchangeEcriture'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException10_get)(TypUpsVmVoid);
   /* Exception 'PlusDeVerrou'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException11_get)(TypUpsVmVoid);
   /* Exception 'ConnexionInvalide'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException12_get)(TypUpsVmVoid);
   /* Exception 'VerrouInvalide'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException13_get)(TypUpsVmVoid);
   /* Exception 'AdresseInvalide'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException14_get)(TypUpsVmVoid);
   /* Exception 'EntrepotOuFichierEchangeInvalide'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException15_get)(TypUpsVmVoid);
   /* Exception 'AdresseExceptionInvalide'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException16_get)(TypUpsVmVoid);
   /* Exception 'EntrepotInconnu'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException17_get)(TypUpsVmVoid);
   /* Exception 'IterateurInvalide'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException18_get)(TypUpsVmVoid);
   /* Exception 'SuivantImpossible'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException19_get)(TypUpsVmVoid);
   /* Exception 'PrecedentImpossible'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException20_get)(TypUpsVmVoid);
   /* Exception 'IndexImpossible'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException21_get)(TypUpsVmVoid);
   /* Exception 'TableauTropGrand'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException22_get)(TypUpsVmVoid);
   /* Exception 'PasDOperateurImplicite'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException23_get)(TypUpsVmVoid);
   /* Exception 'ContrainteNonNulNonRespectee'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException24_get)(TypUpsVmVoid);
   /* Exception 'ContrainteSelonNonRespectee'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException25_get)(TypUpsVmVoid);
   /* Exception 'ContrainteTypeNonRespectee'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException26_get)(TypUpsVmVoid);
   /* Exception 'AdresseProtegee'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException27_get)(TypUpsVmVoid);
   /* Exception 'ArretProgramme'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException28_get)(TypUpsVmVoid);
   /* Exception 'TempsDeGardeDepasse'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException29_get)(TypUpsVmVoid);
   /* Exception 'ModificationImpossible'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException30_get)(TypUpsVmVoid);
   /* Exception 'BlocTropPetit'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException31_get)(TypUpsVmVoid);
   /* Exception 'ExceptionTraitementDistribue'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException32_get)(TypUpsVmVoid);
   /* Exception 'ObjetInconnu'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException33_get)(TypUpsVmVoid);
   /* Exception 'InsertionArbreImpossible'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException34_get)(TypUpsVmVoid);
   /* Exception 'ComparaisonArbreDifferente'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException35_get)(TypUpsVmVoid);
   /* Exception 'PlusDIterateur'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException36_get)(TypUpsVmVoid);
   /* Exception 'ExportationImpossible'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException37_get)(TypUpsVmVoid);
   /* Exception 'ImportationImpossible'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException38_get)(TypUpsVmVoid);
   /* Exception 'ClonageImpossible'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException39_get)(TypUpsVmVoid);
   /* Exception 'EnumerationImpossible'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException40_get)(TypUpsVmVoid);
   /* Exception 'AppelImpossible'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException41_get)(TypUpsVmVoid);
   /* Exception 'ModuleInconnu'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException42_get)(TypUpsVmVoid);
   /* Exception 'InterfaceNonImplementee'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException43_get)(TypUpsVmVoid);
   /* Exception 'ProprieteDynamiqueImpossible'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException44_get)(TypUpsVmVoid);
   /* Exception 'ProprieteInconnue'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException45_get)(TypUpsVmVoid);
   /* Exception 'ProprieteEnLectureSeule'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException46_get)(TypUpsVmVoid);
   /* Exception 'VariableEnLectureSeule'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException47_get)(TypUpsVmVoid);
   /* Exception 'AdaptateurDictionnaireNonTrouve'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException48_get)(TypUpsVmVoid);
   /* Exception 'AdaptateurUpsNetNonTrouve'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException49_get)(TypUpsVmVoid);
   /* Exception 'ExecutionDynamiqueImpossible'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException50_get)(TypUpsVmVoid);
   /* Exception 'ValidationImpossible'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException51_get)(TypUpsVmVoid);
   /* Exception 'TransactionImpossible'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException52_get)(TypUpsVmVoid);
   /* Exception 'PhotographieTropAncienne'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException53_get)(TypUpsVmVoid);
   /* Exception 'AppartenanceImpossible'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException54_get)(TypUpsVmVoid);
   /* Exception 'IndexProprieteImpossible'. */
TypUpsVmPointeurDonnees UpsVmAPI (*UpsException55_get)(TypUpsVmVoid);
   /* Exception 'ErreurInterne'. */

TypUpsVmPointeurDonnees UpsVmAPI (*EstInstanceDe)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees This);
   /* Objet : Methode standard UpsKrn.Objet::EstInstanceDe. */
TypUpsJavJBoolean UpsVmAPI (*Identique)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees This, TypUpsVmPointeurDonnees O);
   /* Objet : Methode standard UpsKrn.Objet::Identique. */
TypUpsVmVoid UpsVmAPI (*Convertir)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees This, TypUpsVmPointeurDonnees O);
   /* Objet : Methode standard UpsKrn.Objet::Convertir. */
TypUpsJavJInt UpsVmAPI (*CreeParLeServeur)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees This);
   /* Objet : Methode standard UpsKrnObjet::CreeParLeServeur. */
TypUpsJavJInt UpsVmAPI (*CreeParLeProcessus)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees This);
   /* Objet : Methode standard UpsKrnObjet::CreeParLeProcessus. */
TypUpsVmPointeurDonnees UpsVmAPI (*CreeDansLEntrepot)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet);
   /* Objet : Methode standard UpsKrnObjet::CreeDansLEntrepot. */
TypUpsVmPointeurDonnees UpsVmAPI (*Cloner)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees EntrepotCible, TypUpsJavJShort Profondeur);
   /* Objet : Methode standard UpsKrnSJObjet::Cloner. */
TypUpsVmVoid UpsVmAPI (*Exporter)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet);
   /* Objet : Methode standard UpsKrn.Objet::Exporter. */
TypUpsVmPointeurDonnees UpsVmAPI (*LirePropriete)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees This, TypUpsVmPointeurDonnees NomPropriete);
   /* Objet : Methode standard UpsKrn.Objet::LirePropriete. */
TypUpsVmVoid UpsVmAPI (*EcrirePropriete)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees This, 
	TypUpsVmPointeurDonnees NomPropriete, TypUpsVmPointeurDonnees ValeurPropriete);
   /* Objet : Methode standard UpsKrn.Objet::EcrirePropriete. */
TypUpsVmPointeurDonnees UpsVmAPI (*IncrementerDecrementerPropriete)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees This, 
   TypUpsVmPointeurDonnees NomPropriete, TypUpsJavJBoolean Incrementer, TypUpsJavJBoolean Prefixe);
   /* Objet : Methode standard UpsKrn.Objet::IncrementerDecrementerPropriete. */
TypUpsVmVoid UpsVmAPI (*SupprimerPropriete)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees This, TypUpsVmPointeurDonnees NomPropriete);
   /* Objet : Methode standard UpsKrn.Objet::SupprimerPropriete. */
TypUpsVmPointeurDonnees UpsVmAPI (*EnumererProprietes)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees This, TypUpsJavJInt Numero, TypUpsVmPointeurDonnees UpsPrm);
   /* Objet : Methode standard UpsKrn.Objet::EnumererProprietes. */
TypUpsVmShort UpsVmAPI (*ArreterProgramme)(TypUpsVmPointeurDonnees Env);
   /* Objet : Arrete le programme. */

TypUpsVmShort UpsVmAPI (*CreerUnType)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees *Classe, TypUpsVmPointeurDonnees *Objet, TypUpsVmAdresse *AdresseObjetType);
   /* Objet : Creation d'un type. */
TypUpsVmVoid UpsVmAPI (*DetruireUnType)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees *Classe, TypUpsVmPointeurDonnees *Objet);
   /* Objet : Destruction d'un type. */
TypUpsVmShort UpsVmAPI (*CreerUnEntrepot)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees *Objet, TypUpsVmAdresse *AdresseObjetEntrepot);
   /* Objet : Creation d'un entrepot. */
TypUpsVmVoid UpsVmAPI (*DetruireUnEntrepot)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees *Objet);
   /* Objet : Destruction d'un entrepot. */
TypUpsVmShort UpsVmAPI (*CreerUneException)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees *Objet, TypUpsVmAdresse *AdresseObjetException);
   /* Objet : Creation d'une exception. */
TypUpsVmVoid UpsVmAPI (*DetruireUneException)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees *Objet);
   /* Objet : Destruction d'une exception. */
TypUpsVmShort UpsVmAPI (*CreerUneFileDAttente)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees *Objet, TypUpsVmAdresse *AdresseObjetFileDAttente);
   /* Objet : Creation d'une une file d'attente. */
TypUpsVmVoid UpsVmAPI (*DetruireUneFileDAttente)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees *Objet);
   /* Objet : Destruction d'une file d'attente. */
TypUpsVmShort UpsVmAPI (*CreerUnModule)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees *Objet, TypUpsVmAdresse *AdresseObjetModule);
   /* Objet : Creation d'un module. */
TypUpsVmVoid UpsVmAPI (*DetruireUnModule)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees *Objet);
   /* Objet : Destruction d'un module. */
} *TypUpsKrnSJTraitements_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsKrnSJTraitements_1_1_0 TypUpsKrnSJTraitements;

extern DllExport TypUpsVtmDemarrer UpsVmAPI UpsKrnSJDemarrerModule(TypUpsVmShort Numero, 
   TypUpsVtmMachineInterface MachineInterfaceUpsVtm,   TypUpsVtmTraitements IntTrtUpsVtm, TypUpsVtmDonnees IntDonUpsVtm);
   /* Objet : Retourne la description de Ups Krn SJ. */

/**********************/
#if defined(__cplusplus)
/**********************/
}
/****/
#endif
/****/

/****/
#endif
/****/
