/*-------------------------------------------------------------------
Fichier     : upsjav_nt.e
Objet       : En-tete de Up ! Java

Module      : Up ! Java
Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.
---------------------------------------------------------------------
                        Observations
                   
---------------------------------------------------------------------*/ 

/********************************/
#if !defined(PasseModuleUpsJavNat)
/********************************/
#define PasseModuleUpsJavNat 1

/**********************/
#if defined(__cplusplus)
/**********************/
extern "C"
{
/****/
#endif
/****/

typedef TypUpsVmLong TypUpsJavJInt;
typedef TypUpsVmLongLong TypUpsJavJLong;
typedef TypUpsVmChar TypUpsJavJByte;
typedef TypUpsVmUnsignedChar TypUpsJavJBoolean;
typedef TypUpsVmUnsignedShort TypUpsJavJChar;
typedef TypUpsVmShort TypUpsJavJShort;
typedef TypUpsVmFloat TypUpsJavJFloat;
typedef TypUpsVmDouble TypUpsJavJDouble;

/****************************************************************/
/* Codification des codes d'erreur.                             */
/****************************************************************/
enum EnuUpsJavCodeErreur
   {
   CEJ_Ok=1,
   CEJ_Unknown=2,
   CEJ_BadOperation=3,
   CEJ_BadContext=4
   };

/****************************************************************/
/* Codification des types supportes par Java.                   */
/****************************************************************/
enum EnuUpsJavType
   {
   TJ_Object=1,
   TJ_Boolean=2,
   TJ_Byte=3,
   TJ_Char=4,
   TJ_Short=5,
   TJ_Int=6,
   TJ_Long=7,
   TJ_Float=8,
   TJ_Double=9
   };

/****************************************************************/
/* Codification constructeurs Java speciaux.                    */
/****************************************************************/
enum EnuUpsJavObjetJava
   {	
   OJ_Boolean=1,
   OJ_Byte=2,
   OJ_Char=3,
   OJ_Double=4,
   OJ_Float=5,
   OJ_Int=6,
   OJ_Long=7,
   OJ_Object=8,
   OJ_Short=9,
   OJ_UnsignedShort=10,
   OJ_BigDecimal=11,
   OJ_BigInteger=12,
   OJ_BitSet=13,
   OJ_ByteBuffer=14,
   OJ_CharBuffer=15,
   OJ_DataBufferByte=16,
   OJ_DataBufferDouble=17,
   OJ_DataBufferFloat=18,
   OJ_DataBufferInt=19,
   OJ_DataBufferShort=20,
   OJ_DataBufferUShort=21,
   OJ_Date=22,
   OJ_DoubleBuffer=23,
   OJ_FloatBuffer=24,
   OJ_IntBuffer=25,
   OJ_LongBuffer=26,
   OJ_ShortBuffer=27,
   OJ_StringBuffer=28,
   OJ_Array=29,
   OJ_ArrayList=30,
   OJ_LinkedList=31,
   OJ_Vector=32,
   OJ_Stack=33
   };

/****************************************************************/
typedef union typupsjavjvalue
/* Objet: Valeur generique pour l'appel dynamique de methode.   */
/****************************************************************/
{
TypUpsJavJBoolean Boolean;
TypUpsJavJByte Byte;
TypUpsJavJChar Char;
TypUpsJavJShort Short;
TypUpsJavJInt Int;
TypUpsJavJLong Long;
TypUpsJavJFloat Float;
TypUpsJavJDouble Double;
TypUpsVmPointeurDonnees Object;
} TypUpsJavJValue;

/****************************************************************/
typedef struct typupsjavnattablemethodesrappel
/* Objet: Methodes de rappel vers Ups Jav.                      */
/****************************************************************/
{
TypUpsVmVoid UpsVmAPI (*MethodeEcrireEcran)(TypUpsVmChar *Message);
   /* Objet : Methode de rappel pour l'envoi d'un message d'erreur.   */
TypUpsVmVoid (*MethodeArreterProgramme)(TypUpsVmShort CodeErreur);
	/* Objet : Methode de rappel pour l'arret en douceur du programme. */
TypUpsVmVoid (*MethodeArreterProgrammeForce)(TypUpsVmVoid);
   /* Objet : Methode de rappel pour l'arret brutal du programme. */
} *TypUpsJavNatTableMethodesRappel;

/****************************************************************/
typedef struct typupsjavnattraitements_1_1_0
/* Objet: Interface des traitements de Ups Jav Nat.             */
/****************************************************************/
{
TypUpsVmShort UpsVmAPI (*AllouerUnTableau)(TypUpsVmPointeurDonnees Env, enum EnuUpsJavObjetJava TypeObjetJava, TypUpsVmPointeurDonnees ObjetJava, 
   TypUpsVmLong *TableDimensions, TypUpsVmShort NbDimensions, TypUpsVmLong BorneMin, TypUpsVmLong BorneMax, enum EnuUpsVmTypeDeDonnee TypeObjetUps);
   /* Objet : Allocation d'un tableau. */
TypUpsVmPointeurDonnees UpsVmAPI (*AllocObject)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe);
   /* Objet : AllocObject. */
TypUpsVmVoid UpsVmAPI (*AttachCurrentThread)(TypUpsVmPointeurDonnees pJavaVM, TypUpsVmPointeurDonnees *Env);
   /* Objet : AttachCurrentThread. */
TypUpsJavJBoolean UpsVmAPI (*CallBooleanMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallBooleanMethod. */
TypUpsJavJByte UpsVmAPI (*CallByteMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallByteMethod. */
TypUpsJavJChar UpsVmAPI (*CallCharMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallCharMethod. */
TypUpsJavJDouble UpsVmAPI (*CallDoubleMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallDoubleMethod. */
TypUpsJavJFloat UpsVmAPI (*CallFloatMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallFloatMethod. */
TypUpsJavJInt UpsVmAPI (*CallIntMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallIntMethod. */
TypUpsJavJLong UpsVmAPI (*CallLongMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallLongMethod. */
TypUpsVmPointeurDonnees UpsVmAPI (*CallObjectMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallObjectMethod. */
TypUpsJavJShort UpsVmAPI (*CallShortMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallShortMethod. */
TypUpsJavJBoolean UpsVmAPI (*CallStaticBooleanMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallStaticBooleanMethod. */
TypUpsJavJByte UpsVmAPI (*CallStaticByteMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallStaticByteMethod. */
TypUpsJavJChar UpsVmAPI (*CallStaticCharMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallStaticCharMethod. */
TypUpsJavJDouble UpsVmAPI (*CallStaticDoubleMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallStaticDoubleMethod. */
TypUpsJavJFloat UpsVmAPI (*CallStaticFloatMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallStaticFloatMethod. */
TypUpsJavJInt UpsVmAPI (*CallStaticIntMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallIntMethod. */
TypUpsJavJLong UpsVmAPI (*CallStaticLongMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallStaticLongMethod. */
TypUpsVmPointeurDonnees UpsVmAPI (*CallStaticObjectMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallStaticObjectMethod. */
TypUpsJavJShort UpsVmAPI (*CallStaticShortMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallStaticShortMethod. */
TypUpsVmVoid UpsVmAPI (*CallStaticVoidMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallStaticVoidMethod. */
TypUpsVmVoid UpsVmAPI (*CallVoidMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallVoidMethod. */
TypUpsVmShort UpsVmAPI (*ConstruireObjetJava)(TypUpsVmPointeurDonnees Env, enum EnuUpsJavObjetJava TypeObjetJava, TypUpsVmPointeurDonnees ObjetJava);
   /* Objet : Constructeur d'un objet Java. */
TypUpsVmVoid (*DeleteGlobalRef)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees This);
   /* Objet : DeleteGlobalRef. */
TypUpsVmVoid UpsVmAPI (*DetachCurrentThread)(TypUpsVmPointeurDonnees pJavaVM);
   /* Objet : DetachCurrentThread. */
TypUpsVmShort UpsVmAPI (*EcrireObjetJava)(TypUpsVmPointeurDonnees Env, enum EnuUpsVmTypeDeDonnee TypeObjetUps, TypUpsVmPointeurDonnees ObjetUps, 
   enum EnuUpsJavObjetJava TypeObjetJava, TypUpsVmPointeurDonnees ObjetJava, TypUpsVmLong *TableDimensions, TypUpsVmShort NbDimensions);
   /* Objet : Ecriture d'un objet Java. */
TypUpsVmShort (*EstUnTableau)(TypUpsVmPointeurDonnees Env, enum EnuUpsJavObjetJava TypeObjetJava, TypUpsVmPointeurDonnees ObjetJava, TypUpsVmLong *TableDimensions, TypUpsVmShort NbDimensions, 
   TypUpsVmShort *EstNul, TypUpsVmLong *BorneMin, TypUpsVmLong *BorneMax, enum EnuUpsJavObjetJava *TypeObjetElementJava, enum EnuUpsVmTypeDeDonnee *TypeObjetElementUps);
   /* Objet : Verifie si l'objet Java est un tableau. */
TypUpsVmVoid UpsVmAPI (*ExceptionClear)(TypUpsVmPointeurDonnees Env);
   /* Objet : ExceptionClear. */
TypUpsVmVoid UpsVmAPI (*ExceptionDescribe)(TypUpsVmPointeurDonnees Env);
   /* Objet : ExceptionDescribe. */
TypUpsVmPointeurDonnees UpsVmAPI (*ExceptionOccurred)(TypUpsVmPointeurDonnees Env);
   /* Objet : ExceptionOccurred. */
TypUpsVmVoid UpsVmAPI (*FatalError)(TypUpsVmPointeurDonnees Env, TypUpsVmChar *Chaine);
   /* Objet : FatalError. */
TypUpsVmPointeurDonnees UpsVmAPI (*FindClass)(TypUpsVmPointeurDonnees Env, TypUpsVmChar *Signature);
   /* Objet : FindClass. */
TypUpsVmLong UpsVmAPI (*GetArrayLength)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees ObjetTableau);
   /* Objet : GetArrayLength. */
TypUpsJavJBoolean UpsVmAPI (*GetBooleanField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetBooleanField. */
TypUpsJavJByte UpsVmAPI *(*GetByteArrayElements)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees ObjetTableau, 
   TypUpsJavJBoolean *CopieDemandee);
   /* Objet : GetByteArrayElements. */
TypUpsJavJByte UpsVmAPI (*GetByteField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetByteField. */
TypUpsJavJChar UpsVmAPI *(*GetCharArrayElements)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees ObjetTableau, 
   TypUpsJavJBoolean *CopieDemandee);
   /* Objet : GetCharArrayElements. */
TypUpsJavJChar UpsVmAPI (*GetCharField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetCharField. */
TypUpsVmShort UpsVmAPI (*GetCreatedJavaVMs)(TypUpsVmPointeurDonnees *TableJavaVMs, TypUpsVmShort TailleTableJavaVMs, 
   TypUpsVmShort *TailleUtilisee);
   /* Objet : GetCreatedJavaVMs. */
TypUpsJavJDouble UpsVmAPI (*GetDoubleField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetDoubleField. */
TypUpsVmPointeurDonnees UpsVmAPI (*GetFieldID)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmChar *NomPropriete, 
   TypUpsVmChar *Signature);
   /* Objet : GetFieldID. */
TypUpsJavJFloat UpsVmAPI (*GetFloatField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetFloatField. */
TypUpsJavJInt UpsVmAPI (*GetIntField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetIntField. */
TypUpsJavJLong UpsVmAPI (*GetLongField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetLongField. */
TypUpsVmPointeurDonnees (*GetMethodID)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmChar *NomMethode, TypUpsVmChar *Signature);
   /* Objet : GetMethodID. */
TypUpsVmPointeurDonnees UpsVmAPI (*GetObjectArrayElement)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees ObjetTableau, TypUpsVmLong Taille);
   /* Objet : GetObjectArrayElement. */
TypUpsVmPointeurDonnees UpsVmAPI (*GetObjectClass)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet);
   /* Objet : GetObjectClass. */
TypUpsVmPointeurDonnees UpsVmAPI (*GetObjectField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetObjectField. */
TypUpsJavJShort UpsVmAPI (*GetShortField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetShortField.  */
TypUpsJavJBoolean UpsVmAPI (*GetStaticBooleanField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetStaticBooleanField. */
TypUpsJavJByte UpsVmAPI (*GetStaticByteField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetStaticByteField. */
TypUpsJavJChar UpsVmAPI (*GetStaticCharField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetStaticCharField. */
TypUpsJavJDouble UpsVmAPI (*GetStaticDoubleField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetStaticDoubleField. */
TypUpsVmPointeurDonnees UpsVmAPI (*GetStaticFieldID)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmChar *NomPropriete, 
   TypUpsVmChar *Signature);
   /* Objet : GetStaticFieldID. */
TypUpsJavJFloat UpsVmAPI (*GetStaticFloatField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetStaticFloatField. */
TypUpsJavJInt UpsVmAPI (*GetStaticIntField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetStaticIntField. */
TypUpsJavJLong UpsVmAPI (*GetStaticLongField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetStaticLongField. */
TypUpsVmPointeurDonnees UpsVmAPI (*GetStaticMethodID)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmChar *NomMethode, 
   TypUpsVmChar *Signature);
   /* Objet : GetStaticMethodID. */
TypUpsVmPointeurDonnees UpsVmAPI (*GetStaticObjectField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetStaticObjectField. */
TypUpsJavJShort UpsVmAPI (*GetStaticShortField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetStaticShortField. */
TypUpsJavJChar UpsVmAPI *(*GetStringChars)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees ObjetChaine, TypUpsJavJBoolean *CopieDemandee);
   /* Objet : GetStringChars. */
TypUpsJavJInt UpsVmAPI (*GetStringLength)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees ObjetChaine);
   /* Objet : GetStringLength. */
TypUpsJavJBoolean UpsVmAPI (*IsInstanceOf)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Classe);
   /* Objet : IsInstanceOf(). */
TypUpsVmShort UpsVmAPI (*Initialiser)(TypUpsVmPointeurDonnees *pJavaVM, TypUpsVmPointeurDonnees *pEnvironnement,
   TypUpsJavNatTableMethodesRappel TableMethodesRappel, TypUpsVmShort TracerJava, TypUpsVmChar *UpsPath, TypUpsVmChar *ClassesJava);
   /* Objet : Initialisation de la machine virtuelle Java. */
TypUpsJavJBoolean UpsVmAPI (*IsSameObject)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet1, TypUpsVmPointeurDonnees Objet2);
   /* Objet : IsSameObject. */
TypUpsVmShort UpsVmAPI (*LireObjetJava)(TypUpsVmPointeurDonnees Env, enum EnuUpsJavObjetJava TypeObjetJava, TypUpsVmPointeurDonnees ObjetJava, 
   TypUpsVmLong *TableDimensions, TypUpsVmShort NbDimensions, enum EnuUpsVmTypeDeDonnee *TypeObjetUps, TypUpsVmPointeurDonnees ObjetUps);
   /* Objet : Lecture d'un objet Java. */
TypUpsVmPointeurDonnees UpsVmAPI (*NewByteArray)(TypUpsVmPointeurDonnees Env, TypUpsVmLong TailleTableau);
   /* Objet : NewByteArray. */
TypUpsVmPointeurDonnees UpsVmAPI (*NewCharArray)(TypUpsVmPointeurDonnees Env, TypUpsVmLong TailleTableau);
   /* Objet : NewCharArray. */
TypUpsVmPointeurDonnees UpsVmAPI (*NewGlobalRef)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees This);
   /* Objet : NewGlobalRef. */
TypUpsVmPointeurDonnees UpsVmAPI (*NewObject)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Methode,
   TypUpsJavJValue *Parametres);
   /* Objet : NewObjectC. */
TypUpsVmPointeurDonnees UpsVmAPI (*NewObjectArray)(TypUpsVmPointeurDonnees Env, TypUpsVmLong TailleTableau, TypUpsVmPointeurDonnees Classe,
   TypUpsVmPointeurDonnees ObjetInitialisation);
   /* Objet : NewObjectArray. */
TypUpsVmPointeurDonnees UpsVmAPI (*NewString)(TypUpsVmPointeurDonnees Env, TypUpsJavJChar *Chaine, TypUpsJavJInt Taille);
   /* Objet : NewString. */
TypUpsVmVoid UpsVmAPI (*ReleaseByteArrayElements)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees ObjetTableau,
   TypUpsJavJByte *Tableau, TypUpsVmShort Mode);
   /* Objet : ReleaseByteArrayElements. */
TypUpsVmVoid UpsVmAPI (*ReleaseCharArrayElements)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees ObjetTableau,
   TypUpsJavJChar *Tableau, TypUpsVmShort Mode);
   /* Objet : ReleaseCharArrayElements. */
TypUpsVmVoid UpsVmAPI (*ReleaseStringChars)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees ObjetChaine,
   TypUpsJavJChar *Chaine);
   /* Objet : ReleaseStringChars. */
TypUpsVmVoid UpsVmAPI (*SetBooleanField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJBoolean Valeur);
   /* Objet : SetBooleanField. */
TypUpsVmVoid UpsVmAPI (*SetByteArrayRegion)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees ObjetTableau, TypUpsVmLong Index, 
   TypUpsVmLong Taille, TypUpsJavJByte *Tableau);
   /* Objet : SetByteArrayRegion. */
TypUpsVmVoid UpsVmAPI (*SetByteField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJByte Valeur);
   /* Objet : SetByteField. */
TypUpsVmVoid UpsVmAPI (*SetCharArrayRegion)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees ObjetTableau, TypUpsVmLong Index, 
   TypUpsVmLong Taille, TypUpsJavJChar *Tableau);
   /* Objet : SetCharArrayRegion. */
TypUpsVmVoid UpsVmAPI (*SetCharField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJChar Valeur);
   /* Objet : SetCharField. */
TypUpsVmVoid UpsVmAPI (*SetDoubleField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJDouble Valeur);
   /* Objet : SetDoubleField. */
TypUpsVmVoid UpsVmAPI (*SetFloatField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJFloat Valeur);
   /* Objet : SetFloatField. */
TypUpsVmVoid UpsVmAPI (*SetIntField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJInt Valeur);
   /* Objet : SetIntField. */
TypUpsVmVoid UpsVmAPI (*SetLongField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJLong Valeur);
   /* Objet : SetLongField. */
TypUpsVmVoid UpsVmAPI (*SetObjectArrayElement)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees ObjetTableau, TypUpsVmLong Index, 
   TypUpsVmPointeurDonnees Valeur);
   /* Objet : SetObjectArrayElement. */
TypUpsVmVoid UpsVmAPI (*SetObjectField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Propriete, 
   TypUpsVmPointeurDonnees Valeur);
   /* Objet : SetObjectField. */
TypUpsVmVoid UpsVmAPI (*SetShortField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJShort Valeur);
   /* Objet : SetShortField. */
TypUpsVmVoid UpsVmAPI (*SetStaticBooleanField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJBoolean Valeur);
   /* Objet : SetStaticBooleanField. */
TypUpsVmVoid UpsVmAPI (*SetStaticByteField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJByte Valeur);
   /* Objet : SetStaticByteField. */
TypUpsVmVoid UpsVmAPI (*SetStaticCharField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJChar Valeur);
   /* Objet : SetStaticCharField. */
TypUpsVmVoid UpsVmAPI (*SetStaticDoubleField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJDouble Valeur);
   /* Objet : SetStaticDoubleField. */
TypUpsVmVoid UpsVmAPI (*SetStaticFloatField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJFloat Valeur);
   /* Objet : SetStaticFloatField. */
TypUpsVmVoid UpsVmAPI (*SetStaticIntField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJInt Valeur);
   /* Objet : SetStaticIntField. */
TypUpsVmVoid UpsVmAPI (*SetStaticLongField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJLong Valeur);
   /* Objet : SetStaticLongField. */
TypUpsVmVoid UpsVmAPI (*SetStaticObjectField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete, 
   TypUpsVmPointeurDonnees Valeur);
   /* Objet : SetStaticObjectField. */
TypUpsVmVoid UpsVmAPI (*SetStaticShortField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJShort Valeur);
   /* Objet : SetStaticShortField. */
TypUpsVmVoid UpsVmAPI (*Terminer)(TypUpsVmPointeurDonnees pJavaVM);
   /* Objet : Terminaison de la machine virtuelle Java. */
TypUpsVmVoid UpsVmAPI (*Throw)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees ExceptionAEnvoyer);
   /* Objet : Throw(). */
TypUpsVmVoid UpsVmAPI (*ThrowNew)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmChar *Message);
   /* Objet : ThrowNew(). */
} *TypUpsJavNatTraitements_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsJavNatTraitements_1_1_0 TypUpsJavNatTraitements;

extern DllExport TypUpsJavNatTraitements UpsVmAPI UpsJavNatDemarrerModule(TypUpsVtmMachineInterface MachineInterfaceUpsVtm);
   /* Objet : Retourne la description de Ups Jav Nat. */

/**********************/
#if defined(__cplusplus)
/**********************/
}
/****/
#endif
/****/

/****/
#endif
/****/
