/*-------------------------------------------------------------------
Fichier     : upsjav.e
Objet       : En-tete du module Up ! Java.

Module      : Up ! Java
Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.
---------------------------------------------------------------------
                         Observations

 
---------------------------------------------------------------------*/

/*****************************/
#if !defined(PasseModuleUpsJav)
/*****************************/
#define PasseModuleUpsJav 1

#include <upsjav_nt.e>

/**********************/
#if defined(__cplusplus)
/**********************/
extern "C"
{
/****/
#endif
/****/

/****************************************************************/
/* Codification de l'objet natif.                               */
/****************************************************************/
enum EnuUpsJavObjetJava2
   {
   OJ_ObjetJava=1
      /* Objet implementant Object. */
   };

/*******************************************************************/
typedef struct typupsjavmachineinterface_1_1_0
/* Objet : Interface avec la machine pour Up ! Java.               */
/*******************************************************************/
{
/*--------------------------------------------------------------*/
/* Procedures et fonctions.                                     */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Tables des methodes.                                         */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Types et interfaces.                                         */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Variables globales.                                          */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Exceptions.                                                  */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Files d'attente.                                             */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Entrepots.                                                   */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Application Program Interfaces proprietaires.                */
/*--------------------------------------------------------------*/
TypUpsJavJChar UpsVmAPI *(*Char2JChar)(TypUpsVmSession *Session, TypUpsJavJChar *Buffer, TypUpsVmLong TailleBuffer, 
   TypUpsVmUnicode *Chaine);
   /* Objet : Encode une chaine Unicode en une chaine jchar *. */
TypUpsVmUnicode UpsVmAPI *(*JChar2Char)(TypUpsVmSession *Session, TypUpsVmUnicode *Buffer, TypUpsVmLong TailleBuffer, 
   TypUpsJavJChar *Chaine);
   /* Objet : Encode une chaine jchar * en une chaine Unicode. */
/*--------------------------------------------------------------*/
/* Application Program Interfaces.   							       */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*AllouerUnTableau)(TypUpsVmPointeurDonnees Env, enum EnuUpsJavObjetJava TypeObjetJava, TypUpsVmPointeurDonnees ObjetJava, 
   TypUpsVmLong *TableDimensions, TypUpsVmShort NbDimensions, TypUpsVmLong BorneMin, TypUpsVmLong BorneMax, 
   enum EnuUpsVmTypeDeDonnee TypeObjetUps);
   /* Objet : Allocation d'un tableau. */
TypUpsVmPointeurDonnees UpsVmAPI (*AllocObject)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe);
   /* Objet : AllocObject. */
TypUpsVmVoid UpsVmAPI (*AttachCurrentThread)(TypUpsVmPointeurDonnees pJavaVM, TypUpsVmPointeurDonnees *Env);
   /* Objet : AttachCurrentThread. */
TypUpsJavJBoolean UpsVmAPI (*CallBooleanMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallBooleanMethod. */
TypUpsJavJByte UpsVmAPI (*CallByteMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallByteMethod. */
TypUpsJavJChar UpsVmAPI (*CallCharMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallCharMethod. */
TypUpsJavJDouble UpsVmAPI (*CallDoubleMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallDoubleMethod. */
TypUpsJavJFloat UpsVmAPI (*CallFloatMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallFloatMethod. */
TypUpsJavJInt UpsVmAPI (*CallIntMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallIntMethod. */
TypUpsJavJLong UpsVmAPI (*CallLongMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallLongMethod. */
TypUpsVmPointeurDonnees UpsVmAPI (*CallObjectMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallObjectMethod. */
TypUpsJavJShort UpsVmAPI (*CallShortMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallShortMethod. */
TypUpsJavJBoolean UpsVmAPI (*CallStaticBooleanMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallStaticBooleanMethod. */
TypUpsJavJByte UpsVmAPI (*CallStaticByteMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallStaticByteMethod. */
TypUpsJavJChar UpsVmAPI (*CallStaticCharMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallStaticCharMethod. */
TypUpsJavJDouble UpsVmAPI (*CallStaticDoubleMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallStaticDoubleMethod. */
TypUpsJavJFloat UpsVmAPI (*CallStaticFloatMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallStaticFloatMethod. */
TypUpsJavJInt UpsVmAPI (*CallStaticIntMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallIntMethod. */
TypUpsJavJLong UpsVmAPI (*CallStaticLongMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallStaticLongMethod. */
TypUpsVmPointeurDonnees UpsVmAPI (*CallStaticObjectMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallStaticObjectMethod. */
TypUpsJavJShort UpsVmAPI (*CallStaticShortMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallStaticShortMethod. */
TypUpsVmVoid UpsVmAPI (*CallStaticVoidMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallStaticVoidMethod. */
TypUpsVmVoid UpsVmAPI (*CallVoidMethod)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Methode, TypUpsJavJValue *Parametres);
   /* Objet : CallVoidMethod. */
TypUpsVmVoid UpsVmAPI (*ConstruireObjetJava)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Env, enum EnuUpsJavObjetJava TypeObjetJava, TypUpsVmPointeurDonnees ObjetJava);
   /* Objet : Constructeur d'un objet Java. */
TypUpsVmVoid UpsVmAPI (*DeleteGlobalRef)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees This);
   /* Objet : DeleteGlobalRef. */
TypUpsVmVoid UpsVmAPI (*DetachCurrentThread)(TypUpsVmPointeurDonnees pJavaVM);
   /* Objet : DetachCurrentThread. */
TypUpsVmShort UpsVmAPI (*EcrireObjetJava)(TypUpsVmPointeurDonnees Env, enum EnuUpsVmTypeDeDonnee TypeObjetUps, TypUpsVmPointeurDonnees ObjetUps, 
   enum EnuUpsJavObjetJava TypeObjetJava, TypUpsVmPointeurDonnees ObjetJava, TypUpsVmLong *TableDimensions, TypUpsVmShort NbDimensions);
   /* Objet : Ecriture d'un objet Java. */
TypUpsVmShort (*EstUnTableau)(TypUpsVmPointeurDonnees Env, enum EnuUpsJavObjetJava TypeObjetJava, TypUpsVmPointeurDonnees ObjetJava, TypUpsVmLong *TableDimensions, TypUpsVmShort NbDimensions, 
   TypUpsVmShort *EstNul, TypUpsVmLong *BorneMin, TypUpsVmLong *BorneMax, enum EnuUpsJavObjetJava *TypeObjetElementJava, enum EnuUpsVmTypeDeDonnee *TypeObjetElementUps);
   /* Objet : Verifie si l'objet Java est un tableau. */
TypUpsVmVoid UpsVmAPI (*ExceptionClear)(TypUpsVmPointeurDonnees Env);
   /* Objet : ExceptionClear. */
TypUpsVmVoid UpsVmAPI (*ExceptionDescribe)(TypUpsVmPointeurDonnees Env);
   /* Objet : ExceptionDescribe. */
TypUpsVmPointeurDonnees UpsVmAPI (*ExceptionOccurred)(TypUpsVmPointeurDonnees Env);
   /* Objet : ExceptionOccurred. */
TypUpsVmVoid UpsVmAPI (*FatalError)(TypUpsVmPointeurDonnees Env, TypUpsVmUnicode *Chaine);
   /* Objet : FatalError. */
TypUpsVmPointeurDonnees UpsVmAPI (*FindClass)(TypUpsVmPointeurDonnees Env, TypUpsVmUnicode *Signature);
   /* Objet : FindClass. */
TypUpsVmLong UpsVmAPI (*GetArrayLength)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees ObjetTableau);
   /* Objet : GetArrayLength. */
TypUpsJavJBoolean UpsVmAPI (*GetBooleanField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetBooleanField. */
TypUpsJavJByte UpsVmAPI *(*GetByteArrayElements)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees ObjetTableau, 
   TypUpsJavJBoolean *CopieDemandee);
   /* Objet : GetByteArrayElements. */
TypUpsJavJByte UpsVmAPI (*GetByteField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetByteField. */
TypUpsJavJChar UpsVmAPI *(*GetCharArrayElements)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees ObjetTableau, 
   TypUpsJavJBoolean *CopieDemandee);
   /* Objet : GetCharArrayElements. */
TypUpsJavJChar UpsVmAPI (*GetCharField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetCharField. */
TypUpsVmShort UpsVmAPI (*GetCreatedJavaVMs)(TypUpsVmPointeurDonnees *TableJavaVMs, TypUpsVmShort TailleTableJavaVMs, TypUpsVmShort *TailleUtilisee);
   /* Objet : GetCreatedJavaVMs. */
TypUpsJavJDouble UpsVmAPI (*GetDoubleField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetDoubleField. */
TypUpsVmPointeurDonnees UpsVmAPI (*GetFieldID)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmUnicode *NomPropriete, 
   TypUpsVmUnicode *Signature);
   /* Objet : GetFieldID. */
TypUpsJavJFloat UpsVmAPI (*GetFloatField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetFloatField. */
TypUpsJavJInt UpsVmAPI (*GetIntField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetIntField. */
TypUpsJavJLong UpsVmAPI (*GetLongField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetLongField. */
TypUpsVmPointeurDonnees UpsVmAPI (*GetMethodID)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmUnicode *NomMethode, TypUpsVmUnicode *Signature);
   /* Objet : GetMethodID. */
TypUpsVmPointeurDonnees UpsVmAPI (*GetObjectArrayElement)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees ObjetTableau, TypUpsVmLong Taille);
   /* Objet : GetObjectArrayElement. */
TypUpsVmPointeurDonnees UpsVmAPI (*GetObjectClass)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet);
   /* Objet : GetObjectClass. */
TypUpsVmPointeurDonnees UpsVmAPI (*GetObjectField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetObjectField. */
TypUpsJavJShort UpsVmAPI (*GetShortField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetShortField.  */
TypUpsJavJBoolean UpsVmAPI (*GetStaticBooleanField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetStaticBooleanField. */
TypUpsJavJByte UpsVmAPI (*GetStaticByteField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetStaticByteField. */
TypUpsJavJChar UpsVmAPI (*GetStaticCharField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetStaticCharField. */
TypUpsJavJDouble UpsVmAPI (*GetStaticDoubleField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetStaticDoubleField. */
TypUpsVmPointeurDonnees UpsVmAPI (*GetStaticFieldID)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmUnicode *NomPropriete, 
   TypUpsVmUnicode *Signature);
   /* Objet : GetStaticFieldID. */
TypUpsJavJFloat UpsVmAPI (*GetStaticFloatField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetStaticFloatField. */
TypUpsJavJInt UpsVmAPI (*GetStaticIntField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetStaticIntField. */
TypUpsJavJLong UpsVmAPI (*GetStaticLongField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetStaticLongField. */
TypUpsVmPointeurDonnees UpsVmAPI (*GetStaticMethodID)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmUnicode *NomMethode, TypUpsVmUnicode *Signature);
   /* Objet : GetStaticMethodID. */
TypUpsVmPointeurDonnees UpsVmAPI (*GetStaticObjectField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetStaticObjectField. */
TypUpsJavJShort UpsVmAPI (*GetStaticShortField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete);
   /* Objet : GetStaticShortField. */
TypUpsJavJChar UpsVmAPI *(*GetStringChars)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees ObjetChaine, TypUpsJavJBoolean *CopieDemandee);
   /* Objet : GetStringChars. */
TypUpsJavJInt UpsVmAPI (*GetStringLength)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees ObjetChaine);
   /* Objet : GetStringLength. */
TypUpsJavJBoolean UpsVmAPI (*IsInstanceOf)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Classe);
   /* Objet : IsInstanceOf(). */
TypUpsVmShort UpsVmAPI (*Initialiser)(TypUpsVmPointeurDonnees *pJavaVM, TypUpsVmPointeurDonnees *pEnvironnement,
   TypUpsJavNatTableMethodesRappel TableMethodesRappel, TypUpsVmShort TracerJava, TypUpsVmChar *UpsPath, TypUpsVmChar *ClassesJava);
   /* Objet : Initialisation de la machine virtuelle Java. */
TypUpsJavJBoolean UpsVmAPI (*IsSameObject)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet1, TypUpsVmPointeurDonnees Objet2);
   /* Objet : IsSameObject. */
TypUpsVmShort UpsVmAPI (*LireObjetJava)(TypUpsVmPointeurDonnees Env, enum EnuUpsJavObjetJava TypeObjetJava, TypUpsVmPointeurDonnees ObjetJava, 
   TypUpsVmLong *TableDimensions, TypUpsVmShort NbDimensions, enum EnuUpsVmTypeDeDonnee *TypeObjetUps, TypUpsVmPointeurDonnees ObjetUps);
   /* Objet : Lecture d'un objet Java. */
TypUpsVmPointeurDonnees UpsVmAPI (*NewByteArray)(TypUpsVmPointeurDonnees Env, TypUpsVmLong TailleTableau);
   /* Objet : NewByteArray. */
TypUpsVmPointeurDonnees UpsVmAPI (*NewCharArray)(TypUpsVmPointeurDonnees Env, TypUpsVmLong TailleTableau);
   /* Objet : NewCharArray. */
TypUpsVmPointeurDonnees UpsVmAPI (*NewGlobalRef)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees This);
   /* Objet : NewGlobalRef. */
TypUpsVmPointeurDonnees UpsVmAPI (*NewObject)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Methode, 
   TypUpsJavJValue *Parametres);
   /* Objet : NewObject. */
TypUpsVmPointeurDonnees UpsVmAPI (*NewObjectArray)(TypUpsVmPointeurDonnees Env, TypUpsVmLong TailleTableau, TypUpsVmPointeurDonnees Classe,
   TypUpsVmPointeurDonnees ObjetInitialisation);
   /* Objet : NewObjectArray. */
TypUpsVmPointeurDonnees UpsVmAPI (*NewString)(TypUpsVmPointeurDonnees Env, TypUpsJavJChar *Chaine, TypUpsJavJInt Taille);
   /* Objet : NewString. */
TypUpsVmVoid UpsVmAPI (*ReleaseByteArrayElements)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees ObjetTableau,
   TypUpsJavJByte *Tableau, TypUpsVmShort Mode);
   /* Objet : ReleaseByteArrayElements. */
TypUpsVmVoid UpsVmAPI (*ReleaseCharArrayElements)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees ObjetTableau,
   TypUpsJavJChar *Tableau, TypUpsVmShort Mode);
   /* Objet : ReleaseCharArrayElements. */
TypUpsVmVoid UpsVmAPI (*ReleaseStringChars)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees ObjetChaine,
   TypUpsJavJChar *Chaine);
   /* Objet : ReleaseStringChars. */
TypUpsVmVoid UpsVmAPI (*SetBooleanField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJBoolean Valeur);
   /* Objet : SetBooleanField. */
TypUpsVmVoid UpsVmAPI (*SetByteArrayRegion)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees ObjetTableau, TypUpsVmLong Index, 
   TypUpsVmLong Taille, TypUpsJavJByte *Tableau);
   /* Objet : SetByteArrayRegion. */
TypUpsVmVoid UpsVmAPI (*SetByteField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJByte Valeur);
   /* Objet : SetByteField. */
TypUpsVmVoid UpsVmAPI (*SetCharArrayRegion)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees ObjetTableau, TypUpsVmLong Index, 
   TypUpsVmLong Taille, TypUpsJavJChar *Tableau);
   /* Objet : SetCharArrayRegion. */
TypUpsVmVoid UpsVmAPI (*SetCharField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJChar Valeur);
   /* Objet : SetCharField. */
TypUpsVmVoid UpsVmAPI (*SetDoubleField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJDouble Valeur);
   /* Objet : SetDoubleField. */
TypUpsVmVoid UpsVmAPI (*SetFloatField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJFloat Valeur);
   /* Objet : SetFloatField. */
TypUpsVmVoid UpsVmAPI (*SetIntField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJInt Valeur);
   /* Objet : SetIntField. */
TypUpsVmVoid UpsVmAPI (*SetLongField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJLong Valeur);
   /* Objet : SetLongField. */
TypUpsVmVoid UpsVmAPI (*SetObjectArrayElement)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees ObjetTableau, TypUpsVmLong Index, 
   TypUpsVmPointeurDonnees Valeur);
   /* Objet : SetObjectArrayElement. */
TypUpsVmVoid UpsVmAPI (*SetObjectField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Propriete, 
   TypUpsVmPointeurDonnees Valeur);
   /* Objet : SetObjectField. */
TypUpsVmVoid UpsVmAPI (*SetShortField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJShort Valeur);
   /* Objet : SetShfortField. */
TypUpsVmVoid UpsVmAPI (*SetStaticBooleanField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJBoolean Valeur);
   /* Objet : SetStaticBooleanField. */
TypUpsVmVoid UpsVmAPI (*SetStaticByteField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJByte Valeur);
   /* Objet : SetStaticByteField. */
TypUpsVmVoid UpsVmAPI (*SetStaticCharField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJChar Valeur);
   /* Objet : SetStaticCharField. */
TypUpsVmVoid UpsVmAPI (*SetStaticDoubleField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJDouble Valeur);
   /* Objet : SetStaticDoubleField. */
TypUpsVmVoid UpsVmAPI (*SetStaticFloatField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJFloat Valeur);
   /* Objet : SetStaticFloatField. */
TypUpsVmVoid UpsVmAPI (*SetStaticIntField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJInt Valeur);
   /* Objet : SetStaticIntField. */
TypUpsVmVoid UpsVmAPI (*SetStaticLongField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJLong Valeur);
   /* Objet : SetStaticLongField. */
TypUpsVmVoid UpsVmAPI (*SetStaticObjectField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete, 
   TypUpsVmPointeurDonnees Valeur);
   /* Objet : SetStaticObjectField. */
TypUpsVmVoid UpsVmAPI (*SetStaticShortField)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Propriete, 
   TypUpsJavJShort Valeur);
   /* Objet : SetStaticShortField. */
TypUpsVmVoid UpsVmAPI (*Terminer)(TypUpsVmPointeurDonnees pJavaVM);
   /* Objet : Terminaison de la machine virtuelle Java. */
TypUpsVmVoid UpsVmAPI (*Throw)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees ExceptionAEnvoyer);
   /* Objet : Throw(). */
TypUpsVmVoid UpsVmAPI (*ThrowNew)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmUnicode *Message);
   /* Objet : ThrowNew(). */
} *TypUpsJavMachineInterface_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsJavMachineInterface_1_1_0 TypUpsJavMachineInterface;

/****************************************************************/
typedef struct typupsjavinterfaceimplementee
/* Objet : Implementation generique d'un objet Java.            */
/****************************************************************/
{
enum EnuUpsJavObjetJava2 Sorte;
   /* Sorte de l'objet natif. */
union
   {
   TypUpsVmPointeurDonnees ObjetJava;
      /* Cas OJ_ObjetJava. */
   } Selection;
   /* Selection en fonction de la sorte. */
} TypUpsJavInterfaceImplementee;

/****************************************************************/
typedef struct typupsjavdonnees
/* Objet: Interface des donnees de Ups Jav.                     */
/****************************************************************/
{
struct typupsvmentetedonneesmodule EnteteDonneesModule;
   /* Entete generique du module. */
TypUpsVmLong NbObjetsCrees;
   /* Nombre d'objets de crees. */
TypUpsVmShort TraceJava;
   /* Si Vrai, il faut tracer Ups Jav. */
TypUpsVmPointeurDonnees EnvPrincipal;
   /* Environnement de la tache principale le temps de l'initialisation. */
TypUpsVmPointeurDonnees JavaVM;
	/* Descripteur de la machine virtuelle Java. */
TypUpsVmShort EstDisponible;
   /* Si Vrai, le serveur Java est disponible. */
/*--------------------------------------------------------------*/
/* Methodes de rappel vers UpsKrnSJ.                            */
/*--------------------------------------------------------------*/
} *TypUpsJavDonnees;

/****************************************************************/
typedef struct typupsjavtraitements_1_1_0
/* Objet: Interface des traitements de Ups Jav.                 */
/****************************************************************/
{
struct typupsvmentetemethodesmodule EnteteMethodesModule;
   /* Methodes generiques au module. */ 

/*--------------------------------------------------------------*/
/* Procedures et fonctions.                                     */
/*--------------------------------------------------------------*/
TypUpsVmLong UpsVmAPI (*CalculerIndexAppel)(TypUpsVmPointeurDonnees InterfaceAppel, TypUpsVmPointeurDonnees AppelCourant);
   /* Objet : Calcule l'index de l'appel. */

/*--------------------------------------------------------------*/
/* Tables des methodes.                                         */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Enumeres.			              				                   */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Entrepots.          								                   */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Types et interfaces.                                         */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Variables globales.                                          */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Exceptions.                                                  */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*UpsException1_get)(TypUpsVmSession *Session);
   /* CreationObjetJavaImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException2_get)(TypUpsVmSession *Session);
   /* ConversionJavaImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException3_get)(TypUpsVmSession *Session);
   /* ExecutionJavaImpossible. */

/*--------------------------------------------------------------*/
/* Files d'attente.                                             */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Application Program Interfaces proprietaires.                */
/*--------------------------------------------------------------*/
TypUpsVmPointeurDonnees UpsVmAPI (*ExposerObjet)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees This);
   /* Objet : Expose un objet. */
TypUpsVmVoid UpsVmAPI (*NePlusExposerObjet)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees This);
   /* Objet : N'expose plus un objet. */
TypUpsVmVoid UpsVmAPI (*TracerJava)(TypUpsVmSession *Session, TypUpsVmUnicode *Filtre, TypUpsVmPointeurDonnees P1, TypUpsVmPointeurDonnees P2, TypUpsVmPointeurDonnees P3, 
   TypUpsVmPointeurDonnees P4, TypUpsVmPointeurDonnees P5, TypUpsVmPointeurDonnees P6);
   /* Objet : Trace une action de Ups Java. */
TypUpsVmVoid UpsVmAPI (*TracerCodeErreur)(TypUpsVmSession *Session, enum EnuUpsJavCodeErreur CodeErreur);
   /* Objet : Trace un code d'erreur. */
TypUpsVmShort UpsVmAPI (*ConstruireObjet)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees *pResultat,
   TypUpsVmAdresse *AdresseObjet, TypUpsVmPointeurDonnees ClasseType, TypUpsVmUnicode *NomObjetType);
   /* Objet : Construit un objet. */
TypUpsVmVoid UpsVmAPI (*DetruireObjet)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees This);
   /* Objet : Destructeur d'un objet. */
TypUpsVmVoid UpsVmAPI (*ExtraireAdresseObjet)(TypUpsVmPointeurDonnees Env, TypUpsVmAdresse *AdresseObjet, TypUpsVmPointeurDonnees Objet);
   /* Objet : Extrait l'adresse Ups de l'objet. */
TypUpsVmVoid UpsVmAPI (*MiseAJourAdresseObjet)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Mise a jour de l'adresse Ups de l'objet. */
TypUpsJavJChar UpsVmAPI *(*Char2JChar)(TypUpsVmSession *Session, TypUpsJavJChar *Buffer, TypUpsVmLong TailleBuffer, TypUpsVmUnicode *Chaine);
   /* Objet : Encode une chaine Unicode en une chaine jchar *. */
TypUpsVmUnicode UpsVmAPI *(*JChar2Char)(TypUpsVmSession *Session, TypUpsVmUnicode *Buffer, TypUpsVmLong TailleBuffer, TypUpsJavJChar *Chaine);
   /* Objet : Encode une chaine jchar * en une chaine Unicode. */
TypUpsVmPointeurDonnees UpsVmAPI (*Binaire2String)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Env, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Lit un objet de type Binaire en un objet de type String. */
TypUpsVmPointeurDonnees UpsVmAPI (*Binaire2TableauByte)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Env, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Lit un objet de type Binaire en un objet de type byte[]. */
TypUpsVmPointeurDonnees UpsVmAPI (*Binaire2TableauByteEntite)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Env, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Lit un objet de type Binaire en un objet de type Byte[]. */
TypUpsVmPointeurDonnees UpsVmAPI (*Caractere2String)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Env, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Lit un objet de type Caractere en un objet de type String. */
TypUpsVmPointeurDonnees UpsVmAPI (*Caractere2TableauChar)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Env, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Lit un objet de type Caractere en un objet de type char[]. */
TypUpsVmPointeurDonnees UpsVmAPI (*Caractere2TableauCharacter)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Env, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Lit un objet de type Caractere en un objet de type Character[]. */
TypUpsVmAdresse UpsVmAPI *(*String2Binaire)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
	TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Binaire);
   /* Objet : Lit un objet de type String en un objet de type Binaire. */
TypUpsVmAdresse UpsVmAPI *(*TableauByte2Binaire)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
	TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Binaire);
   /* Objet : Lit un objet de type byte[] en un objet de type Binaire. */
TypUpsVmAdresse UpsVmAPI *(*String2Caractere)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
	TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Caractere);
   /* Objet : Lit un objet de type String en un objet de type Caractere. */
TypUpsVmAdresse UpsVmAPI *(*TableauChar2Caractere)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
	TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Caractere);
   /* Objet : Lit un objet de type TypUpsVmChar[] en un objet de type Caractere. */
TypUpsVmAdresse UpsVmAPI *(*TableauCharacter2Caractere)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
	TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Caractere);
   /* Objet : Lit un objet de type Character[] en un objet de type Caractere. */
TypUpsVmUnsignedChar UpsVmAPI (*ExtraireChampEnumereCourt)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Objet, TypUpsVmUnicode *NomChamp,
	TypUpsVmShort EstStatique, TypUpsVmShort Type);
   /* Objet : Extrait un champ enumere court. */
TypUpsVmUnsignedShort UpsVmAPI (*ExtraireChampEnumereLong)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Objet, TypUpsVmUnicode *NomChamp,
	TypUpsVmShort EstStatique, TypUpsVmShort Type);
   /* Objet : Extrait un champ enumere long. */
TypUpsVmLong UpsVmAPI (*ExtraireChampEntier)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Objet, TypUpsVmUnicode *NomChamp,
	TypUpsVmShort EstStatique, TypUpsVmShort Type);
   /* Objet : Extrait un champ entier. */
TypUpsVmDouble UpsVmAPI (*ExtraireChampReel)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Objet, TypUpsVmUnicode *NomChamp,
	TypUpsVmShort EstStatique, TypUpsVmShort Type);
   /* Objet : Extrait un champ reel. */
TypUpsVmPointeurDonnees UpsVmAPI (*ExtraireChampObjet)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Objet, TypUpsVmUnicode *NomChamp,
	TypUpsVmShort EstStatique, TypUpsVmShort Type, TypUpsVmUnicode *NomObjetType);
   /* Objet : Extrait un champ reel. */
TypUpsVmVoid UpsVmAPI (*MiseAJourChampEnumereCourt)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Objet, TypUpsVmUnicode *NomChamp,
	TypUpsVmShort EstStatique, TypUpsVmShort Type, TypUpsVmUnsignedChar Valeur);
   /* Objet : Mise a jour d'un champ enumere court. */
TypUpsVmVoid UpsVmAPI (*MiseAJourChampEnumereLong)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Objet, TypUpsVmUnicode *NomChamp,
	TypUpsVmShort EstStatique, TypUpsVmShort Type, TypUpsVmUnsignedShort Valeur);
   /* Objet : Mise a jour d'un champ enumere long. */
TypUpsVmVoid UpsVmAPI (*MiseAJourChampEntier)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Objet, TypUpsVmUnicode *NomChamp,
	TypUpsVmShort EstStatique, TypUpsVmShort Type, TypUpsVmLong Valeur);
   /* Objet : Mise a jour d'un champ entier. */
TypUpsVmVoid UpsVmAPI (*MiseAJourChampReel)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Objet, TypUpsVmUnicode *NomChamp,
	TypUpsVmShort EstStatique, TypUpsVmShort Type, TypUpsVmDouble Valeur);
   /* Objet : Mise a jour d'un champ reel. */
TypUpsVmVoid UpsVmAPI (*MiseAJourChampObjet)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Classe, TypUpsVmPointeurDonnees Objet, TypUpsVmUnicode *NomChamp,
	TypUpsVmShort EstStatique, TypUpsVmShort Type, TypUpsVmPointeurDonnees Valeur, TypUpsVmUnicode *Signature);
   /* Objet : Met a jour d'un champ objet. */
TypUpsVmVoid UpsVmAPI (*EnvoyerErreurInfo)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Env, enum EnuUpsJavCodeErreur CodeErreur);
   /* Objet : Envoie ErreurInfo suite a une exception. */
TypUpsVmVoid UpsVmAPI (*PlusDeMemoire)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Env, TypUpsVmUnicode *NomClasse);
   /* Objet : Signale une erreur suite a la nom creation d'un objet. */
TypUpsVmPointeurDonnees UpsVmAPI (*UtiliserObjetJava)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees This);
   /* Objet : Utilise l'objet issu d'une classe ou d'une interface. */
TypUpsVmVoid UpsVmAPI (*NePlusUtiliserObjetJava)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees This);
   /* Objet : N'utilise plus l'objet issu d'une classe ou d'une interface. */
TypUpsVmShort UpsVmAPI (*CreerObjetAppel)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmPointeurDonnees Env,
   TypUpsVmPointeurDonnees NomClasse, TypUpsVmPointeurDonnees NomMethode, TypUpsVmPointeurDonnees Prototype, TypUpsVmPointeurDonnees Objet);
   /* Objet : Cree un objet appel. */
TypUpsVmPointeurDonnees UpsVmAPI (*RechercherEnvironnementThread)(TypUpsVmSession *Session);
   /* Objet : Recherche l'environnement Java d'un thread. */
TypUpsVmPointeurDonnees UpsVmAPI (*ExtraireObjetJava)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Extrait l'implementation d'un objet issu d'une classe ou d'une interface Java. */
TypUpsVmAdresse UpsVmAPI *(*CreerObjetJava)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
	TypUpsVmAdresse *AdresseObjetType, TypUpsVmPointeurDonnees ObjetType, TypUpsVmPointeurDonnees *Objet);
   /* Objet : Cree un objet issu d'une classe ou d'une interface. */
TypUpsVmVoid UpsVmAPI (*DetruireObjetJava)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Detruit un objet issu d'une classe ou d'une interface. */
TypUpsVmVoid UpsVmAPI (*ClonerObjetJava)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmAdresse *AdresseObjet, TypUpsVmAdresse *AdresseObjetType);
   /* Objet : Cree un objet issu d'une interface. */
TypUpsVmAdresse UpsVmAPI *(*ObjetJava2Objet)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjetType, 
	TypUpsVmPointeurDonnees Objet, TypUpsVmShort NePasTesterEncapsulation);
   /* Objet : Cree un objet d'un objet issu d'une classe ou d'une interface. */
TypUpsVmVoid UpsVmAPI (*ExporterObjetJava)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Env, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Exporte un objet issu d'une interface. */
TypUpsVmVoid UpsVmAPI (*ImporterObjetJava)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Env, TypUpsVmAdresse *AdresseResultat, 
	TypUpsVmAdresse *AdresseObjetType);
   /* Objet : Importe un objet issu d'une interface. */
TypUpsJavJBoolean UpsVmAPI (*ExtraireBoolean)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet);
   /* Objet : Extrait la valeur du booleen. */
TypUpsJavJByte UpsVmAPI (*ExtraireByte)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet);
   /* Objet : Extrait la valeur du byte. */
TypUpsJavJChar UpsVmAPI (*ExtraireCharacter)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet);
   /* Objet : Extrait la valeur du character. */
TypUpsJavJDouble UpsVmAPI (*ExtraireDouble)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet);
   /* Objet : Extrait la valeur du double. */
TypUpsJavJFloat UpsVmAPI (*ExtraireFloat)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet);
   /* Objet : Extrait la valeur du float. */
TypUpsJavJInt UpsVmAPI (*ExtraireInteger)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet);
   /* Objet : Extrait la valeur du integer. */
TypUpsJavJLong UpsVmAPI (*ExtraireLong)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet);
   /* Objet : Extrait la valeur du long. */
TypUpsJavJShort UpsVmAPI (*ExtraireShort)(TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet);
   /* Objet : Extrait la valeur du short. */
TypUpsVmAdresse UpsVmAPI *(*Object2Objet)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmPointeurDonnees Env, TypUpsVmPointeurDonnees Objet, TypUpsVmShort NePasTesterEncapsulation);
   /* Objet : Cree un objet d'un objet Object. */
TypUpsVmPointeurDonnees UpsVmAPI (*CreerBoolean)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Env, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Cree un Boolean. */
TypUpsVmPointeurDonnees UpsVmAPI (*CreerByte)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Env, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Cree un Byte. */
TypUpsVmPointeurDonnees UpsVmAPI (*CreerCharacter)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Env, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Cree un Character. */
TypUpsVmPointeurDonnees UpsVmAPI (*CreerDouble)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Env, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Cree un Double. */
TypUpsVmPointeurDonnees UpsVmAPI (*CreerFloat)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Env, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Cree un Float. */
TypUpsVmPointeurDonnees UpsVmAPI (*CreerInteger)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Env, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Cree un Integer. */
TypUpsVmPointeurDonnees UpsVmAPI (*CreerLong)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Env, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Cree un Long. */
TypUpsVmPointeurDonnees UpsVmAPI (*CreerShort)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Env, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Cree un Short. */
TypUpsVmPointeurDonnees UpsVmAPI (*Objet2Object)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Env, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Cree un objet Object a partir d'un objet. */
TypUpsVmVoid UpsVmAPI (*EnvoyerExceptionStandard)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Env, TypUpsVmUnicode *LibelleAppel);
   /* Objet : Envoie une exception. */
TypUpsVmPointeurDonnees UpsVmAPI (*EcrireObjetJava)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Env, enum EnuUpsVmTypeDeDonnee TypeObjetUps, 
   TypUpsVmPointeurDonnees ObjetUps, enum EnuUpsJavObjetJava TypeObjetJava);
   /* Objet : Ecriture d'un objet Java. */
TypUpsVmVoid UpsVmAPI (*LireObjetJava)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees Env, enum EnuUpsJavObjetJava TypeObjetJava, 
   TypUpsVmPointeurDonnees ObjetJava, enum EnuUpsVmTypeDeDonnee TypeObjetUps, TypUpsVmPointeurDonnees ObjetUps);
   /* Objet : Lecture d'un objet Java. */
TypUpsJavMachineInterface UpsVmAPI (*LireMachineInterface)(TypUpsVmVoid);
   /* Objet : Lit l'interface avec la machine pour Ups Jav. */
} *TypUpsJavTraitements_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsJavTraitements_1_1_0 TypUpsJavTraitements;

extern DllExport TypUpsVtmDemarrer UpsVmAPI UpsJavDemarrerModule(TypUpsVmShort Numero, TypUpsVtmMachineInterface MachineInterfaceUpsVtm,
   TypUpsVtmTraitements IntTrtUpsVtm, TypUpsVtmDonnees IntDonUpsVtm);
   /* Objet : Retourne la description de Ups Jav. */

/**********************/
#if defined(__cplusplus)
/**********************/
}
/****/
#endif
/****/

/****/
#endif
/****/
