/* ------------------------------------------------------------------- */
/* Fichier    : tache.java                                             */
/* Objet      : Exemple d'emploi d'Up ! Java.                          */
/*                                                                     */
/* Module      : Up ! Appplication System.                             */
/* Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.                    */
/* ------------------------------------------------------------------- */
/*                          Observations                               */
/*                                                                     */ 
/*                                                                     */ 
/* ------------------------------------------------------------------- */

import UpsKrn.Caractere;
import UpsKrn.MUpsKrn;
import UpsSys.Synchronisation;
import UpsSys.Tache;
import UpsSys.MUpsSys;
import UpsKrn.UpsException;

public class tache
/*****************/
{
static Synchronisation S;
static Tache T1;
static Caractere C;

static int PrincipalT1(Tache T)
/*****************************/
{
try
   {
   System.out.println("Debut de la tche "+MUpsKrn.Caractere2JavaString(T.NomTache()));

   S.Prendre(MUpsSys.SynchronisationLecturePartagee);
   MUpsSys.Attendre(1);
   System.out.println("T1 (1) : C="+MUpsKrn.Caractere2JavaString(C));
   S.Lacher();

   S.Prendre(MUpsSys.SynchronisationLecturePartagee);
   MUpsSys.Attendre(1);
   System.out.println("T1 (2) : C="+MUpsKrn.Caractere2JavaString(C));
   S.Lacher();

   S.Prendre(MUpsSys.SynchronisationLecturePartagee);
   MUpsSys.Attendre(1);
   System.out.println("T1 (3) : C="+MUpsKrn.Caractere2JavaString(C));
   S.Lacher();

   S.Prendre(MUpsSys.SynchronisationLectureExclusive);
   MUpsSys.Attendre(1);
   System.out.println("T1 (4) : C="+MUpsKrn.Caractere2JavaString(C));
   S.Lacher();

   S.Prendre(MUpsSys.SynchronisationLectureExclusive);
   MUpsSys.Attendre(1);
   System.out.println("T1 (5) : C="+MUpsKrn.Caractere2JavaString(C));
   S.Lacher();

   S.Prendre(MUpsSys.SynchronisationLectureExclusive);
   MUpsSys.Attendre(1);
   System.out.println("T1 (6) : C="+MUpsKrn.Caractere2JavaString(C));
   S.Lacher();

   T.SuspendreTache();

   for (;;)
      {
      System.out.println("Je ne fais rien");
      MUpsSys.Attendre(1);
      }
   }
catch (UpsException e)
   {
   try
      {
      System.out.println("Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '"
         +e.NomSourceEnErreur+"' ligne "+e.NumeroLigne+", colonne "+e.NumeroColonne+" :");
      System.out.println(e.MessageErreur);
      }
   catch (java.lang.Throwable e2)
      {
      System.out.println(e2.toString());
      }      
   }
return(0);
}

public static void main(String s[]) 
/*********************************/
{
try
   {
   if (!MUpsKrn.Demarrer())
      return;
   if (!MUpsSys.Demarrer())
      return;

   S=Synchronisation.Synchronisation(MUpsKrn.JavaString2Caractere("ExempleDeSynchronisation"),MUpsSys.SynchronisationPrivee);
   S.Prendre(MUpsSys.SynchronisationEcritureExclusive);
   T1=Tache.Tache(MUpsKrn.JavaString2Caractere("ExempleDeTache"),MUpsKrn.JavaMethod2Appel("tache","PrincipalT1","(LUpsSys/Tache;)I",null),false);

   C=MUpsKrn.JavaString2Caractere("coucou");
   System.out.println("TP (1) : C="+MUpsKrn.Caractere2JavaString(C));
   MUpsSys.Attendre(5);
   S.Lacher();

   S.Prendre(MUpsSys.SynchronisationEcriturePartagee);
   MUpsSys.Attendre(1);
   C=MUpsKrn.JavaString2Caractere("coucou2");
   System.out.println("TP (2) : C="+MUpsKrn.Caractere2JavaString(C));
   S.Lacher();

   S.Prendre(MUpsSys.SynchronisationEcriturePartagee);
   MUpsSys.Attendre(1);
   C=MUpsKrn.JavaString2Caractere("coucou3");
   System.out.println("TP (3) : C="+MUpsKrn.Caractere2JavaString(C));
   S.Lacher();

   S.Prendre(MUpsSys.SynchronisationEcriturePartagee);
   MUpsSys.Attendre(1);
   S.Lacher();

   MUpsSys.Attendre(5);
   if (T1.EstSuspendue())
      System.out.println("T1 est suspendue");
   else
      System.out.println("T1 n'est pas suspendue");
   T1.ReprendreTache();

   MUpsSys.Attendre(5);
   T1.ArreterTache(1);
   if (T1.EstTerminee())
      System.out.println("T1 est termine");
   System.out.println("Code retour de T1="+T1.CodeRetour());
   T1=null;

   MUpsSys.Arreter();
   MUpsKrn.Arreter();
   }
catch (UpsException e)
   {
   try
      {
      System.out.println("Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '"
         +e.NomSourceEnErreur+"' ligne "+e.NumeroLigne+", colonne "+e.NumeroColonne+" :");
      System.out.println(e.MessageErreur);
      }
   catch (java.lang.Throwable e2)
      {
      System.out.println(e2.toString());
      }      
   }
}
}


