/* ------------------------------------------------------------------- */
/* Fichier    : tableau.java                                           */
/* Objet      : Exemple d'emploi d'Up ! Java.                          */
/*                                                                     */
/* Module      : Up ! Appplication System.                             */
/* Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.                    */
/* ------------------------------------------------------------------- */
/*                          Observations                               */
/*                                                                     */ 
/*                                                                     */ 
/* ------------------------------------------------------------------- */

import UpsKrn.Caractere;
import UpsKrn.Entier;
import UpsKrn.Objet;
import UpsKrn.Tableau;
import UpsKrn.MUpsKrn;
import UpsKrn.UpsException;

public class tableau
/********************/
{
static void EcrireTableau(Caractere M, Tableau T)
/***********************************************/
{
int I;
   
try
   {
   System.out.println(MUpsKrn.Caractere2JavaString(M));
   for (I=T.BorneMin();;I++)
      {
      System.out.println(MUpsKrn.Caractere2JavaString((Caractere)T.Index(MUpsKrn.JavaInt2Entier(I))));
      if (I==T.BorneMax())
         break;
      }
   System.out.println("\n");
   }
catch (UpsException e)
   {
   try
      {
      System.out.println("Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '"
         +e.NomSourceEnErreur+"' ligne "+e.NumeroLigne+", colonne "+e.NumeroColonne+" :");
      System.out.println(e.MessageErreur);
      }
   catch (java.lang.Throwable e2)
      {
      System.out.println(e2.toString());
      }      
   }
}
 
static void EcrireEntier(Caractere M, Entier E)
/*********************************************/
{
try
   {
   System.out.println(MUpsKrn.Caractere2JavaString(M));
   System.out.println(MUpsKrn.Entier2JavaInt(E));
   System.out.println("\n");
   }
catch (UpsException e)
   {
   try
      {
      System.out.println("Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '"
         +e.NomSourceEnErreur+"' ligne "+e.NumeroLigne+", colonne "+e.NumeroColonne+" :");
      System.out.println(e.MessageErreur);
      }
   catch (java.lang.Throwable e2)
      {
      System.out.println(e2.toString());
      }      
   }
}

static Objet IncrementerElementTableau(Tableau T, Entier Index, boolean Prefixe)
/******************************************************************************/
{
Entier E;

E=null;
try
   {
   E=((Entier)T.Index(Index)).Incrementer(Prefixe);
   }
catch (UpsException e)
   {
   try
      {
      System.out.println("Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '"
         +e.NomSourceEnErreur+"' ligne "+e.NumeroLigne+", colonne "+e.NumeroColonne+" :");
      System.out.println(e.MessageErreur);
      }
   catch (java.lang.Throwable e2)
      {
      System.out.println(e2.toString());
      }      
   }
return(E);
}

static Objet DecrementerElementTableau(Tableau T, Entier Index, boolean Prefixe)
/******************************************************************************/
{
Entier E;

E=null;
try
   {
   E=((Entier)T.Index(Index)).Decrementer(Prefixe);
   }
catch (UpsException e)
   {
   try
      {
      System.out.println("Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '"
         +e.NomSourceEnErreur+"' ligne "+e.NumeroLigne+", colonne "+e.NumeroColonne+" :");
      System.out.println(e.MessageErreur);
      }
   catch (java.lang.Throwable e2)
      {
      System.out.println(e2.toString());
      }      
   }
return(E);
}

static void AdditionnerAffecterElementTableau(Tableau T, Entier Index, Entier E)
/******************************************************************************/
{
try
   {
   T.Index2(Index,((Entier)T.Index(Index)).Additionner(E));
   }
catch (UpsException e)
   {
   try
      {
      System.out.println("Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '"
         +e.NomSourceEnErreur+"' ligne "+e.NumeroLigne+", colonne "+e.NumeroColonne+" :");
      System.out.println(e.MessageErreur);
      }
   catch (java.lang.Throwable e2)
      {
      System.out.println(e2.toString());
      }      
   }
}

public static void main(String s[]) 
/*********************************/
{
Tableau T;
Tableau T2;
Tableau T3;
Caractere C;
Tableau T4;

try
   {
   if (!MUpsKrn.Demarrer())
      return;

   T=Tableau.Tableau(MUpsKrn.Caractere(),10,MUpsKrn.JavaString2Caractere(""));
   T2=Tableau.Tableau2(MUpsKrn.Caractere(),1,3,MUpsKrn.JavaString2Caractere(""));
   T3=null;
   T4=Tableau.Tableau(MUpsKrn.Caractere(),1,MUpsKrn.JavaInt2Entier(0));

   C=MUpsKrn.JavaString2Caractere("a");
   T.Index2(MUpsKrn.JavaInt2Entier(0),C);
   T.Index2(MUpsKrn.JavaInt2Entier(1),MUpsKrn.JavaString2Caractere("A"));
   T.Index2(MUpsKrn.JavaInt2Entier(2),C);
   T.Index2(MUpsKrn.JavaInt2Entier(3),MUpsKrn.JavaString2Caractere("B"));
   T.Index2(MUpsKrn.JavaInt2Entier(4),C);
   T.Index2(MUpsKrn.JavaInt2Entier(5),MUpsKrn.JavaString2Caractere("C"));
   EcrireTableau(MUpsKrn.JavaString2Caractere("Construction"), T);
   T2.Index2(MUpsKrn.JavaInt2Entier(1),MUpsKrn.JavaString2Caractere("X"));
   T2.Index2(MUpsKrn.JavaInt2Entier(2),MUpsKrn.JavaString2Caractere("Y"));
   T2.Index2(MUpsKrn.JavaInt2Entier(3),MUpsKrn.JavaString2Caractere("Z"));
   EcrireTableau(MUpsKrn.JavaString2Caractere("Inserer"), ((Tableau)T.Cloner(null,MUpsKrn.ClonageObjetSeul)).Inserer(T2,MUpsKrn.JavaInt2Entier(2)));
   System.out.println(MUpsKrn.Entier2JavaInt(T.Compter((Objet)C,MUpsKrn.JavaInt2Entier(0))));
   System.out.println(MUpsKrn.Entier2JavaInt(T.Compter((Objet)C,MUpsKrn.JavaInt2Entier(1))));
   T3=(Tableau)T.Cloner(null,MUpsKrn.ClonageObjetSeul);
   T3.RemplacerTous(C,MUpsKrn.JavaString2Caractere("X"),MUpsKrn.JavaInt2Entier(0));
   EcrireTableau(MUpsKrn.JavaString2Caractere("Remplacer"), T3);
   T3=(Tableau)T.Cloner(null,MUpsKrn.ClonageObjetSeul);
   T3.RemplacerTous(C,MUpsKrn.JavaString2Caractere("X"),MUpsKrn.JavaInt2Entier(2));
   EcrireTableau(MUpsKrn.JavaString2Caractere("Remplacer"), T3);
   System.out.println(MUpsKrn.Entier2JavaInt(T.Rechercher(C,MUpsKrn.JavaInt2Entier(0))));
   System.out.println(MUpsKrn.Entier2JavaInt(T.Rechercher(C,MUpsKrn.JavaInt2Entier(1))));
   EcrireTableau(MUpsKrn.JavaString2Caractere("Supprimer"), T.SupprimerTous(C,MUpsKrn.JavaInt2Entier(0)));
   EcrireTableau(MUpsKrn.JavaString2Caractere("Supprimer"), T.SupprimerTous(C,MUpsKrn.JavaInt2Entier(2)));
   T3=((Tableau)T.Cloner(null,MUpsKrn.ClonageObjetSeul)).Retailler(20,(Objet)Caractere.Caractere());
   EcrireTableau(MUpsKrn.JavaString2Caractere("Retailler(20)"), T3);
   T3=((Tableau)T.Cloner(null,MUpsKrn.ClonageObjetSeul)).Retailler(2,(Objet)Caractere.Caractere());
   EcrireTableau(MUpsKrn.JavaString2Caractere("Retailler(2)"), T3);
   T4.Index2(MUpsKrn.JavaInt2Entier(0),MUpsKrn.JavaInt2Entier(1));
   EcrireEntier(MUpsKrn.JavaString2Caractere("[]++"),((Entier)IncrementerElementTableau(T4,MUpsKrn.JavaInt2Entier(0),false)));
   EcrireEntier(MUpsKrn.JavaString2Caractere("[]--"),((Entier)DecrementerElementTableau(T4,MUpsKrn.JavaInt2Entier(0),false)));
   EcrireEntier(MUpsKrn.JavaString2Caractere("++[]"),((Entier)IncrementerElementTableau(T4,MUpsKrn.JavaInt2Entier(0),true)));
   EcrireEntier(MUpsKrn.JavaString2Caractere("--[]"),((Entier)DecrementerElementTableau(T4,MUpsKrn.JavaInt2Entier(0),true)));
   T4.Index2(MUpsKrn.JavaInt2Entier(0),((Entier)T4.Index(MUpsKrn.JavaInt2Entier(0))).Additionner(MUpsKrn.JavaInt2Entier(1)));
   EcrireEntier(MUpsKrn.JavaString2Caractere("[]+1"),(Entier)T4.Index(MUpsKrn.JavaInt2Entier(0)));
   AdditionnerAffecterElementTableau(T4,MUpsKrn.JavaInt2Entier(0),MUpsKrn.JavaInt2Entier(1));
   EcrireEntier(MUpsKrn.JavaString2Caractere("[]+=1"),(Entier)T4.Index(MUpsKrn.JavaInt2Entier(0)));
   T4.Index2(null,MUpsKrn.JavaInt2Entier(10));
   EcrireEntier(MUpsKrn.JavaString2Caractere("[Nul]=10"),(Entier)T4.Index(null));
   EcrireEntier(MUpsKrn.JavaString2Caractere("[Nul]++"),((Entier)IncrementerElementTableau(T4,null,false)));
   EcrireEntier(MUpsKrn.JavaString2Caractere("[Nul]--"),((Entier)DecrementerElementTableau(T4,null,false)));
   T4.Index2(null,((Entier)T4.Index(null)).Additionner(MUpsKrn.JavaInt2Entier(1)));
   EcrireEntier(MUpsKrn.JavaString2Caractere("[Nul]+1"),(Entier)T4.Index(null));
   AdditionnerAffecterElementTableau(T4,null,MUpsKrn.JavaInt2Entier(1));
   EcrireEntier(MUpsKrn.JavaString2Caractere("[Nul]+=1"),(Entier)T4.Index(null));

   MUpsKrn.Arreter();
   }
catch (UpsException e)
   {
   try
      {
      System.out.println("Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '"
         +e.NomSourceEnErreur+"' ligne "+e.NumeroLigne+", colonne "+e.NumeroColonne+" :");
      System.out.println(e.MessageErreur);
      }
   catch (java.lang.Throwable e2)
      {
      System.out.println(e2.toString());
      }      
   }
}
}


