/* ------------------------------------------------------------------- */
/* Fichier    : syswin.java                                            */
/* Objet      : Exemple d'emploi d'Up ! Java.                          */
/*                                                                     */
/* Module      : Up ! Appplication System.                             */
/* Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.                    */
/* ------------------------------------------------------------------- */
/*                          Observations                               */
/*                                                                     */ 
/*                                                                     */ 
/* ------------------------------------------------------------------- */

import UpsKrn.Caractere;
import UpsKrn.Date;
import UpsKrn.Liste;
import UpsKrn.MUpsKrn;
import UpsKrn.UpsException;
import UpsSys.FichierListe;
import UpsSys.ProcessusListe;
import UpsSys.UniteListee;
import UpsSys.MUpsSys;
import UpsSec.MUpsSec;

public class syswin
/*****************/
{
static int NbAlarmes=0;

static boolean MonAlarme()
/************************/
{
try
   {
   System.out.println("Date="+MUpsKrn.Caractere2JavaString(Caractere.Caractere4(MUpsSys.DateSysteme(),MUpsKrn.JavaString2Caractere("%HH:%Mi:%S"))));
   NbAlarmes++;
   }
catch (UpsException e)
   {
   try
      {
      System.out.println("Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '"
         +e.NomSourceEnErreur+"' ligne "+e.NumeroLigne+", colonne "+e.NumeroColonne+" :");
      System.out.println(e.MessageErreur);
      }
   catch (java.lang.Throwable e2)
      {
      System.out.println(e2.toString());
      }      
   }
if (NbAlarmes<3)
   return(true);
return(false);
}

static public Caractere EcrireEntree()
/************************************/
{
return(null);
}

static void LireSortie(Caractere M)
/*********************************/
{
try
   {
   System.out.println(MUpsKrn.Caractere2JavaString(M));
   }
catch (UpsException e)
   {
   try
      {
      System.out.println("Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '"
         +e.NomSourceEnErreur+"' ligne "+e.NumeroLigne+", colonne "+e.NumeroColonne+" :");
      System.out.println(e.MessageErreur);
      }
   catch (java.lang.Throwable e2)
      {
      System.out.println(e2.toString());
      }      
   }
}

public static void main(String s[]) 
/*********************************/
{
Caractere C;
int P;
int CR;
int UtilisateurProprietaire;
int GroupeProprietaire;
Date DateDernierAcces;
Date DateDerniereModification;
Date DateCreation;
boolean EstCache;
Liste L1;
FichierListe FL;
Liste L2;
ProcessusListe PL;
Liste L3;
UniteListee UL;
Caractere CommandeLink;
UpsSys.LireDroitsDAcces PLireDroitsDAcces;
UpsSys.Executer PExecuter;
UpsSys.LireCodeRetour PLireCodeRetour;
UpsSys.LireCaracteristiquesFichier2 PLireCaracteristiquesFichier2;

try
   {
   if (!MUpsKrn.Demarrer())
      return;
   if (!MUpsSys.Demarrer())
      return;
   if (!MUpsSec.Demarrer())
      return;

   System.out.println("NomNoeud="+MUpsKrn.Caractere2JavaString(MUpsSys.NomNoeud()));
   System.out.println("NomMachine="+MUpsKrn.Caractere2JavaString(MUpsSys.NomMachine()));
   System.out.println("NomProgramme="+MUpsKrn.Caractere2JavaString(MUpsSys.NomProgramme()));
   System.out.println("NomUtilisateur="+MUpsKrn.Caractere2JavaString(MUpsSys.NomUtilisateur()));
   System.out.println("NomGroupe="+MUpsKrn.Caractere2JavaString(MUpsSys.NomGroupe()));
   System.out.println("NumeroProcessus="+MUpsSys.NumeroProcessus());
   System.out.println("NumeroGroupe="+MUpsSys.NumeroGroupe());
   System.out.println("NumeroUtilisateur="+MUpsSys.NumeroUtilisateur());
   System.out.println("SystemeDExploitation="+MUpsKrn.Caractere2JavaString(MUpsSys.SystemeDExploitation()));
   System.out.println("SeparateurRepertoire="+MUpsKrn.Caractere2JavaString(MUpsSys.SeparateurRepertoire()));
   System.out.println("UpsHome="+MUpsKrn.Caractere2JavaString(MUpsSys.UpsHome()));
   System.out.println("UpsPath="+MUpsKrn.Caractere2JavaString(MUpsSys.UpsPath()));
   System.out.println("UpsUser="+MUpsKrn.Caractere2JavaString(MUpsSys.UpsUser()));

   MUpsSys.Alarme(MUpsKrn.JavaMethod2Appel("syswin","MonAlarme","()Z",null),10,true);
   System.out.println("On attend 40 secondes");
   MUpsSys.Attendre(40);
   System.out.println("Fin de l'attente");

   System.out.println("Aleatoire()="+MUpsSys.Aleatoire());
   System.out.println("BornerRepertoire('/tmp')="+MUpsKrn.Caractere2JavaString(MUpsSys.BornerRepertoire(MUpsKrn.JavaString2Caractere("/tmp"))));
   MUpsSys.ChangerEnvironnement(MUpsKrn.JavaString2Caractere("UPS_ESSAI"),MUpsKrn.JavaString2Caractere("Bonjour le monde"));
   System.out.println("LireEnvironnement(UPS_ESSAI)="+MUpsKrn.Caractere2JavaString(MUpsSys.LireEnvironnement(MUpsKrn.JavaString2Caractere("UPS_ESSAI"))));
   System.out.println("LireEnvironnement(PATH)="+MUpsKrn.Caractere2JavaString(MUpsSys.LireEnvironnement(MUpsKrn.JavaString2Caractere("PATH"))));
   MUpsSys.ChangerPriorite(5);
   System.out.println("LirePriorite()="+MUpsSys.LirePriorite());
   MUpsSys.ChangerPriorite(4);
   C=MUpsSec.Crypter(MUpsKrn.JavaString2Caractere("XYZT"),MUpsKrn.JavaString2Caractere("Bonjour le monde"));
   System.out.println(MUpsKrn.Caractere2JavaString(C));
   System.out.println(MUpsKrn.Caractere2JavaString(MUpsSec.Decrypter(MUpsKrn.JavaString2Caractere("XYZT"),C)));

   MUpsSys.CreerRepertoire(MUpsKrn.JavaString2Caractere("/tmp2"));
   MUpsSys.CreerFichier(MUpsKrn.JavaString2Caractere("/tmp2/essai.txt"));
   if (MUpsSys.IlExisteRepertoire(MUpsKrn.JavaString2Caractere("/tmp2")))
      System.out.println("Il existe repertoire '/tmp2'");
   if (MUpsSys.IlExisteFichier(MUpsKrn.JavaString2Caractere("/tmp2/essai.txt")))
      System.out.println("Il existe fichier '/tmp2/essai.txt'");
   MUpsSys.ChangerDroitsDAcces(MUpsKrn.JavaString2Caractere("/tmp2/essai.txt"),MUpsSys.DroitLectureEcriture,MUpsSys.DroitLecture,MUpsSys.DroitLecture);
   PLireDroitsDAcces=new UpsSys.LireDroitsDAcces();
   switch (MUpsKrn.Enumere2JavaShort(MUpsSys.LireDroitsDAcces(MUpsKrn.JavaString2Caractere("/tmp2/essai.txt"),PLireDroitsDAcces)))
      {
      case MUpsSys.DroitLectureEcriture :
      case MUpsSys.DroitLectureEcritureExecution :
         System.out.println("Lecture, Ecriture et Execution");
         break;
      default :
         System.out.println("Autres droits");
         break;
      }
   MUpsSys.CopierFichier(MUpsKrn.JavaString2Caractere("/tmp2/essai.txt"),MUpsKrn.JavaString2Caractere("/tmp2/essai.sav"));
   MUpsSys.RenommerFichier(MUpsKrn.JavaString2Caractere("/tmp2/essai.sav"),MUpsKrn.JavaString2Caractere("/tmp2/essai.bak"));
   MUpsSys.SupprimerFichier(MUpsKrn.JavaString2Caractere("/tmp2/essai.bak"));
   MUpsSys.CopierRepertoire(MUpsKrn.JavaString2Caractere("/tmp2"),MUpsKrn.JavaString2Caractere("/tmp3"));
   MUpsSys.SupprimerRepertoire(MUpsKrn.JavaString2Caractere("/tmp2"));
   MUpsSys.RenommerRepertoire(MUpsKrn.JavaString2Caractere("/tmp3"),MUpsKrn.JavaString2Caractere("/tmp2"));
   MUpsSys.SupprimerRepertoire(MUpsKrn.JavaString2Caractere("/tmp2"));
   if (MUpsSys.IlExisteRepertoire(MUpsKrn.JavaString2Caractere("/tmp2")))
      System.out.println("Il existe repertoire '/tmp2'");
   if (MUpsSys.IlExisteFichier(MUpsKrn.JavaString2Caractere("/tmp2/essai.txt")))
      System.out.println("Il existe fichier '/tmp2/essai.txt'");
   MUpsSys.ChangerRepertoireCourant(MUpsKrn.JavaString2Caractere("/tmp"));
   System.out.println("RepertoireCourant="+MUpsKrn.Caractere2JavaString(MUpsSys.LireRepertoireCourant()));
   System.out.println(MUpsKrn.Caractere2JavaString(MUpsSys.RechercherFichierDansChemin(MUpsSys.LireEnvironnement(MUpsKrn.JavaString2Caractere("PATH")),MUpsKrn.JavaString2Caractere("notepad"),MUpsKrn.JavaString2Caractere("exe"))));

   PExecuter=new UpsSys.Executer();
   MUpsSys.Executer(MUpsKrn.JavaString2Caractere("c:/WINDOWS/system32/notepad.exe"),false,false,null,null,null,PExecuter);
   P=PExecuter.NumeroProcessusFils;
   MUpsSys.Attendre(10);
   MUpsSys.ArreterProcessus(P);

   CommandeLink=MUpsSys.RechercherFichierDansChemin(MUpsSys.LireEnvironnement(MUpsKrn.JavaString2Caractere("PATH")),MUpsKrn.JavaString2Caractere("link"),MUpsKrn.JavaString2Caractere("exe"));
   PExecuter=new UpsSys.Executer();
   System.out.println("link.exe="+MUpsSys.Executer(CommandeLink.Additionner(MUpsKrn.JavaString2Caractere(" /help")),true,true,null,null,null,PExecuter));
   PExecuter=new UpsSys.Executer();
   MUpsSys.Executer(CommandeLink.Additionner(MUpsKrn.JavaString2Caractere(" /help")),false,false,null,null,null,PExecuter);
   P=PExecuter.NumeroProcessusFils;
   MUpsSys.Attendre(10);
   PLireCodeRetour=new UpsSys.LireCodeRetour();
   if (MUpsSys.LireCodeRetour(P,PLireCodeRetour))
      {
      CR=PLireCodeRetour.CodeRetour;
      System.out.println("Code-retour de link.exe="+CR);
      }

   PExecuter=new UpsSys.Executer();
   MUpsSys.Executer(CommandeLink.Additionner(MUpsKrn.JavaString2Caractere(" /help")),true,true,null,
      MUpsKrn.JavaMethod2Appel("syswin","EcrireEntree","()LUpsKrn/Caractere;",null),
      MUpsKrn.JavaMethod2Appel("syswin","LireSortie","(LUpsKrn/Caractere;)V",null),
      PExecuter);
   P=PExecuter.NumeroProcessusFils;
   System.out.println(MUpsKrn.Caractere2JavaString(MUpsSys.LireEnvironnement(MUpsKrn.JavaString2Caractere("HKEY_LOCAL_MACHINE/software/UpCompany/ups/UPS_HOME2"))));
   System.out.println("Taille autoxec.bat="+MUpsSys.LireCaracteristiquesFichier(MUpsKrn.JavaString2Caractere("c:/autoexec.bat")));
   PLireCaracteristiquesFichier2=new UpsSys.LireCaracteristiquesFichier2();
   System.out.println("Taille autoxec.bat="+MUpsSys.LireCaracteristiquesFichier2(MUpsKrn.JavaString2Caractere("c:/autoexec.bat"),PLireCaracteristiquesFichier2));
   UtilisateurProprietaire=PLireCaracteristiquesFichier2.UtilisateurProprietaire;
   GroupeProprietaire=PLireCaracteristiquesFichier2.GroupeProprietaire;
   DateDernierAcces=PLireCaracteristiquesFichier2.DateDernierAcces;
   DateDerniereModification=PLireCaracteristiquesFichier2.DateDerniereModification;
   DateCreation=PLireCaracteristiquesFichier2.DateCreation;
   EstCache=PLireCaracteristiquesFichier2.EstCache;

   System.out.println(UtilisateurProprietaire);
   System.out.println(GroupeProprietaire);
   System.out.println(MUpsKrn.Caractere2JavaString(Caractere.Caractere3(DateDernierAcces)));
   System.out.println(MUpsKrn.Caractere2JavaString(Caractere.Caractere3(DateDerniereModification)));
   if (EstCache)
      System.out.println("Est cache");
   else
      System.out.println("N'est pas cache");
   System.out.println("\n");

   L1=MUpsSys.ListerFichiers(MUpsKrn.JavaString2Caractere("c:/"),null);
   for (FL=(FichierListe)L1.ParcoursAuDebut(0);;FL=(FichierListe)L1.Suivant(0))
      {
      System.out.println(MUpsKrn.Caractere2JavaString(FL.NomFichier()));
      if (FL.Identique(L1.DernierElement()))
         break;
      }
   System.out.println("\n");

   L2=MUpsSys.ListerProcessus();
   for (PL=(ProcessusListe)L2.ParcoursAuDebut(0);;PL=(ProcessusListe)L2.Suivant(0))
      {
      System.out.println(MUpsKrn.Caractere2JavaString(PL.NomProgramme()));
      System.out.println(PL.Numero());
      System.out.println(PL.TempsSysteme());
      System.out.println(PL.TempsUtilisateur());
      System.out.println("\n");
      if (PL.Identique(L2.DernierElement()))
         break;
      }

   L3=MUpsSys.ListerUnites(null);
   for (UL=(UniteListee)L3.ParcoursAuDebut(0);;UL=(UniteListee)L3.Suivant(0))
      {
      System.out.println(MUpsKrn.Caractere2JavaString(UL.NomUnite()));
      System.out.println(UL.PlaceLibre());
      System.out.println(UL.PlaceTotale());
      System.out.println("\n");
      if (UL.Identique(L3.DernierElement()))
         break;
      }

   MUpsSec.Arreter();
   MUpsSys.Arreter();
   MUpsKrn.Arreter();
   }
catch (UpsException e)
   {
   try
      {
      System.out.println("Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '"
         +e.NomSourceEnErreur+"' ligne "+e.NumeroLigne+", colonne "+e.NumeroColonne+" :");
      System.out.println(e.MessageErreur);
      }
   catch (java.lang.Throwable e2)
      {
      System.out.println(e2.toString());
      }      
   }
}
}


