/* ------------------------------------------------------------------- */
/* Fichier    : liste.java                                             */
/* Objet      : Exemple d'emploi d'Up ! Java.                          */
/*                                                                     */
/* Module      : Up ! Appplication System.                             */
/* Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.                    */
/* ------------------------------------------------------------------- */
/*                          Observations                               */
/*                                                                     */ 
/*                                                                     */ 
/* ------------------------------------------------------------------- */

import UpsKrn.Caractere;
import UpsKrn.Entier;
import UpsKrn.Liste;
import UpsKrn.MUpsKrn;
import UpsKrn.UpsException;

public class liste
/*****************/
{
static void EcrireListe(Caractere M, Liste L)
/*******************************************/
{
Caractere C;

try
   {
   System.out.println(MUpsKrn.Caractere2JavaString(M));
   for (C=(Caractere)L.ParcoursAuDebut(0);;C=(Caractere)L.Suivant(0))
      {
      System.out.println(MUpsKrn.Caractere2JavaString(C));
      if (C.Identique((Caractere)L.DernierElement()))
         break;
      }
   System.out.println("\n");
   }
catch (UpsException e)
   {
   try
      {
      System.out.println("Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '"
         +e.NomSourceEnErreur+"' ligne "+e.NumeroLigne+", colonne "+e.NumeroColonne+" :");
      System.out.println(e.MessageErreur);
      }
   catch (java.lang.Throwable e2)
      {
      System.out.println(e2.toString());
      }      
   }
}

static void EcrireListeInverse(Caractere M, Liste L)
/**************************************************/
{
Caractere C;
int I;

try
   {
   System.out.println(MUpsKrn.Caractere2JavaString(M));
   I=L.AllouerIterateur();
   for (C=(Caractere)L.ParcoursALaFin(I);;C=(Caractere)L.Precedent(I))
      {
      System.out.println(MUpsKrn.Caractere2JavaString((Caractere)L.Element(I)));
      if (C.Identique((Caractere)L.PremierElement()))
         break;
      }
   L.LibererIterateur(I);
   System.out.println("\n");
   }
catch (UpsException e)
   {
   try
      {
      System.out.println("Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '"
         +e.NomSourceEnErreur+"' ligne "+e.NumeroLigne+", colonne "+e.NumeroColonne+" :");
      System.out.println(e.MessageErreur);
      }
   catch (java.lang.Throwable e2)
      {
      System.out.println(e2.toString());
      }      
   }
}

public static void main(String s[]) 
/*********************************/
{
Liste L;
Liste L2;
Caractere A;
Caractere B;
Caractere C;
Caractere D;
Caractere E;
Caractere F;
Caractere G;
Caractere H;

try
   {
   if (!MUpsKrn.Demarrer())
      return;

   L=Liste.Liste(MUpsKrn.Caractere(),MUpsKrn.JavaString2Caractere("A"));
   L=L.Additionner(MUpsKrn.JavaString2Caractere("B"));
   L.AdditionnerAffecter(MUpsKrn.JavaString2Caractere("C"));
   L.AdditionnerAffecter(MUpsKrn.JavaString2Caractere("D"));
   L.AdditionnerAffecter(MUpsKrn.JavaString2Caractere("E"));
   L.AdditionnerAffecter(MUpsKrn.JavaString2Caractere("F"));
   L.AdditionnerAffecter(MUpsKrn.JavaString2Caractere("G"));
   L.AdditionnerAffecter(MUpsKrn.JavaString2Caractere("H"));
   L.AdditionnerAffecter(MUpsKrn.JavaString2Caractere("I"));
   EcrireListe(MUpsKrn.JavaString2Caractere("Suivant()"),L);
   EcrireListeInverse(MUpsKrn.JavaString2Caractere("Precedent()"),L);
   EcrireListe(MUpsKrn.JavaString2Caractere("-()"),L.Soustraire());
   EcrireListe(MUpsKrn.JavaString2Caractere("Gauche(3)"),((Liste)L.Cloner(null,MUpsKrn.ClonageObjetSeul)).Gauche(MUpsKrn.JavaInt2Entier(3)));
   EcrireListe(MUpsKrn.JavaString2Caractere("Droite(3)"),((Liste)L.Cloner(null,MUpsKrn.ClonageObjetSeul)).Droite(MUpsKrn.JavaInt2Entier(3)));
   EcrireListe(MUpsKrn.JavaString2Caractere("Milieu(2,3)"),((Liste)L.Cloner(null,MUpsKrn.ClonageObjetSeul)).Milieu(MUpsKrn.JavaInt2Entier(2),MUpsKrn.JavaInt2Entier(3)));
   C=MUpsKrn.JavaString2Caractere("a");
   L2=Liste.Liste(MUpsKrn.Caractere(),C);
   L2.AdditionnerAffecter(MUpsKrn.JavaString2Caractere("b"));
   L2.AdditionnerAffecter(MUpsKrn.JavaString2Caractere("c"));
   L2.AdditionnerAffecter(C);
   L2.AdditionnerAffecter(MUpsKrn.JavaString2Caractere("b"));
   L2.AdditionnerAffecter(MUpsKrn.JavaString2Caractere("c"));
   EcrireListe(MUpsKrn.JavaString2Caractere("Inserer(2)"),((Liste)L.Cloner(null,MUpsKrn.ClonageObjetSeul)).Inserer(L2,MUpsKrn.JavaInt2Entier(2)));
   System.out.println("Compter(0)");
   System.out.println(MUpsKrn.Entier2JavaInt(L2.Compter(C,MUpsKrn.JavaInt2Entier(0))));
   System.out.println("\n");
   System.out.println("Compter(1)");
   System.out.println(MUpsKrn.Entier2JavaInt(L2.Compter(C,MUpsKrn.JavaInt2Entier(2))));
   System.out.println("\n");
   EcrireListe(MUpsKrn.JavaString2Caractere("Remplacer(0)"),L2.RemplacerTous(C,MUpsKrn.JavaString2Caractere("x"),MUpsKrn.JavaInt2Entier(0)));
   EcrireListe(MUpsKrn.JavaString2Caractere("Remplacer(1)"),L2.RemplacerTous(C,MUpsKrn.JavaString2Caractere("x"),MUpsKrn.JavaInt2Entier(1)));
   System.out.println("Rechercher(0)");
   System.out.println(MUpsKrn.Entier2JavaInt(L2.Rechercher(C,MUpsKrn.JavaInt2Entier(0))));
   System.out.println("\n");
   System.out.println("Rechercher(1)");
   System.out.println(MUpsKrn.Entier2JavaInt(L2.Rechercher(C,MUpsKrn.JavaInt2Entier(1))));
   System.out.println("\n");
   EcrireListe(MUpsKrn.JavaString2Caractere("Supprimer(0)"),L2.SupprimerTous(C,MUpsKrn.JavaInt2Entier(0)));
   EcrireListe(MUpsKrn.JavaString2Caractere("Supprimer(1)"),L2.SupprimerTous(C,MUpsKrn.JavaInt2Entier(1)));
   System.out.println("L[0]");
   System.out.println(MUpsKrn.Caractere2JavaString((Caractere)L.Index(MUpsKrn.JavaInt2Entier(0))));
   System.out.println("L[2]");
   System.out.println(MUpsKrn.Caractere2JavaString((Caractere)L.Index(MUpsKrn.JavaInt2Entier(2))));
   System.out.println("PremierElement()");
   System.out.println(MUpsKrn.Caractere2JavaString((Caractere)L.PremierElement()));
   System.out.println("DernierElement()");
   System.out.println(MUpsKrn.Caractere2JavaString((Caractere)L.DernierElement()));
   System.out.println("NumeroElement()");
   System.out.println(MUpsKrn.Entier2JavaInt(L.NumeroElement(0)));
   EcrireListe(MUpsKrn.JavaString2Caractere("AjouterAuDebut()"),L.AjouterAuDebut(MUpsKrn.JavaString2Caractere("X")));
   EcrireListe(MUpsKrn.JavaString2Caractere("AjouterALaFin()"),L.AjouterALaFin(MUpsKrn.JavaString2Caractere("Y")));
   A=MUpsKrn.JavaString2Caractere("A");
   B=MUpsKrn.JavaString2Caractere("B");
   C=MUpsKrn.JavaString2Caractere("C");
   D=MUpsKrn.JavaString2Caractere("D");
   E=MUpsKrn.JavaString2Caractere("E");
   F=MUpsKrn.JavaString2Caractere("F");
   G=MUpsKrn.JavaString2Caractere("G");
   H=MUpsKrn.JavaString2Caractere("H");
   L=Liste.Liste(MUpsKrn.Caractere(),A);
   L.AdditionnerAffecter(B);
   L.AdditionnerAffecter(C);
   L.AdditionnerAffecter(D);
   L.AdditionnerAffecter(E);
   L.AdditionnerAffecter(F);
   L2=Liste.Liste(MUpsKrn.Caractere(),A);
   L2.AdditionnerAffecter(B);
   L2.AdditionnerAffecter(D);
   L2.AdditionnerAffecter(F);
   L2.AdditionnerAffecter(G);
   L2.AdditionnerAffecter(H);
   EcrireListe(MUpsKrn.JavaString2Caractere("Union()"),L.Union(L2));
   EcrireListe(MUpsKrn.JavaString2Caractere("Intersection()"),L.Intersection(L2));
   EcrireListe(MUpsKrn.JavaString2Caractere("Soustraction()"),L.Soustraction(L2));
   EcrireListe(MUpsKrn.JavaString2Caractere("Exclusion()"),L.Exclusion(L2));

   MUpsKrn.Arreter();
   }
catch (UpsException e)
   {
   try
      {
      System.out.println("Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '"
         +e.NomSourceEnErreur+"' ligne "+e.NumeroLigne+", colonne "+e.NumeroColonne+" :");
      System.out.println(e.MessageErreur);
      }
   catch (java.lang.Throwable e2)
      {
      System.out.println(e2.toString());
      }      
   }
}
}


