/* ------------------------------------------------------------------- */
/* Fichier    : lisp.java                                              */
/* Objet      : Exemple d'emploi d'Up ! Java.                          */
/*                                                                     */
/* Module      : Up ! Appplication System.                             */
/* Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.                    */
/* ------------------------------------------------------------------- */
/*                          Observations                               */
/*                                                                     */ 
/*                                                                     */ 
/* ------------------------------------------------------------------- */

import UpsKrn.Booleen;
import UpsKrn.Caractere;
import UpsKrn.Entier;
import UpsKrn.Liste;
import UpsKrn.Objet;
import UpsKrn.MUpsKrn;
import UpsKrn.UpsException;

public class lisp
/****************/
{
static void P1(Caractere O)
/*************************/
{
try
   {
   System.out.println(MUpsKrn.Caractere2JavaString(O));
   }
catch (UpsException e)
   {
   try
      {
      System.out.println("Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '"
         +e.NomSourceEnErreur+"' ligne "+e.NumeroLigne+", colonne "+e.NumeroColonne+" :");
      System.out.println(e.MessageErreur);
      }
   catch (java.lang.Throwable e2)
      {
      System.out.println(e2.toString());
      }      
   }
}

static void P2(Caractere O1, Entier O2)
/*************************************/
{
try
   {
   System.out.println(MUpsKrn.Caractere2JavaString(O1.Additionner(MUpsKrn.JavaString2Caractere(" ")).Additionner(Caractere.Caractere5(O2))));
   }
catch (UpsException e)
   {
   try
      {
      System.out.println("Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '"
         +e.NomSourceEnErreur+"' ligne "+e.NumeroLigne+", colonne "+e.NumeroColonne+" :");
      System.out.println(e.MessageErreur);
      }
   catch (java.lang.Throwable e2)
      {
      System.out.println(e2.toString());
      }      
   }
}

static Caractere F1(Caractere O)
/******************************/
{
try
   {
   return(O.Majuscule());
   }
catch (UpsException e)
   {
   try
      {
      System.out.println("Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '"
         +e.NomSourceEnErreur+"' ligne "+e.NumeroLigne+", colonne "+e.NumeroColonne+" :");
      System.out.println(e.MessageErreur);
      }
   catch (java.lang.Throwable e2)
      {
      System.out.println(e2.toString());
      }      
   }
return(null);
}

static Caractere F2(Caractere O1, Entier O2)
/******************************************/
{
try
   {
   return(O1.Majuscule().Additionner(MUpsKrn.JavaString2Caractere(" ")).Additionner(Caractere.Caractere5(O2)));
   }
catch (UpsException e)
   {
   try
      {
      System.out.println("Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '"
         +e.NomSourceEnErreur+"' ligne "+e.NumeroLigne+", colonne "+e.NumeroColonne+" :");
      System.out.println(e.MessageErreur);
      }
   catch (java.lang.Throwable e2)
      {
      System.out.println(e2.toString());
      }      
   }
return(null);
}

static Booleen F3(Caractere O1)
/*****************************/
{
try
   {
   return(O1.InferieurOuEgal(MUpsKrn.JavaString2Caractere("hello!!!")));
   }
catch (UpsException e)
   {
   try
      {
      System.out.println("Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '"
         +e.NomSourceEnErreur+"' ligne "+e.NumeroLigne+", colonne "+e.NumeroColonne+" :");
      System.out.println(e.MessageErreur);
      }
   catch (java.lang.Throwable e2)
      {
      System.out.println(e2.toString());
      }      
   }
return(null);
}

static short F4(Caractere O1, Caractere O2)
/*****************************************/
{
try
   {
   if ((O1==null)||(O2==null))
      return(MUpsKrn.ComparaisonNul);
   if (MUpsKrn.Booleen2JavaBoolean(O1.Inferieur(O2)))
      return(MUpsKrn.ComparaisonAvant);
   if (MUpsKrn.Booleen2JavaBoolean(O1.Superieur(O2)))
      return(MUpsKrn.ComparaisonApres);
   }
catch (UpsException e)
   {
   try
      {
      System.out.println("Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '"
         +e.NomSourceEnErreur+"' ligne "+e.NumeroLigne+", colonne "+e.NumeroColonne+" :");
      System.out.println(e.MessageErreur);
      }
   catch (java.lang.Throwable e2)
      {
      System.out.println(e2.toString());
      }      
   }
return(MUpsKrn.ComparaisonEgal);
}

static void EcrireListe(Liste L)
/******************************/
{
Caractere C;

try
   {
   for (C=(Caractere)L.ParcoursAuDebut(0);;C=(Caractere)L.Suivant(0))
      {
      System.out.println(MUpsKrn.Caractere2JavaString(C));
      if (C.Identique(L.DernierElement()))
         break;
      }
   }
catch (UpsException e)
   {
   try
      {
      System.out.println("Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '"
         +e.NomSourceEnErreur+"' ligne "+e.NumeroLigne+", colonne "+e.NumeroColonne+" :");
      System.out.println(e.MessageErreur);
      }
   catch (java.lang.Throwable e2)
      {
      System.out.println(e2.toString());
      }      
   }
}

public static void main(String s[]) 
/*********************************/
{
Liste L1;
Liste L2;
Liste L3;

try
   {
   if (!MUpsKrn.Demarrer())
      return;

   L1=Liste.Liste(MUpsKrn.Caractere(),(Objet)MUpsKrn.JavaString2Caractere("bonjour"));
   L1.AdditionnerAffecter((Objet)MUpsKrn.JavaString2Caractere("hello"));
   L1.AdditionnerAffecter((Objet)MUpsKrn.JavaString2Caractere("guten tag"));
   L2=Liste.Liste(MUpsKrn.Caractere(),MUpsKrn.JavaInt2Entier(1));
   L2.AdditionnerAffecter((Objet)MUpsKrn.JavaInt2Entier(2));
   L2.AdditionnerAffecter((Objet)MUpsKrn.JavaInt2Entier(3));

   System.out.println("P1:");
   L1.Appliquer(MUpsKrn.JavaMethod2Appel("lisp","P1","(LUpsKrn/Caractere;)V",null));
   System.out.println("P2:");
   L1.Appliquer2(MUpsKrn.JavaMethod2Appel("lisp","P2","(LUpsKrn/Caractere;LUpsKrn/Entier;)V",null),L2);

   System.out.println("F1:");
   L3=L1.Appliquer3(MUpsKrn.JavaMethod2Appel("lisp","F1","(LUpsKrn/Caractere;)LUpsKrn/Caractere;",null));
   EcrireListe(L3);
   System.out.println("F2:");
   L3=L1.Appliquer4(MUpsKrn.JavaMethod2Appel("lisp","F2","(LUpsKrn/Caractere;LUpsKrn/Entier;)LUpsKrn/Caractere;",null),L2);
   EcrireListe(L3);

   System.out.println("F3:");
   L3=L1.Filtrer(MUpsKrn.JavaMethod2Appel("lisp","F3","(LUpsKrn/Caractere;)LUpsKrn/Booleen;",null));
   EcrireListe(L3);

   System.out.println("F4:");
   L1.AdditionnerAffecter((Objet)MUpsKrn.JavaString2Caractere("hello"));
   L1.AdditionnerAffecter((Objet)MUpsKrn.JavaString2Caractere("bonjour"));
   L3=L1.Grouper(MUpsKrn.JavaMethod2Appel("lisp","F4","(LUpsKrn/Caractere;LUpsKrn/Caractere;)S",null));
   EcrireListe(L3);

   System.out.println("F4Bis:");
   L1.AdditionnerAffecter((Objet)MUpsKrn.JavaString2Caractere("coucou"));
   L1.AdditionnerAffecter((Objet)MUpsKrn.JavaString2Caractere("salut"));
   L1.AdditionnerAffecter((Objet)MUpsKrn.JavaString2Caractere("hie"));
   L1.AdditionnerAffecter((Objet)MUpsKrn.JavaString2Caractere("schluss"));
   L3=L1.Trier(MUpsKrn.JavaMethod2Appel("lisp","F4","(LUpsKrn/Caractere;LUpsKrn/Caractere;)S",null),true);
   EcrireListe(L3);
   L3=L1.Trier(MUpsKrn.JavaMethod2Appel("lisp","F4","(LUpsKrn/Caractere;LUpsKrn/Caractere;)S",null),false);
   EcrireListe(L3);

   MUpsKrn.Arreter();
   }
catch (UpsException e)
   {
   try
      {
      System.out.println("Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '"
         +e.NomSourceEnErreur+"' ligne "+e.NumeroLigne+", colonne "+e.NumeroColonne+" :");
      System.out.println(e.MessageErreur);
      }
   catch (java.lang.Throwable e2)
      {
      System.out.println(e2.toString());
      }      
   }
}
}


