/* ------------------------------------------------------------------- */
/* Fichier    : arbre.java                                             */
/* Objet      : Exemple d'emploi d'Up ! Java.                          */
/*                                                                     */
/* Module      : Up ! Appplication System.                             */
/* Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.                    */
/* ------------------------------------------------------------------- */
/*                          Observations                               */
/*                                                                     */ 
/*                                                                     */ 
/* ------------------------------------------------------------------- */

import UpsKrn.Appel;
import UpsKrn.ArbreBinaire;
import UpsKrn.Caractere;
import UpsKrn.Entier;
import UpsKrn.MUpsKrn;
import UpsKrn.UpsException;

public class arbre
/*****************/
{
public static short F(Caractere O1, Caractere O2)
/*********************************************/
{
try
   {
   if ((O1==null)||(O2==null))
      return(UpsKrn.MUpsKrn.ComparaisonNul);
   if (MUpsKrn.Caractere2JavaString(O1).compareTo(MUpsKrn.Caractere2JavaString(O2))<0)
      return(UpsKrn.MUpsKrn.ComparaisonAvant);
   if (MUpsKrn.Caractere2JavaString(O1).compareTo(MUpsKrn.Caractere2JavaString(O2))>0)
      return(UpsKrn.MUpsKrn.ComparaisonApres);
   }
catch (UpsException e)
   {
   try
      {
      System.out.println("Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '"
         +e.NomSourceEnErreur+"' ligne "+e.NumeroLigne+", colonne "+e.NumeroColonne+" :");
      System.out.println(e.MessageErreur);
      }
   catch (java.lang.Throwable e2)
      {
      System.out.println(e2.toString());
      }      
   }
return(UpsKrn.MUpsKrn.ComparaisonEgal);
}

static void EcrireArbre(ArbreBinaire A)
/*************************************/
{
Caractere C;

try
   {
   for (C=(Caractere)A.ParcoursAuDebut(0);;C=(Caractere)A.Suivant(0))
      {
      System.out.println(MUpsKrn.Caractere2JavaString(C));
      if (C.Identique((Caractere)A.DernierElement()))
         break;
      }
   }
catch (UpsException e)
   {
   try
      {
      System.out.println("Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '"
         +e.NomSourceEnErreur+"' ligne "+e.NumeroLigne+", colonne "+e.NumeroColonne+" :");
      System.out.println(e.MessageErreur);
      }
   catch (java.lang.Throwable e2)
      {
      System.out.println(e2.toString());
      }      
   }
}

static void EcrireArbre2(ArbreBinaire A)
/**************************************/
{
Caractere C;

try
   {
   for (C=(Caractere)A.ParcoursALaFin(0);;C=(Caractere)A.Precedent(0))
      {
      System.out.println(MUpsKrn.Caractere2JavaString(C));
      if (C.Identique((Caractere)A.PremierElement()))
         break;
      }
   }
catch (UpsException e)
   {
   try
      {
      System.out.println("Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '"
         +e.NomSourceEnErreur+"' ligne "+e.NumeroLigne+", colonne "+e.NumeroColonne+" :");
      System.out.println(e.MessageErreur);
      }
   catch (java.lang.Throwable e2)
      {
      System.out.println(e2.toString());
      }      
   }
}

static void EcrireArbre3(ArbreBinaire A)
/**************************************/
{
Caractere C;

try 
   {
   for (C=(Caractere)A.ParcoursAuDebut(0);;C=(Caractere)A.SuivantGroupe(0))
      {
      System.out.println(MUpsKrn.Caractere2JavaString(C));
      if (C.Identique((Caractere)A.DernierElement()))
         break;
      }
   }
catch (UpsException e)
   {
   try
      {
      System.out.println("Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '"
         +e.NomSourceEnErreur+"' ligne "+e.NumeroLigne+", colonne "+e.NumeroColonne+" :");
      System.out.println(e.MessageErreur);
      }
   catch (java.lang.Throwable e2)
      {
      System.out.println(e2.toString());
      }      
   }
}

static void EcrireArbre4(ArbreBinaire A)
/**************************************/
{
Caractere C;

try
   {
   for (C=(Caractere)A.ParcoursALaFin(0);;C=(Caractere)A.PrecedentGroupe(0))
      {
      System.out.println(MUpsKrn.Caractere2JavaString(C));
      if (C.Identique((Caractere)A.PremierElement()))
         break;
      }
   }
catch (UpsException e)
   {
   try
      {
      System.out.println("Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '"
         +e.NomSourceEnErreur+"' ligne "+e.NumeroLigne+", colonne "+e.NumeroColonne+" :");
      System.out.println(e.MessageErreur);
      }
   catch (java.lang.Throwable e2)
      {
      System.out.println(e2.toString());
      }      
   }
}

static void EcrireArbre5(ArbreBinaire A)
/**************************************/
{
Caractere C;

try
   {
   for (C=(Caractere)A.ParcoursAuDebut(0);;C=(Caractere)A.SuivantGroupe(0))
      {
      System.out.println("Groupe "+MUpsKrn.Caractere2JavaString(Caractere.Caractere5(A.NumeroElement(0))));
      for (C=(Caractere)A.PremierElementGroupe(0);;C=(Caractere)A.Suivant(0))
         {
         System.out.println(MUpsKrn.Caractere2JavaString(C));
         if (C.Identique((Caractere)A.DernierElementGroupe(0)))
            break;
         }
      if (C.Identique((Caractere)A.DernierElement()))
         break;
      }
   }
catch (java.lang.Throwable e)
   {
   System.out.println(e.toString());
   }
}

public static void main(String s[]) 
/*********************************/
{
ArbreBinaire A1;
ArbreBinaire A2;
ArbreBinaire A3;
Caractere Coucou;
Caractere Bonjour;
Caractere Salut;
Caractere Schluss;
int I;
Caractere LibelleA;
Caractere LibelleB;
Caractere LibelleC;
Caractere LibelleD;
Caractere LibelleE;
Caractere LibelleF;

try
   {
   if (!MUpsKrn.Demarrer())
      return;

   Coucou=MUpsKrn.JavaString2Caractere("coucou");
   Bonjour=MUpsKrn.JavaString2Caractere("bonjour");
   Salut=MUpsKrn.JavaString2Caractere("salut");
   Schluss=MUpsKrn.JavaString2Caractere("schluss");
   A1=ArbreBinaire.ArbreBinaire(MUpsKrn.Caractere(), MUpsKrn.JavaMethod2Appel("arbre","F","(LUpsKrn/Caractere;LUpsKrn/Caractere;)S",null),false);
   A1.AdditionnerAffecter(Bonjour);
   A1.AdditionnerAffecter(MUpsKrn.JavaString2Caractere("hello"));
   A1.AdditionnerAffecter(MUpsKrn.JavaString2Caractere("guten tag"));
   A1.AdditionnerAffecter(MUpsKrn.JavaString2Caractere("hello"));
   A1.AdditionnerAffecter(MUpsKrn.JavaString2Caractere("coucou"));
   A1.AdditionnerAffecter(Coucou);
   A1.AdditionnerAffecter(Salut);
   A1.AdditionnerAffecter(MUpsKrn.JavaString2Caractere("hie"));
   A1.AdditionnerAffecter(Schluss);
   EcrireArbre(A1);
   System.out.println("\n");
   EcrireArbre2(A1);
   System.out.println("\n");
   EcrireArbre3(A1);
   System.out.println("\n");
   EcrireArbre4(A1);
   System.out.println("\n");

   A2=ArbreBinaire.ArbreBinaire(MUpsKrn.Caractere(), MUpsKrn.JavaMethod2Appel("arbre","F","(LUpsKrn/Caractere;LUpsKrn/Caractere;)S",null),false);
   A2.AdditionnerAffecter(Schluss);
   A2.AdditionnerAffecter(MUpsKrn.JavaString2Caractere("hie"));
   A2.AdditionnerAffecter(Salut);
   A2.AdditionnerAffecter(Coucou);
   A2.AdditionnerAffecter(MUpsKrn.JavaString2Caractere("bonjour"));
   A2.AdditionnerAffecter(MUpsKrn.JavaString2Caractere("hello"));
   A2.AdditionnerAffecter(MUpsKrn.JavaString2Caractere("guten tag"));
   A2.AdditionnerAffecter(MUpsKrn.JavaString2Caractere("hello"));
   A2.AdditionnerAffecter(Bonjour);
   EcrireArbre5(A2);
   System.out.println("\n");

   if (MUpsKrn.Booleen2JavaBoolean(A1.Egal(A2)))
      System.out.println("A1==A2");
   if (MUpsKrn.Booleen2JavaBoolean(A1.Different(A2)))
      System.out.println("A1!=A2");
   System.out.println(MUpsKrn.Caractere2JavaString((Caractere)A1.PremierElement()));
   System.out.println(MUpsKrn.Caractere2JavaString((Caractere)A1.DernierElement()));
   System.out.println(A1.NbElements());
   System.out.println(A1.NbGroupes());
   System.out.println("\n");

   System.out.println(MUpsKrn.Entier2JavaInt((Entier)A1.Compter(Bonjour, MUpsKrn.JavaInt2Entier(0))));
   System.out.println("\n");
   A2=A2.SupprimerTous(Schluss, MUpsKrn.JavaInt2Entier(0));
   EcrireArbre(A2);
   System.out.println("\n");
   A2=A2.RemplacerTous(Bonjour,MUpsKrn.JavaString2Caractere("hola"), MUpsKrn.JavaInt2Entier(0));
   EcrireArbre(A2);
   System.out.println("\n");

   A2=A1.Gauche(MUpsKrn.JavaInt2Entier(3));
   EcrireArbre(A2);
   System.out.println("\n");
   A2=A1.Gauche(MUpsKrn.JavaInt2Entier(8));
   EcrireArbre(A2);
   System.out.println("\n");
   A2=A1.Droite(MUpsKrn.JavaInt2Entier(8));
   EcrireArbre(A2);
   System.out.println("\n");
   A2=A1.Droite(MUpsKrn.JavaInt2Entier(2));
   EcrireArbre(A2);
   System.out.println("\n");
   A2=A1.Milieu(MUpsKrn.JavaInt2Entier(1),MUpsKrn.JavaInt2Entier(7));
   EcrireArbre(A2);
   System.out.println("\n");

   A2=A1;
   EcrireArbre(A2);
   System.out.println("\n");
   for (I=0;;I++)
      {
      System.out.println(MUpsKrn.Caractere2JavaString((Caractere)A1.Index(MUpsKrn.JavaInt2Entier(I))));
      if (I==A1.NbElements()-1)
         break;
      }
   System.out.println("\n");

   LibelleA=MUpsKrn.JavaString2Caractere("A");
   LibelleB=MUpsKrn.JavaString2Caractere("B");
   LibelleC=MUpsKrn.JavaString2Caractere("C");
   LibelleD=MUpsKrn.JavaString2Caractere("D");
   LibelleE=MUpsKrn.JavaString2Caractere("E");
   LibelleF=MUpsKrn.JavaString2Caractere("F");
   A1=ArbreBinaire.ArbreBinaire(MUpsKrn.Caractere(), MUpsKrn.JavaMethod2Appel("arbre","F","(LUpsKrn/Caractere;LUpsKrn/Caractere;)S",null),false);
   A1.AdditionnerAffecter(LibelleA);
   A1.AdditionnerAffecter(LibelleB);
   A1.AdditionnerAffecter(LibelleC);
   A1.AdditionnerAffecter(LibelleD);
   A2=ArbreBinaire.ArbreBinaire(MUpsKrn.Caractere(), MUpsKrn.JavaMethod2Appel("arbre","F","(LUpsKrn/Caractere;LUpsKrn/Caractere;)S",null),false);
   A2.AdditionnerAffecter(LibelleC);
   A2.AdditionnerAffecter(LibelleD);
   A2.AdditionnerAffecter(LibelleE);
   A2.AdditionnerAffecter(LibelleF);
   A3=A1.Union(A2);
   EcrireArbre(A3);
   System.out.println("\n");
   A3=A1.Intersection(A2);
   EcrireArbre(A3);
   System.out.println("\n");
   A3=A1.Soustraction(A2);
   EcrireArbre(A3);
   System.out.println("\n");
   A3=A1.Exclusion(A2);
   EcrireArbre(A3);
   System.out.println("\n");

   MUpsKrn.Arreter();
   }
catch (UpsException e)
   {
   try
      {
      System.out.println("Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '"
         +e.NomSourceEnErreur+"' ligne "+e.NumeroLigne+", colonne "+e.NumeroColonne+" :");
      System.out.println(e.MessageErreur);
      }
   catch (java.lang.Throwable e2)
      {
      System.out.println(e2.toString());
      }      
   }
}
}


