/* ------------------------------------------------------------------- */
/* Fichier    : annuaire.java                                          */
/* Objet      : Exemple d'emploi d'Up ! Java.                          */
/*                                                                     */
/* Module      : Up ! Appplication System.                             */
/* Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.                    */
/* ------------------------------------------------------------------- */
/*                          Observations                               */
/*                                                                     */ 
/*                                                                     */ 
/* ------------------------------------------------------------------- */

import UpsKrn.Caractere;
import UpsKrn.Entier;
import UpsKrn.Liste;
import UpsKrn.MUpsKrn;
import UpsKrn.UpsException;
import UpsOrb.Annuaire;
import UpsOrb.MUpsOrb;

public class annuaire
/*******************/
{
static Annuaire A;

static void AfficherAnnuaire2(Annuaire An, Caractere Chemin)
/**********************************************************/
{
Liste L;
Caractere C;

try
   {
   L=An.LireArborescenceAnnuaire(Chemin);
   if (L!=null)
      {
      for (C=(Caractere)L.ParcoursAuDebut(0);;C=(Caractere)L.Suivant(0))
         {
         if (MUpsKrn.Booleen2JavaBoolean(Chemin.Different(MUpsKrn.JavaString2Caractere(""))))
            {
            System.out.println(MUpsKrn.Caractere2JavaString(Chemin.Additionner(MUpsKrn.JavaString2Caractere(".")).Additionner(C)));
            AfficherAnnuaire2(An,Chemin.Additionner(MUpsKrn.JavaString2Caractere(".")).Additionner(C));
            }
         else
            {
            System.out.println(MUpsKrn.Caractere2JavaString(C));
            AfficherAnnuaire2(An,C);
            }
         if (C.Identique(L.DernierElement()))
            break;
         }
      }
   }
catch (UpsException e)
   {
   try
      {
      System.out.println("Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '"
         +e.NomSourceEnErreur+"' ligne "+e.NumeroLigne+", colonne "+e.NumeroColonne+" :");
      System.out.println(e.MessageErreur);
      }
   catch (java.lang.Throwable e2)
      {
      System.out.println(e2.toString());
      }      
   }
}

static void AfficherAnnuaire(Annuaire An)
/***************************************/
{
try
   {
   System.out.println(MUpsKrn.Caractere2JavaString(An.NomAnnuaire()));
   AfficherAnnuaire2(An,MUpsKrn.JavaString2Caractere(""));
   System.out.println("\n");
   }
catch (UpsException e)
   {
   try
      {
      System.out.println("Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '"
         +e.NomSourceEnErreur+"' ligne "+e.NumeroLigne+", colonne "+e.NumeroColonne+" :");
      System.out.println(e.MessageErreur);
      }
   catch (java.lang.Throwable e2)
      {
      System.out.println(e2.toString());
      }      
   }
}

public static void main(String s[]) 
/*********************************/
{
Liste L;
Caractere C;

try
   {
   if (!MUpsKrn.Demarrer())
      return;
   if (!MUpsOrb.Demarrer())
      return;

   A=Annuaire.Annuaire(MUpsKrn.JavaString2Caractere("MonAnnuaire"));
   A.EcrireEntree(MUpsKrn.JavaString2Caractere("coucou"),MUpsKrn.JavaString2Caractere("COUCOU"));
   A.EcrireEntree(MUpsKrn.JavaString2Caractere("hello"),MUpsKrn.JavaString2Caractere("HELLO"));
   A.EcrireEntree(MUpsKrn.JavaString2Caractere("guten tag"),MUpsKrn.JavaString2Caractere("GUTEN TAG"));
   A.EcrireEntree(MUpsKrn.JavaString2Caractere("coucou.coucou"),MUpsKrn.JavaString2Caractere("COUCOU.COUCOU"));
   A.EcrireEntree(MUpsKrn.JavaString2Caractere("hello.coucou"),MUpsKrn.JavaString2Caractere("HELLO.COUCOU"));
   A.EcrireEntree(MUpsKrn.JavaString2Caractere("coucou.hello"),MUpsKrn.JavaString2Caractere("COUCOU.HELLO"));
   A.EcrireEntree(MUpsKrn.JavaString2Caractere("hello.hello"),MUpsKrn.JavaString2Caractere("HELLO.HELLO"));
   A.EcrireEntree(MUpsKrn.JavaString2Caractere("hello.guten tag"),MUpsKrn.JavaString2Caractere("HELLO.GUTEN TAG"));
   A.EcrireEntree(MUpsKrn.JavaString2Caractere("coucou.guten tag"),MUpsKrn.JavaString2Caractere("COUCOU.GUTEN TAG"));
   A.EcrireEntree(MUpsKrn.JavaString2Caractere("guten tag.coucou"),MUpsKrn.JavaString2Caractere("GUTEN TAG.COUCOU"));
   A.EcrireEntree(MUpsKrn.JavaString2Caractere("guten tag.hello"),MUpsKrn.JavaString2Caractere("GUTEN TAG.HELLO"));
   A.EcrireEntree(MUpsKrn.JavaString2Caractere("guten tag.guten tag"),MUpsKrn.JavaString2Caractere("GUTEN TAG.GUTEN TAG"));
   AfficherAnnuaire(A);

   System.out.println(MUpsKrn.Caractere2JavaString((Caractere)A.LireEntree(MUpsKrn.JavaString2Caractere("coucou"))));
   System.out.println(MUpsKrn.Caractere2JavaString((Caractere)A.LireEntree(MUpsKrn.JavaString2Caractere("coucou.coucou"))));
   System.out.println(MUpsKrn.Caractere2JavaString((Caractere)A.LireEntree(MUpsKrn.JavaString2Caractere("coucou.guten tag"))));
   System.out.println(MUpsKrn.Caractere2JavaString((Caractere)A.LireEntree(MUpsKrn.JavaString2Caractere("coucou.hello"))));
   System.out.println(MUpsKrn.Caractere2JavaString((Caractere)A.LireEntree(MUpsKrn.JavaString2Caractere("hello"))));
   System.out.println(MUpsKrn.Caractere2JavaString((Caractere)A.LireEntree(MUpsKrn.JavaString2Caractere("hello.coucou"))));
   System.out.println(MUpsKrn.Caractere2JavaString((Caractere)A.LireEntree(MUpsKrn.JavaString2Caractere("hello.guten tag"))));
   System.out.println(MUpsKrn.Caractere2JavaString((Caractere)A.LireEntree(MUpsKrn.JavaString2Caractere("hello.hello"))));
   System.out.println(MUpsKrn.Caractere2JavaString((Caractere)A.LireEntree(MUpsKrn.JavaString2Caractere("guten tag"))));
   System.out.println(MUpsKrn.Caractere2JavaString((Caractere)A.LireEntree(MUpsKrn.JavaString2Caractere("guten tag.coucou"))));
   System.out.println(MUpsKrn.Caractere2JavaString((Caractere)A.LireEntree(MUpsKrn.JavaString2Caractere("guten tag.guten tag"))));
   System.out.println(MUpsKrn.Caractere2JavaString((Caractere)A.LireEntree(MUpsKrn.JavaString2Caractere("guten tag.hello"))));
   System.out.println("\n");

   A.SupprimerEntree(MUpsKrn.JavaString2Caractere("hello.hello"),false);
   A.SupprimerEntree(MUpsKrn.JavaString2Caractere("guten tag"),true);
   A.EcrireEntree(MUpsKrn.JavaString2Caractere("hello"),MUpsKrn.JavaString2Caractere("HELLO !!!"));
   A.EcrireEntree(MUpsKrn.JavaString2Caractere("coucou.hello"),MUpsKrn.JavaString2Caractere("COUCOU.HELLO !!!"));
   A.RenommerEntree(MUpsKrn.JavaString2Caractere("coucou"),MUpsKrn.JavaString2Caractere("salut"),true);
   A.RenommerEntree(MUpsKrn.JavaString2Caractere("hello.guten tag"),MUpsKrn.JavaString2Caractere("good morning.schluss"),false);
   System.out.println(MUpsKrn.Caractere2JavaString((Caractere)A.LireEntree(MUpsKrn.JavaString2Caractere("hello"))));
   System.out.println(MUpsKrn.Caractere2JavaString((Caractere)A.LireEntree(MUpsKrn.JavaString2Caractere("salut.hello"))));
   System.out.println(MUpsKrn.Caractere2JavaString((Caractere)A.LireEntree(MUpsKrn.JavaString2Caractere("salut"))));
   System.out.println("\n");

   AfficherAnnuaire(A);

   MUpsOrb.AnnuaireLocal().EcrireEntree(MUpsKrn.JavaString2Caractere("coucou"),MUpsKrn.JavaString2Caractere("COUCOU"));
   MUpsOrb.AnnuaireLocal().EcrireEntree(MUpsKrn.JavaString2Caractere("hello"),MUpsKrn.JavaString2Caractere("HELLO"));
   MUpsOrb.AnnuaireLocal().EcrireEntree(MUpsKrn.JavaString2Caractere("guten tag"),MUpsKrn.JavaString2Caractere("GUTEN TAG"));
   MUpsOrb.AnnuaireLocal().SupprimerEntree(MUpsKrn.JavaString2Caractere("hello"),false);
   MUpsOrb.AnnuaireLocal().RenommerEntree(MUpsKrn.JavaString2Caractere("guten tag"),MUpsKrn.JavaString2Caractere("schluss"),false);
   AfficherAnnuaire(MUpsOrb.AnnuaireLocal());

   L=MUpsOrb.LireArborescenceAnnuaireGlobal(MUpsKrn.JavaString2Caractere(""));
   for (C=(Caractere)L.ParcoursAuDebut(0);;C=(Caractere)L.Suivant(0))
      {
      System.out.println(MUpsKrn.Caractere2JavaString(C.Additionner(MUpsKrn.JavaString2Caractere("=")).Additionner((Caractere)MUpsOrb.LireEntreeAnnuaireGlobal(C))));
      if (C.Identique(L.DernierElement()))
         break;
      }

   MUpsOrb.Arreter();
   MUpsKrn.Arreter();
   }
catch (UpsException e)
   {
   try
      {
      System.out.println("Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '"
         +e.NomSourceEnErreur+"' ligne "+e.NumeroLigne+", colonne "+e.NumeroColonne+" :");
      System.out.println(e.MessageErreur);
      }
   catch (java.lang.Throwable e2)
      {
      System.out.println(e2.toString());
      }      
   }
}
}


