/*-------------------------------------------------------------------
Fichier     : upscrb_nt.e
Objet       : En-tete de Up ! Common Object Request Broker Archirecture

Module      : Up ! Common Object Request Broker Archirecture
Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.
---------------------------------------------------------------------
                        Observations
                   
---------------------------------------------------------------------*/ 

/********************************/
#if !defined(PasseModuleUpsCrbNat)
/********************************/
#define PasseModuleUpsCrbNat 1

/**********************/
#if defined(__cplusplus)
/**********************/
extern "C"
{
/****/
#endif
/****/

typedef TypUpsVmUnsignedChar TypUpsCrbBoolean; 
typedef TypUpsVmChar TypUpsCrbChar; 
typedef TypUpsVmChar TypUpsCrbOctet; 
typedef TypUpsVmUnsignedChar TypUpsCrbUnsignedChar; 
typedef TypUpsVmUnsignedShort TypUpsCrbWCharT; 
typedef TypUpsCrbChar *TypUpsCrbString; 
typedef TypUpsCrbWCharT *TypUpsCrbWString; 
typedef TypUpsVmShort TypUpsCrbShort; 
typedef TypUpsVmUnsignedShort TypUpsCrbUShort; 
typedef TypUpsVmLong TypUpsCrbLong; 
typedef TypUpsVmUnsignedLong TypUpsCrbULong; 
typedef TypUpsVmLongLong TypUpsCrbLongLong; 
typedef TypUpsVmUnsignedLongLong TypUpsCrbULongLong; 
typedef TypUpsVmDouble TypUpsCrbFloat; 
typedef TypUpsVmDouble TypUpsCrbDouble; 
typedef TypUpsVmDouble TypUpsCrbLongDouble; 

/****************************************************************/
/* Codification des codes d'erreur.                             */
/****************************************************************/
enum EnuUpsCrbCodeErreur
   {
   CEC_Ok=0,
   CEC_Unknown=1,
   CEC_BadParam=2,
   CEC_NoMemory=3,
   CEC_ImpLimit=4,
   CEC_CommFailure=5,
   CEC_InvObjRef=6,
   CEC_NoPermission=7,
   CEC_Internal=8,
   CEC_Marshal=9,
   CEC_Initialize=10,
   CEC_NoImplement=11,
   CEC_BadTypeCode=12,
   CEC_BadOperation=13,
   CEC_NoResources=14,
   CEC_NoResponse=15,
   CEC_PersistStore=16,
   CEC_BadInvOrder=17,
   CEC_Transient=18,
   CEC_FreeMem=19,
   CEC_InvIdent=20,
   CEC_InvFlag=21,
   CEC_IntfRepos=22,
   CEC_BadContext=23,
   CEC_ObjAdapter=24,
   CEC_DataConversion=25,
   CEC_ObjectNotExist=26,
   CEC_TransactionRequired=27,
   CEC_TransactionRolledBack=28,
   CEC_InvalidTransaction=29
   };

/****************************************************************/
/* Codification des types de donnees.                           */
/****************************************************************/
enum EnuCrbTypeCorba 
   {
   TC_Null=1,
   TC_Void=2,
   TC_Short=3,
   TC_Long=4,
   TC_UShort=5,
   TC_ULong=6,
   TC_Float=7,
   TC_Double=8,
   TC_Boolean=9,
   TC_Char=10,
   TC_UChar=11,
   TC_Octet=12,
   TC_Any=13,
   TC_TypeCode=14,
   TC_Principal=15,
   TC_ObjRef=16,
   TC_Struct=17,
   TC_Union=18,
   TC_Enum=19,
   TC_String=20,
   TC_Sequence=21,
   TC_Array=22,
   TC_Alias=23,
   TC_Except=24,
   TC_LongLong=25,
   TC_ULongLong=26,
   TC_LongDouble=27,
   TC_WChar=28,
   TC_WString=29,
   TC_Fixed=30,
   TC_Value=31,
   TC_ValueBox=32,
   TC_Native=33,
   TC_AbstractInterface=34
   };

/****************************************************************/
/* Codification des sortes de definition.                       */
/****************************************************************/
enum EnuUpsCrbDefinitionKind 
   {
   DK_None=1,
   DK_All=2,
   DK_Attribute=3,
   DK_Constant=4,
   DK_Exception=5,
   DK_Interface=6,
   DK_Module=7,
   DK_Operation=8,
   DK_TypeDef=9,
   DK_Alias=10,
   DK_Struct=11,
   DK_Union=12,
   DK_Enum=13,
   DK_Primitive=14,
   DK_String=15,
   DK_Sequence=16,
   DK_Array=17,
   DK_Repository=18,
   DK_WString=19,
   DK_Fixed=20,
   DK_Value=21,
   DK_ValueBox=22,
   DK_ValueMember=23,
   DK_Native=24
   };

/****************************************************************/
/* Codification des sortes d'attribut.                          */
/****************************************************************/
enum EnuUpsCrbAttributeMode
   { 
   AM_Normal=1,
   AM_Readonly=2
   };

/****************************************************************/
/* Codification du mode d'appel.                                */
/****************************************************************/
enum EnuUpsCrbOperationMode
   { 
   OP_Normal=1, 
   OP_OneWay=2
   };

/****************************************************************/
/* Mode de passage des parametres.                              */
/****************************************************************/
enum EnuUpsCrbParameterMode
   { 
   PM_In=1, 
   PM_Out=2, 
   PM_InOut=3 
   };

/****************************************************************/
/* Codification des formes de Any.                              */
/****************************************************************/
enum EnuUpsCrbTypeAny
   {
   TA_Any=1,
   TA_Enumere=2,
   TA_Entier=3,
   TA_Reel=4,
   TA_String=5,
   TA_WString=6,
   TA_Binaire=7,
   TA_Objet=8
   };

/****************************************************************/
/* Codification constructeurs C speciaux.                       */
/****************************************************************/
enum EnuUpsCrbObjetC
   {	
   OCC_Any=1,
   OCC_Boolean=2,
   OCC_Char=3,
   OCC_Double=4,
   OCC_Fixed=5,
   OCC_Float=6,
   OCC_Long=7,
   OCC_LongDouble=8,
   OCC_LongLong=9,
   OCC_Octet=10,
   OCC_Short=11,
   OCC_String=12,
   OCC_UnsignedShort=13,
   OCC_UnsignedLong=14,
   OCC_UnsignedLongLong=15,
   OCC_WChar=16,
   OCC_WString=17,
   OCC_BooleanSeq=18,
   OCC_CharSeq=19,
   OCC_DoubleSeq=20,
   OCC_FixedSeq=21,
   OCC_FloatSeq=22,
   OCC_LongSeq=23,
   OCC_LongDoubleSeq=24,
   OCC_LongLongSeq=25,
   OCC_OctetSeq=26,
   OCC_ShortSeq=27,
   OCC_StringSeq=28,
   OCC_UnsignedShortSeq=29,
   OCC_UnsignedLongSeq=30,
   OCC_UnsignedLongLongSeq=31,
   OCC_WCharSeq=32,
   OCC_WStringSeq=33,
   OCC_TypeCode=34
   };

/****************************************************************/
/* Codification du code erreur de DllRegister.                  */
/****************************************************************/
enum EnuUpsCrbImplRepository
   {
   IR_ParametresInvalides=1,
      /* Parametres invalides. */
   IR_RepositoryNonTrouve=2,
      /* Le referentiel IR est non trouve. */
   IR_PlusDeMemoire=3,
      /* Plus de memoire. */
   IR_EnregistrementImpossible=4
      /* Enregistrement impossible. */
   };

/****************************************************************/
typedef struct typupscrbvaleurany
/* Objet: Valeur d'un any.                                      */
/****************************************************************/
{
enum EnuUpsCrbTypeAny Sorte;
   /* Sorte de la valeur. */
union
   {
   TypUpsCrbUShort Enumere;
      /* Pour TA_Enumere. */
   TypUpsCrbLong Entier;
      /* Pour TA_Entier. */
   TypUpsCrbDouble Reel;
      /* Pour TA_Reel. */
   TypUpsCrbChar *String;
      /* Pour TA_String. */
   TypUpsCrbWCharT *WString;
      /* Pour TA_WString. */
   TypUpsCrbOctet *Binaire;
      /* Pour TA_Binaire. */
   TypUpsVmPointeurDonnees Objet;
      /* Pour TA_Objet. */
   } Selection;
   /* Selection en fonction de la sorte. */
} *TypUpsCrbValeurAny;

/****************************************************************/
typedef struct typupscrbrany
/* Objet: Any.                                                  */
/****************************************************************/
{
enum EnuUpsCrbParameterMode Mode;
   /* Mode de passage du parametre. */
enum EnuCrbTypeCorba TypeCorba;
   /* Sorte de la valeur du Any. */
union
   {
   TypUpsCrbBoolean Boolean;
      /* TC_Boolean. */
   TypUpsCrbChar Char;
      /* TC_Char. */
   TypUpsCrbDouble Double;
      /* TC_Double. */
   TypUpsCrbUShort Enum;
      /* TC_Enum. */
   TypUpsCrbFloat Float;
      /* TC_Float. */
   TypUpsCrbLong Long;
      /* TC_Long. */
   TypUpsCrbLongDouble LongDouble;
      /* TC_LongDouble. */
   TypUpsCrbLongLong LongLong;
      /* TC_LongLong. */
   TypUpsVmPointeurDonnees ObjRef;
      /* TC_ObjRef. */
   TypUpsCrbOctet Octet;
      /* TC_Octet. */
   TypUpsVmPointeurDonnees Sequence;
      /* TC_Sequence. */
   TypUpsCrbShort Short;
      /* TC_Short. */
   TypUpsCrbString String;
      /* TC_String. */
   TypUpsCrbULong UChar;
      /* TC_UChar. */
   TypUpsCrbULong ULong;
      /* TC_ULong. */
   TypUpsCrbULongLong ULongLong;
      /* TC_ULongLong. */
   TypUpsCrbUShort UShort;
      /* TC_UShort. */
   TypUpsCrbWCharT WChar;
      /* TC_WChar. */
   TypUpsCrbWString WString;
      /* TC_WString. */
   } Selection;
   /* Selection en fonction de la sorte. */
} TypUpsCrbAny;

/****************************************************************/
typedef struct typupscrbparameterdescription
/* Objet : CORBA::ParameterDescription.                         */
/****************************************************************/
{
enum EnuUpsCrbParameterMode Mode;
TypUpsCrbChar Name[CO_TailleIdf+1];
TypUpsVmPointeurDonnees TypeDef;
} TypUpsCrbParameterDescription;

/****************************************************************/
typedef struct typupscrbstructmember
/* Objet : CORBA::StructMember.                                 */
/****************************************************************/
{
TypUpsCrbChar Name[CO_TailleIdf+1];
TypUpsVmPointeurDonnees TypeDef;
} TypUpsCrbStructMember;

/****************************************************************/
typedef struct typupscrbunionmember
/* Objet : CORBA::UnionMember.                                  */
/****************************************************************/
{
TypUpsVmPointeurDonnees Label;
TypUpsCrbChar Name[CO_TailleIdf+1];
TypUpsVmPointeurDonnees TypeDef;
} TypUpsCrbUnionMember;

/****************************************************************/
typedef struct typupscrbnattablemethodesrappel
/* Objet: Methodes de rappel vers Ups Crb.                      */
/****************************************************************/
{
/*--------------------------------------------------------------*/
/* Exportation d'un objet C.          							       */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*ExporterBinaire2)(TypUpsVmPointeurDonnees Session, TypUpsVmLong Taille, TypUpsVmChar *Buffer);
   /* Objet : Exporte un binaire sans la taille en prefixe. */
TypUpsVmVoid UpsVmAPI (*ExporterEntier)(TypUpsVmPointeurDonnees Session, TypUpsVmLong Entier);
   /* Objet : Exporte un entier. */
TypUpsVmVoid UpsVmAPI (*ExporterReel)(TypUpsVmPointeurDonnees Session, TypUpsVmDouble Reel);
   /* Objet : Exporte un reel. */
/*--------------------------------------------------------------*/
/* Importation d'un objet C.          							       */
/*--------------------------------------------------------------*/
TypUpsVmLong UpsVmAPI (*ImporterEntier)(TypUpsVmPointeurDonnees Session);
   /* Objet : Importe un entier. */
TypUpsVmDouble UpsVmAPI (*ImporterReel)(TypUpsVmPointeurDonnees Session);
   /* Objet : Importe un reel. */
TypUpsVmVoid UpsVmAPI (*ImporterBinaire)(TypUpsVmPointeurDonnees Session, TypUpsVmChar *Buffer, TypUpsVmLong Taille);
   /* Objet : Importe un binaire. */
} *TypUpsCrbNatTableMethodesRappel;

typedef TypUpsVmVoid (*TypUpsCrbTracerServices)(TypUpsVmChar *NomServices);

/****************************************************************/
typedef struct typupscrbnattraitements_1_1_0
/* Objet: Interface des traitements de Ups Crb Nat.             */
/****************************************************************/
{
/*--------------------------------------------------------------*/
/* Application Program Interfaces.   							       */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*AllouerUnTableau)(enum EnuUpsCrbObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC, TypUpsVmLong *TableDimensions, TypUpsVmShort NbDimensions, 
   TypUpsVmLong BorneMin, TypUpsVmLong BorneMax, enum EnuUpsVmTypeDeDonnee TypeObjetUps);
   /* Objet : Allocation d'un tableau. */
TypUpsVmPointeurDonnees UpsVmAPI (*ClonerObjetC)(enum EnuUpsCrbObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC, TypUpsVmPointeurDonnees ObjetC2);
   /* Objet : Clonage d'un objet C. */
TypUpsVmPointeurDonnees UpsVmAPI (*ConstruireObjetC)(enum EnuUpsCrbObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC);
   /* Objet : Constructeur d'un objet C. */
TypUpsVmVoid UpsVmAPI (*DetruireObjetC)(enum EnuUpsCrbObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC, TypUpsVmShort Reallouer);
   /* Objet : Destructeur d'un objet C. */
TypUpsVmShort UpsVmAPI (*EcrireObjetC)(enum EnuUpsVmTypeDeDonnee TypeObjetUps, TypUpsVmPointeurDonnees ObjetUps, enum EnuUpsCrbObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC,
   TypUpsVmLong *TableDimensions, TypUpsVmShort NbDimensions);
   /* Objet : Ecriture d'un objet C. */
TypUpsVmShort UpsVmAPI (*EstUnObjetUpsVtm)(TypUpsVmPointeurDonnees pObjet, TypUpsVmChar *EstInstanceDe);
   /* Objet : Retourne Vrai s'il s'agit d'un objet Vtm encapsule. */
TypUpsVmPointeurDonnees UpsVmAPI (*EcrireValeurAny)(TypUpsCrbValeurAny Valeur);
   /* Objet : Ecrit la  valeur d'un objet Any. */
TypUpsVmVoid UpsVmAPI (*EnvoyerException)(TypUpsCrbString MessageErreur, TypUpsCrbLong CodeErreur, TypUpsCrbString NomException, 
   TypUpsCrbString NomSourceEnErreur, TypUpsCrbLong NumeroLigne, TypUpsCrbLong NumeroColonne, TypUpsCrbString ModuleOrigine);
   /* Objet : Envoi une exception Ups Crb. */
TypUpsVmShort (*EstUnTableau)(enum EnuUpsCrbObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC, TypUpsVmLong *TableDimensions, TypUpsVmShort NbDimensions, TypUpsVmShort *EstNul, 
   TypUpsVmUnsignedShort *BorneMin, TypUpsVmUnsignedShort *BorneMax, enum EnuUpsCrbObjetC *TypeObjetElementC, enum EnuUpsVmTypeDeDonnee *TypeObjetElementUps);
   /* Objet : Verifie si l'objet C est un tableau. */
TypUpsVmVoid UpsVmAPI (*ExporterObjetC)(TypUpsVmPointeurDonnees Session, enum EnuUpsCrbObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC);
   /* Objet : Exportation d'un objet C. */
TypUpsVmShort UpsVmAPI (*ExporterObjetValueBase)(TypUpsVmPointeurDonnees pObjet, TypUpsVmChar *NomFichier, TypUpsVmChar *MessageErreur);
   /* Objet : exporte un objet ValueBase dans un fichier. */
TypUpsVmPointeurDonnees UpsVmAPI (*ImporterObjetC)(TypUpsVmPointeurDonnees Session, enum EnuUpsCrbObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC);
   /* Objet : Importation d'un objet C. */
TypUpsVmPointeurDonnees UpsVmAPI (*ImporterObjetValueBase)(TypUpsVmChar *NomFichier, TypUpsVmChar *MessageErreur);
   /* Objet : importe un objet ValueBase dans un fichier. */
TypUpsVmShort UpsVmAPI (*Initialiser)(TypUpsVmPointeurDonnees *pOrb, TypUpsVmPointeurDonnees *pPoa, TypUpsVmShort argc, TypUpsVmChar **argv,
   TypUpsVmChar *MessageErreur, TypUpsCrbTracerServices TracerServices);
   /* Objet : Initialisation de l'Orb de Corba. */
TypUpsVmShort UpsVmAPI (*LireObjetC)(enum EnuUpsCrbObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC, 
   TypUpsVmLong *TableDimensions, TypUpsVmShort NbDimensions, enum EnuUpsVmTypeDeDonnee *TypeObjetUps, TypUpsVmPointeurDonnees ObjetUps);
   /* Objet : Lecture d'un objet C. */
TypUpsVmPointeurDonnees UpsVmAPI (*LireTypeCodeInterface)(TypUpsVmPointeurDonnees pObjet, TypUpsVmChar *MessageErreur);
   /* Objet : Le TypeCode d'une interface. */
TypUpsVmPointeurDonnees UpsVmAPI (*LireTypeCodeValueBase)(TypUpsVmPointeurDonnees pObjet, TypUpsVmChar *MessageErreur);
   /* Objet : Le TypeCode d'un valuetype. */
TypUpsVmLong UpsVmAPI (*LireTailleContainedSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la taille d'un CORBA::Contained<>. */
TypUpsVmLong UpsVmAPI (*LireTailleContextIdSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la taille d'un CORBA::ContextId<>. */
TypUpsVmLong UpsVmAPI (*LireTailleEnumMemberSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la taille d'un CORBA::EnumMember<>. */
TypUpsVmLong UpsVmAPI (*LireTailleExceptionDefSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la taille d'un CORBA::ExceptionDef<>. */
TypUpsVmLong UpsVmAPI (*LireTailleInterfaceDefSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la taille d'un CORBA::InterfaceDef<>. */
TypUpsVmLong UpsVmAPI (*LireTailleOctetSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la taille d'un CORBA::Octet<>. */
TypUpsVmLong UpsVmAPI (*LireTailleValueDefSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la taille d'un CORBA::ValueDef<>. */
TypUpsVmShort UpsVmAPI (*LireValeurAny)(TypUpsVmPointeurDonnees pObjetAny, TypUpsCrbValeurAny Valeur);
   /* Objet : Lit la valeur d'un objet Any. */
TypUpsCrbChar UpsVmAPI *(*LireValeurCharSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la valeur d'un CORBA::Char<>. */
TypUpsVmPointeurDonnees UpsVmAPI *(*LireValeurContainedSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la valeur d'un CORBA::Contained<>. */
TypUpsCrbChar UpsVmAPI **(*LireValeurContextIdSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la valeur d'un CORBA::ContextId<>. */
TypUpsCrbChar UpsVmAPI **(*LireValeurEnumMemberSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la valeur d'un CORBA::EnumMember<>. */
TypUpsVmPointeurDonnees UpsVmAPI *(*LireValeurExceptionDefSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la valeur d'un CORBA::ExceptionDef<>. */
TypUpsVmPointeurDonnees UpsVmAPI *(*LireValeurInterfaceDefSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la valeur d'un CORBA::InterfaceDef<>. */
TypUpsCrbOctet UpsVmAPI *(*LireValeurOctetSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la valeur d'un CORBA::Octet<>. */
TypUpsCrbChar UpsVmAPI *(*LireValeurString)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la valeur d'un CORBA::String. */
TypUpsVmPointeurDonnees UpsVmAPI *(*LireValeurValueDefSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la valeur d'un CORBA::ValueDef<>. */
TypUpsCrbWCharT UpsVmAPI *(*LireValeurWCharTSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la valeur d'un CORBA::WCharT<>. */
TypUpsCrbWCharT UpsVmAPI *(*LireValeurWString)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la valeur d'un CORBA::WString. */
TypUpsVmPointeurDonnees UpsVmAPI (*NewCharSequence)(TypUpsCrbChar *Buffer, TypUpsVmLong Taille);
   /* Objet : Alloue une sequence de caracteres. */
TypUpsVmPointeurDonnees UpsVmAPI (*NewOctetSequence)(TypUpsCrbOctet *Buffer, TypUpsVmLong Taille);
   /* Objet : Alloue une sequence d'octets. */
TypUpsVmPointeurDonnees UpsVmAPI (*NewString)(TypUpsCrbChar *Buffer, TypUpsVmLong Taille);
   /* Objet : Alloue une chaine de caracteres. */
TypUpsVmPointeurDonnees UpsVmAPI (*NewWCharTSequence)(TypUpsCrbWCharT *Buffer, TypUpsVmLong Taille);
   /* Objet : Alloue une sequence de caracteres. */
TypUpsVmPointeurDonnees UpsVmAPI (*NewWString)(TypUpsCrbWCharT *Buffer, TypUpsVmLong Taille);
   /* Objet : Alloue une chaine de caracteres. */
TypUpsVmVoid UpsVmAPI (*SetTableMethodesRappel)(TypUpsCrbNatTableMethodesRappel TableMethodesRappel2);
   /* Objet : Memorise la table de methodes de rappel vers Ups Crb. */
TypUpsCrbString UpsVmAPI (*StringAlloc)(TypUpsVmLong Taille);
   /* Objet : CORBA::string_alloc. */
TypUpsVmVoid UpsVmAPI (*StringFree)(TypUpsCrbString Chaine);
   /* Objet : CORBA::string_free. */
TypUpsVmVoid UpsVmAPI (*Throw)(enum EnuUpsCrbCodeErreur CodeErreur);
   /* Objet : Envoi l'exception correspondant au code d'erreur. */
TypUpsCrbWString UpsVmAPI (*WStringAlloc)(TypUpsVmLong Taille);
   /* Objet : CORBA::wstring_alloc. */
TypUpsVmVoid UpsVmAPI (*WStringFree)(TypUpsCrbWString Chaine);
   /* Objet : CORBA::wstring_free. */
/*--------------------------------------------------------------*/
/* AliasDef.                        							       */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*AliasDefName)(TypUpsVmPointeurDonnees pObjetAliasDef, TypUpsVmChar *NomAlias);
   /* Objet : CORBA::AliasDef::name. */
TypUpsVmPointeurDonnees UpsVmAPI (*AliasDefNarrow)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::AliasDef::narrow. */
TypUpsVmPointeurDonnees UpsVmAPI (*AliasDefOriginalTypeDef)(TypUpsVmPointeurDonnees pObjetAliasDef);
   /* Objet : CORBA::AliasDef::original_type_def. */
/*--------------------------------------------------------------*/
/* ArrayDef.                        							       */
/*--------------------------------------------------------------*/
TypUpsVmPointeurDonnees UpsVmAPI (*ArrayDefElementTypeDef)(TypUpsVmPointeurDonnees pObjetArrayDef);
   /* Objet : CORBA::ArrayDef::element_type_def. */
TypUpsVmLong UpsVmAPI (*ArrayDefLength)(TypUpsVmPointeurDonnees pObjetArrayDef);
   /* Objet : CORBA::ArrayDef::length. */
TypUpsVmPointeurDonnees UpsVmAPI (*ArrayDefNarrow)(TypUpsVmPointeurDonnees pObjetIdlType);
   /* Objet : CORBA::ArrayDef::narrow. */
/*--------------------------------------------------------------*/
/* AttributeDef.                     							       */
/*--------------------------------------------------------------*/
enum EnuUpsCrbAttributeMode UpsVmAPI (*AttributeDefMode)(TypUpsVmPointeurDonnees pObjetAttributeDef);
   /* Objet : CORBA::AttributeDef::mode. */
TypUpsVmVoid UpsVmAPI (*AttributeDefName)(TypUpsVmPointeurDonnees pObjetAttributeDef, TypUpsVmChar *NomAttribut);
   /* Objet : CORBA::AttributeDef::name. */
TypUpsVmPointeurDonnees UpsVmAPI (*AttributeDefNarrow)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::AttributeDef::narrow. */
TypUpsVmPointeurDonnees UpsVmAPI (*AttributeDefTypeDef)(TypUpsVmPointeurDonnees pObjetAttributeDef);
   /* Objet : CORBA::AttributeDef::type_def. */
/*--------------------------------------------------------------*/
/* ConstantDef.                      							       */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*ConstantDefName)(TypUpsVmPointeurDonnees pObjetConstantDef, TypUpsVmChar *NomConstante);
   /* Objet : CORBA::ConstantDef::name. */
TypUpsVmPointeurDonnees UpsVmAPI (*ConstantDefNarrow)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::ConstantDef::narrow. */
TypUpsVmPointeurDonnees UpsVmAPI (*ConstantDefTypeDef)(TypUpsVmPointeurDonnees pObjetConstantDef);
   /* Objet : CORBA::ConstantDef::type_def. */
TypUpsVmPointeurDonnees UpsVmAPI (*ConstantDefValue)(TypUpsVmPointeurDonnees pObjetConstantDef);
   /* Objet : CORBA::ConstantDef::value. */
/*--------------------------------------------------------------*/
/* Contained.                        							       */
/*--------------------------------------------------------------*/
enum EnuUpsCrbDefinitionKind UpsVmAPI (*ContainedDefKind)(TypUpsVmPointeurDonnees pObjetContained);
   /* Objet : CORBA::Contained::def_kind. */
TypUpsVmVoid UpsVmAPI (*ContainedDelete)(TypUpsVmPointeurDonnees pObjetContained);
   /* Objet : CORBA::Contained::delete. */
TypUpsVmVoid UpsVmAPI (*ContainedName)(TypUpsVmPointeurDonnees pObjetContained, TypUpsVmChar *NomType);
   /* Objet : CORBA::Contained::name. */
/*--------------------------------------------------------------*/
/* EnumDefs.                        							       */
/*--------------------------------------------------------------*/
TypUpsVmPointeurDonnees UpsVmAPI (*EnumDefMembers)(TypUpsVmPointeurDonnees pObjetEnumDef);
   /* Objet : CORBA::EnumDef::members. */
TypUpsVmVoid UpsVmAPI (*EnumDefName)(TypUpsVmPointeurDonnees pObjetEnumDef, TypUpsVmChar *NomEnumere);
   /* Objet : CORBA::EnumDef::name. */
TypUpsVmPointeurDonnees UpsVmAPI (*EnumDefNarrow)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::EnumDef::narrow. */
/*--------------------------------------------------------------*/
/* ExceptionDef.                     							       */
/*--------------------------------------------------------------*/
TypUpsCrbStructMember UpsVmAPI *(*ExceptionDefMembers)(TypUpsVmPointeurDonnees pObjetExceptionDef, TypUpsVmLong *TailleTableau);
   /* Objet : CORBA::ExceptionDef::members. */
TypUpsVmVoid UpsVmAPI (*ExceptionDefName)(TypUpsVmPointeurDonnees pObjetExceptionDef, TypUpsVmChar *NomException);
   /* Objet : CORBA::ExceptionDef::name. */
TypUpsVmPointeurDonnees UpsVmAPI (*ExceptionDefNarrow)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::ExceptionDef::narrow. */
/*--------------------------------------------------------------*/
/* Exception.                        							       */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*ExceptionDescriptionName)(TypUpsVmPointeurDonnees pException, TypUpsVmChar *MessageErreur);
   /* Objet : CORBA::Exception::description.name. */
/*--------------------------------------------------------------*/
/* IDLType.                         							       */
/*--------------------------------------------------------------*/
TypUpsVmPointeurDonnees UpsVmAPI (*IdlTypeType)(TypUpsVmPointeurDonnees pObjetIdlType);
   /* Objet : CORBA::IDLType::type. */
/*--------------------------------------------------------------*/
/* InterfaceDef.                     							       */
/*--------------------------------------------------------------*/
TypUpsVmPointeurDonnees UpsVmAPI (*InterfaceDefBaseInterfaces)(TypUpsVmPointeurDonnees pObjetInterfaceDef);
   /* Objet : CORBA::InterfaceDef::base_interfaces. */
TypUpsVmPointeurDonnees UpsVmAPI (*InterfaceDefContents)(TypUpsVmPointeurDonnees pObjetInterfaceDef);
   /* Objet : CORBA::InterfaceDef::contents. */
TypUpsVmVoid UpsVmAPI (*InterfaceDefName)(TypUpsVmPointeurDonnees pObjetInterfaceDef, TypUpsVmChar *NomInterface);
   /* Objet : CORBA::InterfaceDef::name. */
TypUpsVmPointeurDonnees UpsVmAPI (*InterfaceDefNarrow)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::InterfaceDef::narrow. */
/*--------------------------------------------------------------*/
/* ModuleDef.                        							       */
/*--------------------------------------------------------------*/
TypUpsVmPointeurDonnees UpsVmAPI (*ModuleDefContents)(TypUpsVmPointeurDonnees pObjetModuleDef);
   /* Objet : CORBA::ModuleDef::contents. */
TypUpsVmVoid UpsVmAPI (*ModuleDefName)(TypUpsVmPointeurDonnees pObjetModuleDef, TypUpsVmChar *NomModule);
   /* Objet : CORBA::ModuleDef::name. */
TypUpsVmPointeurDonnees UpsVmAPI (*ModuleDefNarrow)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::ModuleDef::narrow. */
/*--------------------------------------------------------------*/
/* NativeDef.                        							       */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*NativeDefName)(TypUpsVmPointeurDonnees pObjetNativeDef, TypUpsVmChar *NomTypeNatif);
   /* Objet : CORBA::NativeDef::name. */
TypUpsVmPointeurDonnees UpsVmAPI (*NativeDefNarrow)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::NativeDef::narrow. */
/*--------------------------------------------------------------*/
/* OAD.                             							       */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*OadRegImplementation)(TypUpsVmChar *ApplicationName, TypUpsVmChar *RepositoryId, TypUpsVmChar *InprocServer, 
   TypUpsVmChar *LocalServer, enum EnuUpsCrbImplRepository *CodeErreur);
   /* Objet : Activation::OAD::reg_implementation. */
TypUpsVmShort UpsVmAPI (*OadUnregImplementation)(TypUpsVmChar *ApplicationName, TypUpsVmChar *RepositoryId, enum EnuUpsCrbImplRepository *CodeErreur);
   /* Objet : Activation::Oad::unreg_implementation. */
/*--------------------------------------------------------------*/
/* Object.                          							       */
/*--------------------------------------------------------------*/
TypUpsVmPointeurDonnees UpsVmAPI (*ObjectClone)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::Object::clone. */
TypUpsVmVoid UpsVmAPI (*ObjectDuplicate)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::object::duplicate. */
TypUpsCrbBoolean UpsVmAPI (*ObjectIsA)(TypUpsVmPointeurDonnees pObjet, TypUpsVmPointeurDonnees pObjetType);
   /* Objet : CORBA::Object::is_a. */
TypUpsCrbBoolean UpsVmAPI (*ObjectIsBound)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::Object::is_bound. */
TypUpsCrbBoolean UpsVmAPI (*ObjectIsEquivalent)(TypUpsVmPointeurDonnees pObjet1, TypUpsVmPointeurDonnees pObjet2);
   /* Objet : CORBA::Object::is _equivalent. */
TypUpsCrbBoolean (*ObjectIsPersistent)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::Object::is_persistent. */
TypUpsVmVoid UpsVmAPI (*ObjectRelease)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::Object::release. */
TypUpsVmShort UpsVmAPI (*ObjectRepOId)(TypUpsVmPointeurDonnees pObjet, TypUpsVmChar *Identifiant);
   /* Objet : CORBA::Object::repoid. */
/*--------------------------------------------------------------*/
/* OperationDef.                      							       */
/*--------------------------------------------------------------*/
TypUpsVmPointeurDonnees UpsVmAPI (*OperationDefContexts)(TypUpsVmPointeurDonnees pObjetOperationDef);
   /* Objet : CORBA::OperationDef::contexts. */
TypUpsVmPointeurDonnees UpsVmAPI (*OperationDefExceptions)(TypUpsVmPointeurDonnees pObjetOperationDef);
   /* Objet : CORBA::OperationDef::exceptions. */
enum EnuUpsCrbOperationMode UpsVmAPI (*OperationDefMode)(TypUpsVmPointeurDonnees pObjetOperationDef);
   /* Objet : CORBA::OperationDef::mode. */
TypUpsVmVoid UpsVmAPI (*OperationDefName)(TypUpsVmPointeurDonnees pObjetOperationDef, TypUpsVmChar *NomMethode);
   /* Objet : CORBA::OperationDef::name. */
TypUpsVmPointeurDonnees UpsVmAPI (*OperationDefNarrow)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::OperationDef::narrow. */
TypUpsCrbParameterDescription UpsVmAPI *(*OperationDefParams)(TypUpsVmPointeurDonnees pObjetOperationDef, TypUpsVmLong *TailleTableau);
   /* Objet : CORBA::OperationDef::params. */
TypUpsVmPointeurDonnees UpsVmAPI (*OperationDefResultDef)(TypUpsVmPointeurDonnees pObjetOperationDef);
   /* Objet : CORBA::OperationDef::result_def. */
/*--------------------------------------------------------------*/
/* Orb.                             							       */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*OrbBind)(TypUpsVmPointeurDonnees pOrb, TypUpsVmChar *RepositoryId, TypUpsVmPointeurDonnees *pObjet);
   /* Objet : CORBA::ORB::bind. */
TypUpsCrbChar UpsVmAPI *(*OrbObjectToString)(TypUpsVmPointeurDonnees pOrb, TypUpsVmPointeurDonnees pObject, TypUpsVmChar *MessageErreur);
   /* Objet : CORBA::Orb::object_to_string. */
TypUpsVmShort UpsVmAPI (*OrbRun)(TypUpsVmPointeurDonnees pOrb, TypUpsVmPointeurDonnees pPoa);
   /* Objet : PortableServer::POA::deactivate_object. */
TypUpsVmPointeurDonnees UpsVmAPI (*OrbStringToObject)(TypUpsVmPointeurDonnees pOrb, TypUpsCrbChar *ChaineSerialisation, TypUpsVmChar *MessageErreur);
   /* Objet : CORBA::ORB::string_to_object. */
TypUpsVmVoid UpsVmAPI (*OrbShutdown)(TypUpsVmPointeurDonnees pOrb, TypUpsVmPointeurDonnees pPoa);
   /* Objet : CORBA::Orb::shutdown. */
/*--------------------------------------------------------------*/
/* ParameterDescription.              							       */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*ParameterDescriptionDelete)(TypUpsCrbParameterDescription *Tableau);
   /* Objet : Detruit un tableau de ParameterDescription. */
/*--------------------------------------------------------------*/
/* POA.                             							       */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*PoaActivateObject)(TypUpsVmPointeurDonnees pPoa, TypUpsVmPointeurDonnees pObjet);
   /* Objet : PortableServer::POA::activate_object. */
TypUpsVmVoid UpsVmAPI (*PoaDeactivateObject)(TypUpsVmPointeurDonnees pPoa, TypUpsVmPointeurDonnees pObjet);
   /* Objet : PortableServer::POA::deactivate_object. */
/*--------------------------------------------------------------*/
/* Repository.                       							       */
/*--------------------------------------------------------------*/
TypUpsVmPointeurDonnees UpsVmAPI (*RepositoryBind)(TypUpsVmChar *MessageErreur);
   /* Objet : CORBA::Repository::bind. */
TypUpsVmVoid UpsVmAPI (*RepositoryDelete)(TypUpsVmPointeurDonnees pObjetRepository);
   /* Objet : CORBA::Repository::delete. */
TypUpsVmPointeurDonnees UpsVmAPI (*RepositoryLookupName)(TypUpsVmPointeurDonnees pObjetRepository, TypUpsVmChar *NomInterface);
   /* Objet : CORBA::Repository::lookup_name. */
/*--------------------------------------------------------------*/
/* Request.                         							       */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*RequestInvoke)(TypUpsVmPointeurDonnees pObjet, TypUpsVmChar *NomMethode, TypUpsCrbAny *TableParametresAny, 
   TypUpsVmShort NbParametres, enum EnuCrbTypeCorba TypeCorbaResultat, TypUpsCrbAny *ResultatAny, TypUpsVmChar *MessageErreur);
   /* Objet : CORBA::Request::invoke. */
/*--------------------------------------------------------------*/
/* Sequence.                        							       */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*SequenceDelete)(TypUpsVmPointeurDonnees pSequence);
   /* Objet : CORBA::Sequence::delete. */
TypUpsVmVoid UpsVmAPI (*SequenceGet)(TypUpsVmPointeurDonnees Sequence, enum EnuCrbTypeCorba TypeCorba, TypUpsVmLong Indice, TypUpsCrbAny *Valeur);
   /* Objet : CORBA::Sequence::[]. */
TypUpsVmLong UpsVmAPI (*SequenceLength)(TypUpsVmPointeurDonnees Sequence, enum EnuCrbTypeCorba TypeCorba);
   /* Objet : CORBA::Sequence::length. */
TypUpsVmPointeurDonnees UpsVmAPI (*SequenceNew)(enum EnuCrbTypeCorba TypeCorba, TypUpsVmLong Taille);
   /* Objet : CORBA::Sequence::new. */
TypUpsVmVoid UpsVmAPI (*SequencePut)(TypUpsVmPointeurDonnees Sequence, enum EnuCrbTypeCorba TypeCorba, TypUpsVmLong Indice, TypUpsCrbAny *Valeur);
   /* Objet : CORBA::Sequence::[]. */
/*--------------------------------------------------------------*/
/* StructDef.                        							       */
/*--------------------------------------------------------------*/
TypUpsCrbStructMember UpsVmAPI *(*StructDefMembers)(TypUpsVmPointeurDonnees pObjetStructDef, TypUpsVmLong *TailleTableau);
   /* Objet : CORBA::StructDef::members. */
TypUpsVmVoid UpsVmAPI (*StructDefName)(TypUpsVmPointeurDonnees pObjetStructDef, TypUpsVmChar *NomType);
   /* Objet : CORBA::StructDef::name. */
TypUpsVmPointeurDonnees UpsVmAPI (*StructDefNarrow)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::StructDef::narrow. */
/*--------------------------------------------------------------*/
/* StructMember.                      							       */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*StructMemberDelete)(TypUpsCrbStructMember *Tableau);
   /* Objet : Detruit un tableau de StructMember. */
/*--------------------------------------------------------------*/
/* TypeCode.                        							       */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*TypeCodeContentType)(TypUpsVmPointeurDonnees pObjetType, TypUpsVmChar *NomContenu);
   /* Objet : CORBA::TypeCode::content_type. */
TypUpsVmLong UpsVmAPI (*TypeCodeDefaultIndex)(TypUpsVmPointeurDonnees pObjetType);
   /* Objet : CORBA::TypeCode::default_index. */
TypUpsVmVoid UpsVmAPI (*TypeCodeDelete)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::TypeCode::delete. */
TypUpsVmShort UpsVmAPI (*TypeCodeFixedDigits)(TypUpsVmPointeurDonnees pObjetType);
   /* Objet : CORBA::TypeCode::fixed_digits. */
TypUpsVmShort UpsVmAPI (*TypeCodeFixedScale)(TypUpsVmPointeurDonnees pObjetType);
   /* Objet : CORBA::TypeCode::fixed_scale. */
TypUpsCrbBoolean UpsVmAPI (*TypeCodeIsA)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::TypeCode::is_a. */
enum EnuCrbTypeCorba UpsVmAPI (*TypeCodeKind)(TypUpsVmPointeurDonnees pObjetType);
   /* Objet : CORBA::TypeCode::kind. */
TypUpsVmLong UpsVmAPI (*TypeCodeLength)(TypUpsVmPointeurDonnees pObjetType);
   /* Objet : CORBA::TypeCode::length. */
TypUpsVmVoid UpsVmAPI (*TypeCodeName)(TypUpsVmPointeurDonnees pObjetType, TypUpsVmChar *NomType);
   /* Objet : CORBA::TypeCode::name. */
TypUpsVmPointeurDonnees UpsVmAPI (*TypeCodeNew)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::TypeCode::new. */
/*--------------------------------------------------------------*/
/* UnionDef.                        							       */
/*--------------------------------------------------------------*/
TypUpsVmPointeurDonnees UpsVmAPI (*UnionDefDiscriminatorType)(TypUpsVmPointeurDonnees pObjetUnionDef);
   /* Objet : CORBA::UnionDef::discrimator_type. */
TypUpsVmPointeurDonnees UpsVmAPI (*UnionDefDiscriminatorTypeDef)(TypUpsVmPointeurDonnees pObjetUnionDef);
   /* Objet : CORBA::UnionDef::discriminator_type_def. */
TypUpsCrbUnionMember UpsVmAPI *(*UnionDefMembers)(TypUpsVmPointeurDonnees pObjetUnionDef, TypUpsVmLong *TailleTableau);
   /* Objet : CORBA::UnionDef::members. */
TypUpsVmVoid UpsVmAPI (*UnionDefName)(TypUpsVmPointeurDonnees pObjetUnionDef, TypUpsVmChar *NomUnion);
   /* Objet : CORBA::UnionDef::name. */
TypUpsVmPointeurDonnees UpsVmAPI (*UnionDefNarrow)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::UnionDef::narrow. */
/*--------------------------------------------------------------*/
/* UnionMember.                       							       */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*UnionMemberDelete)(TypUpsCrbUnionMember *Tableau);
   /* Objet : Detruit un tableau de UnionMember. */
/*--------------------------------------------------------------*/
/* ValueBase.                        							       */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*ValueBaseAddRef)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::ValueBase::add_ref. */
TypUpsVmPointeurDonnees UpsVmAPI (*ValueBaseCopyValue)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::ValueBase::copy_value. */
TypUpsVmShort UpsVmAPI (*ValueBaseId)(TypUpsVmPointeurDonnees pObjet, TypUpsVmChar *Identifiant);
   /* Objet : CORBA::ValueBase::id. */
TypUpsCrbBoolean UpsVmAPI (*ValueBaseIsA)(TypUpsVmPointeurDonnees pObjet, TypUpsVmPointeurDonnees pObjetType);
   /* Objet : CORBA::ValueBase::is_a. */
TypUpsVmVoid UpsVmAPI (*ValueBaseRemoveRef)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::ValueBase::remove_ref. */
/*--------------------------------------------------------------*/
/* ValueBoxDef.                       							       */
/*--------------------------------------------------------------*/
TypUpsVmPointeurDonnees UpsVmAPI (*ValueBoxDefOriginalTypeDef)(TypUpsVmPointeurDonnees pObjetValueBoxDef);
   /* Objet : CORBA::ValueBoxDef::original_type_def. */
TypUpsVmVoid UpsVmAPI (*ValueBoxDefName)(TypUpsVmPointeurDonnees pObjetValueBoxDef, TypUpsVmChar *NomType);
   /* Objet : CORBA::ValueBoxDef::name. */
TypUpsVmPointeurDonnees UpsVmAPI (*ValueBoxDefNarrow)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::ValueBoxDef::narrow. */
/*--------------------------------------------------------------*/
/* ValueDef.                        							       */
/*--------------------------------------------------------------*/
TypUpsVmPointeurDonnees UpsVmAPI (*ValueDefAbstractBaseValues)(TypUpsVmPointeurDonnees pObjetValueDef);
   /* Objet : CORBA::ValueDef::abstract_base_values. */
TypUpsVmPointeurDonnees UpsVmAPI (*ValueDefBaseValue)(TypUpsVmPointeurDonnees pObjetValueDef);
   /* Objet : CORBA::ValueDef::base_value. */
TypUpsVmPointeurDonnees UpsVmAPI (*ValueDefContents)(TypUpsVmPointeurDonnees pObjetValueDef);
   /* Objet : CORBA::ValueDef::contents. */
TypUpsCrbBoolean UpsVmAPI (*ValueDefIsAbstract)(TypUpsVmPointeurDonnees pObjetValueDef);
   /* Objet : CORBA::ValueDef::is_abstract. */
TypUpsCrbBoolean UpsVmAPI (*ValueDefIsCustom)(TypUpsVmPointeurDonnees pObjetValueDef);
   /* Objet : CORBA::ValueDef::is_custom. */
TypUpsCrbBoolean UpsVmAPI (*ValueDefIsTruncatable)(TypUpsVmPointeurDonnees pObjetValueDef);
   /* Objet : CORBA::ValueDef::is_truncatable. */
TypUpsVmVoid UpsVmAPI (*ValueDefName)(TypUpsVmPointeurDonnees pObjetValueDef, TypUpsVmChar *NomType);
   /* Objet : CORBA::ValueDef::name. */
TypUpsVmPointeurDonnees UpsVmAPI (*ValueDefNarrow)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::ValueDef::narrow. */
TypUpsVmPointeurDonnees UpsVmAPI (*ValueDefSupportedInterfaces)(TypUpsVmPointeurDonnees pObjetValueDef);
   /* Objet : CORBA::ValueDef::supported_interfaces. */
} *TypUpsCrbNatTraitements_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsCrbNatTraitements_1_1_0 TypUpsCrbNatTraitements;

extern DllExport TypUpsCrbNatTraitements UpsVmAPI UpsCrbNatDemarrerModule(TypUpsVtmMachineInterface MachineInterfaceUpsVtm);
   /* Objet : Retourne la description de Ups Crb Nat. */

/**********************/
#if defined(__cplusplus)
/**********************/
}
/****/
#endif
/****/

/****/
#endif
/****/
