/*-------------------------------------------------------------------
Fichier     : upscrb.e
Objet       : En-tete du module Up ! Common Object Request Broker Architecture.

Module      : Up ! Common Object Request Broker Architecture
Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.
---------------------------------------------------------------------
                         Observations

 
---------------------------------------------------------------------*/

/*****************************/
#if !defined(PasseModuleUpsCrb)
/*****************************/
#define PasseModuleUpsCrb 1

#include <upscrb_nt.e>

/**********************/
#if defined(__cplusplus)
/**********************/
extern "C"
{
/****/
#endif
/****/

/****************************************************************/
/* Codification de l'objet natif.                               */
/****************************************************************/
enum EnuUpsCrbObjetCorba
   {
   OC_ObjetInterface=1,
      /* Objet implementant CORBA::Object. */
   OC_ObjetValueBase=2,
      /* Objet implementant CORBA::ValueBase. */
   OC_ObjetTypeCode=3,
      /* Objet CORBA::TypeCode. */
   OC_ObjetC=4
      /* Objet correspondant a une structure ou une union C. */
   };

/****************************************************************/
typedef struct typupscrbmachineinterface_1_1_0
/* Objet : Interface avec la machine pour Up ! Common Object    */
/* Request Broker Architecture.                                 */ 
/****************************************************************/
{
TypUpsCrbChar UpsVmAPI *(*Caractere2Char)(TypUpsVmSession *Session, TypUpsCrbChar *Buffer, 
   TypUpsVmLong TailleBuffer, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Lit un objet de type Caractere en un objet de type CORBA::Char *. */
TypUpsVmAdresse UpsVmAPI *(*Char2Caractere)(TypUpsVmSession *Session, 
	TypUpsVmAdresse *AdresseResultat, TypUpsCrbChar *Buffer);
   /* Objet : Lit un objet de type CORBA::Char * en un objet de type Caractere. */
/*--------------------------------------------------------------*/
/* Application Program Interfaces.   							       */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*AllouerUnTableau)(enum EnuUpsCrbObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC, TypUpsVmLong *TableDimensions, TypUpsVmShort NbDimensions,
   TypUpsVmLong BorneMin, TypUpsVmLong BorneMax, enum EnuUpsVmTypeDeDonnee TypeObjetUps);
   /* Objet : Allocation d'un tableau. */
TypUpsVmPointeurDonnees UpsVmAPI (*ClonerObjetC)(enum EnuUpsCrbObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC, TypUpsVmPointeurDonnees ObjetC2);
   /* Objet : Clonage d'un objet C. */
TypUpsVmPointeurDonnees UpsVmAPI (*ConstruireObjetC)(TypUpsVmSession *Session, enum EnuUpsCrbObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC);
   /* Objet : Constructeur d'un objet C. */
TypUpsVmVoid UpsVmAPI (*DetruireObjetC)(TypUpsVmSession *Session, enum EnuUpsCrbObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC, TypUpsVmShort Reallouer);
   /* Objet : Destructeur d'un objet C. */
TypUpsVmShort UpsVmAPI (*EcrireObjetC)(enum EnuUpsVmTypeDeDonnee TypeObjetUps, TypUpsVmPointeurDonnees ObjetUps, enum EnuUpsCrbObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC,
   TypUpsVmLong *TableDimensions, TypUpsVmShort NbDimensions);
   /* Objet : Ecriture d'un objet C. */
TypUpsVmPointeurDonnees UpsVmAPI (*EcrireValeurAny)(TypUpsCrbValeurAny Valeur);
   /* Objet : Ecrit la  valeur d'un objet Any. */
TypUpsVmVoid UpsVmAPI (*EnvoyerException)(TypUpsCrbString MessageErreur, TypUpsCrbLong CodeErreur, TypUpsCrbString NomException, TypUpsCrbString NomSourceEnErreur,
   TypUpsCrbLong NumeroLigne, TypUpsCrbLong NumeroColonne, TypUpsCrbString ModuleOrigine);
   /* Objet : Envoi une exception Ups Crb.  */
TypUpsVmShort UpsVmAPI (*EstUnObjetUpsVtm)(TypUpsVmPointeurDonnees pObjet, TypUpsVmUnicode *EstInstanceDe);
   /* Objet : Retourne Vrai s'il s'agit d'un objet Vtm encapsule. */
TypUpsVmShort (*EstUnTableau)(enum EnuUpsCrbObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC, TypUpsVmLong *TableDimensions, TypUpsVmShort NbDimensions, TypUpsVmShort *EstNul, 
   TypUpsVmUnsignedShort *BorneMin, TypUpsVmUnsignedShort *BorneMax, enum EnuUpsCrbObjetC *TypeObjetElementC, enum EnuUpsVmTypeDeDonnee *TypeObjetElementUps);
   /* Objet : Verifie si l'objet C est un tableau. */
TypUpsVmVoid UpsVmAPI (*ExporterObjetC)(TypUpsVmPointeurDonnees Session, enum EnuUpsCrbObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC);
   /* Objet : Exportation d'un objet C. */
TypUpsVmShort UpsVmAPI (*ExporterObjetValueBase)(TypUpsVmPointeurDonnees pObjet, TypUpsVmUnicode *NomFichier, TypUpsVmUnicode *MessageErreur);
   /* Objet : exporte un objet ValueBase dans un fichier. */
TypUpsVmPointeurDonnees UpsVmAPI (*ImporterObjetC)(TypUpsVmPointeurDonnees Session, enum EnuUpsCrbObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC);
   /* Objet : Importation d'un objet C. */
TypUpsVmPointeurDonnees UpsVmAPI (*ImporterObjetValueBase)(TypUpsVmUnicode *NomFichier, TypUpsVmUnicode *MessageErreur);
   /* Objet : importe un objet ValueBase dans un fichier. */
TypUpsVmShort UpsVmAPI (*Initialiser)(TypUpsVmPointeurDonnees *pOrb, TypUpsVmPointeurDonnees *pPoa, TypUpsVmShort argc, TypUpsVmChar **argv,
   TypUpsVmUnicode *MessageErreur, TypUpsCrbTracerServices TracerServices);
   /* Objet : Initialisation de l'Orb de Corba. */
TypUpsVmShort UpsVmAPI (*LireObjetC)(enum EnuUpsCrbObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC, TypUpsVmLong *TableDimensions, TypUpsVmShort NbDimensions,
   enum EnuUpsVmTypeDeDonnee *TypeObjetUps, TypUpsVmPointeurDonnees ObjetUps);
   /* Objet : Lecture d'un objet C. */
TypUpsVmPointeurDonnees UpsVmAPI (*LireTypeCodeInterface)(TypUpsVmPointeurDonnees pObjet, TypUpsVmUnicode *MessageErreur);
   /* Objet : Le TypeCode d'une interface. */
TypUpsVmPointeurDonnees UpsVmAPI (*LireTypeCodeValueBase)(TypUpsVmPointeurDonnees pObjet, TypUpsVmUnicode *MessageErreur);
   /* Objet : Le TypeCode d'un valuetype. */
TypUpsVmLong UpsVmAPI (*LireTailleContainedSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la taille d'un CORBA::Contained<>. */
TypUpsVmLong UpsVmAPI (*LireTailleExceptionDefSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la taille d'un CORBA::ExceptionDef<>. */
TypUpsVmLong UpsVmAPI (*LireTailleContextIdSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la taille d'un CORBA::ContextId<>. */
TypUpsVmLong UpsVmAPI (*LireTailleEnumMemberSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la taille d'un CORBA::EnumMember<>. */
TypUpsVmLong UpsVmAPI (*LireTailleInterfaceDefSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la taille d'un CORBA::InterfaceDef<>. */
TypUpsVmLong UpsVmAPI (*LireTailleOctetSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la taille d'un CORBA::Octet<>. */
TypUpsVmLong UpsVmAPI (*LireTailleValueDefSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la taille d'un CORBA::ValueDef<>. */
TypUpsVmShort UpsVmAPI (*LireValeurAny)(TypUpsVmPointeurDonnees pObjetAny, TypUpsCrbValeurAny Valeur);
   /* Objet : Lit la valeur d'un objet Any. */
TypUpsCrbChar UpsVmAPI *(*LireValeurCharSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la valeur d'un CORBA::Char<>. */
TypUpsVmPointeurDonnees UpsVmAPI *(*LireValeurContainedSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la valeur d'un CORBA::Contained<>. */
TypUpsCrbChar UpsVmAPI **(*LireValeurContextIdSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la valeur d'un CORBA::ContextId<>. */
TypUpsCrbChar UpsVmAPI **(*LireValeurEnumMemberSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la valeur d'un CORBA::EnumMember<>. */
TypUpsVmPointeurDonnees UpsVmAPI *(*LireValeurExceptionDefSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la valeur d'un CORBA::ExceptionDef<>. */
TypUpsVmPointeurDonnees UpsVmAPI *(*LireValeurInterfaceDefSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la valeur d'un CORBA::InterfaceDef<>. */
TypUpsCrbOctet UpsVmAPI *(*LireValeurOctetSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la valeur d'un CORBA::Octet<>. */
TypUpsCrbChar UpsVmAPI *(*LireValeurString)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la valeur d'un CORBA::String. */
TypUpsVmPointeurDonnees UpsVmAPI *(*LireValeurValueDefSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la valeur d'un CORBA::ValueDef<>. */
TypUpsCrbWCharT UpsVmAPI *(*LireValeurWCharTSequence)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la valeur d'un CORBA::WCharT<>. */
TypUpsCrbWCharT UpsVmAPI *(*LireValeurWString)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit la valeur d'un CORBA::WString. */
TypUpsVmPointeurDonnees UpsVmAPI (*NewCharSequence)(TypUpsCrbChar *Buffer, TypUpsVmLong Taille);
   /* Objet : Alloue une sequence de caracteres. */
TypUpsVmPointeurDonnees UpsVmAPI (*NewOctetSequence)(TypUpsCrbOctet *Buffer, TypUpsVmLong Taille);
   /* Objet : Alloue une sequence d'octets. */
TypUpsVmPointeurDonnees UpsVmAPI (*NewString)(TypUpsCrbChar *Buffer, TypUpsVmLong Taille);
   /* Objet : Alloue une chaine de caracteres. */
TypUpsVmPointeurDonnees UpsVmAPI (*NewWCharTSequence)(TypUpsCrbWCharT *Buffer, TypUpsVmLong Taille);
   /* Objet : Alloue une sequence de caracteres. */
TypUpsVmPointeurDonnees UpsVmAPI (*NewWString)(TypUpsCrbWCharT *Buffer, TypUpsVmLong Taille);
   /* Objet : Alloue une chaine de caracteres. */
TypUpsVmVoid UpsVmAPI (*SetTableMethodesRappel)(TypUpsCrbNatTableMethodesRappel TableMethodesRappel2);
   /* Objet : Memorise la table de methodes de rappel vers Ups Crb. */
TypUpsCrbString UpsVmAPI (*StringAlloc)(TypUpsVmSession *Session, TypUpsVmUnicode *LibelleAppel, TypUpsVmLong Taille);
   /* Objet : CORBA::string_alloc. */
TypUpsVmVoid UpsVmAPI (*StringFree)(TypUpsVmSession *Session, TypUpsCrbString Chaine);
   /* Objet : CORBA::string_free. */
TypUpsVmVoid UpsVmAPI (*Throw)(EnuUpsCrbCodeErreur CodeErreur);
   /* Objet : Envoi l'exception correspondant au code d'erreur. */
TypUpsCrbWString UpsVmAPI (*WStringAlloc)(TypUpsVmSession *Session, TypUpsVmUnicode *LibelleAppel, TypUpsVmLong Taille);
   /* Objet : CORBA::wstring_alloc. */
TypUpsVmVoid UpsVmAPI (*WStringFree)(TypUpsVmSession *Session, TypUpsCrbWString Chaine);
   /* Objet : CORBA::wstring_free. */
/*--------------------------------------------------------------*/
/* AliasDef.                        							       */
/*--------------------------------------------------------------*/
TypUpsVmPointeurDonnees UpsVmAPI (*AliasDefNarrow)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::AliasDef::name. */
TypUpsVmVoid UpsVmAPI (*AliasDefName)(TypUpsVmPointeurDonnees pObjetAliasDef, TypUpsVmUnicode *NomAlias);
   /* Objet : CORBA::AliasDef::name. */
TypUpsVmPointeurDonnees UpsVmAPI (*AliasDefOriginalTypeDef)(TypUpsVmPointeurDonnees pObjetAliasDef);
   /* Objet : CORBA::AliasDef::original_type_def. */
/*--------------------------------------------------------------*/
/* ArrayDef.                        							       */
/*--------------------------------------------------------------*/
TypUpsVmPointeurDonnees UpsVmAPI (*ArrayDefElementTypeDef)(TypUpsVmPointeurDonnees pObjetArrayDef);
   /* Objet : CORBA::ArrayDef::element_type_def. */
TypUpsVmLong UpsVmAPI (*ArrayDefLength)(TypUpsVmPointeurDonnees pObjetArrayDef);
   /* Objet : CORBA::ArrayDef::length. */
TypUpsVmPointeurDonnees UpsVmAPI (*ArrayDefNarrow)(TypUpsVmPointeurDonnees pObjetIdlType);
   /* Objet : CORBA::ArrayDef::narrow. */
/*--------------------------------------------------------------*/
/* AttributeDef.                     							       */
/*--------------------------------------------------------------*/
enum EnuUpsCrbAttributeMode UpsVmAPI (*AttributeDefMode)(TypUpsVmPointeurDonnees pObjetAttributeDef);
   /* Objet : CORBA::AttributeDef::mode. */
TypUpsVmVoid UpsVmAPI (*AttributeDefName)(TypUpsVmPointeurDonnees pObjetAttributeDef, TypUpsVmUnicode *NomAttribut);
   /* Objet : CORBA::AttributeDef::name. */
TypUpsVmPointeurDonnees UpsVmAPI (*AttributeDefNarrow)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::AttributeDef::narrow. */
TypUpsVmPointeurDonnees UpsVmAPI (*AttributeDefTypeDef)(TypUpsVmPointeurDonnees pObjetAttributeDef);
   /* Objet : CORBA::AttributeDef::type_def. */
/*--------------------------------------------------------------*/
/* ConstantDef.                      							       */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*ConstantDefName)(TypUpsVmPointeurDonnees pObjetConstantDef, TypUpsVmUnicode *NomConstante);
   /* Objet : CORBA::ConstantDef::name. */
TypUpsVmPointeurDonnees UpsVmAPI (*ConstantDefNarrow)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::ConstantDef::narrow. */
TypUpsVmPointeurDonnees UpsVmAPI (*ConstantDefTypeDef)(TypUpsVmPointeurDonnees pObjetConstantDef);
   /* Objet : CORBA::ConstantDef::type_def. */
TypUpsVmPointeurDonnees UpsVmAPI (*ConstantDefValue)(TypUpsVmPointeurDonnees pObjetConstantDef);
   /* Objet : CORBA::ConstantDef::value. */
/*--------------------------------------------------------------*/
/* Contained.                        							       */
/*--------------------------------------------------------------*/
enum EnuUpsCrbDefinitionKind UpsVmAPI (*ContainedDefKind)(TypUpsVmPointeurDonnees pObjetContained);
   /* Objet : CORBA::Contained::def_kind. */
TypUpsVmVoid UpsVmAPI (*ContainedDelete)(TypUpsVmPointeurDonnees pObjetContained);
   /* Objet : CORBA::Contained::delete. */
TypUpsVmVoid UpsVmAPI (*ContainedName)(TypUpsVmPointeurDonnees pObjetContained, TypUpsVmUnicode *NomType);
   /* Objet : CORBA::Contained::name. */
/*--------------------------------------------------------------*/
/* EnumDefs.                        							       */
/*--------------------------------------------------------------*/
TypUpsVmPointeurDonnees UpsVmAPI (*EnumDefMembers)(TypUpsVmPointeurDonnees pObjetEnumDef);
   /* Objet : CORBA::EnumDef::members. */
TypUpsVmVoid UpsVmAPI (*EnumDefName)(TypUpsVmPointeurDonnees pObjetEnumDef, TypUpsVmUnicode *NomEnumere);
   /* Objet : CORBA::EnumDef::name. */
TypUpsVmPointeurDonnees UpsVmAPI (*EnumDefNarrow)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::EnumDef::narrow. */
/*--------------------------------------------------------------*/
/* ExceptionDef.                     							       */
/*--------------------------------------------------------------*/
TypUpsCrbStructMember UpsVmAPI *(*ExceptionDefMembers)(TypUpsVmPointeurDonnees pObjetExceptionDef, TypUpsVmLong *TailleTableau);
   /* Objet : CORBA::ExceptionDef::members. */
TypUpsVmVoid UpsVmAPI (*ExceptionDefName)(TypUpsVmPointeurDonnees pObjetExceptionDef, TypUpsVmUnicode *NomException);
   /* Objet : CORBA::ExceptionDef::name. */
TypUpsVmPointeurDonnees UpsVmAPI (*ExceptionDefNarrow)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::ExceptionDef::narrow. */
/*--------------------------------------------------------------*/
/* Exception.                        							       */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*ExceptionDescriptionName)(TypUpsVmPointeurDonnees pException, TypUpsVmUnicode *MessageErreur);
   /* Objet : CORBA::Exception::description.name. */
/*--------------------------------------------------------------*/
/* IDLType.                         							       */
/*--------------------------------------------------------------*/
TypUpsVmPointeurDonnees UpsVmAPI (*IdlTypeType)(TypUpsVmPointeurDonnees pObjetIdlType);
   /* Objet : CORBA::IDLType::type. */
/*--------------------------------------------------------------*/
/* InterfaceDef.                     							       */
/*--------------------------------------------------------------*/
TypUpsVmPointeurDonnees UpsVmAPI (*InterfaceDefBaseInterfaces)(TypUpsVmPointeurDonnees pObjetInterfaceDef);
   /* Objet : CORBA::InterfaceDef::base_interfaces. */
TypUpsVmPointeurDonnees UpsVmAPI (*InterfaceDefContents)(TypUpsVmPointeurDonnees pObjetInterfaceDef);
   /* Objet : CORBA::InterfaceDef::contents. */
TypUpsVmPointeurDonnees UpsVmAPI (*InterfaceDefNarrow)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::InterfaceDef::narrow. */
TypUpsVmVoid UpsVmAPI (*InterfaceDefName)(TypUpsVmPointeurDonnees pObjetInterfaceDef, TypUpsVmUnicode *NomInterface);
   /* Objet : CORBA::InterfaceDef::name. */
/*--------------------------------------------------------------*/
/* ModuleDef.                        							       */
/*--------------------------------------------------------------*/
TypUpsVmPointeurDonnees UpsVmAPI (*ModuleDefContents)(TypUpsVmPointeurDonnees pObjetModuleDef);
   /* Objet : CORBA::ModuleDef::contents. */
TypUpsVmVoid UpsVmAPI (*ModuleDefName)(TypUpsVmPointeurDonnees pObjetModuleDef, TypUpsVmUnicode *NomModule);
   /* Objet : CORBA::ModuleDef::name. */
TypUpsVmPointeurDonnees UpsVmAPI (*ModuleDefNarrow)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::ModuleDef::narrow. */
/*--------------------------------------------------------------*/
/* NativeDef.                        							       */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*NativeDefName)(TypUpsVmPointeurDonnees pObjetNativeDef, TypUpsVmUnicode *NomTypeNatif);
   /* Objet : CORBA::NativeDef::name. */
TypUpsVmPointeurDonnees UpsVmAPI (*NativeDefNarrow)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::NativeDef::narrow. */
/*--------------------------------------------------------------*/
/* OAD.                             							       */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*OadRegImplementation)(TypUpsVmUnicode *ApplicationName, TypUpsVmUnicode *RepositoryId, TypUpsVmUnicode *InprocServer, 
   TypUpsVmUnicode *LocalServer, enum EnuUpsCrbImplRepository *CodeErreur);
   /* Objet : Activation::OAD::reg_implementation. */
TypUpsVmShort UpsVmAPI (*OadUnregImplementation)(TypUpsVmUnicode *ApplicationName, TypUpsVmUnicode *RepositoryId, enum EnuUpsCrbImplRepository *CodeErreur);
   /* Objet : Activation::OAD::unreg_implementation. */
/*--------------------------------------------------------------*/
/* Object.                          							       */
/*--------------------------------------------------------------*/
TypUpsVmPointeurDonnees UpsVmAPI (*ObjectClone)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::Object::clone. */
TypUpsVmVoid UpsVmAPI (*ObjectDuplicate)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::Object::duplicate. */
TypUpsCrbBoolean UpsVmAPI (*ObjectIsA)(TypUpsVmPointeurDonnees pObjet, TypUpsVmPointeurDonnees pObjetType);
   /* Objet : CORBA::Object::is_a. */
TypUpsCrbBoolean UpsVmAPI (*ObjectIsBound)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::Object::is_bound. */
TypUpsCrbBoolean UpsVmAPI (*ObjectIsEquivalent)(TypUpsVmPointeurDonnees pObjet1, TypUpsVmPointeurDonnees pObjet2);
   /* Objet : CORBA::Object::is _equivalent. */
TypUpsCrbBoolean (*ObjectIsPersistent)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::Object::is_persistent. */
TypUpsVmVoid UpsVmAPI (*ObjectRelease)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::Object::release. */
TypUpsVmShort UpsVmAPI (*ObjectRepOId)(TypUpsVmPointeurDonnees pObjet, TypUpsVmUnicode *Identifiant);
   /* Objet : CORBA::Object::repoid. */
/*--------------------------------------------------------------*/
/* OperationDef.                      							       */
/*--------------------------------------------------------------*/
TypUpsVmPointeurDonnees UpsVmAPI (*OperationDefContexts)(TypUpsVmPointeurDonnees pObjetOperationDef);
   /* Objet : CORBA::OperationDef::contexts. */
TypUpsVmPointeurDonnees UpsVmAPI (*OperationDefExceptions)(TypUpsVmPointeurDonnees pObjetOperationDef);
   /* Objet : CORBA::OperationDef::exceptions. */
enum EnuUpsCrbOperationMode UpsVmAPI (*OperationDefMode)(TypUpsVmPointeurDonnees pObjetOperationDef);
   /* Objet : CORBA::OperationDef::mode. */
TypUpsVmVoid UpsVmAPI (*OperationDefName)(TypUpsVmPointeurDonnees pObjetOperationDef, TypUpsVmUnicode *NomMethode);
   /* Objet : CORBA::OperationDef::name. */
TypUpsVmPointeurDonnees UpsVmAPI (*OperationDefNarrow)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::OperationDef::narrow. */
TypUpsCrbParameterDescription UpsVmAPI *(*OperationDefParams)(TypUpsVmPointeurDonnees pObjetOperationDef, TypUpsVmLong *TailleTableau);
   /* Objet : CORBA::OperationDef::params. */
TypUpsVmPointeurDonnees UpsVmAPI (*OperationDefResultDef)(TypUpsVmPointeurDonnees pObjetOperationDef);
   /* Objet : CORBA::OperationDef::result_def. */
/*--------------------------------------------------------------*/
/* Orb.                             							       */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*OrbBind)(TypUpsVmPointeurDonnees pOrb, TypUpsVmUnicode *RepositoryId, TypUpsVmPointeurDonnees *pObjet);
   /* Objet : CORBA::ORB::bind. */
TypUpsCrbChar UpsVmAPI *(*OrbObjectToString)(TypUpsVmPointeurDonnees pOrb, TypUpsVmPointeurDonnees pObject, TypUpsVmUnicode *MessageErreur);
   /* Objet : CORBA::Orb::object_to_string. */
TypUpsVmShort UpsVmAPI (*OrbRun)(TypUpsVmPointeurDonnees pOrb, TypUpsVmPointeurDonnees pPoa);
   /* Objet : PortableServer::POA::deactivate_object. */
TypUpsVmPointeurDonnees UpsVmAPI (*OrbStringToObject)(TypUpsVmPointeurDonnees pOrb, TypUpsCrbChar *ChaineSerialisation, TypUpsVmUnicode *MessageErreur);
   /* Objet : CORBA::Orb::string_to_object. */
TypUpsVmVoid UpsVmAPI (*OrbShutdown)(TypUpsVmPointeurDonnees pOrb, TypUpsVmPointeurDonnees pPoa);
   /* Objet : CORBA::Orb::shutdown. */
/*--------------------------------------------------------------*/
/* ParameterDescription.              							       */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*ParameterDescriptionDelete)(TypUpsCrbParameterDescription *Tableau);
   /* Objet : Detruit un tableau de ParameterDescription. */
/*--------------------------------------------------------------*/
/* POA.                             							       */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*PoaActivateObject)(TypUpsVmPointeurDonnees pPoa, TypUpsVmPointeurDonnees pObjet);
   /* Objet : PortableServer::POA::activate_object. */
TypUpsVmVoid UpsVmAPI (*PoaDeactivateObject)(TypUpsVmPointeurDonnees pPoa, TypUpsVmPointeurDonnees pObjet);
   /* Objet : PortableServer::POA::deactivate_object. */
/*--------------------------------------------------------------*/
/* Repository.                       							       */
/*--------------------------------------------------------------*/
TypUpsVmPointeurDonnees UpsVmAPI (*RepositoryBind)(TypUpsVmUnicode *MessageErreur);
   /* Objet : CORBA::Repository::bind. */
TypUpsVmVoid UpsVmAPI (*RepositoryDelete)(TypUpsVmPointeurDonnees pObjetRepository);
   /* Objet : CORBA::Repository::delete. */
TypUpsVmPointeurDonnees UpsVmAPI (*RepositoryLookupName)(TypUpsVmPointeurDonnees pObjetRepository, TypUpsVmUnicode *NomInterface);
   /* Objet : CORBA::Repository::lookup_name. */
/*--------------------------------------------------------------*/
/* Request.                         							       */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*RequestInvoke)(TypUpsVmPointeurDonnees pObjet, TypUpsVmUnicode *NomMethode, TypUpsCrbAny *TableParametresAny, 
   TypUpsVmShort NbParametres, enum EnuCrbTypeCorba TypeCorbaResultat, TypUpsCrbAny *ResultatAny, TypUpsVmUnicode *MessageErreur);
   /* Objet : CORBA::Request::invoke. */
/*--------------------------------------------------------------*/
/* Sequence.                        							       */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*SequenceDelete)(TypUpsVmPointeurDonnees pSequence);
   /* Objet : CORBA::Sequence::delete. */
TypUpsVmLong UpsVmAPI (*SequenceLength)(TypUpsVmPointeurDonnees Sequence, enum EnuCrbTypeCorba TypeCorba);
   /* Objet : CORBA::Sequence::length. */
TypUpsVmVoid UpsVmAPI (*SequenceGet)(TypUpsVmPointeurDonnees Sequence, enum EnuCrbTypeCorba TypeCorba, TypUpsVmLong Indice, TypUpsCrbAny *Valeur);
   /* Objet : CORBA::Sequence::[]. */
TypUpsVmPointeurDonnees UpsVmAPI (*SequenceNew)(enum EnuCrbTypeCorba TypeCorba, TypUpsVmLong Taille);
   /* Objet : CORBA::Sequence::new. */
TypUpsVmVoid UpsVmAPI (*SequencePut)(TypUpsVmPointeurDonnees Sequence, enum EnuCrbTypeCorba TypeCorba, TypUpsVmLong Indice, TypUpsCrbAny *Valeur);
   /* Objet : CORBA::Sequence::[]. */
/*--------------------------------------------------------------*/
/* StructDef.                        							       */
/*--------------------------------------------------------------*/
TypUpsCrbStructMember UpsVmAPI *(*StructDefMembers)(TypUpsVmPointeurDonnees pObjetStructDef, TypUpsVmLong *TailleTableau);
   /* Objet : CORBA::StructDef::members. */
TypUpsVmVoid UpsVmAPI (*StructDefName)(TypUpsVmPointeurDonnees pObjetStructDef, TypUpsVmUnicode *NomType);
   /* Objet : CORBA::StructDef::name. */
TypUpsVmPointeurDonnees UpsVmAPI (*StructDefNarrow)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::StructDef::narrow. */
/*--------------------------------------------------------------*/
/* StructMember.                      							       */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*StructMemberDelete)(TypUpsCrbStructMember *Tableau);
   /* Objet : Detruit un tableau de StructMember. */
/*--------------------------------------------------------------*/
/* TypeCode.                        							       */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*TypeCodeContentType)(TypUpsVmPointeurDonnees pObjetType, TypUpsVmUnicode *NomContenu);
   /* Objet : CORBA::TypeCode::content_type. */
TypUpsVmLong UpsVmAPI (*TypeCodeDefaultIndex)(TypUpsVmPointeurDonnees pObjetType);
   /* Objet : CORBA::TypeCode::default_index. */
TypUpsVmVoid UpsVmAPI (*TypeCodeDelete)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::TypeCode::delete. */
TypUpsVmShort UpsVmAPI (*TypeCodeFixedDigits)(TypUpsVmPointeurDonnees pObjetType);
   /* Objet : CORBA::TypeCode::fixed_digits. */
TypUpsCrbBoolean UpsVmAPI (*TypeCodeIsA)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::TypeCode::is_a. */
TypUpsVmShort UpsVmAPI (*TypeCodeFixedScale)(TypUpsVmPointeurDonnees pObjetType);
   /* Objet : CORBA::TypeCode::fixed_scale. */
enum EnuCrbTypeCorba UpsVmAPI (*TypeCodeKind)(TypUpsVmPointeurDonnees pObjetType);
   /* Objet : CORBA::TypeCode::kind. */
TypUpsVmLong UpsVmAPI (*TypeCodeLength)(TypUpsVmPointeurDonnees pObjetType);
   /* Objet : CORBA::TypeCode::length. */
TypUpsVmVoid UpsVmAPI (*TypeCodeName)(TypUpsVmPointeurDonnees pObjetType, TypUpsVmUnicode *NomType);
   /* Objet : CORBA::TypeCode::name. */
TypUpsVmPointeurDonnees UpsVmAPI (*TypeCodeNew)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::TypeCode::new. */
/*--------------------------------------------------------------*/
/* UnionDef.                        							       */
/*--------------------------------------------------------------*/
TypUpsVmPointeurDonnees UpsVmAPI (*UnionDefDiscriminatorType)(TypUpsVmPointeurDonnees pObjetUnionDef);
   /* Objet : CORBA::UnionDef::discriminator_type. */
TypUpsVmPointeurDonnees UpsVmAPI (*UnionDefDiscriminatorTypeDef)(TypUpsVmPointeurDonnees pObjetUnionDef);
   /* Objet : CORBA::UnionDef::discriminator_type_def. */
TypUpsCrbUnionMember UpsVmAPI *(*UnionDefMembers)(TypUpsVmPointeurDonnees pObjetUnionDef, TypUpsVmLong *TailleTableau);
   /* Objet : CORBA::UnionDef::members. */
TypUpsVmVoid UpsVmAPI (*UnionDefName)(TypUpsVmPointeurDonnees pObjetUnionDef, TypUpsVmUnicode *NomUnion);
   /* Objet : CORBA::UnionDef::name. */
TypUpsVmPointeurDonnees UpsVmAPI (*UnionDefNarrow)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::UnionDef::narrow. */
/*--------------------------------------------------------------*/
/* UnionMember.                       							       */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*UnionMemberDelete)(TypUpsCrbUnionMember *Tableau);
   /* Objet : Detruit un tableau de UnionMember. */
/*--------------------------------------------------------------*/
/* ValueBase.                        							       */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*ValueBaseAddRef)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::ValueBase::add_ref. */
TypUpsVmPointeurDonnees UpsVmAPI (*ValueBaseCopyValue)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::ValueBase::copy_value. */
TypUpsVmShort UpsVmAPI (*ValueBaseId)(TypUpsVmPointeurDonnees pObjet, TypUpsVmUnicode *Identifiant);
   /* Objet : CORBA::ValueBase::id. */
TypUpsCrbBoolean UpsVmAPI (*ValueBaseIsA)(TypUpsVmPointeurDonnees pObjet, TypUpsVmPointeurDonnees pObjetType);
   /* Objet : CORBA::ValueBase::is_a. */
TypUpsVmVoid UpsVmAPI (*ValueBaseRemoveRef)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::ValueBase::remove_ref. */
/*--------------------------------------------------------------*/
/* ValueBoxDef.                       							       */
/*--------------------------------------------------------------*/
TypUpsVmPointeurDonnees UpsVmAPI (*ValueBoxDefOriginalTypeDef)(TypUpsVmPointeurDonnees pObjetValueBoxDef);
   /* Objet : CORBA::ValueBoxDef::original_type_def. */
TypUpsVmVoid UpsVmAPI (*ValueBoxDefName)(TypUpsVmPointeurDonnees pObjetValueBoxDef, TypUpsVmUnicode *NomType);
   /* Objet : CORBA::ValueBoxDef::name. */
TypUpsVmPointeurDonnees UpsVmAPI (*ValueBoxDefNarrow)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::ValueBoxDef::narrow. */
/*--------------------------------------------------------------*/
/* ValueDef.                        							       */
/*--------------------------------------------------------------*/
TypUpsVmPointeurDonnees UpsVmAPI (*ValueDefAbstractBaseValues)(TypUpsVmPointeurDonnees pObjetValueDef);
   /* Objet : CORBA::ValueDef::abstract_base_values. */
TypUpsVmPointeurDonnees UpsVmAPI (*ValueDefBaseValue)(TypUpsVmPointeurDonnees pObjetValueDef);
   /* Objet : CORBA::ValueDef::base_value. */
TypUpsVmPointeurDonnees UpsVmAPI (*ValueDefContents)(TypUpsVmPointeurDonnees pObjetValueDef);
   /* Objet : CORBA::ValueDef::contents. */
TypUpsCrbBoolean UpsVmAPI (*ValueDefIsAbstract)(TypUpsVmPointeurDonnees pObjetValueDef);
   /* Objet : CORBA::ValueDef::is_abstract. */
TypUpsCrbBoolean UpsVmAPI (*ValueDefIsCustom)(TypUpsVmPointeurDonnees pObjetValueDef);
   /* Objet : CORBA::ValueDef::is_custom. */
TypUpsCrbBoolean UpsVmAPI (*ValueDefIsTruncatable)(TypUpsVmPointeurDonnees pObjetValueDef);
   /* Objet : CORBA::ValueDef::is_trucatable. */
TypUpsVmVoid UpsVmAPI (*ValueDefName)(TypUpsVmPointeurDonnees pObjetValueDef, TypUpsVmUnicode *NomType);
   /* Objet : CORBA::ValueDef::name. */
TypUpsVmPointeurDonnees UpsVmAPI (*ValueDefNarrow)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : CORBA::ValueDef::narrow. */
TypUpsVmPointeurDonnees UpsVmAPI (*ValueDefSupportedInterfaces)(TypUpsVmPointeurDonnees pObjetValueDef);
   /* Objet : CORBA::ValueDef::supported_interfaces. */
} *TypUpsCrbMachineInterface_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsCrbMachineInterface_1_1_0 TypUpsCrbMachineInterface;

/****************************************************************/
typedef struct typupscrbinterfaceimplementee
/* Objet : Implementation generique d'une interface Corba.      */
/****************************************************************/
{
enum EnuUpsCrbObjetCorba Sorte;
   /* Sorte de l'objet natif. */
union
   {
   TypUpsVmPointeurDonnees ObjetInterface;
      /* Cas OC_ObjetInterface. */
   TypUpsVmPointeurDonnees ObjetValueBase;
      /* Cas OC_ObjetValueBase. */
   TypUpsVmPointeurDonnees ObjetTypeCode;
      /* Cas OC_ObjetTypeCode. */
   TypUpsVmPointeurDonnees ObjetC;
      /* Cas OC_ObjetC. */
   } Selection;
   /* Selection en fonction de la sorte. */
} TypUpsCrbInterfaceImplementee;

typedef TypUpsVmPointeurDonnees (*TypUpsCrbMethodeNew)(TypUpsVmSession *Session);
typedef TypUpsVmPointeurDonnees (*TypUpsCrbCreerUnObjet)(TypUpsVmAdresse *AdresseObjet);

/****************************************************************/
typedef struct upstrttypupscrb_1_1_1_0
/* Objet : Methodes du type TypeCode.                           */
/****************************************************************/
{
TypUpsVmEnteteMethodes EnteteMethodes;
   /* Entete des methodes. */
} UpsTrtTypUpsCrb_1_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef UpsTrtTypUpsCrb_1_1_1_0 UpsTrtTypUpsCrb_1;

/****************************************************************/
typedef struct typupscrbdonnees
/* Objet: Interface des donnees de Ups Crb.                     */
/****************************************************************/
{
struct typupsvmentetedonneesmodule EnteteDonneesModule;
   /* Entete generique du module. */
TypUpsVmLong NbObjetsCrees;
   /* Nombre d'objets de crees. */
TypUpsVmShort TraceCorba;
   /* Si Vrai, il faut tracer Ups Crb. */
TypUpsVmPointeurDonnees Orb;
   /* Pointeur sur l'Object Request Broker. */
TypUpsVmPointeurDonnees Poa;
   /* Pointeur sur le Portable Object Adaptor. */
TypUpsVmShort EstDisponible;
   /* Si Vrai, les services Corba sont disponibles. */
/*--------------------------------------------------------------*/
/* Methodes de rappel vers UpsKrnSC.                            */
/*--------------------------------------------------------------*/
TypUpsVmPointeurDonnees UpsVmAPI (*CreerUnObjet)(TypUpsVmPointeurDonnees pObjetType, TypUpsVmAdresse *AdresseObjet);
   /* Cree un nouvel objet. Renseigne par UpsKrnSC. */
TypUpsVmAdresse UpsVmAPI *(*LireAdresseObjetUps)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit l'adresse Ups de l'objet. Renseigne par UpsKrnSC. */
TypUpsVmPointeurDonnees UpsVmAPI (*LireObjetCorba)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit l'objet Corba de l'objet Ups. Renseigne par UpsKrnSC. */
TypUpsVmPointeurDonnees UpsVmAPI (*LireObjetInterface)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit l'objet Interface de l'objet Ups. Renseigne par UpsKrnSC. */
TypUpsVmPointeurDonnees UpsVmAPI (*LireServantUpsObjet)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit le servant Ups de l'objet. Renseigne par UpsKrnSC. */
TypUpsVmPointeurDonnees UpsVmAPI (*LireServantUpsClasse)(TypUpsVmPointeurDonnees pClasse);
   /* Objet : Lit le servant Ups de la classe. Renseigne par UpsKrnSC. */
TypUpsVmPointeurDonnees UpsVmAPI (*LireObjetUps)(TypUpsVmPointeurDonnees pObjet);
   /* Objet : Lit l'objet Ups de l'objet. Renseigne par UpsKrnSC. */
TypUpsVmPointeurDonnees UpsVmAPI (*New)(TypUpsVmSession *Session, TypUpsCrbMethodeNew MethodeNew, TypUpsVmUnicode *MessageErreur); 
   /* Objet : Cree un nouvel objet. Renseigne par UpsKrnSC. */
TypUpsVmPointeurDonnees UpsType7;
   /* Type Objet. Renseigne par UpsKrnSC. */
} *TypUpsCrbDonnees;

/****************************************************************/
typedef struct typprmupscrb_1_1
/* Objet : Parametre de EnregistrerComposantCorba(RepositoryId: */
/* Caractere, AccesServeur:Caractere);                          */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* RepositoryId:Caractere. */
TypUpsVmAdresse UpsVar2;
   /* AccesServeur:Caractere. */
} TypPrmUpsCrb_1_1;

/****************************************************************/
typedef struct typprmupscrb_2_1
/* Objet : Parametre de SupprimerComposantCorba(RepositoryId:   */
/* Caratere, AccesServeur:Caractere);                           */
/****************************************************************/
{
TypUpsVmAdresse UpsVar1;
   /* RepositoryId:Caractere. */
TypUpsVmAdresse UpsVar2;
   /* AccesServeur:Caractere. */
} TypPrmUpsCrb_2_1;

/****************************************************************/
typedef struct typupscrbtraitements_1_1_0
/* Objet: Interface des traitements de Ups Crb.                 */
/****************************************************************/
{
struct typupsvmentetemethodesmodule EnteteMethodesModule;
   /* Methodes generiques au module. */ 

/*--------------------------------------------------------------*/
/* Procedures et fonctions.                                     */
/*--------------------------------------------------------------*/
TypUpsVmLong UpsVmAPI (*CalculerIndexAppel)(TypUpsVmPointeurDonnees InterfaceAppel, TypUpsVmPointeurDonnees AppelCourant);
   /* Objet : Calcule l'index de l'appel. */
TypUpsVmVoid UpsVmAPI (*Trt_1_1)(TypUpsVmSession *Session, TypPrmUpsCrb_1_1 *UpsPrm);
   /* Objet : EnregistrerComposantCorba. */
TypUpsVmVoid UpsVmAPI (*Trt_2_1)(TypUpsVmSession *Session, TypPrmUpsCrb_2_1 *UpsPrm);
   /* Objet : SupprimerComposantCorba. */

TypUpsVmCoAppel CoTrt_1_1;
   /* Objet : EnregistrerComposantCorba. */
TypUpsVmCoAppel CoTrt_2_1;
   /* Objet : SupprimerComposantCorba. */

/*--------------------------------------------------------------*/
/* Tables des methodes.                                         */
/*--------------------------------------------------------------*/
UpsTrtTypUpsCrb_1 *UpsTrt1;
   /* Methodes de TypeCode. */ 

/*--------------------------------------------------------------*/
/* Enumeres.			              				                   */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Entrepots.          								                   */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Types et interfaces.                                         */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*UpsType1_get)(TypUpsVmSession *Session);
   /* TypeCode. */
TypUpsVmLong UpsVmAPI (*UpsIndex1_get)(TypUpsVmSession *Session, TypUpsVmShort Numero);
   /* Type TypeCode. */

/*--------------------------------------------------------------*/
/* Variables globales.                                          */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Exceptions.                                                  */
/*--------------------------------------------------------------*/
TypUpsVmAdresse UpsVmAPI *(*UpsException1_get)(TypUpsVmSession *Session);
   /* CreationObjetCorbaImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException2_get)(TypUpsVmSession *Session);
   /* ConversionCorbaImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException3_get)(TypUpsVmSession *Session);
   /* ExecutionCorbaImpossible. */
TypUpsVmAdresse UpsVmAPI *(*UpsException4_get)(TypUpsVmSession *Session);
   /* EnregistrementComposantCorba. */

/*--------------------------------------------------------------*/
/* Files d'attente.                                             */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* Application Program Interfaces proprietaires.                */
/*--------------------------------------------------------------*/
TypUpsCrbMachineInterface UpsVmAPI (*LireMachineInterface)(TypUpsVmVoid);
   /* Objet : Lit l'interface avec la machine pour Ups Crb. */
TypUpsVmVoid UpsVmAPI (*ExposerClasse)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees This);
   /* Objet : Expose un classe. */
TypUpsVmVoid UpsVmAPI (*ExposerObjet)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees This);
   /* Objet : Expose un objet. */
TypUpsVmVoid UpsVmAPI (*NePlusExposerClasse)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees This);
   /* Objet : N'expose plus un constructeur de classe. */
TypUpsVmVoid UpsVmAPI (*NePlusExposerObjet)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees This);
   /* Objet : N'expose plus un objet. */
TypUpsVmVoid UpsVmAPI (*TracerCorba)(TypUpsVmSession *Session, TypUpsVmUnicode *Filtre, TypUpsVmPointeurDonnees P1, TypUpsVmPointeurDonnees P2, TypUpsVmPointeurDonnees P3, 
   TypUpsVmPointeurDonnees P4, TypUpsVmPointeurDonnees P5, TypUpsVmPointeurDonnees P6);
   /* Objet : Trace une action de Ups Corba. */
TypUpsVmVoid UpsVmAPI (*TracerCodeErreur)(TypUpsVmSession *Session, enum EnuUpsCrbCodeErreur CodeErreur);
   /* Objet : Trace un code d'erreur. */
TypUpsVmShort UpsVmAPI (*BaseDeRegistres)(TypUpsVmSession *Session, TypUpsVmUnicode *NomModule, TypUpsVmShort Charger);
   /* Objet : Charge ou decharge la reference des classes dans la base de registres. */
TypUpsVmVoid UpsVmAPI (*EnvoyerErreurInfo)(TypUpsVmSession *Session, enum EnuUpsCrbCodeErreur CodeErreurCorba);
   /* Objet : Envoie ErreurInfo suite a une exception. */
TypUpsVmShort UpsVmAPI (*ConstruireObjet)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees *AdresseResultat,
   TypUpsVmAdresse *AdresseObjet, TypUpsVmPointeurDonnees ObjetType);
   /* Objet : Construit un objet. */
TypUpsVmVoid UpsVmAPI (*DetruireObjet)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees O);
   /* Objet : Destructeur d'un objet. */
TypUpsVmVoid UpsVmAPI (*ExtraireAdresseObjet)(TypUpsVmAdresse *AdresseObjet, TypUpsVmPointeurDonnees Objet);
   /* Objet : Extrait l'adresse Ups de l'objet. */
TypUpsVmVoid UpsVmAPI (*MiseAJourAdresseObjet)(TypUpsVmPointeurDonnees Objet, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Mise a jour de l'adresse Ups de l'objet. */
TypUpsCrbOctet UpsVmAPI *(*Binaire2Octet)(TypUpsVmSession *Session, TypUpsCrbOctet *Buffer, TypUpsVmLong Taille, 
   TypUpsVmAdresse *AdresseObjet);
   /* Objet : Lit un objet de type Binaire en un objet de type CORBA::Octet *. */
TypUpsVmPointeurDonnees UpsVmAPI (*Binaire2SequenceDOctets)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Lit un objet de type Binaire en un objet de type CORBA::Octet<>. */
TypUpsCrbChar UpsVmAPI *(*Binaire2Char)(TypUpsVmSession *Session, TypUpsCrbChar *Buffer, TypUpsVmLong Taille, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Lit un objet de type Binaire en un objet de type CORBA::Char *. */
TypUpsCrbChar UpsVmAPI *(*Caractere2Char)(TypUpsVmSession *Session, TypUpsVmChar *Buffer, TypUpsVmLong TailleBuffer, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Lit un objet de type Caractere en un objet de type CORBA::Char *. */
TypUpsVmPointeurDonnees UpsVmAPI (*Caractere2SequenceDeChars)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Lit un objet de type Caractere en un objet de type CORBA::Char<>. */
TypUpsCrbWCharT UpsVmAPI *(*Caractere2WCharT)(TypUpsVmSession *Session, TypUpsCrbWCharT *Buffer, TypUpsVmLong TailleBuffer, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Lit un objet de type Caractere en un objet de type CORBA::WCharT *. */
TypUpsVmPointeurDonnees UpsVmAPI (*Caractere2SequenceDeWCharTs)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Lit un objet de type Caractere en un objet de type CORBA::WCharT<>. */
TypUpsCrbWCharT UpsVmAPI *(*Date2WCharT)(TypUpsVmSession *Session, TypUpsCrbWCharT *Buffer, TypUpsVmLong TailleBuffer, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Lit un objet de type Date en un objet de type CORBA::WChar *. */
TypUpsVmAdresse UpsVmAPI *(*Octet2Binaire)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsCrbOctet *Buffer);
   /* Objet : Lit un objet de type CORBA::Octet * en un objet de type Binaire. */
TypUpsVmAdresse UpsVmAPI *(*SequenceDOctets2Binaire)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmPointeurDonnees Buffer);
   /* Objet : Lit un objet de type CORBA::Octet< > en un objet de type Binaire. */
TypUpsVmAdresse UpsVmAPI *(*Char2Binaire)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsCrbChar *Buffer);
   /* Objet : Lit un objet de type CORBA::Char * en un objet de type Binaire. */
TypUpsVmAdresse UpsVmAPI *(*Char2Caractere)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsCrbChar *Buffer);
   /* Objet : Lit un objet de type CORBA::Char * en un objet de type Caractere. */
TypUpsVmAdresse UpsVmAPI *(*SequenceDeChars2Caractere)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmPointeurDonnees Buffer);
   /* Objet : Lit un objet de type CORBA::Char<> en un objet de type Caractere. */
TypUpsVmAdresse UpsVmAPI *(*WCharT2Caractere)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsCrbWCharT *Buffer);
   /* Objet : Lit un objet de type CORBA::WCharT en un objet de type Caractere. */
TypUpsVmAdresse UpsVmAPI *(*SequenceDeWCharTs2Caractere)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsVmPointeurDonnees Buffer);
   /* Objet : Lit un objet de type CORBA::WCharT<> en un objet de type Caractere. */
TypUpsVmAdresse UpsVmAPI *(*Char2Date)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, TypUpsCrbChar *Buffer);
   /* Objet : Lit un objet de type CORBA::Char en un objet de type Date. */
TypUpsVmUnicode UpsVmAPI *(*CalculerNomObjet)(TypUpsVmSession *Session, TypUpsVmUnicode *NomObjet, TypUpsVmLong TailleNomObjet, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Calcule le nom de l'objet. */
TypUpsVmVoid (*UtiliserObjetInterface)(TypUpsVmPointeurDonnees This);
   /* Objet : Utilise l'objet issu d'une interface. */
TypUpsVmVoid (*NePlusUtiliserObjetInterface)(TypUpsVmPointeurDonnees This);
   /* Objet : N'utilise plus l'objet issu d'une interface. */
TypUpsVmVoid (*UtiliserObjetValueBase)(TypUpsVmPointeurDonnees This);
   /* Objet : Utilise l'objet issu d'un ValueBase. */
TypUpsVmVoid (*NePlusUtiliserObjetValueBase)(TypUpsVmPointeurDonnees This);
   /* Objet : N'utilise plus l'objet issu d'un ValueBase. */
TypUpsVmShort UpsVmAPI (*CreerObjetAppelDirect)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmUnicode *Prototype, TypUpsVmPointeurTraitements Appel);
   /* Objet : Cree un objet appel. */
TypUpsVmShort UpsVmAPI (*CreerObjetAppelInterface)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmUnicode *RepositoryId, TypUpsVmUnicode *Prototype, TypUpsVmPointeurDonnees pObjet);
   /* Objet : Cree un objet appel. */
TypUpsVmPointeurDonnees UpsVmAPI (*ExtraireObjetInterface)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Extrait l'implementation d'un objet issu d'une interface. */
TypUpsVmPointeurDonnees UpsVmAPI (*ExtraireObjetValueBase)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Extrait l'implementation d'un objet issu d'un CORBA::ValueBase. */
TypUpsVmPointeurDonnees UpsVmAPI (*ExtraireObjetTypeCode)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Extrait l'implementation d'un objet issu de CORBA::TypeCode. */
TypUpsVmPointeurDonnees UpsVmAPI (*ExtraireObjetC)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Extrait l'implementation d'un objet issu d'une structure C. */
TypUpsVmAdresse UpsVmAPI *(*CreerObjetInterface)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmAdresse *AdresseObjetType, TypUpsCrbMethodeNew MethodeNew, TypUpsVmPointeurDonnees *Objet);
   /* Objet : Cree un objet issu d'une interface. */
TypUpsVmAdresse UpsVmAPI *(*CreerObjetValueBase)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmAdresse *AdresseObjetType, TypUpsVmUnicode *NomBibliotheque, TypUpsVmUnicode *LibelleConstructeur, TypUpsVmPointeurDonnees *Objet);
   /* Objet : Cree un objet issu d'un valuetype. */
TypUpsVmAdresse UpsVmAPI *(*CreerObjetC)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmAdresse *AdresseObjetType, TypUpsVmPointeurDonnees ObjetC);
   /* Objet : Cree un objet d'une structure. */
TypUpsVmVoid UpsVmAPI (*MiseAJourObjetC)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet, TypUpsVmPointeurDonnees ObjetC);
   /* Objet : Mise a jour de l'implementation d'un objet C. */
TypUpsVmVoid UpsVmAPI (*DetruireObjetInterface)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Detruit un objet issu d'une interface. */
TypUpsVmVoid UpsVmAPI (*DetruireObjetValueBase)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Detruit un objet issu d'une value base. */
TypUpsVmVoid UpsVmAPI (*ClonerObjetInterface)(TypUpsVmSession *Session,
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypUpsVmAdresse *AdresseObjetType);
   /* Objet : Cree un objet issu d'une interface. */
TypUpsVmVoid UpsVmAPI (*ClonerObjetValueBase)(TypUpsVmSession *Session,
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet, TypUpsVmAdresse *AdresseObjetType);
   /* Objet : Cree un objet issu d'un CORBA::ValueType. */
TypUpsVmVoid UpsVmAPI (*ClonerObjetTypeCode)(TypUpsVmSession *Session,
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjet);
TypUpsVmVoid UpsVmAPI (*ClonerObjetC)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmAdresse *AdresseObjetType, TypUpsVmPointeurDonnees ObjetC);
   /* Objet : Clone un objet issu d'une structure. */
TypUpsVmAdresse UpsVmAPI *(*ObjetInterface2Objet)(TypUpsVmSession *Session,
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjetType, TypUpsVmPointeurDonnees ObjetCorba, TypUpsVmPointeurDonnees ObjetUps);
   /* Objet : Cree un objet d'un objet issu d'une interface. */
TypUpsVmAdresse UpsVmAPI *(*ObjetValueBase2Objet)(TypUpsVmSession *Session,
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjetType, TypUpsVmPointeurDonnees ObjetCorba);
   /* Objet : Cree un objet d'un objet issu d'un CORBA::ValueType. */
TypUpsVmAdresse UpsVmAPI *(*ObjetTypeCode2Objet)(TypUpsVmSession *Session,
   TypUpsVmAdresse *AdresseResultat, TypUpsVmPointeurDonnees Objet);
   /* Objet : Cree un objet d'un objet issu de CORBA::TypeCode. */
TypUpsVmAdresse UpsVmAPI *(*ObjetC2Objet)(TypUpsVmSession *Session,
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjetType, TypUpsVmVoid *Objet);
   /* Objet : Cree un objet d'un objet issu d'une structure. */
TypUpsVmAdresse UpsVmAPI *(*Any2Objet)(TypUpsVmSession *Session,
   TypUpsVmAdresse *AdresseResultat, TypUpsVmPointeurDonnees ObjetAny);
   /* Objet : Cree un objet d'un objet CORBA::Any. */
TypUpsVmPointeurDonnees UpsVmAPI (*Objet2Any)(TypUpsVmSession *Session, TypUpsVmAdresse  *AdresseObjet);
   /* Objet : Cree un objet Any a partir d'un objet. */
TypUpsVmVoid UpsVmAPI (*ExporterObjetInterface)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Exporte un objet issu d'une interface. */
TypUpsVmVoid UpsVmAPI (*ExporterObjetInterface2)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees pObjet);
   /* Objet : Exporte un objet issu d'une interface. */
TypUpsVmVoid UpsVmAPI (*ExporterObjetValueBase)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Exporte un objet issu d'un valuebase. */
TypUpsVmVoid UpsVmAPI (*ExporterObjetValueBase2)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees pObjet);
   /* Objet : Exporte un objet issu d'un valuebase. */
TypUpsVmVoid UpsVmAPI (*ExporterObjetTypeCode)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseObjet);
   /* Objet : Exporte un objet issu d'un typecode. */
TypUpsVmVoid UpsVmAPI (*ExporterObjetTypeCode2)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees pObjet);
   /* Objet : Exporte un objet issu d'un typecode. */
TypUpsVmVoid UpsVmAPI (*ImporterObjetInterface)(TypUpsVmSession *Session,
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjetType);
   /* Objet : Importe un objet issu d'une interface. */
TypUpsVmPointeurDonnees UpsVmAPI (*ImporterObjetInterface2)(TypUpsVmSession *Session);
   /* Objet : Importe un objet issu d'une interface. */
TypUpsVmVoid UpsVmAPI (*ImporterObjetValueBase)(TypUpsVmSession *Session,
   TypUpsVmAdresse *AdresseResultat, TypUpsVmAdresse *AdresseObjetType);
   /* Objet : Importe un objet issu d'un valuetype. */
TypUpsVmPointeurDonnees UpsVmAPI (*ImporterObjetValueBase2)(TypUpsVmSession *Session);
   /* Objet : Importe un objet issu d'un valuetype. */
TypUpsVmVoid UpsVmAPI (*ImporterObjetTypeCode)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat);
   /* Objet : Importe un objet issu d'un typecode. */
TypUpsVmPointeurDonnees UpsVmAPI (*ImporterObjetTypeCode2)(TypUpsVmSession *Session);
   /* Objet : Importe un objet issu d'un typecode. */
TypUpsVmVoid UpsVmAPI (*ImporterObjetC)(TypUpsVmSession *Session, TypUpsVmAdresse *AdresseResultat, 
   TypUpsVmAdresse *AdresseObjetType, TypUpsVmPointeurDonnees Objet);
   /* Objet : Importe un objet C. */
TypUpsCrbChar UpsVmAPI *(*AllouerChar)(TypUpsVmSession *Session, TypUpsVmLong TailleBuffer);
   /* Objet : Alloue la chaine. */
TypUpsCrbWCharT UpsVmAPI *(*AllouerWCharT)(TypUpsVmSession *Session, TypUpsVmLong TailleBuffer);
   /* Objet : Alloue la chaine. */
TypUpsVmVoid UpsVmAPI (*LibererChar)(TypUpsVmSession *Session, TypUpsCrbChar *Chaine);
   /* Objet : Liberer la chaine. */
TypUpsVmVoid UpsVmAPI (*LibererWCharT)(TypUpsVmSession *Session, TypUpsCrbWCharT *Chaine);
   /* Objet : Liberer la chaine. */
TypUpsVmVoid UpsVmAPI (*EnvoyerExceptionStandard)(TypUpsVmSession *Session, TypUpsVmPointeurDonnees E, TypUpsVmUnicode *MessageErreur, 
   TypUpsVmUnicode *LibelleAppel);
   /* Objet : Envoie une exception. */
TypUpsVmShort UpsVmAPI (*EnregistrerComposantCorba)(TypUpsVmSession *Session, TypUpsVmUnicode *RepositoryIdf, TypUpsVmUnicode *AccesServeur, 
   TypUpsVmUnicode *MessageErreur);
   /* Objet : Enregistre le composant Corba. */
TypUpsVmShort UpsVmAPI (*SupprimerComposantCorba)(TypUpsVmSession *Session, TypUpsVmUnicode *RepositoryId, TypUpsVmUnicode *AccesServeur, 
   TypUpsVmUnicode *MessageErreur);
   /* Objet : Supprime le composant Corba. */
TypUpsVmVoid UpsVmAPI (*EcrireObjetC)(TypUpsVmSession *Session, enum EnuUpsVmTypeDeDonnee TypeObjetUps, TypUpsVmPointeurDonnees ObjetUps, 
   enum EnuUpsCrbObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC);
   /* Objet : Ecriture d'un objet C. */
TypUpsVmVoid UpsVmAPI (*LireObjetC)(TypUpsVmSession *Session, enum EnuUpsCrbObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC, 
   enum EnuUpsVmTypeDeDonnee TypeObjetUps, TypUpsVmPointeurDonnees ObjetUps);
   /* Objet : Lecture d'un objet C. */
} *TypUpsCrbTraitements_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsCrbTraitements_1_1_0 TypUpsCrbTraitements;

extern DllExport TypUpsVtmDemarrer UpsVmAPI UpsCrbDemarrerModule(TypUpsVmShort Numero, TypUpsVtmMachineInterface MachineInterfaceUpsVtm,
   TypUpsVtmTraitements IntTrtUpsVtm, TypUpsVtmDonnees IntDonUpsVtm);
   /* Objet : Retourne la description de Ups Crb. */

/**********************/
#if defined(__cplusplus)
/**********************/
}
/****/
#endif
/****/

/****/
#endif
/****/
