/* ------------------------------------------------------------------- */
/* Fichier    : type.cpp                                               */
/* Objet      : Exemple d'emploi d'Up ! Corba.                         */
/*                                                                     */                                                                     
/* Module      : Up ! Appplication System.                             */
/* Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.                    */
/* ------------------------------------------------------------------- */
/*                          Observations                               */
/*                                                                     */
/*                                                                     */
/* ------------------------------------------------------------------- */

#include <CORBA.h>
#include <mico/string.h>
#include <upskrn.hh>
#include <upssys.hh>
#include <upscrbexception.h>

using namespace std;

static CORBA::ORB *pOrb;
static CORBA::BOA *pBoa;
static CORBA::Object *pObjet;
static IUpsKrn *pIUpsKrn;
static IUpsSys *pIUpsSys;

/****************************************************************/
int main(int argc, char *argv[])
/****************************************************************/
{
IUpsKrnEntier_var E;
IUpsKrnType_var T;
IUpsKrnObjet_var O;
IUpsKrnEntier_var Inutile;

pOrb=CORBA::ORB_init(argc,argv,"mico-local-orb");
if (!pOrb)
   return(1);
pBoa=pOrb->BOA_init(argc, argv, "mico-local-boa");
if (!pBoa)
   return(1);
pObjet=pOrb->bind("IDL:IUpsKrn:1.0");
if (!pObjet)
   return(1);
pIUpsKrn=IUpsKrn::_narrow(pObjet);
if (!pIUpsKrn)
   return(1);
pObjet=pOrb->bind("IDL:IUpsSys:1.0");
if (!pObjet)
   return(1);
pIUpsSys=IUpsSys::_narrow(pObjet);
if (!pIUpsSys)
   return(1);

try
   {
   T=(IUpsKrnType *)pIUpsKrn->Type()->EnumererObjets(pIUpsKrn->ObjetNul());
   for (;!pIUpsKrn->EstNul((IUpsKrnObjet *)&(*T));)
      {
      cout << pIUpsKrn->Caractere2CorbaString(T->NomType()) << endl;
      T=(IUpsKrnType *)pIUpsKrn->Type()->EnumererObjets((IUpsKrnObjet *)&(*T));
      }
   cout << endl;

   cout << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Binaire()->NomType()) << endl;
   cout << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere()->NomType()) << endl;
   cout << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Date()->NomType()) << endl;
   cout << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Entier()->NomType()) << endl;
   cout << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Enumere()->NomType()) << endl;
   cout << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Exception_()->NomType()) << endl;
   cout << pIUpsKrn->Caractere2CorbaString(pIUpsSys->Fichier()->NomType()) << endl;
   cout << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Module_()->NomType()) << endl;
   cout << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Objet()->NomType()) << endl;
   cout << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Reel()->NomType()) << endl;
   cout << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Type()->NomType()) << endl;
   E=pIUpsKrn->CorbaLong2Entier(1);
   Inutile=E->Incrementer(FALSE);
   if (pIUpsKrn->Booleen2CorbaBoolean(E->Egal(pIUpsKrn->CorbaLong2Entier(2))))
      T=pIUpsKrn->Caractere();
   else
      T=pIUpsKrn->Entier();
   if (pIUpsKrn->Booleen2CorbaBoolean(T->Egal(pIUpsKrn->Date())))
      cout << "T==Date" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(T->Different(pIUpsKrn->Date())))
      cout << "T!=Date" << endl;
   cout << pIUpsKrn->Caractere2CorbaString(T->NomType()) << endl;
   E->Convertir(pIUpsKrn->Entier()->NouvelObjet());
   cout << pIUpsKrn->Entier2CorbaLong(E) << endl;
   E->Convertir(pIUpsKrn->Exception_()->NouvelObjet());
   cout << pIUpsKrn->Entier2CorbaLong(E) << endl;
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   return(1);   
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   return(1);   
   }

E=NULL;
T=NULL;
O=NULL;
Inutile=NULL;
CORBA::release(pIUpsSys);
pIUpsSys=NULL;
CORBA::release(pIUpsKrn);
pIUpsKrn=NULL;
delete pBoa;
delete pOrb;
return(0);
}