/* ------------------------------------------------------------------- */
/* Fichier    : tache.cpp                                              */
/* Objet      : Exemple d'emploi d'Up ! Corba.                         */
/*                                                                     */                                                                     
/* Module      : Up ! Appplication System.                             */
/* Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.                    */
/* ------------------------------------------------------------------- */
/*                          Observations                               */
/*                                                                     */
/*                                                                     */
/* ------------------------------------------------------------------- */

#include <CORBA.h>
#include <mico/string.h>
#include <upskrn.hh>
#include <upssys.hh>
#include <upscrbexception.h>

using namespace std;

static const CORBA::UShort CO_SynchronisationPrivee=1;
static const CORBA::UShort CO_SynchronisationProtegee=2;
static const CORBA::UShort CO_SynchronisationPublique=3;
static const CORBA::UShort CO_SynchronisationLecturePartagee=1;
static const CORBA::UShort CO_SynchronisationLectureExclusive=2;
static const CORBA::UShort CO_SynchronisationEcriturePartagee=3;
static const CORBA::UShort CO_SynchronisationEcritureExclusive=4;

static CORBA::ORB *pOrb;
static CORBA::BOA *pBoa;
static CORBA::Object *pObjet;
static IUpsKrn *pIUpsKrn;
static IUpsSys *pIUpsSys;
static IUpsSysSynchronisation *S;
static IUpsSysTache_var T1;
static IUpsKrnCaractere_var C;

/****************************************************************/
static CORBA::Long PrincipalT1(IUpsSysTache *T)
/****************************************************************/
{
try
   {
   pIUpsKrn->Tracer("Debut");
   cout << "Debut de la tche " << pIUpsKrn->Caractere2CorbaString(T->NomTache()) << endl;

   S->Prendre(CO_SynchronisationLecturePartagee);
   pIUpsSys->Attendre(1);
   cout << "T1 (1) : C=" << pIUpsKrn->Caractere2CorbaString(C) << endl;
   S->Lacher();

   S->Prendre(CO_SynchronisationLecturePartagee);
   pIUpsSys->Attendre(1);
   cout << "T1 (2) : C=" << pIUpsKrn->Caractere2CorbaString(C) << endl;
   S->Lacher();

   S->Prendre(CO_SynchronisationLecturePartagee);
   pIUpsSys->Attendre(1);
   cout << "T1 (3) : C=" << pIUpsKrn->Caractere2CorbaString(C) << endl;
   S->Lacher();

   S->Prendre(CO_SynchronisationLectureExclusive);
   pIUpsSys->Attendre(1);
   cout << "T1 (4) : C=" << pIUpsKrn->Caractere2CorbaString(C) << endl;
   S->Lacher();

   S->Prendre(CO_SynchronisationLectureExclusive);
   pIUpsSys->Attendre(1);
   cout << "T1 (5) : C=" << pIUpsKrn->Caractere2CorbaString(C) << endl;
   S->Lacher();

   S->Prendre(CO_SynchronisationLectureExclusive);
   pIUpsSys->Attendre(1);
   cout << "T1 (6) : C=" << pIUpsKrn->Caractere2CorbaString(C) << endl;
   S->Lacher();

   T->SuspendreTache();

   for (;;)
      {
      cout << "Je ne fais rien" << endl;
      pIUpsSys->Attendre(1);
      }
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   }
return(0);
}

/****************************************************************/
int main(int argc, char *argv[])
/****************************************************************/
{
pOrb=CORBA::ORB_init(argc,argv,"mico-local-orb");
if (!pOrb)
   return(1);
pBoa=pOrb->BOA_init(argc, argv, "mico-local-boa");
if (!pBoa)
   return(1);
pObjet=pOrb->bind("IDL:IUpsKrn:1.0");
if (!pObjet)
   return(1);
pIUpsKrn=IUpsKrn::_narrow(pObjet);
if (!pIUpsKrn)
   return(1);
pObjet=pOrb->bind("IDL:IUpsSys:1.0");
if (!pObjet)
   return(1);
pIUpsSys=IUpsSys::_narrow(pObjet);
if (!pIUpsSys)
   return(1);

try
   {
   S=pIUpsSys->Synchronisation1(pIUpsKrn->CorbaString2Caractere("ExempleDeSynchronisation"), CO_SynchronisationPrivee);
   S->Prendre(CO_SynchronisationEcritureExclusive);
   T1=pIUpsSys->Tache1(pIUpsKrn->CorbaString2Caractere("ExempleDeTache"), pIUpsKrn->CorbaAppel2Appel("long PrincipalT1(in IUpsSys::Tache T)", (CORBA::LongLong)PrincipalT1), FALSE);

   C=pIUpsKrn->CorbaString2Caractere("coucou");
   cout << "TP (1) : C=" << pIUpsKrn->Caractere2CorbaString(C) << endl;
   pIUpsSys->Attendre(5);
   S->Lacher();

   S->Prendre(CO_SynchronisationEcriturePartagee);
   pIUpsSys->Attendre(1);
   C=pIUpsKrn->CorbaString2Caractere("coucou2");
   cout << "TP (2) : C=" << pIUpsKrn->Caractere2CorbaString(C) << endl;
   S->Lacher();

   S->Prendre(CO_SynchronisationEcriturePartagee);
   pIUpsSys->Attendre(1);
   C=pIUpsKrn->CorbaString2Caractere("coucou3");
   cout << "TP (3) : C=" << pIUpsKrn->Caractere2CorbaString(C) << endl;
   S->Lacher();

   S->Prendre(CO_SynchronisationEcriturePartagee);
   pIUpsSys->Attendre(1);
   S->Lacher();

   pIUpsSys->Attendre(5);
   if (T1->EstSuspendue())
      cout << "T1 est suspendue" << endl;
   else
      cout << "T1 n'est pas suspendue" << endl;
   T1->ReprendreTache();

   pIUpsSys->Attendre(5);
   T1->ArreterTache(1);
   if (T1->EstTerminee())
      cout << "T1 est termine" << endl;
   cout << "Code retour de T1=" << T1->CodeRetour() << endl;
   T1=NULL;
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   return(1);   
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   return(1);   
   }

CORBA::release(pIUpsSys);
pIUpsSys=NULL;
CORBA::release(pIUpsKrn);
pIUpsKrn=NULL;
delete pBoa;
delete pOrb;
return(0);
}