/* ------------------------------------------------------------------- */
/* Fichier    : tableau.cpp                                            */
/* Objet      : Exemple d'emploi d'Up ! Corba.                         */
/*                                                                     */                                                                     
/* Module      : Up ! Appplication System.                             */
/* Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.                    */
/* ------------------------------------------------------------------- */
/*                          Observations                               */
/*                                                                     */
/*                                                                     */
/* ------------------------------------------------------------------- */

#include <CORBA.h>
#include <mico/string.h>
#include <upskrn.hh>
#include <upscrbexception.h>

using namespace std;

static const CORBA::UShort CO_ClonageObjetSeul=1;
static const CORBA::UShort CO_ClonageObjetsDirects=2;
static const CORBA::UShort CO_ClonageRecursif=3;

static CORBA::ORB *pOrb;
static CORBA::BOA *pBoa;
static CORBA::Object *pObjet;
static IUpsKrn *pIUpsKrn;

/****************************************************************/
static void EcrireTableau(IUpsKrnCaractere *M, IUpsKrnTableau *T)
/****************************************************************/
{
CORBA::Long I;
   
try
   {
   cout << pIUpsKrn->Caractere2CorbaString(M) << endl;
   I=T->BorneMin();
   for (;;)
      {
      cout << pIUpsKrn->Caractere2CorbaString((IUpsKrnCaractere *)T->Index(pIUpsKrn->CorbaLong2Entier(I))) << endl;
      if (I == T->BorneMax())
         break;
      I=I + 1;
      }
   cout << endl;
   cout << endl;
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   }
}

/****************************************************************/
static void EcrireEntier(IUpsKrnCaractere *M, IUpsKrnEntier *E)
/****************************************************************/
{
try
   {
   cout << pIUpsKrn->Caractere2CorbaString(M) << endl;
   cout << pIUpsKrn->Entier2CorbaLong(E) << endl;
   cout << endl;
   cout << endl;
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   }
}

/****************************************************************/
static IUpsKrnEntier *IncrementerElementTableau(IUpsKrnTableau *T, IUpsKrnEntier *Index, CORBA::Boolean Prefixe)
/****************************************************************/
{
IUpsKrnEntier_var E;

try
   {
   E=((IUpsKrnEntier *)T->Index(Index))->Incrementer(Prefixe);
   return(E);
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   }
return(NULL);
}
   
/****************************************************************/
static IUpsKrnEntier *DecrementerElementTableau(IUpsKrnTableau *T, IUpsKrnEntier *Index, CORBA::Boolean Prefixe)
/****************************************************************/
{
IUpsKrnEntier_var E;

try
   {
   E=((IUpsKrnEntier *)T->Index(Index))->Decrementer(Prefixe);
   return(E);
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   }
return(NULL);
}

/****************************************************************/
static void AdditionnerAffecterElementTableau(IUpsKrnTableau *T, IUpsKrnEntier *Index, IUpsKrnEntier *E)
/****************************************************************/
{
try
   {
   T->Index2(Index, (IUpsKrnObjet *)((IUpsKrnEntier *)T->Index(Index))->Additionner(E));
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   }
}

/****************************************************************/
int main(int argc, char *argv[])
/****************************************************************/
{
IUpsKrnTableau_var T;
IUpsKrnTableau_var T2;
IUpsKrnTableau_var T3;
IUpsKrnCaractere_var C;
IUpsKrnTableau_var T4;

pOrb=CORBA::ORB_init(argc,argv,"mico-local-orb");
if (!pOrb)
   return(1);
pBoa=pOrb->BOA_init(argc, argv, "mico-local-boa");
if (!pBoa)
   return(1);
pObjet=pOrb->bind("IDL:IUpsKrn:1.0");
if (!pObjet)
   return(1);
pIUpsKrn=IUpsKrn::_narrow(pObjet);
if (!pIUpsKrn)
   return(1);

try
   {
   T=pIUpsKrn->Tableau1(10, (IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere(""));
   T2=pIUpsKrn->Tableau2(1, 3, (IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere(""));
   T3=NULL;
   T4=pIUpsKrn->Tableau1(1, (IUpsKrnObjet *)pIUpsKrn->CorbaLong2Entier(0));

   C=pIUpsKrn->CorbaString2Caractere("a");
   T->Index2(pIUpsKrn->CorbaLong2Entier(0),(IUpsKrnObjet *)&(*C));
   T->Index2(pIUpsKrn->CorbaLong2Entier(1),(IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("A"));
   T->Index2(pIUpsKrn->CorbaLong2Entier(2),(IUpsKrnObjet *)&(*C));
   T->Index2(pIUpsKrn->CorbaLong2Entier(3),(IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("B"));
   T->Index2(pIUpsKrn->CorbaLong2Entier(4),(IUpsKrnObjet *)&(*C));
   T->Index2(pIUpsKrn->CorbaLong2Entier(5),(IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("C"));
   EcrireTableau(pIUpsKrn->CorbaString2Caractere("Construction"), T);
   T2->Index2(pIUpsKrn->CorbaLong2Entier(1), (IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("X"));
   T2->Index2(pIUpsKrn->CorbaLong2Entier(2), (IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("Y"));
   T2->Index2(pIUpsKrn->CorbaLong2Entier(3), (IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("Z"));
   EcrireTableau(pIUpsKrn->CorbaString2Caractere("Inserer"), ((IUpsKrnTableau *)T->Cloner((IUpsKrnEntrepot *)pIUpsKrn->ObjetNul(), CO_ClonageObjetSeul))->Inserer(T2, pIUpsKrn->CorbaLong2Entier(2)));
   cout << pIUpsKrn->Entier2CorbaLong(T->Compter((IUpsKrnObjet *)&(*C), pIUpsKrn->CorbaLong2Entier(0))) << endl;
   cout << pIUpsKrn->Entier2CorbaLong(T->Compter((IUpsKrnObjet *)&(*C), pIUpsKrn->CorbaLong2Entier(1))) << endl;
   T3=(IUpsKrnTableau *)T->Cloner((IUpsKrnEntrepot *)pIUpsKrn->ObjetNul(), CO_ClonageObjetSeul);
   T3->Remplacer((IUpsKrnObjet *)&(*C), (IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("X"), pIUpsKrn->CorbaLong2Entier(0));
   EcrireTableau(pIUpsKrn->CorbaString2Caractere("Remplacer"), T3);
   T3=(IUpsKrnTableau *)T->Cloner((IUpsKrnEntrepot *)pIUpsKrn->ObjetNul(), CO_ClonageObjetSeul);
   T3->Remplacer((IUpsKrnObjet *)&(*C), (IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("X"), pIUpsKrn->CorbaLong2Entier(2));
   EcrireTableau(pIUpsKrn->CorbaString2Caractere("Remplacer"), T3);
   cout << pIUpsKrn->Entier2CorbaLong(T->Rechercher((IUpsKrnObjet *)&(*C), pIUpsKrn->CorbaLong2Entier(0))) << endl;
   cout << pIUpsKrn->Entier2CorbaLong(T->Rechercher((IUpsKrnObjet *)&(*C), pIUpsKrn->CorbaLong2Entier(1))) << endl;
   EcrireTableau(pIUpsKrn->CorbaString2Caractere("Supprimer"), T->Supprimer((IUpsKrnObjet *)&(*C), pIUpsKrn->CorbaLong2Entier(0)));
   EcrireTableau(pIUpsKrn->CorbaString2Caractere("Supprimer"), T->Supprimer((IUpsKrnObjet *)&(*C), pIUpsKrn->CorbaLong2Entier(2)));
   T3=((IUpsKrnTableau *)T->Cloner((IUpsKrnEntrepot *)pIUpsKrn->ObjetNul(), CO_ClonageObjetSeul))->Retailler(20, (IUpsKrnObjet *)pIUpsKrn->Caractere1());
   EcrireTableau(pIUpsKrn->CorbaString2Caractere("Retailler(20)"), T3);
   T3=((IUpsKrnTableau *)T->Cloner((IUpsKrnEntrepot *)pIUpsKrn->ObjetNul(), CO_ClonageObjetSeul))->Retailler(2, (IUpsKrnObjet *)pIUpsKrn->Caractere1());
   EcrireTableau(pIUpsKrn->CorbaString2Caractere("Retailler(2)"), T3);
   T4->Index2(pIUpsKrn->CorbaLong2Entier(0), (IUpsKrnObjet *)pIUpsKrn->CorbaLong2Entier(1));
   EcrireEntier(pIUpsKrn->CorbaString2Caractere("[]++"), IncrementerElementTableau(T4, pIUpsKrn->CorbaLong2Entier(0), FALSE));
   EcrireEntier(pIUpsKrn->CorbaString2Caractere("[]--"), DecrementerElementTableau(T4, pIUpsKrn->CorbaLong2Entier(0), FALSE));
   EcrireEntier(pIUpsKrn->CorbaString2Caractere("++[]"), IncrementerElementTableau(T4, pIUpsKrn->CorbaLong2Entier(0), TRUE));
   EcrireEntier(pIUpsKrn->CorbaString2Caractere("--[]"), DecrementerElementTableau(T4, pIUpsKrn->CorbaLong2Entier(0), TRUE));
   T4->Index2(pIUpsKrn->CorbaLong2Entier(0), (IUpsKrnObjet *)((IUpsKrnEntier *)T4->Index(pIUpsKrn->CorbaLong2Entier(0)))->Additionner(pIUpsKrn->CorbaLong2Entier(1)));
   EcrireEntier(pIUpsKrn->CorbaString2Caractere("[]+1"), (IUpsKrnEntier *)T4->Index(pIUpsKrn->CorbaLong2Entier(0)));
   AdditionnerAffecterElementTableau(T4, pIUpsKrn->CorbaLong2Entier(0), pIUpsKrn->CorbaLong2Entier(1));
   EcrireEntier(pIUpsKrn->CorbaString2Caractere("[]+=1"), (IUpsKrnEntier *)T4->Index(pIUpsKrn->CorbaLong2Entier(0)));
   T4->Index2((IUpsKrnEntier *)pIUpsKrn->ObjetNul(), (IUpsKrnObjet *)pIUpsKrn->CorbaLong2Entier(10));
   EcrireEntier(pIUpsKrn->CorbaString2Caractere("[Nul]=10"), (IUpsKrnEntier *)T4->Index((IUpsKrnEntier *)pIUpsKrn->ObjetNul()));
   EcrireEntier(pIUpsKrn->CorbaString2Caractere("[Nul]++"), IncrementerElementTableau(T4, (IUpsKrnEntier *)pIUpsKrn->ObjetNul(), FALSE));
   EcrireEntier(pIUpsKrn->CorbaString2Caractere("[Nul]--"), DecrementerElementTableau(T4, (IUpsKrnEntier *)pIUpsKrn->ObjetNul(), FALSE));
   T4->Index2((IUpsKrnEntier *)pIUpsKrn->ObjetNul(), (IUpsKrnObjet *)((IUpsKrnEntier *)T4->Index((IUpsKrnEntier *)pIUpsKrn->ObjetNul()))->Additionner(pIUpsKrn->CorbaLong2Entier(1)));
   EcrireEntier(pIUpsKrn->CorbaString2Caractere("[Nul]+1"), (IUpsKrnEntier *)T4->Index((IUpsKrnEntier *)pIUpsKrn->ObjetNul()));
   AdditionnerAffecterElementTableau(T4, (IUpsKrnEntier *)pIUpsKrn->ObjetNul(), pIUpsKrn->CorbaLong2Entier(1));
   EcrireEntier(pIUpsKrn->CorbaString2Caractere("[Nul]+=1"), (IUpsKrnEntier *)T4->Index((IUpsKrnEntier *)pIUpsKrn->ObjetNul()));
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   return(1);   
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   return(1);   
   }

T=NULL;
T2=NULL;
T3=NULL;
C=NULL;
T4=NULL;
CORBA::release(pIUpsKrn);
pIUpsKrn=NULL;
delete pBoa;
delete pOrb;
return(0);
}