/* ------------------------------------------------------------------- */
/* Fichier    : system.cpp                                             */
/* Objet      : Exemple d'emploi d'Up ! Corba.                         */
/*                                                                     */                                                                     
/* Module      : Up ! Appplication System.                             */
/* Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.                    */
/* ------------------------------------------------------------------- */
/*                          Observations                               */
/*                                                                     */
/*                                                                     */
/* ------------------------------------------------------------------- */

#include <CORBA.h>
#include <mico/string.h>
#include <upskrn.hh>
#include <upssys.hh>
#include <upssec.hh>
#include <upscrbexception.h>

using namespace std;

static const CORBA::UShort CO_DroitLecture=1;
static const CORBA::UShort CO_DroitEcriture=2;
static const CORBA::UShort CO_DroitExecution=3;
static const CORBA::UShort CO_DroitLectureEcriture=4;
static const CORBA::UShort CO_DroitLectureExecution=5;
static const CORBA::UShort CO_DroitEcritureExecution=6;
static const CORBA::UShort CO_DroitLectureEcritureExecution=7;

static CORBA::ORB *pOrb;
static CORBA::BOA *pBoa;
static CORBA::Object *pObjet;
static IUpsKrn *pIUpsKrn;
static IUpsSys *pIUpsSys;
static IUpsSec *pIUpsSec;
static CORBA::Long NbAlarmes;

/****************************************************************/
static CORBA::Boolean MonAlarme(void)
/****************************************************************/
{
try
   {
   cout << "Date=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere4(pIUpsSys->DateSysteme(), pIUpsKrn->CorbaString2Caractere("%HH:%Mi:%S"))) << endl;
   NbAlarmes=NbAlarmes+1;
   if (NbAlarmes < 3)
      return(TRUE);
   else
      return(FALSE);
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   }
return(FALSE);
}

/****************************************************************/
static IUpsKrnCaractere *EcrireEntree(void)
/****************************************************************/
{
try
   {
   return((IUpsKrnCaractere *)pIUpsKrn->ObjetNul());
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   }
return(NULL);
}

/****************************************************************/
static void LireSortie(IUpsKrnCaractere *M)
/****************************************************************/
{
try
   {
   cout << pIUpsKrn->Caractere2CorbaString(M) << endl;
   }
catch (CORBA::Exception &e)
   {
   UpsCrbException *E;

   E=(UpsCrbException *)&e;
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   return;   
   }
}

/****************************************************************/
int main(int argc, char *argv[])
/****************************************************************/
{
IUpsKrnCaractere_var C;
CORBA::Long P;
CORBA::Long CR;
CORBA::Long UtilisateurProprietaire;
CORBA::Long GroupeProprietaire;
IUpsKrnEnumere_var DroitsGroupe;
IUpsKrnEnumere_var DroitsAutres;
IUpsKrnDate_var DateDernierAcces;
IUpsKrnDate_var DateDerniereModification;
IUpsKrnDate_var DateCreation;
CORBA::Boolean EstCache;
IUpsKrnListe_var L1;
IUpsSysFichierListe_var FL;
IUpsKrnListe_var L2;
IUpsSysProcessusListe_var PL;
IUpsKrnListe_var L3;
IUpsSysUniteListee_var UL;
IUpsKrnCaractere_var CommandeGcc;
CORBA::Long Inutile;

pOrb=CORBA::ORB_init(argc,argv,"mico-local-orb");
if (!pOrb)
   return(1);
pBoa=pOrb->BOA_init(argc, argv, "mico-local-boa");
if (!pBoa)
   return(1);
pObjet=pOrb->bind("IDL:IUpsKrn:1.0");
if (!pObjet)
   return(1);
pIUpsKrn=IUpsKrn::_narrow(pObjet);
if (!pIUpsKrn)
   return(1);
pObjet=pOrb->bind("IDL:IUpsSys:1.0");
if (!pObjet)
   return(1);
pIUpsSys=IUpsSys::_narrow(pObjet);
if (!pIUpsSys)
   return(1);
pObjet=pOrb->bind("IDL:IUpsSec:1.0");
if (!pObjet)
   return(1);
pIUpsSec=IUpsSec::_narrow(pObjet);
if (!pIUpsSec)
   return(1);

try
   {
   NbAlarmes=0;

   cout << "NomNoeud=" << pIUpsKrn->Caractere2CorbaString(pIUpsSys->NomNoeud()) << endl;
   cout << "NomMachine=" << pIUpsKrn->Caractere2CorbaString(pIUpsSys->NomMachine()) << endl;
   cout << "NomProgramme=" << pIUpsKrn->Caractere2CorbaString(pIUpsSys->NomProgramme()) << endl;
   cout << "NomUtilisateur=" << pIUpsKrn->Caractere2CorbaString(pIUpsSys->NomUtilisateur()) << endl;
   cout << "NomGroupe=" << pIUpsKrn->Caractere2CorbaString(pIUpsSys->NomGroupe()) << endl;
   cout << "NumeroProcessus=" << pIUpsSys->NumeroProcessus() << endl;
   cout << "NumeroGroupe=" << pIUpsSys->NumeroGroupe() << endl;
   cout << "NumeroUtilisateur=" << pIUpsSys->NumeroUtilisateur() << endl;
   cout << "SystemeDExploitation=" << pIUpsKrn->Caractere2CorbaString(pIUpsSys->SystemeDExploitation()) << endl;
   cout << "SeparateurRepertoire=" << pIUpsKrn->Caractere2CorbaString(pIUpsSys->SeparateurRepertoire()) << endl;
   cout << "UpsHome=" << pIUpsKrn->Caractere2CorbaString(pIUpsSys->UpsHome()) << endl;
   cout << "UpsPath=" << pIUpsKrn->Caractere2CorbaString(pIUpsSys->UpsPath()) << endl;
   cout << "UpsUser=" << pIUpsKrn->Caractere2CorbaString(pIUpsSys->UpsUser()) << endl;

   pIUpsSys->Alarme(pIUpsKrn->CorbaAppel2Appel("boolean MonAlarme()", (CORBA::LongLong)MonAlarme), 10, TRUE);
   cout << "On attend 40 secondes" << endl;
   pIUpsSys->Attendre(40);
   cout << "Fin de l'attente" << endl;

   cout << "Aleatoire()=" << pIUpsSys->Aleatoire() << endl;
   cout << "BornerRepertoire('/tmp')=" << pIUpsKrn->Caractere2CorbaString(pIUpsSys->BornerRepertoire(pIUpsKrn->CorbaString2Caractere("/tmp"))) << endl;
   pIUpsSys->ChangerEnvironnement(pIUpsKrn->CorbaString2Caractere("UPS_ESSAI"), pIUpsKrn->CorbaString2Caractere("Bonjour le monde"));
   cout << "LireEnvironnement(UPS_ESSAI)=" << pIUpsKrn->Caractere2CorbaString(pIUpsSys->LireEnvironnement(pIUpsKrn->CorbaString2Caractere("UPS_ESSAI"))) << endl;
   cout << "LireEnvironnement(PATH)=" << pIUpsKrn->Caractere2CorbaString(pIUpsSys->LireEnvironnement(pIUpsKrn->CorbaString2Caractere("PATH"))) << endl;
   pIUpsSys->ChangerPriorite(5);
   cout << "LirePriorite()=" << pIUpsSys->LirePriorite() << endl;
   pIUpsSys->ChangerPriorite(4);
   C=pIUpsSec->Crypter(pIUpsKrn->CorbaString2Caractere("XYZT"), pIUpsKrn->CorbaString2Caractere("Bonjour le monde"));
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   cout << pIUpsKrn->Caractere2CorbaString(pIUpsSec->Decrypter(pIUpsKrn->CorbaString2Caractere("XYZT"), C)) << endl;

   pIUpsSys->CreerRepertoire(pIUpsKrn->CorbaString2Caractere("/tmp2"));
   pIUpsSys->CreerFichier(pIUpsKrn->CorbaString2Caractere("/tmp2/essai.txt"));
   if (pIUpsSys->IlExisteRepertoire(pIUpsKrn->CorbaString2Caractere("/tmp2")))
      cout << "Il existe repertoire '/tmp2'" << endl;
   if (pIUpsSys->IlExisteFichier(pIUpsKrn->CorbaString2Caractere("/tmp2/essai.txt")))
      cout << "Il existe fichier '/tmp2/essai.txt'" << endl;
   pIUpsSys->ChangerDroitsDAcces(pIUpsKrn->CorbaString2Caractere("/tmp2/essai.txt"), CO_DroitLectureEcriture, CO_DroitLecture, CO_DroitLecture);
   switch (pIUpsKrn->Enumere2CorbaUnsignedShort(pIUpsSys->LireDroitsDAcces(pIUpsKrn->CorbaString2Caractere("/tmp2/essai.txt"), DroitsGroupe, DroitsAutres)))
      {
      case DroitLectureEcriture :
      case DroitLectureEcritureExecution :
         cout << "Lecture, Ecriture et Execution" << endl;
         break;
         
      default :
         cout << "Autres droits" << endl;
         break;
      }

   pIUpsSys->CopierFichier(pIUpsKrn->CorbaString2Caractere("/tmp2/essai.txt"), pIUpsKrn->CorbaString2Caractere("/tmp2/essai.sav"));
   pIUpsSys->RenommerFichier(pIUpsKrn->CorbaString2Caractere("/tmp2/essai.sav"), pIUpsKrn->CorbaString2Caractere("/tmp2/essai.bak"));
   pIUpsSys->SupprimerFichier(pIUpsKrn->CorbaString2Caractere("/tmp2/essai.bak"));
   pIUpsSys->CopierRepertoire(pIUpsKrn->CorbaString2Caractere("/tmp2"), pIUpsKrn->CorbaString2Caractere("/tmp3"));
   pIUpsSys->SupprimerRepertoire(pIUpsKrn->CorbaString2Caractere("/tmp2"));
   pIUpsSys->RenommerRepertoire(pIUpsKrn->CorbaString2Caractere("/tmp3"), pIUpsKrn->CorbaString2Caractere("/tmp2"));
   pIUpsSys->SupprimerRepertoire(pIUpsKrn->CorbaString2Caractere("/tmp2"));
   if (pIUpsSys->IlExisteRepertoire(pIUpsKrn->CorbaString2Caractere("/tmp2")))
      cout << "Il existe repertoire '/tmp2'" << endl;
   if (pIUpsSys->IlExisteFichier(pIUpsKrn->CorbaString2Caractere("/tmp2/essai.txt")))
      cout << "Il existe fichier '/tmp2/essai.txt'" << endl;
   pIUpsSys->ChangerRepertoireCourant(pIUpsKrn->CorbaString2Caractere("/tmp"));
   cout << "RepertoireCourant=" << pIUpsKrn->Caractere2CorbaString(pIUpsSys->LireRepertoireCourant()) << endl;
   cout << pIUpsKrn->Caractere2CorbaString(pIUpsSys->RechercherFichierDansChemin(pIUpsSys->LireEnvironnement(pIUpsKrn->CorbaString2Caractere("PATH")), pIUpsKrn->CorbaString2Caractere("xterm"), (IUpsKrnCaractere *)pIUpsKrn->ObjetNul())) << endl;

   Inutile=pIUpsSys->Executer(pIUpsKrn->CorbaString2Caractere("xterm"), FALSE, FALSE, P, (IUpsKrnCaractere *)pIUpsKrn->ObjetNul(), 
      (IUpsKrnAppel *)pIUpsKrn->ObjetNul(), (IUpsKrnAppel *)pIUpsKrn->ObjetNul());
   pIUpsSys->Attendre(10);
   pIUpsSys->ArreterProcessus(P);

   CommandeGcc=pIUpsSys->RechercherFichierDansChemin(pIUpsSys->LireEnvironnement(pIUpsKrn->CorbaString2Caractere("PATH")), 
      pIUpsKrn->CorbaString2Caractere("gcc"), (IUpsKrnCaractere *)pIUpsKrn->ObjetNul());
   cout << "gcc=" << pIUpsSys->Executer(CommandeGcc->Additionner(pIUpsKrn->CorbaString2Caractere(" --version")), TRUE, TRUE, P, (IUpsKrnCaractere *)pIUpsKrn->ObjetNul(), 
      (IUpsKrnAppel *)pIUpsKrn->ObjetNul(), (IUpsKrnAppel *)pIUpsKrn->ObjetNul()) << endl;
   Inutile=pIUpsSys->Executer(CommandeGcc->Additionner(pIUpsKrn->CorbaString2Caractere(" --version")), FALSE, FALSE, P, (IUpsKrnCaractere *)pIUpsKrn->ObjetNul(), 
      (IUpsKrnAppel *)pIUpsKrn->ObjetNul(), (IUpsKrnAppel *)pIUpsKrn->ObjetNul());
   pIUpsSys->Attendre(10);
   if (pIUpsSys->LireCodeRetour(P, CR))
      cout << "Code-retour de gcc=" << CR << endl;
   Inutile=pIUpsSys->Executer(CommandeGcc->Additionner(pIUpsKrn->CorbaString2Caractere(" --version")), TRUE, TRUE, P, (IUpsKrnCaractere *)pIUpsKrn->ObjetNul(), 
      pIUpsKrn->CorbaAppel2Appel("IUpsKrn::Caractere EcrireEntree()", (CORBA::LongLong)EcrireEntree), 
      pIUpsKrn->CorbaAppel2Appel("void LireSortie(in IUpsKrn::Caractere M)", (CORBA::LongLong)LireSortie));

   cout << pIUpsKrn->Caractere2CorbaString(pIUpsSys->LireEnvironnement(pIUpsKrn->CorbaString2Caractere("UPS_HOME2"))) << endl;
   cout << "Taille /etc/profile=" << pIUpsSys->LireCaracteristiquesFichier(pIUpsKrn->CorbaString2Caractere("/etc/profile")) << endl;
   cout << "Taille /etc/profile=" << pIUpsSys->LireCaracteristiquesFichier2(pIUpsKrn->CorbaString2Caractere("/etc/profile"), 
      UtilisateurProprietaire, GroupeProprietaire, DateDernierAcces, DateDerniereModification, DateCreation, EstCache) << endl;

   cout << UtilisateurProprietaire << endl;
   cout << GroupeProprietaire << endl;
   cout << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere3(DateDernierAcces)) << endl;
   cout << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere3(DateDerniereModification)) << endl;
   if (EstCache)
      cout << "Est cache" << endl;
   else
      cout << "N'est pas cache" << endl;
   cout << endl;

   L1=pIUpsSys->ListerFichiers(pIUpsKrn->CorbaString2Caractere("c:/"), (IUpsKrnCaractere *)pIUpsKrn->ObjetNul());
   FL=(IUpsSysFichierListe *)L1->ParcoursAuDebut(0);
   for (;;)
      {
      cout << pIUpsKrn->Caractere2CorbaString(FL->NomFichier()) << endl;
      if (FL->Identique(L1->DernierElement()))
         break;
      FL=(IUpsSysFichierListe *)L1->Suivant(0);
      }
   cout << endl;

   L2=pIUpsSys->ListerProcessus();
   PL=(IUpsSysProcessusListe *)L2->ParcoursAuDebut(0);
   for (;;)
      {
      cout << pIUpsKrn->Caractere2CorbaString(PL->NomProgramme()) << endl;
      cout << PL->Numero() << endl;
      cout << PL->TempsSysteme() << endl;
      cout << PL->TempsUtilisateur() << endl;
      cout << endl;
      if (PL->Identique(L2->DernierElement()))
         break;
      PL=(IUpsSysProcessusListe *)L2->Suivant(0);
      }

   L3=pIUpsSys->ListerUnites((IUpsKrnCaractere *)pIUpsKrn->ObjetNul());
   UL=(IUpsSysUniteListee *)L3->ParcoursAuDebut(0);
   for(;;)
      {
      cout << pIUpsKrn->Caractere2CorbaString(UL->NomUnite()) << endl;
      cout << UL->PlaceLibre() << endl;
      cout << UL->PlaceTotale() << endl;
      cout << endl;
      if (UL->Identique(L3->DernierElement()))
         break;
      UL=(IUpsSysUniteListee *)L3->Suivant(0);
      }
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   return(1);   
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   return(1);   
   }

C=NULL;
DroitsGroupe=NULL;
DroitsAutres=NULL;
DateDernierAcces=NULL;
DateDerniereModification=NULL;
DateCreation=NULL;
L1=NULL;
FL=NULL;
L2=NULL;
PL=NULL;
L3=NULL;
UL=NULL;
CommandeGcc=NULL;
CORBA::release(pIUpsSec);
pIUpsSec=NULL;
CORBA::release(pIUpsSys);
pIUpsSys=NULL;
CORBA::release(pIUpsKrn);
pIUpsKrn=NULL;
delete pBoa;
delete pOrb;
return(0);
}
