/* ------------------------------------------------------------------- */
/* Fichier    : reference.cpp                                          */
/* Objet      : Exemple d'emploi d'Up ! Corba.                         */
/*                                                                     */                                                                     
/* Module      : Up ! Appplication System.                             */
/* Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.                    */
/* ------------------------------------------------------------------- */
/*                          Observations                               */
/*                                                                     */
/*                                                                     */
/* ------------------------------------------------------------------- */

#include <CORBA.h>
#include <mico/string.h>
#include <upskrn.hh>
#include <upscrbexception.h>

using namespace std;

static CORBA::ORB *pOrb;
static CORBA::BOA *pBoa;
static CORBA::Object *pObjet;
static IUpsKrn *pIUpsKrn;

/****************************************************************/
int main(int argc, char *argv[])
/****************************************************************/
{
IUpsKrnCaractere_var A;
IUpsKrnReference_var R1;
IUpsKrnReference_var R2;

pOrb=CORBA::ORB_init(argc,argv,"mico-local-orb");
if (!pOrb)
   return(1);
pBoa=pOrb->BOA_init(argc, argv, "mico-local-boa");
if (!pBoa)
   return(1);
pObjet=pOrb->bind("IDL:IUpsKrn:1.0");
if (!pObjet)
   return(1);
pIUpsKrn=IUpsKrn::_narrow(pObjet);
if (!pIUpsKrn)
   return(1);

try
   {
   A=pIUpsKrn->CorbaString2Caractere("A");
   R1=pIUpsKrn->Reference1((IUpsKrnObjet *)&(*A));
   R2=pIUpsKrn->Reference1((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("B"));
   cout << pIUpsKrn->Caractere2CorbaString((IUpsKrnCaractere *)R1->Valeur()) << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(R1->Egal(R2)))
      cout << "R1==R2" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(R1->Different(R2)))
      cout << "R1!=R2" << endl;
   R2=R1;
   if (R1->Valeur()->Identique(R2->Valeur()))
      cout << "R1.Valeur==R2.Valeur" << endl;
   R1->Valeur((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("C"));
   cout << pIUpsKrn->Caractere2CorbaString((IUpsKrnCaractere *)R2->Valeur()) << endl;
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   return(1);   
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   return(1);   
   }

A=NULL;
R1=NULL;
R2=NULL;
CORBA::release(pIUpsKrn);
pIUpsKrn=NULL;
delete pBoa;
delete pOrb;
return(0);
}