/* ------------------------------------------------------------------- */
/* Fichier    : reel.cpp                                               */
/* Objet      : Exemple d'emploi d'Up ! Corba.                         */
/*                                                                     */                                                                     
/* Module      : Up ! Appplication System.                             */
/* Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.                    */
/* ------------------------------------------------------------------- */
/*                          Observations                               */
/*                                                                     */
/*                                                                     */
/* ------------------------------------------------------------------- */

#include <CORBA.h>
#include <mico/string.h>
#include <upskrn.hh>
#include <upscrbexception.h>

using namespace std;

static CORBA::ORB *pOrb;
static CORBA::BOA *pBoa;
static CORBA::Object *pObjet;
static IUpsKrn *pIUpsKrn;

/****************************************************************/
int main(int argc, char *argv[])
/****************************************************************/
{
IUpsKrnReel_var A;
CORBA::Double B;

pOrb=CORBA::ORB_init(argc,argv,"mico-local-orb");
if (!pOrb)
   return(1);
pBoa=pOrb->BOA_init(argc, argv, "mico-local-boa");
if (!pBoa)
   return(1);
pObjet=pOrb->bind("IDL:IUpsKrn:1.0");
if (!pObjet)
   return(1);
pIUpsKrn=IUpsKrn::_narrow(pObjet);
if (!pIUpsKrn)
   return(1);

try
   {
   A=pIUpsKrn->CorbaDouble2Reel(1.0);
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B=1.0;
   cout << B << endl;

   A=A->Additionner(pIUpsKrn->CorbaDouble2Reel(1.0));
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B=B + 1.0;
   cout << B << endl;

   A=A->Soustraire2(pIUpsKrn->CorbaDouble2Reel(10.0));
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B=B - 10.0;
   cout << B << endl;

   A=A->Multiplier(pIUpsKrn->CorbaDouble2Reel(10.0));
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B=B * 10.0;
   cout << B << endl;

   A=A->Diviser(pIUpsKrn->CorbaDouble2Reel(5.0));
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B=B / 5.0;
   cout << B << endl;

   A=A->Puissance(pIUpsKrn->CorbaDouble2Reel(3.0));
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B=(CORBA::Double)pow((double)B,3.0);
   cout << B << endl;

   A=pIUpsKrn->CorbaDouble2Reel(1.0);
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B=1.0;
   cout << B << endl;

   A=pIUpsKrn->CorbaDouble2Reel(1.0)->Additionner(A);
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B=1.0 + B;
   cout << B << endl;

   A=pIUpsKrn->CorbaDouble2Reel(10.0)->Soustraire2(A);
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B=10.0 - B;
   cout << B << endl;

   A=pIUpsKrn->CorbaDouble2Reel(10.0)->Multiplier(A);
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B=10.0 * B;
   cout << B << endl;

   A=pIUpsKrn->CorbaDouble2Reel(5.0)->Diviser(A);
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B=5.0 / B;
   cout << B << endl;

   A=pIUpsKrn->CorbaDouble2Reel(3.0)->Puissance(A);
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B=(CORBA::Double)pow(3.0,(double)B);
   cout << B << endl;

   A=pIUpsKrn->CorbaDouble2Reel(1.0);
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B=1.0;
   cout << B << endl;

   A->AdditionnerAffecter(pIUpsKrn->CorbaDouble2Reel(1.0));
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B+=1.0;
   cout << B << endl;

   A->SoustraireAffecter(pIUpsKrn->CorbaDouble2Reel(10.0));
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B-=10.0;
   cout << B << endl;

   A->MultiplierAffecter(pIUpsKrn->CorbaDouble2Reel(10.0));
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B*=10.0;
   cout << B << endl;

   A->PuissanceAffecter(pIUpsKrn->CorbaDouble2Reel(3.0));
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B=(CORBA::Double)pow((double)B,3.0);
   cout << B << endl;

   A=pIUpsKrn->Reel2(pIUpsKrn->CorbaLong2Entier(1));
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B=1;
   cout << B << endl;

   A=A->Additionner2(pIUpsKrn->CorbaLong2Entier(1));
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B=B + 1;
   cout << B << endl;

   A=A->Soustraire3(pIUpsKrn->CorbaLong2Entier(10));
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B=B - 10;
   cout << B << endl;

   A=A->Multiplier2(pIUpsKrn->CorbaLong2Entier(10));
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B=B * 10;
   cout << B << endl;

   A=A->Diviser2(pIUpsKrn->CorbaLong2Entier(5));
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B=B / 5;
   cout << B << endl;

   A=A->Puissance2(pIUpsKrn->CorbaLong2Entier(3));
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B=(CORBA::Double)pow((double)B,3.0);
   cout << B << endl;

   A=pIUpsKrn->Reel2(pIUpsKrn->CorbaLong2Entier(1));
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B=1;
   cout << B << endl;

   A=pIUpsKrn->CorbaLong2Entier(1)->Additionner2(A);
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B=1 + B;
   cout << B << endl;

   A=pIUpsKrn->CorbaLong2Entier(1)->Soustraire3(A);
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B=1 - B;
   cout << B << endl;

   A=pIUpsKrn->CorbaLong2Entier(1)->Multiplier2(A);
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B=1 * B;
   cout << B << endl;

   A=pIUpsKrn->CorbaLong2Entier(5)->Diviser2(A);
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B=5 / B;
   cout << B << endl;

   A=pIUpsKrn->CorbaLong2Entier(3)->Puissance2(A);
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B=(CORBA::Double)pow(3.0,(double)B);
   cout << B << endl;

   A=pIUpsKrn->Reel2(pIUpsKrn->CorbaLong2Entier(1));
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B=1;
   cout << B << endl;

   A->AdditionnerAffecter2(pIUpsKrn->CorbaLong2Entier(1));
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B=B + 1;
   cout << B << endl;

   A->SoustraireAffecter2(pIUpsKrn->CorbaLong2Entier(10));
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B=B - 10;
   cout << B << endl;

   A->MultiplierAffecter2(pIUpsKrn->CorbaLong2Entier(10));
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B=B * 10;
   cout << B << endl;

   A->PuissanceAffecter2(pIUpsKrn->CorbaLong2Entier(3));
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B=(CORBA::Double)pow((double)B,3.0);
   cout << B << endl;

   A->Incrementer(FALSE);
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B++;
   cout << B << endl;

   A->Decrementer(FALSE);
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   B--;
   cout << B << endl;

   A->Incrementer(TRUE);
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   ++B;
   cout << B << endl;

   A->Decrementer(TRUE);
   cout << pIUpsKrn->Reel2CorbaDouble(A) << endl;
   --B;
   cout << B << endl;

   if (pIUpsKrn->Booleen2CorbaBoolean(A->Egal(pIUpsKrn->CorbaDouble2Reel(1.0))))
      cout << "A==1.0" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(A->Different(pIUpsKrn->CorbaDouble2Reel(1.0))))
      cout << "A!=1.0" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(A->InferieurOuEgal(pIUpsKrn->CorbaDouble2Reel(1.0))))
      cout << "A<=1.0" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(A->SuperieurOuEgal(pIUpsKrn->CorbaDouble2Reel(1.0))))
      cout << "A>=1.0" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(A->Inferieur(pIUpsKrn->CorbaDouble2Reel(1.0))))
      cout << "A<1.0" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(A->Superieur(pIUpsKrn->CorbaDouble2Reel(1.0))))
      cout << "A>1.0" << endl;

   if (B==1.0)
      cout << "B==1.0" << endl;
   if (B != 1.0)
      cout << "B!=1.0" << endl;
   if (B <= 1.0)
      cout << "B<=1.0" << endl;
   if (B >= 1.0)
      cout << "B>=1.0" << endl;
   if (B < 1.0)
      cout << "B<1.0" << endl;
   if (B > 1.0)
      cout << "B>1.0" << endl;

   if (pIUpsKrn->Booleen2CorbaBoolean(A->Egal2(pIUpsKrn->CorbaLong2Entier(1))))
      cout << "A==1" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(A->Different2(pIUpsKrn->CorbaLong2Entier(1))))
      cout << "A!=1" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(A->InferieurOuEgal2(pIUpsKrn->CorbaLong2Entier(1))))
      cout << "A<=1" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(A->SuperieurOuEgal2(pIUpsKrn->CorbaLong2Entier(1))))
      cout << "A>=1" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(A->Inferieur2(pIUpsKrn->CorbaLong2Entier(1))))
      cout << "A<1" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(A->Superieur2(pIUpsKrn->CorbaLong2Entier(1))))
      cout << "A>1" << endl;

   if (B==1)
      cout << "B==1" << endl;
   if (B != 1)
      cout << "B!=1" << endl;
   if (B <= 1)
      cout << "B<=1" << endl;
   if (B >= 1)
      cout << "B>=1" << endl;
   if (B < 1)
      cout << "B<1" << endl;
   if (B > 1)
      cout << "B>1" << endl;

   if (pIUpsKrn->Booleen2CorbaBoolean(pIUpsKrn->CorbaDouble2Reel(1.0)->Egal(A)))
      cout << "1.0==A" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(pIUpsKrn->CorbaDouble2Reel(1.0)->Different(A)))
      cout << "1.0!=A" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(pIUpsKrn->CorbaDouble2Reel(1.0)->InferieurOuEgal(A)))
      cout << "1.0<=A" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(pIUpsKrn->CorbaDouble2Reel(1.0)->SuperieurOuEgal(A)))
      cout << "1.0>=A" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(pIUpsKrn->CorbaDouble2Reel(1.0)->Inferieur(A)))
      cout << "1.0<A" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(pIUpsKrn->CorbaDouble2Reel(1.0)->Superieur(A)))
      cout << "1.0>A" << endl;

   if (1.0==B)
      cout << "1.0==B" << endl;
   if (1 != B)
      cout << "1.0!=B" << endl;
   if (1.0 <= B)
      cout << "1.0<=B" << endl;
   if (1.0 >= B)
      cout << "1.0>=B" << endl;
   if (1.0 < B)
      cout << "1.0<B" << endl;
   if (1.0 > B)
      cout << "1.0>B" << endl;

   if (pIUpsKrn->Booleen2CorbaBoolean(pIUpsKrn->CorbaLong2Entier(1)->Egal2(A)))
      cout << "1==A" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(pIUpsKrn->CorbaLong2Entier(1)->Different2(A)))
      cout << "1!=A" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(pIUpsKrn->CorbaLong2Entier(1)->InferieurOuEgal2(A)))
      cout << "1<=A" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(pIUpsKrn->CorbaLong2Entier(1)->SuperieurOuEgal2(A)))
      cout << "1>=A" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(pIUpsKrn->CorbaLong2Entier(1)->Inferieur2(A)))
      cout << "1<A" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(pIUpsKrn->CorbaLong2Entier(1)->Superieur2(A)))
      cout << "1>A" << endl;

   if (1==B)
      cout << "1==B" << endl;
   if (1 != B)
      cout << "1!=B" << endl;
   if (1 <= B)
      cout << "1<=B" << endl;
   if (1 >= B)
      cout << "1>=B" << endl;
   if (1 < B)
      cout << "1<B" << endl;
   if (1 > B)
      cout << "1>B" << endl;
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   return(1);   
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   return(1);   
   }

A=NULL;
CORBA::release(pIUpsKrn);
pIUpsKrn=NULL;
delete pBoa;
delete pOrb;
return(0);
}