/* ------------------------------------------------------------------- */
/* Fichier    : objkrn.cpp                                             */
/* Objet      : Exemple d'emploi d'Up ! Corba.                         */
/*                                                                     */                                                                     
/* Module      : Up ! Appplication System.                             */
/* Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.                    */
/* ------------------------------------------------------------------- */
/*                          Observations                               */
/*                                                                     */
/*                                                                     */
/* ------------------------------------------------------------------- */

#include <CORBA.h>
#include <mico/string.h>
#include <upskrn.hh>
#include <upssys.hh>
#include <upscrbexception.h>

using namespace std;

static CORBA::ORB *pOrb;
static CORBA::BOA *pBoa;
static CORBA::Object *pObjet;
static IUpsKrn *pIUpsKrn;
static IUpsSys *pIUpsSys;

/****************************************************************/
int main(int argc, char *argv[])
/****************************************************************/
{
IUpsKrnCaractere_var A;
IUpsKrnEntier_var L;
IUpsSysFichier_var Map;

pOrb=CORBA::ORB_init(argc,argv,"mico-local-orb");
if (!pOrb)
   return(1);
pBoa=pOrb->BOA_init(argc, argv, "mico-local-boa");
if (!pBoa)
   return(1);
pObjet=pOrb->bind("IDL:IUpsKrn:1.0");
if (!pObjet)
   return(1);
pIUpsKrn=IUpsKrn::_narrow(pObjet);
if (!pIUpsKrn)
   return(1);
pObjet=pOrb->bind("IDL:IUpsSys:1.0");
if (!pObjet)
   return(1);
pIUpsSys=IUpsSys::_narrow(pObjet);
if (!pIUpsSys)
   return(1);

try
   {
   pIUpsSys->Ecran()->Ecrire3(pIUpsKrn->CorbaString2Caractere("Entrer une ligne :"));
   L=pIUpsSys->Clavier()->LireUneLigne(A, pIUpsKrn->CorbaLong2Entier(50));
   pIUpsSys->Ecran()->Ecrire3(pIUpsKrn->CorbaString2Caractere("Ligne lue : ")->Additionner(A)->Additionner(pIUpsKrn->CorbaString2Caractere(" de taille "))->Additionner(pIUpsKrn->Caractere5(L)));
   pIUpsSys->Journal()->Ecrire3(pIUpsKrn->CorbaString2Caractere("Ligne lue : ")->Additionner(A)->Additionner(pIUpsKrn->CorbaString2Caractere(" de taille "))->Additionner(pIUpsKrn->Caractere5(L)));
   Map=pIUpsSys->MiseAuPoint();
   if (!pIUpsKrn->EstNul((IUpsKrnObjet *)&(*Map)))
      Map->Ecrire3(pIUpsKrn->CorbaString2Caractere("Ligne lue : ")->Additionner(A)->Additionner(pIUpsKrn->CorbaString2Caractere(" de taille "))->Additionner(pIUpsKrn->Caractere5(L)));
   pIUpsSys->Imprimante()->Ecrire3(pIUpsKrn->CorbaString2Caractere("Ligne lue : ")->Additionner(A)->Additionner(pIUpsKrn->CorbaString2Caractere(" de taille "))->Additionner(pIUpsKrn->Caractere5(L)));
   pIUpsSys->Imprimante()->Vider();
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   return(1);   
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   return(1);   
   }

A=NULL;
L=NULL;
Map=NULL;
CORBA::release(pIUpsSys);
pIUpsSys=NULL;
CORBA::release(pIUpsKrn);
pIUpsKrn=NULL;
delete pBoa;
delete pOrb;
return(0);
}