/* ------------------------------------------------------------------- */
/* Fichier    : nls.cpp                                                */
/* Objet      : Exemple d'emploi d'Up ! Corba.                         */
/*                                                                     */                                                                     
/* Module      : Up ! Appplication System.                             */
/* Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.                    */
/* ------------------------------------------------------------------- */
/*                          Observations                               */
/*                                                                     */
/*                                                                     */
/* ------------------------------------------------------------------- */

#include <CORBA.h>
#include <mico/string.h>
#include <upskrn.hh>
#include <upsnls.hh>
#include <upscrbexception.h>

using namespace std;

static const CORBA::UShort CO_SectionDivers=1;
static const CORBA::UShort CO_SectionLibelleMessage=2;
static const CORBA::UShort CO_SectionLibelleParametre=3;
static const CORBA::UShort CO_SectionLibelleInstruction=4;
static const CORBA::UShort CO_SectionAide=5;
static const CORBA::UShort CO_SectionLibelleRegle=6;

static const CORBA::UShort CO_PaysAllemagne=1;
static const CORBA::UShort CO_PaysAngleterre=2;
static const CORBA::UShort CO_PaysChine=3;
static const CORBA::UShort CO_PaysCoreeSud=4;
static const CORBA::UShort CO_PaysDanemark=5;
static const CORBA::UShort CO_PaysEspagne=6;
static const CORBA::UShort CO_PaysEtatsUnis=7;
static const CORBA::UShort CO_PaysFinlande=8;
static const CORBA::UShort CO_PaysFrance=9;
static const CORBA::UShort CO_PaysGrece=10;
static const CORBA::UShort CO_PaysHollande=11;
static const CORBA::UShort CO_PaysIsrael=12;
static const CORBA::UShort CO_PaysItalie=13;
static const CORBA::UShort CO_PaysJapon=14;
static const CORBA::UShort CO_PaysNorvege=15;
static const CORBA::UShort CO_PaysPologne=16;
static const CORBA::UShort CO_PaysPortugal=17;
static const CORBA::UShort CO_PaysRussie=18;
static const CORBA::UShort CO_PaysSuede=19;
static const CORBA::UShort CO_PaysSuisse=20;

static const CORBA::UShort CO_PageUs7Ascii=1;
static const CORBA::UShort CO_PageWE8Iso8859P1=2;
static const CORBA::UShort CO_PageEE8Iso8859P2=3;
static const CORBA::UShort CO_PageWE8Iso8859P9=4;
static const CORBA::UShort CO_PageNE8Iso8859P10=5;
static const CORBA::UShort CO_PageUs8Pc437=6;
static const CORBA::UShort CO_PageWE8Pc850=7;
static const CORBA::UShort CO_PageUS8Pc852=8;
static const CORBA::UShort CO_PageWE8Pc857=9;
static const CORBA::UShort CO_PageWE8MacRoman8=10;
static const CORBA::UShort CO_PageWE8Windows1=11;
static const CORBA::UShort CO_PageEE8Windows2=12;
static const CORBA::UShort CO_PageWE8Ebcdic297=13;
static const CORBA::UShort CO_PageWE8Ebcdic500=14;
static const CORBA::UShort CO_PageWE8Ebcdic037=15;
static const CORBA::UShort CO_PageWE8Ebcdic260=16;

static const CORBA::UShort CO_FuseauEniwetokKwajalein=1;
static const CORBA::UShort CO_FuseauMidwaySamoa=2;
static const CORBA::UShort CO_FuseauHawai=3;
static const CORBA::UShort CO_FuseauAlaska=4;
static const CORBA::UShort CO_FuseauTijuana=5;
static const CORBA::UShort CO_FuseauArizona=6;
static const CORBA::UShort CO_FuseauRocheuseAmerique=7;
static const CORBA::UShort CO_FuseauCentreAmerique=8;
static const CORBA::UShort CO_FuseauMexicoTegucigalpa=9;
static const CORBA::UShort CO_FuseauSaskatchevan=10;
static const CORBA::UShort CO_FuseauBogotaLimaQuito=11;
static const CORBA::UShort CO_FuseauEstAmerique=12;
static const CORBA::UShort CO_FuseauIndiana=13;
static const CORBA::UShort CO_FuseauAtlantique=14;
static const CORBA::UShort CO_FuseauCaracasLaPaz=15;
static const CORBA::UShort CO_FuseauTerreNeuve=16;
static const CORBA::UShort CO_FuseauBresil=17;
static const CORBA::UShort CO_FuseauBuenosAiresGeorgeTown=18;
static const CORBA::UShort CO_FuseauMilieuAtlantique=19;
static const CORBA::UShort CO_FuseauAcoresCapVert=20;
static const CORBA::UShort CO_FuseauCasablancaMonrovia=21;
static const CORBA::UShort CO_FuseauGreenwich=22;
static const CORBA::UShort CO_FuseauAmsterdamBerlinBernRome=23;
static const CORBA::UShort CO_FuseauBelgradeBudapestPrague=24;
static const CORBA::UShort CO_FuseauBruxellesMadridParis=25;
static const CORBA::UShort CO_FuseauSarajevoSofiaVarsovie=26;
static const CORBA::UShort CO_FuseauAthenesIstanbulMinsk=27;
static const CORBA::UShort CO_FuseauBucarest=28;
static const CORBA::UShort CO_FuseauCaire=29;
static const CORBA::UShort CO_FuseauPretoria=30;
static const CORBA::UShort CO_FuseauHelsinkiRigaTallinn=31;
static const CORBA::UShort CO_FuseauIsrael=32;
static const CORBA::UShort CO_FuseauBagdhadKoweitRiyadh=33;
static const CORBA::UShort CO_FuseauMoscouStPetersbourg=34;
static const CORBA::UShort CO_FuseauNairobi=35;
static const CORBA::UShort CO_FuseauTeheran=36;
static const CORBA::UShort CO_FuseauAbuDhabiMuscat=37;
static const CORBA::UShort CO_FuseauBakouTbilisi=38;
static const CORBA::UShort CO_FuseauKabul=39;
static const CORBA::UShort CO_FuseauEkaterinburg=40;
static const CORBA::UShort CO_FuseauIsmalabadKarachiTaschkent=41;
static const CORBA::UShort CO_FuseauBombayCalcuttaNewDelhi=42;
static const CORBA::UShort CO_FuseauAlmatyDhaka=43;
static const CORBA::UShort CO_FuseauColombo=44;
static const CORBA::UShort CO_FuseauBangkokHanoiJakarta=45;
static const CORBA::UShort CO_FuseauPekinHongKongUrumqi=46;
static const CORBA::UShort CO_FuseauPerth=47;
static const CORBA::UShort CO_FuseauSingapour=48;
static const CORBA::UShort CO_FuseauCeylan=49;
static const CORBA::UShort CO_FuseauOsakaSapporoTokyo=50;
static const CORBA::UShort CO_FuseauSeoul=51;
static const CORBA::UShort CO_FuseauYakutsk=52;
static const CORBA::UShort CO_FuseauAdelaide=53;
static const CORBA::UShort CO_FuseauDarwin=54;
static const CORBA::UShort CO_FuseauBrisbane=55;
static const CORBA::UShort CO_FuseauCanberraMelbourneSydney=56;
static const CORBA::UShort CO_FuseauGuamPortMoresby=57;
static const CORBA::UShort CO_FuseauHobart=58;
static const CORBA::UShort CO_FuseauVladivostok=59;
static const CORBA::UShort CO_FuseauMagadanSalomonNouvelleCaledonie=60;
static const CORBA::UShort CO_FuseauAucklandWellington=61;
static const CORBA::UShort CO_FuseauFijiKamchatkaMarshall=62;

static const CORBA::UShort CO_MetriqueMetre=1;
static const CORBA::UShort CO_MetriqueYard=2;

static const CORBA::UShort CO_SousMetriqueCentiMetre=1;
static const CORBA::UShort CO_SousMetriquePouce=2;
static const CORBA::UShort CO_SousMetriquePied=3;

static const CORBA::UShort CO_SubMetriqueKiloMetre=1;
static const CORBA::UShort CO_SubMetriqueMilleTerrestre=2;
static const CORBA::UShort CO_SubMetriqueMilleMarin=3;

static const CORBA::UShort CO_PoidsKiloGramme=1;
static const CORBA::UShort CO_PoidsLivre=2;
static const CORBA::UShort CO_PoidsOnce=3;

static const CORBA::UShort CO_TemperatureKelvin=1;
static const CORBA::UShort CO_TemperatureCelsius=2;
static const CORBA::UShort CO_TemperatureFahrenheit=3;

static const CORBA::UShort CO_AngleRadian=1;
static const CORBA::UShort CO_AngleDegres=2;
static const CORBA::UShort CO_AngleGrade=3;

static CORBA::ORB *pOrb;
static CORBA::BOA *pBoa;
static CORBA::Object *pObjet;
static IUpsKrn *pIUpsKrn;
static IUpsSys *pIUpsSys;
static IUpsNls *pIUpsNls;

/****************************************************************/
int main(int argc, char *argv[])
/****************************************************************/
{
IUpsKrnCaractere_var C;

pOrb=CORBA::ORB_init(argc,argv,"mico-local-orb");
if (!pOrb)
   return(1);
pBoa=pOrb->BOA_init(argc, argv, "mico-local-boa");
if (!pBoa)
   return(1);
pObjet=pOrb->bind("IDL:IUpsKrn:1.0");
if (!pObjet)
   return(1);
pIUpsKrn=IUpsKrn::_narrow(pObjet);
if (!pIUpsKrn)
   return(1);
pObjet=pOrb->bind("IDL:IUpsSys:1.0");
if (!pObjet)
   return(1);
pIUpsSys=IUpsSys::_narrow(pObjet);
if (!pIUpsSys)
   return(1);
pObjet=pOrb->bind("IDL:IUpsNls:1.0");
if (!pObjet)
   return(1);
pIUpsNls=IUpsNls::_narrow(pObjet);
if (!pIUpsNls)
   return(1);

try
   {
   if (pIUpsNls->Pays()==CO_PaysFrance)
      cout << "Pays==PaysFrance" << endl;
   else
      cout << "Pays!=PaysFrance" << endl;
   if (pIUpsNls->PageDeCode()==CO_PageWE8Iso8859P1)
      cout << "PageDeCode==PageWE8Iso8859P1" << endl;
   else
      cout << "PageDeCode!=PageWE8Iso8859P1" << endl;
   if (pIUpsNls->FuseauHoraire()==CO_FuseauBruxellesMadridParis)
      cout << "FuseauHoraire==FuseauBruxellesMadridParis" << endl;
   else
      cout << "FuseauHoraire!=FuseauBruxellesMadridParis" << endl;
   if (pIUpsNls->Metrique()==CO_MetriqueMetre)
      cout << "Metrique==MetriqueMetre" << endl;
   else
      cout << "Metrique!=MetriqueMetre" << endl;
   if (pIUpsNls->SousMetrique()==CO_SousMetriqueCentiMetre)
      cout << "SousMetrique==MetriqueCentiMetre" << endl;
   else
      cout << "SousMetrique!=MetriqueCentiMetre" << endl;
   if (pIUpsNls->SubMetrique()==CO_SubMetriqueKiloMetre)
      cout << "SubMetrique==SubMetriqueKiloMetre" << endl;
   else
      cout << "SubMetrique!=SubMetriqueKiloMetre" << endl;
   if (pIUpsNls->Poids()==CO_PoidsKiloGramme)
      cout << "Poids==PoidsKiloGramme" << endl;
   else
      cout << "Poids!=PoidsKiloGramme" << endl;
   if (pIUpsNls->Temperature()==CO_TemperatureCelsius)
      cout << "Temperature==TemperatureCelsius" << endl;
   else
      cout << "Temperature!=TemperatureCelsius" << endl;
   if (pIUpsNls->Angle()==CO_AngleDegres)
      cout << "Angle==AngleDegres" << endl;
   else
      cout << "Angle!=AngleDegres" << endl;

   cout << "SymboleDecimale=" << pIUpsKrn->Caractere2CorbaString(pIUpsNls->SymboleDecimale()) << endl;
   cout << "SymboleVirgule=" << pIUpsKrn->Caractere2CorbaString(pIUpsNls->SymboleVirgule()) << endl;
   cout << "SymboleMonetaire=" << pIUpsKrn->Caractere2CorbaString(pIUpsNls->SymboleMonetaire()) << endl;
   cout << "SymboleMetrique=" << pIUpsKrn->Caractere2CorbaString(pIUpsNls->SymboleMetrique()) << endl;
   cout << "SymboleSousMetrique=" << pIUpsKrn->Caractere2CorbaString(pIUpsNls->SymboleSousMetrique()) << endl;
   cout << "SymboleSubMetrique=" << pIUpsKrn->Caractere2CorbaString(pIUpsNls->SymboleSubMetrique()) << endl;
   cout << "SymbolePoids=" << pIUpsKrn->Caractere2CorbaString(pIUpsNls->SymbolePoids()) << endl;
   cout << "SymboleTemperature=" << pIUpsKrn->Caractere2CorbaString(pIUpsNls->SymboleTemperature()) << endl;
   cout << "SymboleAngle=" << pIUpsKrn->Caractere2CorbaString(pIUpsNls->SymboleAngle()) << endl;
   cout << "UniteMonetaire=" << pIUpsKrn->Caractere2CorbaString(pIUpsNls->UniteMonetaire()) << endl;
   cout << "UniteMetrique=" << pIUpsKrn->Caractere2CorbaString(pIUpsNls->UniteMetrique()) << endl;
   cout << "UniteSousMetrique=" << pIUpsKrn->Caractere2CorbaString(pIUpsNls->UniteSousMetrique()) << endl;
   cout << "UniteSubMetrique=" << pIUpsKrn->Caractere2CorbaString(pIUpsNls->UniteSubMetrique()) << endl;
   cout << "UnitePoids=" << pIUpsKrn->Caractere2CorbaString(pIUpsNls->UnitePoids()) << endl;
   cout << "UniteTemperature=" << pIUpsKrn->Caractere2CorbaString(pIUpsNls->UniteTemperature()) << endl;
   cout << "UniteAngle=" << pIUpsKrn->Caractere2CorbaString(pIUpsNls->UniteAngle()) << endl;

   cout << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere5(pIUpsKrn->CorbaLong2Entier(12345))) << endl;
   cout << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(12345.67))) << endl;
   cout << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere6(pIUpsKrn->CorbaLong2Entier(12345), pIUpsNls->FiltreMonnaieEntier())) << endl;
   cout << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere9(pIUpsKrn->CorbaDouble2Reel(12345.67), pIUpsNls->FiltreMonnaieReel())) << endl;
   cout << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere3(pIUpsSys->DateSysteme())) << endl;
   cout << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere4(pIUpsSys->DateSysteme(), pIUpsNls->FiltreDate())) << endl;
   cout << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere4(pIUpsSys->DateSysteme(), pIUpsNls->FiltreHeure())) << endl;

   cout << "Le cours du Dollar=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->UnDollar()))) << endl;
   cout << "Le cours de la Livre=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->UneLivre()))) << endl;
   cout << "Le cours du Yen=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->CentYens()))) << endl;
   cout << "Le cours de l'Euro=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->UnEuro()))) << endl;

   C=pIUpsNls->ConvertirPageDeCode(pIUpsKrn->CorbaString2Caractere("Bonjour le monde"), CO_PageWE8Windows1);
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   cout << "Heure de Paris=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere3(pIUpsNls->ChangerFuseauHoraire(pIUpsSys->DateSysteme(), pIUpsNls->FuseauHoraire(), 
      CO_FuseauBruxellesMadridParis))) << endl;
   cout << "Heure de New York=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere3(pIUpsNls->ChangerFuseauHoraire(pIUpsSys->DateSysteme(), pIUpsNls->FuseauHoraire(), 
      CO_FuseauEstAmerique))) << endl;
   cout << "1 m en yd=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirMetrique(1.0, CO_MetriqueMetre, CO_MetriqueYard)))) << endl;
   cout << "1 yd en m=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirMetrique(1.0, CO_MetriqueYard, CO_MetriqueMetre)))) << endl;
   cout << "1 cm en ''=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirSousMetrique(1.0, CO_SousMetriqueCentiMetre, CO_SousMetriquePouce)))) << endl;
   cout << "1 cm en '=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirSousMetrique(1.0, CO_SousMetriqueCentiMetre, CO_SousMetriquePied)))) << endl;
   cout << "1 '' en cm=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirSousMetrique(1.0, CO_SousMetriquePouce, CO_SousMetriqueCentiMetre)))) << endl;
   cout << "1 '' en '=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirSousMetrique(1.0, CO_SousMetriquePouce, CO_SousMetriquePied)))) << endl;
   cout << "1 ' en cm=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirSousMetrique(1.0, CO_SousMetriquePied, CO_SousMetriqueCentiMetre)))) << endl;
   cout << "1 ' en ''=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirSousMetrique(1.0, CO_SousMetriquePied, CO_SousMetriquePouce)))) << endl;
   cout << "1 km en m terrestre=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirSubMetrique(1.0, CO_SubMetriqueKiloMetre, CO_SubMetriqueMilleTerrestre)))) << endl;
   cout << "1 km en m marin=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirSubMetrique(1.0, CO_SubMetriqueKiloMetre, CO_SubMetriqueMilleMarin)))) << endl;
   cout << "1 m terrestre en km=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirSubMetrique(1.0, CO_SubMetriqueMilleTerrestre, CO_SubMetriqueKiloMetre)))) << endl;
   cout << "1 m terrestre en m marin=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirSubMetrique(1.0, CO_SubMetriqueMilleTerrestre, CO_SubMetriqueMilleMarin)))) << endl;
   cout << "1 m marin en km=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirSubMetrique(1.0, CO_SubMetriqueMilleMarin, CO_SubMetriqueKiloMetre)))) << endl;
   cout << "1 m marin en m terrestre=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirSubMetrique(1.0, CO_SubMetriqueMilleMarin, CO_SubMetriqueMilleTerrestre)))) << endl;
   cout << "1 kg en lb=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirPoids(1.0, CO_PoidsKiloGramme, CO_PoidsLivre)))) << endl;
   cout << "1 kg en oz=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirPoids(1.0, CO_PoidsKiloGramme, CO_PoidsOnce)))) << endl;
   cout << "1 lb en kg=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirPoids(1.0, CO_PoidsLivre, CO_PoidsKiloGramme)))) << endl;
   cout << "1 lb en kg=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirPoids(1.0, CO_PoidsLivre, CO_PoidsOnce)))) << endl;
   cout << "1 oz en kg=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirPoids(1.0, CO_PoidsOnce, CO_PoidsKiloGramme)))) << endl;
   cout << "1 oz en lb=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirPoids(1.0, CO_PoidsOnce, CO_PoidsLivre)))) << endl;
   cout << "0 K en C=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirTemperature(0.0, CO_TemperatureKelvin, CO_TemperatureCelsius)))) << endl;
   cout << "0 K en F=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirTemperature(0.0, CO_TemperatureKelvin, CO_TemperatureFahrenheit)))) << endl;
   cout << "0 C en K=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirTemperature(0.0, CO_TemperatureCelsius, CO_TemperatureKelvin)))) << endl;
   cout << "0 C en F=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirTemperature(0.0, CO_TemperatureCelsius, CO_TemperatureFahrenheit)))) << endl;
   cout << "0 F en K=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirTemperature(0.0, CO_TemperatureFahrenheit, CO_TemperatureKelvin)))) << endl;
   cout << "0 F en C=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirTemperature(0.0, CO_TemperatureFahrenheit, CO_TemperatureCelsius)))) << endl;
   cout << "Pi rad en =" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirAngle(3.1416, CO_AngleRadian, CO_AngleDegres)))) << endl;
   cout << "Pi rad en gr=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirAngle(3.1416, CO_AngleRadian, CO_AngleGrade)))) << endl;
   cout << "90  en rad=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirAngle(90.0, CO_AngleDegres, CO_AngleRadian)))) << endl;
   cout << "90  en gr=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirAngle(90.0, CO_AngleDegres, CO_AngleGrade)))) << endl;
   cout << "100 gr en rad=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirAngle(100.0, CO_AngleGrade, CO_AngleRadian)))) << endl;
   cout << "100 gr en =" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirAngle(100.0, CO_AngleGrade, CO_AngleDegres)))) << endl;
   cout << "1 cm en m=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirSousMetriqueEnMetrique(1.0, CO_SousMetriqueCentiMetre, CO_MetriqueMetre)))) << endl;
   cout << "1 '' en m=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirSousMetriqueEnMetrique(1.0, CO_SousMetriquePouce, CO_MetriqueMetre)))) << endl;
   cout << "1 ' en m=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirSousMetriqueEnMetrique(1.0, CO_SousMetriquePied, CO_MetriqueMetre)))) << endl;
   cout << "1 m en cm=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirMetriqueEnSousMetrique(1.0, CO_MetriqueMetre, CO_SousMetriqueCentiMetre)))) << endl;
   cout << "1 m en ''=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirMetriqueEnSousMetrique(1.0, CO_MetriqueMetre, CO_SousMetriquePouce)))) << endl;
   cout << "1 m en '=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirMetriqueEnSousMetrique(1.0, CO_MetriqueMetre, CO_SousMetriquePied)))) << endl;
   cout << "1 km en m=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirSubMetriqueEnMetrique(1.0, CO_SubMetriqueKiloMetre, CO_MetriqueMetre)))) << endl;
   cout << "1 m terrestre en m=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirSubMetriqueEnMetrique(1.0, CO_SubMetriqueMilleTerrestre, CO_MetriqueMetre)))) << endl;
   cout << "1 m marin en m=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirSubMetriqueEnMetrique(1.0, CO_SubMetriqueMilleMarin, CO_MetriqueMetre)))) << endl;
   cout << "1 m en km=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirMetriqueEnSubMetrique(1.0, CO_MetriqueMetre, CO_SubMetriqueKiloMetre)))) << endl;
   cout << "1 m en m terrestre=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirMetriqueEnSubMetrique(1.0, CO_MetriqueMetre, CO_SubMetriqueMilleTerrestre)))) << endl;
   cout << "1 m en m marin=" << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(pIUpsNls->ConvertirMetriqueEnSubMetrique(1.0, CO_MetriqueMetre, CO_SubMetriqueMilleMarin)))) << endl;

   cout << pIUpsKrn->Caractere2CorbaString(pIUpsNls->Message(pIUpsKrn->UpsKrn(), pIUpsKrn->CorbaString2Caractere("Bonjour"), (IUpsKrnCaractere *)pIUpsKrn->ObjetNul(), (IUpsKrnCaractere *)pIUpsKrn->ObjetNul(), (IUpsKrnCaractere *)pIUpsKrn->ObjetNul(), (IUpsKrnCaractere *)pIUpsKrn->ObjetNul(), (IUpsKrnCaractere *)pIUpsKrn->ObjetNul())) << endl;
   cout << pIUpsKrn->Caractere2CorbaString(pIUpsNls->Traduire(pIUpsKrn->UpsKrn(), CO_SectionDivers, pIUpsKrn->CorbaString2Caractere("MerveilleuxUps"))) << endl;
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   return(1);   
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   return(1);   
   }

C=NULL;
CORBA::release(pIUpsNls);
pIUpsNls=NULL;
CORBA::release(pIUpsSys);
pIUpsSys=NULL;
CORBA::release(pIUpsKrn);
pIUpsKrn=NULL;
delete pBoa;
delete pOrb;
return(0);
}