/* ------------------------------------------------------------------- */
/* Fichier    : math.cpp                                               */
/* Objet      : Exemple d'emploi d'Up ! Corba.                         */
/*                                                                     */                                                                     
/* Module      : Up ! Appplication System.                             */
/* Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.                    */
/* ------------------------------------------------------------------- */
/*                          Observations                               */
/*                                                                     */
/*                                                                     */
/* ------------------------------------------------------------------- */

#include <CORBA.h>
#include <mico/string.h>
#include <upskrn.hh>
#include <upsmat.hh>
#include <upscrbexception.h>

using namespace std;

static CORBA::ORB *pOrb;
static CORBA::BOA *pBoa;
static CORBA::Object *pObjet;
static IUpsKrn *pIUpsKrn;
static IUpsMat *pIUpsMat;

/****************************************************************/
int main(int argc, char *argv[])
/****************************************************************/
{
pOrb=CORBA::ORB_init(argc,argv,"mico-local-orb");
if (!pOrb)
   return(1);
pBoa=pOrb->BOA_init(argc, argv, "mico-local-boa");
if (!pBoa)
   return(1);
pObjet=pOrb->bind("IDL:IUpsKrn:1.0");
if (!pObjet)
   return(1);
pIUpsKrn=IUpsKrn::_narrow(pObjet);
if (!pIUpsKrn)
   return(1);
pObjet=pOrb->bind("IDL:IUpsMat:1.0");
if (!pObjet)
   return(1);
pIUpsMat=IUpsMat::_narrow(pObjet);
if (!pIUpsMat)
   return(1);

try
   {
   cout << "Abs(-10)=" << endl;
   cout << pIUpsMat->Abs(-10) << endl;
   cout << "Abs(10.2)=" << endl;
   cout << pIUpsMat->Abs2(10.2) << endl;
   cout << "ACos(0.0)=" << endl;
   cout << pIUpsMat->ACos(0.0) << endl;
   cout << "ASin(0.0)=" << endl;
   cout << pIUpsMat->ASin(0.0) << endl;
   cout << "ATan(0.0)=" << endl;
   cout << pIUpsMat->ATan(0.0) << endl;
   cout << "Cos(0.0)=" << endl;
   cout << pIUpsMat->Cos(0.0) << endl;
   cout << "Sin(0.0)=" << endl;
   cout << pIUpsMat->Sin(0.0) << endl;
   cout << "Tan(0.0)=" << endl;
   cout << pIUpsMat->Tan(0.0) << endl;
   cout << "ACosH(1.0)=" << endl;
   cout << pIUpsMat->ACosH(1.0) << endl;
   cout << "ASinH(1.0)=" << endl;
   cout << pIUpsMat->ASinH(1.0) << endl;
   cout << "ATanH(10.0)=" << endl;
   cout << pIUpsMat->ATanH(10.0) << endl;
   cout << "CosH(0.0)=" << endl;
   cout << pIUpsMat->CosH(0.0) << endl;
   cout << "SinH(0.0)=" << endl;
   cout << pIUpsMat->SinH(0.0) << endl;
   cout << "TanH(0.0)=" << endl;
   cout << pIUpsMat->TanH(0.0) << endl;
   cout << "Exp(1.0)=" << endl;
   cout << pIUpsMat->Exp(1.0) << endl;
   cout << "Log(10.0)=" << endl;
   cout << pIUpsMat->Log(10.0) << endl;
   cout << "Log10(10.0)=" << endl;
   cout << pIUpsMat->Log10(10.0) << endl;
   cout << "Racine(4.0)=" << endl;
   cout << pIUpsMat->Racine2(4.0) << endl;
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   return(1);   
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   return(1);   
   }

CORBA::release(pIUpsMat);
pIUpsMat=NULL;
CORBA::release(pIUpsKrn);
pIUpsKrn=NULL;
delete pBoa;
delete pOrb;
return(0);
}