/* ------------------------------------------------------------------- */
/* Fichier    : liste.cpp                                              */
/* Objet      : Exemple d'emploi d'Up ! Corba.                         */
/*                                                                     */                                                                     
/* Module      : Up ! Appplication System.                             */
/* Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.                    */
/* ------------------------------------------------------------------- */
/*                          Observations                               */
/*                                                                     */
/*                                                                     */
/* ------------------------------------------------------------------- */

#include <CORBA.h>
#include <mico/string.h>
#include <upskrn.hh>
#include <upscrbexception.h>

using namespace std;

static const CORBA::UShort CO_ClonageObjetSeul=1;
static const CORBA::UShort CO_ClonageObjetsDirects=2;
static const CORBA::UShort CO_ClonageRecursif=3;

static CORBA::ORB *pOrb;
static CORBA::BOA *pBoa;
static CORBA::Object *pObjet;
static IUpsKrn *pIUpsKrn;

/****************************************************************/
static void EcrireListe(IUpsKrnCaractere *M, IUpsKrnListe *L)
/****************************************************************/
{
IUpsKrnCaractere_var C;

try
   {
   cout << pIUpsKrn->Caractere2CorbaString(M) << endl;
   C=(IUpsKrnCaractere *)L->ParcoursAuDebut(0);
   for (;;)
      {
      cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
      if (C->Identique(L->DernierElement()))
         break;
      C=(IUpsKrnCaractere *)L->Suivant(0);
      }
   cout << endl;
   cout << endl;
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   }
}

/****************************************************************/
static void EcrireListeInverse(IUpsKrnCaractere *M, IUpsKrnListe *L)
/****************************************************************/
{
IUpsKrnCaractere_var C;
CORBA::Long I;

try
   {
   cout << pIUpsKrn->Caractere2CorbaString(M) << endl;
   I=L->AllouerIterateur();
   C=(IUpsKrnCaractere *)L->ParcoursALaFin(I);
   for (;;)
      {
      cout << pIUpsKrn->Caractere2CorbaString((IUpsKrnCaractere *)L->Element(I)) << endl;
      if (C->Identique(L->PremierElement()))
         break;
      C=(IUpsKrnCaractere *)L->Precedent(I);
      }
   L->LibererIterateur(I);
   cout << endl;
   cout << endl;
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   }
}

/****************************************************************/
int main(int argc, char *argv[])
/****************************************************************/
{
IUpsKrnListe_var L;
IUpsKrnListe_var L2;
IUpsKrnCaractere_var A;
IUpsKrnCaractere_var B;
IUpsKrnCaractere_var C;
IUpsKrnCaractere_var D;
IUpsKrnCaractere_var E;
IUpsKrnCaractere_var F;
IUpsKrnCaractere_var G;
IUpsKrnCaractere_var H;

pOrb=CORBA::ORB_init(argc,argv,"mico-local-orb");
if (!pOrb)
   return(1);
pBoa=pOrb->BOA_init(argc, argv, "mico-local-boa");
if (!pBoa)
   return(1);
pObjet=pOrb->bind("IDL:IUpsKrn:1.0");
if (!pObjet)
   return(1);
pIUpsKrn=IUpsKrn::_narrow(pObjet);
if (!pIUpsKrn)
   return(1);

try
   {
   L=pIUpsKrn->Liste1((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("A"));
   L=L->Additionner((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("B"));
   L->AdditionnerAffecter((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("C"));
   L->AdditionnerAffecter((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("D"));
   L->AdditionnerAffecter((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("E"));
   L->AdditionnerAffecter((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("F"));
   L->AdditionnerAffecter((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("G"));
   L->AdditionnerAffecter((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("H"));
   L->AdditionnerAffecter((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("I"));
   EcrireListe(pIUpsKrn->CorbaString2Caractere("Suivant()"), L);
   EcrireListeInverse(pIUpsKrn->CorbaString2Caractere("Precedent()"), L);
   EcrireListe(pIUpsKrn->CorbaString2Caractere("-()"), L->Soustraire());
   EcrireListe(pIUpsKrn->CorbaString2Caractere("Gauche(3)"), ((IUpsKrnListe *)L->Cloner((IUpsKrnEntrepot *)pIUpsKrn->ObjetNul(), CO_ClonageObjetSeul))->Gauche(pIUpsKrn->CorbaLong2Entier(3)));
   EcrireListe(pIUpsKrn->CorbaString2Caractere("Droite(3)"), ((IUpsKrnListe *)L->Cloner((IUpsKrnEntrepot *)pIUpsKrn->ObjetNul(), CO_ClonageObjetSeul))->Droite(pIUpsKrn->CorbaLong2Entier(3)));
   EcrireListe(pIUpsKrn->CorbaString2Caractere("Milieu(2,3)"), ((IUpsKrnListe *)L->Cloner((IUpsKrnEntrepot *)pIUpsKrn->ObjetNul(), CO_ClonageObjetSeul))->Milieu(pIUpsKrn->CorbaLong2Entier(2), pIUpsKrn->CorbaLong2Entier(3)));
   C=pIUpsKrn->CorbaString2Caractere("a");
   L2=pIUpsKrn->Liste1((IUpsKrnObjet *)&(*C));
   L2->AdditionnerAffecter((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("b"));
   L2->AdditionnerAffecter((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("c"));
   L2->AdditionnerAffecter((IUpsKrnObjet *)&(*C));
   L2->AdditionnerAffecter((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("b"));
   L2->AdditionnerAffecter((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("c"));
   EcrireListe(pIUpsKrn->CorbaString2Caractere("Inserer(2)"), ((IUpsKrnListe *)L->Cloner((IUpsKrnEntrepot *)pIUpsKrn->ObjetNul(), CO_ClonageObjetSeul))->Inserer(L2, pIUpsKrn->CorbaLong2Entier(2)));
   cout << "Compter(0)" << endl;
   cout << pIUpsKrn->Entier2CorbaLong(L2->Compter((IUpsKrnObjet *)&(*C), pIUpsKrn->CorbaLong2Entier(0))) << endl;
   cout << endl;
   cout << endl;
   cout << "Compter(1)" << endl;
   cout << pIUpsKrn->Entier2CorbaLong(L2->Compter((IUpsKrnObjet *)&(*C), pIUpsKrn->CorbaLong2Entier(2))) << endl;
   cout << endl;
   cout << endl;
   EcrireListe(pIUpsKrn->CorbaString2Caractere("Remplacer(0)"), L2->RemplacerTous((IUpsKrnObjet *)&(*C), (IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("x"), pIUpsKrn->CorbaLong2Entier(0)));
   EcrireListe(pIUpsKrn->CorbaString2Caractere("Remplacer(1)"), L2->RemplacerTous((IUpsKrnObjet *)&(*C), (IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("x"), pIUpsKrn->CorbaLong2Entier(1)));
   cout << "Rechercher(0)" << endl;
   cout << pIUpsKrn->Entier2CorbaLong(L2->Rechercher((IUpsKrnObjet *)&(*C), pIUpsKrn->CorbaLong2Entier(0))) << endl;
   cout << endl;
   cout << endl;
   cout << "Rechercher(1)" << endl;
   cout << pIUpsKrn->Entier2CorbaLong(L2->Rechercher((IUpsKrnObjet *)&(*C), pIUpsKrn->CorbaLong2Entier(1))) << endl;
   cout << endl;
   cout << endl;
   EcrireListe(pIUpsKrn->CorbaString2Caractere("Supprimer(0)"), L2->SupprimerTous((IUpsKrnObjet *)&(*C), pIUpsKrn->CorbaLong2Entier(0)));
   EcrireListe(pIUpsKrn->CorbaString2Caractere("Supprimer(1)"), L2->SupprimerTous((IUpsKrnObjet *)&(*C), pIUpsKrn->CorbaLong2Entier(1)));
   cout << "L[0]" << endl;
   cout << pIUpsKrn->Caractere2CorbaString((IUpsKrnCaractere *)L->Index(pIUpsKrn->CorbaLong2Entier(0))) << endl;
   cout << "L[2]" << endl;
   cout << pIUpsKrn->Caractere2CorbaString((IUpsKrnCaractere *)L->Index(pIUpsKrn->CorbaLong2Entier(2))) << endl;
   cout << "PremierElement()" << endl;
   cout << pIUpsKrn->Caractere2CorbaString((IUpsKrnCaractere *)L->PremierElement()) << endl;
   cout << "DernierElement()" << endl;
   cout << pIUpsKrn->Caractere2CorbaString((IUpsKrnCaractere *)L->DernierElement()) << endl;
   cout << "NumeroElement()" << endl;
   cout << pIUpsKrn->Entier2CorbaLong(L->NumeroElement(0)) << endl;;
   EcrireListe(pIUpsKrn->CorbaString2Caractere("AjouterAuDebut()"), L->AjouterAuDebut((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("X")));
   EcrireListe(pIUpsKrn->CorbaString2Caractere("AjouterALaFin()"), L->AjouterALaFin((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("Y")));
   A=pIUpsKrn->CorbaString2Caractere("A");
   B=pIUpsKrn->CorbaString2Caractere("B");
   C=pIUpsKrn->CorbaString2Caractere("C");
   D=pIUpsKrn->CorbaString2Caractere("D");
   E=pIUpsKrn->CorbaString2Caractere("E");
   F=pIUpsKrn->CorbaString2Caractere("F");
   G=pIUpsKrn->CorbaString2Caractere("G");
   H=pIUpsKrn->CorbaString2Caractere("H");
   L=pIUpsKrn->Liste1((IUpsKrnObjet *)&(*A));
   L->AdditionnerAffecter((IUpsKrnObjet *)&(*B));
   L->AdditionnerAffecter((IUpsKrnObjet *)&(*C));
   L->AdditionnerAffecter((IUpsKrnObjet *)&(*D));
   L->AdditionnerAffecter((IUpsKrnObjet *)&(*E));
   L->AdditionnerAffecter((IUpsKrnObjet *)&(*F));
   L2=pIUpsKrn->Liste1((IUpsKrnObjet *)&(*A));
   L2->AdditionnerAffecter((IUpsKrnObjet *)&(*B));
   L2->AdditionnerAffecter((IUpsKrnObjet *)&(*D));
   L2->AdditionnerAffecter((IUpsKrnObjet *)&(*F));
   L2->AdditionnerAffecter((IUpsKrnObjet *)&(*G));
   L2->AdditionnerAffecter((IUpsKrnObjet *)&(*H));
   EcrireListe(pIUpsKrn->CorbaString2Caractere("Union()"), L->Union_(L2));
   EcrireListe(pIUpsKrn->CorbaString2Caractere("Intersection()"), L->Intersection(L2));
   EcrireListe(pIUpsKrn->CorbaString2Caractere("Soustraction()"), L->Soustraction(L2));
   EcrireListe(pIUpsKrn->CorbaString2Caractere("Exclusion()"), L->Exclusion(L2));
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   return(1);   
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   return(1);   
   }

L=NULL;
L2=NULL;
A=NULL;
B=NULL;
C=NULL;
D=NULL;
E=NULL;
F=NULL;
G=NULL;
H=NULL;
CORBA::release(pIUpsKrn);
pIUpsKrn=NULL;
delete pBoa;
delete pOrb;
return(0);
}