/* ------------------------------------------------------------------- */
/* Fichier    : lisp.cpp                                               */
/* Objet      : Exemple d'emploi d'Up ! Corba.                         */
/*                                                                     */                                                                     
/* Module      : Up ! Appplication System.                             */
/* Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.                    */
/* ------------------------------------------------------------------- */
/*                          Observations                               */
/*                                                                     */
/*                                                                     */
/* ------------------------------------------------------------------- */

#include <CORBA.h>
#include <mico/string.h>
#include <upskrn.hh>
#include <upscrbexception.h>

using namespace std;

static const CORBA::UShort CO_ComparaisonAvant=1;
static const CORBA::UShort CO_ComparaisonEgal=2;
static const CORBA::UShort CO_ComparaisonApres=3;
static const CORBA::UShort CO_ComparaisonNul=4;

static CORBA::ORB *pOrb;
static CORBA::BOA *pBoa;
static CORBA::Object *pObjet;
static IUpsKrn *pIUpsKrn;

/****************************************************************/
static void P1(IUpsKrnCaractere *O)
/****************************************************************/
{
try
   {
   cout << pIUpsKrn->Caractere2CorbaString(O) << endl;
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   }
}

/****************************************************************/
static void P2(IUpsKrnCaractere *O1, IUpsKrnEntier *O2)
/****************************************************************/
{
try
   {
   cout << pIUpsKrn->Caractere2CorbaString(O1->Additionner(pIUpsKrn->CorbaString2Caractere(" "))->Additionner(pIUpsKrn->Caractere5(O2))) << endl;
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   }
}

/****************************************************************/
static IUpsKrnCaractere *F1(IUpsKrnCaractere *O)
/****************************************************************/
{
try
   {
   return(O->Majuscule());
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   }
return(NULL);   
}

/****************************************************************/
static IUpsKrnCaractere *F2(IUpsKrnCaractere *O1, IUpsKrnEntier *O2)
/****************************************************************/
{
try
   {
   return(O1->Majuscule()->Additionner(pIUpsKrn->CorbaString2Caractere(" "))->Additionner(pIUpsKrn->Caractere5(O2)));
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   }
return(NULL);   
}

/****************************************************************/
static IUpsKrnBooleen *F3(IUpsKrnCaractere *O1)
/****************************************************************/
{
try
   {
   return(O1->InferieurOuEgal(pIUpsKrn->CorbaString2Caractere("hello!!!")));
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   }
return(NULL);   
}

/****************************************************************/
static CORBA::UShort F4(IUpsKrnCaractere *O1, IUpsKrnCaractere *O2)
/****************************************************************/
{
try
   {
   if (pIUpsKrn->EstNul((IUpsKrnObjet *)O1) || pIUpsKrn->EstNul((IUpsKrnObjet *)O2))
      return(CO_ComparaisonNul);
   else if (pIUpsKrn->Booleen2CorbaBoolean(O1->Inferieur(O2)))
      return(CO_ComparaisonAvant);
   else if (pIUpsKrn->Booleen2CorbaBoolean(O1->Superieur(O2)))
      return(CO_ComparaisonApres);
   else
      return(CO_ComparaisonEgal);
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   }
return(0);   
}

/****************************************************************/
static void EcrireListe(IUpsKrnListe *L)
/****************************************************************/
{
IUpsKrnCaractere_var C;

try
   {
   C=(IUpsKrnCaractere *)L->ParcoursAuDebut(0);
   for (;;)
      {
      cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
      if (C->Identique(L->DernierElement()))
         break;
      C=(IUpsKrnCaractere *)L->Suivant(0);
      }
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   }
}

/****************************************************************/
int main(int argc, char *argv[])
/****************************************************************/
{
IUpsKrnListe_var L1;
IUpsKrnListe_var L2;
IUpsKrnListe_var L3;

pOrb=CORBA::ORB_init(argc,argv,"mico-local-orb");
if (!pOrb)
   return(1);
pBoa=pOrb->BOA_init(argc, argv, "mico-local-boa");
if (!pBoa)
   return(1);
pObjet=pOrb->bind("IDL:IUpsKrn:1.0");
if (!pObjet)
   return(1);
pIUpsKrn=IUpsKrn::_narrow(pObjet);
if (!pIUpsKrn)
   return(1);

try
   {
   L1=pIUpsKrn->Liste1((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("bonjour"));
   L1->AdditionnerAffecter((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("hello"));
   L1->AdditionnerAffecter((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("guten tag"));
   L2=pIUpsKrn->Liste1((IUpsKrnObjet *)pIUpsKrn->CorbaLong2Entier(1));
   L2->AdditionnerAffecter((IUpsKrnObjet *)pIUpsKrn->CorbaLong2Entier(2));
   L2->AdditionnerAffecter((IUpsKrnObjet *)pIUpsKrn->CorbaLong2Entier(3));

   cout << "P1:" << endl;
   L1->Appliquer(pIUpsKrn->CorbaAppel2Appel("void P1(in IUpsKrn::Objet O)", (CORBA::LongLong)P1));
   cout << "P2:" << endl;
   L1->Appliquer2(pIUpsKrn->CorbaAppel2Appel("void P2(in IUpsKrn::Objet O1, in IUpsKrn::Objet O2)", (CORBA::LongLong)P2), L2);

   cout << "F1:" << endl;
   L3=L1->Appliquer3(pIUpsKrn->CorbaAppel2Appel("IUpsKrn::Objet F1(in IUpsKrn::Objet O)", (CORBA::LongLong)F1));
   EcrireListe(L3);
   cout << "F2:" << endl;
   L3=L1->Appliquer4(pIUpsKrn->CorbaAppel2Appel("IUpsKrn::Objet F2(in IUpsKrn::Objet O1, in IUpsKrn::Objet O2)", (CORBA::LongLong)F2), L2);
   EcrireListe(L3);

   cout << "F3:" << endl;
   L3=L1->Filtrer(pIUpsKrn->CorbaAppel2Appel("IUpsKrn::Objet F3(in IUpsKrn::Objet O1)", (CORBA::LongLong)F3));
   EcrireListe(L3);

   cout << "F4:" << endl;
   L1->AdditionnerAffecter((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("hello"));
   L1->AdditionnerAffecter((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("bonjour"));
   L3=L1->Grouper(pIUpsKrn->CorbaAppel2Appel("unsigned short F4(in IUpsKrn::Objet O1, in IUpsKrn::Objet O2)", (CORBA::LongLong)F4));
   EcrireListe(L3);

   cout << "F4Bis:" << endl;
   L1->AdditionnerAffecter((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("coucou"));
   L1->AdditionnerAffecter((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("salut"));
   L1->AdditionnerAffecter((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("hie"));
   L1->AdditionnerAffecter((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("schluss"));
   L3=L1->Trier(pIUpsKrn->CorbaAppel2Appel("unsigned short F4(in IUpsKrn::Objet O1, in IUpsKrn::Objet O2)", (CORBA::LongLong)F4), TRUE);
   EcrireListe(L3);
   L3=L1->Trier(pIUpsKrn->CorbaAppel2Appel("unsigned short F4(in IUpsKrn::Objet O1, in IUpsKrn::Objet O2)", (CORBA::LongLong)F4), FALSE);
   EcrireListe(L3);
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   return(1);   
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   return(1);   
   }

L1=NULL;
L2=NULL;
L3=NULL;
CORBA::release(pIUpsKrn);
pIUpsKrn=NULL;
delete pBoa;
delete pOrb;
return(0);
}