/* ------------------------------------------------------------------- */
/* Fichier    : libf2.cpp                                            */
/* Objet      : Exemple d'emploi d'Up ! Corba.                         */
/*                                                                     */                                                                     
/* Module      : Up ! Appplication System.                             */
/* Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.                    */
/* ------------------------------------------------------------------- */
/*                          Observations                               */
/*                                                                     */
/*                                                                     */
/* ------------------------------------------------------------------- */

#include <CORBA.h>
#include <mico/string.h>
#include <upskrn.hh>
#include <libf.hh>
#include <upscrbexception.h>

using namespace std;

static CORBA::ORB *pOrb;
static CORBA::BOA *pBoa;
static CORBA::Object *pObjet;
static IUpsKrn *pIUpsKrn;
static Ilibf *pILibF;

/****************************************************************/
int main(int argc, char *argv[])
/****************************************************************/
{
IlibfC1_var VC1;
IUpsKrnCaractere_ptr C;

pOrb=CORBA::ORB_init(argc,argv,"mico-local-orb");
if (!pOrb)
   return(1);
pBoa=pOrb->BOA_init(argc, argv, "mico-local-boa");
if (!pBoa)
   return(1);
pObjet=pOrb->bind("IDL:IUpsKrn:1.0");
if (!pObjet)
   return(1);
pIUpsKrn=IUpsKrn::_narrow(pObjet);
if (!pIUpsKrn)
   return(1);
pObjet=pOrb->bind("IDL:Ilibf:1.0");
if (!pObjet)
   return(1);
pILibF=Ilibf::_narrow(pObjet);
if (!pILibF)
   return(1);

try
   {
   VC1=pILibF->C11();
   VC1->CA1(TRUE);
   if (VC1->CA1())
      cout << "VC1.CA1=True" << endl;
   else
      cout << "VC1.CA1=False" << endl;
   VC1->CB1(pIUpsKrn->CorbaBoolean2Booleen(TRUE));
   if (pIUpsKrn->Booleen2CorbaBoolean(VC1->CB1()))
      cout << "VC1.CB1=True" << endl;
   else
      cout << "VC1.CB1=False" << endl;
   VC1->CC1(2);
   cout << "VC1.CC1=" << VC1->CC1() << endl;
   VC1->CD1(pIUpsKrn->CorbaLong2Entier(2));
   cout << "VC1.CD1=" << pIUpsKrn->Entier2CorbaLong(VC1->CD1()) << endl;
   VC1->CE1(3.2);
   cout << "VC1.CE1=" << VC1->CE1() << endl;
   VC1->CF1(pIUpsKrn->CorbaDouble2Reel(3.2));
   cout << "VC1.CF1=" << pIUpsKrn->Reel2CorbaDouble(VC1->CF1()) << endl;
   VC1->CG1(pIUpsKrn->CorbaString2Caractere("coucou"));
   cout << "VC1.CG1=" << pIUpsKrn->Caractere2CorbaString(VC1->CG1()) << endl;
   VC1->CH1(pIUpsKrn->CorbaString2Caractere("coucou"));
   cout << "VC1.CH1=" << pIUpsKrn->Caractere2CorbaString(VC1->CH1()) << endl;

   VC1->CA1V(TRUE);
   if (VC1->CA1V())
      cout << "VC1.CA1V=True" << endl;
   else
      cout << "VC1.CA1V=False" << endl;
   VC1->CB1V(pIUpsKrn->CorbaBoolean2Booleen(TRUE));
   if (pIUpsKrn->Booleen2CorbaBoolean(VC1->CB1V()))
      cout << "VC1.CB1V=True" << endl;
   else
      cout << "VC1.CB1V=False" << endl;
   VC1->CC1V(2);
   cout << "VC1.CC1V=" << VC1->CC1V() << endl;
   VC1->CD1V(pIUpsKrn->CorbaLong2Entier(2));
   cout << "VC1.CD1V=" << pIUpsKrn->Entier2CorbaLong(VC1->CD1V()) << endl;
   VC1->CE1V(3.2);
   cout << "VC1.CE1V=" << VC1->CE1V() << endl;
   VC1->CF1V(pIUpsKrn->CorbaDouble2Reel(3.2));
   cout << "VC1.CF1V=" << pIUpsKrn->Reel2CorbaDouble(VC1->CF1V()) << endl;
   VC1->CG1V(pIUpsKrn->CorbaString2Caractere("coucou"));
   cout << "VC1.CG1V=" << pIUpsKrn->Caractere2CorbaString(VC1->CG1V()) << endl;
   VC1->CH1V(pIUpsKrn->CorbaString2Caractere("coucou"));
   cout << "VC1.CH1V=" << pIUpsKrn->Caractere2CorbaString(VC1->CH1V()) << endl;

   VC1->Ecrire1(pIUpsKrn->CorbaBoolean2Booleen(TRUE));
   VC1->Ecrire2(pIUpsKrn->CorbaLong2Entier(2));
   VC1->Ecrire3(pIUpsKrn->CorbaDouble2Reel(3.2));
   VC1->Ecrire32(pIUpsKrn->CorbaString2Caractere("coucou"));

   pILibF->VA1(TRUE);
   if (pILibF->VA1())
      cout << "VA1=True" << endl;
   else
      cout << "VA1=False" << endl;
   pILibF->VB1(pIUpsKrn->CorbaBoolean2Booleen(TRUE));
   if (pIUpsKrn->Booleen2CorbaBoolean(pILibF->VB1()))
      cout << "VB1=True" << endl;
   else
      cout << "VB1=False" << endl;
   pILibF->VC1(2);
   cout << "VC1=" << pILibF->VC1() << endl;
   pILibF->VD1(pIUpsKrn->CorbaLong2Entier(2));
   cout << "VD1=" << pIUpsKrn->Entier2CorbaLong(pILibF->VD1()) << endl;
   pILibF->VE1(3.2);
   cout << "VE1=" << pILibF->VE1() << endl;
   pILibF->VF1(pIUpsKrn->CorbaDouble2Reel(3.2));
   cout << "VF1=" << pIUpsKrn->Reel2CorbaDouble(pILibF->VF1()) << endl;
   pILibF->VG1(pIUpsKrn->CorbaString2Caractere("coucou"));
   cout << "VG1=" << pIUpsKrn->Caractere2CorbaString(pILibF->VG1()) << endl;
   pILibF->VH1(pIUpsKrn->CorbaString2Caractere("coucou"));
   cout << "VH1=" << pIUpsKrn->Caractere2CorbaString(pILibF->VH1()) << endl;

   pILibF->VA1V(TRUE);
   if (pILibF->VA1V())
      cout << "VA1V=True" << endl;
   else
      cout << "VA1V=False" << endl;
   pILibF->VB1V(pIUpsKrn->CorbaBoolean2Booleen(TRUE));
   if (pIUpsKrn->Booleen2CorbaBoolean(pILibF->VB1V()))
      cout << "VB1V=True" << endl;
   else
      cout << "VB1V=False" << endl;
   pILibF->VC1V(2);
   cout << "VC1V=" << pILibF->VC1V() << endl;
   pILibF->VD1V(pIUpsKrn->CorbaLong2Entier(2));
   cout << "VD1V=" << pIUpsKrn->Entier2CorbaLong(pILibF->VD1V()) << endl;
   pILibF->VE1V(3.2);
   cout << "VE1V=" << pILibF->VE1V() << endl;
   pILibF->VF1V(pIUpsKrn->CorbaDouble2Reel(3.2));
   cout << "VF1V=" << pIUpsKrn->Reel2CorbaDouble(pILibF->VF1V()) << endl;
   pILibF->VG1V(pIUpsKrn->CorbaString2Caractere("coucou"));
   cout << "VG1V=" << pIUpsKrn->Caractere2CorbaString(pILibF->VG1V()) << endl;
   pILibF->VH1V(pIUpsKrn->CorbaString2Caractere("coucou"));
   cout << "VH1V=" << pIUpsKrn->Caractere2CorbaString(pILibF->VH1V()) << endl;

   pILibF->Appel1();
   C=(IUpsKrnCaractere *)pIUpsKrn->ObjetNul();
   pILibF->Appel2(TRUE, 2, 3.2, C);
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   if (pILibF->Appel3())
      cout << "Appel3=True" << endl;
   else
      cout << "Appel3=False" << endl;
   C=(IUpsKrnCaractere *)pIUpsKrn->ObjetNul();
   if (pILibF->Appel4(TRUE, 2, 3.2, C))
      cout << "Appel4=True" << endl;
   else
      cout << "Appel4=False" << endl;
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   cout << "Appel5=" << pILibF->Appel5() << endl;
   C=(IUpsKrnCaractere *)pIUpsKrn->ObjetNul();
   cout << "Appel6=" << pILibF->Appel6(TRUE, 2, 3.2, C) << endl;
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   cout << "Appel7=" << pILibF->Appel7() << endl;
   C=(IUpsKrnCaractere *)pIUpsKrn->ObjetNul();
   cout << "Appel8=" << pILibF->Appel8(TRUE, 2, 3.2, C) << endl;
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   cout << "Appel9=" << pIUpsKrn->Caractere2CorbaString(pILibF->Appel9()) << endl;
   C=(IUpsKrnCaractere *)pIUpsKrn->ObjetNul();
   cout << "Appel10=" << pIUpsKrn->Caractere2CorbaString(pILibF->Appel10(TRUE, 2, 3.2, C)) << endl;
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   C=NULL;
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   return(1);   
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   return(1);   
   }

VC1=NULL;
C=NULL;
CORBA::release(pILibF);
pILibF=NULL;
CORBA::release(pIUpsKrn);
pIUpsKrn=NULL;
delete pBoa;
delete pOrb;
return(0);
}