/* ------------------------------------------------------------------- */
/* Fichier    : fichier.cpp                                            */
/* Objet      : Exemple d'emploi d'Up ! Corba.                         */
/*                                                                     */                                                                     
/* Module      : Up ! Appplication System.                             */
/* Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.                    */
/* ------------------------------------------------------------------- */
/*                          Observations                               */
/*                                                                     */
/*                                                                     */
/* ------------------------------------------------------------------- */

#include <CORBA.h>
#include <mico/string.h>
#include <upskrn.hh>
#include <upssys.hh>
#include <upscrbexception.h>

using namespace std;

static const CORBA::UShort CO_NonOuvert=1;
static const CORBA::UShort CO_LectureTexte=2;
static const CORBA::UShort CO_EcritureTexte=3;
static const CORBA::UShort CO_EcritureTexteALaSuite=4;
static const CORBA::UShort CO_LectureEcritureTexte=5;
static const CORBA::UShort CO_LectureBinaire=6;
static const CORBA::UShort CO_EcritureBinaire=7;
static const CORBA::UShort CO_EcritureBinaireALaSuite=8;
static const CORBA::UShort CO_LectureEcritureBinaire=9;

static CORBA::ORB *pOrb;
static CORBA::BOA *pBoa;
static CORBA::Object *pObjet;
static IUpsKrn *pIUpsKrn;
static IUpsSys *pIUpsSys;

/****************************************************************/
int main(int argc, char *argv[])
/****************************************************************/
{
IUpsSysFichier_var F;
IUpsSysFichier_var FBis;
IUpsKrnCaractere_var C;
CORBA::Long E;
CORBA::Double R;
CORBA::Boolean B;
CORBA::Long P;

pOrb=CORBA::ORB_init(argc,argv,"mico-local-orb");
if (!pOrb)
   return(1);
pBoa=pOrb->BOA_init(argc, argv, "mico-local-boa");
if (!pBoa)
   return(1);
pObjet=pOrb->bind("IDL:IUpsKrn:1.0");
if (!pObjet)
   return(1);
pIUpsKrn=IUpsKrn::_narrow(pObjet);
if (!pIUpsKrn)
   return(1);
pObjet=pOrb->bind("IDL:IUpsSys:1.0");
if (!pObjet)
   return(1);
pIUpsSys=IUpsSys::_narrow(pObjet);
if (!pIUpsSys)
   return(1);

try
   {
   F=pIUpsSys->Fichier2(pIUpsKrn->CorbaString2Caractere("c:/tmp/essai.txt"), CO_EcritureTexte);
   F->Ecrire3(pIUpsKrn->CorbaString2Caractere("Bonjour\nAu revoir\nEt a bientot\n"));
   F->Ecrire4(pIUpsKrn->CorbaLong2Entier(1));
   F->Ecrire3(pIUpsKrn->CorbaString2Caractere("\n"));
   F->Ecrire5(pIUpsKrn->CorbaDouble2Reel(2.3));
   F->Ecrire3(pIUpsKrn->CorbaString2Caractere("\n"));
   F->Ecrire(pIUpsKrn->CorbaBoolean2Booleen(TRUE));
   F->Ecrire3(pIUpsKrn->CorbaString2Caractere("\n"));
   F->Vider();
   F->DeposerSurDisque();
   F->Fermer();
   F=pIUpsSys->Fichier2(pIUpsKrn->CorbaString2Caractere("c:/tmp/essai.txt"), CO_LectureTexte);
   E=pIUpsKrn->Entier2CorbaLong(F->LireUnMot(C, pIUpsKrn->CorbaLong2Entier(20)));
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   E=pIUpsKrn->Entier2CorbaLong(F->Lire3(C, pIUpsKrn->CorbaLong2Entier(4)));
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   cout << E << endl;
   E=pIUpsKrn->Entier2CorbaLong(F->LireUneLigne(C, pIUpsKrn->CorbaLong2Entier(50)));
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   cout << E << endl;
   P=pIUpsKrn->Entier2CorbaLong(F->LirePosition());
   E=pIUpsKrn->Entier2CorbaLong(F->LireUneLigne(C, pIUpsKrn->CorbaLong2Entier(50)));
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   cout << E << endl;
   F->Lire4(E);
   cout << E << endl;
   F->Lire5(R);
   cout << R << endl;
   F->Lire(B);
   if (B)
      cout << "Vrai" << endl;
   else
      cout << "Faux" << endl;
   E=pIUpsKrn->Entier2CorbaLong(F->Lire3(C, pIUpsKrn->CorbaLong2Entier(4)));
   if (F->FinDeFlux())
      cout << "Fin de fichier" << endl;
   F->FixerPosition(P);
   E=pIUpsKrn->Entier2CorbaLong(F->LireUneLigne(C, pIUpsKrn->CorbaLong2Entier(50)));
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   cout << E << endl;
   if (F->FinDeFlux())
      cout << "Fin de fichier" << endl;
   F->Fermer();
   FBis=NULL;
   if (pIUpsKrn->Booleen2CorbaBoolean(F->Egal(FBis)))
      cout << "F==FBis" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(F->Different(FBis)))
      cout << "F!=FBis" << endl;
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   return(1);   
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   return(1);   
   }

F=NULL;
FBis=NULL;
C=NULL;
CORBA::release(pIUpsSys);
pIUpsSys=NULL;
CORBA::release(pIUpsKrn);
pIUpsKrn=NULL;
delete pBoa;
delete pOrb;
return(0);
}