/* ------------------------------------------------------------------- */
/* Fichier    : entier.cpp                                             */
/* Objet      : Exemple d'emploi d'Up ! CorbA->                         */
/*                                                                     */                                                                     
/* Module      : Up ! Appplication System.                             */
/* Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.                    */
/* ------------------------------------------------------------------- */
/*                          Observations                               */
/*                                                                     */
/*                                                                     */
/* ------------------------------------------------------------------- */

#include <CORBA.h>
#include <mico/string.h>
#include <upskrn.hh>
#include <upscrbexception.h>

using namespace std;

static CORBA::ORB *pOrb;
static CORBA::BOA *pBoa;
static CORBA::Object *pObjet;
static IUpsKrn *pIUpsKrn;

/****************************************************************/
int main(int argc, char *argv[])
/****************************************************************/
{
IUpsKrnEntier_var A;
CORBA::Long B;

pOrb=CORBA::ORB_init(argc,argv,"mico-local-orb");
if (!pOrb)
   return(1);
pBoa=pOrb->BOA_init(argc, argv, "mico-local-boa");
if (!pBoa)
   return(1);
pObjet=pOrb->bind("IDL:IUpsKrn:1.0");
if (!pObjet)
   return(1);
pIUpsKrn=IUpsKrn::_narrow(pObjet);
if (!pIUpsKrn)
   return(1);

try
   {
   A=pIUpsKrn->CorbaLong2Entier(1);
   cout << pIUpsKrn->Entier2CorbaLong(A) << endl;
   B=1;
   cout << B << endl;
   A=A->Additionner(pIUpsKrn->CorbaLong2Entier(1));
   cout << pIUpsKrn->Entier2CorbaLong(A) << endl;
   B=B + 1;
   cout << B << endl;

   A=A->Soustraire2(pIUpsKrn->CorbaLong2Entier(10));
   cout << pIUpsKrn->Entier2CorbaLong(A) << endl;
   B=B - 10;
   cout << B << endl;

   A=A->Multiplier(pIUpsKrn->CorbaLong2Entier(10));
   cout << pIUpsKrn->Entier2CorbaLong(A) << endl;
   B=B * 10;
   cout << B << endl;

   A=A->DiviserEntier(pIUpsKrn->CorbaLong2Entier(5));
   cout << pIUpsKrn->Entier2CorbaLong(A) << endl;
   B=B / 5;
   cout << B << endl;

   A=A->Moduler(pIUpsKrn->CorbaLong2Entier(3));
   cout << pIUpsKrn->Entier2CorbaLong(A) << endl;
   B=B % 3;
   cout << B << endl;

   A=A->Puissance(pIUpsKrn->CorbaLong2Entier(3));
   cout << pIUpsKrn->Entier2CorbaLong(A) << endl;
   B=(CORBA::Long)pow((double)B,3.0);
   cout << B << endl;

   A=A->EtBit(pIUpsKrn->CorbaLong2Entier(255));
   cout << pIUpsKrn->Entier2CorbaLong(A) << endl;
   B=B & 255;
   cout << B << endl;

   A=A->OuBit(pIUpsKrn->CorbaLong2Entier(256));
   cout << pIUpsKrn->Entier2CorbaLong(A) << endl;
   B=B | 256;
   cout << B << endl;

   A=A->SuperieurSuperieur(pIUpsKrn->CorbaLong2Entier(4));
   cout << pIUpsKrn->Entier2CorbaLong(A) << endl;
   B= B >> 4;
   cout << B << endl;

   A=A->InferieurInferieur(pIUpsKrn->CorbaLong2Entier(2));
   cout << pIUpsKrn->Entier2CorbaLong(A) << endl;
   B=B << 2;
   cout << B << endl;

   A=pIUpsKrn->CorbaLong2Entier(1);
   cout << pIUpsKrn->Entier2CorbaLong(A) << endl;
   B=1;
   cout << B << endl;

   A->AdditionnerAffecter(pIUpsKrn->CorbaLong2Entier(1));
   cout << pIUpsKrn->Entier2CorbaLong(A) << endl;
   B+=1;
   cout << B << endl;

   A->SoustraireAffecter(pIUpsKrn->CorbaLong2Entier(10));
   cout << pIUpsKrn->Entier2CorbaLong(A) << endl;
   B-=10;
   cout << B << endl;

   A->MultiplierAffecter(pIUpsKrn->CorbaLong2Entier(10));
   cout << pIUpsKrn->Entier2CorbaLong(A) << endl;
   B*=10;
   cout << B << endl;

   A->DiviserEntierAffecter(pIUpsKrn->CorbaLong2Entier(5));
   cout << pIUpsKrn->Entier2CorbaLong(A) << endl;
   B/=5;
   cout << B << endl;

   A->ModulerAffecter(pIUpsKrn->CorbaLong2Entier(3));
   cout << pIUpsKrn->Entier2CorbaLong(A) << endl;
   B%=3;
   cout << B << endl;

   A->PuissanceAffecter(pIUpsKrn->CorbaLong2Entier(3));
   cout << pIUpsKrn->Entier2CorbaLong(A) << endl;
   B=(CORBA::Long)pow((double)B,3.0);
   cout << B << endl;

   A->EtBitAffecter(pIUpsKrn->CorbaLong2Entier(255));
   cout << pIUpsKrn->Entier2CorbaLong(A) << endl;
   B&=255;
   cout << B << endl;

   A->OuBitAffecter(pIUpsKrn->CorbaLong2Entier(256));
   cout << pIUpsKrn->Entier2CorbaLong(A) << endl;
   B|=256;
   cout << B << endl;

   A->SuperieurSuperieurAffecter(pIUpsKrn->CorbaLong2Entier(4));
   cout << pIUpsKrn->Entier2CorbaLong(A) << endl;
   B>>=4;
   cout << B << endl;

   A->InferieurInferieurAffecter(pIUpsKrn->CorbaLong2Entier(2));
   cout << pIUpsKrn->Entier2CorbaLong(A) << endl;
   B<<=2;
   cout << B << endl;

   A->Incrementer(FALSE);
   cout << pIUpsKrn->Entier2CorbaLong(A) << endl;
   B++;
   cout << B << endl;

   A->Decrementer(FALSE);
   cout << pIUpsKrn->Entier2CorbaLong(A) << endl;
   B--;
   cout << B << endl;

   A->Incrementer(TRUE);
   cout << pIUpsKrn->Entier2CorbaLong(A) << endl;
   ++B;
   cout << B << endl;

   A->Decrementer(TRUE);
   cout << pIUpsKrn->Entier2CorbaLong(A) << endl;
   --B;
   cout << B << endl;

   if (pIUpsKrn->Booleen2CorbaBoolean(A->Egal(pIUpsKrn->CorbaLong2Entier(1))))
      cout << "A==1" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(A->Different(pIUpsKrn->CorbaLong2Entier(1))))
      cout << "A!=1" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(A->InferieurOuEgal(pIUpsKrn->CorbaLong2Entier(1))))
      cout << "A<=1" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(A->SuperieurOuEgal(pIUpsKrn->CorbaLong2Entier(1))))
      cout << "A>=1" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(A->Inferieur(pIUpsKrn->CorbaLong2Entier(1))))
      cout << "A<1" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(A->Superieur(pIUpsKrn->CorbaLong2Entier(1))))
      cout << "A>1" << endl;

   if (B==1)
      cout << "B==1" << endl;
   if (B!=1)
      cout << "B!=1" << endl;
   if (B <= 1)
      cout << "B<=1" << endl;
   if (B >= 1)
      cout << "B>=1" << endl;
   if (B < 1)
      cout << "B<1" << endl;
   if (B > 1)
      cout << "B>1" << endl;
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   return(1);   
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   return(1);   
   }

A=NULL;
CORBA::release(pIUpsKrn);
pIUpsKrn=NULL;
delete pBoa;
delete pOrb;
return(0);
}