/* ------------------------------------------------------------------- */
/* Fichier    : date.cpp                                               */
/* Objet      : Exemple d'emploi d'Up ! Corba.                         */
/*                                                                     */                                                                     
/* Module      : Up ! Appplication System.                             */
/* Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.                    */
/* ------------------------------------------------------------------- */
/*                          Observations                               */
/*                                                                     */
/*                                                                     */
/* ------------------------------------------------------------------- */

#include <CORBA.h>
#include <mico/string.h>
#include <upskrn.hh>
#include <upscrbexception.h>

using namespace std;

static CORBA::ORB *pOrb;
static CORBA::BOA *pBoa;
static CORBA::Object *pObjet;
static IUpsKrn *pIUpsKrn;

/****************************************************************/
int main(int argc, char *argv[])
/****************************************************************/
{
IUpsKrnDate_var D;
CORBA::Double R;

pOrb=CORBA::ORB_init(argc,argv,"mico-local-orb");
if (!pOrb)
   return(1);
pBoa=pOrb->BOA_init(argc, argv, "mico-local-boa");
if (!pBoa)
   return(1);
pObjet=pOrb->bind("IDL:IUpsKrn:1.0");
if (!pObjet)
   return(1);
pIUpsKrn=IUpsKrn::_narrow(pObjet);
if (!pIUpsKrn)
   return(1);

try
   {
   D=pIUpsKrn->Date2(pIUpsKrn->CorbaString2Caractere("27-01-1998"));
   cout << D->Jour() << endl;
   cout << D->Mois() << endl;
   cout << D->Annee() << endl;
   cout << D->Heure() << endl;
   cout << D->Minute() << endl;
   cout << D->Seconde() << endl;
   cout << D->Millieme() << endl;
   cout << endl;
   D=pIUpsKrn->Date2(pIUpsKrn->CorbaString2Caractere("27-01-1998 21:00:14"));
   cout << D->Jour() << endl;
   cout << D->Mois() << endl;
   cout << D->Annee() << endl;
   cout << D->Heure() << endl;
   cout << D->Minute() << endl;
   cout << D->Seconde() << endl;
   cout << D->Millieme() << endl;
   cout << endl;
   D=pIUpsKrn->Date2(pIUpsKrn->CorbaString2Caractere("27-01-1998 21:00:14:98"));
   cout << D->Jour() << endl;
   cout << D->Mois() << endl;
   cout << D->Annee() << endl;
   cout << D->Heure() << endl;
   cout << D->Minute() << endl;
   cout << D->Seconde() << endl;
   cout << D->Millieme() << endl;
   cout << endl;
   D=pIUpsKrn->Date3(pIUpsKrn->CorbaLong2Entier(27), pIUpsKrn->CorbaLong2Entier(1), pIUpsKrn->CorbaLong2Entier(1998));
   cout << D->Jour() << endl;
   cout << D->Mois() << endl;
   cout << D->Annee() << endl;
   cout << D->Heure() << endl;
   cout << D->Minute() << endl;
   cout << D->Seconde() << endl;
   cout << D->Millieme() << endl;
   cout << endl;
   D=pIUpsKrn->Date4(pIUpsKrn->CorbaLong2Entier(27), pIUpsKrn->CorbaLong2Entier(1), pIUpsKrn->CorbaLong2Entier(1998), 
      pIUpsKrn->CorbaLong2Entier(21), pIUpsKrn->CorbaLong2Entier(9), pIUpsKrn->CorbaLong2Entier(14));
   cout << D->Jour() << endl;
   cout << D->Mois() << endl;
   cout << D->Annee() << endl;
   cout << D->Heure() << endl;
   cout << D->Minute() << endl;
   cout << D->Seconde() << endl;
   cout << D->Millieme() << endl;
   cout << endl;
   D=pIUpsKrn->Date5(pIUpsKrn->CorbaLong2Entier(27), pIUpsKrn->CorbaLong2Entier(1), pIUpsKrn->CorbaLong2Entier(1998), 
      pIUpsKrn->CorbaLong2Entier(21), pIUpsKrn->CorbaLong2Entier(9), pIUpsKrn->CorbaLong2Entier(14), pIUpsKrn->CorbaLong2Entier(98));
   cout << D->Jour() << endl;
   cout << D->Mois() << endl;
   cout << D->Annee() << endl;
   cout << D->Heure() << endl;
   cout << D->Minute() << endl;
   cout << D->Seconde() << endl;
   cout << D->Millieme() << endl;
   cout << endl;
   D=pIUpsKrn->Date4(pIUpsKrn->CorbaLong2Entier(27), pIUpsKrn->CorbaLong2Entier(1), pIUpsKrn->CorbaLong2Entier(1998), 
      pIUpsKrn->CorbaLong2Entier(21), pIUpsKrn->CorbaLong2Entier(9), pIUpsKrn->CorbaLong2Entier(14))->Additionner(pIUpsKrn->CorbaLong2Entier(70));
   cout << D->Jour() << endl;
   cout << D->Mois() << endl;
   cout << D->Annee() << endl;
   cout << D->Heure() << endl;
   cout << D->Minute() << endl;
   cout << D->Seconde() << endl;
   cout << D->Millieme() << endl;
   cout << endl;
   D=pIUpsKrn->Date4(pIUpsKrn->CorbaLong2Entier(27), pIUpsKrn->CorbaLong2Entier(1), pIUpsKrn->CorbaLong2Entier(1998), 
      pIUpsKrn->CorbaLong2Entier(21), pIUpsKrn->CorbaLong2Entier(9), pIUpsKrn->CorbaLong2Entier(14));
   D->AdditionnerAffecter(pIUpsKrn->CorbaLong2Entier(70));
   cout << D->Jour() << endl;
   cout << D->Mois() << endl;
   cout << D->Annee() << endl;
   cout << D->Heure() << endl;
   cout << D->Minute() << endl;
   cout << D->Seconde() << endl;
   cout << D->Millieme() << endl;
   cout << endl;
   D=pIUpsKrn->Date4(pIUpsKrn->CorbaLong2Entier(27), pIUpsKrn->CorbaLong2Entier(1), pIUpsKrn->CorbaLong2Entier(1998), 
      pIUpsKrn->CorbaLong2Entier(21), pIUpsKrn->CorbaLong2Entier(9), pIUpsKrn->CorbaLong2Entier(14))->Soustraire(pIUpsKrn->CorbaLong2Entier(20));
   cout << D->Jour() << endl;
   cout << D->Mois() << endl;
   cout << D->Annee() << endl;
   cout << D->Heure() << endl;
   cout << D->Minute() << endl;
   cout << D->Seconde() << endl;
   cout << D->Millieme() << endl;
   cout << endl;
   D=pIUpsKrn->Date4(pIUpsKrn->CorbaLong2Entier(27), pIUpsKrn->CorbaLong2Entier(1), pIUpsKrn->CorbaLong2Entier(1998), 
      pIUpsKrn->CorbaLong2Entier(21), pIUpsKrn->CorbaLong2Entier(9), pIUpsKrn->CorbaLong2Entier(14));
   D->SoustraireAffecter(pIUpsKrn->CorbaLong2Entier(20));
   cout << D->Jour() << endl;
   cout << D->Mois() << endl;
   cout << D->Annee() << endl;
   cout << D->Heure() << endl;
   cout << D->Minute() << endl;
   cout << D->Seconde() << endl;
   cout << D->Millieme() << endl;
   cout << endl;
   D=pIUpsKrn->Date4(pIUpsKrn->CorbaLong2Entier(27), pIUpsKrn->CorbaLong2Entier(1), pIUpsKrn->CorbaLong2Entier(1998), 
      pIUpsKrn->CorbaLong2Entier(21), pIUpsKrn->CorbaLong2Entier(9), pIUpsKrn->CorbaLong2Entier(14))->AjouterMinutes(pIUpsKrn->CorbaLong2Entier(62));
   cout << D->Jour() << endl;
   cout << D->Mois() << endl;
   cout << D->Annee() << endl;
   cout << D->Heure() << endl;
   cout << D->Minute() << endl;
   cout << D->Seconde() << endl;
   cout << D->Millieme() << endl;
   cout << endl;
   D=pIUpsKrn->Date4(pIUpsKrn->CorbaLong2Entier(27), pIUpsKrn->CorbaLong2Entier(1), pIUpsKrn->CorbaLong2Entier(1998), 
      pIUpsKrn->CorbaLong2Entier(21), pIUpsKrn->CorbaLong2Entier(9), pIUpsKrn->CorbaLong2Entier(14))->AjouterMinutes(pIUpsKrn->CorbaLong2Entier(-11));
   cout << D->Jour() << endl;
   cout << D->Mois() << endl;
   cout << D->Annee() << endl;
   cout << D->Heure() << endl;
   cout << D->Minute() << endl;
   cout << D->Seconde() << endl;
   cout << D->Millieme() << endl;
   cout << endl;
   D=pIUpsKrn->Date4(pIUpsKrn->CorbaLong2Entier(27), pIUpsKrn->CorbaLong2Entier(1), pIUpsKrn->CorbaLong2Entier(1998), 
      pIUpsKrn->CorbaLong2Entier(21), pIUpsKrn->CorbaLong2Entier(9), pIUpsKrn->CorbaLong2Entier(14))->AjouterHeures(pIUpsKrn->CorbaLong2Entier(4));
   cout << D->Jour() << endl;
   cout << D->Mois() << endl;
   cout << D->Annee() << endl;
   cout << D->Heure() << endl;
   cout << D->Minute() << endl;
   cout << D->Seconde() << endl;
   cout << D->Millieme() << endl;
   cout << endl;
   D=pIUpsKrn->Date4(pIUpsKrn->CorbaLong2Entier(27), pIUpsKrn->CorbaLong2Entier(1), pIUpsKrn->CorbaLong2Entier(1998), 
      pIUpsKrn->CorbaLong2Entier(21), pIUpsKrn->CorbaLong2Entier(9), pIUpsKrn->CorbaLong2Entier(14))->AjouterHeures(pIUpsKrn->CorbaLong2Entier(-11));
   cout << D->Jour() << endl;
   cout << D->Mois() << endl;
   cout << D->Annee() << endl;
   cout << D->Heure() << endl;
   cout << D->Minute() << endl;
   cout << D->Seconde() << endl;
   cout << D->Millieme() << endl;
   cout << endl;
   D=pIUpsKrn->Date4(pIUpsKrn->CorbaLong2Entier(27), pIUpsKrn->CorbaLong2Entier(1), pIUpsKrn->CorbaLong2Entier(1998), 
      pIUpsKrn->CorbaLong2Entier(21), pIUpsKrn->CorbaLong2Entier(9), pIUpsKrn->CorbaLong2Entier(14))->AjouterJours(pIUpsKrn->CorbaLong2Entier(4));
   cout << D->Jour() << endl;
   cout << D->Mois() << endl;
   cout << D->Annee() << endl;
   cout << D->Heure() << endl;
   cout << D->Minute() << endl;
   cout << D->Seconde() << endl;
   cout << D->Millieme() << endl;
   cout << endl;
   D=pIUpsKrn->Date4(pIUpsKrn->CorbaLong2Entier(27), pIUpsKrn->CorbaLong2Entier(1), pIUpsKrn->CorbaLong2Entier(1998), 
      pIUpsKrn->CorbaLong2Entier(21), pIUpsKrn->CorbaLong2Entier(9), pIUpsKrn->CorbaLong2Entier(14))->AjouterJours(pIUpsKrn->CorbaLong2Entier(-30));
   cout << D->Jour() << endl;
   cout << D->Mois() << endl;
   cout << D->Annee() << endl;
   cout << D->Heure() << endl;
   cout << D->Minute() << endl;
   cout << D->Seconde() << endl;
   cout << D->Millieme() << endl;
   cout << endl;
   D=pIUpsKrn->Date4(pIUpsKrn->CorbaLong2Entier(27), pIUpsKrn->CorbaLong2Entier(1), pIUpsKrn->CorbaLong2Entier(1998), 
      pIUpsKrn->CorbaLong2Entier(21), pIUpsKrn->CorbaLong2Entier(9), pIUpsKrn->CorbaLong2Entier(14))->AjouterMois(pIUpsKrn->CorbaLong2Entier(4));
   cout << D->Jour() << endl;
   cout << D->Mois() << endl;
   cout << D->Annee() << endl;
   cout << D->Heure() << endl;
   cout << D->Minute() << endl;
   cout << D->Seconde() << endl;
   cout << D->Millieme() << endl;
   cout << endl;
   D=pIUpsKrn->Date4(pIUpsKrn->CorbaLong2Entier(27), pIUpsKrn->CorbaLong2Entier(1), pIUpsKrn->CorbaLong2Entier(1998), 
      pIUpsKrn->CorbaLong2Entier(21), pIUpsKrn->CorbaLong2Entier(9), pIUpsKrn->CorbaLong2Entier(14))->AjouterMois(pIUpsKrn->CorbaLong2Entier(-3));
   cout << D->Jour() << endl;
   cout << D->Mois() << endl;
   cout << D->Annee() << endl;
   cout << D->Heure() << endl;
   cout << D->Minute() << endl;
   cout << D->Seconde() << endl;
   cout << D->Millieme() << endl;
   cout << endl;
   D=pIUpsKrn->Date4(pIUpsKrn->CorbaLong2Entier(27), pIUpsKrn->CorbaLong2Entier(1), pIUpsKrn->CorbaLong2Entier(1998), 
      pIUpsKrn->CorbaLong2Entier(21), pIUpsKrn->CorbaLong2Entier(9), pIUpsKrn->CorbaLong2Entier(14))->AjouterAnnees(pIUpsKrn->CorbaLong2Entier(4));
   cout << D->Jour() << endl;
   cout << D->Mois() << endl;
   cout << D->Annee() << endl;
   cout << D->Heure() << endl;
   cout << D->Minute() << endl;
   cout << D->Seconde() << endl;
   cout << D->Millieme() << endl;
   cout << endl;
   D=pIUpsKrn->Date4(pIUpsKrn->CorbaLong2Entier(27), pIUpsKrn->CorbaLong2Entier(1), pIUpsKrn->CorbaLong2Entier(1998), 
      pIUpsKrn->CorbaLong2Entier(21), pIUpsKrn->CorbaLong2Entier(9), pIUpsKrn->CorbaLong2Entier(14))->AjouterAnnees(pIUpsKrn->CorbaLong2Entier(-3));
   cout << D->Jour() << endl;
   cout << D->Mois() << endl;
   cout << D->Annee() << endl;
   cout << D->Heure() << endl;
   cout << D->Minute() << endl;
   cout << D->Seconde() << endl;
   cout << D->Millieme() << endl;
   cout << endl;
   D=pIUpsKrn->Date4(pIUpsKrn->CorbaLong2Entier(27), pIUpsKrn->CorbaLong2Entier(1), pIUpsKrn->CorbaLong2Entier(1998), 
      pIUpsKrn->CorbaLong2Entier(21), pIUpsKrn->CorbaLong2Entier(9), pIUpsKrn->CorbaLong2Entier(14))->AjouterMilliemes(pIUpsKrn->CorbaLong2Entier(980));
   cout << D->Jour() << endl;
   cout << D->Mois() << endl;
   cout << D->Annee() << endl;
   cout << D->Heure() << endl;
   cout << D->Minute() << endl;
   cout << D->Seconde() << endl;
   cout << D->Millieme() << endl;
   cout << endl;
   D=pIUpsKrn->Date4(pIUpsKrn->CorbaLong2Entier(27), pIUpsKrn->CorbaLong2Entier(1), pIUpsKrn->CorbaLong2Entier(1998), 
      pIUpsKrn->CorbaLong2Entier(21), pIUpsKrn->CorbaLong2Entier(9), pIUpsKrn->CorbaLong2Entier(14))->AjouterMilliemes(pIUpsKrn->CorbaLong2Entier(-980));
   cout << D->Jour() << endl;
   cout << D->Mois() << endl;
   cout << D->Annee() << endl;
   cout << D->Heure() << endl;
   cout << D->Minute() << endl;
   cout << D->Seconde() << endl;
   cout << D->Millieme() << endl;
   cout << endl;
   D=pIUpsKrn->Date4(pIUpsKrn->CorbaLong2Entier(27), pIUpsKrn->CorbaLong2Entier(1), pIUpsKrn->CorbaLong2Entier(1998), 
      pIUpsKrn->CorbaLong2Entier(21), pIUpsKrn->CorbaLong2Entier(9), pIUpsKrn->CorbaLong2Entier(14))->DernierJour();
   cout << D->Jour() << endl;
   cout << D->Mois() << endl;
   cout << D->Annee() << endl;
   cout << D->Heure() << endl;
   cout << D->Minute() << endl;
   cout << D->Seconde() << endl;
   cout << D->Millieme() << endl;
   cout << endl;
   R=pIUpsKrn->Reel2CorbaDouble(pIUpsKrn->Date4(pIUpsKrn->CorbaLong2Entier(27), pIUpsKrn->CorbaLong2Entier(1), pIUpsKrn->CorbaLong2Entier(1998), 
      pIUpsKrn->CorbaLong2Entier(21), pIUpsKrn->CorbaLong2Entier(9), pIUpsKrn->CorbaLong2Entier(14))->Soustraire2( 
         pIUpsKrn->Date4(pIUpsKrn->CorbaLong2Entier(27), pIUpsKrn->CorbaLong2Entier(1), pIUpsKrn->CorbaLong2Entier(1998), 
            pIUpsKrn->CorbaLong2Entier(20), pIUpsKrn->CorbaLong2Entier(8), pIUpsKrn->CorbaLong2Entier(6))));
   cout << R << endl;
   D=pIUpsKrn->Date4(pIUpsKrn->CorbaLong2Entier(27), pIUpsKrn->CorbaLong2Entier(1), pIUpsKrn->CorbaLong2Entier(1998), 
      pIUpsKrn->CorbaLong2Entier(21), pIUpsKrn->CorbaLong2Entier(9), pIUpsKrn->CorbaLong2Entier(14))->AjouterMilliemes(pIUpsKrn->CorbaLong2Entier(980));
   if (pIUpsKrn->Booleen2CorbaBoolean(D->Egal(pIUpsKrn->Date5(pIUpsKrn->CorbaLong2Entier(27), pIUpsKrn->CorbaLong2Entier(1), 
      pIUpsKrn->CorbaLong2Entier(1998), pIUpsKrn->CorbaLong2Entier(21), pIUpsKrn->CorbaLong2Entier(9), 
      pIUpsKrn->CorbaLong2Entier(14), pIUpsKrn->CorbaLong2Entier(980)))))
      cout << "D==29-1-1998 21:9:14:980" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(D->Different(pIUpsKrn->Date5(pIUpsKrn->CorbaLong2Entier(27), pIUpsKrn->CorbaLong2Entier(1), 
      pIUpsKrn->CorbaLong2Entier(1998), pIUpsKrn->CorbaLong2Entier(21), pIUpsKrn->CorbaLong2Entier(9), 
      pIUpsKrn->CorbaLong2Entier(14), pIUpsKrn->CorbaLong2Entier(980)))))
      cout << "D!=29-1-1998 21:9:14:980" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(D->InferieurOuEgal(pIUpsKrn->Date5(pIUpsKrn->CorbaLong2Entier(27), pIUpsKrn->CorbaLong2Entier(1), 
      pIUpsKrn->CorbaLong2Entier(1998), pIUpsKrn->CorbaLong2Entier(21), pIUpsKrn->CorbaLong2Entier(9), 
      pIUpsKrn->CorbaLong2Entier(14), pIUpsKrn->CorbaLong2Entier(980)))))
      cout << "D<=29-1-1998 21:9:14:980" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(D->SuperieurOuEgal(pIUpsKrn->Date5(pIUpsKrn->CorbaLong2Entier(27), pIUpsKrn->CorbaLong2Entier(1), 
      pIUpsKrn->CorbaLong2Entier(1998), pIUpsKrn->CorbaLong2Entier(21), pIUpsKrn->CorbaLong2Entier(9), 
      pIUpsKrn->CorbaLong2Entier(14), pIUpsKrn->CorbaLong2Entier(980)))))
      cout << "D>=29-1-1998 21:9:14:980" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(D->Inferieur(pIUpsKrn->Date5(pIUpsKrn->CorbaLong2Entier(27), pIUpsKrn->CorbaLong2Entier(1), 
      pIUpsKrn->CorbaLong2Entier(1998), pIUpsKrn->CorbaLong2Entier(21), pIUpsKrn->CorbaLong2Entier(9), 
      pIUpsKrn->CorbaLong2Entier(14), pIUpsKrn->CorbaLong2Entier(980)))))
      cout << "D<29-1-1998 21:9:14:980" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(D->Superieur(pIUpsKrn->Date5(pIUpsKrn->CorbaLong2Entier(27), pIUpsKrn->CorbaLong2Entier(1), 
      pIUpsKrn->CorbaLong2Entier(1998), pIUpsKrn->CorbaLong2Entier(21), pIUpsKrn->CorbaLong2Entier(9), 
      pIUpsKrn->CorbaLong2Entier(14), pIUpsKrn->CorbaLong2Entier(980)))))
      cout << "D>29-1-1998 21:9:14:980" << endl;
   D=pIUpsKrn->Date2(pIUpsKrn->CorbaString2Caractere("29-1-1998 21:9:14"));
   cout << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere4(D, pIUpsKrn->CorbaString2Caractere("%jj-%mm-%A %HH:%Mi:%S"))) << endl;
   cout << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere4(D, pIUpsKrn->CorbaString2Caractere("%J %JJ %M %MM"))) << endl;
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   return(1);   
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   return(1);   
   }

D=NULL;
CORBA::release(pIUpsKrn);
pIUpsKrn=NULL;
delete pBoa;
delete pOrb;
return(0);
}