# ------------------------------------------------------------------- 
# Fichier    : upswrk.sh
# Objet      : Script de lancement de Corba
#                                                                      
#  Module      : Up ! Appplication System.                             
#  Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.                    
#  ------------------------------------------------------------------- 
#                           Observations                               
#                                                                       
#                                                                       
#  ------------------------------------------------------------------- 

# Path minimal
# ============
export PATH=/usr/bin:/usr/local/bin:/usr/X11R6/bin

# Configuration Gcc 3.2
# =====================
export GCC_HOME=/usr
export PATH=$PATH:$GCC_HOME/bin
export INCLUDE=$GCC_HOME/include
export LIB=$GCC_HOME/lib

# Configuration Mico 2.3.11
# =========================
export MICO_HOME=/usr/mico2311
export PATH=$PATH:$MICO_HOME/bin
export INCLUDE=$MICO_HOME/include
export LIB=$MICO_HOME/bin

# Configuration Up ! Application System 1.1.0
# ===========================================
export UPS_HOME=/usr/up/ups110

# Lancement Up ! Compiler 1.1.0
# =============================
$UPS_HOME/upscmp/bin/upscmp Source=classab.idl AdaptateurClientCorba=Oui AdaptateurServeurUpsNet=Oui AdaptateurDictionnaire=Oui
$UPS_HOME/upscmp/bin/upscmp Source=client.upl

# Referencement des objets Corba
# ==============================
$MICO_HOME/bin/ird -ORBIIOPAddr inet:localhost:8888 --db %MICO_HOME%/db/db-ird
$MICO_HOME/bin/micod -ORBIIOPAddr inet:localhost:9999 --db %MICO_HOME%/db/db-micod.txt --forward
$MICO_HOME/bin/idl -ORBIfaceRepoAddr inet:localhost:8888 -ORBImplRepoAddr inet:localhost:9999 --no-codegen-c++ --no-codegen-idl --feed-ir -I $MICO_HOME/include/mico classab.idl 

# Lancement C++
# =============
$MICO_HOME/bin/ird -ORBIIOPAddr inet:localhost:8888 --db %MICO_HOME%/db/db-ird
$MICO_HOME/bin/micod -ORBIIOPAddr inet:localhost:9999 --db %MICO_HOME%/db/db-micod.txt --forward
client -ORBIfaceRepoAddr inet:localhost:8888 -ORBImplRepoAddr inet:localhost:9999 -ORBBindAddr local:

