/* ------------------------------------------------------------------- */
/* Fichier    : caractere.cpp                                          */
/* Objet      : Exemple d'emploi d'Up ! Corba.                         */
/*                                                                     */                                                                     
/* Module      : Up ! Appplication System.                             */
/* Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.                    */
/* ------------------------------------------------------------------- */
/*                          Observations                               */
/*                                                                     */
/*                                                                     */
/* ------------------------------------------------------------------- */

#include <CORBA.h>
#include <mico/string.h>
#include <upskrn.hh>
#include <upscrbexception.h>

using namespace std;

static CORBA::ORB *pOrb;
static CORBA::BOA *pBoa;
static CORBA::Object *pObjet;
static IUpsKrn *pIUpsKrn;

/****************************************************************/
int main(int argc, char *argv[])
/****************************************************************/
{
IUpsKrnCaractere_var C;
CORBA::Long L;

pOrb=CORBA::ORB_init(argc,argv,"mico-local-orb");
if (!pOrb)
   return(1);
pBoa=pOrb->BOA_init(argc, argv, "mico-local-boa");
if (!pBoa)
   return(1);
pObjet=pOrb->bind("IDL:IUpsKrn:1.0");
if (!pObjet)
   return(1);
pIUpsKrn=IUpsKrn::_narrow(pObjet);
if (!pIUpsKrn)
   return(1);

try
   {
   C=pIUpsKrn->Caractere2(pIUpsKrn->CorbaBoolean2Booleen(TRUE));
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   C=pIUpsKrn->Caractere5(pIUpsKrn->CorbaLong2Entier(5));
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   C=pIUpsKrn->Caractere8(pIUpsKrn->CorbaDouble2Reel(3.14159));
   cout << pIUpsKrn->Caractere2CorbaString(C)<< endl;
   C=pIUpsKrn->CorbaString2Caractere("Bonjour le monde");
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   C=pIUpsKrn->CorbaString2Caractere("Bonjour")->Additionner(pIUpsKrn->CorbaString2Caractere(" Le"))->Additionner(pIUpsKrn->CorbaString2Caractere(" Monde"));
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   C=pIUpsKrn->CorbaString2Caractere("Bonjour le monde")->Soustraire();
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   L=pIUpsKrn->Entier2CorbaLong(pIUpsKrn->CorbaString2Caractere("Bonjour")->Longueur());
   cout << L << endl;
   C=pIUpsKrn->CorbaString2Caractere("Bonjour le monde")->Gauche(pIUpsKrn->CorbaLong2Entier(5));
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   C=pIUpsKrn->CorbaString2Caractere("Bonjour le monde")->Droite(pIUpsKrn->CorbaLong2Entier(5));
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   C=pIUpsKrn->CorbaString2Caractere("Bonjour le monde")->Milieu(pIUpsKrn->CorbaLong2Entier(2), pIUpsKrn->CorbaLong2Entier(5));
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   C=pIUpsKrn->CorbaString2Caractere("Bonjour le monde")->Majuscule();
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   C=pIUpsKrn->CorbaString2Caractere("Bonjour le monde")->MajMinuscule();
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   C=pIUpsKrn->CorbaString2Caractere("Bonjour le monde")->Minuscule();
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   C=pIUpsKrn->CorbaString2Caractere("Bonjour monde")->Inserer(pIUpsKrn->CorbaString2Caractere(" le"), pIUpsKrn->CorbaLong2Entier(7));
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   L=pIUpsKrn->Entier2CorbaLong(pIUpsKrn->CorbaString2Caractere("Bonjour le monde")->Compter(pIUpsKrn->CorbaString2Caractere("o"), pIUpsKrn->CorbaLong2Entier(0)));
   cout << L << endl;
   L=pIUpsKrn->Entier2CorbaLong(pIUpsKrn->CorbaString2Caractere("Bonjour le monde")->Compter(pIUpsKrn->CorbaString2Caractere("o"), pIUpsKrn->CorbaLong2Entier(4)));
   cout << L << endl;
   C=pIUpsKrn->CorbaString2Caractere("Bonjour XYZT monde")->Remplacer(pIUpsKrn->CorbaString2Caractere("XYZT"), pIUpsKrn->CorbaString2Caractere("le"), pIUpsKrn->CorbaLong2Entier(0));
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   C=pIUpsKrn->CorbaString2Caractere("Bonjour XYZT monde")->Remplacer(pIUpsKrn->CorbaString2Caractere("XYZT"), pIUpsKrn->CorbaString2Caractere("le"), pIUpsKrn->CorbaLong2Entier(4));
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   C=pIUpsKrn->CorbaString2Caractere("Bonjour le monde")->Ajouter(pIUpsKrn->CorbaLong2Entier(20), pIUpsKrn->CorbaString2Caractere(" "));
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   C=pIUpsKrn->CorbaString2Caractere("Bonjour le monde")->Ajouter(pIUpsKrn->CorbaLong2Entier(20), pIUpsKrn->CorbaString2Caractere("."));
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   C=pIUpsKrn->CorbaString2Caractere("Bonjour le monde")->AjouterGauche(pIUpsKrn->CorbaLong2Entier(20), pIUpsKrn->CorbaString2Caractere(" "));
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   C=pIUpsKrn->CorbaString2Caractere("Bonjour le monde")->AjouterGauche(pIUpsKrn->CorbaLong2Entier(20), pIUpsKrn->CorbaString2Caractere("."));
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   C=pIUpsKrn->CorbaString2Caractere("Bonjour le monde")->AjouterDroite(pIUpsKrn->CorbaLong2Entier(20), pIUpsKrn->CorbaString2Caractere(" "));
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   C=pIUpsKrn->CorbaString2Caractere("Bonjour le monde")->AjouterDroite(pIUpsKrn->CorbaLong2Entier(20), pIUpsKrn->CorbaString2Caractere("."));
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   C=pIUpsKrn->CorbaString2Caractere("  Bonjour le monde  ")->Supprimer(pIUpsKrn->CorbaString2Caractere(" "));
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   C=pIUpsKrn->CorbaString2Caractere("..Bonjour le monde..")->Supprimer(pIUpsKrn->CorbaString2Caractere("."));
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   C=pIUpsKrn->CorbaString2Caractere("    Bonjour le monde")->SupprimerGauche(pIUpsKrn->CorbaString2Caractere(" "));
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   C=pIUpsKrn->CorbaString2Caractere("....Bonjour le monde")->SupprimerGauche(pIUpsKrn->CorbaString2Caractere("."));
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   C=pIUpsKrn->CorbaString2Caractere("Bonjour le monde    ")->SupprimerDroite(pIUpsKrn->CorbaString2Caractere(" "));
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   C=pIUpsKrn->CorbaString2Caractere("Bonjour le monde....")->SupprimerDroite(pIUpsKrn->CorbaString2Caractere("."));
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
   L=pIUpsKrn->Entier2CorbaLong(pIUpsKrn->CorbaString2Caractere("Bonjour le monde")->Compter(pIUpsKrn->CorbaString2Caractere("o"), pIUpsKrn->CorbaLong2Entier(0)));
   cout << L << endl;
   L=pIUpsKrn->Entier2CorbaLong(pIUpsKrn->CorbaString2Caractere("Bonjour le monde")->Compter(pIUpsKrn->CorbaString2Caractere("o"), pIUpsKrn->CorbaLong2Entier(3)));
   cout << L << endl;
   C=pIUpsKrn->CorbaString2Caractere("Bonjour le");
   C->AdditionnerAffecter(pIUpsKrn->CorbaString2Caractere(" monde"));
   cout << pIUpsKrn->Caractere2CorbaString(C) << endl;

   C=pIUpsKrn->CorbaString2Caractere("B");
   C=C->Additionner(pIUpsKrn->CorbaString2Caractere("B"));
   if (pIUpsKrn->Booleen2CorbaBoolean(C->Egal(pIUpsKrn->CorbaString2Caractere("B"))))
      cout << "C==B" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(C->Different(pIUpsKrn->CorbaString2Caractere("B"))))
      cout << "C!=B" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(C->InferieurOuEgal(pIUpsKrn->CorbaString2Caractere("B"))))
      cout << "C<=B" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(C->SuperieurOuEgal(pIUpsKrn->CorbaString2Caractere("B"))))
      cout << "C>=B" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(C->Inferieur(pIUpsKrn->CorbaString2Caractere("B"))))
      cout << "C<B" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(C->Superieur(pIUpsKrn->CorbaString2Caractere("B"))))
      cout << "C>B" << endl;
      
   if (pIUpsKrn->Booleen2CorbaBoolean(pIUpsKrn->CorbaString2Caractere("B")->Egal(C)))
      cout << "B==C" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(pIUpsKrn->CorbaString2Caractere("B")->Different(C)))
      cout << "B!=C" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(pIUpsKrn->CorbaString2Caractere("B")->InferieurOuEgal(C)))
      cout << "B<=C" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(pIUpsKrn->CorbaString2Caractere("B")->SuperieurOuEgal(C)))
      cout << "B>=C" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(pIUpsKrn->CorbaString2Caractere("B")->Inferieur(C)))
      cout << "B<C" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(pIUpsKrn->CorbaString2Caractere("B")->Superieur(C)))
      cout << "B>C" << endl;

   C=pIUpsKrn->CorbaString2Caractere("ab");
   C=C->Additionner(pIUpsKrn->CorbaString2Caractere("cd"));
   if (pIUpsKrn->Booleen2CorbaBoolean(C->IdentiqueMajMinuscule(pIUpsKrn->CorbaString2Caractere("def"))))
      cout << "C==def" << endl;
   else
      cout << "C!=def" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(C->IdentiqueMajMinuscule(pIUpsKrn->CorbaString2Caractere("AbCd"))))
      cout << "C==AbCd" << endl;
   else
      cout << "C!=AbCd" << endl;
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   return(1);   
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   return(1);   
   }

C=NULL;
CORBA::release(pIUpsKrn);
pIUpsKrn=NULL;
delete pBoa;
delete pOrb;
return(0);
}