/* ------------------------------------------------------------------- */
/* Fichier    : binaire.cpp                                            */
/* Objet      : Exemple d'emploi d'Up ! Corba.                         */
/*                                                                     */                                                                     
/* Module      : Up ! Appplication System.                             */
/* Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.                    */
/* ------------------------------------------------------------------- */
/*                          Observations                               */
/*                                                                     */
/*                                                                     */
/* ------------------------------------------------------------------- */

#include <CORBA.h>
#include <mico/string.h>
#include <upskrn.hh>
#include <upscrbexception.h>

using namespace std;

static CORBA::ORB *pOrb;
static CORBA::BOA *pBoa;
static CORBA::Object *pObjet;
static IUpsKrn *pIUpsKrn;

/****************************************************************/
int main(int argc, char *argv[])
/****************************************************************/
{
IUpsKrnBinaire_var B;
CORBA::Long L;

pOrb=CORBA::ORB_init(argc,argv,"mico-local-orb");
if (!pOrb)
   return(1);
pBoa=pOrb->BOA_init(argc, argv, "mico-local-boa");
if (!pBoa)
   return(1);
pObjet=pOrb->bind("IDL:IUpsKrn:1.0");
if (!pObjet)
   return(1);
pIUpsKrn=IUpsKrn::_narrow(pObjet);
if (!pIUpsKrn)
   return(1);

try
   {
   B=pIUpsKrn->Binaire2(pIUpsKrn->CorbaString2Caractere("Binaire : "));
   cout << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere11(B)) << endl;
   B=pIUpsKrn->Binaire2(pIUpsKrn->CorbaString2Caractere("Binaire"))->Additionner(pIUpsKrn->Binaire2(pIUpsKrn->CorbaString2Caractere(" : ")));
   cout << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere11(B)) << endl;
   B=pIUpsKrn->Binaire2(pIUpsKrn->CorbaString2Caractere("Binaire"));
   B->AdditionnerAffecter(pIUpsKrn->Binaire2(pIUpsKrn->CorbaString2Caractere(" : ")));
   cout << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere11(B)) << endl;
   B=pIUpsKrn->Binaire2(pIUpsKrn->CorbaString2Caractere("Binaire : "));
   B=B->Soustraire();
   B=B->Soustraire();
   cout << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere11(B)) << endl;
   B=pIUpsKrn->Binaire2(pIUpsKrn->CorbaString2Caractere("Binaire : "));
   L=pIUpsKrn->Entier2CorbaLong(B->Longueur());
   cout << L << endl;
   B=pIUpsKrn->Binaire2(pIUpsKrn->CorbaString2Caractere("Binaire : "))->Gauche(pIUpsKrn->CorbaLong2Entier(4));
   cout << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere11(B)) << endl;
   B=pIUpsKrn->Binaire2(pIUpsKrn->CorbaString2Caractere("Binaire : "))->Droite(pIUpsKrn->CorbaLong2Entier(4));
   cout << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere11(B)) << endl;
   B=pIUpsKrn->Binaire2(pIUpsKrn->CorbaString2Caractere("Binaire : "))->Milieu(pIUpsKrn->CorbaLong2Entier(4), pIUpsKrn->CorbaLong2Entier(9));
   cout << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere11(B))  << endl;
   L=pIUpsKrn->Entier2CorbaLong(pIUpsKrn->Binaire2(pIUpsKrn->CorbaString2Caractere("A"))->Ascii(pIUpsKrn->CorbaLong2Entier(0)));
   cout << L << endl;
   B=pIUpsKrn->Binaire2(pIUpsKrn->CorbaString2Caractere("Binaire"));
   B->AdditionnerAffecter(pIUpsKrn->Binaire2(pIUpsKrn->CorbaString2Caractere(" : ")));
   if (pIUpsKrn->Booleen2CorbaBoolean(B->Egal(pIUpsKrn->Binaire2(pIUpsKrn->CorbaString2Caractere("Binaire : ")))))
      cout << "B==Binaire : " << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(B->Different(pIUpsKrn->Binaire2(pIUpsKrn->CorbaString2Caractere("Binaire : ")))))
      cout << "B!=Binaire : " << endl;
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   return(1);   
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   return(1);   
   }

B=NULL;
CORBA::release(pIUpsKrn);
pIUpsKrn=NULL;
delete pBoa;
delete pOrb;
return(0);
}