/* ------------------------------------------------------------------- */
/* Fichier    : arbre.cpp                                              */
/* Objet      : Exemple d'emploi d'Up ! Corba.                         */
/*                                                                     */                                                                     
/* Module      : Up ! Appplication System.                             */
/* Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.                    */
/* ------------------------------------------------------------------- */
/*                          Observations                               */
/*                                                                     */
/*                                                                     */
/* ------------------------------------------------------------------- */

#include <CORBA.h>
#include <mico/string.h>
#include <upskrn.hh>
#include <upscrbexception.h>

using namespace std;

static const CORBA::UShort CO_ComparaisonAvant=1;
static const CORBA::UShort CO_ComparaisonEgal=2;
static const CORBA::UShort CO_ComparaisonApres=3;
static const CORBA::UShort CO_ComparaisonNul=4;

static CORBA::ORB *pOrb;
static CORBA::BOA *pBoa;
static CORBA::Object *pObjet;
static IUpsKrn *pIUpsKrn;
 
/****************************************************************/
static CORBA::UShort F(IUpsKrnCaractere *O1, IUpsKrnCaractere *O2)
/****************************************************************/
{
try
   {
   if (pIUpsKrn->EstNul((IUpsKrnObjet *)O1) || pIUpsKrn->EstNul((IUpsKrnObjet *)O2))
      return(CO_ComparaisonNul);
   else if (pIUpsKrn->Booleen2CorbaBoolean(O1->Inferieur(O2)))
      return(CO_ComparaisonAvant);
   else if (pIUpsKrn->Booleen2CorbaBoolean(O1->Superieur(O2)))
      return(CO_ComparaisonApres);
   else
      return(CO_ComparaisonEgal);
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   }
return(0);
}

/****************************************************************/
static void EcrireArbre(IUpsKrnArbreBinaire *A)
/****************************************************************/
{
IUpsKrnCaractere_var C;

try
   {
   C=(IUpsKrnCaractere *)A->ParcoursAuDebut(0);
   for (;;)
      {
      cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
      if (C->Identique(A->DernierElement()))
         break;
      C=(IUpsKrnCaractere *)A->Suivant(0);
      }
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   }
}

/****************************************************************/
static void EcrireArbre2(IUpsKrnArbreBinaire *A)
/****************************************************************/
{
IUpsKrnCaractere_var C;

try
   {
   C=(IUpsKrnCaractere *)A->ParcoursALaFin(0);
   for (;;)
      {
      cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
      if (C->Identique(A->PremierElement()))
         break;
      C=(IUpsKrnCaractere *)A->Precedent(0);
      }
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   }
}

/****************************************************************/
static void EcrireArbre3(IUpsKrnArbreBinaire *A)
/****************************************************************/
{
IUpsKrnCaractere_var C;

try
   {
   C=(IUpsKrnCaractere *)A->ParcoursAuDebut(0);
   for (;;)
      {
      cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
      if (C->Identique(A->DernierElement()))
         break;
      C=(IUpsKrnCaractere *)A->SuivantGroupe(0);
      }
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   }
}

/****************************************************************/
static void EcrireArbre4(IUpsKrnArbreBinaire *A)
/****************************************************************/
{
IUpsKrnCaractere_var C;

try
   {
   C=(IUpsKrnCaractere *)A->ParcoursALaFin(0);
   for (;;)
      {
      cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
      if (C->Identique(A->PremierElement()))
         break;
      C=(IUpsKrnCaractere *)A->PrecedentGroupe(0);
      }
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   }
}

/****************************************************************/
static void EcrireArbre5(IUpsKrnArbreBinaire *A)
/****************************************************************/
{
IUpsKrnCaractere_var C;

try
   {
   C=(IUpsKrnCaractere *)A->ParcoursAuDebut(0);
   for (;;)
      {
      cout << "Groupe " << pIUpsKrn->Caractere2CorbaString(pIUpsKrn->Caractere5(A->NumeroGroupe(0))) << endl;
      C=(IUpsKrnCaractere *)A->PremierElementGroupe(0);
      for (;;)
         {
         cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
         if  (C->Identique(A->DernierElementGroupe(0)))
            break;
         C=(IUpsKrnCaractere *)A->Suivant(0);
         }
      if (C->Identique(A->DernierElement()))
         break;
      C=(IUpsKrnCaractere *)A->SuivantGroupe(0);
      }
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   }
}

/****************************************************************/
int main(int argc, char *argv[])
/****************************************************************/
{
IUpsKrnArbreBinaire_var A1;
IUpsKrnArbreBinaire_var A2;
IUpsKrnArbreBinaire_var A3;
IUpsKrnCaractere_var Coucou;
IUpsKrnCaractere_var Bonjour;
IUpsKrnCaractere_var Salut;
IUpsKrnCaractere_var Schluss;
CORBA::Long I;
IUpsKrnCaractere_var LibelleA;
IUpsKrnCaractere_var LibelleB;
IUpsKrnCaractere_var LibelleC;
IUpsKrnCaractere_var LibelleD;
IUpsKrnCaractere_var LibelleE;
IUpsKrnCaractere_var LibelleF;

pOrb=CORBA::ORB_init(argc,argv,"mico-local-orb");
if (!pOrb)
   return(1);
pBoa=pOrb->BOA_init(argc, argv, "mico-local-boa");
if (!pBoa)
   return(1);
pObjet=pOrb->bind("IDL:IUpsKrn:1.0");
if (!pObjet)
   return(1);
pIUpsKrn=IUpsKrn::_narrow(pObjet);
if (!pIUpsKrn)
   return(1);

try
   {
   Coucou=pIUpsKrn->CorbaString2Caractere("coucou");
   Bonjour=pIUpsKrn->CorbaString2Caractere("bonjour");
   Salut=pIUpsKrn->CorbaString2Caractere("salut");
   Schluss=pIUpsKrn->CorbaString2Caractere("schluss");
   A1=pIUpsKrn->ArbreBinaire1(pIUpsKrn->CorbaAppel2Appel("unsigned short F(in IUpsKrn::Caractere O1, in IUpsKrn::Caractere O2)", (CORBA::LongLong)F), FALSE);
   A1->AdditionnerAffecter((IUpsKrnObjet *)&(*Bonjour));
   A1->AdditionnerAffecter((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("hello"));
   A1->AdditionnerAffecter((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("guten tag"));
   A1->AdditionnerAffecter((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("hello"));
   A1->AdditionnerAffecter((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("coucou"));
   A1->AdditionnerAffecter((IUpsKrnObjet *)&(*Coucou));
   A1->AdditionnerAffecter((IUpsKrnObjet *)&(*Salut));
   A1->AdditionnerAffecter((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("hie"));
   A1->AdditionnerAffecter((IUpsKrnObjet *)&(*Schluss));
   EcrireArbre(A1);
   cout << endl;
   cout << endl;
   EcrireArbre2(A1);
   cout << endl;
   cout << endl;
   EcrireArbre3(A1);
   cout << endl;
   cout << endl;
   EcrireArbre4(A1);
   cout << endl;
   cout << endl;

   A2=pIUpsKrn->ArbreBinaire1(pIUpsKrn->CorbaAppel2Appel("unsigned short F(in IUpsKrn::Caractere O1, in IUpsKrn::Caractere O2)", (CORBA::LongLong)F), FALSE);
   A2->AdditionnerAffecter((IUpsKrnObjet *)&(*Schluss));
   A2->AdditionnerAffecter((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("hie"));
   A2->AdditionnerAffecter((IUpsKrnObjet *)&(*Salut));
   A2->AdditionnerAffecter((IUpsKrnObjet *)&(*Coucou));
   A2->AdditionnerAffecter((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("bonjour"));
   A2->AdditionnerAffecter((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("hello"));
   A2->AdditionnerAffecter((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("guten tag"));
   A2->AdditionnerAffecter((IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("hello"));
   A2->AdditionnerAffecter((IUpsKrnObjet *)&(*Bonjour));
   EcrireArbre5(A2);
   cout << endl;
   cout << endl;

   if (pIUpsKrn->Booleen2CorbaBoolean(A1->Egal(A2)))
      cout << "A1==A2" << endl;
   if (pIUpsKrn->Booleen2CorbaBoolean(A1->Different(A2)))
      cout << "A1!=A2" << endl;
   cout << pIUpsKrn->Caractere2CorbaString((IUpsKrnCaractere *)A1->PremierElement()) << endl;
   cout << pIUpsKrn->Caractere2CorbaString((IUpsKrnCaractere *)A1->DernierElement()) << endl;
   cout << A1->NbElements() << endl;
   cout << A1->NbGroupes() << endl;
   cout << endl;
   cout << endl;

   cout << pIUpsKrn->Entier2CorbaLong(A1->Compter((IUpsKrnObjet *)&(*Bonjour))) << endl;
   cout << endl;
   cout << endl;
   A2=A2->SupprimerTous((IUpsKrnObjet *)&(*Schluss));
   EcrireArbre(A2);
   cout << endl;
   cout << endl;
   A2=A2->RemplacerTous((IUpsKrnObjet *)&(*Bonjour), (IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("hola"));
   EcrireArbre(A2);
   cout << endl;
   cout << endl;

   A2=A1->Gauche((IUpsKrnObjet *)&(*Coucou));
   EcrireArbre(A2);
   cout << endl;
   cout << endl;
   A2=A1->Gauche((IUpsKrnObjet *)&(*Salut));
   EcrireArbre(A2);
   cout << endl;
   cout << endl;
   A2=A1->Droite((IUpsKrnObjet *)&(*Coucou));
   EcrireArbre(A2);
   cout << endl;
   cout << endl;
   A2=A1->Droite((IUpsKrnObjet *)&(*Salut));
   EcrireArbre(A2);
   cout << endl;
   cout << endl;
   A2=A1->Milieu((IUpsKrnObjet *)&(*Coucou), (IUpsKrnObjet *)&(*Salut));
   EcrireArbre(A2);
   cout << endl;
   cout << endl;

   A2=A1;
   EcrireArbre(A2);
   cout << endl;
   cout << endl;
   for (I=0;;I++)
      {
      cout << pIUpsKrn->Caractere2CorbaString((IUpsKrnCaractere *)A1->Index(pIUpsKrn->CorbaLong2Entier(I))) << endl;
      if (I==A1->NbElements()-1)
         break;
      }
   cout << endl;
   cout << endl;

   LibelleA=pIUpsKrn->CorbaString2Caractere("A");
   LibelleB=pIUpsKrn->CorbaString2Caractere("B");
   LibelleC=pIUpsKrn->CorbaString2Caractere("C");
   LibelleD=pIUpsKrn->CorbaString2Caractere("D");
   LibelleE=pIUpsKrn->CorbaString2Caractere("E");
   LibelleF=pIUpsKrn->CorbaString2Caractere("F");
   A1=pIUpsKrn->ArbreBinaire1(pIUpsKrn->CorbaAppel2Appel("unsigned short F(in IUpsKrn::Caractere O1, in IUpsKrn::Caractere O2)", (CORBA::LongLong)F), FALSE);
   A1->AdditionnerAffecter((IUpsKrnObjet *)&(*LibelleA));
   A1->AdditionnerAffecter((IUpsKrnObjet *)&(*LibelleB));
   A1->AdditionnerAffecter((IUpsKrnObjet *)&(*LibelleC));
   A1->AdditionnerAffecter((IUpsKrnObjet *)&(*LibelleD));
   A2=pIUpsKrn->ArbreBinaire1(pIUpsKrn->CorbaAppel2Appel("unsigned short F(in IUpsKrn::Caractere O1, in IUpsKrn::Caractere O2)", (CORBA::LongLong)F), FALSE);
   A2->AdditionnerAffecter((IUpsKrnObjet *)&(*LibelleC));
   A2->AdditionnerAffecter((IUpsKrnObjet *)&(*LibelleD));
   A2->AdditionnerAffecter((IUpsKrnObjet *)&(*LibelleE));
   A2->AdditionnerAffecter((IUpsKrnObjet *)&(*LibelleF));
   A3=A1->Union_(A2);
   EcrireArbre(A3);
   cout << endl;
   cout << endl;
   A3=A1->Intersection(A2);
   EcrireArbre(A3);
   cout << endl;
   cout << endl;
   A3=A1->Soustraction(A2);
   EcrireArbre(A3);
   cout << endl;
   cout << endl;
   A3=A1->Exclusion(A2);
   EcrireArbre(A3);
   cout << endl;
   cout << endl;
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   return(1);   
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   return(1);   
   }

A1=NULL;
A2=NULL;
A3=NULL;
Coucou=NULL;
Bonjour=NULL;
Salut=NULL;
Schluss=NULL;
LibelleA=NULL;
LibelleB=NULL;
LibelleC=NULL;
LibelleD=NULL;
LibelleE=NULL;
LibelleF=NULL;
CORBA::release(pIUpsKrn);
pIUpsKrn=NULL;
delete pBoa;
delete pOrb;
return(0);
}