/* ------------------------------------------------------------------- */
/* Fichier    : annuaire.cpp                                           */
/* Objet      : Exemple d'emploi d'Up ! Corba.                         */
/*                                                                     */                                                                     
/* Module      : Up ! Appplication System.                             */
/* Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.                    */
/* ------------------------------------------------------------------- */
/*                          Observations                               */
/*                                                                     */
/*                                                                     */
/* ------------------------------------------------------------------- */

#include <CORBA.h>
#include <mico/string.h>
#include <upskrn.hh>
#include <upssys.hh>
#include <upsnls.hh>
#include <upsnet.hh>
#include <upssec.hh>
#include <upsorb.hh>
#include <upscrbexception.h>

using namespace std;

static CORBA::ORB *pOrb;
static CORBA::BOA *pBoa;
static CORBA::Object *pObjet;
static IUpsKrn *pIUpsKrn;
static IUpsOrb *pIUpsOrb;
static IUpsOrbAnnuaire *A;

/****************************************************************/
static void AfficherAnnuaire2(IUpsOrbAnnuaire *An, IUpsKrnCaractere *Chemin)
/****************************************************************/
{
IUpsKrnListe_var L;
IUpsKrnCaractere_var C;

try
   {
   L=An->LireArborescenceAnnuaire(Chemin);
   if (!pIUpsKrn->EstNul((IUpsKrnObjet *)&(*L)))
      {
      C=(IUpsKrnCaractere *)L->ParcoursAuDebut(0);
      for (;;)
         {
         if (pIUpsKrn->Booleen2CorbaBoolean(Chemin->Different(pIUpsKrn->CorbaString2Caractere(""))))
            {
            cout << pIUpsKrn->Caractere2CorbaString(Chemin->Additionner(pIUpsKrn->CorbaString2Caractere("."))->Additionner(C)) << endl;
            AfficherAnnuaire2(An, Chemin->Additionner(pIUpsKrn->CorbaString2Caractere("."))->Additionner(C));
            }
         else
            {
            cout << pIUpsKrn->Caractere2CorbaString(C) << endl;
            AfficherAnnuaire2(An, C);
            }
         if (C->Identique(L->DernierElement()))
            break;
         C=(IUpsKrnCaractere *)L->Suivant(0);
         }
      }
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   }
}

/****************************************************************/
static void AfficherAnnuaire(IUpsOrbAnnuaire *An)
/****************************************************************/
{
try
   {
   cout << pIUpsKrn->Caractere2CorbaString(An->NomAnnuaire()) << endl;
   AfficherAnnuaire2(An, pIUpsKrn->CorbaString2Caractere(""));
   cout << endl;
   cout << endl;
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   }
}

/****************************************************************/
int main(int argc, char *argv[])
/****************************************************************/
{
IUpsKrnListe_var L;
IUpsKrnCaractere_var C; 

pOrb=CORBA::ORB_init(argc,argv,"mico-local-orb");
if (!pOrb)
   return(1);
pBoa=pOrb->BOA_init(argc, argv, "mico-local-boa");
if (!pBoa)
   return(1);
pObjet=pOrb->bind("IDL:IUpsKrn:1.0");
if (!pObjet)
   return(1);
pIUpsKrn=IUpsKrn::_narrow(pObjet);
if (!pIUpsKrn)
   return(1);
pObjet=pOrb->bind("IDL:IUpsOrb:1.0");
if (!pObjet)
   return(1);
pIUpsOrb=IUpsOrb::_narrow(pObjet);
if (!pIUpsOrb)
   return(1);

try
   {
   A=pIUpsOrb->Annuaire1(pIUpsKrn->CorbaString2Caractere("MonAnnuaire"));
   A->EcrireEntree(pIUpsKrn->CorbaString2Caractere("coucou"), (IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("COUCOU"));
   A->EcrireEntree(pIUpsKrn->CorbaString2Caractere("hello"), (IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("HELLO"));
   A->EcrireEntree(pIUpsKrn->CorbaString2Caractere("guten tag"), (IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("GUTEN TAG"));
   A->EcrireEntree(pIUpsKrn->CorbaString2Caractere("coucou.coucou"), (IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("COUCOU.COUCOU"));
   A->EcrireEntree(pIUpsKrn->CorbaString2Caractere("hello.coucou"), (IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("HELLO.COUCOU"));
   A->EcrireEntree(pIUpsKrn->CorbaString2Caractere("coucou.hello"), (IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("COUCOU.HELLO"));
   A->EcrireEntree(pIUpsKrn->CorbaString2Caractere("hello.hello"), (IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("HELLO.HELLO"));
   A->EcrireEntree(pIUpsKrn->CorbaString2Caractere("hello.guten tag"), (IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("HELLO.GUTEN TAG"));
   A->EcrireEntree(pIUpsKrn->CorbaString2Caractere("coucou.guten tag"), (IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("COUCOU.GUTEN TAG"));
   A->EcrireEntree(pIUpsKrn->CorbaString2Caractere("guten tag.coucou"), (IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("GUTEN TAG.COUCOU"));
   A->EcrireEntree(pIUpsKrn->CorbaString2Caractere("guten tag.hello"), (IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("GUTEN TAG.HELLO"));
   A->EcrireEntree(pIUpsKrn->CorbaString2Caractere("guten tag.guten tag"), (IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("GUTEN TAG.GUTEN TAG"));
   AfficherAnnuaire(A);

   cout << pIUpsKrn->Caractere2CorbaString((IUpsKrnCaractere *)A->LireEntree(pIUpsKrn->CorbaString2Caractere("coucou"))) << endl;
   cout << pIUpsKrn->Caractere2CorbaString((IUpsKrnCaractere *)A->LireEntree(pIUpsKrn->CorbaString2Caractere("coucou.coucou"))) << endl;
   cout << pIUpsKrn->Caractere2CorbaString((IUpsKrnCaractere *)A->LireEntree(pIUpsKrn->CorbaString2Caractere("coucou.guten tag"))) << endl;
   cout << pIUpsKrn->Caractere2CorbaString((IUpsKrnCaractere *)A->LireEntree(pIUpsKrn->CorbaString2Caractere("coucou.hello"))) << endl;
   cout << pIUpsKrn->Caractere2CorbaString((IUpsKrnCaractere *)A->LireEntree(pIUpsKrn->CorbaString2Caractere("hello"))) << endl;
   cout << pIUpsKrn->Caractere2CorbaString((IUpsKrnCaractere *)A->LireEntree(pIUpsKrn->CorbaString2Caractere("hello.coucou"))) << endl;
   cout << pIUpsKrn->Caractere2CorbaString((IUpsKrnCaractere *)A->LireEntree(pIUpsKrn->CorbaString2Caractere("hello.guten tag"))) << endl;
   cout << pIUpsKrn->Caractere2CorbaString((IUpsKrnCaractere *)A->LireEntree(pIUpsKrn->CorbaString2Caractere("hello.hello"))) << endl;
   cout << pIUpsKrn->Caractere2CorbaString((IUpsKrnCaractere *)A->LireEntree(pIUpsKrn->CorbaString2Caractere("guten tag"))) << endl;
   cout << pIUpsKrn->Caractere2CorbaString((IUpsKrnCaractere *)A->LireEntree(pIUpsKrn->CorbaString2Caractere("guten tag.coucou"))) << endl;
   cout << pIUpsKrn->Caractere2CorbaString((IUpsKrnCaractere *)A->LireEntree(pIUpsKrn->CorbaString2Caractere("guten tag.guten tag"))) << endl;
   cout << pIUpsKrn->Caractere2CorbaString((IUpsKrnCaractere *)A->LireEntree(pIUpsKrn->CorbaString2Caractere("guten tag.hello"))) << endl;
   cout << endl;
   cout << endl;

   A->SupprimerEntree(pIUpsKrn->CorbaString2Caractere("hello.hello"), FALSE);
   A->SupprimerEntree(pIUpsKrn->CorbaString2Caractere("guten tag"), TRUE);
   A->EcrireEntree(pIUpsKrn->CorbaString2Caractere("hello"), (IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("HELLO !!!"));
   A->EcrireEntree(pIUpsKrn->CorbaString2Caractere("coucou.hello"), (IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("COUCOU.HELLO !!!"));
   A->RenommerEntree(pIUpsKrn->CorbaString2Caractere("coucou"), pIUpsKrn->CorbaString2Caractere("salut"), TRUE);
   A->RenommerEntree(pIUpsKrn->CorbaString2Caractere("hello.guten tag"), pIUpsKrn->CorbaString2Caractere("good morning.schluss"), FALSE);
   cout << pIUpsKrn->Caractere2CorbaString((IUpsKrnCaractere *)A->LireEntree(pIUpsKrn->CorbaString2Caractere("hello"))) << endl;
   cout << pIUpsKrn->Caractere2CorbaString((IUpsKrnCaractere *)A->LireEntree(pIUpsKrn->CorbaString2Caractere("salut.hello"))) << endl;
   cout << pIUpsKrn->Caractere2CorbaString((IUpsKrnCaractere *)A->LireEntree(pIUpsKrn->CorbaString2Caractere("salut"))) << endl;
   cout << endl;
   cout << endl;

   AfficherAnnuaire(A);

   pIUpsOrb->AnnuaireLocal()->EcrireEntree(pIUpsKrn->CorbaString2Caractere("coucou"), (IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("COUCOU"));
   pIUpsOrb->AnnuaireLocal()->EcrireEntree(pIUpsKrn->CorbaString2Caractere("hello"), (IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("HELLO"));
   pIUpsOrb->AnnuaireLocal()->EcrireEntree(pIUpsKrn->CorbaString2Caractere("guten tag"), (IUpsKrnObjet *)pIUpsKrn->CorbaString2Caractere("GUTEN TAG"));
   pIUpsOrb->AnnuaireLocal()->SupprimerEntree(pIUpsKrn->CorbaString2Caractere("hello"), FALSE);
   pIUpsOrb->AnnuaireLocal()->RenommerEntree(pIUpsKrn->CorbaString2Caractere("guten tag"), pIUpsKrn->CorbaString2Caractere("schluss"), FALSE);
   AfficherAnnuaire(pIUpsOrb->AnnuaireLocal());

   L=pIUpsOrb->LireArborescenceAnnuaireGlobal(pIUpsKrn->CorbaString2Caractere(""));
   C=(IUpsKrnCaractere *)L->ParcoursAuDebut(0);
   for (;;)
      {
      cout << pIUpsKrn->Caractere2CorbaString(C->Additionner(pIUpsKrn->CorbaString2Caractere("="))->Additionner((IUpsKrnCaractere *)pIUpsOrb->LireEntreeAnnuaireGlobal(C))) << endl;
      if (C->Identique(L->DernierElement()))
         break;
      C=(IUpsKrnCaractere *)L->Suivant(0);
      }
   }
catch (UpsCrbException *E)
   {
   cout << "Erreur UpsKrn-0 : L'exception suivante a t envoye dans le source '" << E->NomSourceEnErreur << "' :" << endl;
   cout << E->MessageErreur << endl;
   return(1);   
   }
catch (CORBA::Exception &e)
   {
   cout << "Erreur Mico : L'exception suivante a t envoye :" << endl;
   cout << e << endl;
   return(1);   
   }

A=NULL;
L=NULL;
C=NULL;
CORBA::release(pIUpsOrb);
pIUpsOrb=NULL;
CORBA::release(pIUpsKrn);
pIUpsKrn=NULL;
delete pBoa;
delete pOrb;
return(0);
}