/*-------------------------------------------------------------------
Fichier     : upscom_nt.e
Objet       : En-tete de Up ! Component Object Module

Module      : Up ! Component Object Module
Auteur-Date : DUVAL Jean-Pierre - Novembre 2003.
---------------------------------------------------------------------
                        Observations
                   
---------------------------------------------------------------------*/ 

/********************************/
#if !defined(PasseModuleUpsComNat)
/********************************/
#define PasseModuleUpsComNat 1

/**********************/
#if defined(__cplusplus)
/**********************/
extern "C"
{
/****/
#endif
/****/

/*********************/
#if defined(__CYGWIN__)
/*********************/
typedef short boolean;
/****/
#endif
/****/

/****************************/
#if defined(PLATEFORMEWINDOWS)
/****************************/
#define _WIN32_WINNT 0x0500
#define _WIN32_DCOM 1
/****/
#endif
/****/

/****************************************************************/
/* Codification des codes d'erreurs.                            */
/****************************************************************/
enum EnuUpsComCodeErreur
   {
   CED_Ok=0,
   CED_OutOfMemory=1,
   CED_DispEException=2,
   CED_EUnexpected=3,
   CED_DispEBadIndex=4,
   CED_StgEMediumFull=5,
   CED_False=6,
   CED_ENoInterface=7
   };

/****************************************************************/
/* Codification des types.                                      */
/****************************************************************/
enum EnuUpsComTypeKind
   {
   TK_Enum=0,
	TK_Record=1,
	TK_Module=2,
	TK_Interface=3,
	TK_Dispatch=4,
	TK_CoClass=5,
	TK_Alias=6,
	TK_Union=7,
	TK_Max=8
   };

/****************************************************************/
/* Codification des types du variant.                           */
/****************************************************************/
enum EnuUpsComVarType
   {
   VA_Empty=0,
   VA_Null=1,
   VA_I2=2,
   VA_I4=3,
   VA_R4=4,
   VA_R8=5,
   VA_Cy=6,
   VA_Date=7,
   VA_BStr=8,
   VA_Dispatch=9,
   VA_Error=10,
   VA_Bool=11,
   VA_Variant=12,
   VA_Unknown=13,
   VA_Decimal=14,
   VA_I1=16,
   VA_Ui1=17,
   VA_Ui2=18,
   VA_Ui4=19,
   VA_I8=20,
   VA_Ui8=21,
   VA_Int=22,
   VA_UInt=23,
   VA_Void=24,
   VA_HResult=25,
   VA_Ptr=26,
   VA_SafeArray=27,
   VA_CArray=28,
   VA_UserDefined=29,
   VA_LpStr=30,
   VA_LpWStr=31,
   VA_FileTime=64,
   VA_Blob=65,
   VA_Stream=66,
   VA_Storage=67,
   VA_StreamedObject=68,
   VA_StoredObject=69,
   VA_BlobObject=70,
   VA_CF=71,
   VA_Clsid=72,
   VA_Vector=0x1000,
   VA_Array=0x2000,
   VA_ByRef=0x4000,
   VA_Reserved=0x8000,
   VA_Illegal=0xffff,
   VA_IllegalMasked=0xfff,
   VA_TypeMask=0xfff
   };

/****************************************************************/
/* Codification des modes d'invocation.                         */
/****************************************************************/
enum EnuUpsComInvokeKind
   {
   IK_Func=1,
   IK_PropertyGet=2,
   IK_PropertyPut=4,
   IK_PropertyPutRef=8
   };

/****************************************************************/
/* Codification des modes d'appel.                              */
/****************************************************************/
enum EnuUpsComCallConv
   {
   CC_FastCall=0,
   CC_CDecl=1,
   CC_MscPascal=2,
   CC_Pascal=2,
   CC_MacPascal=3,
   CC_StdCall=4,
   CC_FpFastCall=5,
   CC_SysCall=6,
   CC_MpwCDecl=7,
   CC_MpwPascal=8,
   CC_Max=9
   };

/****************************************************************/
/* Codification des types de variable.                          */
/****************************************************************/
enum EnuUpsComVarKind
   {
   VK_PerInstance=0,
   VK_Static=1,
   VK_Const=2,
   VK_Dispatch=3
   };

/****************************************************************/
/* Codification des inflexions d'une variable.                  */
/****************************************************************/
enum EnuUpsComVarFlags
   {	
   VF_FReadOnly=0x1,
   VF_FSource=0x2,
   VF_FBindable=0x4,
   VF_FRequestEdit=0x8,
   VF_FDisplayBind=0x10,
   VF_FDefaultBind=0x20,
   VF_FHidden=0x40,
   VF_FRestricted=0x80,
   VF_FDefaultCollElem=0x100,
   VF_FUiDefault=0x200,
   VF_FNonBrowsable=0x400,
   VF_FReplaceable=0x800,
   VF_FImmediateBind=0x1000
   };

/****************************************************************/
/* Codification des inflexions d'un parametre.                  */
/****************************************************************/
enum EnuUpsComParamFlags
   {	
   PF_None=0,
   PF_FIn=0x1,
   PF_FOut=0x2,
   PF_FLcid=0x4,
   PF_FRetVal=0x8,
   PF_FOpt=0x10,
   PF_FHasDefault=0x20,
   PF_FHasCustData=0x40
   };

/****************************************************************/
/* Codification des inflexions d'un appel.                      */
/****************************************************************/
enum EnuUpsFuncFlags
   {	
   FF_FRestricted=0x1,
   FF_FSource=0x2,
   FF_FBindable=0x4,
   FF_FRequestEdit=0x8,
   FF_FDisplayBind=0x10,
   FF_FDefaultBind=0x20,
   FF_FHidden=0x40,
   FF_FUsesGetLastError=0x80,
   FF_FDefaultCollElem=0x100,
   FF_FUiDefault=0x200,
   FF_FNonBrowsable=0x400,
   FF_FReplaceable=0x800,
   FF_FImmediateBind=0x1000
   };

/****************************************************************/
/* Codification des inflexions d'un appel.                      */
/****************************************************************/
enum EnuUpsComFuncKind
   {	
   FK_Virtual=0,
   FK_PureVirtual=1,
   FK_NonVirtual=2,
   FK_Static=3,
   FK_Dispatch=4
   };

/****************************************************************/
/* Codification des inflexions d'un appel.                      */
/****************************************************************/
enum EnuUpsComImplTypeFlag
   {
   ITF_FDefault=0x1,
   ITF_FSource=0x2,
   ITF_FRestricted=0x4,
   ITF_FDefaultVTable=0x8
   };

/****************************************************************/
/* Codification des deplacements dans un stream.                */
/****************************************************************/
enum EnuUpsComStreamSeek
   {	
   SS_Set=0,
   SS_Cur=1,
   SS_End=2
   };

/****************************************************************/
/* Codification constructeurs C speciaux.                       */
/****************************************************************/
enum EnuUpsComObjetC
   {	
   OCD_Char=1,
   OCD_UnsignedChar=2,
   OCD_Short=3,
   OCD_UnsignedShort=4,
   OCD_VariantBool=5,
   OCD_Int=6,
   OCD_UnsignedInt=7,
   OCD_Long=8,
   OCD_UnsignedLong=9,
   OCD_Float=10,
   OCD_Scode=11,
   OCD_LargeInteger=12,
   OCD_ULargeInteger=13,
   OCD_Double=14,
   OCD_Cy=15,
   OCD_Date=16,
   OCD_Decimal=17,
   OCD_FileTime=18,
   OCD_SystemTime=19,
   OCD_ClsId=20,
   OCD_ClipData=21,
   OCD_BStr=22,
   OCD_LPStr=23,
   OCD_LPWStr=24,
   OCD_CaUb=25,
   OCD_CaI=26,
   OCD_CaUi=27,
   OCD_CaBool=28,
   OCD_CaL=29,
   OCD_CaUl=30,
   OCD_CaFlt=31,
   OCD_CaScode=32,
   OCD_CaH=33,
   OCD_CaUh=34,
   OCD_CaDbl=35,
   OCD_CaCy=36,
   OCD_CaDate=37,
   OCD_CaFileTime=38,
   OCD_CaClsId=39,
   OCD_CaClipData=40,
   OCD_CaBStr=41,
   OCD_CaLPStr=42,
   OCD_CaLPWStr=43,
   OCD_CaPropVariant=44,
   OCD_PropVariant=45,
   OCD_ByteBlob=46,
   OCD_WordBlob=47,
   OCD_DwordBlob=49,
   OCD_FlaggedByteBlob=50,
   OCD_FlaggedWordBlob=51,
   OCD_ByteSizeDArr=52,
   OCD_WordSizeDArr=53,
   OCD_DwordSizeDArr=54,
   OCD_HyperSizeDArr=55,
   OCD_RemHGlobal=56,
   OCD_RemHEnhMetaFile=57,
   OCD_RemHBitmap=58,
   OCD_RemHPalette=59,
   OCD_RemHBrush=60,
   OCD_Variant=61,
   OCD_SafeArray=62,
   OCD_ByRef=63,
   OCD_ByRefChar=64,
   OCD_ByRefUnsignedChar=65,
   OCD_ByRefShort=66,
   OCD_ByRefUnsignedShort=67,
   OCD_ByRefInt=68,
   OCD_ByRefUnsignedInt=69,
   OCD_ByRefLong=70,
   OCD_ByRefUnsignedLong=71,
   OCD_ByRefFloat=72,
   OCD_ByRefDouble=73,
   OCD_ByRefVariantBool=74,
   OCD_ByRefScode=75,
   OCD_ByRefDecimal=76,
   OCD_ByRefCy=77,
   OCD_ByRefDate=78,
   OCD_ByRefBStr=79,
   OCD_ByRefSafeArray=80,
   OCD_ByRefVariant=81,
   OCD_CustData=82,
   OCD_CustDataItem=83,
   OCD_IDispatch=84
   };

/****************************************************************/
/* Codification du code erreur de DllRegister.                  */
/****************************************************************/
enum EnuUpsComDllRegister
   {
   DR_ParametresInvalides=1,
      /* Parametres invalides. */
   DR_ChargementImpossible=2,
      /* Chargement impossible de l'ActiveX. */
   DR_ApiNonTrouvee=3,
      /* L'API est non trouvee. */
   DR_PlusDeMemoire=4,
      /* Plus de memoire. */
   DR_EnregistrementImpossible=5,
      /* Enregistrement impossible. */
   DR_ErreurInconnue=6,
      /* Erreur inconnue. */
   DR_AutresVersionsDisponibles=7
      /* D'autres sont disponibles. */
   };

typedef TypUpsVmUnsignedChar TypUpsComByte;
typedef TypUpsVmUnsignedShort TypUpsComOleChar;
typedef TypUpsVmUnsignedShort TypUpsComWCharT;
typedef TypUpsComOleChar *TypUpsComBStr;

/****************************************************************/
typedef struct typupscomiid
/* Objet : Pour modeliser un GUID.                              */
/****************************************************************/
{
TypUpsVmUnsignedLong Data1;
TypUpsVmUnsignedShort Data2;
TypUpsVmUnsignedShort Data3;
TypUpsVmUnsignedChar Data4[8];
} TypUpsComIId;

typedef TypUpsComIId * TypUpsComRefIId;
typedef TypUpsVmShort TypUpsComVariantBool;

#define UpsComCodeErreur(C) ((C)&0xFFFF)
#define UpsComCoderVariantBool(B) (TypUpsComVariantBool)(B?-1:0)
#define UpsComCoderBool(B) (TypUpsVmLong)(B?-1:0)
#define UpsComDecoderVariantBool(B) (TypUpsVmUnsignedChar)(B?1:0)
#define UpsComDecoderBool(B) (TypUpsVmUnsignedChar)(B?1:0)
#define ExternGuid(Definition, D1, D2, D3, D40, D41, D42, D43, D44, D45, D46, D47) extern TypUpsComIId Definition
#define DefineGuid(Definition, D1, D2, D3, D40, D41, D42, D43, D44, D45, D46, D47) TypUpsComIId Definition = {D1, D2, D3, {D40, D41, D42, D43, D44, D45, D46, D47}}

typedef struct typupscomvariant TypUpsComVariant;
typedef struct typupscomvariant TypUpsComVariantArg;

/****************************************************************/
typedef struct typupscomtypedescription 
/* Objet : TYPEDESC.                                            */
/****************************************************************/
{
union 
   {
   struct typupscomtypedescription *lptdesc;
   struct typupscomarraydescription *lpadesc;
   TypUpsVmLong hreftype;
   } u;
TypUpsVmUnsignedShort vt;
} TypUpsComTypeDescription;

/****************************************************************/
typedef struct typupscomsafearraybound
/* Objet : ARRAYBOUND.                                          */
/****************************************************************/
{
TypUpsVmUnsignedLong cElements;
TypUpsVmLong lLbound;
} TypUpsComSafeArrayBound;

/****************************************************************/
typedef struct typupscomarraydescription
/* Objet : ARRAYDESC.                                           */
/****************************************************************/
{
TypUpsComTypeDescription tdescElem;
TypUpsVmUnsignedShort cDims;
TypUpsComSafeArrayBound rgbounds[1];
} TypUpsComArrayDescription;

/****************************************************************/
typedef struct typupscomidldescription
/* Objet : IDLDESC.                                             */
/****************************************************************/
{
TypUpsVmUnsignedShort wIDLFlags;
} TypUpsComIdlDescription;

/****************************************************************/
typedef struct upscomtypeattributs 
/* Objet : TYPEATTR.                                            */
/****************************************************************/
{
TypUpsComIId guid;
TypUpsVmLong lcid;
TypUpsVmShort memidConstructor;
TypUpsVmShort memidDestructor;
TypUpsVmShort wMajorVerNum;
TypUpsVmShort wMinorVerNum;
TypUpsVmLong cFuncs;
TypUpsVmLong cVars;
TypUpsVmLong cImplTypes;
enum EnuUpsComTypeKind typekind;
TypUpsComTypeDescription tdescAlias;
TypUpsComIdlDescription idldescType;
} TypUpsComTypeAttributs;

/****************************************************************/
typedef struct typupscomlibrairieattributs
/* Objet : TLIBATTR.                                            */
/****************************************************************/
{
TypUpsComIId guid;
TypUpsVmLong lcid;
TypUpsVmShort wMajorVerNum;
TypUpsVmShort wMinorVerNum;
} TypUpsComLibrairieAttributs;

/****************************************************************/
typedef struct  typupscomdecimal
/* Objet : DECIMAL.                                             */
/****************************************************************/
{
TypUpsVmShort scale;
TypUpsVmShort sign;
TypUpsVmUnsignedLong Hi32;
TypUpsVmUnsignedLong Lo64;
} TypUpsComDecimal;

/****************************************************************/
typedef struct  typupscomsafearray
/* Objet : SAFEARRAY.                                           */
/****************************************************************/
{
TypUpsVmUnsignedShort cDims;
TypUpsVmUnsignedShort fFeatures;
TypUpsVmUnsignedLong cbElements;
TypUpsVmUnsignedLong cLocks;
TypUpsVmPointeurDonnees pvData;
TypUpsComSafeArrayBound rgsabound[1];
} TypUpsComSafeArray;

/****************************************************************/
typedef struct typupscomvariant
/* Objet : VARIANT.                                             */
/****************************************************************/
{
TypUpsVmUnsignedShort vt;
TypUpsVmUnsignedShort Reserve1;
TypUpsVmUnsignedShort Reserve2;
TypUpsVmUnsignedShort Reserve3;
union 
   {
   TypUpsVmUnsignedChar bVal;
   TypUpsVmLong iVal;
   TypUpsVmLong lVal;
   TypUpsVmDouble fltVal;
   TypUpsVmDouble dblVal;
   TypUpsVmShort boolVal;
   TypUpsVmLong scode;
   TypUpsVmLong cyVal;
   TypUpsVmDouble date;
   TypUpsComBStr bstrVal;
   TypUpsComDecimal *pdecVal;
   TypUpsVmPointeurDonnees punkVal;
   TypUpsVmPointeurDonnees pdispVal;
   TypUpsComSafeArray *parray;
   TypUpsVmUnsignedChar *pbVal;
   TypUpsVmShort *piVal;
   TypUpsVmLong *plVal;
   TypUpsVmDouble *pfltVal;
   TypUpsVmDouble *pdblVal;
   TypUpsVmShort *pboolVal;
   TypUpsVmLong *pscode;
   TypUpsVmLong *pcyVal;
   TypUpsVmDouble *pdate;
   TypUpsComBStr *pbstrVal;
   TypUpsVmPointeurDonnees *ppunkVal;
   TypUpsVmPointeurDonnees *ppdispVal;
   TypUpsComSafeArray **pparray;
   struct typupscomvariant *pvarVal;
   TypUpsVmPointeurDonnees byref;
   TypUpsVmChar cVal;
   TypUpsVmUnsignedShort uiVal;
   TypUpsVmUnsignedLong ulVal;
   TypUpsVmLong intVal;
   TypUpsVmUnsignedLong uintVal;
   TypUpsVmChar *pcVal;
   TypUpsVmUnsignedShort *puiVal;
   TypUpsVmUnsignedLong *pulVal;
   TypUpsVmLong *pintVal;
   TypUpsVmLong *puintVal;
   } u;
} TypUpsComVariant;

/****************************************************************/
typedef struct typupscomdispparams
/* Objet : DISPPARAMS.                                          */
/****************************************************************/
{
TypUpsComVariant *TableParametres;
   /* Table des parametres. */
TypUpsVmLong *TableIdentifiants;
   /* Table des identifiants des parametres. */
TypUpsVmUnsignedShort NbParametres;
   /* Nombre de parametres dans la table. */
TypUpsVmUnsignedShort NbIdentifiants;
   /* Nombre d'identifiants dans la table. */
} TypUpsComDispParams;

/****************************************************************/
typedef struct  typupscomparamdescriptionex
/* Objet : PARAMDESCEX.                                         */
/****************************************************************/
{
TypUpsVmUnsignedLong cBytes;
TypUpsComVariantArg varDefaultValue;
} TypUpsComParamDescriptionEx;

/****************************************************************/
typedef struct  typupscomparamdescription
/* Objet : PARAMDESC.                                           */
/****************************************************************/
{
TypUpsComParamDescriptionEx *pparamdescex;
TypUpsVmUnsignedShort wParamFlags;
} TypUpsComParamDescription;

/****************************************************************/
typedef struct typupscomelemdescription
/* Objet : ELEMDESC.                                            */
/****************************************************************/
{
TypUpsComTypeDescription tdesc;
TypUpsComParamDescription paramdesc;
} TypUpsComElemDescription;

/****************************************************************/
typedef struct typupscomvardescription
/* Objet : VARDESC.                                             */
/****************************************************************/
{
TypUpsVmUnsignedShort wVarFlags;
TypUpsVmLong memid;
TypUpsComElemDescription elemdescVar;
enum EnuUpsComVarKind varkind;
} TypUpsComVarDescription;
 
/****************************************************************/
typedef struct typupscomfuncdescription
/* Objet : FUNCDESC.                                            */
/****************************************************************/
{
TypUpsVmLong memid;
TypUpsVmLong wFuncFlags;
enum EnuUpsComInvokeKind invkind;
enum EnuUpsComCallConv callconv;
TypUpsVmShort cParams;
TypUpsComElemDescription *lprgelemdescParam;
TypUpsComElemDescription elemdescFunc;
enum EnuUpsComFuncKind funckind;
} TypUpsComFuncDescription;

/****************************************************************/
typedef struct typupscominformations
/* Objet : Informations sur un objet Up ! Virtual Technical     */
/* Machine.                                                     */
/****************************************************************/
{
TypUpsVmAdresse AdresseObjet;
   /* Adresse de l'objet. */
TypUpsVmPointeurDonnees pIProvideClassInfo2;
   /* Objet ProvideClassInfo2. */
TypUpsVmPointeurDonnees pIPersistFile;
   /* Objet PersistFile. */
TypUpsVmPointeurDonnees pIPersistMemory;
   /* Objet PersistMemory. */
TypUpsVmPointeurDonnees pIPersistPropertyBag;
   /* Objet PersistPropertyBag. */
TypUpsVmPointeurDonnees pIPersistStorage;
   /* Objet PersistStorage. */
TypUpsVmPointeurDonnees pIPersistStream;
   /* Objet PersistStream. */
TypUpsVmPointeurDonnees pIPersistStreamInit;
   /* Objet PersistStreamInit. */
TypUpsVmLong CompteurUsage;
   /* Pour decompter l'usage de l'objet. */
TypUpsVmPointeurDonnees pITypeLib; 
   /* Description de la classe utilisant l'IDL compilee. */
TypUpsVmPointeurDonnees pITypeInfo; 
   /* Description de la classe utilisant l'IDL compilee. */
TypUpsComRefIId RefIId;
   /* Reference sur l'interface de l'objet. */
} TypUpsComInformations;

/****************************************************************/
typedef struct typupscomexcepInfo
/* Objet : Exception envoyee par une methode Com.              */
/****************************************************************/
{
TypUpsVmUnsignedShort CodeErreur;
   /* Code erreur de l'exception. */
TypUpsVmUnsignedShort Reserve;
   /* Inutile.*/
TypUpsComBStr Source;
   /* Source de l'exception. */
TypUpsComBStr Description;
   /* Description de l'exception. */
TypUpsComBStr AideEnLigne;
   /* Aide sur l'exception. */
TypUpsVmUnsignedLong RubriqueAideContextuelle;
   /* Rubrique d'aide sur l'exception. */
TypUpsVmPointeurDonnees Reserve2;
   /* Inutile. */
TypUpsVmPointeurTraitements Reserve3;
   /* Inutile. */
TypUpsVmLong CodeErreur2;
   /* Code erreur de l'exception. */
} TypUpsComExcepInfo;

/****************************************************************/
typedef struct typupscomnattablemethodesrappel
/* Objet: Methodes de rappel vers Ups Com.                      */
/****************************************************************/
{
/*--------------------------------------------------------------*/
/* IPersist.                        							       */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*PersistGetClassID)(TypUpsVmPointeurDonnees This, TypUpsComRefIId pClassID);
   /* Objet : IPersist::GetClassID. */
/*--------------------------------------------------------------*/
/* IPersistFile.                      							       */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*PersistFileLoad)(TypUpsVmPointeurDonnees This, TypUpsComBStr NomFichier, TypUpsVmShort Mode);
   /* Objet : IPersistFile::Load. */
TypUpsVmShort UpsVmAPI (*PersistFileSave)(TypUpsVmPointeurDonnees This, TypUpsComBStr NomFichier, TypUpsVmShort fRemember);
   /* Objet : IPersistFile::Save. */
TypUpsVmShort UpsVmAPI (*PersistFileSaveCompleted)(TypUpsVmPointeurDonnees This, TypUpsComBStr NomFichier);
   /* Objet : IPersistFile::SaveCompleted. */
TypUpsVmShort UpsVmAPI (*PersistFileGetCurFile)(TypUpsVmPointeurDonnees This, TypUpsComBStr *NomFichier);
   /* Objet : IPersistFile::GetCurFile. */
/*--------------------------------------------------------------*/
/* IPersistMemory.                  							       */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*PersistMemoryGetSizeMax)(TypUpsVmPointeurDonnees This, TypUpsVmLong *Taille);
   /* Objet : IPersistMemory::GetSizeMax. */
TypUpsVmShort UpsVmAPI (*PersistMemoryInitNew)(TypUpsVmPointeurDonnees This);
   /* Objet : IPersistMemory::InitNew. */
TypUpsVmShort UpsVmAPI (*PersistMemoryLoad)(TypUpsVmPointeurDonnees This, void *ZoneMemoire, TypUpsVmLong Taille);
   /* Objet : IPersistMemory::Load. */
TypUpsVmShort UpsVmAPI (*PersistMemorySave)(TypUpsVmPointeurDonnees This, void *ZoneMemoire, TypUpsVmLong Taille);
   /* Objet : IPersistStorage::Save. */
/*--------------------------------------------------------------*/
/* IPersistStorage.                  							       */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*PersistStorageInitNew)(TypUpsVmPointeurDonnees This, TypUpsVmPointeurDonnees pStorage);
   /* Initialise l'objet. */        
TypUpsVmShort UpsVmAPI (*PersistStorageLoad)(TypUpsVmPointeurDonnees This, TypUpsVmPointeurDonnees pStorage);
   /* Chargement de l'objet. */        
TypUpsVmShort UpsVmAPI (*PersistStorageSave)(TypUpsVmPointeurDonnees This, TypUpsVmPointeurDonnees pStorage);
   /* Enregistrement de l'objet. */        
TypUpsVmShort UpsVmAPI (*PersistStorageSaveCompleted)(TypUpsVmPointeurDonnees This, TypUpsVmPointeurDonnees pStorage);
   /* Enregistrement de l'objet dans le fichier. */        
TypUpsVmShort UpsVmAPI (*PersistStorageHandsOffStorage)(TypUpsVmPointeurDonnees This);
   /* Termine la sauvegarde. */        
/*--------------------------------------------------------------*/
/* IPersistStream.                  							       */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*PersistStreamLoad)(TypUpsVmPointeurDonnees This);
   /* Objet : IPersistStream::Load. */
TypUpsVmShort UpsVmAPI (*PersistStreamSave)(TypUpsVmPointeurDonnees This, TypUpsVmShort fClearDirty);
   /* Objet : IPersistStream::Save. */
/*--------------------------------------------------------------*/
/* IPersistStreamInit.                							       */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*PersistStreamInitInitNew)(TypUpsVmPointeurDonnees This);
   /* Objet : IPersistStreamInit::InitNew. */
TypUpsVmShort UpsVmAPI (*PersistStreamInitLoad)(TypUpsVmPointeurDonnees This, TypUpsVmPointeurDonnees pIStream);
   /* Objet : IPersistStreamInit::Load. */
TypUpsVmShort UpsVmAPI (*PersistStreamInitSave)(TypUpsVmPointeurDonnees This, TypUpsVmPointeurDonnees pIStream, TypUpsVmShort fClearDirty);
   /* Objet : IPersistStreamInit::Save. */
/*--------------------------------------------------------------*/
/* IProvideClassInfo2.               							       */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*ProvideClassInfo2GetClassInfo)(TypUpsVmPointeurDonnees This, TypUpsVmPointeurDonnees *pITypeInfo);
   /* Objet : IProvideClassInfo2::GetClassInfo. */
TypUpsVmShort UpsVmAPI (*ProvideClassInfo2GetGUID)(TypUpsVmPointeurDonnees This, TypUpsComRefIId pGUID);
   /* Objet : IProvideClassInfo2::GetGUID. */
/*--------------------------------------------------------------*/
/* IStream.                         							       */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*StreamRelease)(TypUpsVmPointeurDonnees This, TypUpsVmPointeurDonnees Descripteur);
   /* Objet : IStream::Release. */
TypUpsVmShort UpsVmAPI (*StreamRead)(TypUpsVmPointeurDonnees This, TypUpsVmPointeurDonnees Descripteur, TypUpsVmChar *Buffer, 
   TypUpsVmLong TailleDemandee, TypUpsVmLong *TailleLue);
   /* Objet : IStream::Read. */
TypUpsVmShort UpsVmAPI (*StreamWrite)(TypUpsVmPointeurDonnees This, TypUpsVmPointeurDonnees Descripteur, TypUpsVmChar *Buffer, 
   TypUpsVmLong TailleDemandee, TypUpsVmLong *TailleEcrite);
   /* Objet : IStream::Ecrite. */
TypUpsVmShort UpsVmAPI (*StreamSeek)(TypUpsVmPointeurDonnees This, TypUpsVmPointeurDonnees Descripteur, TypUpsVmLong Deplacement, enum EnuUpsComStreamSeek Origine,
   TypUpsVmLong *NouvellePosition);
   /* Objet : IStream::Seek. */
TypUpsVmShort UpsVmAPI (*StreamCopyTo)(TypUpsVmPointeurDonnees This, TypUpsVmPointeurDonnees Descripteur, TypUpsVmPointeurDonnees pIStream, TypUpsVmLong TailleDemandee, 
   TypUpsVmLong *TailleLue2, TypUpsVmLong *TailleEcrite2);
   /* Objet : IStream::CopyTo. */
TypUpsVmVoid UpsVmAPI (*StreamStat)(TypUpsVmPointeurDonnees This, TypUpsComBStr *NomFichier2, TypUpsVmUnicode *NomFichier);
   /* Objet : IStream::Stat. */
TypUpsVmShort UpsVmAPI (*StreamClone)(TypUpsVmPointeurDonnees This, TypUpsVmUnicode *NomFichier, TypUpsVmUnicode *ModeOuverture, TypUpsVmPointeurDonnees Descripteur, TypUpsVmPointeurDonnees *pIStream);
   /* Objet : IStream::Clone. */
/*--------------------------------------------------------------*/
/* Exportation d'un objet C.          							       */
/*--------------------------------------------------------------*/
TypUpsVmVoid UpsVmAPI (*ExporterBinaire2)(TypUpsVmPointeurDonnees Session, TypUpsVmLong Taille, TypUpsVmChar *Buffer);
   /* Objet : Exporte un binaire sans la taille en prefixe. */
TypUpsVmVoid UpsVmAPI (*ExporterEntier)(TypUpsVmPointeurDonnees Session, TypUpsVmLong Entier);
   /* Objet : Exporte un entier. */
TypUpsVmVoid UpsVmAPI (*ExporterReel)(TypUpsVmPointeurDonnees Session, TypUpsVmDouble Reel);
   /* Objet : Exporte un reel. */
/*--------------------------------------------------------------*/
/* Importation d'un objet C.          							       */
/*--------------------------------------------------------------*/
TypUpsVmLong UpsVmAPI (*ImporterEntier)(TypUpsVmPointeurDonnees Session);
   /* Objet : Importe un entier. */
TypUpsVmDouble UpsVmAPI (*ImporterReel)(TypUpsVmPointeurDonnees Session);
   /* Objet : Importe un reel. */
TypUpsVmVoid UpsVmAPI (*ImporterBinaire)(TypUpsVmPointeurDonnees Session, TypUpsVmChar *Buffer, TypUpsVmLong Taille);
   /* Objet : Importe un binaire. */
} *TypUpsComNatTableMethodesRappel;

/****************************************************************/
typedef struct typupscomnattraitements_1_1_0
/* Objet: Interface des traitements de Ups Com Nat.             */
/****************************************************************/
{
/*--------------------------------------------------------------*/
/* Identifiant d'interfaces standard. 							       */
/*--------------------------------------------------------------*/
TypUpsComRefIId UpsVmAPI (*GUID_NULL)(TypUpsVmVoid);
   /* Objet : GUID_NULL(). */
TypUpsComRefIId UpsVmAPI (*IID_IClassFactory)(TypUpsVmVoid);
   /* Objet : IID_IClassFactory(). */
TypUpsComRefIId UpsVmAPI (*IID_IDispatch)(TypUpsVmVoid);
   /* Objet : IID_IDispatch(). */
TypUpsComRefIId UpsVmAPI (*IID_IErrorInfo)(TypUpsVmVoid);
   /* Objet : IID_IErrorInfo(). */
TypUpsComRefIId UpsVmAPI (*IID_IPersist)(TypUpsVmVoid);
   /* Objet : IID_IPersist(). */
TypUpsComRefIId UpsVmAPI (*IID_IPersistFile)(TypUpsVmVoid);
   /* Objet : IID_IPersistFile(). */
TypUpsComRefIId UpsVmAPI (*IID_IPersistMemory)(TypUpsVmVoid);
   /* Objet : IID_IPersistMemory(). */
TypUpsComRefIId UpsVmAPI (*IID_IPersistStorage)(TypUpsVmVoid);
   /* Objet : IID_IPersistStorage(). */
TypUpsComRefIId UpsVmAPI (*IID_IPersistStream)(TypUpsVmVoid);
   /* Objet : IID_IPersistStream(). */
TypUpsComRefIId UpsVmAPI (*IID_IPersistStreamInit)(TypUpsVmVoid);
   /* Objet : IID_IPersistStreamInit(). */
TypUpsComRefIId UpsVmAPI (*IID_IProvideClassInfo)(TypUpsVmVoid);
   /* Objet : IID_IProvideClassInfo(). */
TypUpsComRefIId UpsVmAPI (*IID_IProvideClassInfo2)(TypUpsVmVoid);
   /* Objet : IID_IProvideClassInfo2(void). */
TypUpsComRefIId UpsVmAPI (*IID_IStream)(TypUpsVmVoid);
   /* Objet : IID_IStream(). */
TypUpsComRefIId UpsVmAPI (*IID_ITypeInfo)(TypUpsVmVoid);
   /* Objet : IID_ITypeInfo(). */
TypUpsComRefIId UpsVmAPI (*IID_IUnknown)(TypUpsVmVoid);
   /* Objet : IID_IUnknown(). */
/*--------------------------------------------------------------*/
/* Application Program Interfaces.   							       */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*AllouerUnTableau)(enum EnuUpsComObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC, TypUpsVmLong *TableDimensions, TypUpsVmShort NbDimensions, 
   TypUpsVmLong BorneMin, TypUpsVmLong BorneMax, enum EnuUpsVmTypeDeDonnee TypeObjetUps);
   /* Objet : Allocation d'un tableau. */
TypUpsVmPointeurDonnees UpsVmAPI (*ClonerObjetC)(enum EnuUpsComObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC, TypUpsVmPointeurDonnees ObjetC2);
   /* Objet : Clonage d'un objet C. */
TypUpsVmShort UpsVmAPI (*CoCreateGuid)(TypUpsComIId *Guid);
   /* Objet : CoCreateGuid(). */
TypUpsVmShort UpsVmAPI (*CoCreateInstance)(TypUpsComIId *ClasseId, TypUpsComIId *IId, TypUpsVmPointeurDonnees *Implementation);
   /* Objet : CoCreateInstance(). */
TypUpsVmShort UpsVmAPI (*CoDisconnectObject)(TypUpsVmPointeurDonnees pIUnknown);
   /* Objet : CoDisconnectObject(). */
TypUpsVmShort UpsVmAPI (*CoFileTimeNow)(TypUpsVmDateEtHeure *DateEtHeure);
   /* Objet : CoFileTimeNow(). */
TypUpsVmShort UpsVmAPI (*CoGetClassObject)(TypUpsComRefIId IIdClasse, TypUpsComRefIId IId, TypUpsVmPointeurDonnees *Classe);
   /* Objet : CoGetClassObject(). */
TypUpsVmShort UpsVmAPI (*CoInitializeEx)(TypUpsVmVoid);
   /* Objet : CoInitializeEx(). */
TypUpsVmShort UpsVmAPI (*CoLockObjectExternal)(TypUpsVmPointeurDonnees pIUnknown, TypUpsVmShort Verrouiller);
   /* Objet : CoLockObjectExternal(). */
TypUpsVmPointeurDonnees UpsVmAPI (*ConstruireClassFactory)(TypUpsComRefIId IId, TypUpsComRefIId ClsId, TypUpsVmPointeurDonnees ObjetClasse,
   TypUpsVmUnsignedLong **IdentifiantClassFactory, TypUpsVmPointeurDonnees *AdresseClassFactory);
   /* Objet : Constructeur de ClassFactory. */
TypUpsVmPointeurDonnees UpsVmAPI (*ConstruireObjetC)(enum EnuUpsComObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC, TypUpsVmShort NbDimensions);
   /* Objet : Constructeur d'un objet C. */
TypUpsVmShort UpsVmAPI (*CoRegisterClassObject)(TypUpsComRefIId ClsId, TypUpsVmPointeurDonnees pIUnknown, TypUpsVmShort EstServeur, 
   TypUpsVmUnsignedLong *Identifiant, TypUpsVmShort EstDisponible);
   /* Objet : CoRegisterClass(). */
TypUpsVmShort UpsVmAPI (*CoResumeClassObjects)(TypUpsVmVoid);
   /* Objet : CoResumeClassObjects(). */
TypUpsVmShort UpsVmAPI (*CoRevokeClassObject)(TypUpsVmUnsignedLong Identifiant);
   /* Objet : CoRevokeClassObject(). */
TypUpsVmShort UpsVmAPI (*CoSuspendClassObjects)(TypUpsVmVoid);
   /* Objet : CoSuspendClassObjects(). */
TypUpsVmPointeurDonnees UpsVmAPI (*CoTaskMemAlloc)(TypUpsVmLong Taille);
   /* Objet : CoTaskMemAlloc(). */
TypUpsVmVoid UpsVmAPI (*CoTaskMemFree)(TypUpsVmPointeurDonnees Buffer);
   /* Objet : CoTaskMemFree(). */
TypUpsVmPointeurDonnees UpsVmAPI (*CoTaskMemRealloc)(TypUpsVmPointeurDonnees Buffer, TypUpsVmLong Taille);
   /* Objet : CoTaskMemRealloc(). */
TypUpsVmVoid UpsVmAPI (*CoUninitialize)(TypUpsVmVoid);
   /* Objet : CoUninitialize(). */
TypUpsVmShort UpsVmAPI (*CreateErrorInfo)(TypUpsVmPointeurDonnees *pICreateErrorInfo);
   /* Objet : CreateErrorInfo(). */
TypUpsVmShort UpsVmAPI (*CreerUnObjet)(TypUpsVmPointeurDonnees This, TypUpsComInformations *Informations);
   /* Objet : Cree un nouvel objet. */
TypUpsVmPointeurDonnees UpsVmAPI (*CreerUnStream)(TypUpsVmUnicode **NomFichier, TypUpsVmUnicode **ModeOuverture,
   TypUpsVmPointeurDonnees Descripteur);
   /* Objet : Creation d'un nouveau Stream. */
TypUpsVmVoid UpsVmAPI (*DetruireObjetC)(enum EnuUpsComObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC, TypUpsVmShort Reallouer);
   /* Objet : Destructeur d'un objet C. */
TypUpsVmVoid UpsVmAPI (*DetruireUnObjet)(TypUpsComInformations *Informations);
   /* Objet : Detruit un objet. */
TypUpsVmVoid UpsVmAPI (*DetruireUnStream)(TypUpsVmPointeurDonnees pIStream);
   /* Objet : Detruit un stream. */
TypUpsVmShort UpsVmAPI (*DispGetIDsOfNames)(TypUpsVmPointeurDonnees pITypeInfo, TypUpsComBStr *TableNoms, TypUpsVmShort TailleTable, TypUpsVmLong *TableIdentifiants);
   /* Objet : DispGetIDsOfNames(). */
TypUpsVmShort UpsVmAPI (*DispInvoke)(TypUpsVmPointeurDonnees This, TypUpsVmPointeurDonnees pITypeInfo, TypUpsVmLong Identifiant, TypUpsVmLong Options, 
   TypUpsComDispParams *Parametres, TypUpsVmPointeurDonnees Resultat, TypUpsComExcepInfo *InformationException, 
   TypUpsVmLong *ParametreEnErreur);
   /* Objet : DispInvoke(). */
TypUpsVmShort UpsVmAPI (*DllRegister)(TypUpsVmChar *NomBibliotheque, enum EnuUpsComDllRegister *CodeErreur);
   /* Objet : DllRegister. */
TypUpsVmShort UpsVmAPI (*DllUnregister)(TypUpsVmChar *NomBibliotheque, enum EnuUpsComDllRegister *CodeErreur);
   /* Objet : DllUnregister. */
TypUpsVmShort UpsVmAPI (*EcrireObjetC)(enum EnuUpsVmTypeDeDonnee TypeObjetUps, TypUpsVmPointeurDonnees ObjetUps, enum EnuUpsComObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC,
   TypUpsVmLong *TableDimensions, TypUpsVmShort NbDimensions);
   /* Objet : Ecriture d'un objet C. */
TypUpsVmShort (*EstUnTableau)(enum EnuUpsComObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC, TypUpsVmLong *TableDimensions, TypUpsVmShort NbDimensions, 
   TypUpsVmShort *EstNul, TypUpsVmLong *BorneMin, TypUpsVmLong *BorneMax, enum EnuUpsComObjetC *TypeObjetElementC, enum EnuUpsVmTypeDeDonnee *TypeObjetElementUps);
   /* Objet : Verifie si l'objet C est un tableau. */
TypUpsVmVoid UpsVmAPI (*ExporterObjetC)(TypUpsVmPointeurDonnees Session, enum EnuUpsComObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC);
   /* Objet : Exportation d'un objet C. */
TypUpsVmPointeurDonnees UpsVmAPI (*ImporterObjetC)(TypUpsVmPointeurDonnees Session, enum EnuUpsComObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC);
   /* Objet : Importation d'un objet C. */
TypUpsVmShort UpsVmAPI (*IsEqualIID)(TypUpsComRefIId RefIId1, TypUpsComRefIId RefIId2);
   /* Objet : IsEqualIID(). */
TypUpsVmLong UpsVmAPI (*LireIdentifiantClassFactory)(TypUpsVmPointeurDonnees pClassFactory);
   /* Objet : Lit l'identifiant de class factory. */
TypUpsVmShort UpsVmAPI (*LireObjetC)(enum EnuUpsComObjetC TypeObjetC, TypUpsVmPointeurDonnees ObjetC, 
   TypUpsVmLong *TableDimensions, TypUpsVmShort NbDimensions, enum EnuUpsVmTypeDeDonnee *TypeObjetUps, TypUpsVmPointeurDonnees ObjetUps);
   /* Objet : Lecture d'un objet C. */
TypUpsVmShort UpsVmAPI (*LoadTypeLib)(TypUpsComOleChar *NomFichier, TypUpsVmPointeurDonnees *pITypeLib);
   /* Objet : LoadTypeLib(). */
TypUpsVmShort UpsVmAPI (*OleLoadFromStream)(TypUpsVmPointeurDonnees pIStream, TypUpsComRefIId IdentifiantInterface, TypUpsVmPointeurDonnees *Objet);
   /* Objet : OleLoadFromStream(). */
TypUpsVmShort UpsVmAPI (*OleSaveToStream)(TypUpsVmPointeurDonnees pIPersistStream, TypUpsVmPointeurDonnees pIStream);
   /* Objet : OleSaveToStream(). */
TypUpsVmShort UpsVmAPI (*QueryInterface)(TypUpsVmPointeurDonnees pObjetObjet, TypUpsComRefIId RefIId, TypUpsVmPointeurDonnees *pObjet,
   TypUpsComInformations *Informations, TypUpsComRefIId RefIIdObjet);
   /* Objet : Objet::QueryInterface. */
TypUpsVmShort UpsVmAPI (*RegisterActiveObject)(TypUpsVmPointeurDonnees pIUnknown, TypUpsComRefIId RefIId, TypUpsVmUnsignedLong *Identifiant);
   /* Objet : RegisterActiveObject(). */
TypUpsVmShort UpsVmAPI (*RegisterTypeLib)(TypUpsVmPointeurDonnees pITypeLib, TypUpsComBStr NomFichier, TypUpsComBStr NomFichierAide);
   /* Objet : RegisterTypeLib(). */
TypUpsVmShort UpsVmAPI (*RevokeActiveObject)(TypUpsVmUnsignedLong Identifiant);
   /* Objet : RevokeActiveObject(). */
TypUpsComSafeArray UpsVmAPI *(*SafeArrayCreate)(TypUpsVmShort TypeDeDonnees, TypUpsVmLong Taille);
   /* Objet : SafeArrayCreate(). */
TypUpsVmVoid UpsVmAPI (*SafeArrayDestroy)(TypUpsComSafeArray *Tableau);
   /* Objet : SafeArrayDestroy(). */
TypUpsVmShort UpsVmAPI (*SafeArrayGetElement)(TypUpsComSafeArray *Tableau, TypUpsVmLong Index, TypUpsComVariant *Element);
   /* Objet : SafeArrayGetElement(). */
TypUpsVmShort UpsVmAPI (*SafeArrayGetUBound)(TypUpsComSafeArray *Tableau, TypUpsVmLong *Taille);
   /* Objet : SafeArrayGetBound(). */
TypUpsVmShort UpsVmAPI (*SafeArrayPutElement)(TypUpsComSafeArray *Tableau, TypUpsVmLong Index, TypUpsComVariant *Element);
   /* Objet : SafeArrayPutElement(). */
TypUpsVmShort UpsVmAPI (*SetErrorInfo)(TypUpsVmPointeurDonnees pIErrorInfo);
   /* Objet : SetErrorInfo(). */
TypUpsVmVoid UpsVmAPI (*SetTableMethodesRappel)(TypUpsComNatTableMethodesRappel TableMethodesRappel2);
   /* Objet : Memorise la table de methodes de rappel vers Ups Com. */
TypUpsComBStr UpsVmAPI (*SysAllocString)(TypUpsComOleChar *S); 
   /* Objet : SysAllocString(). */
TypUpsComBStr UpsVmAPI (*SysAllocStringByteLen)(TypUpsVmLong Taille); 
   /* Objet : SysAllocStringByteLen(). */
TypUpsVmVoid UpsVmAPI (*SysFreeString)(TypUpsComBStr S); 
   /* Objet : SysFreeString(). */
TypUpsVmShort UpsVmAPI (*UnRegisterTypeLib)(TypUpsComRefIId RefIID, TypUpsVmShort Version, TypUpsVmShort Revision);
   /* Objet : UnRegisterTypeLib(). */  
/*--------------------------------------------------------------*/
/* IClassFactory.                    							       */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*ClassFactoryCreateInstance)(TypUpsVmPointeurDonnees pIClassFactory, TypUpsComRefIId RefIId, TypUpsVmPointeurDonnees *pObjet);
   /* Objet : IClassFactory::CreateInstance(). */
/*--------------------------------------------------------------*/
/* IDispatch.                       							       */
/*--------------------------------------------------------------*/
TypUpsVmShort (*DispatchInvoke)(TypUpsVmPointeurDonnees pIDispatch, TypUpsVmShort Identifiant, TypUpsVmShort SorteAppel, 
   TypUpsVmPointeurDonnees DispParams, TypUpsVmPointeurDonnees VariantResultat, TypUpsVmUnicode **MotCleErreur, 
   TypUpsVmShort *NumeroParametreEnErreur);
   /* Objet : IDispatch::Invoke. */
/*--------------------------------------------------------------*/
/* ICreateErrorInfo.                 							       */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*CreateErrorInfoSetDescription)(TypUpsVmPointeurDonnees CreateErrorInfo, TypUpsComBStr Description);
   /* Objet : ICreateErrorInfo::SetDescription(). */
TypUpsVmShort UpsVmAPI (*CreateErrorInfoSetGUID)(TypUpsVmPointeurDonnees CreateErrorInfo, TypUpsComRefIId RefIID);
   /* Objet : ICreateErrorInfo::SetGUID(). */
/*--------------------------------------------------------------*/
/* IStorage.                         							       */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*StorageCreateStream)(TypUpsVmPointeurDonnees Storage, TypUpsComBStr NomFichier, TypUpsVmPointeurDonnees *Stream);
   /* Objet : IStorage::CreateStream(). */
TypUpsVmShort UpsVmAPI (*StorageOpenStream)(TypUpsVmPointeurDonnees Storage, TypUpsComBStr NomFichier, TypUpsVmPointeurDonnees *Stream);
   /* Objet : IStorage::OpenStream(). */
/*--------------------------------------------------------------*/
/* IStream.                         							       */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*StreamRead)(TypUpsVmPointeurDonnees Stream, TypUpsVmChar *Buffer, TypUpsVmLong TailleBufferDemandee, 
   TypUpsVmLong *TailleBufferLue);
   /* Objet : IStream::Read(). */
TypUpsVmShort UpsVmAPI (*StreamSeek)(TypUpsVmPointeurDonnees Stream, TypUpsVmLong Deplacement, enum EnuUpsComStreamSeek Origine);
   /* Objet : IStream::Seek(). */
TypUpsVmShort UpsVmAPI (*StreamWrite)(TypUpsVmPointeurDonnees Stream, TypUpsVmChar *Buffer, TypUpsVmLong TailleBufferDemandee, 
   TypUpsVmLong *TailleBufferEcrite);
   /* Objet : IStream::Write(). */
/*--------------------------------------------------------------*/
/* ITypeInfo.                        							       */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*TypeInfoGetDllEntry)(TypUpsVmPointeurDonnees TypeInfo, TypUpsVmShort Numero, TypUpsComBStr *NomDll, TypUpsVmUnsignedShort *NumeroPointEntree);
   /* Objet : ITypeInfo::GetDllEntry(). */
TypUpsVmShort UpsVmAPI (*TypeInfoGetDocumentation)(TypUpsVmPointeurDonnees TypeLib, TypUpsVmShort Numero, TypUpsComBStr *NomElement,
   TypUpsComBStr *ChaineAide, TypUpsVmUnsignedLong *NumeroAide, TypUpsComBStr *FichierAide);
   /* Objet : ITypeInfo::GetDocumentation(). */
TypUpsVmShort UpsVmAPI (*TypeInfoGetFuncDesc)(TypUpsVmPointeurDonnees TypeInfo, TypUpsVmShort Numero, TypUpsComFuncDescription *Description);
   /* Objet : ITypeInfo::GetFuncDesc(). */
TypUpsVmShort UpsVmAPI (*TypeInfoGetImplTypeFlags)(TypUpsVmPointeurDonnees TypeInfo, TypUpsVmShort NumeroClasseImplementee, TypUpsVmLong *Flags);
   /* Objet : ITypeInfo::GetImplTypeFlags(). */
TypUpsVmShort UpsVmAPI (*TypeInfoGetNames)(TypUpsVmPointeurDonnees TypeInfo, TypUpsVmShort Numero, TypUpsComOleChar **TableNoms, TypUpsVmShort Taille, TypUpsVmShort *NbParametresLus);
   /* Objet : ITypeInfo::GetNames(). */
TypUpsVmShort UpsVmAPI (*TypeInfoGetRefTypeInfo)(TypUpsVmPointeurDonnees TypeInfo, TypUpsVmLong hreftype, TypUpsVmPointeurDonnees *TypeInfoUtilisateur);
   /* Objet : ITypeInfo::GetRefTypeInfo(). */
TypUpsVmShort UpsVmAPI (*TypeInfoGetRefTypeOfImplType)(TypUpsVmPointeurDonnees TypeInfo, TypUpsVmLong NumeroClasseImplementee, TypUpsVmLong *ReferenceType);
   /* Objet : ITypeInfo::GetRefTypeOfImplType(). */
TypUpsVmShort UpsVmAPI (*TypeInfoGetTypeAttr)(TypUpsVmPointeurDonnees TypeInfo, TypUpsComTypeAttributs *TypeAttributs);
   /* Objet : ITypeInfo::GetTypeAttr(). */
TypUpsVmShort UpsVmAPI (*TypeInfoGetVarDesc)(TypUpsVmPointeurDonnees TypeInfo, TypUpsVmShort Numero, TypUpsComVarDescription *Description);
   /* Objet : ITypeInfo::GetVarDesc(). */
TypUpsVmVoid UpsVmAPI (*TypeInfoReleaseFuncDesc)(TypUpsVmPointeurDonnees TypeInfo, TypUpsComFuncDescription *Description);
   /* Objet : ITypeInfo::ReleaseFuncDesc(). */
TypUpsVmVoid UpsVmAPI (*TypeInfoReleaseTypeAttr)(TypUpsVmPointeurDonnees TypeInfo, TypUpsComTypeAttributs *TypeAttributs);
   /* Objet : ITypeInfo::ReleaseTypeAttr(). */
TypUpsVmVoid UpsVmAPI (*TypeInfoReleaseVarDesc)(TypUpsVmPointeurDonnees TypeInfo, TypUpsComVarDescription *Description);
   /* Objet : ITypeInfo::ReleaseVarDesc(). */
/*--------------------------------------------------------------*/
/* ITypeLib.                                                    */
/*--------------------------------------------------------------*/
TypUpsVmShort UpsVmAPI (*TypeLibGetDocumentation)(TypUpsVmPointeurDonnees TypeLib, TypUpsVmShort Numero, TypUpsComBStr *NomElement,
   TypUpsComBStr *ChaineAide, TypUpsVmUnsignedLong *NumeroAide, TypUpsComBStr *FichierAide);
   /* Objet : ITypeInfo::GetDocumentation(). */
TypUpsVmShort UpsVmAPI (*TypeLibGetLibAttr)(TypUpsVmPointeurDonnees TypeLib, TypUpsComLibrairieAttributs *LibrairieAttributs);
   /* Objet : ITypeLib::GetLibAttr(). */
TypUpsVmShort UpsVmAPI (*TypeLibGetTypeInfo)(TypUpsVmPointeurDonnees TypeLib, TypUpsVmShort Numero, TypUpsVmPointeurDonnees *TypeInfo);
   /* Objet : ITypeLib::GetTypeInfo(). */
TypUpsVmShort UpsVmAPI (*TypeLibGetTypeInfoCount)(TypUpsVmPointeurDonnees TypeLib);
   /* Objet : ITypeInfo::GetTypeInfoCount(). */
TypUpsVmShort UpsVmAPI (*TypeLibGetTypeInfoOfGuid)(TypUpsVmPointeurDonnees TypeLib, TypUpsComRefIId RefIID, TypUpsVmPointeurDonnees *TypeInfo);
   /* Objet : ITypeLib::GetTypeInfoOfGuid(). */
TypUpsVmShort UpsVmAPI (*TypeLibGetTypeInfoType)(TypUpsVmPointeurDonnees TypeLib, TypUpsVmShort Numero, enum EnuUpsComTypeKind *Sorte);
   /* Objet : ITypeInfo::GetTypeInfoType(). */
/*--------------------------------------------------------------*/
/* IUnknown.                        							       */
/*--------------------------------------------------------------*/
TypUpsVmLong UpsVmAPI (*UnknownAddRef)(TypUpsVmPointeurDonnees ObjetObjet);
   /* Objet : IUnknown::AddRef(). */
TypUpsVmShort UpsVmAPI (*UnknownQueryInterface)(TypUpsVmPointeurDonnees ObjetObjet, TypUpsComRefIId RefIId, TypUpsVmPointeurDonnees *Objet);
   /* Objet : IUnknown::QueryInterface. */
TypUpsVmLong UpsVmAPI (*UnknownRelease)(TypUpsVmPointeurDonnees ObjetObjet);
   /* Objet : IUnknown::Release(). */
} *TypUpsComNatTraitements_1_1_0;

/*--------------------------------------------------------------*/
/* La version courante est la 1.1.0.                            */
/*--------------------------------------------------------------*/
typedef TypUpsComNatTraitements_1_1_0 TypUpsComNatTraitements;

extern DllExport TypUpsComNatTraitements UpsVmAPI UpsComNatDemarrerModule(TypUpsVtmMachineInterface MachineInterfaceUpsVtm);
   /* Objet : Retourne la description de Ups Com Nat. */

/**********************/
#if defined(__cplusplus)
/**********************/
}
/****/
#endif
/****/

/****/
#endif
/****/
